+/**
 * 
 * CanvasXpress 37.0 - JavaScript Canvas Library
 * 
 * Copyright (c) 2009-2021 - license@canvasxpress.org
 * 
 * Redistributions of the source code must retain this copyright
 * notice and the following disclaimer.
 *  
 * CanvasXpress is released as open source for personal and
 * educational use with dual licensing for comercial purposes.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * Please see a copy of the GNU General Public License at
 * http://www.gnu.org/licenses.
 * 
 * Commercial use may be granted to the extent that this source
 * code does NOT become part of any other Open Source or
 * Commercially licensed development library or toolkit without
 * explicit permission from CanvasXpress.
 * 
 */
/**
 * 
 * canvas.text.js
 * @projectDescription An cross-browser implementation of the HTML5 <canvas> text methods 
 * @author Fabien M�nager 
 * @version $Revision: 1.4 $ 
 * @license MIT License <http://www.opensource.org/licenses/mit-license.php> 
 * 
 * Known issues: 
 * - The 'light' font weight is not supported, neither is the 'oblique' font style. 
 * - Optimize the different hacks (for Opera9) 
 * 
 ****
 *
 * ngraph
 * 
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2019 Andrei Kashcha
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 ****
 * 
 * sprintf() for JavaScript v.0.4
 *
 * Copyright (c) 2007 Alexandru Marasteanu <http://alexei.417.ro/>
 * Thanks to David Baird (unit test and patch).
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 ***
 * 
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 *
 ****
 *
 * canvas_wrapper.js
 * Canvas doesn't support getCoords() which I really need....
 * So I made a wrapper, code mostly taken from excanvas.js by Google - http://code.google.com/p/explorercanvas/
 * alias some functions to make (compiled) code shorter
 *
 ****
 *
 * conrec.js
 * Copyright (c) 2010, Jason Davies.
 *
 * All rights reserved.  This code is based on Bradley White's Java version,
 * which is in turn based on Nicholas Yue's C++ version, which in turn is based
 * on Paul D. Bourke's original Fortran version.  See below for the respective
 * copyright notices.
 *
 * See http://paulbourke.net/papers/conrec for the original
 * paper by Paul D. Bourke.
 *
 * The vector conversion code is based on http://apptree.net/conrec.htm by
 * Graham Cox.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the <organization> nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * conrec.js
 * Copyright (c) 1996-1997 Nicholas Yue
 *
 * This software is copyrighted by Nicholas Yue. This code is based on Paul D.
 * Bourke's CONREC.F routine.
 *
 * The authors hereby grant permission to use, copy, and distribute this
 * software and its documentation for any purpose, provided that existing
 * copyright notices are retained in all copies and that this notice is
 * included verbatim in any distributions. Additionally, the authors grant
 * permission to modify this software and its documentation for any purpose,
 * provided that such modifications are not distributed without the explicit
 * consent of the authors and that existing copyright notices are retained in
 * all copies. Some of the algorithms implemented by this software are
 * patented, observe all applicable patent law.
 *
 * IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
 * EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS
 * PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 * 
 **** 
 *
 * jLouvain.js
 * Author: Corneliu S. (github.com/upphiminn)
 * This is a javascript implementation of the Louvain
 * community detection algorithm (http://arxiv.org/abs/0803.0476)
 * Based on https://bitbucket.org/taynaud/python-louvain/overview
 * 
 ****
 * 
 * science.js
 * Copyright (c) 2011, Jason Davies
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name Jason Davies may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL JASON DAVIES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 * 
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 * 
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 * 
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 *
 ****
 * 
 * FileSaver.js
 * Copyright © 2015 [Eli Grey][1].
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **** 
 * 
 * canvas-toBlob.js
 * Copyright © 2011 Eli Grey and Devin Samarin.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * Blob.js
 * Copyright © 2014 Eli Grey.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * jstat.js
 * Copyright (c) 2013 jStat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * numeric.js
 * Numeric Javascript
 * Copyright (C) 2011 by Sébastien Loisel
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * Sankey.js
 * Copyright (c) 2012, Michael Bostock
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * The name Michael Bostock may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****
 *
 * canvas2svg
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Gliffy Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
+(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{if(typeof define==="function"&&define.amd){define(["exports"],a)}else{(a((b.CanvasXpress=b.CanvasXpress||{})))}}}(this,(function(b){var c,a;if(this){c=this.window;a=this.document}CanvasXpress=function(j,f,e,o,d,k,g,n,m,i){var h=this;var l=function(){h.init(j,f,e,o,d,k,g,n,m,i)};if((e&&e.fonts)||(j&&j.config&&j.config.fonts)){if(e&&e.fonts){CanvasXpress.loadFonts(e.fonts,l)}else{CanvasXpress.loadFonts(j.config.fonts,l)}}else{if((e&&e.fontsExternal)||(j&&j.config&&j.config.fontsExternal)){if(e&&e.fontsExternal){CanvasXpress.loadFontsExternal(e.fontsExternal,l)}else{CanvasXpress.loadFontsExternal(j.config.fontsExternal,l)}}else{this.init(j,f,e,o,d,k,g,n,m,i)}}}})));CanvasXpress.instances=[];CanvasXpress.config=[];CanvasXpress.transitions={};CanvasXpress.cacheImages={};CanvasXpress.cacheImagesReady=false;CanvasXpress.cachePatterns={};CanvasXpress.cacheText={};CanvasXpress.fonts={Arial:true,Courier:true,Verdana:true};CanvasXpress.loadFonts=function(d,c){if(d&&d.length){var b=false;for(var a=0;a<d.length;a++){if(!CanvasXpress.fonts.hasOwnProperty(d[a])){b=true;break}}WebFontConfig={google:{families:d},timeout:2000};if(c){WebFontConfig.active=c}(function(h){if(window.navigator.onLine&&b){var e=h.createElement("script");var g=h.scripts[0];e.src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js";e.async=true;g.parentNode.insertBefore(e,g);for(var f=0;f<d.length;f++){CanvasXpress.fonts[d[f]]=true}}else{c()}})(document)}};CanvasXpress.loadFontsExternal=function(c,b){if(c&&c.length){var a=false;if(!CanvasXpress.fonts.hasOwnProperty(c[0].name)){a=true}(function(f){if(window.navigator.onLine&&a){var e=new XMLHttpRequest();e.addEventListener("readystatechange",function(g){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){var d=new FontFace(c[0].name,e.response);document.fonts.add(d);CanvasXpress.fonts[c[0].name]=true;b()}}}});e.responseType="arraybuffer";e.open("get",c[0].url);e.send()}else{b()}})(document)}};CanvasXpress.selector={vars:{},smps:{},meta:{},comp:{},nodes:{},edges:{},mixed:{},selections:0,graphType:false};CanvasXpress.stack={};CanvasXpress.current=false;CanvasXpress.chain={};CanvasXpress.resizing=false;CanvasXpress.registered="5F75F5478D18361F0114292F75861AB5728467904E9";CanvasXpress.system={};CanvasXpress.ready=false;CanvasXpress.factory={version:37,buildDate:"11-23-2021",client:"",siteSrc:false,valid:undefined,href:window.location.href};CanvasXpress.factory.services="https://www.canvasxpress.org/cgi-bin/services.pl";CanvasXpress.onReady=function(){var f=[];var a=false;var d=false;var c=function(){if(!a){console.log("canvasXpress JS ready");a=true;for(var g=0;g<f.length;g++){f[g].fn.call(window,f[g].ctx)}f=[];CanvasXpress.system.isHTMLWidgets=typeof HTMLWidgets!="undefined";CanvasXpress.system.isShiny=typeof window.Shiny!=="undefined"&&!!window.Shiny.outputBindings;CanvasXpress.system.isRViewer=/\bviewer_pane=1\b/.test(window.location);CanvasXpress.system.isRConsole=CanvasXpress.system.isHTMLWidgets&&!CanvasXpress.system.isShiny&&!CanvasXpress.system.isRViewer;CanvasXpress.system.isjQuery=typeof $==="function";CanvasXpress.system.isReveal=typeof Reveal!="undefined";CanvasXpress.system.isZoom=typeof zoom!="undefined";CanvasXpress.factory.valid=typeof window.cX=="string"?window.cX:undefined}};var b=function(){if(window.document.readyState==="complete"){c()}};var e=function(){c()};window.onReady=function(h,g){if(a){setTimeout(function(){h(g)},1);return}else{f.push({fn:h,ctx:g})}if(window.document.readyState==="complete"){setTimeout(c,1)}else{if(!d){if(window.document.addEventListener){window.document.addEventListener("DOMContentLoaded",c,false);window.addEventListener("load",e,false)}else{window.document.attachEvent("onreadystatechange",b);window.attachEvent("onload",e)}d=true}}};return true}();CanvasXpress.loadScripts=function(){var i=0;return function(files,callback,scope){var head=window.document.getElementsByTagName("head")[0];var loadScript=function(s,c){var t=s.type;if(t.match(/javascript/i)){s.onreadystatechange=function(){if(s.readyState==="loaded"||s.readyState==="complete"){s.onreadystatechange=null;c()}};s.onload=function(){c()};head.appendChild(s)}else{head.appendChild(s);c()}};var count=function(){if(i===files.length){i=0;if(callback){if(typeof(callback)=="function"){callback.call(scope)}else{if(typeof(callback)=="string"){eval("var fn = "+callback);fn()}}}}else{CanvasXpress.loadScripts(files,callback,scope)}};i++;loadScript(files[i-1],count)}}();CanvasXpress.transferDatasetAttributes=function(e,a,f){var d=JSON.parse(JSON.stringify(e.dataset));for(var c in d){if(d.hasOwnProperty(c)){if(f){a[c.replace(/^data-/,"")]=d[c]}else{var b="data-"+c.replace(/([a-zA-Z])(?=[A-Z])/g,"$1-").toLowerCase();a.setAttribute(b,d[c])}}}};CanvasXpress.initCanvas=function(){var e=window.document.getElementsByTagName("canvas");for(var d=0;d<e.length;d++){var g=e[d];if(g.className=="CanvasXpress"&&g.id){var f=false;var a={};var b=CanvasXpress.getObject(g.id);if(g.hasAttribute("data-src")&&!b){f=g.getAttribute("data-src");CanvasXpress.transferDatasetAttributes(g,a,true);if(Object.keys(a).length){new CanvasXpress(g.id,f,a)}else{new CanvasXpress(g.id,f)}}}}};CanvasXpress.initImage=function(){var a=window.document.getElementsByTagName("img");for(var c=0;c<a.length;c++){var g=a[c];if(g.className=="CanvasXpress"&&g.id){var f=CanvasXpress.getObject(g.id);var d=g.parentNode;if(!f){var e=g.src;var h=g.id;var b=window.document.createElement("canvas");b.width=g.clientWidth;b.height=g.clientHeight;CanvasXpress.transferDatasetAttributes(g,b);d.removeChild(g);b.id=h;d.appendChild(b);new CanvasXpress(h,e)}}}};CanvasXpress.initTable=function(){var c=window.document.getElementsByTagName("table");for(var b=0;b<c.length;b++){var e=c[b];if(e.className=="CanvasXpress"&&e.id){var g=CanvasXpress.getObject(e.id);var d=e.parentNode;if(!g){var f=e.id;var a=window.document.createElement("canvas");a.id="temp-table-id-"+e.id;a.width=e.hasAttribute("data-width")?e.getAttribute("data-width"):500;a.height=e.hasAttribute("data-height")?e.getAttribute("data-height"):500;CanvasXpress.transferDatasetAttributes(e,a);d.appendChild(a);new CanvasXpress({data:f,renderTo:f})}}}};CanvasXpress.getObject=function(f,b){if(f){while(CanvasXpress.chain.hasOwnProperty(f)){f=CanvasXpress.chain[f]}for(var a=0;a<CanvasXpress.instances.length;a++){if(CanvasXpress.instances[a].target==f){return CanvasXpress.instances[a]}}}else{if(b){var d=window.document.getElementById(f);if(!d){var e=window.document.createElement("canvas");e.id=f;e.width=100;e.height=100;window.document.body.appendChild(e);d=new CanvasXpress({renderTo:f,hidden:true})}return d}else{if(CanvasXpress.instances.length){return CanvasXpress.instances[0]}}}};CanvasXpress.json=function(b,c){var a=new FileReader();a.onload=function(){try{c(JSON.parse(a.result))}catch(d){alert("Oooops! Not a valid callback")}};a.readAsText(b)};CanvasXpress.csv=function(b,c){var a=new FileReader();a.onload=function(){try{var o=JSON.parse(a.result);var d=/\r\n|\r|\n/g;var h=o.split(d);var j=0;var n=0;if(o.match(/,/g)){j=o.match(/,/g).length}if(o.match(/\t/g)){n=o.match(/\t/g).length}var g=j>n?",":"\t";for(var k=0;k<h.length;k++){if(h[k].match(/^#/)){h.splice(k,1);k--;continue}var l=h[k].split(g);for(var p=l.length-1;p>=0;p--){if(l[p].replace(/"\s+$/,'"').charAt(l[p].length-1)=='"'){var q=l[p].replace(/^\s+"/,'"');if(q.length>1&&q.charAt(0)=='"'){l[p]=l[p].replace(/^\s*"|"\s*$/g,"").replace(/""/g,'"')}else{if(p){l.splice(p-1,2,[l[p-1],l[p]].join(g))}else{l=l.shift().split(g).concat(l)}}}else{l[p].replace(/""/g,'"')}}if(l.length==1&&l[0]==""){h.splice(k,1);k--;continue}h[k]=l}c(h)}catch(m){alert("Oooops! Not a valid callback")}};a.readAsText(b)};CanvasXpress.$=function(b,a){return CanvasXpress.getObject(b,a)};CanvasXpress.destroy=function(b,a){if(CanvasXpress.instances.length>0){CanvasXpress.instances[0].destroy(b,a)}};CanvasXpress.prototype.init=function(f,c,b,j,a,g,d,i,h,e){if(!f){return}else{if(typeof(f)=="object"&&f.renderTo){c=f.tracks?{tracks:f.tracks}:f.nodes?{nodes:f.nodes}:f.venn?{venn:f.venn}:f.data?f.data:false;b=f.config||false;if(f.version){b.createVersion=f.version}if(f.factory){b.createFactory=f.factory}j=f.events||false;a=f.info?f.info.replace(/'/g,"'").replace(/"/g,"'"):false;g=f.afterRender||false;d=f.hidden||false;i=f.callback||false;h=f.uploadFile||false;e=f.noValidate?f.noValidate:b&&b.noValidate?b.noValidate:false;f=f.renderTo}}this.setInit=function(){this.target=f;this.events=j;this.info=a;this.userId=1;this.url={};this.meta={ids:{},time:{start:new Date().getTime(),elapsed:null,end:null,draw:[],render:[]},data:false,canvas:{},config:{user:b,orig:{},vals:{},remote:false},vals:{},render:{objects:[],groups:{},types:{},order:[],map:{},origin:[],transition:false},events:{},state:{save:0,clip:false,translate:[0,0],rotate:[0],scale:[1,1],last:{translate:[0,0],rotate:[0],scale:[1,1]}},stack:[],def:{},dom:{}}};this.validateParameters=function(){this.validateData();this.validateConfig();this.validateEvents();this.validateInfo();this.validateAfterRender()};this.validateData=function(){this.dataURL=false;this.dataString=false;if(typeof(c)=="string"){var m=window.document.getElementById(c);if(m&&m.tagName.toLowerCase()=="table"&&m.className=="CanvasXpress"&&m.id){var n=c;c=this.parseHTMLTable(m,true);b=c.config;c=c.data;m.parentNode.removeChild(m);var k=window.document.getElementById("temp-table-id-"+n);if(k){k.id=n}else{alert("Dude! What did you do?")}}else{var m=this.isValidString(c);switch(m.type){case"URL":this.dataURL=c;c=false;break;case"XML":this.dataString=m.data;c=false;break;case"JSON":c=m.data;break;case"DELIM":c=m.data.data;if(!b){b=m.data.config}break;default:alert("Not a valid data string\n");break}}}else{if(typeof(c)=="function"){try{c=c.call(this)}catch(l){alert("Not a valid Data object:\n"+l)}}else{if(!e){try{this.stringifyJSON(c)}catch(l){alert("Data object malformed:\n"+l)}}}}};this.validateConfig=function(){if(b){if(typeof(b)=="function"){try{b=b.call(this)}catch(l){alert("Not a valid Data object:\n"+l)}}else{if(!e){try{this.stringifyJSON(b)}catch(l){alert("Config object malformed:\n"+l)}}}this.topoJSONURL=false;if(b.topoJSON&&typeof(b.topoJSON)=="string"){var k=this.isValidString(b.topoJSON);switch(k.type){case"URL":this.topoJSONURL=b.topoJSON;break}}}};this.validateEvents=function(){};this.validateInfo=function(){if(!a){a=""}};this.validateAfterRender=function(){if(g){try{this.stringifyJSON(g)}catch(k){alert("AfterRender object malformed:\n"+k)}}};this.isOneTimeFunctionInConfig=function(k){if(!k){k=this}if(k.transposeData){return true}if(k.transformData){return true}if(k.asSampleFactors&&k.asSampleFactors.length){return true}if(k.asVariableFactors&&k.asVariableFactors.length){return true}if(k.stringSampleFactors&&k.stringSampleFactors.length){return true}if(k.stringVariableFactors&&k.stringVariableFactors.length){return true}if(k.histogramData){return true}if(k.ridgeBy){return true}if(k.sortData&&k.sortData.length){return true}if(k.asDOE){}return false};this.getAfterRender=function(k){var m=[];if(k.histogramData||k.ridgeBy){if(k.histogramData===true&&k.colorBy){m.unshift(["createHistogram",[],{}])}else{m.unshift(["createHistogram",[k.ridgeBy||k.histogramData||k.colorBy],{}])}}if(k.stringVariableFactors&&k.stringVariableFactors.length){for(var l=0;l<k.stringVariableFactors.length;l++){m.unshift(["switchNumericToString",[k.stringVariableFactors[l]],{}])}}if(k.stringSampleFactors&&k.stringSampleFactors.length){for(var l=0;l<k.stringSampleFactors.length;l++){m.unshift(["switchNumericToString",[k.stringSampleFactors[l],true],{}])}}if(k.asVariableFactors&&k.asVariableFactors.length){for(var l=0;l<k.asVariableFactors.length;l++){m.unshift(["switchVarToAnnotation",[k.asVariableFactors[l]],{}])}}if(k.asSampleFactors&&k.asSampleFactors.length){for(var l=0;l<k.asSampleFactors.length;l++){m.unshift(["switchSmpToAnnotation",[k.asSampleFactors[l]],{}])}}if(k.transposeData){m.unshift(["transpose",[false,true],{}])}if(k.transformData){m.unshift(["transform",[k.transformData,k.transformAxis,false,true],{}])}if(k.sortData&&k.sortData.length){for(var l=0;l<k.sortData.length;l++){m.push(["modifySort",[k.sortData[l][0],k.sortData[l][1],k.sortData[l][2],false,l==this.sortData.length-1?true:false],{}])}}if(k.asDOE){m.push(["createDOE",[],{}])}return m};this.afterRender=function(y){if(!y){y=[]}var C=this.meta.time.start;var z=this.graphType=="Scatter2D"&&this.scatterType=="visium";if(this.histogramData||this.ridgeBy){if(this.histogramData===true){y.push(["createHistogram",[],{},C,true])}else{y.push(["createHistogram",[this.ridgeBy||this.histogramData],{},C,true])}this.histogramData=false;delete (CanvasXpress.stack[this.target].config.histogramData)}if(this.stringVariableFactors.length){for(var p=0;p<this.stringVariableFactors.length;p++){y.unshift(["switchNumericToString",[this.stringVariableFactors[p],false],{},C,true])}this.stringVariableFactors=[];this.layoutRestore=false}if(this.stringSampleFactors.length){for(var p=0;p<this.stringSampleFactors.length;p++){y.unshift(["switchNumericToString",[this.stringSampleFactors[p],true],{},C,true])}this.stringSampleFactors=[];this.layoutRestore=false}if(this.asVariableFactors.length){for(var p=0;p<this.asVariableFactors.length;p++){y.unshift(["switchVarToAnnotation",[this.asVariableFactors[p],false],{},C,true])}this.asVariableFactors=[];this.layoutRestore=false}if(this.asSampleFactors.length){for(var p=0;p<this.asSampleFactors.length;p++){y.unshift(["switchSmpToAnnotation",[this.asSampleFactors[p],false],{},C,true])}this.asSampleFactors=[];this.layoutRestore=false}if(this.transposeData){y.unshift(["transpose",[false,this.sortData.length||this.selectedDataPoints.length],{},C,true]);this.transposeData=false;delete (CanvasXpress.stack[this.target].config.transposeData)}if(this.sortData){for(var p=0;p<this.sortData.length;p++){y.push(["modifySort",[this.sortData[p][0],this.sortData[p][1],this.sortData[p][2],false,p==this.sortData.length-1?true:false],{},C,true])}this.sortData=[];delete (CanvasXpress.stack[this.target].config.sortData)}if(this.selectedDataPoints.length&&this.xAxisIndices&&this.xAxisIndices.length&&this.yAxisIndices&&this.yAxisIndices.length){var x=false;for(var p=0;p<this.selectedDataPoints.length;p++){var o=this.getVariableIndices(this.selectedDataPoints[p]);if(o>=0){this.addRemoveToSelected([o,this.xAxisIndices[0],this.yAxisIndices[0]]);x=true}}if(x){y.unshift(["broadcastDraw",[{func:"afterRender"}],{},C,true])}}var r=y.length-1;var l=false;for(var p=0;p<y.length;p++){var n=y[p];var u=n.shift();if(u){var k=n.length>0?n.shift():[];var w=n.length>0?n.shift():{};var B=n.length>0?n.shift():C;var q=n.length>0?n.shift():false;if(this.showFunctionNamesAfterRender){this.flashInfoSpan(20,20,u)}var m=y[p+1]&&y[p+1][0]&&y[p+1][0].match(/drag/i)?true:false;this.skipRender=u=="createDOE"||u=="createHistogram"||u=="modifyColorScheme"||u.match(/segregate/)||m?false:!this.showTransition&&p<r?true:this.view=="table"?true:false;this.skipRender=u.match(/switch/)&&p<r?true:false;for(var s in w){this[s]=w[s]}if(u.match(/switch/)&&z&&p==r){l=true}this[u].apply(this,k);if(u=="moveCanvas"){CanvasXpress.stack[this.target].afterRender.push([u,k])}if(q){var A=CanvasXpress.stack[this.target].afterRender.length-1;CanvasXpress.stack[this.target].afterRender[A][4]=true}if(l){this.masterReset()}}}if(this.asDOE&&this.isDOEable()){this.createDOE(this.asDOE)}if(this.view=="table"){this.view="canvas";this.clickView()}else{if(this.view=="layout"){this.view="canvas";this.clickLayout(false,false,"none")}}this.triggerDataLoaded("afterRender")};this.setURL=function(){if(window.location.search!=""){var m=location.search.substring(1).split("&");for(var l=0;l<m.length;l++){var k=m[l].split("=");if(!k[0]){continue}if(k[0].match(/^cX/)){this.url[k[0]]=k[1]||true}else{this.url[k[0]]=k[1]=="false"?false:k[1]=="true"?true:k[1]}}}};this.createThumbnailBase64=function(){if(this.url.hasOwnProperty("cXprint")||this.printThumbnail){this.printThumbnail=false;var l=this.url.cXprint!==true&&this.url.cXprint!=="true"?this.url.cXprint:this.saveFilename?this.saveFilename:this.target+".png";var k=this;var m=function(n,o){k.saveAs(n,o);setTimeout(function(){window.close()},4000)};k.print(false,l,m)}else{if(this.url.hasOwnProperty("cXprintBase64")||this.cacheBase64){this.cacheBase64=false;var m=function(){return};if(CanvasXpress.$(this.target)){this.print(false,false,m)}}}};this.logConsole=function(k){if(this.verbose){console.log(this.target,this.prettyJSON(k))}};this.triggerDataLoaded=function(n,l){var m=this;var k=function(){var o=l||m;o.logConsole("canvasXpress data ready - "+n);o.createThumbnailBase64();CanvasXpress.ready=true};if(CanvasXpress.cacheImagesReady){if(n=="afterRender"){if(!this.isAnimation&&!this.isTransitionOn&&!this.dataURL&&!this.dataString&&!h&&!this.isUpdateRemoteData&&!d){k()}}else{if(this.graphType=="Network"){if(!this.isAnimation&&!this.isUpdateRemoteData){k()}}else{if(!this.isTransitionOn){k()}}}}};this.saveFirstState=function(){CanvasXpress.stack[this.target].state.push(this.getConfigState())};this.continueInitialization=function(){var k=CanvasXpress.stack[this.target];var l=this.isOneTimeFunctionInConfig();this.initializeGraph(false,false,false,false,false,false,l);if(!this.dataURL){this.afterRender(k.afterRenderInit)}this.getDataFromURLOrString(this.target,k.config,k.events,k.info);this.saveFirstState();CanvasXpress.current=this.target;this.meta.time.end=new Date().getTime();this.meta.time.elapsed=this.meta.time.end-this.meta.time.start;this.hideMask()};this.pauseInitialization=function(){if(!this.lazyLoad||(!this.loaded&&this.isInViewport(this.meta.canvas.ctx.canvas))){this.continueInitialization()}};this.initializeProcessing=function(){var k=this;k.initializeBrowser();k.inititalizeConfig(b);k.initializeViewport(d);k.validateUserColors();k.initializeApi();k.initializeDimensions();k.initializeData(c);k.initializeLayout();k.initializeDataFilters();k.initializeEvents();k.initializeRemote();k.initStack(c,b,j,a,g);k.initTransitions();k.pauseInitialization()};this.initialize=function(){CanvasXpress.instances.push(this);this.setInit();this.setURL();this.initDOM();this.initSVG();this.initInterface();this.initSave();this.validateParameters();this.initConfig();this.initDate();this.initViewport();this.initPrimitives();this.initUtils();this.initNumeric();this.initjLouvain();this.initMathUtils();this.initLegendUtils();this.initFilterUtils();this.initClusterUtils();this.initSortUtils();this.initExample();this.initDataUtils();this.initRandom();this.initData();this.initValidity();this.initLayout();this.initEvents();this.initTooltip();this.initTooltipMouse();this.initTooltipDiv();this.initToolbar();this.initMenus();this.initLinks();this.initConfigurator();this.initDataFilter();this.initDataTable();this.initCodeInfo();this.initBin();this.initDataExplorer();this.initAnimation();this.initRemote();this.initAxes();this.initGraph();this.initializeProcessing()};this.initialize()};CanvasXpress.png="data:image/png;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==";CanvasXpress.letters=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];CanvasXpress.dates={Sun:1,Mon:2,Tue:3,Wed:4,Thu:5,Fri:6,Sat:7,Sunday:1,Monday:2,Tuesday:3,Wednesday:4,Thursday:5,Friday:6,Saturday:7,Jan:"01",Feb:"02",Mar:"03",Apr:"04",May:"05",Jun:"06",Jul:"07",Aug:"08",Sep:"09",Oct:"10",Nov:"11",Dec:"12",January:"01",February:"02",March:"03",April:"04",May:"05",June:"06",July:"07",August:"08",September:"09",October:"10",November:"11",December:"12"};CanvasXpress.countries={AFG:["Afghanistan","Asia","South Asia","AF",33.939,67.709],ALA:["Aland Islands","Europe","North Europe","AX",48.464,-122.706],ALB:["Albania","Europe","South Europe","AL",41.153,20.168],DZA:["Algeria","Africa","North Africa","DZ",28.033,1.659],ASM:["American Samoa","Oceania","Polynesia","AS",-14.271,-170.133],AND:["Andorra","Europe","South Europe","AD",42.546,1.601],AGO:["Angola","Africa","Middle Africa","AO",-11.203,17.873],AIA:["Anguilla","America","Caribbean","AI",18.22,-63.069],ATA:["Antarctica","","","AQ",-75.251,-0.072],ATG:["Antigua and Barbuda","America","Caribbean","AG",17.06,-61.797],ARG:["Argentina","America","South America","AR",-38.417,-63.617],ARM:["Armenia","Asia","West Asia","AM",40.069,45.038],ABW:["Aruba","America","Caribbean","AW",12.521,-69.969],AUS:["Australia","Oceania","Australia and New Zealand","AU",-25.275,133.775],AUT:["Austria","Europe","West Europe","AT",47.516,14.55],AZE:["Azerbaijan","Asia","West Asia","AZ",40.143,47.576],BHS:["Bahamas","America","Caribbean","BS",25.034,-77.397],BHR:["Bahrain","Asia","West Asia","BH",25.93,50.637],BGD:["Bangladesh","Asia","South Asia","BD",23.684,90.356],BRB:["Barbados","America","Caribbean","BB",13.193,-59.544],BLR:["Belarus","Europe","East Europe","BY",53.709,27.953],BEL:["Belgium","Europe","West Europe","BE",50.503,4.469],BLZ:["Belize","America","Central America","BZ",17.189,-88.498],BEN:["Benin","Africa","West Africa","BJ",9.307,2.315],BMU:["Bermuda","America","North America","BM",32.321,-64.758],BTN:["Bhutan","Asia","South Asia","BT",27.514,90.433],BOL:["Bolivia","America","South America","BO",-16.291,-63.589],BES:["Bonaire","America","Caribbean","BQ",12.201,-68.262],BIH:["Bosnia and Herzegovina","Europe","South Europe","BA",43.915,17.679],BWA:["Botswana","Africa","South Africa","BW",-22.329,24.684],BVT:["Bouvet Island","","","BV",-54.424,3.413],BRA:["Brazil","America","South America","BR",-14.236,-51.926],IOT:["British Indian Ocean Territory","","","IO",-6.344,71.876],BRN:["Brunei Darussalam","Asia","South-East Asia","BN",4.535,114.727],BGR:["Bulgaria","Europe","East Europe","BG",42.733,25.485],BFA:["Burkina Faso","Africa","West Africa","BF",12.238,-1.562],BDI:["Burundi","Africa","East Africa","BI",-3.374,29.918],KHM:["Cambodia","Asia","South-East Asia","KH",12.565,104.99],CMR:["Cameroon","Africa","Middle Africa","CM",7.369,12.354],CAN:["Canada","America","North America","CA",56.13,-106.347],CPV:["Cabo Verde","Africa","West Africa","CV",16.002,-24.014],CYM:["Cayman Islands","America","Caribbean","KY",19.513,-80.567],CAF:["Central African Republic","Africa","Middle Africa","CF",6.611,20.939],TCD:["Chad","Africa","Middle Africa","TD",15.454,18.732],CHL:["Chile","America","South America","CL",-35.676,-71.543],CHN:["China","Asia","East Asia","CN",35.861,104.195],CXR:["Christmas Island","","","CX",-10.448,105.69],CCK:["Cocos (Keeling) Islands","","","CC",-12.165,96.87],COL:["Colombia","America","South America","CO",4.57,-74.298],COM:["Comoros","Africa","East Africa","KM",-11.876,43.872],COG:["Congo","Africa","Middle Africa","CG",-0.229,15.827],COD:["Congo (Democratic Republic of the)","Africa","Middle Africa","CD",-4.039,21.758],COK:["Cook Islands","Oceania","Polynesia","CK",-21.237,-159.778],CRI:["Costa Rica","America","Central America","CR",9.748,-83.754],CIV:["Cote d'Ivoire","Africa","West Africa","CI",7.539,-5.548],HRV:["Croatia","Europe","South Europe","HR",45.1,15.2],CUB:["Cuba","America","Caribbean","CU",21.521,-77.782],CUW:["Cura�ao","America","Caribbean","CW",12.169,-68.99],CYP:["Cyprus","Asia","West Asia","CY",35.126,33.429],CZE:["Czech Republic","Europe","East Europe","CZ",49.817,15.472],DNK:["Denmark","Europe","North Europe","DK",56.263,9.501],DJI:["Djibouti","Africa","East Africa","DJ",11.825,42.59],DMA:["Dominica","America","Caribbean","DM",15.414,-61.371],DOM:["Dominican Republic","America","Caribbean","DO",18.735,-70.163],ECU:["Ecuador","America","South America","EC",-1.832,-78.184],EGY:["Egypt","Africa","North Africa","EG",26.82,30.802],SLV:["El Salvador","America","Central America","SV",13.794,-88.897],GNQ:["Equatorial Guinea","Africa","Middle Africa","GQ",1.65,10.267],ERI:["Eritrea","Africa","East Africa","ER",15.179,39.782],EST:["Estonia","Europe","North Europe","EE",58.595,25.013],ETH:["Ethiopia","Africa","East Africa","ET",9.145,40.489],FLK:["Falkland Islands","America","South America","FK",-51.797,-59.524],FRO:["Faroe Islands","Europe","North Europe","FO",61.892,-6.912],FJI:["Fiji","Oceania","Melanesia","FJ",-16.579,179.414],FIN:["Finland","Europe","North Europe","FI",61.924,25.748],FRA:["France","Europe","West Europe","FR",46.227,2.213],GUF:["French Guiana","America","South America","GF",3.933,-53.126],PYF:["French Polynesia","Oceania","Polynesia","PF",-17.68,-149.407],ATF:["French Southern Territories","","","TF",-49.281,69.348],GAB:["Gabon","Africa","Middle Africa","GA",-0.804,11.609],GMB:["Gambia","Africa","West Africa","GM",13.443,-15.311],GEO:["Georgia","Asia","West Asia","GE",42.315,43.356],DEU:["Germany","Europe","West Europe","DE",51.165,10.451],GHA:["Ghana","Africa","West Africa","GH",7.946,-1.024],GIB:["Gibraltar","Europe","South Europe","GI",36.137,-5.346],GRC:["Greece","Europe","South Europe","GR",39.074,21.824],GRE:["Greece","Europe","South Europe","EL",39.074,21.824],GRL:["Greenland","America","North America","GL",71.706,-42.605],GRD:["Grenada","America","Caribbean","GD",12.262,-61.605],GLP:["Guadeloupe","America","Caribbean","GP",16.995,-62.068],GUM:["Guam","Oceania","Micronesia","GU",13.444,144.793],GTM:["Guatemala","America","Central America","GT",15.783,-90.231],GGY:["Guernsey","Europe","North Europe","GG",49.465,-2.586],GIN:["Guinea","Africa","West Africa","GN",9.945,-9.697],GNB:["Guinea-Bissau","Africa","West Africa","GW",11.803,-15.181],GUY:["Guyana","America","South America","GY",4.86,-58.931],HTI:["Haiti","America","Caribbean","HT",18.971,-72.286],HMD:["Heard Island and McDonald Islands","","","HM",-53.082,73.504],VAT:["Holy See","Europe","South Europe","VA",41.902,12.453],HND:["Honduras","America","Central America","HN",15.199,-86.242],HKG:["Hong Kong","Asia","East Asia","HK",22.396,114.109],HUN:["Hungary","Europe","East Europe","HU",47.162,19.503],ISL:["Iceland","Europe","North Europe","IS",64.963,-19.021],IND:["India","Asia","South Asia","IN",20.593,78.962],IDN:["Indonesia","Asia","South-East Asia","ID",-0.79,113.921],IRN:["Iran","Asia","South Asia","IR",32.427,53.688],IRQ:["Iraq","Asia","West Asia","IQ",33.223,43.679],IRL:["Ireland","Europe","North Europe","IE",53.412,-8.244],IMN:["Isle of Man","Europe","North Europe","IM",54.236,-4.549],ISR:["Israel","Asia","West Asia","IL",31.046,34.851],ITA:["Italy","Europe","South Europe","IT",41.871,12.567],JAM:["Jamaica","America","Caribbean","JM",18.109,-77.298],JPN:["Japan","Asia","East Asia","JP",36.204,138.252],JEY:["Jersey","Europe","North Europe","JE",49.214,-2.132],JOR:["Jordan","Asia","West Asia","JO",30.585,36.238],KAZ:["Kazakhstan","Asia","Central Asia","KZ",48.019,66.923],KEN:["Kenya","Africa","East Africa","KE",-0.024,37.906],KIR:["Kiribati","Oceania","Micronesia","KI",-3.371,-168.735],PRK:["Korea (Democratic People's Republic of)","Asia","East Asia","KP",40.339,127.51],KOR:["Korea (Republic of)","Asia","East Asia","KR",35.907,127.766],XKX:["Kosovo","Europe","South Europe","XK",42.602,20.902],KWT:["Kuwait","Asia","West Asia","KW",29.311,47.481],KGZ:["Kyrgyzstan","Asia","Central Asia","KG",41.204,74.766],LAO:["Lao People's Democratic Republic","Asia","South-East Asia","LA",19.856,102.495],LVA:["Latvia","Europe","North Europe","LV",56.879,24.603],LBN:["Lebanon","Asia","West Asia","LB",33.854,35.862],LSO:["Lesotho","Africa","South Africa","LS",-29.61,28.233],LBR:["Liberia","Africa","West Africa","LR",6.428,-9.43],LBY:["Libya","Africa","North Africa","LY",26.335,17.228],LIE:["Liechtenstein","Europe","West Europe","LI",47.166,9.555],LTU:["Lithuania","Europe","North Europe","LT",55.169,23.881],LUX:["Luxembourg","Europe","West Europe","LU",49.815,6.129],MAC:["Macao","Asia","East Asia","MO",22.198,113.543],MKD:["Macedonia","Europe","South Europe","MK",41.608,21.745],MDG:["Madagascar","Africa","East Africa","MG",-18.767,46.869],MWI:["Malawi","Africa","East Africa","MW",-13.255,34.301],MYS:["Malaysia","Asia","South-East Asia","MY",4.21,101.975],MDV:["Maldives","Asia","South Asia","MV",3.202,73.22],MLI:["Mali","Africa","West Africa","ML",17.57,-3.997],MLT:["Malta","Europe","South Europe","MT",35.937,14.375],MHL:["Marshall Islands","Oceania","Micronesia","MH",7.131,171.184],MTQ:["Martinique","America","Caribbean","MQ",14.641,-61.025],MRT:["Mauritania","Africa","West Africa","MR",21.007,-10.941],MUS:["Mauritius","Africa","East Africa","MU",-20.349,57.552],MYT:["Mayotte","Africa","East Africa","YT",-12.828,45.166],MEX:["Mexico","America","Central America","MX",23.634,-102.553],FSM:["Micronesia","Oceania","Micronesia","FM",7.425,150.55],MDA:["Moldova","Europe","East Europe","MD",47.411,28.369],MCO:["Monaco","Europe","West Europe","MC",43.75,7.412],MNG:["Mongolia","Asia","East Asia","MN",46.862,103.846],MNE:["Montenegro","Europe","South Europe","ME",42.708,19.374],MSR:["Montserrat","America","Caribbean","MS",16.742,-62.188],MAR:["Morocco","Africa","North Africa","MA",31.791,-7.093],MOZ:["Mozambique","Africa","East Africa","MZ",-18.666,35.529],MMR:["Myanmar","Asia","South-East Asia","MM",21.913,95.956],NAM:["Namibia","Africa","South Africa","NA",-22.958,18.49],NRU:["Nauru","Oceania","Micronesia","NR",-0.523,166.931],NPL:["Nepal","Asia","South Asia","NP",28.394,84.124],NLD:["Netherlands","Europe","West Europe","NL",52.132,5.291],ANT:["Netherlands Antilles","","","AN",12.226,-69.061],NCL:["New Caledonia","Oceania","Melanesia","NC",-20.905,165.618],NZL:["New Zealand","Oceania","Australia and New Zealand","NZ",-40.901,174.885],NIC:["Nicaragua","America","Central America","NI",12.865,-85.208],NER:["Niger","Africa","West Africa","NE",17.607,8.081],NGA:["Nigeria","Africa","West Africa","NG",9.081,8.675],NIU:["Niue","Oceania","Polynesia","NU",-19.055,-169.868],NFK:["Norfolk Island","Oceania","Australia and New Zealand","NF",-29.041,167.954],MNP:["West Mariana Islands","Oceania","Micronesia","MP",17.33,145.384],NOR:["Norway","Europe","North Europe","NO",60.472,8.468],OMN:["Oman","Asia","West Asia","OM",21.512,55.923],PAK:["Pakistan","Asia","South Asia","PK",30.375,69.345],PLW:["Palau","Oceania","Micronesia","PW",7.514,134.582],PSE:["Palestine","Asia","West Asia","PS",31.952,35.233],PAN:["Panama","America","Central America","PA",8.537,-80.783],PNG:["Papua New Guinea","Oceania","Melanesia","PG",-6.315,143.955],PRY:["Paraguay","America","South America","PY",-23.443,-58.444],PER:["Peru","America","South America","PE",-9.19,-75.016],PHL:["Philippines","Asia","South-East Asia","PH",12.879,121.774],PCN:["Pitcairn","Oceania","Polynesia","PN",-24.704,-127.44],POL:["Poland","Europe","East Europe","PL",51.919,19.145],PRT:["Portugal","Europe","South Europe","PT",39.399,-8.225],PRI:["Puerto Rico","America","Caribbean","PR",18.22,-66.591],QAT:["Qatar","Asia","West Asia","QA",25.354,51.183],REU:["R�union","Africa","East Africa","RE",-21.116,55.536],ROU:["Romania","Europe","East Europe","RO",45.943,24.966],RUS:["Russian Federation","Europe","East Europe","RU",61.524,105.318],RWA:["Rwanda","Africa","East Africa","RW",-1.941,29.873],BLM:["Saint Barthelemy","America","Caribbean","BL",17.899,-62.833],SHN:["Saint Helena","Africa","West Africa","SH",-24.144,-10.031],KNA:["Saint Kitts and Nevis","America","Caribbean","KN",17.357,-62.783],LCA:["Saint Lucia","America","Caribbean","LC",13.909,-60.979],MAF:["Saint Martin","America","Caribbean","MF",18.075,-63.06],SPM:["Saint Pierre and Miquelon","America","North America","PM",46.941,-56.272],VCT:["Saint Vincent and the Grenadines","America","Caribbean","VC",12.984,-61.288],WSM:["Samoa","Oceania","Polynesia","WS",-13.76,-172.105],SMR:["San Marino","Europe","South Europe","SM",43.942,12.457],STP:["Sao Tome and Principe","Africa","Middle Africa","ST",0.186,6.613],SAU:["Saudi Arabia","Asia","West Asia","SA",23.885,45.079],SEN:["Senegal","Africa","West Africa","SN",14.497,-14.453],SRB:["Serbia","Europe","South Europe","RS",44.016,21.005],SYC:["Seychelles","Africa","East Africa","SC",-4.68,55.491],SLE:["Sierra Leone","Africa","West Africa","SL",8.46,-11.78],SGP:["Singapore","Asia","South-East Asia","SG",1.352,103.819],SXM:["Sint Maarten","America","Caribbean","SX",18.042,-63.054],SVK:["Slovakia","Europe","East Europe","SK",48.669,19.699],SVN:["Slovenia","Europe","South Europe","SI",46.151,14.995],SLB:["Solomon Islands","Oceania","Melanesia","SB",-9.646,160.156],SOM:["Somalia","Africa","East Africa","SO",5.152,46.199],ZAF:["South Africa","Africa","South Africa","ZA",-30.56,22.937],SGS:["South Georgia and the South Sandwich Islands","","","GS",-54.43,-36.588],SSD:["South Sudan","Africa","East Africa","SS",4.859,31.571],ESP:["Spain","Europe","South Europe","ES",40.463,-3.75],LKA:["Sri Lanka","Asia","South Asia","LK",7.873,80.771],SDN:["Sudan","Africa","North Africa","SD",12.862,30.217],SUR:["Suriname","America","South America","SR",3.919,-56.028],SJM:["Svalbard and Jan Mayen","Europe","North Europe","SJ",77.553,23.67],SWZ:["Swaziland","Africa","South Africa","SZ",-26.523,31.465],SWE:["Sweden","Europe","North Europe","SE",60.128,18.643],CHE:["Switzerland","Europe","West Europe","CH",46.818,8.227],SYR:["Syrian Arab Republic","Asia","West Asia","SY",34.802,38.996],TWN:["Taiwan","Asia","East Asia","TW",23.697,120.96],TJK:["Tajikistan","Asia","Central Asia","TJ",38.861,71.276],TZA:["Tanzania","Africa","East Africa","TZ",-6.37,34.888],THA:["Thailand","Asia","South-East Asia","TH",15.87,100.992],TLS:["Timor-Leste","Asia","South-East Asia","TL",-8.875,125.727],TGO:["Togo","Africa","West Africa","TG",8.619,0.824],TKL:["Tokelau","Oceania","Polynesia","TK",-8.968,-171.856],TON:["Tonga","Oceania","Polynesia","TO",-21.179,-175.199],TTO:["Trinidad and Tobago","America","Caribbean","TT",10.691,-61.223],TUN:["Tunisia","Africa","North Africa","TN",33.886,9.537],TUR:["Turkey","Asia","West Asia","TR",38.963,35.243],TKM:["Turkmenistan","Asia","Central Asia","TM",38.969,59.556],TCA:["Turks and Caicos Islands","America","Caribbean","TC",21.694,-71.798],TUV:["Tuvalu","Oceania","Polynesia","TV",-7.11,177.649],UGA:["Uganda","Africa","East Africa","UG",1.373,32.29],UKR:["Ukraine","Europe","East Europe","UA",48.379,31.165],ARE:["United Arab Emirates","Asia","West Asia","AE",23.424,53.847],GBR:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe","GB",55.378,-3.436],UKM:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe","UK",55.378,-3.436],USA:["United States of America","America","North America","US",37.09,-95.713],UMI:["United States Minor Outlying Islands","","","UM",-0.374,-159.996],URY:["Uruguay","America","South America","UY",-32.523,-55.766],UZB:["Uzbekistan","Asia","Central Asia","UZ",41.377,64.585],VUT:["Vanuatu","Oceania","Melanesia","VU",-15.377,166.959],VEN:["Venezuela","America","South America","VE",6.423,-66.59],VNM:["Vietnam","Asia","South-East Asia","VN",14.058,108.277],VGB:["Virgin Islands (British)","America","Caribbean","VG",18.42,-64.64],VIR:["Virgin Islands (U.S.)","America","Caribbean","VI",18.335,-64.897],WLF:["Wallis and Futuna","Oceania","Polynesia","WF",-13.769,-177.157],ESH:["Western Sahara","Africa","North Africa","EH",24.215,-12.886],XXX:["Unespecified Nationality","","","XX",],YEM:["Yemen","Asia","West Asia","YE",15.552,48.516],ZMB:["Zambia","Africa","East Africa","ZM",-13.134,27.849],ZWE:["Zimbabwe","Africa","East Africa","ZW",-19.016,29.154]};CanvasXpress.usa={AK:["Alaska",63.588753,-154.493062],AL:["Alabama",32.318231,-86.902298],AR:["Arkansas",35.20105,-91.831833],AZ:["Arizona",34.048928,-111.093731],CA:["California",36.778261,-119.417932],CO:["Colorado",39.550051,-105.782067],CT:["Connecticut",41.603221,-73.087749],DC:["District of Columbia",38.905985,-77.033418],DE:["Delaware",38.910832,-75.52767],FL:["Florida",27.664827,-81.515754],GA:["Georgia",32.157435,-82.907123],HI:["Hawaii",19.898682,-155.665857],IA:["Iowa",41.878003,-93.097702],ID:["Idaho",44.068202,-114.742041],IL:["Illinois",40.633125,-89.398528],IN:["Indiana",40.551217,-85.602364],KS:["Kansas",39.011902,-98.484246],KY:["Kentucky",37.839333,-84.270018],LA:["Louisiana",31.244823,-92.145024],MA:["Massachusetts",42.407211,-71.382437],MD:["Maryland",39.045755,-76.641271],ME:["Maine",45.253783,-69.445469],MI:["Michigan",44.314844,-85.602364],MN:["Minnesota",46.729553,-94.6859],MO:["Missouri",37.964253,-91.831833],MS:["Mississippi",32.354668,-89.398528],MT:["Montana",46.879682,-110.362566],NC:["North Carolina",35.759573,-79.0193],ND:["NorthDakota",47.551493,-101.002012],NE:["Nebraska",41.492537,-99.901813],NH:["New Hampshire",43.193852,-71.572395],NJ:["New Jersey",40.058324,-74.405661],NM:["New Mexico",34.97273,-105.032363],NV:["Nevada",38.80261,-116.419389],NY:["New York",43.299428,-74.217933],OH:["Ohio",40.417287,-82.907123],OK:["Oklahoma",35.007752,-97.092877],OR:["Oregon",43.804133,-120.554201],PA:["Pennsylvania",41.203322,-77.194525],PR:["Puerto Rico",18.220833,-66.590149],RI:["Rhode Island",41.580095,-71.477429],SC:["South Carolina",33.836081,-81.163725],SD:["South Dakota",43.969515,-99.901813],TN:["Tennessee",35.517491,-86.580447],TX:["Texas",31.968599,-99.901813],UT:["Utah",39.32098,-111.093731],VA:["Virginia",37.431573,-78.656894],VT:["Vermont",44.558803,-72.577841],WA:["Washington",47.751074,-120.740139],WI:["Wisconsin",43.78444,-88.787868],WV:["West Virginia",38.597626,-80.454903],WY:["Wyoming",43.075968,-107.290284]};CanvasXpress.maps={Africa:"/data/africa.geo.json",Argentina:"/data/argentina.geo.json",Asia:"/data/asia.geo.json",Belgium:"/data/belgium.geo.json",China:"/data/china.geo.json",Colombia:"/data/colombia.geo.json",Countries:"/data/countries.geo.json",Europe:"/data/europe.geo.json",France:"/data/france.geo.json",India:"/data/india.geo.json",Italy:"/data/italy.geo.json",NorthAmerica:"/data/north-america.geo.json",Oceania:"/data/oceania.geo.json",SouthAmerica:"/data/south-america.geo.json",Spain:"/data/spain.geo.json",UnitedKingdom:"/data/united-kindom.geo.json",USA:"/data/USA.geo.json",USACounties:"/data/usa-counties.json",USADistricts:"/data/usa-districts.json",USAStates:"/data/usa-states.json",WorldContinents:"/data/world-continents-geo.json",World:"/data/world.geo.json"};CanvasXpress.chromosomes={hg19:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5400000,"p36.32","gpos25"],[5400000,7200000,"p36.31","gneg"],[7200000,9200000,"p36.23","gpos25"],[9200000,12700000,"p36.22","gneg"],[12700000,16200000,"p36.21","gpos50"],[16200000,20400000,"p36.13","gneg"],[20400000,23900000,"p36.12","gpos25"],[23900000,28000000,"p36.11","gneg"],[28000000,30200000,"p35.3","gpos25"],[30200000,32400000,"p35.2","gneg"],[32400000,34600000,"p35.1","gpos25"],[34600000,40100000,"p34.3","gneg"],[40100000,44100000,"p34.2","gpos25"],[44100000,46800000,"p34.1","gneg"],[46800000,50700000,"p33","gpos75"],[50700000,56100000,"p32.3","gneg"],[56100000,59000000,"p32.2","gpos50"],[59000000,61300000,"p32.1","gneg"],[61300000,68900000,"p31.3","gpos50"],[68900000,69700000,"p31.2","gneg"],[69700000,84900000,"p31.1","gpos100"],[84900000,88400000,"p22.3","gneg"],[88400000,92000000,"p22.2","gpos75"],[92000000,94700000,"p22.1","gneg"],[94700000,99700000,"p21.3","gpos75"],[99700000,102200000,"p21.2","gneg"],[102200000,107200000,"p21.1","gpos100"],[107200000,111800000,"p13.3","gneg"],[111800000,116100000,"p13.2","gpos50"],[116100000,117800000,"p13.1","gneg"],[117800000,120600000,"p12","gpos50"],[120600000,121500000,"p11.2","gneg"],[121500000,125000000,"p11.1","acen"],[125000000,128900000,"q11","acen"],[128900000,142600000,"q12","gvar"],[142600000,147000000,"q21.1","gneg"],[147000000,150300000,"q21.2","gpos50"],[150300000,155000000,"q21.3","gneg"],[155000000,156500000,"q22","gpos50"],[156500000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,172900000,"q24.3","gpos75"],[172900000,176000000,"q25.1","gneg"],[176000000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207200000,"q32.1","gneg"],[207200000,211500000,"q32.2","gpos25"],[211500000,214500000,"q32.3","gneg"],[214500000,224100000,"q41","gpos100"],[224100000,224600000,"q42.11","gneg"],[224600000,227000000,"q42.12","gpos25"],[227000000,230700000,"q42.13","gneg"],[230700000,234700000,"q42.2","gpos50"],[234700000,236600000,"q42.3","gneg"],[236600000,243700000,"q43","gpos75"],[243700000,249250621,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,7100000,"p25.2","gpos50"],[7100000,12200000,"p25.1","gneg"],[12200000,16700000,"p24.3","gpos75"],[16700000,19200000,"p24.2","gneg"],[19200000,24000000,"p24.1","gpos75"],[24000000,27900000,"p23.3","gneg"],[27900000,30000000,"p23.2","gpos25"],[30000000,32100000,"p23.1","gneg"],[32100000,36600000,"p22.3","gpos75"],[36600000,38600000,"p22.2","gneg"],[38600000,41800000,"p22.1","gpos50"],[41800000,47800000,"p21","gneg"],[47800000,52900000,"p16.3","gpos100"],[52900000,55000000,"p16.2","gneg"],[55000000,61300000,"p16.1","gpos100"],[61300000,64100000,"p15","gneg"],[64100000,68600000,"p14","gpos50"],[68600000,71500000,"p13.3","gneg"],[71500000,73500000,"p13.2","gpos50"],[73500000,75000000,"p13.1","gneg"],[75000000,83300000,"p12","gpos100"],[83300000,90500000,"p11.2","gneg"],[90500000,93300000,"p11.1","acen"],[93300000,96800000,"q11.1","acen"],[96800000,102700000,"q11.2","gneg"],[102700000,106000000,"q12.1","gpos50"],[106000000,107500000,"q12.2","gneg"],[107500000,110200000,"q12.3","gpos25"],[110200000,114400000,"q13","gneg"],[114400000,118800000,"q14.1","gpos50"],[118800000,122400000,"q14.2","gneg"],[122400000,129900000,"q14.3","gpos50"],[129900000,132500000,"q21.1","gneg"],[132500000,135100000,"q21.2","gpos25"],[135100000,136800000,"q21.3","gneg"],[136800000,142200000,"q22.1","gpos100"],[142200000,144100000,"q22.2","gneg"],[144100000,148700000,"q22.3","gpos100"],[148700000,149900000,"q23.1","gneg"],[149900000,150500000,"q23.2","gpos25"],[150500000,154900000,"q23.3","gneg"],[154900000,159800000,"q24.1","gpos75"],[159800000,163700000,"q24.2","gneg"],[163700000,169700000,"q24.3","gpos75"],[169700000,178000000,"q31.1","gneg"],[178000000,180600000,"q31.2","gpos50"],[180600000,183000000,"q31.3","gneg"],[183000000,189400000,"q32.1","gpos75"],[189400000,191900000,"q32.2","gneg"],[191900000,197400000,"q32.3","gpos75"],[197400000,203300000,"q33.1","gneg"],[203300000,204900000,"q33.2","gpos50"],[204900000,209000000,"q33.3","gneg"],[209000000,215300000,"q34","gpos100"],[215300000,221500000,"q35","gneg"],[221500000,225200000,"q36.1","gpos75"],[225200000,226100000,"q36.2","gneg"],[226100000,231000000,"q36.3","gpos100"],[231000000,235600000,"q37.1","gneg"],[235600000,237300000,"q37.2","gpos50"],[237300000,243199373,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8700000,"p26.1","gpos50"],[8700000,11800000,"p25.3","gneg"],[11800000,13300000,"p25.2","gpos25"],[13300000,16400000,"p25.1","gneg"],[16400000,23900000,"p24.3","gpos100"],[23900000,26400000,"p24.2","gneg"],[26400000,30900000,"p24.1","gpos75"],[30900000,32100000,"p23","gneg"],[32100000,36500000,"p22.3","gpos50"],[36500000,39400000,"p22.2","gneg"],[39400000,43700000,"p22.1","gpos75"],[43700000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63700000,"p14.2","gneg"],[63700000,69800000,"p14.1","gpos50"],[69800000,74200000,"p13","gneg"],[74200000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87200000,"p12.1","gpos75"],[87200000,87900000,"p11.2","gneg"],[87900000,91000000,"p11.1","acen"],[91000000,93900000,"q11.1","acen"],[93900000,98300000,"q11.2","gvar"],[98300000,100000000,"q12.1","gneg"],[100000000,100900000,"q12.2","gpos25"],[100900000,102800000,"q12.3","gneg"],[102800000,106200000,"q13.11","gpos75"],[106200000,107900000,"q13.12","gneg"],[107900000,111300000,"q13.13","gpos50"],[111300000,113500000,"q13.2","gneg"],[113500000,117300000,"q13.31","gpos75"],[117300000,119000000,"q13.32","gneg"],[119000000,121900000,"q13.33","gpos75"],[121900000,123800000,"q21.1","gneg"],[123800000,125800000,"q21.2","gpos25"],[125800000,129200000,"q21.3","gneg"],[129200000,133700000,"q22.1","gpos25"],[133700000,135700000,"q22.2","gneg"],[135700000,138700000,"q22.3","gpos25"],[138700000,142800000,"q23","gneg"],[142800000,148900000,"q24","gpos100"],[148900000,152100000,"q25.1","gneg"],[152100000,155000000,"q25.2","gpos50"],[155000000,157000000,"q25.31","gneg"],[157000000,159000000,"q25.32","gpos50"],[159000000,160700000,"q25.33","gneg"],[160700000,167600000,"q26.1","gpos100"],[167600000,170900000,"q26.2","gneg"],[170900000,175700000,"q26.31","gpos75"],[175700000,179000000,"q26.32","gneg"],[179000000,182700000,"q26.33","gpos75"],[182700000,184500000,"q27.1","gneg"],[184500000,186000000,"q27.2","gpos25"],[186000000,187900000,"q27.3","gneg"],[187900000,192300000,"q28","gpos75"],[192300000,198022430,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15200000,"p15.33","gpos50"],[15200000,17800000,"p15.32","gneg"],[17800000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50400000,"p11","acen"],[50400000,52700000,"q11","acen"],[52700000,59500000,"q12","gneg"],[59500000,66600000,"q13.1","gpos100"],[66600000,70500000,"q13.2","gneg"],[70500000,76300000,"q13.3","gpos75"],[76300000,78900000,"q21.1","gneg"],[78900000,82400000,"q21.21","gpos50"],[82400000,84100000,"q21.22","gneg"],[84100000,86900000,"q21.23","gpos25"],[86900000,88000000,"q21.3","gneg"],[88000000,93700000,"q22.1","gpos75"],[93700000,95100000,"q22.2","gneg"],[95100000,98800000,"q22.3","gpos75"],[98800000,101100000,"q23","gneg"],[101100000,107700000,"q24","gpos50"],[107700000,114100000,"q25","gneg"],[114100000,120800000,"q26","gpos75"],[120800000,123800000,"q27","gneg"],[123800000,128800000,"q28.1","gpos50"],[128800000,131100000,"q28.2","gneg"],[131100000,139500000,"q28.3","gpos100"],[139500000,141500000,"q31.1","gneg"],[141500000,146800000,"q31.21","gpos25"],[146800000,148500000,"q31.22","gneg"],[148500000,151100000,"q31.23","gpos25"],[151100000,155600000,"q31.3","gneg"],[155600000,161800000,"q32.1","gpos100"],[161800000,164500000,"q32.2","gneg"],[164500000,170100000,"q32.3","gpos100"],[170100000,171900000,"q33","gneg"],[171900000,176300000,"q34.1","gpos75"],[176300000,177500000,"q34.2","gneg"],[177500000,183200000,"q34.3","gpos100"],[183200000,187100000,"q35.1","gneg"],[187100000,191154276,"q35.2","gpos25"]],5:[[0,4500000,"p15.33","gneg"],[4500000,6300000,"p15.32","gpos25"],[6300000,9800000,"p15.31","gneg"],[9800000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48400000,"p11","acen"],[48400000,50700000,"q11.1","acen"],[50700000,58900000,"q11.2","gneg"],[58900000,62900000,"q12.1","gpos75"],[62900000,63200000,"q12.2","gneg"],[63200000,66700000,"q12.3","gpos75"],[66700000,68400000,"q13.1","gneg"],[68400000,73300000,"q13.2","gpos50"],[73300000,76900000,"q13.3","gneg"],[76900000,81400000,"q14.1","gpos50"],[81400000,82800000,"q14.2","gneg"],[82800000,92300000,"q14.3","gpos100"],[92300000,98200000,"q15","gneg"],[98200000,102800000,"q21.1","gpos100"],[102800000,104500000,"q21.2","gneg"],[104500000,109600000,"q21.3","gpos100"],[109600000,111500000,"q22.1","gneg"],[111500000,113100000,"q22.2","gpos50"],[113100000,115200000,"q22.3","gneg"],[115200000,121400000,"q23.1","gpos100"],[121400000,127300000,"q23.2","gneg"],[127300000,130600000,"q23.3","gpos100"],[130600000,136200000,"q31.1","gneg"],[136200000,139500000,"q31.2","gpos25"],[139500000,144500000,"q31.3","gneg"],[144500000,149800000,"q32","gpos75"],[149800000,152700000,"q33.1","gneg"],[152700000,155700000,"q33.2","gpos50"],[155700000,159900000,"q33.3","gneg"],[159900000,168500000,"q34","gpos100"],[168500000,172800000,"q35.1","gneg"],[172800000,176600000,"q35.2","gpos25"],[176600000,180915260,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27000000,"p22.2","gneg"],[27000000,30400000,"p22.1","gpos50"],[30400000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,52900000,"p12.2","gneg"],[52900000,57000000,"p12.1","gpos100"],[57000000,58700000,"p11.2","gneg"],[58700000,61000000,"p11.1","acen"],[61000000,63300000,"q11.1","acen"],[63300000,63400000,"q11.2","gneg"],[63400000,70000000,"q12","gpos100"],[70000000,75900000,"q13","gneg"],[75900000,83900000,"q14.1","gpos50"],[83900000,84900000,"q14.2","gneg"],[84900000,88000000,"q14.3","gpos50"],[88000000,93100000,"q15","gneg"],[93100000,99500000,"q16.1","gpos100"],[99500000,100600000,"q16.2","gneg"],[100600000,105500000,"q16.3","gpos100"],[105500000,114600000,"q21","gneg"],[114600000,118300000,"q22.1","gpos75"],[118300000,118500000,"q22.2","gneg"],[118500000,126100000,"q22.31","gpos100"],[126100000,127100000,"q22.32","gneg"],[127100000,130300000,"q22.33","gpos75"],[130300000,131200000,"q23.1","gneg"],[131200000,135200000,"q23.2","gpos50"],[135200000,139000000,"q23.3","gneg"],[139000000,142800000,"q24.1","gpos75"],[142800000,145600000,"q24.2","gneg"],[145600000,149000000,"q24.3","gpos75"],[149000000,152500000,"q25.1","gneg"],[152500000,155500000,"q25.2","gpos50"],[155500000,161000000,"q25.3","gneg"],[161000000,164500000,"q26","gpos50"],[164500000,171115067,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7300000,"p22.1","gneg"],[7300000,13800000,"p21.3","gpos100"],[13800000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,28000000,"p15.2","gpos50"],[28000000,28800000,"p15.1","gneg"],[28800000,35000000,"p14.3","gpos75"],[35000000,37200000,"p14.2","gneg"],[37200000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,54000000,"p12.1","gpos75"],[54000000,58000000,"p11.2","gneg"],[58000000,59900000,"p11.1","acen"],[59900000,61700000,"q11.1","acen"],[61700000,67000000,"q11.21","gneg"],[67000000,72200000,"q11.22","gpos50"],[72200000,77500000,"q11.23","gneg"],[77500000,86400000,"q21.11","gpos100"],[86400000,88200000,"q21.12","gneg"],[88200000,91100000,"q21.13","gpos75"],[91100000,92800000,"q21.2","gneg"],[92800000,98000000,"q21.3","gpos75"],[98000000,103800000,"q22.1","gneg"],[103800000,104500000,"q22.2","gpos50"],[104500000,107400000,"q22.3","gneg"],[107400000,114600000,"q31.1","gpos75"],[114600000,117400000,"q31.2","gneg"],[117400000,121100000,"q31.31","gpos75"],[121100000,123800000,"q31.32","gneg"],[123800000,127100000,"q31.33","gpos75"],[127100000,129200000,"q32.1","gneg"],[129200000,130400000,"q32.2","gpos25"],[130400000,132600000,"q32.3","gneg"],[132600000,138200000,"q33","gpos50"],[138200000,143100000,"q34","gneg"],[143100000,147900000,"q35","gpos75"],[147900000,152600000,"q36.1","gneg"],[152600000,155100000,"q36.2","gpos25"],[155100000,159138663,"q36.3","gneg"]],8:[[0,2200000,"p23.3","gneg"],[2200000,6200000,"p23.2","gpos75"],[6200000,12700000,"p23.1","gneg"],[12700000,19000000,"p22","gpos100"],[19000000,23300000,"p21.3","gneg"],[23300000,27400000,"p21.2","gpos50"],[27400000,28800000,"p21.1","gneg"],[28800000,36500000,"p12","gpos75"],[36500000,38300000,"p11.23","gneg"],[38300000,39700000,"p11.22","gpos25"],[39700000,43100000,"p11.21","gneg"],[43100000,45600000,"p11.1","acen"],[45600000,48100000,"q11.1","acen"],[48100000,52200000,"q11.21","gneg"],[52200000,52600000,"q11.22","gpos75"],[52600000,55500000,"q11.23","gneg"],[55500000,61600000,"q12.1","gpos50"],[61600000,62200000,"q12.2","gneg"],[62200000,66000000,"q12.3","gpos50"],[66000000,68000000,"q13.1","gneg"],[68000000,70500000,"q13.2","gpos50"],[70500000,73900000,"q13.3","gneg"],[73900000,78300000,"q21.11","gpos100"],[78300000,80100000,"q21.12","gneg"],[80100000,84600000,"q21.13","gpos75"],[84600000,86900000,"q21.2","gneg"],[86900000,93300000,"q21.3","gpos100"],[93300000,99000000,"q22.1","gneg"],[99000000,101600000,"q22.2","gpos25"],[101600000,106200000,"q22.3","gneg"],[106200000,110500000,"q23.1","gpos75"],[110500000,112100000,"q23.2","gneg"],[112100000,117700000,"q23.3","gpos100"],[117700000,119200000,"q24.11","gneg"],[119200000,122500000,"q24.12","gpos50"],[122500000,127300000,"q24.13","gneg"],[127300000,131500000,"q24.21","gpos50"],[131500000,136400000,"q24.22","gneg"],[136400000,139900000,"q24.23","gpos75"],[139900000,146364022,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,38400000,"p13.2","gpos25"],[38400000,41000000,"p13.1","gneg"],[41000000,43600000,"p12","gpos50"],[43600000,47300000,"p11.2","gneg"],[47300000,49000000,"p11.1","acen"],[49000000,50700000,"q11","acen"],[50700000,65900000,"q12","gvar"],[65900000,68700000,"q13","gneg"],[68700000,72200000,"q21.11","gpos25"],[72200000,74000000,"q21.12","gneg"],[74000000,79200000,"q21.13","gpos50"],[79200000,81100000,"q21.2","gneg"],[81100000,84100000,"q21.31","gpos50"],[84100000,86900000,"q21.32","gneg"],[86900000,90400000,"q21.33","gpos50"],[90400000,91800000,"q22.1","gneg"],[91800000,93900000,"q22.2","gpos25"],[93900000,96600000,"q22.31","gneg"],[96600000,99300000,"q22.32","gpos25"],[99300000,102600000,"q22.33","gneg"],[102600000,108200000,"q31.1","gpos100"],[108200000,111300000,"q31.2","gneg"],[111300000,114900000,"q31.3","gpos25"],[114900000,117700000,"q32","gneg"],[117700000,122500000,"q33.1","gpos75"],[122500000,125800000,"q33.2","gneg"],[125800000,130300000,"q33.3","gpos25"],[130300000,133500000,"q34.11","gneg"],[133500000,134000000,"q34.12","gpos25"],[134000000,135900000,"q34.13","gneg"],[135900000,137400000,"q34.2","gpos25"],[137400000,141213431,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18600000,"p12.33","gpos75"],[18600000,18700000,"p12.32","gneg"],[18700000,22600000,"p12.31","gpos75"],[22600000,24600000,"p12.2","gneg"],[24600000,29600000,"p12.1","gpos50"],[29600000,31300000,"p11.23","gneg"],[31300000,34400000,"p11.22","gpos25"],[34400000,38000000,"p11.21","gneg"],[38000000,40200000,"p11.1","acen"],[40200000,42300000,"q11.1","acen"],[42300000,46100000,"q11.21","gneg"],[46100000,49900000,"q11.22","gpos25"],[49900000,52900000,"q11.23","gneg"],[52900000,61200000,"q21.1","gpos100"],[61200000,64500000,"q21.2","gneg"],[64500000,70600000,"q21.3","gpos100"],[70600000,74900000,"q22.1","gneg"],[74900000,77700000,"q22.2","gpos50"],[77700000,82000000,"q22.3","gneg"],[82000000,87900000,"q23.1","gpos100"],[87900000,89500000,"q23.2","gneg"],[89500000,92900000,"q23.31","gpos75"],[92900000,94100000,"q23.32","gneg"],[94100000,97000000,"q23.33","gpos50"],[97000000,99300000,"q24.1","gneg"],[99300000,101900000,"q24.2","gpos50"],[101900000,103000000,"q24.31","gneg"],[103000000,104900000,"q24.32","gpos25"],[104900000,105800000,"q24.33","gneg"],[105800000,111900000,"q25.1","gpos100"],[111900000,114900000,"q25.2","gneg"],[114900000,119100000,"q25.3","gpos75"],[119100000,121700000,"q26.11","gneg"],[121700000,123100000,"q26.12","gpos50"],[123100000,127500000,"q26.13","gneg"],[127500000,130600000,"q26.2","gpos50"],[130600000,135534747,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,10700000,"p15.4","gpos50"],[10700000,12700000,"p15.3","gneg"],[12700000,16200000,"p15.2","gpos50"],[16200000,21700000,"p15.1","gneg"],[21700000,26100000,"p14.3","gpos100"],[26100000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43500000,"p12","gpos100"],[43500000,48800000,"p11.2","gneg"],[48800000,51600000,"p11.12","gpos75"],[51600000,53700000,"p11.11","acen"],[53700000,55700000,"q11","acen"],[55700000,59900000,"q12.1","gpos75"],[59900000,61700000,"q12.2","gneg"],[61700000,63400000,"q12.3","gpos25"],[63400000,65900000,"q13.1","gneg"],[65900000,68400000,"q13.2","gpos25"],[68400000,70400000,"q13.3","gneg"],[70400000,75200000,"q13.4","gpos50"],[75200000,77100000,"q13.5","gneg"],[77100000,85600000,"q14.1","gpos100"],[85600000,88300000,"q14.2","gneg"],[88300000,92800000,"q14.3","gpos100"],[92800000,97200000,"q21","gneg"],[97200000,102100000,"q22.1","gpos100"],[102100000,102900000,"q22.2","gneg"],[102900000,110400000,"q22.3","gpos100"],[110400000,112500000,"q23.1","gneg"],[112500000,114500000,"q23.2","gpos50"],[114500000,121200000,"q23.3","gneg"],[121200000,123900000,"q24.1","gpos50"],[123900000,127800000,"q24.2","gneg"],[127800000,130800000,"q24.3","gpos50"],[130800000,135006516,"q25","gneg"]],12:[[0,3300000,"p13.33","gneg"],[3300000,5400000,"p13.32","gpos25"],[5400000,10100000,"p13.31","gneg"],[10100000,12800000,"p13.2","gpos75"],[12800000,14800000,"p13.1","gneg"],[14800000,20000000,"p12.3","gpos100"],[20000000,21300000,"p12.2","gneg"],[21300000,26500000,"p12.1","gpos100"],[26500000,27800000,"p11.23","gneg"],[27800000,30700000,"p11.22","gpos50"],[30700000,33300000,"p11.21","gneg"],[33300000,35800000,"p11.1","acen"],[35800000,38200000,"q11","acen"],[38200000,46400000,"q12","gpos100"],[46400000,49100000,"q13.11","gneg"],[49100000,51500000,"q13.12","gpos25"],[51500000,54900000,"q13.13","gneg"],[54900000,56600000,"q13.2","gpos25"],[56600000,58100000,"q13.3","gneg"],[58100000,63100000,"q14.1","gpos75"],[63100000,65100000,"q14.2","gneg"],[65100000,67700000,"q14.3","gpos50"],[67700000,71500000,"q15","gneg"],[71500000,75700000,"q21.1","gpos75"],[75700000,80300000,"q21.2","gneg"],[80300000,86700000,"q21.31","gpos100"],[86700000,89000000,"q21.32","gneg"],[89000000,92600000,"q21.33","gpos100"],[92600000,96200000,"q22","gneg"],[96200000,101600000,"q23.1","gpos75"],[101600000,103800000,"q23.2","gneg"],[103800000,109000000,"q23.3","gpos50"],[109000000,111700000,"q24.11","gneg"],[111700000,112300000,"q24.12","gpos25"],[112300000,114300000,"q24.13","gneg"],[114300000,116800000,"q24.21","gpos50"],[116800000,118100000,"q24.22","gneg"],[118100000,120700000,"q24.23","gpos50"],[120700000,125900000,"q24.31","gneg"],[125900000,129300000,"q24.32","gpos50"],[129300000,133851895,"q24.33","gneg"]],13:[[0,4500000,"p13","gvar"],[4500000,10000000,"p12","stalk"],[10000000,16300000,"p11.2","gvar"],[16300000,17900000,"p11.1","acen"],[17900000,19500000,"q11","acen"],[19500000,23300000,"q12.11","gneg"],[23300000,25500000,"q12.12","gpos25"],[25500000,27800000,"q12.13","gneg"],[27800000,28900000,"q12.2","gpos25"],[28900000,32200000,"q12.3","gneg"],[32200000,34000000,"q13.1","gpos50"],[34000000,35500000,"q13.2","gneg"],[35500000,40100000,"q13.3","gpos75"],[40100000,45200000,"q14.11","gneg"],[45200000,45800000,"q14.12","gpos25"],[45800000,47300000,"q14.13","gneg"],[47300000,50900000,"q14.2","gpos50"],[50900000,55300000,"q14.3","gneg"],[55300000,59600000,"q21.1","gpos100"],[59600000,62300000,"q21.2","gneg"],[62300000,65700000,"q21.31","gpos75"],[65700000,68600000,"q21.32","gneg"],[68600000,73300000,"q21.33","gpos100"],[73300000,75400000,"q22.1","gneg"],[75400000,77200000,"q22.2","gpos50"],[77200000,79000000,"q22.3","gneg"],[79000000,87700000,"q31.1","gpos100"],[87700000,90000000,"q31.2","gneg"],[90000000,95000000,"q31.3","gpos100"],[95000000,98200000,"q32.1","gneg"],[98200000,99300000,"q32.2","gpos25"],[99300000,101700000,"q32.3","gneg"],[101700000,104800000,"q33.1","gpos100"],[104800000,107000000,"q33.2","gneg"],[107000000,110300000,"q33.3","gpos100"],[110300000,115169878,"q34","gneg"]],14:[[0,3700000,"p13","gvar"],[3700000,8100000,"p12","stalk"],[8100000,16100000,"p11.2","gvar"],[16100000,17600000,"p11.1","acen"],[17600000,19100000,"q11.1","acen"],[19100000,24600000,"q11.2","gneg"],[24600000,33300000,"q12","gpos100"],[33300000,35300000,"q13.1","gneg"],[35300000,36600000,"q13.2","gpos50"],[36600000,37800000,"q13.3","gneg"],[37800000,43500000,"q21.1","gpos100"],[43500000,47200000,"q21.2","gneg"],[47200000,50900000,"q21.3","gpos100"],[50900000,54100000,"q22.1","gneg"],[54100000,55500000,"q22.2","gpos25"],[55500000,58100000,"q22.3","gneg"],[58100000,62100000,"q23.1","gpos75"],[62100000,64800000,"q23.2","gneg"],[64800000,67900000,"q23.3","gpos50"],[67900000,70200000,"q24.1","gneg"],[70200000,73800000,"q24.2","gpos50"],[73800000,79300000,"q24.3","gneg"],[79300000,83600000,"q31.1","gpos100"],[83600000,84900000,"q31.2","gneg"],[84900000,89800000,"q31.3","gpos100"],[89800000,91900000,"q32.11","gneg"],[91900000,94700000,"q32.12","gpos25"],[94700000,96300000,"q32.13","gneg"],[96300000,101400000,"q32.2","gpos50"],[101400000,103200000,"q32.31","gneg"],[103200000,104000000,"q32.32","gpos50"],[104000000,107349540,"q32.33","gneg"]],15:[[0,3900000,"p13","gvar"],[3900000,8700000,"p12","stalk"],[8700000,15800000,"p11.2","gvar"],[15800000,19000000,"p11.1","acen"],[19000000,20700000,"q11.1","acen"],[20700000,25700000,"q11.2","gneg"],[25700000,28100000,"q12","gpos50"],[28100000,30300000,"q13.1","gneg"],[30300000,31200000,"q13.2","gpos50"],[31200000,33600000,"q13.3","gneg"],[33600000,40100000,"q14","gpos75"],[40100000,42800000,"q15.1","gneg"],[42800000,43600000,"q15.2","gpos25"],[43600000,44800000,"q15.3","gneg"],[44800000,49500000,"q21.1","gpos75"],[49500000,52900000,"q21.2","gneg"],[52900000,59100000,"q21.3","gpos75"],[59100000,59300000,"q22.1","gneg"],[59300000,63700000,"q22.2","gpos25"],[63700000,67200000,"q22.31","gneg"],[67200000,67300000,"q22.32","gpos25"],[67300000,67500000,"q22.33","gneg"],[67500000,72700000,"q23","gpos25"],[72700000,75200000,"q24.1","gneg"],[75200000,76600000,"q24.2","gpos25"],[76600000,78300000,"q24.3","gneg"],[78300000,81700000,"q25.1","gpos50"],[81700000,85200000,"q25.2","gneg"],[85200000,89100000,"q25.3","gpos50"],[89100000,94300000,"q26.1","gneg"],[94300000,98500000,"q26.2","gpos50"],[98500000,102531392,"q26.3","gneg"]],16:[[0,7900000,"p13.3","gneg"],[7900000,10500000,"p13.2","gpos50"],[10500000,12600000,"p13.13","gneg"],[12600000,14800000,"p13.12","gpos50"],[14800000,16800000,"p13.11","gneg"],[16800000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28100000,"p12.1","gpos50"],[28100000,34600000,"p11.2","gneg"],[34600000,36600000,"p11.1","acen"],[36600000,38600000,"q11.1","acen"],[38600000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56700000,"q12.2","gpos50"],[56700000,57400000,"q13","gneg"],[57400000,66700000,"q21","gpos100"],[66700000,70800000,"q22.1","gneg"],[70800000,72900000,"q22.2","gpos50"],[72900000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81700000,"q23.2","gneg"],[81700000,84200000,"q23.3","gpos50"],[84200000,87100000,"q24.1","gneg"],[87100000,88700000,"q24.2","gpos25"],[88700000,90354753,"q24.3","gneg"]],17:[[0,3300000,"p13.3","gneg"],[3300000,6500000,"p13.2","gpos50"],[6500000,10700000,"p13.1","gneg"],[10700000,16000000,"p12","gpos75"],[16000000,22200000,"p11.2","gneg"],[22200000,24000000,"p11.1","acen"],[24000000,25800000,"q11.1","acen"],[25800000,31800000,"q11.2","gneg"],[31800000,38100000,"q12","gpos50"],[38100000,38400000,"q21.1","gneg"],[38400000,40900000,"q21.2","gpos25"],[40900000,44900000,"q21.31","gneg"],[44900000,47400000,"q21.32","gpos25"],[47400000,50200000,"q21.33","gneg"],[50200000,57600000,"q22","gpos75"],[57600000,58300000,"q23.1","gneg"],[58300000,61100000,"q23.2","gpos75"],[61100000,62600000,"q23.3","gneg"],[62600000,64200000,"q24.1","gpos50"],[64200000,67100000,"q24.2","gneg"],[67100000,70900000,"q24.3","gpos75"],[70900000,74800000,"q25.1","gneg"],[74800000,75300000,"q25.2","gpos25"],[75300000,81195210,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7100000,"p11.31","gpos50"],[7100000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,17200000,"p11.1","acen"],[17200000,19000000,"q11.1","acen"],[19000000,25000000,"q11.2","gneg"],[25000000,32700000,"q12.1","gpos100"],[32700000,37200000,"q12.2","gneg"],[37200000,43500000,"q12.3","gpos75"],[43500000,48200000,"q21.1","gneg"],[48200000,53800000,"q21.2","gpos75"],[53800000,56200000,"q21.31","gneg"],[56200000,59000000,"q21.32","gpos50"],[59000000,61600000,"q21.33","gneg"],[61600000,66800000,"q22.1","gpos100"],[66800000,68700000,"q22.2","gneg"],[68700000,73100000,"q22.3","gpos25"],[73100000,78077248,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,13900000,"p13.2","gpos25"],[13900000,14000000,"p13.13","gneg"],[14000000,16300000,"p13.12","gpos25"],[16300000,20000000,"p13.11","gneg"],[20000000,24400000,"p12","gvar"],[24400000,26500000,"p11","acen"],[26500000,28600000,"q11","acen"],[28600000,32400000,"q12","gvar"],[32400000,35500000,"q13.11","gneg"],[35500000,38300000,"q13.12","gpos25"],[38300000,38700000,"q13.13","gneg"],[38700000,43400000,"q13.2","gpos25"],[43400000,45200000,"q13.31","gneg"],[45200000,48000000,"q13.32","gpos25"],[48000000,51400000,"q13.33","gneg"],[51400000,53600000,"q13.41","gpos25"],[53600000,56300000,"q13.42","gneg"],[56300000,59128983,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12100000,"p12.2","gneg"],[12100000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25600000,"p11.21","gneg"],[25600000,27500000,"p11.1","acen"],[27500000,29400000,"q11.1","acen"],[29400000,32100000,"q11.21","gneg"],[32100000,34400000,"q11.22","gpos25"],[34400000,37600000,"q11.23","gneg"],[37600000,41700000,"q12","gpos75"],[41700000,42100000,"q13.11","gneg"],[42100000,46400000,"q13.12","gpos25"],[46400000,49800000,"q13.13","gneg"],[49800000,55000000,"q13.2","gpos75"],[55000000,56500000,"q13.31","gneg"],[56500000,58400000,"q13.32","gpos50"],[58400000,63025520,"q13.33","gneg"]],21:[[0,2800000,"p13","gvar"],[2800000,6800000,"p12","stalk"],[6800000,10900000,"p11.2","gvar"],[10900000,13200000,"p11.1","acen"],[13200000,14300000,"q11.1","acen"],[14300000,16400000,"q11.2","gneg"],[16400000,24000000,"q21.1","gpos100"],[24000000,26800000,"q21.2","gneg"],[26800000,31500000,"q21.3","gpos75"],[31500000,35800000,"q22.11","gneg"],[35800000,37800000,"q22.12","gpos50"],[37800000,39700000,"q22.13","gneg"],[39700000,42600000,"q22.2","gpos50"],[42600000,48129895,"q22.3","gneg"]],22:[[0,3800000,"p13","gvar"],[3800000,8300000,"p12","stalk"],[8300000,12200000,"p11.2","gvar"],[12200000,14700000,"p11.1","acen"],[14700000,17900000,"q11.1","acen"],[17900000,22200000,"q11.21","gneg"],[22200000,23500000,"q11.22","gpos25"],[23500000,25900000,"q11.23","gneg"],[25900000,29600000,"q12.1","gpos50"],[29600000,32200000,"q12.2","gneg"],[32200000,37600000,"q12.3","gpos50"],[37600000,41000000,"q13.1","gneg"],[41000000,44200000,"q13.2","gpos50"],[44200000,48400000,"q13.31","gneg"],[48400000,49400000,"q13.32","gpos50"],[49400000,51304566,"q13.33","gneg"]],X:[[0,4300000,"p22.33","gneg"],[4300000,6000000,"p22.32","gpos50"],[6000000,9500000,"p22.31","gneg"],[9500000,17100000,"p22.2","gpos50"],[17100000,19300000,"p22.13","gneg"],[19300000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37600000,"p21.1","gpos100"],[37600000,42400000,"p11.4","gneg"],[42400000,46400000,"p11.3","gpos75"],[46400000,49800000,"p11.23","gneg"],[49800000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,60600000,"p11.1","acen"],[60600000,63000000,"q11.1","acen"],[63000000,64600000,"q11.2","gneg"],[64600000,67800000,"q12","gpos50"],[67800000,71800000,"q13.1","gneg"],[71800000,73900000,"q13.2","gpos50"],[73900000,76000000,"q13.3","gneg"],[76000000,84600000,"q21.1","gpos100"],[84600000,86200000,"q21.2","gneg"],[86200000,91800000,"q21.31","gpos100"],[91800000,93500000,"q21.32","gneg"],[93500000,98300000,"q21.33","gpos75"],[98300000,102600000,"q22.1","gneg"],[102600000,103700000,"q22.2","gpos50"],[103700000,108700000,"q22.3","gneg"],[108700000,116500000,"q23","gpos75"],[116500000,120900000,"q24","gneg"],[120900000,128700000,"q25","gpos100"],[128700000,130400000,"q26.1","gneg"],[130400000,133600000,"q26.2","gpos25"],[133600000,138000000,"q26.3","gneg"],[138000000,140300000,"q27.1","gpos75"],[140300000,142100000,"q27.2","gneg"],[142100000,147100000,"q27.3","gpos100"],[147100000,155270560,"q28","gneg"]],Y:[[0,2500000,"p11.32","gneg"],[2500000,3000000,"p11.31","gpos50"],[3000000,11600000,"p11.2","gneg"],[11600000,12500000,"p11.1","acen"],[12500000,13400000,"q11.1","acen"],[13400000,15100000,"q11.21","gneg"],[15100000,19800000,"q11.221","gpos50"],[19800000,22100000,"q11.222","gneg"],[22100000,26200000,"q11.223","gpos50"],[26200000,28800000,"q11.23","gneg"],[28800000,59373566,"q12","gvar"]]}},hg38:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5300000,"p36.32","gpos25"],[5300000,7100000,"p36.31","gneg"],[7100000,9100000,"p36.23","gpos25"],[9100000,12500000,"p36.22","gneg"],[12500000,15900000,"p36.21","gpos50"],[15900000,20100000,"p36.13","gneg"],[20100000,23600000,"p36.12","gpos25"],[23600000,27600000,"p36.11","gneg"],[27600000,29900000,"p35.3","gpos25"],[29900000,32300000,"p35.2","gneg"],[32300000,34300000,"p35.1","gpos25"],[34300000,39600000,"p34.3","gneg"],[39600000,43700000,"p34.2","gpos25"],[43700000,46300000,"p34.1","gneg"],[46300000,50200000,"p33","gpos75"],[50200000,55600000,"p32.3","gneg"],[55600000,58500000,"p32.2","gpos50"],[58500000,60800000,"p32.1","gneg"],[60800000,68500000,"p31.3","gpos50"],[68500000,69300000,"p31.2","gneg"],[69300000,84400000,"p31.1","gpos100"],[84400000,87900000,"p22.3","gneg"],[87900000,91500000,"p22.2","gpos75"],[91500000,94300000,"p22.1","gneg"],[94300000,99300000,"p21.3","gpos75"],[99300000,101800000,"p21.2","gneg"],[101800000,106700000,"p21.1","gpos100"],[106700000,111200000,"p13.3","gneg"],[111200000,115500000,"p13.2","gpos50"],[115500000,117200000,"p13.1","gneg"],[117200000,120400000,"p12","gpos50"],[120400000,121700000,"p11.2","gneg"],[121700000,123400000,"p11.1","acen"],[123400000,125100000,"q11","acen"],[125100000,143200000,"q12","gvar"],[143200000,147500000,"q21.1","gneg"],[147500000,150600000,"q21.2","gpos50"],[150600000,155100000,"q21.3","gneg"],[155100000,156600000,"q22","gpos50"],[156600000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,173000000,"q24.3","gpos75"],[173000000,176100000,"q25.1","gneg"],[176100000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207100000,"q32.1","gneg"],[207100000,211300000,"q32.2","gpos25"],[211300000,214400000,"q32.3","gneg"],[214400000,223900000,"q41","gpos100"],[223900000,224400000,"q42.11","gneg"],[224400000,226800000,"q42.12","gpos25"],[226800000,230500000,"q42.13","gneg"],[230500000,234600000,"q42.2","gpos50"],[234600000,236400000,"q42.3","gneg"],[236400000,243500000,"q43","gpos75"],[243500000,248956422,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,6900000,"p25.2","gpos50"],[6900000,12000000,"p25.1","gneg"],[12000000,16500000,"p24.3","gpos75"],[16500000,19000000,"p24.2","gneg"],[19000000,23800000,"p24.1","gpos75"],[23800000,27700000,"p23.3","gneg"],[27700000,29800000,"p23.2","gpos25"],[29800000,31800000,"p23.1","gneg"],[31800000,36300000,"p22.3","gpos75"],[36300000,38300000,"p22.2","gneg"],[38300000,41500000,"p22.1","gpos50"],[41500000,47500000,"p21","gneg"],[47500000,52600000,"p16.3","gpos100"],[52600000,54700000,"p16.2","gneg"],[54700000,61000000,"p16.1","gpos100"],[61000000,63900000,"p15","gneg"],[63900000,68400000,"p14","gpos50"],[68400000,71300000,"p13.3","gneg"],[71300000,73300000,"p13.2","gpos50"],[73300000,74800000,"p13.1","gneg"],[74800000,83100000,"p12","gpos100"],[83100000,91800000,"p11.2","gneg"],[91800000,93900000,"p11.1","acen"],[93900000,96000000,"q11.1","acen"],[96000000,102100000,"q11.2","gneg"],[102100000,105300000,"q12.1","gpos50"],[105300000,106700000,"q12.2","gneg"],[106700000,108700000,"q12.3","gpos25"],[108700000,112200000,"q13","gneg"],[112200000,118100000,"q14.1","gpos50"],[118100000,121600000,"q14.2","gneg"],[121600000,129100000,"q14.3","gpos50"],[129100000,131700000,"q21.1","gneg"],[131700000,134300000,"q21.2","gpos25"],[134300000,136100000,"q21.3","gneg"],[136100000,141500000,"q22.1","gpos100"],[141500000,143400000,"q22.2","gneg"],[143400000,147900000,"q22.3","gpos100"],[147900000,149000000,"q23.1","gneg"],[149000000,149600000,"q23.2","gpos25"],[149600000,154000000,"q23.3","gneg"],[154000000,158900000,"q24.1","gpos75"],[158900000,162900000,"q24.2","gneg"],[162900000,168900000,"q24.3","gpos75"],[168900000,177100000,"q31.1","gneg"],[177100000,179700000,"q31.2","gpos50"],[179700000,182100000,"q31.3","gneg"],[182100000,188500000,"q32.1","gpos75"],[188500000,191100000,"q32.2","gneg"],[191100000,196600000,"q32.3","gpos75"],[196600000,202500000,"q33.1","gneg"],[202500000,204100000,"q33.2","gpos50"],[204100000,208200000,"q33.3","gneg"],[208200000,214500000,"q34","gpos100"],[214500000,220700000,"q35","gneg"],[220700000,224300000,"q36.1","gpos75"],[224300000,225200000,"q36.2","gneg"],[225200000,230100000,"q36.3","gpos100"],[230100000,234700000,"q37.1","gneg"],[234700000,236400000,"q37.2","gpos50"],[236400000,242193529,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8100000,"p26.1","gpos50"],[8100000,11600000,"p25.3","gneg"],[11600000,13200000,"p25.2","gpos25"],[13200000,16300000,"p25.1","gneg"],[16300000,23800000,"p24.3","gpos100"],[23800000,26300000,"p24.2","gneg"],[26300000,30800000,"p24.1","gpos75"],[30800000,32000000,"p23","gneg"],[32000000,36400000,"p22.3","gpos50"],[36400000,39300000,"p22.2","gneg"],[39300000,43600000,"p22.1","gpos75"],[43600000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63800000,"p14.2","gneg"],[63800000,69700000,"p14.1","gpos50"],[69700000,74100000,"p13","gneg"],[74100000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87100000,"p12.1","gpos75"],[87100000,87800000,"p11.2","gneg"],[87800000,90900000,"p11.1","acen"],[90900000,94000000,"q11.1","acen"],[94000000,98600000,"q11.2","gvar"],[98600000,100300000,"q12.1","gneg"],[100300000,101200000,"q12.2","gpos25"],[101200000,103100000,"q12.3","gneg"],[103100000,106500000,"q13.11","gpos75"],[106500000,108200000,"q13.12","gneg"],[108200000,111600000,"q13.13","gpos50"],[111600000,113700000,"q13.2","gneg"],[113700000,117600000,"q13.31","gpos75"],[117600000,119300000,"q13.32","gneg"],[119300000,122200000,"q13.33","gpos75"],[122200000,124100000,"q21.1","gneg"],[124100000,126100000,"q21.2","gpos25"],[126100000,129500000,"q21.3","gneg"],[129500000,134000000,"q22.1","gpos25"],[134000000,136000000,"q22.2","gneg"],[136000000,139000000,"q22.3","gpos25"],[139000000,143100000,"q23","gneg"],[143100000,149200000,"q24","gpos100"],[149200000,152300000,"q25.1","gneg"],[152300000,155300000,"q25.2","gpos50"],[155300000,157300000,"q25.31","gneg"],[157300000,159300000,"q25.32","gpos50"],[159300000,161000000,"q25.33","gneg"],[161000000,167900000,"q26.1","gpos100"],[167900000,171200000,"q26.2","gneg"],[171200000,176000000,"q26.31","gpos75"],[176000000,179300000,"q26.32","gneg"],[179300000,183000000,"q26.33","gpos75"],[183000000,184800000,"q27.1","gneg"],[184800000,186300000,"q27.2","gpos25"],[186300000,188200000,"q27.3","gneg"],[188200000,192600000,"q28","gpos75"],[192600000,198295559,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15000000,"p15.33","gpos50"],[15000000,17700000,"p15.32","gneg"],[17700000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50000000,"p11","acen"],[50000000,51800000,"q11","acen"],[51800000,58500000,"q12","gneg"],[58500000,65500000,"q13.1","gpos100"],[65500000,69400000,"q13.2","gneg"],[69400000,75300000,"q13.3","gpos75"],[75300000,78000000,"q21.1","gneg"],[78000000,81500000,"q21.21","gpos50"],[81500000,83200000,"q21.22","gneg"],[83200000,86000000,"q21.23","gpos25"],[86000000,87100000,"q21.3","gneg"],[87100000,92800000,"q22.1","gpos75"],[92800000,94200000,"q22.2","gneg"],[94200000,97900000,"q22.3","gpos75"],[97900000,100100000,"q23","gneg"],[100100000,106700000,"q24","gpos50"],[106700000,113200000,"q25","gneg"],[113200000,119900000,"q26","gpos75"],[119900000,122800000,"q27","gneg"],[122800000,127900000,"q28.1","gpos50"],[127900000,130100000,"q28.2","gneg"],[130100000,138500000,"q28.3","gpos100"],[138500000,140600000,"q31.1","gneg"],[140600000,145900000,"q31.21","gpos25"],[145900000,147500000,"q31.22","gneg"],[147500000,150200000,"q31.23","gpos25"],[150200000,154600000,"q31.3","gneg"],[154600000,160800000,"q32.1","gpos100"],[160800000,163600000,"q32.2","gneg"],[163600000,169200000,"q32.3","gpos100"],[169200000,171000000,"q33","gneg"],[171000000,175400000,"q34.1","gpos75"],[175400000,176600000,"q34.2","gneg"],[176600000,182300000,"q34.3","gpos100"],[182300000,186200000,"q35.1","gneg"],[186200000,190214555,"q35.2","gpos25"]],5:[[0,4400000,"p15.33","gneg"],[4400000,6300000,"p15.32","gpos25"],[6300000,9900000,"p15.31","gneg"],[9900000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48800000,"p11","acen"],[48800000,51400000,"q11.1","acen"],[51400000,59600000,"q11.2","gneg"],[59600000,63600000,"q12.1","gpos75"],[63600000,63900000,"q12.2","gneg"],[63900000,67400000,"q12.3","gpos75"],[67400000,69100000,"q13.1","gneg"],[69100000,74000000,"q13.2","gpos50"],[74000000,77600000,"q13.3","gneg"],[77600000,82100000,"q14.1","gpos50"],[82100000,83500000,"q14.2","gneg"],[83500000,93000000,"q14.3","gpos100"],[93000000,98900000,"q15","gneg"],[98900000,103400000,"q21.1","gpos100"],[103400000,105100000,"q21.2","gneg"],[105100000,110200000,"q21.3","gpos100"],[110200000,112200000,"q22.1","gneg"],[112200000,113800000,"q22.2","gpos50"],[113800000,115900000,"q22.3","gneg"],[115900000,122100000,"q23.1","gpos100"],[122100000,127900000,"q23.2","gneg"],[127900000,131200000,"q23.3","gpos100"],[131200000,136900000,"q31.1","gneg"],[136900000,140100000,"q31.2","gpos25"],[140100000,145100000,"q31.3","gneg"],[145100000,150400000,"q32","gpos75"],[150400000,153300000,"q33.1","gneg"],[153300000,156300000,"q33.2","gpos50"],[156300000,160500000,"q33.3","gneg"],[160500000,169000000,"q34","gpos100"],[169000000,173300000,"q35.1","gneg"],[173300000,177100000,"q35.2","gpos25"],[177100000,181538259,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27100000,"p22.2","gneg"],[27100000,30500000,"p22.1","gpos50"],[30500000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,53000000,"p12.2","gneg"],[53000000,57200000,"p12.1","gpos100"],[57200000,58500000,"p11.2","gneg"],[58500000,59800000,"p11.1","acen"],[59800000,62600000,"q11.1","acen"],[62600000,62700000,"q11.2","gneg"],[62700000,69200000,"q12","gpos100"],[69200000,75200000,"q13","gneg"],[75200000,83200000,"q14.1","gpos50"],[83200000,84200000,"q14.2","gneg"],[84200000,87300000,"q14.3","gpos50"],[87300000,92500000,"q15","gneg"],[92500000,98900000,"q16.1","gpos100"],[98900000,100000000,"q16.2","gneg"],[100000000,105000000,"q16.3","gpos100"],[105000000,114200000,"q21","gneg"],[114200000,117900000,"q22.1","gpos75"],[117900000,118100000,"q22.2","gneg"],[118100000,125800000,"q22.31","gpos100"],[125800000,126800000,"q22.32","gneg"],[126800000,130000000,"q22.33","gpos75"],[130000000,130900000,"q23.1","gneg"],[130900000,134700000,"q23.2","gpos50"],[134700000,138300000,"q23.3","gneg"],[138300000,142200000,"q24.1","gpos75"],[142200000,145100000,"q24.2","gneg"],[145100000,148500000,"q24.3","gpos75"],[148500000,152100000,"q25.1","gneg"],[152100000,155200000,"q25.2","gpos50"],[155200000,160600000,"q25.3","gneg"],[160600000,164100000,"q26","gpos50"],[164100000,170805979,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7200000,"p22.1","gneg"],[7200000,13700000,"p21.3","gpos100"],[13700000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,27900000,"p15.2","gpos50"],[27900000,28800000,"p15.1","gneg"],[28800000,34900000,"p14.3","gpos75"],[34900000,37100000,"p14.2","gneg"],[37100000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,53900000,"p12.1","gpos75"],[53900000,58100000,"p11.2","gneg"],[58100000,60100000,"p11.1","acen"],[60100000,62100000,"q11.1","acen"],[62100000,67500000,"q11.21","gneg"],[67500000,72700000,"q11.22","gpos50"],[72700000,77900000,"q11.23","gneg"],[77900000,86700000,"q21.11","gpos100"],[86700000,88500000,"q21.12","gneg"],[88500000,91500000,"q21.13","gpos75"],[91500000,93300000,"q21.2","gneg"],[93300000,98400000,"q21.3","gpos75"],[98400000,104200000,"q22.1","gneg"],[104200000,104900000,"q22.2","gpos50"],[104900000,107800000,"q22.3","gneg"],[107800000,115000000,"q31.1","gpos75"],[115000000,117700000,"q31.2","gneg"],[117700000,121400000,"q31.31","gpos75"],[121400000,124100000,"q31.32","gneg"],[124100000,127500000,"q31.33","gpos75"],[127500000,129600000,"q32.1","gneg"],[129600000,130800000,"q32.2","gpos25"],[130800000,132900000,"q32.3","gneg"],[132900000,138500000,"q33","gpos50"],[138500000,143400000,"q34","gneg"],[143400000,148200000,"q35","gpos75"],[148200000,152800000,"q36.1","gneg"],[152800000,155200000,"q36.2","gpos25"],[155200000,159345973,"q36.3","gneg"]],8:[[0,2300000,"p23.3","gneg"],[2300000,6300000,"p23.2","gpos75"],[6300000,12800000,"p23.1","gneg"],[12800000,19200000,"p22","gpos100"],[19200000,23500000,"p21.3","gneg"],[23500000,27500000,"p21.2","gpos50"],[27500000,29000000,"p21.1","gneg"],[29000000,36700000,"p12","gpos75"],[36700000,38500000,"p11.23","gneg"],[38500000,39900000,"p11.22","gpos25"],[39900000,43200000,"p11.21","gneg"],[43200000,45200000,"p11.1","acen"],[45200000,47200000,"q11.1","acen"],[47200000,51300000,"q11.21","gneg"],[51300000,51700000,"q11.22","gpos75"],[51700000,54600000,"q11.23","gneg"],[54600000,60600000,"q12.1","gpos50"],[60600000,61300000,"q12.2","gneg"],[61300000,65100000,"q12.3","gpos50"],[65100000,67100000,"q13.1","gneg"],[67100000,69600000,"q13.2","gpos50"],[69600000,72000000,"q13.3","gneg"],[72000000,74600000,"q21.11","gpos100"],[74600000,74700000,"q21.12","gneg"],[74700000,83500000,"q21.13","gpos75"],[83500000,85900000,"q21.2","gneg"],[85900000,92300000,"q21.3","gpos100"],[92300000,97900000,"q22.1","gneg"],[97900000,100500000,"q22.2","gpos25"],[100500000,105100000,"q22.3","gneg"],[105100000,109500000,"q23.1","gpos75"],[109500000,111100000,"q23.2","gneg"],[111100000,116700000,"q23.3","gpos100"],[116700000,118300000,"q24.11","gneg"],[118300000,121500000,"q24.12","gpos50"],[121500000,126300000,"q24.13","gneg"],[126300000,130400000,"q24.21","gpos50"],[130400000,135400000,"q24.22","gneg"],[135400000,138900000,"q24.23","gpos75"],[138900000,145138636,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,37900000,"p13.2","gpos25"],[37900000,39000000,"p13.1","gneg"],[39000000,40000000,"p12","gpos50"],[40000000,42200000,"p11.2","gneg"],[42200000,43000000,"p11.1","acen"],[43000000,45500000,"q11","acen"],[45500000,61500000,"q12","gvar"],[61500000,65000000,"q13","gneg"],[65000000,69300000,"q21.11","gpos25"],[69300000,71300000,"q21.12","gneg"],[71300000,76600000,"q21.13","gpos50"],[76600000,78500000,"q21.2","gneg"],[78500000,81500000,"q21.31","gpos50"],[81500000,84300000,"q21.32","gneg"],[84300000,87800000,"q21.33","gpos50"],[87800000,89200000,"q22.1","gneg"],[89200000,91200000,"q22.2","gpos25"],[91200000,93900000,"q22.31","gneg"],[93900000,96500000,"q22.32","gpos25"],[96500000,99800000,"q22.33","gneg"],[99800000,105400000,"q31.1","gpos100"],[105400000,108500000,"q31.2","gneg"],[108500000,112100000,"q31.3","gpos25"],[112100000,114900000,"q32","gneg"],[114900000,119800000,"q33.1","gpos75"],[119800000,123100000,"q33.2","gneg"],[123100000,127500000,"q33.3","gpos25"],[127500000,130600000,"q34.11","gneg"],[130600000,131100000,"q34.12","gpos25"],[131100000,133100000,"q34.13","gneg"],[133100000,134500000,"q34.2","gpos25"],[134500000,138394717,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18300000,"p12.33","gpos75"],[18300000,18400000,"p12.32","gneg"],[18400000,22300000,"p12.31","gpos75"],[22300000,24300000,"p12.2","gneg"],[24300000,29300000,"p12.1","gpos50"],[29300000,31100000,"p11.23","gneg"],[31100000,34200000,"p11.22","gpos25"],[34200000,38000000,"p11.21","gneg"],[38000000,39800000,"p11.1","acen"],[39800000,41600000,"q11.1","acen"],[41600000,45500000,"q11.21","gneg"],[45500000,48600000,"q11.22","gpos25"],[48600000,51100000,"q11.23","gneg"],[51100000,59400000,"q21.1","gpos100"],[59400000,62800000,"q21.2","gneg"],[62800000,68800000,"q21.3","gpos100"],[68800000,73100000,"q22.1","gneg"],[73100000,75900000,"q22.2","gpos50"],[75900000,80300000,"q22.3","gneg"],[80300000,86100000,"q23.1","gpos100"],[86100000,87700000,"q23.2","gneg"],[87700000,91100000,"q23.31","gpos75"],[91100000,92300000,"q23.32","gneg"],[92300000,95300000,"q23.33","gpos50"],[95300000,97500000,"q24.1","gneg"],[97500000,100100000,"q24.2","gpos50"],[100100000,101200000,"q24.31","gneg"],[101200000,103100000,"q24.32","gpos25"],[103100000,104000000,"q24.33","gneg"],[104000000,110100000,"q25.1","gpos100"],[110100000,113100000,"q25.2","gneg"],[113100000,117300000,"q25.3","gpos75"],[117300000,119900000,"q26.11","gneg"],[119900000,121400000,"q26.12","gpos50"],[121400000,125700000,"q26.13","gneg"],[125700000,128800000,"q26.2","gpos50"],[128800000,133797422,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,11700000,"p15.4","gpos50"],[11700000,13800000,"p15.3","gneg"],[13800000,16900000,"p15.2","gpos50"],[16900000,22000000,"p15.1","gneg"],[22000000,26200000,"p14.3","gpos100"],[26200000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43400000,"p12","gpos100"],[43400000,48800000,"p11.2","gneg"],[48800000,51000000,"p11.12","gpos75"],[51000000,53400000,"p11.11","acen"],[53400000,55800000,"q11","acen"],[55800000,60100000,"q12.1","gpos75"],[60100000,61900000,"q12.2","gneg"],[61900000,63600000,"q12.3","gpos25"],[63600000,66100000,"q13.1","gneg"],[66100000,68700000,"q13.2","gpos25"],[68700000,70500000,"q13.3","gneg"],[70500000,75500000,"q13.4","gpos50"],[75500000,77400000,"q13.5","gneg"],[77400000,85900000,"q14.1","gpos100"],[85900000,88600000,"q14.2","gneg"],[88600000,93000000,"q14.3","gpos100"],[93000000,97400000,"q21","gneg"],[97400000,102300000,"q22.1","gpos100"],[102300000,103000000,"q22.2","gneg"],[103000000,110600000,"q22.3","gpos100"],[110600000,112700000,"q23.1","gneg"],[112700000,114600000,"q23.2","gpos50"],[114600000,121300000,"q23.3","gneg"],[121300000,124000000,"q24.1","gpos50"],[124000000,127900000,"q24.2","gneg"],[127900000,130900000,"q24.3","gpos50"],[130900000,135086622,"q25","gneg"]],12:[[0,3200000,"p13.33","gneg"],[3200000,5300000,"p13.32","gpos25"],[5300000,10000000,"p13.31","gneg"],[10000000,12600000,"p13.2","gpos75"],[12600000,14600000,"p13.1","gneg"],[14600000,19800000,"p12.3","gpos100"],[19800000,21100000,"p12.2","gneg"],[21100000,26300000,"p12.1","gpos100"],[26300000,27600000,"p11.23","gneg"],[27600000,30500000,"p11.22","gpos50"],[30500000,33200000,"p11.21","gneg"],[33200000,35500000,"p11.1","acen"],[35500000,37800000,"q11","acen"],[37800000,46000000,"q12","gpos100"],[46000000,48700000,"q13.11","gneg"],[48700000,51100000,"q13.12","gpos25"],[51100000,54500000,"q13.13","gneg"],[54500000,56200000,"q13.2","gpos25"],[56200000,57700000,"q13.3","gneg"],[57700000,62700000,"q14.1","gpos75"],[62700000,64700000,"q14.2","gneg"],[64700000,67300000,"q14.3","gpos50"],[67300000,71100000,"q15","gneg"],[71100000,75300000,"q21.1","gpos75"],[75300000,79900000,"q21.2","gneg"],[79900000,86300000,"q21.31","gpos100"],[86300000,88600000,"q21.32","gneg"],[88600000,92200000,"q21.33","gpos100"],[92200000,95800000,"q22","gneg"],[95800000,101200000,"q23.1","gpos75"],[101200000,103500000,"q23.2","gneg"],[103500000,108600000,"q23.3","gpos50"],[108600000,111300000,"q24.11","gneg"],[111300000,111900000,"q24.12","gpos25"],[111900000,113900000,"q24.13","gneg"],[113900000,116400000,"q24.21","gpos50"],[116400000,117700000,"q24.22","gneg"],[117700000,120300000,"q24.23","gpos50"],[120300000,125400000,"q24.31","gneg"],[125400000,128700000,"q24.32","gpos50"],[128700000,133275309,"q24.33","gneg"]],13:[[0,4600000,"p13","gvar"],[4600000,10100000,"p12","stalk"],[10100000,16500000,"p11.2","gvar"],[16500000,17700000,"p11.1","acen"],[17700000,18900000,"q11","acen"],[18900000,22600000,"q12.11","gneg"],[22600000,24900000,"q12.12","gpos25"],[24900000,27200000,"q12.13","gneg"],[27200000,28300000,"q12.2","gpos25"],[28300000,31600000,"q12.3","gneg"],[31600000,33400000,"q13.1","gpos50"],[33400000,34900000,"q13.2","gneg"],[34900000,39500000,"q13.3","gpos75"],[39500000,44600000,"q14.11","gneg"],[44600000,45200000,"q14.12","gpos25"],[45200000,46700000,"q14.13","gneg"],[46700000,50300000,"q14.2","gpos50"],[50300000,54700000,"q14.3","gneg"],[54700000,59000000,"q21.1","gpos100"],[59000000,61800000,"q21.2","gneg"],[61800000,65200000,"q21.31","gpos75"],[65200000,68100000,"q21.32","gneg"],[68100000,72800000,"q21.33","gpos100"],[72800000,74900000,"q22.1","gneg"],[74900000,76700000,"q22.2","gpos50"],[76700000,78500000,"q22.3","gneg"],[78500000,87100000,"q31.1","gpos100"],[87100000,89400000,"q31.2","gneg"],[89400000,94400000,"q31.3","gpos100"],[94400000,97500000,"q32.1","gneg"],[97500000,98700000,"q32.2","gpos25"],[98700000,101100000,"q32.3","gneg"],[101100000,104200000,"q33.1","gpos100"],[104200000,106400000,"q33.2","gneg"],[106400000,109600000,"q33.3","gpos100"],[109600000,114364328,"q34","gneg"]],14:[[0,3600000,"p13","gvar"],[3600000,8000000,"p12","stalk"],[8000000,16100000,"p11.2","gvar"],[16100000,17200000,"p11.1","acen"],[17200000,18200000,"q11.1","acen"],[18200000,24100000,"q11.2","gneg"],[24100000,32900000,"q12","gpos100"],[32900000,34800000,"q13.1","gneg"],[34800000,36100000,"q13.2","gpos50"],[36100000,37400000,"q13.3","gneg"],[37400000,43000000,"q21.1","gpos100"],[43000000,46700000,"q21.2","gneg"],[46700000,50400000,"q21.3","gpos100"],[50400000,53600000,"q22.1","gneg"],[53600000,55000000,"q22.2","gpos25"],[55000000,57600000,"q22.3","gneg"],[57600000,61600000,"q23.1","gpos75"],[61600000,64300000,"q23.2","gneg"],[64300000,67400000,"q23.3","gpos50"],[67400000,69800000,"q24.1","gneg"],[69800000,73300000,"q24.2","gpos50"],[73300000,78800000,"q24.3","gneg"],[78800000,83100000,"q31.1","gpos100"],[83100000,84400000,"q31.2","gneg"],[84400000,89300000,"q31.3","gpos100"],[89300000,91400000,"q32.11","gneg"],[91400000,94200000,"q32.12","gpos25"],[94200000,95800000,"q32.13","gneg"],[95800000,100900000,"q32.2","gpos50"],[100900000,102700000,"q32.31","gneg"],[102700000,103500000,"q32.32","gpos50"],[103500000,107043718,"q32.33","gneg"]],15:[[0,4200000,"p13","gvar"],[4200000,9700000,"p12","stalk"],[9700000,17500000,"p11.2","gvar"],[17500000,19000000,"p11.1","acen"],[19000000,20500000,"q11.1","acen"],[20500000,25500000,"q11.2","gneg"],[25500000,27800000,"q12","gpos50"],[27800000,30000000,"q13.1","gneg"],[30000000,30900000,"q13.2","gpos50"],[30900000,33400000,"q13.3","gneg"],[33400000,39800000,"q14","gpos75"],[39800000,42500000,"q15.1","gneg"],[42500000,43300000,"q15.2","gpos25"],[43300000,44500000,"q15.3","gneg"],[44500000,49200000,"q21.1","gpos75"],[49200000,52600000,"q21.2","gneg"],[52600000,58800000,"q21.3","gpos75"],[58800000,59000000,"q22.1","gneg"],[59000000,63400000,"q22.2","gpos25"],[63400000,66900000,"q22.31","gneg"],[66900000,67000000,"q22.32","gpos25"],[67000000,67200000,"q22.33","gneg"],[67200000,72400000,"q23","gpos25"],[72400000,74900000,"q24.1","gneg"],[74900000,76300000,"q24.2","gpos25"],[76300000,78000000,"q24.3","gneg"],[78000000,81400000,"q25.1","gpos50"],[81400000,84700000,"q25.2","gneg"],[84700000,88500000,"q25.3","gpos50"],[88500000,93800000,"q26.1","gneg"],[93800000,98000000,"q26.2","gpos50"],[98000000,101991189,"q26.3","gneg"]],16:[[0,7800000,"p13.3","gneg"],[7800000,10400000,"p13.2","gpos50"],[10400000,12500000,"p13.13","gneg"],[12500000,14700000,"p13.12","gpos50"],[14700000,16700000,"p13.11","gneg"],[16700000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28500000,"p12.1","gpos50"],[28500000,35300000,"p11.2","gneg"],[35300000,36800000,"p11.1","acen"],[36800000,38400000,"q11.1","acen"],[38400000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56000000,"q12.2","gpos50"],[56000000,57300000,"q13","gneg"],[57300000,66600000,"q21","gpos100"],[66600000,70800000,"q22.1","gneg"],[70800000,72800000,"q22.2","gpos50"],[72800000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81600000,"q23.2","gneg"],[81600000,84100000,"q23.3","gpos50"],[84100000,87000000,"q24.1","gneg"],[87000000,88700000,"q24.2","gpos25"],[88700000,90338345,"q24.3","gneg"]],17:[[0,3400000,"p13.3","gneg"],[3400000,6500000,"p13.2","gpos50"],[6500000,10800000,"p13.1","gneg"],[10800000,16100000,"p12","gpos75"],[16100000,22700000,"p11.2","gneg"],[22700000,25100000,"p11.1","acen"],[25100000,27400000,"q11.1","acen"],[27400000,33500000,"q11.2","gneg"],[33500000,39800000,"q12","gpos50"],[39800000,40200000,"q21.1","gneg"],[40200000,42800000,"q21.2","gpos25"],[42800000,46800000,"q21.31","gneg"],[46800000,49300000,"q21.32","gpos25"],[49300000,52100000,"q21.33","gneg"],[52100000,59500000,"q22","gpos75"],[59500000,60200000,"q23.1","gneg"],[60200000,63100000,"q23.2","gpos75"],[63100000,64600000,"q23.3","gneg"],[64600000,66200000,"q24.1","gpos50"],[66200000,69100000,"q24.2","gneg"],[69100000,72900000,"q24.3","gpos75"],[72900000,76800000,"q25.1","gneg"],[76800000,77200000,"q25.2","gpos25"],[77200000,83257441,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7200000,"p11.31","gpos50"],[7200000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,18500000,"p11.1","acen"],[18500000,21500000,"q11.1","acen"],[21500000,27500000,"q11.2","gneg"],[27500000,35100000,"q12.1","gpos100"],[35100000,39500000,"q12.2","gneg"],[39500000,45900000,"q12.3","gpos75"],[45900000,50700000,"q21.1","gneg"],[50700000,56200000,"q21.2","gpos75"],[56200000,58600000,"q21.31","gneg"],[58600000,61300000,"q21.32","gpos50"],[61300000,63900000,"q21.33","gneg"],[63900000,69100000,"q22.1","gpos100"],[69100000,71000000,"q22.2","gneg"],[71000000,75400000,"q22.3","gpos25"],[75400000,80373285,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,12600000,"p13.2","gpos25"],[12600000,13800000,"p13.13","gneg"],[13800000,16100000,"p13.12","gpos25"],[16100000,19900000,"p13.11","gneg"],[19900000,24200000,"p12","gvar"],[24200000,26200000,"p11","acen"],[26200000,28100000,"q11","acen"],[28100000,31900000,"q12","gvar"],[31900000,35100000,"q13.11","gneg"],[35100000,37800000,"q13.12","gpos25"],[37800000,38200000,"q13.13","gneg"],[38200000,42900000,"q13.2","gpos25"],[42900000,44700000,"q13.31","gneg"],[44700000,47500000,"q13.32","gpos25"],[47500000,50900000,"q13.33","gneg"],[50900000,53100000,"q13.41","gpos25"],[53100000,55800000,"q13.42","gneg"],[55800000,58617616,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12000000,"p12.2","gneg"],[12000000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25700000,"p11.21","gneg"],[25700000,28100000,"p11.1","acen"],[28100000,30400000,"q11.1","acen"],[30400000,33500000,"q11.21","gneg"],[33500000,35800000,"q11.22","gpos25"],[35800000,39000000,"q11.23","gneg"],[39000000,43100000,"q12","gpos75"],[43100000,43500000,"q13.11","gneg"],[43500000,47800000,"q13.12","gpos25"],[47800000,51200000,"q13.13","gneg"],[51200000,56400000,"q13.2","gpos75"],[56400000,57800000,"q13.31","gneg"],[57800000,59700000,"q13.32","gpos50"],[59700000,64444167,"q13.33","gneg"]],21:[[0,3100000,"p13","gvar"],[3100000,7000000,"p12","stalk"],[7000000,10900000,"p11.2","gvar"],[10900000,12000000,"p11.1","acen"],[12000000,13000000,"q11.1","acen"],[13000000,15000000,"q11.2","gneg"],[15000000,22600000,"q21.1","gpos100"],[22600000,25500000,"q21.2","gneg"],[25500000,30200000,"q21.3","gpos75"],[30200000,34400000,"q22.11","gneg"],[34400000,36400000,"q22.12","gpos50"],[36400000,38300000,"q22.13","gneg"],[38300000,41200000,"q22.2","gpos50"],[41200000,46709983,"q22.3","gneg"]],22:[[0,4300000,"p13","gvar"],[4300000,9400000,"p12","stalk"],[9400000,13700000,"p11.2","gvar"],[13700000,15000000,"p11.1","acen"],[15000000,17400000,"q11.1","acen"],[17400000,21700000,"q11.21","gneg"],[21700000,23100000,"q11.22","gpos25"],[23100000,25500000,"q11.23","gneg"],[25500000,29200000,"q12.1","gpos50"],[29200000,31800000,"q12.2","gneg"],[31800000,37200000,"q12.3","gpos50"],[37200000,40600000,"q13.1","gneg"],[40600000,43800000,"q13.2","gpos50"],[43800000,48100000,"q13.31","gneg"],[48100000,49100000,"q13.32","gpos50"],[49100000,50818468,"q13.33","gneg"]],X:[[0,4400000,"p22.33","gneg"],[4400000,6100000,"p22.32","gpos50"],[6100000,9600000,"p22.31","gneg"],[9600000,17400000,"p22.2","gpos50"],[17400000,19200000,"p22.13","gneg"],[19200000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37800000,"p21.1","gpos100"],[37800000,42500000,"p11.4","gneg"],[42500000,47600000,"p11.3","gpos75"],[47600000,50100000,"p11.23","gneg"],[50100000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,61000000,"p11.1","acen"],[61000000,63800000,"q11.1","acen"],[63800000,65400000,"q11.2","gneg"],[65400000,68500000,"q12","gpos50"],[68500000,73000000,"q13.1","gneg"],[73000000,74700000,"q13.2","gpos50"],[74700000,76800000,"q13.3","gneg"],[76800000,85400000,"q21.1","gpos100"],[85400000,87000000,"q21.2","gneg"],[87000000,92700000,"q21.31","gpos100"],[92700000,94300000,"q21.32","gneg"],[94300000,99100000,"q21.33","gpos75"],[99100000,103300000,"q22.1","gneg"],[103300000,104500000,"q22.2","gpos50"],[104500000,109400000,"q22.3","gneg"],[109400000,117400000,"q23","gpos75"],[117400000,121800000,"q24","gneg"],[121800000,129500000,"q25","gpos100"],[129500000,131300000,"q26.1","gneg"],[131300000,134500000,"q26.2","gpos25"],[134500000,138900000,"q26.3","gneg"],[138900000,141200000,"q27.1","gpos75"],[141200000,143000000,"q27.2","gneg"],[143000000,148000000,"q27.3","gpos100"],[148000000,156040895,"q28","gneg"]],Y:[[0,300000,"p11.32","gneg"],[300000,600000,"p11.31","gpos50"],[600000,10300000,"p11.2","gneg"],[10300000,10400000,"p11.1","acen"],[10400000,10600000,"q11.1","acen"],[10600000,12400000,"q11.21","gneg"],[12400000,17100000,"q11.221","gpos50"],[17100000,19600000,"q11.222","gneg"],[19600000,23800000,"q11.223","gpos50"],[23800000,26600000,"q11.23","gneg"],[26600000,57227415,"q12","gvar"]]}}};CanvasXpress.graphTypes={Area:["Area"],AreaLine:["AreaLine"],Bar:["Bar"],BarLine:["BarLine"],Boxplot:["Boxplot"],Fish:["Fish"],Gantt:["Gantt"],Circular:["Circular"],Correlation:["Correlation"],DotLine:["DotLine"],Dotplot:["Dotplot"],Genome:["Genome"],Heatmap:["Heatmap"],Line:["Line"],Map:["Map"],Meter:["Meter"],Network:["Network"],ParallelCoordinates:["ParallelCoordinates"],Pie:["Pie"],Sankey:["Sankey"],Scatter2D:["Scatter2D"],ScatterBubble2D:["ScatterBubble2D"],Scatter3D:["Scatter3D"],Stacked:["Stacked"],StackedLine:["StackedLine"],StackedPercent:["StackedPercent"],StackedPercentLine:["StackedPercentLine"],TagCloud:["TagCloud"],Tree:["Tree"],Treemap:["Treemap"],Venn:["Venn"],DotGraphs:["Boxplot","DotLine","Dotplot"],LineGraphs:["AreaLine","BarLine","DotLine","Line","ParallelCoordinates","StackedLine","StackedPercentLine"],ScatterGraphs:["Scatter2D","ScatterBubble2D","Scatter3D"],StackedGraphs:["Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneDPlots:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Meter","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Sankey","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],OneDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Meter","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneTwoThreeeDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Fish","Gantt","Meter","Circular","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Pie","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","Treemap"],AllGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Fish","Meter","Circular","Correlation","DotLine","Dotplot","Genome","Heatmap","Line","Map","Network","ParallelCoordinates","Pie","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap","Venn"],AGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Fish","Meter","Circular","Correlation","DotLine","Dotplot","Heatmap","Line","Map","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],AttGraphs:["Bar","BarLine","Boxplot","Dotplot","Treemap","Heatmap","Stacked","StackedLine","StackedPercent","StackedPercentLine","ParallelCoordinates","Line","Sankey","Tree","TagCloud","Gantt"],NoneDGraphs:["Fish","Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn"],NonSegregatable:["Fish","Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn","Circular","Gantt"]};CanvasXpress.colorNames={aliceblue:"f0f8ff",antiquewhite1:"ffefdb",antiquewhite2:"eedfcc",antiquewhite3:"cdc0b0",antiquewhite4:"8b8378",antiquewhite:"faebd7",aqua:"00ffff",aquamarine1:"7fffd4",aquamarine2:"76eec6",aquamarine4:"458b74",aquamarine:"7fffd4",azure1:"f0ffff",azure2:"e0eeee",azure3:"c1cdcd",azure4:"838b8b",azure:"f0ffff",beige:"f5f5dc",bisque1:"ffe4c4",bisque2:"eed5b7",bisque3:"cdb79e",bisque4:"8b7d6b",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blue1:"0000ff",blue2:"0000ee",blue3:"1874cd",blue4:"00008b",blueviolet:"8a2be2",brown1:"ff4040",brown2:"ee3b3b",brown3:"cd3333",brown4:"8b2323",brown:"a52a2a",burlywood1:"ffd39b",burlywood2:"eec591",burlywood3:"cdaa7d",burlywood4:"8b7355",burlywood:"deb887",cadetblue1:"98f5ff",cadetblue2:"8ee5ee",cadetblue3:"7ac5cd",cadetblue4:"53868b",cadetblue:"5f9ea0",chartreuse1:"7fff00",chartreuse2:"76ee00",chartreuse3:"66cd00",chartreuse4:"458b00",chartreuse:"7fff00",chocolate1:"ff7f24",chocolate2:"ee7621",chocolate3:"cd661d",chocolate:"d2691e",coral1:"ff7256",coral2:"ee6a50",coral3:"cd5b45",coral4:"8b3e2f",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk1:"fff8dc",cornsilk2:"eee8cd",cornsilk3:"cdc8b1",cornsilk4:"8b8878",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",cyan1:"00ffff",cyan2:"00eeee",cyan3:"00cdcd",cyan4:"008b8b",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod1:"ffb90f",darkgoldenrod2:"eead0e",darkgoldenrod3:"cd950c",darkgoldenrod4:"8b6508",darkgoldenrod4:"8b6508",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen1:"caff70",darkolivegreen2:"bcee68",darkolivegreen3:"a2cd5a",darkolivegreen4:"6e8b3d",darkolivegreen:"556b2f",darkorange1:"ff7f00",darkorange2:"ee7600",darkorange3:"cd6600",darkorange4:"8b4500",darkorange:"ff8c00",darkorchid1:"bf3eff",darkorchid2:"b23aee",darkorchid3:"9a32cd",darkorchid4:"68228b",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen1:"c1ffc1",darkseagreen2:"b4eeb4",darkseagreen3:"9bcd9b",darkseagreen4:"698b69",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray1:"97ffff",darkslategray2:"8deeee",darkslategray:"2f4f4f",darkslategray3:"79cdcd",darkslategray4:"528b8b",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink1:"ff1493",deeppink2:"ee1289",deeppink3:"cd1076",deeppink4:"8b0a50",deeppink:"ff1493",deepskyblue:"00bfff",deepskyblue1:"00bfff",deepskyblue2:"00b2ee",deepskyblue3:"009acd",deepskyblue4:"00688b",dimgray:"696969",dimgrey:"696969",dodgerblue1:"1e90ff",dodgerblue:"1e90ff",dodgerblue2:"1c86ee",dodgerblue3:"1874cd",dodgerblue4:"104e8b",firebrick1:"ff3030",firebrick2:"ee2c2c",firebrick3:"cd2626",firebrick4:"8b1a1a",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold1:"ffd700",gold2:"eec900",gold3:"cdad00",gold4:"8b7500",goldenrod1:"ffc125",goldenrod2:"eeb422",goldenrod3:"cd9b1d",goldenrod4:"8b6914",goldenrod:"daa520",goldenrod:"daa520",gold:"ffd700",gray10:"1a1a1a",gray1:"030303",gray11:"1c1c1c",gray12:"1f1f1f",gray13:"212121",gray14:"242424",gray15:"262626",gray16:"292929",gray17:"2b2b2b",gray18:"2e2e2e",gray19:"303030",gray20:"333333",gray2:"050505",gray21:"363636",gray22:"383838",gray23:"3b3b3b",gray24:"3d3d3d",gray25:"404040",gray26:"424242",gray27:"454545",gray28:"474747",gray29:"4a4a4a",gray30:"4d4d4d",gray3:"080808",gray31:"4f4f4f",gray32:"525252",gray33:"545454",gray34:"575757",gray35:"595959",gray36:"5c5c5c",gray37:"5e5e5e",gray38:"616161",gray39:"636363",gray40:"666666",gray4:"0a0a0a",gray41:"696969",gray42:"6b6b6b",gray43:"6e6e6e",gray44:"707070",gray45:"737373",gray46:"757575",gray47:"787878",gray48:"7a7a7a",gray49:"7d7d7d",gray50:"7f7f7f",gray5:"0d0d0d",gray51:"828282",gray52:"858585",gray53:"878787",gray54:"8a8a8a",gray55:"8c8c8c",gray56:"8f8f8f",gray57:"919191",gray58:"949494",gray59:"969696",gray60:"999999",gray6:"0f0f0f",gray61:"9c9c9c",gray62:"9e9e9e",gray63:"a1a1a1",gray64:"a3a3a3",gray65:"a6a6a6",gray66:"a8a8a8",gray67:"ababab",gray68:"adadad",gray69:"b0b0b0",gray70:"b3b3b3",gray7:"121212",gray71:"b5b5b5",gray72:"b8b8b8",gray73:"bababa",gray74:"bdbdbd",gray75:"bfbfbf",gray76:"c2c2c2",gray77:"c4c4c4",gray78:"c7c7c7",gray79:"c9c9c9",gray:"808080",gray80:"cccccc",gray8:"141414",gray81:"cfcfcf",gray82:"d1d1d1",gray83:"d4d4d4",gray84:"d6d6d6",gray85:"d9d9d9",gray86:"dbdbdb",gray87:"dedede",gray88:"e0e0e0",gray89:"e3e3e3",gray90:"e5e5e5",gray9:"171717",gray91:"e8e8e8",gray92:"ebebeb",gray93:"ededed",gray94:"f0f0f0",gray95:"f2f2f2",gray97:"f7f7f7",gray98:"fafafa",gray99:"fcfcfc",gray:"bebebe",green:"008000",green1:"00ff00",green2:"00ee00",green3:"00cd00",green4:"008b00",greenyellow:"adff2f",grey:"808080",honeydew1:"f0fff0",honeydew2:"e0eee0",honeydew3:"c1cdc1",honeydew4:"838b83",honeydew:"f0fff0",hotpink1:"ff6eb4",hotpink2:"ee6aa7",hotpink3:"cd6090",hotpink4:"8b3a62",hotpink:"ff69b4",indianred1:"ff6a6a",indianred2:"ee6363",indianred3:"cd5555",indianred4:"8b3a3a",indianred:"cd5c5c",indigo:"4b0082",ivory1:"fffff0",ivory2:"eeeee0",ivory3:"cdcdc1",ivory4:"8b8b83",ivory:"fffff0",khaki1:"fff68f",khaki2:"eee685",khaki3:"cdc673",khaki4:"8b864e",khaki:"f0e68c",lavenderblush1:"fff0f5",lavenderblush2:"eee0e5",lavenderblush3:"cdc1c5",lavenderblush4:"8b8386",lavenderblush:"fff0f5",lavender:"e6e6fa",lawngreen:"7cfc00",lemonchiffon1:"fffacd",lemonchiffon2:"eee9bf",lemonchiffon3:"cdc9a5",lemonchiffon4:"8b8970",lemonchiffon:"fffacd",lightblue1:"bfefff",lightblue2:"b2dfee",lightblue3:"9ac0cd",lightblue4:"68838b",lightblue:"add8e6",lightcoral:"f08080",lightcyan1:"e0ffff",lightcyan2:"d1eeee",lightcyan3:"b4cdcd",lightcyan4:"7a8b8b",lightcyan:"e0ffff",light:"eedd82",lightgoldenrod1:"ffec8b",lightgoldenrod2:"eedc82",lightgoldenrod3:"cdbe70",lightgoldenrod4:"8b814c",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink1:"ffaeb9",lightpink2:"eea2ad",lightpink3:"cd8c95",lightpink4:"8b5f65",lightpink:"ffb6c1",lightsalmon1:"ffa07a",lightsalmon2:"ee9572",lightsalmon3:"cd8162",lightsalmon4:"8b5742",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue1:"b0e2ff",lightskyblue2:"a4d3ee",lightskyblue3:"8db6cd",lightskyblue4:"607b8b",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue1:"cae1ff",lightsteelblue2:"bcd2ee",lightsteelblue3:"a2b5cd",lightsteelblue4:"6e7b8b",lightsteelblue:"b0c4de",lightyellow1:"ffffe0",lightyellow2:"eeeed1",lightyellow3:"cdcdb4",lightyellow4:"8b8b7a",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta2:"ee00ee",magenta3:"cd00cd",magenta4:"8b008b",magenta:"ff00ff",maroon1:"ff34b3",maroon2:"ee30a7",maroon3:"cd2990",maroon4:"8b1c62",maroon:"800000",maroon:"b03060",medium:"66cdaa",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid1:"e066ff",mediumorchid2:"d15fee",mediumorchid3:"b452cd",mediumorchid4:"7a378b",mediumorchid:"ba55d3",mediumpurple1:"ab82ff",mediumpurple2:"9f79ee",mediumpurple3:"8968cd",mediumpurple4:"5d478b",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose1:"ffe4e1",mistyrose2:"eed5d2",mistyrose3:"cdb7b5",mistyrose4:"8b7d7b",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite1:"ffdead",navajowhite2:"eecfa1",navajowhite3:"cdb38b",navajowhite4:"8b795e",navajowhite:"ffdead",navy:"000080",navyblue:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab1:"c0ff3e",olivedrab2:"b3ee3a",olivedrab4:"698b22",olivedrab:"6b8e23",orange1:"ffa500",orange2:"ee9a00",orange3:"cd8500",orange4:"8b5a00",orange:"ffa500",orangered1:"ff4500",orangered2:"ee4000",orangered3:"cd3700",orangered4:"8b2500",orangered:"ff4500",orchid1:"ff83fa",orchid2:"ee7ae9",orchid3:"cd69c9",orchid4:"8b4789",orchid:"da70d6",pale:"db7093",palegoldenrod:"eee8aa",palegreen1:"9aff9a",palegreen2:"90ee90",palegreen3:"7ccd7c",palegreen4:"548b54",palegreen:"98fb98",paleturquoise1:"bbffff",paleturquoise2:"aeeeee",paleturquoise3:"96cdcd",paleturquoise4:"668b8b",paleturquoise:"afeeee",palevioletred1:"ff82ab",palevioletred2:"ee799f",palevioletred3:"cd6889",palevioletred4:"8b475d",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff1:"ffdab9",peachpuff2:"eecbad",peachpuff3:"cdaf95",peachpuff4:"8b7765",peachpuff:"ffdab9",peru:"cd853f",pink1:"ffb5c5",pink2:"eea9b8",pink3:"cd919e",pink4:"8b636c",pink:"ffc0cb",plum1:"ffbbff",plum2:"eeaeee",plum3:"cd96cd",plum4:"8b668b",plum:"dda0dd",powderblue:"b0e0e6",purple1:"9b30ff",purple2:"912cee",purple3:"7d26cd",purple4:"551a8b",purple:"800080",purple:"a020f0",rebeccapurple:"663399",red1:"ff0000",red2:"ee0000",red3:"cd0000",red4:"8b0000",red:"ff0000",rosybrown1:"ffc1c1",rosybrown2:"eeb4b4",rosybrown3:"cd9b9b",rosybrown4:"8b6969",rosybrown:"bc8f8f",royalblue1:"4876ff",royalblue2:"436eee",royalblue3:"3a5fcd",royalblue:"4169e1",royalblue4:"27408b",saddlebrown:"8b4513",salmon1:"ff8c69",salmon2:"ee8262",salmon3:"cd7054",salmon4:"8b4c39",salmon:"fa8072",sandybrown:"f4a460",seagreen1:"54ff9f",seagreen2:"4eee94",seagreen:"2e8b57",seagreen3:"43cd80",seagreen4:"2e8b57",seashell1:"fff5ee",seashell2:"eee5de",seashell3:"cdc5bf",seashell4:"8b8682",seashell:"fff5ee",sienna1:"ff8247",sienna2:"ee7942",sienna3:"cd6839",sienna4:"8b4726",sienna:"a0522d",silver:"c0c0c0",skyblue1:"87ceff",skyblue2:"7ec0ee",skyblue3:"6ca6cd",skyblue4:"4a708b",skyblue:"87ceeb",slateblue1:"836fff",slateblue2:"7a67ee",slateblue3:"6959cd",slateblue4:"473c8b",slateblue:"6a5acd",slategray1:"c6e2ff",slategray2:"b9d3ee",slategray3:"9fb6cd",slategray4:"6c7b8b",slategray:"708090",slategrey:"708090",snow1:"fffafa",snow2:"eee9e9",snow3:"cdc9c9",snow4:"8b8989",snow:"fffafa",springgreen:"00ff7f",springgreen1:"00ff7f",springgreen2:"00ee76",springgreen3:"00cd66",springgreen4:"008b45",steelblue1:"63b8ff",steelblue2:"5cacee",steelblue3:"4f94cd",steelblue4:"36648b",steelblue:"4682b4",tan1:"ffa54f",tan2:"ee9a49",tan3:"cd853f",tan4:"8b5a2b",tan:"d2b48c",teal:"008080",thistle1:"ffe1ff",thistle2:"eed2ee",thistle3:"cdb5cd",thistle4:"8b7b8b",thistle:"d8bfd8",tomato1:"ff6347",tomato2:"ee5c42",tomato3:"cd4f39",tomato4:"8b3626",tomato:"ff6347",turquoise1:"00f5ff",turquoise2:"00e5ee",turquoise3:"00c5cd",turquoise4:"00868b",turquoise:"40e0d0",violet:"ee82ee",violetred1:"ff3e96",violetred2:"ee3a8c",violetred3:"cd3278",violetred4:"8b2252",violetred:"d02090",wheat1:"ffe7ba",wheat2:"eed8ae",wheat3:"cdba96",wheat4:"8b7e66",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow1:"ffff00",yellow2:"eeee00",yellow3:"cdcd00",yellow4:"8b8b00",yellow:"ffff00",yellowgreen:"9acd32"};CanvasXpress.setColorSchemes=function(){CanvasXpress.colorSchemes={YlGn:{3:"f7fcb9addd8e31a354",4:"ffffccc2e69978c679238443",5:"ffffccc2e69978c67931a354006837",6:"ffffccd9f0a3addd8e78c67931a354006837",7:"ffffccd9f0a3addd8e78c67941ab5d238443005a32",8:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443005a32",9:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443006837004529"},YlGnBu:{3:"edf8b17fcdbb2c7fb8",4:"ffffcca1dab441b6c4225ea8",5:"ffffcca1dab441b6c42c7fb8253494",6:"ffffccc7e9b47fcdbb41b6c42c7fb8253494",7:"ffffccc7e9b47fcdbb41b6c41d91c0225ea80c2c84",8:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea80c2c84",9:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea8253494081d58"},GnBu:{3:"e0f3dba8ddb543a2ca",4:"f0f9e8bae4bc7bccc42b8cbe",5:"f0f9e8bae4bc7bccc443a2ca0868ac",6:"f0f9e8ccebc5a8ddb57bccc443a2ca0868ac",7:"f0f9e8ccebc5a8ddb57bccc44eb3d32b8cbe08589e",8:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe08589e",9:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe0868ac084081"},BuGn:{3:"e5f5f999d8c92ca25f",4:"edf8fbb2e2e266c2a4238b45",5:"edf8fbb2e2e266c2a42ca25f006d2c",6:"edf8fbccece699d8c966c2a42ca25f006d2c",7:"edf8fbccece699d8c966c2a441ae76238b45005824",8:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45005824",9:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45006d2c00441b"},PuBuGn:{3:"ece2f0a6bddb1c9099",4:"f6eff7bdc9e167a9cf02818a",5:"f6eff7bdc9e167a9cf1c9099016c59",6:"f6eff7d0d1e6a6bddb67a9cf1c9099016c59",7:"f6eff7d0d1e6a6bddb67a9cf3690c002818a016450",8:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016450",9:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016c59014636"},PuBu:{3:"ece7f2a6bddb2b8cbe",4:"f1eef6bdc9e174a9cf0570b0",5:"f1eef6bdc9e174a9cf2b8cbe045a8d",6:"f1eef6d0d1e6a6bddb74a9cf2b8cbe045a8d",7:"f1eef6d0d1e6a6bddb74a9cf3690c00570b0034e7b",8:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0034e7b",9:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0045a8d023858"},BuPu:{3:"e0ecf49ebcda8856a7",4:"edf8fbb3cde38c96c688419d",5:"edf8fbb3cde38c96c68856a7810f7c",6:"edf8fbbfd3e69ebcda8c96c68856a7810f7c",7:"edf8fbbfd3e69ebcda8c96c68c6bb188419d6e016b",8:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d6e016b",9:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d810f7c4d004b"},RdPu:{3:"fde0ddfa9fb5c51b8a",4:"feebe2fbb4b9f768a1ae017e",5:"feebe2fbb4b9f768a1c51b8a7a0177",6:"feebe2fcc5c0fa9fb5f768a1c51b8a7a0177",7:"feebe2fcc5c0fa9fb5f768a1dd3497ae017e7a0177",8:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a0177",9:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a017749006a"},PuRd:{3:"e7e1efc994c7dd1c77",4:"f1eef6d7b5d8df65b0ce1256",5:"f1eef6d7b5d8df65b0dd1c77980043",6:"f1eef6d4b9dac994c7df65b0dd1c77980043",7:"f1eef6d4b9dac994c7df65b0e7298ace125691003f",8:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125691003f",9:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125698004367001f"},OrRd:{3:"fee8c8fdbb84e34a33",4:"fef0d9fdcc8afc8d59d7301f",5:"fef0d9fdcc8afc8d59e34a33b30000",6:"fef0d9fdd49efdbb84fc8d59e34a33b30000",7:"fef0d9fdd49efdbb84fc8d59ef6548d7301f990000",8:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301f990000",9:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301fb300007f0000"},YlOrRd:{3:"ffeda0feb24cf03b20",4:"ffffb2fecc5cfd8d3ce31a1c",5:"ffffb2fecc5cfd8d3cf03b20bd0026",6:"ffffb2fed976feb24cfd8d3cf03b20bd0026",7:"ffffb2fed976feb24cfd8d3cfc4e2ae31a1cb10026",8:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cb10026",9:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cbd0026800026"},YlOrBr:{3:"fff7bcfec44fd95f0e",4:"ffffd4fed98efe9929cc4c02",5:"ffffd4fed98efe9929d95f0e993404",6:"ffffd4fee391fec44ffe9929d95f0e993404",7:"ffffd4fee391fec44ffe9929ec7014cc4c028c2d04",8:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c028c2d04",9:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c02993404662506"},Purples:{3:"efedf5bcbddc756bb1",4:"f2f0f7cbc9e29e9ac86a51a3",5:"f2f0f7cbc9e29e9ac8756bb154278f",6:"f2f0f7dadaebbcbddc9e9ac8756bb154278f",7:"f2f0f7dadaebbcbddc9e9ac8807dba6a51a34a1486",8:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a34a1486",9:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a354278f3f007d"},Blues:{3:"deebf79ecae13182bd",4:"eff3ffbdd7e76baed62171b5",5:"eff3ffbdd7e76baed63182bd08519c",6:"eff3ffc6dbef9ecae16baed63182bd08519c",7:"eff3ffc6dbef9ecae16baed64292c62171b5084594",8:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b5084594",9:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b508519c08306b"},Greens:{3:"e5f5e0a1d99b31a354",4:"edf8e9bae4b374c476238b45",5:"edf8e9bae4b374c47631a354006d2c",6:"edf8e9c7e9c0a1d99b74c47631a354006d2c",7:"edf8e9c7e9c0a1d99b74c47641ab5d238b45005a32",8:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45005a32",9:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45006d2c00441b"},Oranges:{3:"fee6cefdae6be6550d",4:"feeddefdbe85fd8d3cd94701",5:"feeddefdbe85fd8d3ce6550da63603",6:"feeddefdd0a2fdae6bfd8d3ce6550da63603",7:"feeddefdd0a2fdae6bfd8d3cf16913d948018c2d04",8:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d948018c2d04",9:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d94801a636037f2704"},Reds:{3:"fee0d2fc9272de2d26",4:"fee5d9fcae91fb6a4acb181d",5:"fee5d9fcae91fb6a4ade2d26a50f15",6:"fee5d9fcbba1fc9272fb6a4ade2d26a50f15",7:"fee5d9fcbba1fc9272fb6a4aef3b2ccb181d99000d",8:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181d99000d",9:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181da50f1567000d"},Greys:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000",256:"fffffffffffffefefefefefefdfdfdfdfdfdfcfcfcfcfcfcfbfbfbfbfbfbfafafafafafaf9f9f9f9f9f9f9f9f9f8f8f8f8f8f8f7f7f7f7f7f7f6f6f6f6f6f6f5f5f5f5f5f5f4f4f4f4f4f4f3f3f3f3f3f3f2f2f2f2f2f2f1f1f1f1f1f1f0f0f0f0f0f0efefefefefefeeeeeeeeeeeeededededededececececececebebebebebebeaeaeaeaeaeae9e9e9e9e9e9e8e8e8e8e8e8e7e7e7e7e7e7e6e6e6e6e6e6e5e5e5e5e5e5e4e4e4e4e4e4e3e3e3e3e3e3e2e2e2e2e2e2e1e1e1e1e1e1e0e0e0e0e0e0dfdfdfdfdfdfdedededddddddddddddcdcdcdcdcdcdbdbdbdbdbdbdadadadadadad9d9d9d9d9d9d8d8d8d7d7d7d7d7d7d6d6d6d6d6d6d5d5d5d5d5d5d4d4d4d4d4d4d3d3d3d2d2d2d2d2d2d1d1d1d1d1d1d0d0d0cfcfcfcfcfcfcececececececdcdcdcdcdcdcccccccbcbcbcbcbcbcacacacacacac9c9c9c8c8c8c8c8c8c7c7c7c7c7c7c6c6c6c5c5c5c5c5c5c4c4c4c3c3c3c3c3c3c2c2c2c2c2c2c1c1c1c0c0c0c0c0c0bfbfbfbebebebebebebdbdbdbcbcbcbcbcbcbbbbbbbabababababab9b9b9b8b8b8b8b8b8b7b7b7b6b6b6b6b6b6b5b5b5b4b4b4b4b4b4b3b3b3b2b2b2b2b2b2b1b1b1b0b0b0afafafafafafaeaeaeadadadadadadacacacabababaaaaaaaaaaaaa9a9a9a8a8a8a7a7a7a7a7a7a6a6a6a5a5a5a4a4a4a4a4a4a3a3a3a2a2a2a1a1a1a0a0a0a0a0a09f9f9f9e9e9e9d9d9d9c9c9c9c9c9c9b9b9b9a9a9a9999999898989797979797979696969595959494949393939292929191919090909090908f8f8f8e8e8e8d8d8d8c8c8c8b8b8b8a8a8a8989898888888787878686868585858484848383838282828181818080807f7f7f7e7e7e7d7d7d7c7c7c7b7b7b7a7a7a7878787777777676767575757474747373737272727070706f6f6f6e6e6e6d6d6d6b6b6b6a6a6a6969696767676666666565656363636262626060605f5f5f5d5d5d5c5c5c5a5a5a5959595757575555555454545252525050504e4e4e4c4c4c4a4a4a4848484646464444444242424040403d3d3d3b3b3b3838383535353232322e2e2e2b2b2b2727272222221c1c1c15151500000"},PuOr:{3:"f1a340f7f7f7998ec3",4:"e66101fdb863b2abd25e3c99",5:"e66101fdb863f7f7f7b2abd25e3c99",6:"b35806f1a340fee0b6d8daeb998ec3542788",7:"b35806f1a340fee0b6f7f7f7d8daeb998ec3542788",8:"b35806e08214fdb863fee0b6d8daebb2abd28073ac542788",9:"b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac542788",10:"7f3b08b35806e08214fdb863fee0b6d8daebb2abd28073ac5427882d004b",11:"7f3b08b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac5427882d004b"},BrBG:{3:"d8b365f5f5f55ab4ac",4:"a6611adfc27d80cdc1018571",5:"a6611adfc27df5f5f580cdc1018571",6:"8c510ad8b365f6e8c3c7eae55ab4ac01665e",7:"8c510ad8b365f6e8c3f5f5f5c7eae55ab4ac01665e",8:"8c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e",9:"8c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e",10:"5430058c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e003c30",11:"5430058c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e003c30"},PRGn:{3:"af8dc3f7f7f77fbf7b",4:"7b3294c2a5cfa6dba0008837",5:"7b3294c2a5cff7f7f7a6dba0008837",6:"762a83af8dc3e7d4e8d9f0d37fbf7b1b7837",7:"762a83af8dc3e7d4e8f7f7f7d9f0d37fbf7b1b7837",8:"762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b7837",9:"762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b7837",10:"40004b762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b783700441b",11:"40004b762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b783700441b"},PiYG:{3:"e9a3c9f7f7f7a1d76a",4:"d01c8bf1b6dab8e1864dac26",5:"d01c8bf1b6daf7f7f7b8e1864dac26",6:"c51b7de9a3c9fde0efe6f5d0a1d76a4d9221",7:"c51b7de9a3c9fde0eff7f7f7e6f5d0a1d76a4d9221",8:"c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221",9:"c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221",10:"8e0152c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221276419",11:"8e0152c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221276419"},RdBu:{3:"ef8a62f7f7f767a9cf",4:"ca0020f4a58292c5de0571b0",5:"ca0020f4a582f7f7f792c5de0571b0",6:"b2182bef8a62fddbc7d1e5f067a9cf2166ac",7:"b2182bef8a62fddbc7f7f7f7d1e5f067a9cf2166ac",8:"b2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac",9:"b2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac",10:"67001fb2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac053061",11:"67001fb2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac053061"},RdGy:{3:"ef8a62ffffff999999",4:"ca0020f4a582bababa404040",5:"ca0020f4a582ffffffbababa404040",6:"b2182bef8a62fddbc7e0e0e09999994d4d4d",7:"b2182bef8a62fddbc7ffffffe0e0e09999994d4d4d",8:"b2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d",9:"b2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d",10:"67001fb2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d1a1a1a",11:"67001fb2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d1a1a1a"},RdYlBu:{3:"fc8d59ffffbf91bfdb",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},Spectral:{3:"fc8d59ffffbf99d594",4:"d7191cfdae61abdda42b83ba",5:"d7191cfdae61ffffbfabdda42b83ba",6:"d53e4ffc8d59fee08be6f59899d5943288bd",7:"d53e4ffc8d59fee08bffffbfe6f59899d5943288bd",8:"d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd",9:"d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd",10:"9e0142d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd5e4fa2",11:"9e0142d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd5e4fa2"},RdYlGn:{3:"fc8d59ffffbf91cf60",4:"d7191cfdae61a6d96a1a9641",5:"d7191cfdae61ffffbfa6d96a1a9641",6:"d73027fc8d59fee08bd9ef8b91cf601a9850",7:"d73027fc8d59fee08bffffbfd9ef8b91cf601a9850",8:"d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850",9:"d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850",10:"a50026d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850006837",11:"a50026d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850006837"},Accent:{3:"7fc97fbeaed4fdc086",4:"7fc97fbeaed4fdc086ffff99",5:"7fc97fbeaed4fdc086ffff99386cb0",6:"7fc97fbeaed4fdc086ffff99386cb0f0027f",7:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17",8:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666"},Dark2:{3:"1b9e77d95f027570b3",4:"1b9e77d95f027570b3e7298a",5:"1b9e77d95f027570b3e7298a66a61e",6:"1b9e77d95f027570b3e7298a66a61ee6ab02",7:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d",8:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666"},Paired:{3:"a6cee31f78b4b2df8a",4:"a6cee31f78b4b2df8a33a02c",5:"a6cee31f78b4b2df8a33a02cfb9a99",6:"a6cee31f78b4b2df8a33a02cfb9a99e31a1c",7:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6f",8:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00",9:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d6",10:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9a",11:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99",12:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"},Pastel1:{3:"fbb4aeb3cde3ccebc5",4:"fbb4aeb3cde3ccebc5decbe4",5:"fbb4aeb3cde3ccebc5decbe4fed9a6",6:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcc",7:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bd",8:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaec",9:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2"},Pastel2:{3:"b3e2cdfdcdaccbd5e8",4:"b3e2cdfdcdaccbd5e8f4cae4",5:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9",6:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2ae",7:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cc",8:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc"},Set1:{3:"e41a1c377eb84daf4a",4:"e41a1c377eb84daf4a984ea3",5:"e41a1c377eb84daf4a984ea3ff7f00",6:"e41a1c377eb84daf4a984ea3ff7f00ffff33",7:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628",8:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf",9:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999"},Set2:{3:"66c2a5fc8d628da0cb",4:"66c2a5fc8d628da0cbe78ac3",5:"66c2a5fc8d628da0cbe78ac3a6d854",6:"66c2a5fc8d628da0cbe78ac3a6d854ffd92f",7:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494",8:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3"},Set3:{3:"8dd3c7ffffb3bebada",4:"8dd3c7ffffb3bebadafb8072",5:"8dd3c7ffffb3bebadafb807280b1d3",6:"8dd3c7ffffb3bebadafb807280b1d3fdb462",7:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69",8:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5",9:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9",10:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bd",11:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5",12:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"},Default:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676",36:"ff00000000ff00ff00ffff0000ffffff00ff993300000080808000ff6600008080660066ff99cc666699333300ffcc99ccffff9999ffff80803366ff339966ffcc0000ccffd020909933660066cc99cc00ff990033cccccc99ff800000333399008000ffffcc99ccff800080"},Basic:{24:"0000ffff004dffbf0074ff00a400ffff7400ffff0000ffffff0000ffd3003d00ff00ff00ff00ffff9200d3ff000090ff6d00ffff4900ffe80000ff92ff0090ffaa00aaff00004dff"},Light:{24:"6565ffff6593ffd865abff65c865ffffab65ffff6565ffffff6565ffe5658965ff65ff65ff65ffffbd65e5ff6565bcffa765ffff9165fff16565ffbdff65bcffcc65ccff656593ff"},Favorite:{1:"ff0000",2:"ff000000ffff",3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000bfff0000ff800040ffff00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",10:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ff",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080",24:"ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff4000ff8000ffbf00ffff00ffff00bfff0080ff0040"},Pastel:{24:"b5b5ffffb5cbffedb5d7ffb5e5b5ffffd7b5ffffb5b5ffffffb5b5fff2b5c7b5ffb5ffb5ffb5ffffdfb5f2ffb5b5dfffd5b5ffffcab5fff8b5b5ffdfffb5dfffe6b5e6ffb5b5cbff"},Balanced:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676"},Rpalette:{8:"000000ff000000cd000000ff00ffffff00ffffff00bebebe"},RlatticeBackground:{7:"ffe5ccccffccccffffcce6ffffccffffccccffffcc"},RlatticeShingle:{7:"ff7f0000ff0000ffff0080ffff00ffff0000ffff00"},RlatticeLine:{7:"0080ffff00ff006400ff0000ffa50000ff00a52a2a"},RlatticePolygon:{7:"ccffffffccffccffccffe5cccce6ffffffccffcccc"},Bootstrap:{1:"337ab7",2:"337ab7d9534f",3:"337ab75cb85cd9534f",4:"337ab75cb85cf0ad4ed9534f",5:"337ab75cb85c5bc0def0ad4ed9534f",6:"337ab75cb85c9370db5bc0def0ad4ed9534f",7:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976",8:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976c86727"},ColorSpectrum:{1:""},White:{1:"ffffff"},Black:{1:"000000"},NPG:{10:"e64b354dbbd500a0873c5488f39b7f8491b491d1c2dc00007e6148b09c85"},AAAS:{10:"3b4992ee0000008b45631879008280bb00215f559ba200568081801b1919"},NEJM:{8:"bc3c290072b5e1872720854e7876b16f99adffdc91ee4c97"},Lancet:{9:"00468bed000042b5400099b4925e9ffdaf91ad002aadb6b61b1919"},Jama:{7:"374e55df8f4400a1d5b2474579af976a659980796b"},JCO:{10:"0073c2efc000868686cd534c7aa6dc003c678f77003b3b3ba730304a6990"},Economist:{12:"6794a7014d6476c0c101a2d97ad2f600887dadadad7bd3f67c260bee8f7176c0c1a18376"},EconomistBG:{5:"d5e4ebc3d6dfed111aebebebc9c9c9"},Excel:{7:"ff00ffffff0000ffff8000808000000080800000ff"},Excel2:{7:"993366ffffccccffff660066ff80800066ccccccff"},Excel3:{10:"365e9698333477973d5d437c36869fd1702f8197c5c47f80acc4849887b0"},GGPlot:{1:"f8766d",2:"f8766d00bfc4",3:"f8766d00ba38619cff",4:"f8766d7cae0000bfc4c77cff",5:"f8766da3a50000bf7d00b0f6e76bf3",6:"f8766db79f0000ba3800bfc4619cfff564e3",7:"f8766dc49a0053b40000c09400b6eba58afffb61d7",8:"f8766dcd96007cae0000be6700bfc400a9ffc77cffff61cc",9:"f8766dd3920093aa0000ba3800c19f00b9e3619cffdb72fbff61c3",10:"f8766dd89000a3a50039b60000bf7d00bfc400b0f69590ffe76bf3ff62bc",11:"f8766ddb8e00aea20064b20000bd5c00c1a700bade00a6ffb385ffef67ebff63b6",12:"f8766dde8c00b79f007cae0000ba3800c08b00bfc400b4f0619cffc77cfff564e3ff64b0",13:"f8766de18a00be9c008cab0024b70000be7000c1ab00bbda00acfc8b93ffd575fef962ddff65ac",14:"f8766de38900c49a0099a80053b40000bc5600c09400bfc400b6eb06a4ffa58affdf70f8fb61d7ff66a8",15:"f8766de58700c99800a3a5006bb10000ba3800bf7d00c0af00bcd800b0f6619cffb983ffe76bf3fd61d1ff67a4",16:"f8766de68613cd9600aba3007cae000cb70200be6700c19a00bfc400b8e700a9ff8494ffc77cffed68edff61ccff68a1",17:"f8766de7851ed09400b2a10089ac0045b50000bc5100c08700c0b200bcd600b3f229a3ff9c8dffd277fff166e8ff61c7ff689e",18:"f8766de88526d39200b79f0093aa005eb30000ba3800bf7400c19f00bfc400b9e300adfa619cffae87ffdb72fbf564e3ff61c3ff699c"},Solarized:{1:"b58900",2:"b58900859900",3:"b58900c671c4859900",4:"b58900dc322f268bd2859900",5:"b58900dc322f6c71c4268bd2859900",6:"b58900cb4b16d336826c71c42aa198859900",7:"b58900cb4b16dc322f6c71c4268bd22aa198859900",8:"b58900cb4b16dc322fd336826c71c4268bd22aa198859900"},SolarizedBase:{7:"002b36073642586e7583949693a1a1eee8d5fdf6e3",8:"002b36073642586e75657b8383949693a1a1eee8d5fdf6e3"},PaulTol:{1:"4477aa",2:"4477aacc6677",3:"4477aaddcc77cc6677",4:"4477aa117733ddcc77cc6677",5:"4477aa88ccee117733ddcc77cc6677",6:"4477aa88ccee117733ddcc77cc6677aa4499",7:"33228888ccee44aa99117733ddcc77cc6677aa4499",8:"33228888ccee44aa99117733999933ddcc77cc6677aa4499",9:"33228888ccee44aa99117733999933ddcc77cc6677882255aa4499",10:"33228888ccee44aa99117733999933ddcc77661100cc6677882255aa4499",11:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677882255aa4499",12:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677aa4466882255aa4499"},ColorBlind:{8:"000000e69f0056b4e9009e73f0e4420072b2d55e00cc79a7"},Tableau:{20:"1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",10:"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"},TableauMedium:{10:"729eceff9e4a67bf5ced665dad8bc9a8786eed97caa2a2a2cdcc5d6dccda"},TableauLight:{10:"aec7e8ffbb7898df8aff9896c5b0d5c49c94f7b6d2c7c7c7dbdb8d9edae5"},TableauGrey:{5:"60636aa5acaf4144518f8782cfcfcf"},TableauColorBlind:{10:"006ba4ff800eababab5959595f9ed1c85200898989a2c8ecffbc79cfcfcf"},TableauTrafficLight:{9:"b10318dba13a309343d82526ffc15669b764f26c64ffdd719fcd99"},TableauPurpleGrey:{12:"7b66d2a699e8dc5fbdffc0da5f5a41b4b19b995688d898baab6ad5d098ee8b7c6edbd4c5"},TableauBlueRed:{12:"2c69b0b5c8e2f02720ffb6b0ac613ce9c39b6ba3d6b5dffdac8763ddc9b4bd0a36f4737a"},TableauGreenOrange:{12:"32a251acd98dff7f0fffb9773cb7cc98d9e4b85a0dffd94a39737c86b4a982853bccc94d"},TableauCyclic:{20:"1f83b41696ac18a18829a03c54a33882a93fadb828d8bd35ffbd4cffb022ff9c0eff810ee75727d23e4ec94d8cc04aa7b446b39658b18061b46f63bb"},TableauPairSequential:{32:"bccfb49c0824bccfb409622ab4d4da26456ef0c2947b3014c3c3c31e1e1ee5e5e5ffb2b6e5e5e5b7e6a7e5e5e5c4d8f3e5e5e5ffcc9ef5cac7bd1100dbe8b43c8200f3e0c2bb5137feffd941b7c4f7e4c6bb5137efedf5807dbaf0f0f0737373"},TableauTripleDiverging:{48:"9c0824cacaca26456e9c0824cacaca09622a9c0824ffffff09622a9c0824cacaca1e1e1e9c0824ffffff1e1e1e09622acacaca26456e7b3014cacaca26456e7b3014ffffff26456effb2b6e5e5e5b7e6a7ffb2b6ffffffb7e6a7ffb2b6ffffffc6c6c6ffcc9ee5e5e5c4d8f3ffcc9effffffc4d8f3e0ad30e4e4e27492aaeda389cde1d35c8b70529985dbcf47c26b51"},WallStreetJournal:{4:"efefefe9f3ead4dee7f8f2e4"},WallStreetJournal2:{4:"d3ba68d5695d5d8ca865a479"},WallStreetJournalRedGreen:{2:"088158ba2f2a"},WallStreetJournalBlackGreen:{4:"00000059595959a77f008856"},WallStreetJournalDemRep:{3:"006a8eb1283aa8a6a7"},WallStreetJournal3:{6:"c72e29016392be9c2e098154fb832d000000"},Stata:{15:"1a476f90353b55752fe37e006e8e84c10534938dd2cac27ea0522d7b92a82d6d669c8847bfa19cffd200d9e6eb"},Stata2:{15:"ffff0000ff000080ffff00ffff7f00ff0000add8e6ffe47400ff80c0dcc0ff45000000ffff00806e8e84a0522d"},Stata3:{15:"006000ff45001a476f90353b6e8e84a0522dff7f00ff00ff00ffffff000000ff009c8847800080c0dcc0add8e6"},StataMono:{15:"606060a0a0a0808080404040000000e0e0e0202020707070909090b0b0b0d0d0d0f0f0f0303030c0c0c0505050"},BlackAndWhite:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000"},CanvasXpress:{1:"4575b4",2:"d730274575b4",3:"d7191cfdae612c7bb6",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},CanvasXpressTraditional:{1:"f2000d",2:"f2000d000df2",3:"f2000d000df20df200",4:"f2000d000df20df200f2f20d",5:"f2000d000df20df200f2f20df20df2",6:"f2000d000df20df200f2f20df20df20df2f2",7:"f2000d000df20df200f2f20df20df20df2f2f2f2f2",8:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd3",9:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fe",10:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b",11:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d0016",12:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d",13:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00",14:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808",15:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38b",16:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe",17:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3",18:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3404040"},Matlab:{7:"0072bdd95319edb1207e2f8e77ac304dbeeea2142f"},Parula:{10:"352a870f5cdd127dd8079ccf15b1b459bd8ca5be6be1b952fcce2ef9fb0e"},Viridis:{3:"44015421908cfde725",4:"44015431688e35b779fde725",5:"4401543b528b21908c5dc863fde725",6:"4401544144872a788e22a8847ad151fde725",7:"440154443a8331688e21908c35b7798fd744fde725",8:"44015446337e365c8d277f8e1fa1874ac16d9fda3afde725",9:"440154472d7b3b528b2c728e21908c27ad815dc863aadc32fde725",10:"4401544828783e4a8931688e26828e1f9e8935b7796dcd59b4de2cfde725",11:"44015448257641448735608d2a788e21908c22a88443bf717ad151bbdf27fde725",12:"440154482173433e8538598c2d708e25858e1e9b8a2bb07f51c56a85d54ac2df23fde725",256:"44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725"},Magma:{3:"000004b63679fcfdbf",4:"000004721f81f1605dfcfdbf",5:"00000451127cb63679fb8861fcfdbf",6:"0000043b0f708c2981de4968fe9f6dfcfdbf",7:"0000042d1160721f81b63679f1605dfeaf77fcfdbf",8:"0000042311515f187f982d80d3436ef8765cfeba80fcfdbf",9:"0000041d114751127c822681b63679e65164fb8861fec287fcfdbf",10:"000004180f3e451077721f819f2f7fcd4071f1605dfd9567fec98dfcfdbf",11:"000004150e373b0f70641a808c2981b63679de4968f76f5cfe9f6dfece91fcfdbf",12:"000004120d323310685a167e7d2482a3307ec83e73e95562f97c5dfea873fed395fcfdbf",256:"00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf"},Plasma:{3:"0d0887cc4678f0f921",4:"0d08879c179eed7953f0f921",5:"0d08877e03a8cc4678f89441f0f921",6:"0d08876a00a8b12a90e16462fca636f0f921",7:"0d08875d01a69c179ecc4678ed7953fdb32ff0f921",8:"0d08875402a38b0aa5b93289db5c68f48849febc2af0f921",9:"0d08874c02a17e03a8a92395cc4678e56b5df89441fdc328f0f921",10:"0d088747039f7301a89c179ebd3786d8576bed7953fa9e3bfdc926f0f921",11:"0d088742049e6a00a8900da4b12a90cc4678e16462f1844bfca636fcce25f0f921",12:"0d08873e049c6300a78707a6a62098c03a83d5546ee76f5af58c46fdad32fcd225f0f921",256:"0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"},Inferno:{3:"000004bb3754fcffa4",4:"000004781c6ded6925fcffa4",5:"00000456106ebb3754f98c0afcffa4",6:"000004420a68932667dd513afca50afcffa4",7:"000004330a5f781c6dbb3754ed6925fcb519fcffa4",8:"000004280b5465156e9f2a63d44842f57d15fac127fcffa4",9:"000004210c4a56106e89226abb3754e35932f98c0af9c932fcffa4",10:"0000041b0c424b0c6b781c6da52c60cf4446ed6925fb9a06f7d03cfcffa4",11:"000004170c3a420a686b186e932667bb3754dd513af3771afca50af6d645fcffa4",12:"000004140b353a096360136e85216ba92e5ecb4149e65d2ff78311fcad12f5db4bfcffa4",256:"00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4"},Cividis:{3:"00204d7c7b78ffea46",4:"00204d575c6da69d75ffea46",5:"00204d414d6b7c7b78bcaf6fffea46",6:"00204d31446b666970958f78cbba69ffea46",7:"00204d233e6c575c6d7c7b78a69d75d3c164ffea46",8:"00204d16396d4b546c6c6e728e8a79b3a772dbc761ffea46",9:"00204d05366e414d6b61646f7c7b789b9477bcaf6fe0cb5effea46",10:"00204d00336f39486b575c6d7071738a8779a69d75c4b56ce4cf5bffea46",11:"00204d00326f31446b4e576c6669707c7b78958f78b0a473cbba69e7d159ffea46",12:"00204d00306f2a406c48526b5e626e7273748784799e9677b6a971d0be67ead357ffea46",256:"00204c00204e00215000225100235300235500245600255800265a00265b00275d00285f002861002963002a64002a66002b68002c6a002d6c002d6d002e6e002e6f002f6f002f6f00306f00316f00316f00326e00336e00346e00346e01356e06366e0a376d0e376d12386d15396d17396d1a3a6c1c3b6c1e3c6c203c6c223d6c243e6c263e6c273f6c29406b2b416b2c416b2e426b2f436b31446b32446b33456b35466b36466b37476b38486b3a496b3b496b3c4a6b3d4b6b3e4b6b404c6b414d6b424e6b434e6b444f6b45506b46506b47516b48526b49536b4a536b4b546b4c556b4d556b4e566b4f576c50586c51586c52596c535a6c545a6c555b6c565c6c575d6d585d6d595e6d5a5f6d5b5f6d5c606d5d616e5e626e5f626e5f636e60646e61656f62656f63666f64676f65676f666870676970686a70686a70696b716a6c716b6d716c6d726d6e726e6f726f6f726f70737071737172737272747373747474757575757575757676767777767878767978777a79777b7a777b7b787c7b787d7c787e7d787f7e78807e78817f788280788381788481788582788683788784788885788985788a86788b87788c88788d88788e89788f8a78908b78918c78928c78938d78948e78958f78968f779790779891779992779a93779b93779c94779d95779e96769f9776a09876a19876a29976a39a75a49b75a59c75a69c75a79d75a89e74a99f74aaa074aba174aca173ada273aea373afa473b0a572b1a672b2a672b4a771b5a871b6a971b7aa70b8ab70b9ab70baac6fbbad6fbcae6ebdaf6ebeb06ebfb16dc0b16dc1b26cc2b36cc3b46cc5b56bc6b66bc7b76ac8b86ac9b869cab969cbba68ccbb68cdbc67cebd67d0be66d1bf66d2c065d3c065d4c164d5c263d6c363d7c462d8c561d9c661dbc760dcc860ddc95fdeca5edfcb5de0cb5de1cc5ce3cd5be4ce5be5cf5ae6d059e7d158e8d257e9d356ebd456ecd555edd654eed753efd852f0d951f1da50f3db4ff4dc4ef5dd4df6de4cf7df4bf9e049fae048fbe147fce246fde345ffe443ffe542ffe642ffe743ffe844ffe945"},Rainbow:{3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000ccff0000ff660066ffcc00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",7:"ff0000ffdb0049ff0000ff920092ff4900ffff00db",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",9:"ff0000ffaa00aaff0000ff0000ffaa00aaff0000ffaa00ffff00aa",10:"ff0000ff9900ccff0033ff0000ff6600ffff0066ff3300ffcc00ffff0099",11:"ff0000ff8b00e8ff005dff0000ff2e00ffb900b9ff002eff5d00ffe800ffff008b",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080"},Heat:{3:"ff0000ff8000ffff00",4:"ff0000ff8000ffff00ffff80",5:"ff0000ff5500ffaa00ffff00ffff80",6:"ff0000ff4000ff8000ffbf00ffff00ffff80",7:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff80",8:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff40ffffbf",9:"ff0000ff2a00ff5500ff8000ffaa00ffd500ffff00ffff40ffffbf",10:"ff0000ff2400ff4900ff6d00ff9200ffb600ffdb00ffff00ffff40ffffbf",11:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff40ffffbf",12:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff2affff80ffffd5"},LastAirBenderFire:{8:"ecb100a100007E605EFF45009948234B4C4E572530000000"},LastAirBenderAir:{7:"ff9933C24841FFFF338B5B4587AFD1EEB05ADBC5A0"},LastAirBenderEarth:{9:"015E05B1A8667A5C1264674225351C4C7022C7C45ED2CFABFEFED8"},LastAirBenderWater:{8:"0047ab1DB4D3A2CAEDAFB5B8120976fffafa174D79949BBC"},SpongeBob:{11:"C86925FDF56CC4433F989B46FC95765D57AFB2CE31FF2027000000B1D6C5AB8323"},Simpsons:{10:"fed90f424f46d1b271FB4122ABC67D0363C37A491E000000FC020946732E"},RickyAndMorty:{9:"01B4C697ce4cFFF874BEE5FDF675DA44281d3a4767F8D3ACE64358"},ParksAndRecreation:{10:"bdbdbda51209ffdb58ec70147A491EC24841005502f7fcb969983ab5651d"},KimPossible:{12:"FF8C0002466370D42389160402001F9CF6F7FFCE455D734DFEC3BB662C9Cfff9f5000000"},GravityFalls:{14:"417BA1ff1493ffff2e3456348b0000ff670093C0D58b45139248A71c88594747478fbc8fd2b48c000000"},GameOfThronesStark:{9:"cadde17B906F174D79fffafa898989D4CDB1708090120976000000"},GameOfThronesStannis:{7:"FF0000ff8d1aFFD700b20000cc6600FFFF66000000"},GameOfThronesLannister:{6:"89080AC5AA73FEDF25C248418B5B45000000"},GameOfThronesTyrell:{9:"068105F7DC27808000AB681BF9FE768DA08071749798FB983CB371"},GameOfThronesTargaryen:{5:"AC1F25272727ff993382878896804b"},GameOfThronesMartell:{8:"ff8000cc6600b81b1873110ff8fc23fafd7b4c2600a57642"},GameOfThronesTully:{6:"212250AE432FE4EDCA8B5B454682B4000000"},GameOfThronesGreyjoy:{6:"000000708090D4CDB1DCDCDCF7DC27808080"},GameOfThronesManderly:{7:"40e0d080808000ff00282828015202195953FFFFFF"},GameOfThronesArryn:{7:"007fff7fbfff0019334c4cffffefb2a89797FFFFFF"},Brooklyn99Regular:{10:"e7298a72bcd4e41a1cFCF40E49f149f16913525252F9FEFF000E33000000"},Brooklyn99Dark:{9:"6CA9C33A3533000E33800000CBCFD2175E78DAA520174D79000000"}};for(var c in CanvasXpress.colorSchemes){for(var d in CanvasXpress.colorSchemes[c]){var b=CanvasXpress.colorSchemes[c][d].match(/.{6}/g);CanvasXpress.colorSchemes[c][d]=b?b.map(function(a){return"#"+a}):[]}}}();CanvasXpress.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]};CanvasXpress.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]};CanvasXpress.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"};CanvasXpress.themes={economist:{backgroundType:"solid",backgroundWindow:"#D5E4EB",background:"#D5E4EB",colorScheme:"Economist",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#D5E4EB",legendColumns:4,legendInside:true,legendPosition:"top",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:2,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickColor:"#000000",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisTickStyle:"solid",xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:false,yAxis2Show:true,yAxisTickStyle:"solid",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",mapOutlineColor:"#D5E4EB",conditional:{OneDPlots:{xAxisMajorTicks:true}}},excel:{backgroundType:"window",backgroundWindow:"#C0C0C0",background:"#FFFFFF",colorScheme:"Excel",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#000000",legendBox:true,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickColor:"#000000",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisTickStyle:"solid",xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"#000000",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",mapOutlineColor:"#C0C0C0",conditional:{OneDPlots:{xAxisMajorTicks:true}}},tableau:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#E5E5E5",colorScheme:"TableauMedium",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#000000",legendBox:true,legendBoxColor:"#E5E5E5",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"#E5E5E5",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#E5E5E5",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",mapOutlineColor:"#E5E5E5"},stata:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#EAF2F3",colorScheme:"Stata",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#000000",legendBox:true,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:4,legendInside:false,legendPosition:"bottom",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:2,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickStyle:"solid",xAxisTickColor:"#000000",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"#EAF2F3",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000",mapOutlineColor:"#EAF2F3",conditional:{OneDPlots:{xAxisMajorTicks:true}}},igray:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#E5E5E5",colorScheme:"GGPlot",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:false,yAxisBottomMajorTick:false,yAxisTopBottomTickColor:"#000000",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000",mapOutlineColor:"#FFFFFF"},solarized:{backgroundType:"solid",backgroundWindow:"#FDF6E3",background:"#FDF6E3",colorScheme:"Solarized",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#93A1A1",legendBox:true,legendBoxColor:"#93A1A1",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#93A1A1",axisTitleColor:"#93A1A1",axisTickThickness:1,axisMinMaxTickThickness:2,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"#93A1A1",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#93A1A1",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"#93A1A1",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#93A1A1",titleAlign:"left",titleColor:"#93A1A1",subtitleAlign:"left",subtitleColor:"#93A1A1",mapOutlineColor:"#FDF6E3"},paulTol:{backgroundType:"solid",backgroundWindow:"#FFFFFF",background:"#FFFFFF",colorScheme:"PaulTol",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#E5E5E5",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:false,yAxisBottomMajorTick:false,yAxisTopBottomTickColor:"#E5E5E5",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",mapOutlineColor:"#FFFFFF"},ggplot:{backgroundType:"window",backgroundWindow:"#E5E5E5",background:"#FFFFFF",colorScheme:"GGPlot",objectBorderColor:"rgb(0,0,0)",guides:true,guidesColor:"#FFFFFF",legendColor:"#000000",legendBox:true,legendBoxColor:"rgba(0,0,0,0)",legendBackgroundColor:"rgba(0,0,0,0)",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"#FFFFFF",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#FFFFFF",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#FFFFFF",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000",mapOutlineColor:"#FFFFFF"},wallStreetJournal:{backgroundType:"solid",backgroundWindow:"#F8F2E4",background:"#F8F2E4",colorScheme:"WallStreetJournal3",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#F8F2E4",legendColumns:4,legendInside:true,legendPosition:"top",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:2,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickStyle:"dotted",xAxisTickColor:"#000000",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"dotted",yAxisTickColor:"#000000",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",mapOutlineColor:"#F8F2E4",conditional:{OneDPlots:{xAxisMajorTicks:true}}},cx:{backgroundType:"window",backgroundWindow:"#E8E8E8",background:"#FFFFFF",colorScheme:"CanvasXpress",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",legendColor:"#000000",legendBox:true,legendBoxColor:"#FFFFFF",legendBackgroundColor:"#E8E8E8",lineDecoration:"symbol",axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"#FFFFFF",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"#337AB7",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#337AB7",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000",mapOutlineColor:"rgb(204,204,204)",conditional:{OneDPlots:{plotBox:true,plotBoxColor:"#337AB7"}}},blackAndWhite:{backgroundType:"solid",backgroundWindow:"rgb(255,255,255)",background:"rgb(255,255,255)",colorScheme:"BlackAndWhite",objectBorderColor:"rgb(0,0,0)",foreground:"rgb(0,0,0)",guides:false,guidesColor:"rgba(255,255,255,0)",legendColor:"rgb(0,0,0)",legendBox:false,legendBoxColor:"rgba(255,255,255,0)",legendBackgroundColor:"rgba(255,255,255,0)",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,lineDecoration:"pattern",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"rgb(0,0,0)",axisTitleColor:"rgb(0,0,0)",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:true,xAxisMajorTicks:true,xAxisTickStyle:"dotted",xAxisTickColor:"rgb(0,0,0)",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"rgb(0,0,0)",yAxisMajorTicks:true,yAxisMinorTicks:true,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"dotted",yAxisTickColor:"rgb(0,0,0)",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"rgb(0,0,0)",titleAlign:"center",titleColor:"rgb(0,0,0)",subtitleAlign:"center",subtitleColor:"rgb(0,0,0)",mapOutlineColor:"rgb(0,0,0)",plotBoxColor:"rgb(0,0,0)",plotBox:true},lastAirBender:{backgroundType:"solid",backgroundWindow:"rgb(236,229,211)",background:"rgb(236,229,211)",foreground:"rgb(51,51,51)",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgba(255,255,255,0)",legendColor:"rgb(51,51,51)",legendBox:false,legendBoxColor:"rgba(236,229,211,0)",legendBackgroundColor:"rgba(236,229,211,0)",legendColumns:3,legendInside:false,legendPosition:"bottom",legendScaleFontFactor:1,lineDecoration:"false",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"rgb(51,51,51)",axisTitleColor:"rgb(51,51,51)",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:true,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"rgb(51,51,51)",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"rgb(51,51,51)",yAxisMajorTicks:true,yAxisMinorTicks:true,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"rgb(51,51,51)",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"rgb(51,51,51)",titleAlign:"center",titleColor:"rgb(51,51,51)",subtitleAlign:"center",subtitleColor:"rgb(51,51,51)",mapOutlineColor:"rgb(51,51,51)",plotBoxColor:"rgb(51,51,51)",plotBox:false},gameOfThrones:{backgroundType:"solid",backgroundWindow:"rgb(255,255,255)",background:"rgb(255,255,255)",foreground:"rgb(51,51,51)",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgba(255,255,255,0)",legendColor:"rgb(51,51,51)",legendBox:false,legendBoxColor:"rgba(255,255,255,0)",legendBackgroundColor:"rgba(255,255,255,0)",legendColumns:3,legendInside:false,legendPosition:"bottom",legendScaleFontFactor:1,lineDecoration:"false",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"rgb(51,51,51)",axisTitleColor:"rgb(51,51,51)",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:true,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"rgb(51,51,51)",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"rgb(51,51,51)",yAxisMajorTicks:true,yAxisMinorTicks:true,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"rgb(51,51,51)",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"rgb(51,51,51)",titleAlign:"center",titleColor:"rgb(51,51,51)",subtitleAlign:"center",subtitleColor:"rgb(51,51,51)",mapOutlineColor:"rgb(51,51,51)",plotBoxColor:"rgb(51,51,51)",plotBox:false},none:{backgroundType:"solid",backgroundWindow:"rgb(244,244,244)",background:"rgb(255,255,255)",colorScheme:"User",objectBorderColor:"rgb(0,0,0)",guides:false,guidesColor:"rgb(204,204,204)",colors:CanvasXpress.colorSchemes.Default[20],legendColor:"rgb(0,0,0)",legendBox:false,legendBoxColor:"rgb(204,204,204)",legendBackgroundColor:"rgba(255,255,255,0)",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,lineDecoration:"symbol",axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"rgb(0,0,0)",axisTitleColor:"rgb(0,0,0)",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:true,xAxisMajorTicks:true,xAxisTickStyle:"solid",xAxisTickColor:"rgb(204,204,204)",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"rgb(204,204,204)",yAxisMajorTicks:true,yAxisMinorTicks:true,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"solid",yAxisTickColor:"rgb(204,204,204)",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"rgb(204,204,204)",titleAlign:"center",titleColor:"rgb(0,0,0)",subtitleAlign:"center",subtitleColor:"rgb(0,0,0)",mapOutlineColor:"rgb(204,204,204)"}};CanvasXpress.themes.CanvasXpress=CanvasXpress.themes.cx;CanvasXpress.themes.canvasXpress=CanvasXpress.themes.cx;CanvasXpress.themes.canvasxpress=CanvasXpress.themes.cx;CanvasXpress.themes.paultol=CanvasXpress.themes.paulTol;CanvasXpress.themes.PaulTol=CanvasXpress.themes.paulTol;CanvasXpress.R={lty:[[0,0],[],[8,6],[1,3],[1,3,5,3],[14,6],[4,3,8,3]],ltyNames:["blank","solid","dashed","dotted","dotdash","longdash","twodash"]};CanvasXpress.prototype.initDOM=function(){this.$=function(id){return window.document.getElementById(id)};this.$cX=function(t,p,s){var e=window.document.createElement(t);if(p){for(var i in p){e[i]=p[i]}}if(s){for(var i in s){e.style[i]=s[i]}}return e};this.$cXI=function(k,p,s,x,d){var el=document.createElementNS("http://www.w3.org/2000/svg","svg");var t="";var classes=function(svg){var sn={};var sp=svg.split(/class=/);var c="<style>";for(var ii=1;ii<sp.length;ii++){var m=sp[ii].match(/"(.+?)"/);if(m){var cs=m[1].split(/\s+/);for(var jj=0;jj<cs.length;jj++){var ms=cs[jj];if(CanvasXpress.icons.classes.hasOwnProperty(ms)&&!sn.hasOwnProperty(ms)){c+="."+ms+CanvasXpress.icons.classes[ms]}}}}c+="</style>";return c};if(CanvasXpress.icons.use.hasOwnProperty(k)){var svg='<rect class="cxnc" x="0" y="0" width="100" height="100" />';if(CanvasXpress.icons.gradients.hasOwnProperty(k)){svg+=CanvasXpress.icons.gradients[k].replace(/&quot;/g,'"')}for(var i=0;i<CanvasXpress.icons.use[k].length;i++){svg+=CanvasXpress.icons.symbols[CanvasXpress.icons.use[k][i]].replace(/&quot;/g,'"').replace(/&apos;/g,"'")}var c=classes(svg);if(!d){d=24}el.setAttribute("xmlns","http://www.w3.org/2000/svg");el.setAttribute("viewBox","0 0 100 100");el.setAttribute("style","width:"+d+"px;height:"+d+"px;");if(p){for(var i in p){if(i=="className"){el.setAttribute("class",p[i])}else{el.setAttribute(i,p[i]);if(i=="title"){t="<title>"+p[i]+"</title>"}}}}if(s){for(var i in s){el.style[i]=s[i]}}el.innerHTML=t+c+svg}return x?new XMLSerializer().serializeToString(el):el};this.$cXIU=function(el,k,p,s){var t="";var classes=function(svg){var sn={};var sp=svg.split(/class=/);var c="<style>";for(var ii=1;ii<sp.length;ii++){var m=sp[ii].match(/"(.+?)"/);if(m){var cs=m[1].split(/\s+/);for(var jj=0;jj<cs.length;jj++){var ms=cs[jj];if(CanvasXpress.icons.classes.hasOwnProperty(ms)&&!sn.hasOwnProperty(ms)){c+="."+ms+CanvasXpress.icons.classes[ms]}}}}c+="</style>";return c};if(el&&CanvasXpress.icons.use.hasOwnProperty(k)){var svg='<rect class="cxnc" x="0" y="0" width="100" height="100" />';if(CanvasXpress.icons.gradients.hasOwnProperty(k)){svg+=CanvasXpress.icons.gradients[k].replace(/&quot;/g,'"')}for(var i=0;i<CanvasXpress.icons.use[k].length;i++){svg+=CanvasXpress.icons.symbols[CanvasXpress.icons.use[k][i]].replace(/&quot;/g,'"').replace(/&apos;/g,"'")}var c=classes(svg);if(p){for(var i in p){if(i=="className"){el.setAttribute("class",p[i])}else{el.setAttribute(i,p[i]);if(i=="title"){t="<title>"+p[i]+"</title>"}}}}if(s){for(var i in s){el.style[i]=s[i]}}el.innerHTML=t+c+svg}};this.setPixelImage=function(){if(CanvasXpress.instances.length==1){this.beaconImage=this.$cX("img",{id:this.target+"-cX-Beacon-Image",src:(window.navigator.onLine?"https://www.canvasxpress.org/assets/images/beacon.gif?"+CanvasXpress.factory.client:CanvasXpress.png),title:"",alt:""})}else{this.beaconImage=CanvasXpress.instances[0].beaconImage}};this.$$=function(){var t=this;var c=CanvasXpress;var f=function(k){if(!k){k=c[d[4]]}var len=k.length;var ini=Number(k.substring(2,3));var end=Number(k.substring(len-3,len-2));var str=k.substring(3+ini,3+ini+5)[d[7]]("")[d[8]]()[d[9]]("");var fns=k.substring(len-(3+end+5),len-(3+end));return Number(str+""+fns+"000")};var w=["686578546f537472696e67","6472617754657874","666163746f7279","73797374656d","72656769737465726564","76616c6964","737562737472696e67","73706c6974","72657665727365","6a6f696e","43616e766173587072657373","4e6f7420612076616c696420636f7079206f6620","556e737570706f727465642056657273696f6e206f6620","20522056657273696f6e","204e6f64652056657273696f6e","697352566965776572","697352436f6e736f6c65","68726566","2f7777772e63616e7661737870726573732e6f72672f646973742f","72616e646f6d496e744265747765656e","666f6e7453697a65"];var h=t.hexToString("686578546f537472696e67");var d=[];for(var i=0;i<w.length;i++){d.push(t[h](w[i]))}var r=Number(f());var s=Number(t.meta.time.start);var v=isNaN(c[d[2]][d[5]])?Number(f(c[d[2]][d[5]])):0;var x=new RegExp(d[18]).test(c[d[2]][d[17]])||c[d[3]][d[15]]||c[d[3]][d[16]];var m=d[10];var b=t[d[20]];var q=1;if(!x){if(r-s<0){if(!v||v-s<0){if(c[d[2]][d[5]]){b+=4;q+=2;m=d[11]+d[10]}setTimeout(function(){t[d[1]](m,t.width-(b/4),t.height-(b/2),t.font,"rgba(0,0,0,0."+q+")","right","middle")},t[d[19]](1,8)*1000)}}}};this.showMask=function(){var c=this.$(this.target);var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.height=parseInt((c.height/2)-100.5)+"px";l.style.display="block"}};this.hideMask=function(){var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.display="none"}this.loaded=true;this.$$()};this.createNewTarget=function(){var cn=this.$cX("canvas").setAttribute("id",this.newId("-canvasXpress-"));window.document.body.appendChild(cn);return cn.id};this.newId=function(t){var n=0;var i=this.target+t+n;while(this.meta.ids[i]){n++;i=this.target+t+n}this.meta.ids[i]=true;return i};this.insertTarget=function(t,p,w,h,a){if(t&&p){var c=this.$(t);if(c){return}else{c=this.$cX("canvas",{id:t,width:w,height:h});this.castCanvasAttributes(c)}if(a){p.parentNode.insertBefore(c,p.nextSibling)}else{p.parentNode.insertBefore(c,p)}}};this.castCanvasAttributes=function(c,e){if(!e){e=this.meta.canvas.ctx.canvas}CanvasXpress.transferDatasetAttributes(e,c)};this.removeTarget=function(t){var n=this.$(t);if(n){n.parentNode.removeChild(n)}};this.getWindowSize=function(){var doc=window.document;var w=window.innerWidth||doc.documentElement.clientWidth||doc.body.clientWidth;var h=window.innerHeight||doc.documentElement.clientHeight||doc.body.clientHeight;return[w,h]};this.getWindowScroll=function(){var d=window.document.documentElement;var l=(window.pageXOffset||d.scrollLeft)-(d.clientLeft||0);var t=(window.pageYOffset||d.scrollTop)-(d.clientTop||0);return[l,t]};this.isInViewport=function(el,d){var w=this.getWindowSize();var b=el.getBoundingClientRect();var c=b.right-(this.width*0.5);var m=b.bottom-(this.height*0.5);return b.left>=0&&b.top>=0&&c<=w[0]&&m<=w[1]};this.hasClass=function(e,n){return e?e.classList.contains(n):false};this.addClass=function(e,n){if(e){e.classList.add(n)}};this.removeClass=function(e,n){if(e){e.classList.remove(n)}};this.getComputedCSS=function(e){var s="";var o=getComputedStyle(e);for(var i=0;i<o.length;i++){s+=o[i]+":"+o.getPropertyValue(o[i])+";"}return s};this.cancelEvent=function(e){if(!e){return}if(CanvasXpress.system.browser.match(/safari/i)){return false}else{if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}}};this.stopEvent=function(e){if(!e){return}if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=true}};this.normalizeEvtName=function(e){return CanvasXpress.system.isIE?"on"+e:e};this.copyEvent=function(e){var ce={};for(var i in e){ce[i]=e[i]}return ce};this.addEvtListener=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;if(o.id){if(!m[o.id]){m[o.id]={}}m[o.id][e]=[c,f]}else{if(!m[o]){m[o]={}}m[o][e]=[c,f]}if(CanvasXpress.system.isIE){o.attachEvent(this.normalizeEvtName(e),c)}else{if(e=="touchstart"){o.addEventListener(e,c,f)}else{if(e=="mousewheel"){o.addEventListener(e,c,f);o.addEventListener("DOMMouseScroll",c,f)}else{o.addEventListener(e,c,f)}}}}};this.removeEvtListener=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;var k=m[o.id||o];if(k&&k.hasOwnProperty(e)){delete (k[e]);if(CanvasXpress.system.isIE){o.detachEvent(this.normalizeEvtName(e),c)}else{o.removeEventListener(e,c,f);if(e=="mousewheel"){o.removeEventListener("DOMMouseScroll",c,f)}}var v=this.getKeys(m[o.id||o]);if(v&&v.length<1){delete (m[o.id||o])}}}};this.addRemoveEvtListener=function(t,o,e,c,f){if(t&&o&&e&&c){this[t](o,e,c,f)}};this.purgeEventListeners=function(){var m=this.meta.events;for(var i in m){var o=this.$(i)||i;for(var e in m[i]){this.removeEvtListener(o,e,m[i][0],m[i][1])}}};this.preventSelection=function(){var d=window.document;if(d.selection){d.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.getTargetEvent=function(e){var obj=e.target||e.srcElement;if(typeof(obj)!="object"){obj=this.$(obj)}if(obj instanceof SVGElement&&obj.ownerSVGElement){obj=obj.ownerSVGElement}return obj};this.dispatchEvent=function(el,e){el.dispatchEvent(e)};this.requestAnimationFrame=function(callback,time){if(callback){raf=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame;if(raf){raf(callback)}else{if(!time){time=1000/60}window.setTimeout(callback,time)}}};this.setTimeout=function(callback,time){if(this.isR){setTimeout(callback,time)}else{var that=this;var wait=function(t){return new Promise(function(resolve,reject){if(t){setTimeout(resolve,t)}else{setTimeout(resolve,1000)}})};wait(time).then(function(){callback.apply(that)})}};this.setInterval=function(c,d){this.logConsole("canvasXpress setInterval ready - "+arguments.callee.caller.name+" - "+d);return setInterval(c,d)};if(typeof JSON.decycle!=="function"){JSON.decycle=function decycle(object,replacer){var objects=new WeakMap();return(function derez(value,path){var old_path;var nu;if(replacer!==undefined){value=replacer(value)}if(typeof value==="object"&&value!==null&&!(value instanceof Boolean)&&!(value instanceof Date)&&!(value instanceof Number)&&!(value instanceof RegExp)&&!(value instanceof String)){old_path=objects.get(value);if(old_path!==undefined){return{$ref:old_path}}objects.set(value,path);if(Array.isArray(value)){nu=[];value.forEach(function(element,i){nu[i]=derez(element,path+"["+i+"]")})}else{nu={};Object.keys(value).forEach(function(name){nu[name]=derez(value[name],path+"["+JSON.stringify(name)+"]")})}return nu}return value}(object,"$"))}}if(typeof JSON.retrocycle!=="function"){JSON.retrocycle=function retrocycle($){var px=/^\$(?:\[(?:\d+|"(?:[^\\"\u0000-\u001f]|\\([\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*")\])*$/;(function rez(value){if(value&&typeof value==="object"){if(Array.isArray(value)){value.forEach(function(element,i){if(typeof element==="object"&&element!==null){var path=element.$ref;if(typeof path==="string"&&px.test(path)){value[i]=eval(path)}else{rez(element)}}})}else{Object.keys(value).forEach(function(name){var item=value[name];if(typeof item==="object"&&item!==null){var path=item.$ref;if(typeof path==="string"&&px.test(path)){value[name]=eval(path)}else{rez(item)}}})}}}($));return $}}if(!Array.from){Array.from=(function(){var toStr=Object.prototype.toString;var isCallable=function(fn){return typeof fn==="function"||toStr.call(fn)==="[object Function]"};var toInteger=function(value){var number=Number(value);if(isNaN(number)){return 0}if(number===0||!isFinite(number)){return number}return(number>0?1:-1)*Math.floor(Math.abs(number))};var maxSafeInteger=Math.pow(2,53)-1;var toLength=function(value){var len=toInteger(value);return Math.min(Math.max(len,0),maxSafeInteger)};return function from(arrayLike){var C=this;var items=Object(arrayLike);if(arrayLike==null){throw new TypeError("Array.from requires an array-like object - not null or undefined")}var mapFn=arguments.length>1?arguments[1]:void undefined;var T;if(typeof mapFn!=="undefined"){if(!isCallable(mapFn)){throw new TypeError("Array.from: when provided, the second argument must be a function")}if(arguments.length>2){T=arguments[2]}}var len=toLength(items.length);var A=isCallable(C)?Object(new C(len)):new Array(len);var k=0;var kValue;while(k<len){kValue=items[k];if(mapFn){A[k]=typeof T==="undefined"?mapFn(kValue,k):mapFn.call(T,kValue,k)}else{A[k]=kValue}k+=1}A.length=len;return A}}())}if(!Array.prototype.fill){Object.defineProperty(Array.prototype,"fill",{value:function(value){if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;var start=arguments[1];var relativeStart=start>>0;var k=relativeStart<0?Math.max(len+relativeStart,0):Math.min(relativeStart,len);var end=arguments[2];var relativeEnd=end===undefined?len:end>>0;var finl=relativeEnd<0?Math.max(len+relativeEnd,0):Math.min(relativeEnd,len);while(k<finl){O[k]=value;k++}return O}})}if(typeof Object.assign!="function"){Object.defineProperty(Object,"assign",{value:function assign(target,varArgs){if(target==null){throw new TypeError("Cannot convert undefined or null to object")}var to=Object(target);for(var index=1;index<arguments.length;index++){var nextSource=arguments[index];if(nextSource!=null){for(var nextKey in nextSource){if(Object.prototype.hasOwnProperty.call(nextSource,nextKey)){to[nextKey]=nextSource[nextKey]}}}}return to},writable:true,configurable:true})}if(!Array.prototype.map){Array.prototype.map=function(callback){var T,A,k;if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;if(typeof callback!=="function"){throw new TypeError(callback+" is not a function")}if(arguments.length>1){T=arguments[1]}A=new Array(len);k=0;while(k<len){var kValue,mappedValue;if(k in O){kValue=O[k];mappedValue=callback.call(T,kValue,k,O);A[k]=mappedValue}k++}return A}}if(!Array.prototype.findIndex){Object.defineProperty(Array.prototype,"findIndex",{value:function(predicate){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(typeof predicate!=="function"){throw new TypeError("predicate must be a function")}var thisArg=arguments[1];var k=0;while(k<len){var kValue=o[k];if(predicate.call(thisArg,kValue,k,o)){return k}k++}return -1}})}if(typeof window.CustomEvent!=="function"){window.CustomEvent=function(event,params){params=params||{bubbles:false,cancelable:false,detail:null};var evt=document.createEvent("CustomEvent");evt.initCustomEvent(event,params.bubbles,params.cancelable,params.detail);return evt}}if(!Array.prototype.includes){Object.defineProperty(Array.prototype,"includes",{value:function(searchElement,fromIndex){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(len===0){return false}var n=fromIndex|0;var k=Math.max(n>=0?n:len-Math.abs(n),0);function sameValueZero(x,y){return x===y||(typeof x==="number"&&typeof y==="number"&&isNaN(x)&&isNaN(y))}while(k<len){if(sameValueZero(o[k],searchElement)){return true}k++}return false}})}this.isInIframe=function(){try{return window.self!==window.top}catch(e){return true}};this.initializeBrowser=function(){var getBrowserVersion=function(){var ua=window.navigator.userAgent;var tem;var m=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(m[1])){tem=/\brv[ :]+(\d+)/g.exec(ua)||[];return"IE "+(tem[1]||"")}if(m[1]==="Chrome"){tem=ua.match(/\b(OPR|Edge)\/(\d+)/);if(tem!=null){return tem.slice(1).join(" ").replace("OPR","Opera")}}m=m[2]?[m[1],m[2]]:[window.navigator.appName,window.navigator.appVersion,"-?"];if((tem=ua.match(/version\/(\d+)/i))!=null){m.splice(1,1,tem[1])}return m.join(" ")};var getOS=function(){var userAgent=window.navigator.userAgent;var platform=window.navigator.platform;var macosPlatforms=["Macintosh","MacIntel","MacPPC","Mac68K"];var windowsPlatforms=["Win32","Win64","Windows","WinCE"];var iosPlatforms=["iPhone","iPad","iPod"];var os=null;if(macosPlatforms.indexOf(platform)!==-1){os="Mac OS"}else{if(iosPlatforms.indexOf(platform)!==-1){os="iOS"}else{if(windowsPlatforms.indexOf(platform)!==-1){os="Windows"}else{if(/Android/.test(userAgent)){os="Android"}else{if(!os&&/Linux/.test(platform)){os="Linux"}}}}}return os};var str=getBrowserVersion().split(" ");var os=getOS();CanvasXpress.system={browser:str[0],browserVersion:str[1],os:os,alt:(os=="Mac OS"?"&#8997;":"Alt"),command:"&#8984;",control:(os=="Mac OS"?"&#8963;":"Ctrl"),shift:(os=="Mac OS"?"&#8679;":"Shift"),isjQuery:typeof $==="function",isReveal:typeof Reveal!="undefined",isZoom:typeof zoom!="undefined",isIE:this.browser=="IE"?true:false,isInIframe:(str[0].match(/safari/i)?true:this.isInIframe()),isTouchScreen:("ontouchstart" in window||"onmsgesturechange" in window||window.navigator.maxTouchPoints)}}};CanvasXpress.prototype.initSVG=function(){function g(o,l){var n=Object.keys(l),m;for(m=0;m<n.length;m++){o=o.replace(new RegExp("\\{"+n[m]+"\\}","gi"),l[n[m]])}return o}function h(m){var o,n,l;if(!m){throw new Error("cannot create a random attribute name for an undefined object")}o="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";n="";do{n="";for(l=0;l<12;l++){n+=o[Math.floor(Math.random()*o.length)]}}while(m[n]);return n}function d(n,p){var o,m,r={},q,l;n=n.split(",");p=p||10;for(o=0;o<n.length;o+=2){m="&"+n[o+1]+";";q=parseInt(n[o],p);r[m]="&#"+q+";"}r["\\xa0"]="&#160;";return r}function f(m){var l={left:"start",right:"end",center:"middle",start:"start",end:"end"};return l[m]||l.start}function c(m){var l={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return l[m]||l.alphabetic}var a=d("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32);var j={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};var i=function(m,l){this.__root=m;this.__ctx=l};i.prototype.addColorStop=function(p,l){var m=this.__ctx.__createElement("stop"),n,o;m.setAttribute("offset",p);if(l.indexOf("rgba")!==-1){n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;o=n.exec(l);m.setAttribute("stop-color",g("rgb({r},{g},{b})",{r:o[1],g:o[2],b:o[3]}));m.setAttribute("stop-opacity",o[4])}else{m.setAttribute("stop-color",l)}this.__root.appendChild(m)};var e=function(m,l){this.__root=m;this.__ctx=l};var k=function(n){var l={width:500,height:500,enableMirroring:false},m;if(arguments.length>1){m=l;m.width=arguments[0];m.height=arguments[1]}else{if(!n){m=l}else{m=n}}if(!(this instanceof k)){return new k(m)}this.width=m.width||l.width;this.height=m.height||l.height;this.enableMirroring=m.enableMirroring!==undefined?m.enableMirroring:l.enableMirroring;this.canvas=this;this.__document=m.document||document;if(m.ctx){this.__ctx=m.ctx}else{this.__canvas=this.__document.createElement("canvas");this.__ctx=this.__canvas.getContext("2d")}this.__setDefaultStyles();this.__stack=[this.__getStyleState()];this.__groupStack=[];this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg");this.__root.setAttribute("version",1.1);this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg");this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");this.__root.setAttribute("width",this.width);this.__root.setAttribute("height",this.height);this.__ids={};this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs");this.__root.appendChild(this.__defs);this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g");this.__root.appendChild(this.__currentElement)};k.prototype.__createElement=function(l,p,r){if(typeof p==="undefined"){p={}}var o=this.__document.createElementNS("http://www.w3.org/2000/svg",l),q=Object.keys(p),n,m;if(r){o.setAttribute("fill","none");o.setAttribute("stroke","none")}for(n=0;n<q.length;n++){m=q[n];o.setAttribute(m,p[m])}return o};k.prototype.__setDefaultStyles=function(){var n=Object.keys(j),m,l;for(m=0;m<n.length;m++){l=n[m];this[l]=j[l].canvas}};k.prototype.__applyStyleState=function(l){var o=Object.keys(l),n,m;for(n=0;n<o.length;n++){m=o[n];this[m]=l[m]}};k.prototype.__getStyleState=function(){var n,l={},o=Object.keys(j),m;for(n=0;n<o.length;n++){m=o[n];l[m]=this[m]}return l};k.prototype.__applyStyleToCurrentElement=function(u){var q=this.__currentElement;var n=this.__currentElementsToStyle;if(n){q.setAttribute(u,"");q=n.element;n.children.forEach(function(y){y.setAttribute(u,"")})}var x=Object.keys(j),o,l,w,m,v,p;for(o=0;o<x.length;o++){l=j[x[o]];w=this[x[o]];if(l.apply){if(w instanceof e){if(w.__ctx){while(w.__ctx.__defs.childNodes.length){m=w.__ctx.__defs.childNodes[0].getAttribute("id");this.__ids[m]=m;this.__defs.appendChild(w.__ctx.__defs.childNodes[0])}}q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(w instanceof i){q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(l.apply.indexOf(u)!==-1&&l.svg!==w){if((l.svgAttr==="stroke"||l.svgAttr==="fill")&&w.indexOf&&w.indexOf("rgba")!==-1){v=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;p=v.exec(w);q.setAttribute(l.svgAttr,g("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var r=p[4];var t=this.globalAlpha;if(t!=null){r*=t}q.setAttribute(l.svgAttr+"-opacity",r)}else{var s=l.svgAttr;if(x[o]==="globalAlpha"){s=u+"-"+l.svgAttr;if(q.getAttribute(s)){continue}}q.setAttribute(s,w)}}}}}}};k.prototype.__closestGroupOrSvg=function(l){l=l||this.__currentElement;if(l.nodeName==="g"||l.nodeName==="svg"){return l}else{return this.__closestGroupOrSvg(l.parentNode)}};k.prototype.getSerializedSvg=function(s){var q=new XMLSerializer().serializeToString(this.__root),n,m,l,p,o,r;r=/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;if(r.test(q)){q=q.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')}if(s){n=Object.keys(a);for(m=0;m<n.length;m++){l=n[m];p=a[l];o=new RegExp(l,"gi");if(o.test(q)){q=q.replace(o,p)}}}return q};k.prototype.getSvg=function(){return this.__root};k.prototype.save=function(){var m=this.__createElement("g");var l=this.__closestGroupOrSvg();this.__groupStack.push(l);l.appendChild(m);this.__currentElement=m;this.__stack.push(this.__getStyleState())};k.prototype.restore=function(){this.__currentElement=this.__groupStack.pop();this.__currentElementsToStyle=null;if(!this.__currentElement){this.__currentElement=this.__root.childNodes[1]}var l=this.__stack.pop();this.__applyStyleState(l)};k.prototype.__addTransform=function(m){var n=this.__closestGroupOrSvg();if(n.childNodes.length>0){if(this.__currentElement.nodeName==="path"){if(!this.__currentElementsToStyle){this.__currentElementsToStyle={element:n,children:[]}}this.__currentElementsToStyle.children.push(this.__currentElement);this.__applyCurrentDefaultPath()}var o=this.__createElement("g");n.appendChild(o);this.__currentElement=o}var l=this.__currentElement.getAttribute("transform");if(l){l+=" "}else{l=""}l+=m;this.__currentElement.setAttribute("transform",l)};k.prototype.scale=function(l,m){if(m===undefined){m=l}this.__addTransform(g("scale({x},{y})",{x:l,y:m}))};k.prototype.rotate=function(m){var l=(m*180/Math.PI);this.__addTransform(g("rotate({angle},{cx},{cy})",{angle:l,cx:0,cy:0}))};k.prototype.translate=function(l,m){this.__addTransform(g("translate({x},{y})",{x:l,y:m}))};k.prototype.transform=function(m,l,q,p,o,n){this.__addTransform(g("matrix({a},{b},{c},{d},{e},{f})",{a:m,b:l,c:q,d:p,e:o,f:n}))};k.prototype.beginPath=function(){var m,l;this.__currentDefaultPath="";this.__currentPosition={};m=this.__createElement("path",{},true);l=this.__closestGroupOrSvg();l.appendChild(m);this.__currentElement=m};k.prototype.__applyCurrentDefaultPath=function(){var l=this.__currentElement;if(l.nodeName==="path"){l.setAttribute("d",this.__currentDefaultPath)}else{console.error("Attempted to apply path command to node",l.nodeName)}};k.prototype.__addPathCommand=function(l){this.__currentDefaultPath+=" ";this.__currentDefaultPath+=l};k.prototype.moveTo=function(l,m){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.__currentPosition={x:l,y:m};this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))};k.prototype.closePath=function(){if(this.__currentDefaultPath){this.__addPathCommand("Z")}};k.prototype.lineTo=function(l,m){this.__currentPosition={x:l,y:m};if(this.__currentDefaultPath.indexOf("M")>-1){this.__addPathCommand(g("L {x} {y}",{x:l,y:m}))}else{this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))}};k.prototype.bezierCurveTo=function(n,m,p,o,l,q){this.__currentPosition={x:l,y:q};this.__addPathCommand(g("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:n,cp1y:m,cp2x:p,cp2y:o,x:l,y:q}))};k.prototype.quadraticCurveTo=function(n,m,l,o){this.__currentPosition={x:l,y:o};this.__addPathCommand(g("Q {cpx} {cpy} {x} {y}",{cpx:n,cpy:m,x:l,y:o}))};var b=function(m){var l=Math.sqrt(m[0]*m[0]+m[1]*m[1]);return[m[0]/l,m[1]/l]};k.prototype.arcTo=function(F,o,E,n,q){var G=this.__currentPosition&&this.__currentPosition.x;var p=this.__currentPosition&&this.__currentPosition.y;if(typeof G=="undefined"||typeof p=="undefined"){return}if(q<0){throw new Error("IndexSizeError: The radius provided ("+q+") is negative.")}if(((G===F)&&(p===o))||((F===E)&&(o===n))||(q===0)){this.lineTo(F,o);return}var u=b([G-F,p-o]);var t=b([E-F,n-o]);if(u[0]*t[1]===u[1]*t[0]){this.lineTo(F,o);return}var m=(u[0]*t[0]+u[1]*t[1]);var v=Math.acos(Math.abs(m));var B=b([u[0]+t[0],u[1]+t[1]]);var r=q/Math.sin(v/2);var A=F+r*B[0];var z=o+r*B[1];var l=[-u[1],u[0]];var w=[t[1],-t[0]];var s=function(I){var H=I[0];var J=I[1];if(J>=0){return Math.acos(H)}else{return -Math.acos(H)}};var D=s(l);var C=s(w);this.lineTo(A+l[0]*q,z+l[1]*q);this.arc(A,z,q,D,C)};k.prototype.stroke=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","fill stroke markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("stroke")};k.prototype.fill=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","stroke fill markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("fill")};k.prototype.rect=function(m,o,n,l){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.moveTo(m,o);this.lineTo(m+n,o);this.lineTo(m+n,o+l);this.lineTo(m,o+l);this.lineTo(m,o);this.closePath()};k.prototype.fillRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("fill")};k.prototype.strokeRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("stroke")};k.prototype.__clearCanvas=function(){var o=this.__closestGroupOrSvg(),l=o.getAttribute("transform");var n=this.__root.childNodes[1];var p=n.childNodes;for(var m=p.length-1;m>=0;m--){if(p[m]){n.removeChild(p[m])}}this.__currentElement=n;this.__groupStack=[];if(l){this.__addTransform(l)}};k.prototype.clearRect=function(m,q,o,l){if(m===0&&q===0&&o===this.width&&l===this.height){this.__clearCanvas();return}var p,n=this.__closestGroupOrSvg();p=this.__createElement("rect",{x:m,y:q,width:o,height:l,fill:"#FFFFFF"},true);n.appendChild(p)};k.prototype.createLinearGradient=function(m,o,l,n){var p=this.__createElement("linearGradient",{id:h(this.__ids),x1:m+"px",x2:l+"px",y1:o+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(p);return new i(p,this)};k.prototype.createRadialGradient=function(o,q,n,m,p,l){var r=this.__createElement("radialGradient",{id:h(this.__ids),cx:m+"px",cy:p+"px",r:l+"px",fx:o+"px",fy:q+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(r);return new i(r,this)};k.prototype.__parseFont=function(){var m=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;var l=m.exec(this.font);var n={style:l[1]||"normal",size:l[4]||"10px",family:l[6]||"sans-serif",weight:l[3]||"normal",decoration:l[2]||"normal",href:null};if(this.__fontUnderline==="underline"){n.decoration="underline"}if(this.__fontHref){n.href=this.__fontHref}return n};k.prototype.__wrapTextLink=function(m,n){if(m.href){var l=this.__createElement("a");l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.href);l.appendChild(n);return l}return n};k.prototype.__applyText=function(q,l,r,p){var n=this.__parseFont(),o=this.__closestGroupOrSvg(),m=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:l,y:r,"text-anchor":f(this.textAlign),"dominant-baseline":c(this.textBaseline)},true);m.appendChild(this.__document.createTextNode(q));this.__currentElement=m;this.__applyStyleToCurrentElement(p);o.appendChild(this.__wrapTextLink(n,m))};k.prototype.fillText=function(m,l,n){this.__applyText(m,l,n,"fill")};k.prototype.strokeText=function(m,l,n){this.__applyText(m,l,n,"stroke")};k.prototype.measureText=function(l){this.__ctx.font=this.font;return this.__ctx.measureText(l)};k.prototype.arc=function(t,s,q,r,m,v){if(r===m){return}r=r%(2*Math.PI);m=m%(2*Math.PI);if(r===m){m=((m+(2*Math.PI))-0.001*(v?-1:1))%(2*Math.PI)}var z=t+q*Math.cos(m),w=s+q*Math.sin(m),p=t+q*Math.cos(r),o=s+q*Math.sin(r),n=v?0:1,l=0,u=m-r;if(u<0){u+=2*Math.PI}if(v){l=u>Math.PI?0:1}else{l=u>Math.PI?1:0}this.lineTo(p,o);this.__addPathCommand(g("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:q,ry:q,xAxisRotation:0,largeArcFlag:l,sweepFlag:n,endX:z,endY:w}));this.__currentPosition={x:z,y:w}};k.prototype.clip=function(){var m=this.__closestGroupOrSvg(),l=this.__createElement("clipPath"),o=h(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath();m.removeChild(this.__currentElement);l.setAttribute("id",o);l.appendChild(this.__currentElement);this.__defs.appendChild(l);m.setAttribute("clip-path",g("url(#{id})",{id:o}));m.appendChild(n);this.__currentElement=n};k.prototype.drawImage=function(){var n=Array.prototype.slice.call(arguments),z=n[0],u,t,v,F,x=0,w=0,C,G,s,y,l,q,o,D,p,m,B;if(n.length===3){u=n[1];t=n[2];C=z.width;G=z.height;v=C;F=G}else{if(n.length===5){u=n[1];t=n[2];v=n[3];F=n[4];C=z.width;G=z.height}else{if(n.length===9){x=n[1];w=n[2];C=n[3];G=n[4];u=n[5];t=n[6];v=n[7];F=n[8]}else{throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length)}}}s=this.__closestGroupOrSvg();o=this.__currentElement;var r="translate("+u+", "+t+")";if(z instanceof k){y=z.getSvg().cloneNode(true);if(y.childNodes&&y.childNodes.length>1){l=y.childNodes[0];while(l.childNodes.length){B=l.childNodes[0].getAttribute("id");this.__ids[B]=B;this.__defs.appendChild(l.childNodes[0])}q=y.childNodes[1];if(q){var E=q.getAttribute("transform");var A;if(E){A=E+" "+r}else{A=r}q.setAttribute("transform",A);s.appendChild(q)}}}else{if(z.nodeName==="CANVAS"||z.nodeName==="IMG"){D=this.__createElement("image");D.setAttribute("width",v);D.setAttribute("height",F);D.setAttribute("preserveAspectRatio","none");if(x||w||C!==z.width||G!==z.height){p=this.__document.createElement("canvas");p.width=v;p.height=F;m=p.getContext("2d");m.drawImage(z,x,w,C,G,0,0,v,F);z=p}D.setAttribute("transform",r);D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",z.nodeName==="CANVAS"?z.toDataURL():z.getAttribute("src"));s.appendChild(D)}}};k.prototype.createPattern=function(o,m){var n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),p=h(this.__ids),l;n.setAttribute("id",p);n.setAttribute("width",o.width);n.setAttribute("height",o.height);if(o.nodeName==="CANVAS"||o.nodeName==="IMG"){l=this.__document.createElementNS("http://www.w3.org/2000/svg","image");l.setAttribute("width",o.width);l.setAttribute("height",o.height);l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",o.nodeName==="CANVAS"?o.toDataURL():o.getAttribute("src"));n.appendChild(l);this.__defs.appendChild(n)}else{if(o instanceof k){n.appendChild(o.__root.childNodes[1]);this.__defs.appendChild(n)}}return new e(n,this)};k.prototype.setLineDash=function(l){if(l&&l.length>0){this.lineDash=l.join(",")}else{this.lineDash=null}};k.prototype.drawFocusRing=function(){};k.prototype.createImageData=function(){};k.prototype.getImageData=function(){};k.prototype.putImageData=function(){};k.prototype.globalCompositeOperation=function(){};k.prototype.setTransform=function(){};this.canvasToSVG=k};CanvasXpress.prototype.initInterface=function(){this.parseJSON=function(s,r){if(s.toString().match(/<!DOCTYPE/)){return undefined}else{if(r){return JSON.parse(s,r)}else{return JSON.parse(s,function(k,v){if(typeof v==="string"&&v.startsWith&&v.startsWith("/Function(")&&v.endsWith&&v.endsWith(")/")){v=v.substring(10,v.length-2).replace(/&quot;/g,'"');return eval("("+v+")")}else{return v}})}}};this.stringifyJSON=function(js,r,s){if(r){return JSON.stringify(js,r,s||null)}else{return js?JSON.stringify(js,function(k,v){if(typeof v==="function"){return"/Function("+v.toString().replace(/"/g,"&quot;")+")/"}else{if(k=="state"||k=="stateIndex"||k=="gantt"||k=="events"){return undefined}else{if(v instanceof Array){for(var p in v){if(Array.isArray(v[p])||v[p] instanceof Object){return v}}return JSON.stringify(v)}else{return v}}}},s||null).replace(/\\n/g,"").replace(/\\/g,"").replace(/\"\[/g,"[").replace(/\]\"/g,"]").replace(/\"\{/g,"{").replace(/\}\"/g,"}").replace(/u0000/g,""):false}};this.isValidURL=function(str){var pattern=new RegExp("^(https?:\\/\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;,\\s\\(\\)\\[\\]&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$","i");return pattern.test(str)};this.stringToXML=function(str){var test=false;if(window.DOMParser){test=(new DOMParser()).parseFromString(str,"text/xml")}else{if(typeof window.ActiveXObject!="undefined"&&new window.ActiveXObject("Microsoft.XMLDOM")){test=new window.ActiveXObject("Microsoft.XMLDOM");test.async="false";test.loadXML(str)}}return test};this.isValidXML=function(str){var test=this.stringToXML(str);return test!=null&&test.getElementsByTagName("parsererror").length==0};this.isValidJSON=function(str){try{JSON.parse(str)}catch(e){return false}return true};this.isValidDelimitedFile=function(str){var test=this.delimitedToArray(str);return this.isArray(test)&&this.isArray(test[0])};this.isValidString=function(str){var obj={type:false,data:false};if(this.isValidURL(str)){obj.type="URL";obj.data=str}else{if(this.isValidXML(str)){obj.type="XML";obj.data=this.stringToXML(str)}else{if(this.isValidJSON(str)){obj.type="JSON";obj.data=JSON.parse(str)}else{if(this.isValidDelimitedFile(str)){obj.type="DELIM";obj.data=this.delimitedToArray(str,false,true,this.graphType=="Network")}}}}return obj};this.loadParamsFile=function(t){return function(e){t.removeMenus();t.resetConfigurator(e);var file=e.target.files[0];var type=file.type;var part=file.name.split(".");var reader=new FileReader();var ext=part.pop();if(ext=="json"){reader.onload=function(){try{var data=t.parseJSON(reader.result);t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}}else{t.draw({func:"loadParamsFile",par:(e)})}}catch(e){alert("Oooops! Not a valid CanvasXpress json parameter file")}};reader.readAsText(file)}else{alert("Oooops! Not a valid CanvasXpress json parameter file")}}}(this);this.parseDataFromPNG=function(p){var istEXt=function(dv,idx){var c="";for(var i=0;i<4;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c=="tEXt"};var isCanvasXpress=function(dv,idx,len){var c="";for(var i=0;i<len;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c.match(/CanvasXpress/)};var dv=new DataView(p);var ihdr=dv.getUint32(8);var soft=dv.getUint32(8+4+4+ihdr+4);if(istEXt(dv,8+4+4+ihdr+4+4)&&isCanvasXpress(dv,8+4+4+ihdr+4+4+4,soft)){var rprs=dv.getUint32(8+4+4+ihdr+4+4+4+soft+4);var indx=8+4+4+ihdr+4+4+4+soft+4+4+4;var res="";for(var i=0;i<rprs;i++){res+=String.fromCharCode(dv.getUint8(indx+i))}res=res.replace("ReproducibleResearch\0","");return this.parseJSON(res)}else{alert("Oooops! Not a valid CanvasXpress Image")}};this.parseNodeLinks=function(json){var smps=[];var vals=[];var srce=[];var targ=[];for(var i=0;i<json.links.length;i++){var l=json.links[i];if(l.source&&l.target&&l.value){srce.push(l.source);targ.push(l.target);vals.push(l.value);smps.push("Smp"+(i+1))}}var data={y:{vars:["Weight"],smps:smps,data:[vals]},x:{Source:srce,Target:targ}};return{renderTo:"newSankey",data:data,config:{graphType:"Sankey",sankeySource:"Source",sankeyTarget:"Target"}}};this.parseHierarchy=function(json){var that=this;var reformat=function(treeStructure){var max=0;var smps=[];var vals=[];var seen={};var flatten=function(children,extractChildren,level,parent){return Array.prototype.concat.apply(children.map(function(x){if(!seen.hasOwnProperty(x.name)){seen[x.name]=0}seen[x.name]++;if(seen[x.name]>1){x.name+=seen[x.name]}var o=that.cloneObject(x);o.level=level||1;o.parent=parent||null;return o}),children.map(function(x){max=Math.max(max,(level||1)+1);if(!x.children){smps.push(x.name);vals.push(x.value||1)}return flatten(extractChildren(x)||[],extractChildren,(level||1)+1,x.name)}))};var extractChildren=function extractChildren(x){return x.children||null};var flat=flatten(extractChildren(treeStructure),extractChildren).map(function(x){x.n=x.children?x.children.length:0;return delete x.children&&x});var data={y:{vars:["Dummy"],smps:smps,data:[vals]},x:{}};for(var i=0;i<data.y.smps.length;i++){for(var j=0;j<flat.length;j++){if(!flat[j].n&&data.y.smps[i]==flat[j].name){flat[j].smp=i;break}}}var hier=[];var levl=json.name;data.x[levl]=[];hier.push(levl);for(var i=2;i<max-1;i++){data.x[levl+i]=[];hier.push(levl+i)}var map={};for(var i=0;i<flat.length;i++){map[flat[i].name]=i}for(var i=0;i<hier.length;i++){for(var j=0;j<data.y.smps.length;j++){data.x[hier[i]][j]=null}}for(var i=0;i<flat.length;i++){if(flat[i].parent){var p=flat[i].parent;var m=map[p];var s=flat[i].smp;var l=flat[i].level-1;var f=flat[m].parent;data.x[levl+(l>1?l:"")][s]=flat[m].name;while(f){m=map[f];l=flat[m].level;data.x[levl+(l>1?l:"")][s]=flat[m].name;f=flat[m].parent}}}return{renderTo:"newTree",data:data,config:{graphType:"Tree",hierarchy:hier}}};return reformat(json)};this.loadFile=function(t){return function(e,jr,callback,f){t.removeMenus();t.resetConfigurator(e);t.showMask();var checkBackgroundImage=function(data){if(data.config&&data.config.backgroundImage&&data.config.backgroundImage.match(/^javascript:\/\//)&&data.config.backgroundImageSrc){var im=new Image();im.id=data.config.backgroundImage.split("//")[1];im.style.display="none";im.src="data:image/png;base64,"+atob(data.config.backgroundImageSrc);document.body.appendChild(im);CanvasXpress.cacheImages[t.getFileName(im.src)]=im}};var file=f?f:e.target?e.target.files[0]:e.files[0];var type=file.type;var part=file.name.split(".");var reader=new FileReader();if(type=="image/png"){var istEXt=function(dv,idx){var c="";for(var i=0;i<4;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c=="tEXt"};var isCanvasXpress=function(dv,idx,len){var c="";for(var i=0;i<len;i++){c+=String.fromCharCode(dv.getUint8(idx+i))}return c.match(/CanvasXpress/)};reader.onload=function(){var dv=new DataView(this.result);var ihdr=dv.getUint32(8);var soft=dv.getUint32(8+4+4+ihdr+4);if(istEXt(dv,8+4+4+ihdr+4+4)&&isCanvasXpress(dv,8+4+4+ihdr+4+4+4,soft)){var rprs=dv.getUint32(8+4+4+ihdr+4+4+4+soft+4);var indx=8+4+4+ihdr+4+4+4+soft+4+4+4;var res="";for(var i=0;i<rprs;i++){res+=String.fromCharCode(dv.getUint8(indx+i))}res=res.replace("ReproducibleResearch\0","");var data=t.parseJSON(res);if(jr){return data}checkBackgroundImage(data);if(data.hasOwnProperty("config")){delete (data.config.remoteService)}data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{t.hideMask();alert("Oooops! Not a valid CanvasXpress Image")}};reader.readAsArrayBuffer(file)}else{var ext=part.pop();if(ext=="json"){reader.onload=function(){try{var data=t.parseJSON(reader.result);checkBackgroundImage(data);if(data.data||(data&&data.config&&data.config.graphType&&data.config.graphType=="Map")){if(data.config.topoJSON){if(data.config.mapId){delete window[data.config.mapId];delete t.meta.map;delete t.topoJSON;delete t.topoJSONURL}}data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{if(data.config){t.setConfigDefaults();t.layoutValid=false;for(var p in data.config){t[p]=data.config[p]}if(data.afterRender){for(var i=0;i<data.afterRender.length;i++){var ar=data.afterRender[i];var fn=ar[0];var pr=ar[1]||[];t[fn].apply(t,pr)}}else{t.draw({func:"loadFile",par:[e,jr,callback,f]})}}else{if(data.children&&data.children.length){data=t.parseHierarchy(data);data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{if(data.nodes&&data.links){data=t.parseNodeLinks(data);data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}else{if(data.type&&data.type.match(/FeatureCollection|Topology/)){var datan={data:false,config:{graphType:"Map",topoJSON:data,mapId:"cXMap"}};window.cXMap=data;t.updateData(datan);t.hideMask()}else{var foo=data.error.error}}}}}}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(ext=="geojson"){reader.onload=function(){try{var data=t.parseJSON(reader.result);if(data.type&&data.type.match(/FeatureCollection|Topology/)){var datan={data:false,config:{graphType:"Map",topoJSON:data,mapId:"cXMap"}};window.cXMap=data;t.updateData(datan);t.hideMask()}else{var foo=data.error.error}}catch(e){t.hideMask();alert("Oooops! Not a valid geojson file")}}}else{if(ext=="svg"){reader.onload=function(){try{var data=t.SVGtoCX(reader.result);data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(ext=="txt"||ext=="csv"||ext=="tsv"||ext=="tab"){reader.onload=function(){try{var str=reader.result;var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}var dl=ext=="csv"&&tc>tt?",":"\t";var data;if(t.graphType=="Network"){data=t.delimitedToArray(str,dl,false,true);if(data&&!t.isArray(data)){var fail="";if(data.fail>0){fail=data.fail+" records couldn't be mapped to network data"}alert(data.rows+" "+data.type+" records added to network data\n"+fail);if(data.type=="node"){t.appendNodeData(data.data)}else{t.appendEdgeData(data.data)}t.hideMask();return}else{data=t.arrayToCanvasXpress(data)}}else{data=t.isMetaDataFile(t.delimitedToArray(str,dl),t.graphType=="Map");if(data&&!t.isArray(data)){if(data.addt){alert(data.recs+" records added as an additional data set\n")}else{alert(data.recs+" records added to meta data\n")}t.appendMetaData(data.data,data.addt);t.hideMask();return}else{data=t.arrayToCanvasXpress(data)}}data.renderTo=part[0].replace(/\s/g,"").replace(/\(/g,"").replace(/\)/g,"");data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(ext=="esv"){reader.onload=function(){try{var str=reader.result;var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}var dl=tc>tt?",":"\t";var data=t.delimitedToArray(str,dl,false,true,"edge");data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(ext=="gml"){reader.onload=function(){try{var data=t.parseGML(reader.result);data.renderTo=part[0];data.uploadFile=true;t.remoteServiceType="file";t.updateRemoteData(data,callback);t.hideMask()}catch(e){t.hideMask();alert("Oooops! Not a valid gml file for CanvasXpress")}}}else{if(ext=="gexf"){reader.onload=function(){t.remoteServiceType="file";try{var xml=t.parseXML(reader.result);t.gexfToCX(xml,part[0])}catch(e){t.hideMask();alert("Oooops! Not a valid "+ext+" file for CanvasXpress")}}}else{if(ext.match(/ml$/)){reader.onload=function(){try{var xml=t.parseXML(reader.result);t.loadXML(xml,part[0])}catch(e){t.hideMask();alert("Oooops! Not a valid "+ext+" file for CanvasXpress")}}}}}}}}}}reader.readAsText(file)}}}(this);this.loadXML=function(xml,target,config,events){this.remoteServiceType="file";var ts1=xml.childNodes[0];var ts2=xml.childNodes[2]||xml.childNodes[1];if(ts1.tagName&&ts1.tagName.toLowerCase()=="map"){this.metabaseToCX(xml,target,config,events)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="graph"){this.cytoscapeToCX(xml,target,config,events)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="pathway"){this.wikipathwayToCX(xml,target,config,events)}else{if(ts2&&ts2.tagName&&ts2.tagName.toLowerCase()=="pathway"){this.keggToCX(xml,target,config,events)}}}}};this.editJSFiddle=function(t){return function(e,f){if(t.editable||f){t.removeMenus();var js="onReady(function () {\n"+t.getCodeJSONJS()+"})";var ht="<link rel='stylesheet' href='https://www.canvasxpress.org/dist/canvasXpress.css' type='text/css'/>\n";ht+="<script type='text/javascript' src='https://www.canvasxpress.org/dist/canvasXpress.min.js'><\/script>\n\n";ht+="<canvas id='"+t.target+"' width='"+t.width+"' height='"+t.height+"'></canvas>";var form=t.$cX("form",{id:"submitToJSFiddle",method:"post",action:"https://jsfiddle.net/api/post/library/pure/",target:"check"},{display:"none"});document.body.appendChild(form);var tatt=t.$cX("textarea",{name:"title",value:(t.title||"CanvasXpress")});var taht=t.$cX("textarea",{name:"html",value:ht});var tajs=t.$cX("textarea",{name:"js",value:js});var btsb=t.$cX("button",{type:"submit"});form.appendChild(tatt);form.appendChild(taht);form.appendChild(tajs);form.appendChild(btsb);btsb.click();document.body.removeChild(form)}}}(this);this.editCodePen=function(t){return function(e,f){if(t.editable||f){t.removeMenus();var js="onReady(function () {\n"+t.getCodeJSONJS().replace(/\'/g,"")+"})";var ht='<link rel="stylesheet" href="https://www.canvasxpress.org/dist/canvasXpress.css" type="text/css"/>\n';ht+='<script type="text/javascript" src="https://www.canvasxpress.org/dist/canvasXpress.min.js"><\/script>\n\n';ht+='<canvas id="'+t.target+'" width="'+t.width+'" height="'+t.height+'"></canvas>';var rs="https://www.canvasxpress.org/dist/canvasXpress.css;https://www.canvasxpress.org/dist/canvasXpress.min.js";var data='{"title": "'+(t.title||"CanvasXpress")+'", "html": "'+ht+'" js: "'+js+'" js_external: "'+rs+'"}';data='{"title": "CanvasXpress", "html": "'+ht.replace(/"/g,"'")+'", "js": "'+js.replace(/"/g,"'")+'", "js_external": "'+rs.replace(/"/g,"'")+'"}';var form=t.$cX("form",{id:"submitToCodePen",method:"post",action:"https://codepen.io/pen/define",target:"_blank"},{display:"none"});document.body.appendChild(form);var indt=t.$cX("input",{type:"hidden",name:"data",value:data});var btsb=t.$cX("button",{type:"submit"});form.appendChild(indt);form.appendChild(btsb);btsb.click();document.body.appendChild(form)}}}(this);this.saveCurrent=function(){this.resortData();var s=CanvasXpress.stack[this.target];var a=s.afterRender;var ar=[];for(var i=0;i<a.length;i++){if(a[i][0].match(/^sort/)){ar.push(this.cloneObject(a[i]))}}return this.prettyJSON({renderTo:s.renderTo,data:this.data,config:this.getConfig(),afterRender:ar,factory:s.factory,system:s.system,version:s.version})};this.save=function(t){return function(e,f,p,o){t.removeMenus();t.resetConfigurator(e);var flnm=f?f+".json":t.saveFilename?t.saveFilename+".json":"cX-"+t.target+".json";flnm=flnm.replace(/.json.json$/,".json");CanvasXpress.stack[t.target].factory=CanvasXpress.factory;CanvasXpress.stack[t.target].system=CanvasXpress.system;var obj;if(p){obj=t.prettyJSON({config:CanvasXpress.stack[t.target].config,afterRender:CanvasXpress.stack[t.target].afterRender||[]})}else{if(o||(e&&(e.ctrlKey||e.altKey))){obj=t.saveCurrent()}else{obj=t.prettyJSON(t.cleanDataObject(t.cloneObject(CanvasXpress.stack[t.target])))}}var blob=new Blob([obj],{type:"text/plain"});t.saveAs(blob,flnm)}}(this);this.saveSVG=function(t){return function(e,f){t.removeMenus();t.resetConfigurator(e);CanvasXpress.stack[t.target].factory=CanvasXpress.factory;CanvasXpress.stack[t.target].system=CanvasXpress.system;t.isSVG=true;var tr=t.showTransition;t.showTransition=false;t.meta.canvas.SVG=new this.canvasToSVG({width:t.width,height:t.height,desc:t.isReproducibleResearch?t.prettyJSON(t.cleanDataObject(t.cloneObject(CanvasXpress.stack[t.target]))):""});t.renderGraph(true);var svg=t.meta.canvas.SVG.getSerializedSvg();if(t.isReproducibleResearch){t.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}var flnm=f?f+".svg":t.saveFilename?t.saveFilename+".svg":"cX-"+t.target+".svg";flnm=flnm.replace(/.svg.svg$/,".svg");var blob=new Blob([svg],{type:"image/svg+xml"});t.saveAs(blob,flnm);t.showTransition=tr;delete (t.meta.canvas.SVG);t.isSVG=false}}(this);this.parseXML=function(xml){var dom=null;if(window.DOMParser){try{dom=(new DOMParser()).parseFromString(xml,"text/xml")}catch(e){dom=null}}else{if(window.ActiveXObject){try{dom=new ActiveXObject("Microsoft.XMLDOM");dom.async=false;if(!dom.loadXML(xml)){window.alert(dom.parseError.reason+dom.parseError.srcText)}}catch(e){dom=null}}else{alert("cannot parse xml string!")}}return dom};this.parseHTMLTable=function(table,cx){var ar=[];for(var i=0;i<table.rows.length;i++){var ln=[];for(var j=0;j<table.rows.item(i).cells.length;j++){ln.push(table.rows.item(i).cells.item(j).innerHTML)}ar.push(ln)}if(cx){cx=this.arrayToCanvasXpress(ar);CanvasXpress.transferDatasetAttributes(table,cx.config,true);return cx}else{return ar}};this.SVGtoCX=function(xml){var dom=this.parseXML(xml);var svg=dom.childNodes[0];if(svg.tagName.match(/svg/i)){var desc=svg.getAttribute("desc");if(desc){return this.parseJSON(desc)}}};this.arrayBufferToBase64=function(buffer){var binary="";var bytes=new Uint8Array(buffer);var len=bytes.byteLength;for(var i=0;i<len;i++){binary+=String.fromCharCode(bytes[i])}return window.btoa(binary)};this.base64ToArrayBuffer=function(base64){var binary_string=window.atob(base64);var len=binary_string.length;var bytes=new Uint8Array(len);for(var i=0;i<len;i++){bytes[i]=binary_string.charCodeAt(i)}return bytes.buffer};this.print=function(t){return function(e,f,c){var wn=window;var ow=t.width;var oh=t.height;var pm=t.printMagnification;var as=t.autoScaleFont;var st=t.showTransition;var ss=t.skipStack;var pr=["outlineWidth","lineThickness","axisTickThickness","axisMinMaxTickThickness","guidesWidth","boxplotMedianWidth","boxplotConnectWidth","treeLinkWidth","connectByWidth","histogramBarWidth","heatmapCellBoxWidth","heatmapCellBoxHighlightWidth","edgeThickness","maxTextSize","treemapBorderWidth","errorBarsThickness","ganttDependencyThickness"];if(!CanvasXpress.stack.hasOwnProperty(t.target)){t=CanvasXpress.getObject(CanvasXpress.current.replace("-events",""))}var adjustDPI=function(reset){if(reset&&pm!=1){for(var i=0;i<pr.length;i++){t[pr[i]]/=pm}t.autoScaleFont=as;t.showTransition=st;t.setDimensions(ow,oh,true);t.skipStack=ss}else{if(pm!=1){t.skipStack=true;t.showTransition=false;for(var i=0;i<pr.length;i++){t[pr[i]]*=pm}t.autoScaleFont=true;t.setDimensions(ow*pm,oh*pm,true)}}};var makeCRCTable=function(){var cn;var crcTable=[];for(var n=0;n<256;n++){cn=n;for(var k=0;k<8;k++){cn=((cn&1)?(3988292384^(cn>>>1)):(cn>>>1))}crcTable[n]=cn}return crcTable};var crc32=function(str){var crcTable=wn.crcTable||(wn.crcTable=makeCRCTable());var crc=0^(-1);for(var i=0;i<str.length;i++){crc=(crc>>>8)^crcTable[(crc^str.charCodeAt(i))&255]}return(crc^(-1))>>>0};var appendBuffer=function(buffer1,buffer2){var tmp=new Uint8Array(buffer1.byteLength+buffer2.byteLength);tmp.set(new Uint8Array(buffer1),0);tmp.set(new Uint8Array(buffer2),buffer1.byteLength);return tmp.buffer};var getArrayBuffer=function(string){var ztxt="tEXt";var len=string.length;var crc=crc32(ztxt+string);var mab=new ArrayBuffer(12+len);var ndv=new DataView(mab);ndv.setUint32(0,len);for(var i=0;i<ztxt.length;i++){ndv.setUint8(4+i,ztxt.charCodeAt(i))}for(var i=0;i<string.length;i++){ndv.setUint8(8+i,string.charCodeAt(i))}ndv.setUint32(4+4+len,crc);return mab};var cleanStack=function(){if(t.isReproducibleResearch){if(t.printMagnification!=1){delete (CanvasXpress.stack[t.target].config.showTransition)}return e&&(e.ctrlKey||e.altKey)?t.saveCurrent():t.stringifyJSON(t.cleanDataObject(t.cloneObject(CanvasXpress.stack[t.target])))}else{var stk=t.parseJSON(e.ctrlKey||e.altKey?t.saveCurrent():t.stringifyJSON(CanvasXpress.stack[t.target]));stk.afterRender=[stk.afterRender[0]];return t.stringifyJSON(stk)}};var collectArrayBuffers=function(hab,sab,rab,dab){var nab=appendBuffer(hab,sab);nab=appendBuffer(nab,rab);nab=appendBuffer(nab,dab);return nab};var toDataUrl=function(blb){var fr=new FileReader();var tx="";if(t.isReproducibleResearch){tx+="<h2>Please be aware that the actual data is stored inside the image! Right click to save!</h2>"}else{tx+="<h2>Right click to save image</h2>"}fr.onload=function(evt){tx+="<img width="+t.width+" height="+t.height+" src= '"+evt.target.result+"'/>";t.showTooltipDiv(e,tx,t.getTargetEvent(e),{maxWidth:t.width+"px",whiteSpace:"normal"},40,40)};fr.readAsDataURL(blb)};adjustDPI();t.removeMenus();t.resetConfigurator(e);CanvasXpress.stack[t.target].factory=CanvasXpress.factory;CanvasXpress.stack[t.target].system=CanvasXpress.system;var cnv=t.meta.canvas.ctx.canvas;cnv.toBlob(function(blob){var fr=new FileReader();var fn=f?f+".png":t.saveFilename?t.saveFilename+".png":"cX-"+t.target+".png";fn=fn.replace(/.png.png$/,".png");fr.onloadend=function(){var dv=new DataView(this.result);var ihdr=dv.getUint32(8);var idat=8+4+4+ihdr+4;var hab=this.result.slice(0,idat);var dab=this.result.slice(idat);var sab=getArrayBuffer("Software\0CanvasXpress Version: "+CanvasXpress.factory.version);var rab=getArrayBuffer("ReproducibleResearch\0"+cleanStack());var nab=collectArrayBuffers(hab,sab,rab,dab);var blb=new Blob([nab],{type:"image/png"});t.meta.base64=t.arrayBufferToBase64(nab);if(c){c(blb,fn)}else{if(t.printType=="download"){if(t.isReproducibleResearch){t.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}t.saveAs(blb,fn)}else{toDataUrl(blb)}}adjustDPI(true)};fr.readAsArrayBuffer(blob)},"image/png");if(t.maximized){t.clickGraphMaxMin(e)}}}(this);this.exportToSVG=function(t){return function(e){var ctx=t.meta.canvas.ctx;t.meta.canvas.ctx=new this.canvasToSVG({width:t.width,height:t.height});t.draw({func:"exportToSVG",par:[e]});var svg=t.prettyXML(t.meta.canvas.ctx.getSerializedSvg());var win=window.open("",t.target+"-SVG");win.document.write(svg);t.meta.canvas.ctx=ctx;t.draw({func:"exportToSVG",par:[e]});return false}}(this);this.exportToExcel=function(d){return this.exportToTabDelimited(d)};this.exportToHTML=function(d,t){var str="<table>";for(var i=0;i<d.length;i++){str+="<tr><td>";str+=d[i].join("</td><td>");str+="</td></tr>"}str+="</table>";return t?str:window.open().document.write(str)};this.exportToTabDelimited=function(d){var str="";for(var i=0;i<d.length;i++){str+=d[i].join("\t")+"\n"}var link=this.$(this.target+"-cX-linkTab");if(!link){link=this.$cX("a",{id:this.target+"-cX-linkTab"},{display:"none"});window.document.body.appendChild(link)}link.download=this.target+".tsv";link.href="data:text/tab-separated-values;charset=UTF-8,"+encodeURIComponent(str);link.click()};this.arrayToHTML=function(d){var str="";if(d[0].length){str+='<div class="CanvasXpressDataTableContainer" style="overflow:scroll;max-height:400px;max-width:600px;position:inherit;padding-left:18px;">';str+='<table class="CanvasXpressDataTable" style="position:inherit;">';str+="<tbody>";str+="<tr>";for(var i=0;i<d[0][0].length;i++){str+='<th class="CanvasXpressTableCellHead" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][0][i];str+="</div>";str+="</th>"}str+="</tr>";for(var i=1;i<d[0].length;i++){str+="<tr>";for(var j=0;j<d[0][i].length;j++){if(j==0){str+='<th class="CanvasXpressTableCellHead" style="height:18px">';str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][i][j];str+="</div>";str+="</th>"}else{if(d[2]&&d[2][i]&&d[2][i][j]){str+='<td class="CanvasXpressTableCell" style="height:18px;background-color:'+d[2][i][j]+'">'}else{str+='<td class="CanvasXpressTableCell" style="height:18px">'}str+='<div class="CanvasXpressTableCell" style="height:18px">';str+=d[0][i][j];str+="</div>";str+="</td>"}}str+="</tr>"}str+="</tbody>";str+="</table>";str+="</div>"}return str};this.rToPrettyR=function(s){var nice=[];var lines=s.split(/\n(?=(?:(?:[^"]*"){2})*[^"]*$)/);var funcs=["header","quote","row.names","fill","check.names","stringsAsFactors"];var call=false;for(var i=0;i<lines.length;i++){var l=lines[i];if(l.match(/library\(canvasXpress\)/)){nice.push(l.replace("library(canvasXpress)",'library(<span class="json-value">canvasXpress</span>)'))}else{if(l.match(/canvasXpress\(/)){nice.push(l.replace("canvasXpress(",'<span class="json-value">canvasXpress</span>('));call=true}else{if(l.match(/\"http.+\"/)){l=l.replace(/(\"http.+?\")/,'<span class="json-string">$1</span>');for(var j=0;j<funcs.length;j++){l=l.replace(funcs[j],'<span class="json-key">'+funcs[j]+"</span>")}l=l.replace('""','<span class="json-string">""</span>,');l=l.replace(/\"\t\"/,'<span class="json-string">"&#92;t"</span>');l=l.replace("=1,",'=<span class="json-number">1</span>,');l=l.replace(/FALSE/g,'<span class="json-boolean">FALSE</span>');l=l.replace(/TRUE/g,'<span class="json-boolean">TRUE</span>');nice.push(l)}else{if(call){if(l.match(/\".+?\"/)){l=l.replace(/(\".+?\")/g,'<span class="json-string">$1</span>')}else{if(l.match(/[^xis][\d\.]+/)){l=l.replace(/([\d\.]+)/,'<span class="json-number">$1</span>')}}l=l.replace(/\n/,"&#92;n");l=l.replace(/(\w+)?=/,'<span class="json-key">$1=</span>');l=l.replace(/FALSE/g,'<span class="json-boolean">FALSE</span>');l=l.replace(/TRUE/g,'<span class="json-boolean">TRUE</span>')}nice.push(l)}}}}return'<pre class="CanvasXpressCodeContent">\n<code>'+nice.join("</code>\n<code>")+"</code>\n</pre>"};this.prettyColoredR=function(o,r,c){var json=this.stringifyJSON(o,r?r:null,2);if(json.length>10000){c=false}if(c){json=json.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}json=json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(match){var cls="number";if(/^"/.test(match)){if(/:$/.test(match)){match=match.replace(/"/g,"").replace(":"," =");cls="key"}else{cls="string"}}else{if(/true|false/.test(match)){match=match.replace("false","FALSE").replace("true","TRUE");cls="boolean"}else{if(/null/.test(match)){match=match.replace("null","NULL");cls="null"}}}return c?('<span class="json-'+cls+'">'+match+"</span>"):match});return json.replace(/\[/g,"list(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"")};this.dataToR=function(){var arr=[];var prp=[];var cnf,vls,vrs,sps,dat,cod;var scr="";var data=CanvasXpress.stack[this.target].data;var ini="<span class=json-value>canvasXpress</span>(\n";if(this.meta.config.remote){scr+='data = "'+this.meta.config.remote.data+'"\n';ini+="  <span class=json-key>data</span> = data,\n"}else{if(this.graphType=="Map"){scr+="";ini+="  <span class=json-key>data</span> = <span class=json-value>FALSE</span>,\n"}else{if(data.y){arr=[];for(var i=0;i<data.y.vars.length;i++){var arr2=[];for(var j=0;j<data.y.smps.length;j++){arr2.push(data.y.data[i][j]!=null?data.y.data[i][j]:"NA")}arr.push("<span class=json-number>"+arr2.join("</span>,<span class=json-number>")+"</span>,")}arr[arr.length-1]=arr[arr.length-1].replace(/,$/,"");vls="vals = c("+arr.join("\n+ ")+")\n";vrs='vars = c(<span class=json-string>"'+data.y.vars.join('"</span>,<span class=json-string>"')+'"</span>)\n';sps='smps = c(<span class=json-string>"'+data.y.smps.join('"</span>,<span class=json-string>"')+'"</span>)\n';dat="data = as.data.frame(matrix(vals, <span class=json-key>nrow</span> = <span class=json-number>"+data.y.vars.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+data.y.smps.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>TRUE</span>, <span class=json-key>dimnames</span> = list(vars, smps)))\n";scr+=vls+vrs+sps+dat;ini+="  <span class=json-key>data</span> = data,\n"}if(data.x){arr=[];prp=[];vls="";for(var i in data.x){if(this.meta.data.x[i].type=="Numeric"){arr.push("<span class=json-number>"+data.x[i].join("</span>,<span class=json-number>")+"</span>,")}else{arr.push('<span class=json-string>"'+data.x[i].join('"</span>,<span class=json-string>"')+'"</span>,')}prp.push(i)}arr[arr.length-1]=arr[arr.length-1].replace(/,$/,"");vls="valx = c("+arr.join("\n+ ")+")\n";if(this.graphType=="Tree"){vls=vls.replace(/\"\"/g,"NA")}vrs='varx = c(<span class=json-string>"'+prp.join('"</span>,<span class=json-string>"')+'"</span>)\n';dat="datx = as.data.frame(matrix(valx, <span class=json-key>nrow</span> = <span class=json-number>"+prp.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+data.y.smps.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>TRUE</span>, <span class=json-key>dimnames</span> = list(varx, smps)))\n";scr+=vls+vrs+dat;ini+="  <span class=json-key>smpAnnot</span> = datx,\n"}if(data.z){arr=[];prp=[];vls="";for(var i in data.z){if(this.meta.data.z[i].type=="Numeric"){arr.push("<span class=json-number>"+data.z[i].join("</span>,<span class=json-number>")+"</span>,")}else{arr.push('<span class=json-string>"'+data.z[i].join('"</span>,<span class=json-string>"')+'"</span>,')}prp.push(i)}arr[arr.length-1]=arr[arr.length-1].replace(/,$/,"");vls="valz = c("+arr.join("\n+ ")+")\n";sps='smpz = c(<span class=json-string>"'+prp.join('"</span>,<span class=json-string>"')+'"</span>)\n';dat="datz = as.data.frame(matrix(valz, <span class=json-key>nrow</span> = <span class=json-number>"+data.y.vars.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+prp.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>FALSE</span>, <span class=json-key>dimnames</span> = list(vars, smpz)))\n";scr+=vls+sps+dat;ini+="  <span class=json-key>varAnnot</span> = datz,\n"}if(data.nodes){scr+="nodes = list(\n"+this.prettyColoredR(data.nodes,function(k,v){if(k!="layout"){return v}},true)+")\n";ini+="  <span class=json-key>nodeData</span> = nodes,\n"}if(data.edges){scr+="edges = list(\n"+this.prettyColoredR(data.edges,false,true)+")\n";ini+="  <span class=json-key>edgeData</span> = edges,\n"}if(data.venn){scr+="venn = data.frame(\n"+this.prettyColoredR(data.venn.data,false,true)+")\n";ini+="  <span class=json-key>vennData</span> = venn,\n";if(data.venn.legend){scr+="legn = data.frame(\n"+this.prettyColoredR(data.venn.legend,false,true)+")\n";ini+="  <span class=json-key>vennLegend</span> = legn,\n"}}if(data.tracks){ini+="  <span class=json-key>tracks</span> = genome,\n";scr+="genome = list(\n"+this.prettyColoredR(data.tracks,false,true)+")\n"}}}cnf=this.meta.config.remote?this.cloneObject(this.meta.config.remote.config):this.cloneObject(CanvasXpress.stack[this.target].config);if(CanvasXpress.stack[this.target].afterRender&&CanvasXpress.stack[this.target].afterRender.length>1){cnf.afterRender=this.cloneObject(CanvasXpress.stack[this.target].afterRender)}ini+=this.prettyColoredR(cnf,false,true)+")";cod="library(<span class=json-value>canvasXpress</span>)\n"+scr+ini;return"<code> "+cod.replace(/\n/g,"</code>\n<code> ")+"</code>"};this.prettyJSON=function(o,r,c,i){return c&&o?this.prettyColoredJSON(o,r):o?this.stringifyJSON(o,r,i||2):false};this.prettyColoredJSON=function(o,r){if(o){var json=this.stringifyJSON(o,r?r:null,2);if(json.length>10000){return json}else{json=json.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(match){var cls="number";if(/^"/.test(match)){if(/:$/.test(match)){cls="key"}else{cls="string"}}else{if(/true|false/.test(match)){cls="boolean"}else{if(/null/.test(match)){cls="null"}}}return'<span class="json-'+cls+'">'+match+"</span>"})}else{return false}};this.prettyXML=function(str){var reg=/(>)\s*(<)(\/*)/g;var wsexp=/ *(.*) +\n/g;var contexp=/(<.+>)(.+\n)/g;var xml=str.replace(reg,"$1\n$2$3").replace(wsexp,"$1\n").replace(contexp,"$1\n$2");var pad=0;var formatted="";var lines=xml.split("\n");var indent=0;var lastType="other";var transitions={"single->single":0,"single->closing":-1,"single->opening":0,"single->other":0,"closing->single":0,"closing->closing":-1,"closing->opening":0,"closing->other":0,"opening->single":1,"opening->closing":0,"opening->opening":1,"opening->other":1,"other->single":0,"other->closing":-1,"other->opening":0,"other->other":0};for(var i=0;i<lines.length;i++){var ln=lines[i];var single=Boolean(ln.match(/<.+\/>/));var closing=Boolean(ln.match(/<\/.+>/));var opening=Boolean(ln.match(/<[^!].*>/));var type=single?"single":closing?"closing":opening?"opening":"other";var fromTo=lastType+"->"+type;lastType=type;var padding="";indent+=transitions[fromTo];for(var j=0;j<indent;j++){padding+="  "}formatted+=padding+ln+"\n"}return formatted};this.dataToPython=function(jupyter){var cd=this.getDataJSON(true).replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var sc=this.getConfigJSON(true).replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var se=this.getEventsJSON(true);var ar=this.getAfterRenderJSON(true);var pc="";pc+="<span class=json-key>from</span> canvasxpress.canvas <span class=json-key>import</span> CanvasXpress\n";if(jupyter){pc+="<span class=json-key>from</span> canvasxpress.render.jupyter <span class=json-key>import</span> CXNoteBook\n"}else{pc+="<span class=json-key>from</span> canvasxpress.render.popup <span class=json-key>import</span> CXBrowserPopup\n\n"}pc+="cx = CanvasXpress(\n";pc+='  render_to = </span>"'+this.target+'"</span>,\n';pc+="  data = "+cd+",\n";pc+="  config = "+sc+",\n";if(se){pc+="  events = "+se.replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(ar){pc+="  afterRender = "+ar.replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}pc+="  width = <span class=json-number>"+this.width+"</span>,\n";pc+="  height = <span class=json-number>"+this.height+"</span>\n";pc+=")\n\n";if(jupyter){pc+="display = CXNoteBook(cx)\n"}else{pc+="display = CXBrowserPopup(cx)\n"}pc+="display.render()";return"<code> "+pc.replace(/\n/g,"</code>\n<code> ")+"</code>"};this.delimitedToArrayOrig=function(str,delim,cx){delim=delim||",";var pat=new RegExp(("(\\"+delim+'|\\r?\\n|\\r|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\'+delim+"\\r\\n]*))"),"gi");var arr=[[]];var arrM=null;while(arrM=pat.exec(str)){var strM=arrM[1];if(strM.length&&strM!==delim){arr.push([])}var strV;if(arrM[2]){strV=arrM[2].replace(new RegExp('""',"g"),'"')}else{strV=arrM[3]}arr[arr.length-1].push(this.isNumber(strV)?Number(strV):strV!=this.missingDataValue?strV:null)}return cx?this.arrayToCanvasXpress(arr):arr};this.delimitedToArray=function(str,delim,cx,net,nwt){var nl=/\r\n|\r|\n/g;var ar=str.split(nl);var setDelim=function(){var tc=0;var tt=0;if(str.match(/,/g)){tc=str.match(/,/g).length}if(str.match(/\t/g)){tt=str.match(/\t/g).length}delim=tc>tt?",":"\t"};if(!delim){setDelim()}for(var i=0;i<ar.length;i++){if(ar[i].match(/^#/)){ar.splice(i,1);i--;continue}var f=ar[i].split(delim);for(var x=f.length-1;x>=0;x--){if(f[x].replace(/"\s+$/,'"').charAt(f[x].length-1)=='"'){var tl=f[x].replace(/^\s+"/,'"');if(tl.length>1&&tl.charAt(0)=='"'){f[x]=f[x].replace(/^\s*"|"\s*$/g,"").replace(/""/g,'"')}else{if(x){f.splice(x-1,2,[f[x-1],f[x]].join(delim))}else{f=f.shift().split(delim).concat(f)}}}else{f[x].replace(/""/g,'"')}}for(var j=0;j<f.length;j++){if(this.isNumber(f[j])){f[j]=Number(f[j])}else{if(f[j]==this.missingDataValue){f[j]=null}else{if(f[j].match(/^\[.+\]$/)||f[j].match(/^\{.+\}$/)){f[j]=this.parseJSON(f[j])}else{f[j]=f[j].replace(/"/g,"'")}}}}if(f.length==1&&f[0]==""){ar.splice(i,1);i--;continue}ar[i]=f}return cx&&!nwt?this.arrayToCanvasXpress(ar):net?this.isNetworkFile(ar,nwt):ar};this.isMetaDataFile=function(arr,isMap){if(this.varIndices.length&&this.smpIndices.length){var that=this;var getObject=function(t){if(t=="s"){return{y:{smps:that.cloneObject(that.data.y.smps)},x:{}}}else{return{y:{vars:that.cloneObject(that.data.y.vars)},z:{}}}};var map={};if(isMap&&this.data.z&&this.data.z.hasOwnProperty("cXId")){for(var i=0;i<this.data.z.cXId.length;i++){map[this.data.z.cXId[i]]=i}}var rows={s:[],v:[]};var cols={s:[],v:[]};var idx;var min=2;var add=false;for(var i=1;i<arr.length;i++){idx=this.getSampleIndices(arr[i][0]);if(idx>-1){rows.s.push([i,idx]);continue}idx=isMap&&map.hasOwnProperty(arr[i][0])?map[arr[i][0]]:this.getVariableIndices(arr[i][0]);if(idx>-1){rows.v.push([i,idx]);continue}}for(var i=1;i<arr[0].length;i++){idx=isMap&&map.hasOwnProperty(arr[i][0])?map[arr[i][0]]:this.getVariableIndices(arr[0][i]);if(idx>-1){cols.v.push([i,idx]);continue}idx=this.getSampleIndices(arr[0][i]);if(idx>-1){cols.s.push([i,idx]);continue}}var rs=rows.s.length>min?rows.s.length:0;var rv=rows.v.length>min?rows.v.length:0;var cs=cols.s.length>min?cols.s.length:0;var cv=cols.v.length>min?cols.v.length:0;var sl=this.data.y.smps.length;var vl=this.data.y.vars.length;if(rs||rv||cs||cv){var n=0;if(rs==sl&&cv==vl){var data=[];for(var i=0;i<cols.v.length;i++){var ii=cols.v[i][0];var ix=cols.v[i][1];data[ix]=[];for(var j=0;j<rows.s.length;j++){var jj=rows.s[j][0];var jx=rows.s[j][1];data[ix][jx]=arr[jj][ii];n++}}add=true}else{if(cs==sl&&rv==vl){var data=[];for(var i=0;i<rows.v.length;i++){var ii=rows.v[i][0];var ix=rows.v[i][1];data[ix]=[];for(var j=0;j<cols.s.length;j++){var jj=cols.s[j][0];var jx=cols.s[j][1];data[ix][jx]=arr[ii][jj];n++}}add=true}else{if(rs>=rv&&rs>=cs&&rs>=cv){var data=getObject("s");for(var i=1;i<arr[0].length;i++){data.x[arr[0][i]]=[];var m=0;for(var j=0;j<rows.s.length;j++){var jj=rows.s[j][0];var jx=rows.s[j][1];data.x[arr[0][i]][jx]=arr[jj][i];n++;m=arr[jj][i]?m+1:m}if(!m){delete data.x[arr[0][i]]}}}else{if(rv>=rs&&rv>=cs&&rv>=cv){var data=getObject("v");for(var i=1;i<arr[0].length;i++){data.z[arr[0][i]]=[];var m=0;for(var j=0;j<rows.v.length;j++){var jj=rows.v[j][0];var jx=rows.v[j][1];data.z[arr[0][i]][jx]=arr[jj][i];n++;m=arr[jj][i]?m+1:m}if(!m){delete data.z[arr[0][i]]}}}else{if(cs>rs&&cs>=rv&&cs>=cv){var data=getObject("s");for(var i=0;i<cols.s.length;i++){var ii=cols.s[i][0];var ix=cols.s[i][1];var m=0;for(var j=1;j<arr.length;j++){if(i==0){data.x[arr[j][0]]=[]}data.x[arr[j][0]][ix]=arr[j][ii];n++;m=arr[j][ii]?m+1:m}if(!m){delete data.x[arr[j][0]]}}}else{if(cv>rs&&cv>=rv&&cv>=cs){var data=getObject("v");for(var i=0;i<rows.s.length;i++){var ii=rows.s[i][0];var ix=rows.s[i][1];var m=0;for(var j=1;j<arr.length;j++){if(i==0){data.z[arr[j][0]]=[]}data.z[arr[j][0]][ix]=arr[j][ii];n++;m=arr[j][ii]?m+1:m}if(!m){delete data.z[arr[j][0]]}}}}}}}}return{data:data,recs:n,addt:add}}else{return arr}}return arr};this.isNetworkFile=function(arr,nwt){var obj={};var cols=arr[0];var nodes=0;var edges=0;var fail=0;var type=nwt||false;if(type=="node"){}else{if(type=="edge"){nodes={};obj.data={nodes:[],edges:[]};for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(n&&m){var e={id1:n,id2:m};for(var j=2;j<arr[i].length;j++){e[arr[0][j]]=arr[i][j]}obj.data.edges.push(e)}nodes[n]=true;nodes[m]=true}for(var i in nodes){obj.data.nodes.push({id:i,shape:"sphere"})}obj.config={graphType:"Network"};return obj}else{var map={};for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(this.data.nodeIndices.hasOwnProperty(n)&&this.data.nodeIndices.hasOwnProperty(m)){edges++}else{if(this.data.nodeIndices.hasOwnProperty(n)){nodes++}else{fail++}}map[n]=i}if(!nodes&&!edges){for(var i=0;i<this.data.nodes.length;i++){var n=this.data.nodes[i];if(n.hasOwnProperty("extId")&&map.hasOwnProperty(n.extId)){arr[map[n.extId]][0]=n.id;nodes++}}}if(edges>nodes){nodes=0;edges=0;fail=0;type="edge";for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(this.data.nodeIndices.hasOwnProperty(n)&&this.data.nodeIndices.hasOwnProperty(m)){edges++;obj[n+":"+m]={};for(var j=2;j<cols.length;j++){obj[n+":"+m][cols[j]]=arr[i][j]}}else{fail++}}}else{if(nodes>8){nodes=0;edges=0;fail=0;type="node";for(var i=1;i<arr.length;i++){var n=arr[i][0];if(this.data.nodeIndices.hasOwnProperty(n)){nodes++;obj[n]={};for(var j=1;j<cols.length;j++){obj[n][cols[j]]=arr[i][j]}}else{fail++}}}else{return arr}}if((type=="edge"&&(edges>5||edges>=arr.length-1))||(type=="node"&&(nodes>5||nodes>=arr.length-1))){return{data:obj,rows:Math.max(nodes,edges),fail:fail,type:type}}else{return arr}}}};this.XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").replace(/\[/g,"&#91").replace(/\]/g,"&#93").toLowerCase();if(p){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p){json[p].push(j)}}else{if(p=="alt"){json[p].push(xml.textContent.replace(/\"/g,"'").replace(/\[/g,"&#91").replace(/\]/g,"&#93"))}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();this.XMLToJSON(n,json,p)}}}}}return json};this.cytoscapeToCX=function(xml,target,config,events){var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var nodes=[];var edges=[];var title="";var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="graph"){var ob=this.XMLToJSON(pw,false,false,true);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();var js=this.XMLToJSON(el);switch(nn){case"node":if(js.graphics&&js.id){var gr=js.graphics[0];var node={id:js.id,x:Number(gr.x),y:Number(gr.y),z:Number(gr.z),width:Number(gr.w),height:Number(gr.h),shape:(sp[gr.type]||gr.type),color:gr.fill,outline:gr.outline,outlineWidth:Number(gr.width)};if(js.label){node.name=js.label}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/NODE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.name=="COMMON"&&at.value){node.label=at.value}else{if(at.value){node[at.name]=at.value}}break;case"Double":case"Integer":if(at.value!=null){node[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){node[at.name]=at.value==0?false:true}break}}}}nodes.push(node)}break;case"edge":if(js.source&&js.target){var edge={id1:js.source,id2:js.target};if(js.id){edge.intId=js.id}if(js.label){edge.label=js.label}if(js.directed){edge.directed=js.directed}if(js.graphics){edge.color=js.graphics[0].fill;edge.width=js.graphics[0].width}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/EDGE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.value){edge[at.name]=at.value}break;case"Double":case"Integer":if(at.value!=null){edge[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){edge[at.name]=at.value==0?false:true}break}}}}edges.push(edge)}break;case"att":if(js.name&&js.value&&js.name=="Dataset Name"){title=js.value}break}}}}else{alert("Ooops! Not a cytoscape xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:true,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,title:title,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Cytoscape"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.keggToCX=function(xml,target,config,events){var that=this;var pw=xml.childNodes[2]||xml.childNodes[1];var nodes=[];var edges=[];var title,image,link,width,height;var addAnchors=function(){nodes.push({id:"__zero__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:0,y:0,hideLabel:true},{id:"__max__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:width,y:height,hideLabel:true})};if(pw.tagName.toLowerCase()=="pathway"){var ob=this.XMLToJSON(pw,false,false,true);title=ob.title;image=ob.image;link=ob.link;var img=new Image();img.onload=function(){width=this.width;height=this.height;var res="Number of Nodes: "+nodes.length+"\n";res+="Number of Edges: "+edges.length+"\n";addAnchors();that.remoteServiceType="file";that.networkFreeze=false;var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,networkFreeze:false,showNodeNameThreshold:20000,preScaleNetwork:false,title:title,backgroundType:"image",backgroundImage:image,networkVendor:"Kegg"},renderTo:target,events:events,uploadFile:(that.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=that.dataURL||that.dataString;var cnfg=that.cloneObject(that.meta.config.user);if(that.graphType=="Network"){for(var p in that.meta.config.user){data.config[p]=that.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}that.updateRemoteData(data,clbk);that.hideMask()};if((CanvasXpress.system.isR&&!CanvasXpress.system.isInIframe)||!CanvasXpress.system.isR){img.crossOrigin="anonymous"}img.src=ob.image;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"entry":var ob=this.XMLToJSON(el);if(ob.graphics[0].type=="roundrectangle"){ob.graphics[0].type="roundrect";ob.graphics[0].fgcolor="rgba(0,0,0,0)"}if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type!="line"){var ext=ob.type=="group"?5:0;var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:ob.graphics[0].type,color:"rgba(0,0,0,0)",outline:that.validateColor(ob.graphics[0].fgcolor)||"rgb(0,0,0)",width:parseInt(ob.graphics[0].width)+ext,height:parseInt(ob.graphics[0].height)+ext,x:parseInt(ob.graphics[0].x),y:parseInt(ob.graphics[0].y),hideLabel:true,fixed:true};if(ob.type=="group"){nodes.unshift(node)}else{nodes.push(node)}}else{if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type=="line"){var coords=ob.graphics[0].coords.split(",");if(coords.length==4){var x=[];var y=[];var w,h,r;while(coords.length>1){x.push(parseInt(coords.shift()));y.push(parseInt(coords.shift()))}var mx=parseInt(this.mean(x));var my=parseInt(this.mean(y));if(x[0]==x[1]){mx+=1;w=2;h=y[1]-y[0];r=0}else{if(y[0]==y[1]){my+=1;w=x[1]-x[0];h=2;r=0}else{h=this.lineLength(x[0],y[0],x[1],y[1]);w=2;r=this.getAngle(x[0],y[0],x[1],y[1])}}var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:"rect",color:"rgba(0,0,0,0)",outline:"rgba(0,0,0,0)",x:mx,y:my,width:w,height:h,rotate:r,hideLabel:true,fixed:true};nodes.push(node)}}}break;case"relation":case"reaction":var ob=this.XMLToJSON(el);ob.id1=this.cloneObject(ob.entry1);ob.id2=this.cloneObject(ob.entry2);delete (ob.entry1);delete (ob.entry2);ob.color="rgba(0,0,0,0)";edges.push(ob);break}}}}else{alert("Ooops! Not a kgml file!")}};this.wikipathwayToCX=function(xml,target,config,events){var pw=xml.childNodes[0];var nodes={};var edges=[];var state={};var groups={};var anchors={};var order={};var cntp=1;var cntn=0;var sord=[];var groupRef={};var groupGref={};var groupId={};var wrn="\nWarnings:\n";var htt=false;var title,subtitle;var arrowTypes={Line:false,Arrow:"arrow",TBar:"square","mim-necessary-stimulation":false,"mim-binding":false,"mim-conversion":"arrow","mim-stimulation":"arrow","mim-catalysis":"round","mim-modification":false,"mim-inhibition":"square","mim-covalent-bond":false,"mim-transcription-translation":false};var createNodeFromGroup=function(grp,id){var mnx=Number.MAX_VALUE;var mny=Number.MAX_VALUE;var mxx=-Number.MAX_VALUE;var mxy=-Number.MAX_VALUE;var ids=[];var ord=[];var shw=false;for(var i=0;i<grp.length;i++){mnx=Math.min(mnx,grp[i][1]-(grp[i][3]/2));mny=Math.min(mny,grp[i][2]-(grp[i][4]/2));mxx=Math.max(mxx,grp[i][1]+(grp[i][3]/2));mxy=Math.max(mxy,grp[i][2]+(grp[i][4]/2));ids.push(grp[i][0]);nodes[grp[i][0]].parentNode=id;ord.push(nodes[grp[i][0]].zorder);if(nodes[grp[i][0]].nodeName!="label"){shw=true}ord.sort(function(a,b){return a-b})}var w=mxx-mnx;var h=mxy-mny;var ob={id:id,x:(mnx+mxx)/2,y:(mny+mxy)/2,width:w+(grp.length>1&&w>10?5:0),height:h+(grp.length>1&&h>10?5:0),group:ids,hideLabel:true,hideTooltip:htt,type:"Group",color:(shw?"rgba(245,245,245,0.5)":"rgba(0,0,0,0)"),outline:(shw?"rgb(0,0,0)":"rgba(0,0,0,0)"),shape:"rectangle",zorder:ord[0]};order[id]=cntn--;nodes[id]=ob;sord.push(id)};var createNodeFromPoint=function(p,id){var ob={id:id,x:Math.round(p.x*10)/10,y:Math.round(p.y*10)/10,width:p.width?Math.round(p.width):1,height:p.height?Math.round(p.height):1,hideLabel:p.show?false:true,hideTooltip:!htt?false:p.show?false:true,eventless:p.show?false:true,type:p.type||"Anchor",color:p.color||"rgba(0,0,0,0)",outline:p.outline||"rgba(0,0,0,0)",shape:p.shape||"circle",label:p.label||"",zorder:p.zorder||0};order[id]=cntp++;nodes[id]=ob;sord.push(id)};var getDirection=function(s){switch(s){case"r":case"l":return"rl";case"b":case"t":case"c":return"tb"}};var getSide=function(p){if(parseInt(p.relx)==1){return"r"}else{if(parseInt(p.relx)==-1){return"l"}else{if(parseInt(p.rely)==1){return"b"}else{if(parseInt(p.rely)==-1){return"t"}else{if(Math.abs(p.relx)>Math.abs(p.rely)){if(parseFloat(p.relx)>0){return"r"}else{return"l"}}else{if(parseFloat(p.rely)>0){return"b"}else{if(parseFloat(p.rely)<0){return"t"}else{return"c"}}}}}}}};var getNumberOfLines=function(s,t){var findExtra=function(sd,p1,p2){switch(sd){case"r":if(parseFloat(p1.x)>=parseFloat(p2.x)){return 2}break;case"l":if(parseFloat(p1.x)<=parseFloat(p2.x)){return 2}break;case"t":case"c":if(parseFloat(p1.y)<=parseFloat(p2.y)){return 2}break;case"b":if(parseFloat(p1.y)>=parseFloat(p2.y)){return 2}break}return 0};var ss=getSide(s);var ts=getSide(t);var ls=2;if(getDirection(ss)==getDirection(ts)){ls++}if(ss!=ts){ls+=findExtra(ss,s,t);ls+=findExtra(ts,t,s)}return ls};var getPoint=function(s,a,f){if(f){switch(s){case"r":return[a[0]+20,a[1]];case"l":return[a[0]-20,a[1]];case"t":case"c":return[a[0],a[1]-20];case"b":return[a[0],a[1]+20]}}else{switch(s){case"r":case"l":return[a[0][0],a[1][1]];case"t":case"b":case"c":return[a[1][0],a[0][1]]}}};var getCoords=function(d,a){var r=[a[0]];var l=a[0];for(var i=1;i<a.length;i++){var c=a[i];switch(d){case"rl":r.push([c[0],l[1]]);break;case"tb":r.push([l[0],c[1]]);break}l=r[i];d=d=="rl"?"tb":"rl"}r.push(a[a.length-1]);return r};var to2DArray=function(edg){var ps=edg.point;var a=[];for(var i=0;i<ps.length;i++){a.push([Math.round(ps[i].x*10)/10,Math.round(ps[i].y*10)/10])}return a};var getElbowPoints=function(edg){var ps=edg.point;var n1=ps.length-1;var ls=getNumberOfLines(ps[0],ps[n1]);var s=getSide(ps[0]);var t=getSide(ps[n1]);var d=getDirection(s);var a=to2DArray(edg);if(ls==ps.length){a=getCoords(d,a)}else{if(ps.length==2){a.splice(1,0,getPoint(s,a[0],true));if(ls>3){if(ls>3){a.splice(2,0,getPoint(t,a[2],true))}if(ls>4){if(ls>4){a.splice(3,0,[(a[1][0]+a[2][0])/2,(a[1][1]+a[2][1])/2])}if(ls>5){a=to2DArray(edg);a=getCoords(d,a)}}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}else{if((a[0][0]==a[1][0]&&a[1][0]==a[2][0])||(a[0][1]==a[1][1]&&a[1][1]==a[2][1])){a.splice(1,1)}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}}else{if(ps.length>ls){a=getCoords(d,a)}else{for(var i=0;i<n1;i++){var j=i*2;if(d=="tb"){d="rl";a.splice(j+1,0,[a[j][0],a[j+1][1]])}else{d="tb";a.splice(j+1,0,[a[j+1][0],a[j][1]])}}}}}var b=[[a[0][0],a[0][1]]];for(var i=1;i<a.length;i++){if(a[i][0]==a[i-1][0]&&a[i][1]==a[i-1][1]){continue}b.push([a[i][0],a[i][1]])}return b};var getBezierPoints=function(edg,sn,tn){var ps=edg.point;var n1=ps.length-1;var s=getSide(ps[0]);var t=getSide(ps[n1]);var ds=getDirection(s);var dt=getDirection(t);var ar=to2DArray(edg);var segs=[];var p0,p1,mx,my;if(n1==1){p0=ar[0];p1=ar[1];if(sn&&tn){if(ds==dt){mx=(p0[0]+p1[0])/2;my=(p0[1]+p1[1])/2;if(ds=="tb"){if(t=="t"){if(my>tn.y-tn.height){my-=tn.height}}else{if(t=="b"){if(my<tn.y+tn.height){my+=tn.height}}}segs.push([p0[0],p0[1],p0[0],my,mx,my]);segs.push([mx,my,p1[0],my,p1[0],p1[1]])}else{if(t=="l"){if(mx>tn.x-tn.width){mx-=tn.width*0.5}}else{if(t=="r"){if(mx<tn.x+tn.width){mx+=tn.width*0.5}}}segs.push([p0[0],p0[1],mx,p0[1],mx,my]);segs.push([mx,my,mx,p1[1],p1[0],p1[1]])}}else{if(s=="t"||s=="b"){mx=t=="l"?-tn.width*0.5:t=="r"?tn.width*0.5:-tn.width*0.5;my=(p1[1]-p0[1])/3;if((t=="l"&&p0[0]>tn.x-tn.width)||(t=="r"&&p0[0]<tn.x+tn.width)){segs.push([p0[0],p0[1],p0[0],p0[1]+my,p1[0],p0[1]+my]);segs.push([p1[0],p0[1]+my,p1[0]+mx,p0[1]+my,p1[0]+mx,p0[1]+my+my]);segs.push([p1[0]+mx,p0[1]+my+my,p1[0]+mx,p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}else{mx=(p1[0]-p0[0])/3;my=t=="t"?-tn.height:t=="b"?tn.height:-tn.height;if((t=="t"&&p0[1]>tn.y-tn.height)||(t=="b"&&p0[1]<tn.y+tn.height)){segs.push([p0[0],p0[1],p0[0]+mx,p0[1],p0[0]+mx,p1[1]]);segs.push([p0[0]+mx,p1[1],p0[0]+mx,p1[1]+my,p0[0]+mx+mx,p1[1]+my]);segs.push([p0[0]+mx+mx,p1[1]+my,p1[0],p1[1]+my,p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}}}}else{p0=ar[0];if(s=="t"||s=="b"){for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}else{for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}}return segs};var getStatePosition=function(n,s){var x=parseFloat(s.relx);var y=parseFloat(s.rely);var w=n.width/2;var h=n.height/2;return[n.x+(x*w),n.y+(y*h)]};var XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&(p=="point"||p=="anchor")&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").replace(/\[/g,"&#91").replace(/\]/g,"&#93").toLowerCase();if(p&&(p=="point"||p=="anchor")){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p&&(p=="point"||p=="anchor")){json[p].push(j)}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();XMLToJSON(n,json,p)}}}}}return json};if(pw.tagName.toLowerCase()=="pathway"){var ob=XMLToJSON(pw,false,false,true);title=ob.name;subtitle=ob.organism;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"comment":break;case"graphics":break;case"state":var ob=XMLToJSON(el);ob.nodeName=nn;state[ob.graphid]=ob;break;case"datanode":case"label":case"shape":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.centerx){ob.x=Math.round(ob.centerx*10)/10;delete (ob.centerx)}if(ob.centery){ob.y=Math.round(ob.centery*10)/10;delete (ob.centery)}if(ob.width){ob.width=parseInt(ob.width)}if(ob.height){ob.height=parseInt(ob.height)}if(ob.textlabel){ob.label=ob.textlabel;delete (ob.textlabel)}if(ob.database&&ob.id){ob.database+=" : "+ob.id}if(ob.graphid){ob.id=ob.graphid}if(ob.fontsize){ob.labelSize=parseInt(ob.fontsize)}if(ob.rotation){ob.rotate=(parseFloat(ob.rotation)*180/Math.PI)+180}if(ob.shapetype){if(ob.shapetype=="RoundedRectangle"){ob.shapetype=ob.value&&ob.value=="Double"?"roundrectd":"roundrect"}if(ob.shapetype=="Arc"){ob.shapetype="arc3"}if(ob.shapetype=="Mitochondria"){ob.shapetype="image";ob.imagePath="https://www.canvasxpress.org/assets/images/mit.png"}if(this.isValidShape(ob.shapetype.toLowerCase())){ob.shape=ob.shapetype.toLowerCase()}else{if(ob.shapetype=="None"){ob.shape="rectangle"}else{wrn+=ob.id+" has an unkown shape: "+ob.shapetype+"\n";ob.shape=ob.shapetype}}if(ob.shape=="oval"&&ob.value&&ob.value=="Double"){ob.shape="ovald"}delete (ob.shapetype)}if(!ob.shape){ob.shape="rectangle"}if(nn=="shape"){ob.labelColor=ob.color?this.validateColor(ob.color):"rgb(0,0,0)"}else{if(ob.color){ob.labelColor=this.validateColor(ob.color)}else{ob.labelColor="rgb(0,0,0)"}}if(ob.fillcolor){ob.color=this.validateColor(ob.fillcolor);delete (ob.fillcolor)}else{ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(0,0,0)"){ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(255,255,255)"){ob.color="rgba(255,255,255,0)"}if(nn=="label"){if(!ob.label||ob.label==""){ob.hideLabel=true;ob.hideTooltip=htt;ob.eventless=true}ob.outline="rgba(0,0,0,0)";ob.color="rgba(0,0,0,0)"}else{ob.outline=ob.labelColor}if(nn=="shape"&&(!ob.label||ob.label=="")){ob.hideLabel=true;ob.hideTooltip=htt;ob.outline=ob.labelColor}if(ob.groupref){if(!groupRef.hasOwnProperty(ob.groupref)){groupRef[ob.groupref]=[]}groupRef[ob.groupref].push([ob.id,ob.x,ob.y,ob.width,ob.height]);ob.parentNode=ob.groupref}order[ob.id]=cntp++;nodes[ob.id]=ob;sord.push(ob.id);break;case"interaction":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.anchor){for(var j=0;j<ob.anchor.length;j++){anchors[ob.anchor[j].graphid]=true}delete (ob.anchor)}var n1=ob.point.length-1;if(ob.point[0].graphref&&ob.point[n1].graphref){ob.id1=ob.point[0].graphref;ob.id2=ob.point[n1].graphref}var type="solid";if(ob.linestyle&&ob.linestyle=="Broken"){type="dashed"}if(ob.connectortype&&ob.connectortype=="Curved"){type+="Bezier"}ob.type=type;if(ob.point[0].arrowhead){if(arrowTypes[ob.point[0].arrowhead]){ob.startArrow=arrowTypes[ob.point[0].arrowhead]}}if(ob.point[n1].arrowhead){if(arrowTypes[ob.point[n1].arrowhead]){ob.endArrow=arrowTypes[ob.point[n1].arrowhead]}}if(ob.linethickness){ob.thickness=parseInt(ob.linethickness*10)/10;delete (ob.linethickness)}if(ob.point[0].relx&&ob.point[0].rely){ob.startX=parseFloat(ob.point[0].relx);ob.startY=parseFloat(ob.point[0].rely)}if(ob.point[n1].relx&&ob.point[n1].rely){ob.endX=parseFloat(ob.point[n1].relx);ob.endY=parseFloat(ob.point[n1].rely)}delete (ob.id);edges.push(ob);break;case"group":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.groupref&&ob.groupid){if(!groups.hasOwnProperty(ob.groupref)){groups[ob.groupref]=[]}groups[ob.groupref].push(ob.groupid);groupGref[ob.graphid]=ob.groupref}else{groupId[ob.graphid]=ob.groupid}break;case"infobox":break;case"legend":break;case"biopax":break}}}}else{alert("Ooops! Not a gpml file!")}for(var s in state){var g=state[s].graphref;if(nodes[g]){var c=getStatePosition(nodes[g],state[s]);var p={id:g,x:c[0],y:c[1],width:state[s].width,height:state[s].height,label:state[s].textlabel==""?" ":state[s].textlabel,type:"State",color:state[s].textlabel==""?"rgb(255,255,255)":this.validateColor(state[s].fillcolor),outline:"rgb(0,0,0)",shape:"oval",show:true};createNodeFromPoint(p,s)}}for(var g in groupRef){createNodeFromGroup(groupRef[g],g)}for(var g in groups){if(groupRef.hasOwnProperty(g)){for(var i=0;i<groups[g].length;i++){var ob=nodes[groups[g][i]];groupRef[g].push([ob.id,ob.x,ob.y,ob.width,ob.height])}createNodeFromGroup(groupRef[g],g)}}var edgs=[];var fail=[];for(var i=0;i<edges.length;i++){var ob=edges[i];var n1=ob.point.length-1;if(!ob.point[0].graphref&&!ob.point[n1].graphref){ob.exact=true}for(var j=0;j<ob.point.length;j++){var pt=ob.point[j];if(pt.graphref){if(!nodes.hasOwnProperty(pt.graphref)){if(j==0){if(groupId[pt.graphref]){ob.id1=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactStart=anchors[pt.graphref]?true:false;ob.id1=pt.graphref}}else{if(j==ob.point.length-1){if(groupId[pt.graphref]){ob.id2=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactEnd=anchors[pt.graphref]?true:false;ob.id2=pt.graphref}}}}}else{if(j==0||j==ob.point.length-1){var id=j==0?ob.graphid+".1":ob.graphid+".2";var ni=j==0?ob.point.length-1:0;createNodeFromPoint(pt,id);if(j==0){ob.id1=id;ob.exactStart=true}else{ob.id2=id;ob.exactEnd=true}ob.hideTooltip=htt;if(ob.point[ni].graphref){if(!nodes.hasOwnProperty(ob.point[ni].graphref)&&groupId[ob.point[ni].graphref]){if(j==0){ob.id2=groupId[ob.point[ni].graphref]}else{ob.id1=groupId[ob.point[ni].graphref]}}else{if(j==0){ob.id2=ob.point[ni].graphref}else{ob.id1=ob.point[ni].graphref}}}}}}if(ob.connectortype){if(ob.connectortype=="Elbow"){ob.elbows=getElbowPoints(ob)}else{if(ob.connectortype=="Curved"){ob.elbows=getBezierPoints(ob,nodes[ob.id1],nodes[ob.id2])}else{if(ob.connectortype=="Segmented"){ob.elbows=to2DArray(ob)}}}}if(nodes[ob.id1]&&nodes[ob.id2]){edgs.push(ob)}else{fail.push(ob)}}sord.sort(function(a,b){if(nodes[a].zorder&&nodes[b].zorder){if(parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)==0){return order[a]-order[b]}else{return parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)}}else{return order[a]-order[b]}});var nods=[];for(var i=0;i<sord.length;i++){nods.push(nodes[sord[i]])}var res="Number of Nodes: "+nods.length+"\n";res+="Number of Edges: "+edgs.length+"\n";if(fail.length>0){res+="Number of Failed Edges: "+fail.length+"\n";for(var i=0;i<fail.length;i++){res+="\t"+(i+1)+". "+fail[i].graphid+"\n"}}if(wrn!="\nWarnings:\n"){res+=wrn}res=res.replace(/\n/g,"<br>");var data={data:{nodes:nods,edges:edgs},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,title:title,networkVendor:"Wikipathways"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.metabaseToCX=function(xml,target,config,events){var that=this;var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var loc={3:"microsome",13:"epr",21:"lysosome",43:"nucleus",67:"golgi",1287:"mitochondria",1312:"peroxisome"};var getMembrane=function(node){var getNode=function(){return{shape:"rectangle",color:"rgba(255,255,255,0)",outline:"rgba(0,0,0,0)",outlineWidth:0,hideLabel:true,immutable:true,eventless:true,type:node.type,zorder:node.zorder+1,width:32,height:32}};var getNodeTL=function(){var nd=getNode();nd.id=node.id+"-membraneTL";nd.pattern="membraneTL";nd.x=node.x-(node.width*0.5);nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeTR=function(){var nd=getNode();nd.id=node.id+"-membraneTR";nd.pattern="membraneTR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeBL=function(){var nd=getNode();nd.id=node.id+"-membraneBL";nd.pattern="membraneBL";nd.x=node.x-(node.width*0.5);nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeBR=function(){var nd=getNode();nd.id=node.id+"-membraneBR";nd.pattern="membraneBR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeTop=function(s){var nd=getNode();nd.id=node.id+"-membraneT";nd.pattern="membraneTop";nd.x=node.x+(s==0?0:s==1?-16:s==2?16:0);nd.y=node.y-(node.height*0.5);nd.width=node.width-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeBottom=function(s){var nd=getNodeTop(s);nd.id=node.id+"-membraneB";nd.pattern="membraneBottom";nd.y=node.y+(node.height*0.5)-16;return nd};var getNodeRight=function(s){var nd=getNode();nd.id=node.id+"-membraneR";nd.pattern="membraneRight";nd.x=node.x+(node.width*0.5)-16;nd.y=node.y+(s==0?0:s==1?-16:s==2?16:0);nd.height=node.height-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeLeft=function(s){var nd=getNodeRight(s);nd.id=node.id+"-membraneL";nd.pattern="membraneLeft";nd.x=node.x-(node.width*0.5);return nd};switch(node.type){case 1:node.shape="rectangle";return[getNodeTop(0)];case 2:node.shape="rectangle";return[getNodeRight(0)];case 3:node.shape="roundrecttr";return[getNodeTop(1),getNodeRight(2),getNodeTR()];case 4:node.shape="rectangle";return[getNodeBottom(0)];case 5:node.shape="rectangle";return[getNodeTop(0),getNodeBottom(0)];case 6:node.shape="roundrectbr";return[getNodeBottom(1),getNodeRight(1),getNodeBR()];case 7:node.shape="roundrectr";return[getNodeTop(1),getNodeBottom(1),getNodeRight(3),getNodeBR(),getNodeTR()];case 8:node.shape="rectangle";return[getNodeLeft(0)];case 9:node.shape="roundrecttl";return[getNodeTop(2),getNodeLeft(2),getNodeTL()];case 10:node.shape="rectangle";return[getNodeRight(0),getNodeLeft(0)];case 11:node.shape="roundrectt";return[getNodeTop(3),getNodeRight(2),getNodeLeft(2),getNodeTR(),getNodeTL()];case 12:node.shape="roundrectbl";return[getNodeBottom(2),getNodeLeft(1),getNodeBL()];case 13:node.shape="roundrectl";return[getNodeTop(2),getNodeBottom(2),getNodeLeft(3),getNodeTL(),getNodeBL()];case 14:node.shape="roundrectb";return[getNodeBottom(3),getNodeRight(1),getNodeLeft(1),getNodeBR(),getNodeBL()];case 15:if(node.width<64||node.height<64){node.shape="rectangle";delete node.gradient;delete node.color1;delete node.color2;delete node.color3;return[getNodeTop(0)]}node.shape="roundrect2";return[getNodeTop(3),getNodeBottom(3),getNodeRight(3),getNodeLeft(3),getNodeTR(),getNodeTL(),getNodeBR(),getNodeBL()]}return[]};var getLengthToNodeBoundary=function(x0,y0,x1,y1,node){var wi=node.width;var he=node.height;var cl=that.clip("line",[x0,y0,x1,y1],[x0-(node.width/2),y0-(node.height/2),node.width+(x0-(node.width/2)),node.height+(y0-(node.height/2))]);return that.lineLength(cl[0],cl[1],cl[2],cl[3])+2};var nodes=[];var edges=[];var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="map"){var seen={};var sord=[];var n=0;var ob=this.XMLToJSON(pw,false,false,true);nodes.push({id:"__background__",type:"background",shape:"rectangle",color:"rgb(220,231,232)",outline:"rgb(29,154,195)",outlineWidth:3,width:Number(ob.width),height:Number(ob.height),x:Number(ob.width)*0.5,y:Number(ob.height)*0.5,hideLabel:true,immutable:true,eventless:true,zorder:1});sord.push(n++);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"localizations":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="loc"){var js=this.XMLToJSON(nd);var shp=loc.hasOwnProperty(js.id)?"image":js.id=="16"?"roundrect2":"roundrect";var node={id:"loc"+(j+1),shape:shp,hideLabel:true,immutable:true,eventless:true,x:Number(js.x)+(Number(js.width)*0.5),y:Number(js.y)+(Number(js.height)*0.5),width:Number(js.width),height:Number(js.height),type:Number(js.type),zorder:js.appearance&&js.appearance[0].zorder?Number(js.appearance[0].zorder.replace("Integer: ","")):2};if(shp!="image"){node.color="rgba(0,0,0,0)";node.outline=js.id=="16"?"rgba(0,0,0,0)":"rgb(83,158,188)";node.outlineWidth=js.id!="16"?3:0;if(js.id!="16"){node.width-=6;node.height-=6}}if(js.appearance&&js.appearance[0].rotateangle){node.rotate=Number(js.appearance&&js.appearance[0].rotateangle.split(": ")[1]);if(!node.rotate){delete node.rotate}else{node.widthTMP=node.width;node.width=node.height;node.height=node.widthTMP;delete node.widthTMP}}if(js.id=="16"){node.gradient="linear";node.color1="rgb(122,194,226)";node.color2="rgb(223,237,248)";node.color3="rgb(223,237,248)"}if(shp=="image"){if(js.id=="1287"){node.imagePath=js.type=="1"?CanvasXpress.images.mitochondria2:CanvasXpress.images.mitochondria}else{node.imagePath=CanvasXpress.images[loc[js.id]]}}for(var p in js){if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(": ");switch(vk[0]){case"String":node[a]=vk[1];break;case"Integer":case"Double":node[a]=Number(vk[1]);break;case"Boolean":node[a]=vk[1]=="true"?true:false;break}}}}nodes.push(node);sord.push(n++);if(Number(js.id)==16){var mem=getMembrane(node);if(mem.length){for(var k=0;k<mem.length;k++){nodes.push(mem[k]);sord.push(n++)}}}}}break;case"nodes":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="node"){var js=this.XMLToJSON(nd);var node={};for(var p in js){if(p.toLowerCase()=="alt"){if(js[p][0].match(/\w/)){node.tooltip=js[p][0].replace(/\"/g,"'");node.tooltip=js[p][0].replace(/\[/g,"&#91");node.tooltip=js[p][0].replace(/\]/g,"&#93")}}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(":");switch(vk[0]){case"String":node[a]=vk[1].replace(/\s/g,"");break;case"Integer":case"Double":node[a]=Number(vk[1].replace(/\s/g,""));break;case"Boolean":node[a]=vk[1].replace(/\s/g,"")=="true"?true:false;break;case"Rectangle":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"Color":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);node[a][3]=Math.round(node[a][3]/255*10)/10;node[a]="rgba("+node[a].join(",")+")";break;case"Font":node[a]=vk[1].replace(/\s/g,"").split(",");break}}}node[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}node.extId=js.id;node.id=js.nodeid.toString();node.x=Number(js.x)+(Number(js.width)*0.5);node.y=Number(js.y)+(Number(js.height)*0.5);node.width=Number(js.width);node.height=Number(js.height);if(node.iconarea){node.width=node.iconarea[2];node.height=node.iconarea[3];node.x=node.iconarea[0]+(node.width*0.5);node.y=node.iconarea[1]+(node.height*0.5);delete node.iconarea}if(js.icontype&&(js.type==0||js.type==16)){if(isNaN(js.icontype)){js.icontype=1000}if(Number(js.icontype)<10){js.icontype="0"+js.icontype}if(CanvasXpress.images.hasOwnProperty(js.icontype)){node.zoomX=50/node.width;node.zoomY=50/node.height;node.shape="image";node.imagePath=CanvasXpress.images[js.icontype];node.immutable=false}else{node.shape="roundrect";node.immutable=true}}else{if(js.icontype){switch(js.type){case"-10":node.width-=5;node.height-=5;node.x+=2.5;node.y+=2.5;node.shape=node.arcwidth>40?"roundrecto":"roundrect";break;case"21":case"61":case"63":case"91":case"-11":case"-12":node.width-=4;node.height-=4;node.x+=2;node.y+=2;node.shape="roundrect";break;default:break}node.immutable=true}else{node.shape="roundrect";node.immutable=true}}if(node.name==""){node.hideLabel=true}else{node.name=node.name.toString().replace(/\[/g,"&#91").replace(/\]/g,"&#93").replace(/\"/g,"&quot")}if(node.textarea){var lines=1;if(node.font){lines=Math.floor(node.textarea[3]/(Number(node.font[2])+(Number(node.font[2])>12?1:0)));node.labelSize=node.font[2]==14?1.1:1;if(node.font[0].match(/Bold Italic/i)){node.labelStyle="Bold Italic"}else{if(node.font[0].match(/Bold/i)){node.labelStyle="Bold"}else{if(node.font[0].match(/Italic/i)){node.labelStyle="Italic"}}}}if(lines>1&&!node.name.toString().match(/\n/)){var fnt=this.nodeFontStyle+" "+Math.floor(10*node.labelSize)+"px "+this.fontName;var tst=Math.floor(node.textarea[2]/5.5);var wrp=tst>0?this.wrapText(node.name.toString(),tst):node.name.toString();var lns=wrp.split(/\n/);var max=this.measureTextMultiple(wrp,fnt);if(lns.length>lines){while(lns.length>lines&&tst<node.name.toString().length){wrp=this.wrapText(node.name.toString(),tst++);lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt)}}if(max>node.textarea[2]){wrp=wrp.replace("(","\n(");lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt);while((max>node.textarea[2]||lns.length*fnt>node.textarea[3]||lns.length<lines)&&tst>3){wrp=this.wrapText(node.name,tst--);lns=wrp.split(/\n/);max=this.measureTextMultiple(wrp,fnt)}}node.name=wrp}else{if(lines==0){node.hideLabel=true}}node.labelX=node.textarea[0]+(node.textarea[2]*0.5);node.labelY=node.textarea[1]+(node.textarea[3]*0.5)}if(node.textalignment!=null){if(node.textalignment==0){node.labelAlign="left";node.labelX-=(node.textarea[2]*0.45)}else{if(node.textalignment==1){node.labelAlign="center"}else{if(node.textalignment==2){node.labelAlign="right";node.labelX+=(node.textarea[2]*0.45)}}}}delete node.textarea;if(node.fontcolor){node.labelColor=node.fontcolor;delete node.fontcolor}if(node.backgroundcolor){node.color=node.backgroundcolor;delete node.backgroundcolor}if(node.bordercolor){node.outline=node.bordercolor;delete node.bordercolor}if(node.rotateangle){node.rotate=node.shape=="image"?-node.rotateangle:270-node.rotateangle;if(node.shape!="image"){node.labelRotate=-node.rotateangle}delete node.rotateangle}if(node.borderwidth){node.outlineWidth=Number(node.borderwidth)-1;delete node.borderwidth}seen[node.id]=n;delete node.appearance;delete node.icontype;nodes.push(node);sord.push(n++);if(node.complex){nodes.push({id:node.id+"-complex",x:node.x,y:node.y,width:14,height:14,shape:"star",color:"rgb(255,255,255)",hideLabel:true,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-complex"]=n;sord.push(n++);delete node.complex}if(node.pathstart){var rot=0;var ptx=0;var pty=0;switch(node.sideofpathstarteditor){case 0:rot=90;pty=-(40+node.pathstartarrowmargin);break;case 1:rot=180;ptx=(40+node.pathstartarrowmargin);break;case 2:rot=270;pty=(40+node.pathstartarrowmargin);break;case 3:rot=0;ptx=-(40+node.pathstartarrowmargin);break}nodes.push({id:node.id+"-pathstart",x:node.x+ptx,y:node.y+pty,width:40,height:40,shape:"image",imagePath:CanvasXpress.images["99"],hideLabel:true,immutable:true,rotate:rot,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-pathstart"]=n;sord.push(n++);delete node.sideofpathstarteditor;delete node.pathstartarrowmargin;delete node.pathstart}if(node.organismspecificobject){nodes.push({id:node.id+"-organism",x:node.x,y:node.y,width:60,height:60,shape:"circle",color:"rgba(0,0,0,0.1)",outline:"rgb(255,255,0)",outlineWidth:3,hideLabel:true,zorder:node.zorder-1,parentNode:node.id});seen[node.id+"-organism"]=n;sord.push(n++);delete node.organismspecificobject}}}break;case"edges":for(var j=0;j<el.childNodes.length;j++){var ed=el.childNodes[j];if(ed.nodeName&&ed.nodeName.toLowerCase()=="edge"){var js=this.XMLToJSON(ed);var edge={};for(var p in js){if(p.toLowerCase()=="alt"){continue}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){if(a=="linkhighlighting"){vk=js[p][0][a].split(":");if(vk[1]=="Color"&&vk[2]){vk[2]=vk[2].split(",");vk[2].pop();edge.highlight="rgb("+vk[2].join(",")+")"}}else{vk=js[p][0][a].split(": ");switch(vk[0]){case"String":edge[a]=vk[1];break;case"Integer":case"Double":edge[a]=Number(vk[1]);break;case"Boolean":edge[a]=vk[1]=="true"?true:false;break;case"Rectangle":edge[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"PointArray":var cp=[];vk[1]=vk[1].replace(/\s/g,"").split(";");for(var k=0;k<vk[1].length-1;k++){cp.push(vk[1][k].split(",").map(Number))}edge[a]=cp;break}}}}edge[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}edge.id1=js.src;edge.id2=js.dst;if(edge.type){edge.EdgeType=edge.type;delete edge.type}if(edge.directed){edge.endArrow="arrow";delete edge.directed}edge.color="grey";edge.type=edge.enhances?"dashed":"solid";if(edge.visualization=="Round"){edge.type="quadratic";edge.angle=edge.angle}else{if(edge.visualization=="Bezier"){if(!edge.controlpoints){edge.type="solid";edge.linksourcepointindex=0;edge.linktargetpointindex=0}else{edge.type="bezier";edge.angle=edge.angle}}}if(edge.hasOwnProperty("effect")){if(edge.effect>=0){switch(edge.effect){case 0:edge.color="rgb(152,156,158)";break;case 1:edge.color="rgb(0,128,0)";break;case 2:edge.color="rgb(170,0,0)";break}}if(edge.mech!=null){var dec={};if(edge.showhexagon){var col=edge.hexagoncustomcolor||edge.color;var idx=edge.hexagonindex||0;var pos=edge.hexagoncoordinate||0.5;var cll=edge.effect==0?"black":"rgb(242,216,0)";var getDec=function(lbl){return{label:lbl,labelColor:cll,shape:"hexagon",color:col,index:idx,pos:pos}};switch(edge.mech){case -1:dec=getDec("");break;case 0:dec=getDec("?");break;case 2:dec=getDec("CM");break;case 3:dec=getDec("+P");break;case 4:dec=getDec("-P");break;case 5:dec=getDec("B");break;case 6:dec=getDec("Cn");break;case 7:dec=getDec("T");break;case 8:dec=getDec("C");break;case 9:dec=getDec("TR");break;case 10:dec=getDec("GR");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 11:dec=getDec("CR");break;case 12:dec=getDec("IE");break;case 14:dec=getDec("CS");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 15:dec=getDec("Z");break;case 16:dec=getDec("Tn");break;case 20:dec=getDec("cRT");break;case 21:dec=getDec("PE");break;case 22:dec=getDec("TE");break;case 24:dec=getDec("M");break;case 31:dec=getDec("SR");break;case 44:dec=getDec("RG");break;default:dec=getDec("");break}if(dec.label!=""){edge.decoration=[dec]}}delete edge.effect;delete edge.mech;delete edge.hexagonindex;delete edge.hexagoncoordinate;delete edge.showhexagon;delete edge.hexagoncustomcolor}}if(edge.broken){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"X",labelColor:"purple",fontSize:20,shape:"square",color:"rgba(0,0,0,0)",index:(edge.brokenindex||0),pos:(edge.brokencoordinate||0.5)});delete edge.broken;delete edge.brokenindex;delete edge.brokencoordinate}if(edge.weakens){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"-x-",labelColor:"purple",fontSize:12,shape:"square",color:"rgba(0,0,0,0)",index:(edge.weakensindex||0),pos:(edge.weakenscoordinate||0.5)});delete edge.weakens;delete edge.weakensindex;delete edge.weakenscoordinate}if(edge.disease){edge.color="purple";edge.thickness=2;delete edge.disease}if(edge.enhances){edge.color="purple";edge.thickness=2;delete edge.enhances}delete edge.appearance;delete edge.src;delete edge.dst;if(seen.hasOwnProperty(edge.id1)&&seen.hasOwnProperty(edge.id2)){var src=nodes[seen[edge.id1]];var dst=nodes[seen[edge.id2]];var sx=src.x;var sy=src.y;var sw=src.width*0.5;var sh=src.height*0.5;var ex=0;var ey=0;var dx=dst.x;var dy=dst.y;var dw=dst.width*0.5;var dh=dst.height*0.5;var ss,sd,sq,ds,dd,dq,xy,cx,cy,rd,frs,lst,n1;if(edge.visualization&&edge.visualization=="Right angle polyline"){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(edge.firstleg&&edge.firstleg=="Vertical"){frs=edge.controlpoints?edge.controlpoints[0][1]:false;sy=frs&&frs[1]>0?sy+sh:src.y>dst.y?sy-sh:frs&&frs<0?sy-sh:sy+sh;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{if(ss==1){sx=sx+sw}else{if(ss==3){sx=sx-sw}}}sq="tb"}else{frs=edge.controlpoints?edge.controlpoints[0][0]:false;sx=frs&&frs>0?sx+sw:src.x>dst.x?sx-sw:frs&&frs<0?sx-sw:sx+sw;if(ss==1||ss==3){sy=(sy-sh)+(src.height*sd)}else{if(ss==0){sy=sy-sh}else{if(ss==2){sy=sy+sh}}}sq="lr"}ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(!edge.controlpoints){if(edge.firstleg&&edge.firstleg=="Vertical"){dx=src.x>dst.x?dx+dw:dx-dw;if(ds==1||ds==3){dy=(dy-dh)+(dst.height*dd)}}else{dy=src.y>dst.y?dy+dh:dy-dh;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}}}else{dq=edge.controlpoints.length%2?sq:sq=="tb"?"lr":"tb";n1=edge.controlpoints.length-1;lst=edge.controlpoints[n1];if(edge.linktargetpointindex){if(ds==1||ds==3){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}dy=(dy-dh)+(dst.height*dd)}else{if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd);if(src.y+lst[1]>dst.y){dy+=dh}else{dy-=dh}}}}else{if(edge.controlpoints.length%2){if(sq==dq&&sq=="lr"){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}}}else{dx=src.x+lst[0]>dst.x?dx+dw:dx-dw}if(edge.controlpoints.length%2){if(sq!=dq||sq!="lr"){dy=src.y+lst[1]>dst.y?dy+dh:dy-dh}}else{if(src.y+lst[1]>dst.y){dy=dy+dh}}}}if(edge.controlpoints){edge.elbows=[[sx,sy]];cx=sx;cy=sy;if(edge.firstleg&&edge.firstleg=="Vertical"){for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cx=sx+edge.controlpoints[k][0]}else{cy=sy+edge.controlpoints[k][1]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([dx,cy])}else{edge.elbows.push([cx,dy])}}else{for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cy=sy+edge.controlpoints[k][1]}else{cx=sx+edge.controlpoints[k][0]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([cx,dy])}else{edge.elbows.push([dx,cy])}}edge.elbows.push([dx,dy])}else{if(edge.firstleg&&edge.firstleg=="Vertical"){edge.elbows=[[sx,sy],[sx,dy],[dx,dy]]}else{edge.elbows=[[sx,sy],[dx,sy],[dx,dy]]}}}else{if(edge.controlpoints&&edge.linksourcepointindex!=null&&edge.linktargetpointindex!=null&&edge.id1!=edge.id2){if(edge.linksourcepointindex||edge.controlpoints){frs=edge.controlpoints?edge.controlpoints[0]:[0,0];if(edge.linksourcepointindex==0){ds=getLengthToNodeBoundary(sx,sy,sx+frs[0],sy+frs[1],src);xy=this.getCoordinateAtDistance(sx,sy,sx+frs[0],sy+frs[1],ds);rd=this.getRadians(sx,sy,sx+frs[0],sy+frs[1]);sx=xy[0];sy=xy[1];ex=(-ds*-Math.cos(rd));ey=ds*Math.sin(rd)}else{ss=Math.floor((edge.linksourcepointindex-1)/src.linkpointcount);sd=(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1);switch(ss){case 0:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy-sh;break;case 1:ex=0;ey=(src.height*sd);sx=sx+sw;sy=ey+sy-sh;break;case 2:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy+sh;break;case 3:ex=0;ey=(src.height*sd);sx=sx-sw;sy=ey+sy-sh;break}}}if(edge.linktargetpointindex||edge.controlpoints){lst=edge.controlpoints?this.cloneObject(edge.controlpoints[edge.controlpoints.length-1]):[0,0];if(edge.linktargetpointindex==0){if(edge.controlpoints){lst[0]=dx-(sx+lst[0]);lst[1]=dy-(sy+lst[1])}ds=getLengthToNodeBoundary(dx,dy,dx+lst[0],dy+lst[1],dst);xy=this.getCoordinateAtDistance(dx,dy,dx+lst[0],dy+lst[1],-ds);rd=this.getRadians(dx,dy,dx+lst[0],dy+lst[1]);dx=xy[0];dy=xy[1]}else{ds=Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount);dd=(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1);switch(ds){case 0:dx=(dst.width*dd)+dx-dw;dy=dy-dh;break;case 1:dx=dx+dw;dy=(dst.height*dd)+dy-dh;break;case 2:dx=(dst.width*dd)+dx-dw;dy=dy+dh;break;case 3:dx=dx-dw;dy=(dst.height*dd)+dy-dh;break}}}edge.elbows=[];for(var k=0;k<edge.controlpoints.length;k++){edge.elbows.push([sx+edge.controlpoints[k][0]+5,sy+edge.controlpoints[k][1]])}edge.elbows.unshift([sx,sy]);edge.elbows.push([dx,dy])}else{if(edge.id1==edge.id2){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;if(ss==ds){edge.self={dir:edge.angle>0,pos:(ss==0?"top":ss==1?"right":ss=2?"bottom":"left"),size:20,end:"arrow"}}else{if(ss>ds||(ss==0&&ds==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topLeft":ss=1?"topRight":ss==2?"bottomRight":"bottomLeft"),size:20,end:"arrow"}}else{if(ds>ss||(ds==0&&ss==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topRight":ss==1?"bottomRight":ss==2?"bottomLeft":"topLeft"),size:20,end:"arrow"}}}}}else{if(edge.linksourcepointindex){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{sy=(sy-sh)+(src.height*sd)}}if(edge.linktargetpointindex){ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}else{dy=(dy-dh)+(dst.height*dd)}}if(edge.linksourcepointindex||edge.linktargetpointindex){if(edge.linksourcepointindex){switch(ss){case 0:sy-=sh;break;case 1:sx+=sw;break;case 2:sy+=sh;break;case 3:sx-=sw;break}if(!edge.linktargetpointindex){ds=getLengthToNodeBoundary(dx,dy,sx,sy,dst);xy=this.getCoordinateAtDistance(dx,dy,sx,sy,ds);dx=xy[0];dy=xy[1]}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}}}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}ds=getLengthToNodeBoundary(sx,sy,dx,dy,src);xy=this.getCoordinateAtDistance(sx,sy,dx,dy,ds);sx=xy[0];sy=xy[1]}edge.elbows=[[sx,sy],[dx,dy]]}}}}delete edge.linksourcepointindex;delete edge.linktargetpointindex;delete edge.controlpoints;delete edge.visualization;delete edge.firstleg;edges.push(edge)}}}break}}}sord.sort(function(a,b){if(nodes[a].zorder-nodes[b].zorder==0){return a-b}else{return nodes[a].zorder-nodes[b].zorder}});var tmp=[];for(var i=0;i<sord.length;i++){tmp.push(nodes[sord[i]])}nodes=tmp}else{alert("Ooops! Not a Metabase xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Metabase"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.gexfToCX=function(xml,target,config,events){var nodes=[];var edges=[];var cl=true;var gexf=xml.childNodes[0];if(gexf.tagName.toLowerCase()=="gexf"){for(var i=0;i<gexf.childNodes.length;i++){var el=gexf.childNodes[i];if(el.nodeName&&el.nodeName.toLowerCase()=="graph"){for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="nodes"){for(var k=0;k<nd.childNodes.length;k++){var n=nd.childNodes[k];if(n.nodeName&&n.nodeName.toLowerCase()=="node"){var js=this.XMLToJSON(n);var node={};if(js.id){for(var p in js){switch(p.toLowerCase()){case"id":node.id=js.id;break;case"label":node.name=js.label;break;case"color":node.color="rgb("+js[p][0].r+","+js[p][0].g+","+js[p][0].b+")";break;case"position":node.x=Number(js[p][0].x);node.y=Number(js[p][0].y);node.z=Number(js[p][0].z);cl=false;break;case"size":node.width=Number(js[p][0].value);node.height=Number(js[p][0].value);break}}nodes.push(node)}}}}else{if(nd.nodeName&&nd.nodeName.toLowerCase()=="edges"){for(var k=0;k<nd.childNodes.length;k++){var e=nd.childNodes[k];if(e.nodeName&&e.nodeName.toLowerCase()=="edge"){js=this.XMLToJSON(e);var edge={};if(js.source&&js.target){edge.id1=js.source;edge.id2=js.target;edges.push(edge)}}}}}}}}}else{alert("Ooops! Not a Gephi gexf file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{graphType:"Network",calculateLayout:cl,showAnimation:false,networkNodesOnTop:true,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Gephi"},renderTo:target,events:events,uploadFile:(this.dataString?false:true),afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}var clbk=false;var rurl=this.dataURL||this.dataString;var cnfg=this.cloneObject(this.meta.config.user);if(this.graphType=="Network"){for(var p in this.meta.config.user){data.config[p]=this.meta.config.user[p]}clbk=function(t){t.meta.config.remote={data:rurl,config:cnfg};t.networkFreeze=true}}this.updateRemoteData(data,clbk);this.hideMask()};this.parseGML=function(gml){var forIn=function(object,callback){Object.keys(object).forEach(function(key){callback(key,object[key])})};var json=("{\n"+gml+"\n}").replace(/^(\s*)(\w+)\s*\[/gm,'$1"$2": {').replace(/^(\s*)\]/gm,"$1},").replace(/^(\s*)(\w+)\s+(.+)$/gm,'$1"$2": $3,').replace(/,(\s*)\}/g,"$1}");var graph={};var nodes=[];var edges=[];var i=0;json=json.replace(/^(\s*)"node"/gm,function(all,indent){return(indent+'"node['+(i++)+']"')});i=0;json=json.replace(/^(\s*)"edge"/gm,function(all,indent){return(indent+'"edge['+(i++)+']"')});try{json=this.parseJSON(json)}catch(err){throw new SyntaxError("bad format")}if(!this.isObject(json.graph)){throw new SyntaxError("no graph tag")}forIn(json.graph,function(key,value){var matches=key.match(/^(\w+)\[(\d+)\]$/);var name;var i;if(matches){name=matches[1];i=parseInt(matches[2],10);if(name==="node"){nodes[i]=value}else{if(name==="edge"){edges[i]=value;edges[i].id1=edges[i].source;edges[i].id2=edges[i].target;delete (edges[i].source);delete (edges[i].target)}else{graph[key]=value}}}else{graph[key]=value}});graph.nodes=nodes;graph.edges=edges;return{data:graph,config:{graphType:"Network"}}};this.arrayToCanvasXpress=function(arr){var unique=function(a){return a.filter(function(x,i){return a.indexOf(x)===i})};var data={y:{vars:[],smps:[],data:[]}};var g="Scatter2D";var cols=arr[0].filter(Number);if(cols.length==0){cols=arr.shift()}else{cols=[];for(var i=0;i<arr[0].length;i++){cols.push("C"+(i+1))}}var rows=[];for(var i=0;i<arr.length;i++){rows.push(arr[i][0].toString())}var urow=unique(rows);if(urow.length==rows.length){for(var i=0;i<arr.length;i++){arr[i].shift(arr[i][0])}}else{rows=[];for(var i=0;i<arr.length;i++){rows.push("R"+(i+1))}}if(cols.length>arr[0].length){cols.shift();if(!cols.length==arr[0].length){return false}}if(arr[0].length!=arr[arr.length-1].length){arr.pop();rows.pop();if(arr[0].length!=arr[arr.length-1].length){return false}}var types=[];var total=0;for(var i=0;i<cols.length;i++){types[i]=false;for(var j=0;j<rows.length;j++){if(isNaN(arr[j][i])){types[i]=true;break}}if(!types[i]){for(var j=0;j<rows.length;j++){arr[j][i]=arr[j][i]==null||arr[j][i]==undefined?null:!isNaN(parseFloat(arr[j][i]))&&isFinite(arr[j][i])?Number(arr[j][i]):null}total++}else{data.z={}}}var trans=false;if(total>1){var n=Math.ceil(total*0.6);var q=0;for(var i=types.length-1;i>=0;i--){if(!types[i]){q++}else{if(q<n){trans=true}}}}for(var i=0;i<rows.length;i++){data.y.data[i]=[];data.y.vars.push(rows[i])}for(var i=0;i<cols.length;i++){if(types[i]||(this.metaData&&this.metaData.hasOwnProperty(cols[i]))){data.z[cols[i]]=[];for(var j=0;j<rows.length;j++){data.z[cols[i]].push(arr[j][i])}}else{data.y.smps.push(cols[i]);for(var j=0;j<rows.length;j++){data.y.data[j].push(arr[j][i])}}}if(data.y.smps.length==0){var n=data.y.data.length;data.y.data=[[]];for(var i=0;i<n;i++){data.y.data[0].push(1)}data.y.smps=data.y.vars;data.y.vars=["counts"];data.x=data.z;delete (data.z);g="Bar"}else{if(data.y.smps.length==1||trans){var trp=function(mat){return mat[0].map(function(_,c){return mat.map(function(r){return r[c]})})};data.y.data=trp(data.y.data);data.y.vars=data.y.smps;data.y.smps=rows;data.x=data.z;delete (data.z);g="Bar"}}return{data:data,config:{graphType:g}}};this.getRDatasets=function(){var setRDataSets=function(t){return function(r){t.Rdatasets=t.parseJSON(r)}}(this);var url=this.RdatasetsURL+"datasets.json";this.ajaxRequest(url,false,setRDataSets)};this.getRLibraryDataSets=function(s){this.getDataSetListFromURL(this.RdatasetsURL+"json/"+s+"/datasets.json")};this.appendNetworkDataFromURL=function(){var that=this;var url=this.appendNetworkData.length>0?this.appendNetworkData.shift():false;var appendDelimitedData=function(r){var tc=0;var tt=0;if(r.match(/,/g)){tc=r.match(/,/g).length}if(r.match(/\t/g)){tt=r.match(/\t/g).length}var dl=url.match(/\.csv$/)&&tc>tt?",":"\t";var data=that.delimitedToArray(r,dl,false,true);if(data&&!that.isArray(data)){var fail="";if(data.fail>0){fail=data.fail+" records couldn't be mapped to network data"}that.flashInfoSpan(100,150,data.rows+" "+data.type+" records added to network data\n"+fail,5000);var cn=that.meta.config.user;var at=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy","colorEdgeBy","SizeEdgeBy","decorations"];for(var i=0;i<at.length;i++){var a=at[i];if(cn.hasOwnProperty(a)){that[a]=cn[a]}}if(data.type=="node"){that.appendNodeData(data.data)}else{that.appendEdgeData(data.data)}if(that.appendNetworkData.length>0){that.appendNetworkDataFromURL()}else{that.draw({func:"appendNetworkDataFromURL"});that.hideMask()}}};var appendJSONData=function(r){if(r.type=="node"){that.appendNodeData(r.data)}else{that.appendEdgeData(r.data)}if(that.appendNetworkData.length>0){that.appendNetworkDataFromURL()}else{that.draw({func:"appendNetworkDataFromURL"});that.hideMask()}};var appendDataURL=function(t){return function(r){if(url.match(/\.txt$/)||url.match(/\.csv$/)||url.match(/\.tsv$/)||url.match(/\.tab$/)){appendDelimitedData(r)}else{t.hideMask();alert("Oooops! Not a CanvasXpress Network delimited file")}}}(this);if(url){if(typeof(url)=="string"){var obj=this.isValidString(url);switch(obj.type){case"URL":this.ajaxRequest(url,false,appendDataURL);break;case"XML":alert("XML not supported!");break;case"JSON":appendJSONData(obj.data);case"DELIM":appendDelimitedData(url);break}}else{appendJSONData(url)}}};this.getDataFromURLOrString=function(target,config,events,info,callback){if(this.dataURL){var that=this;var getJSON=function(s){try{return that.parseJSON(s)}catch(e){return false}};var format=this.dataURL.match(/\.png$/)?"arraybuffer":false;var setData=function(t){return function(r){var data=getJSON(r);t.remoteService=t.dataURL;t.remoteServiceType="file";if(t.isObject(data)){if(Array.isArray(data)){return t.setDataSetsFromURL(r)}}else{if(t.dataURL.match(/\.png$/)){data=t.parseDataFromPNG(r)}else{if(t.dataURL.match(/\.svg$/)){data=t.SVGtoCX(r)}else{if(t.dataURL.match(/\.txt$/)||t.dataURL.match(/\.csv$/)||t.dataURL.match(/\.tsv$/)||t.dataURL.match(/\.tab$/)){data=t.delimitedToArray(r,false,true)}else{if(t.dataURL.match(/.gexf/)){var xml=t.parseXML(r);return t.gexfToCX(xml,trg)}else{if(t.dataURL.match(/\ml$/)){var xml=t.parseXML(r);var ts1=xml.childNodes[0];var ts2=xml.childNodes[2];var trg=target?target:t.newId("-cX-data-url-");if(ts1.tagName&&ts1.tagName.toLowerCase()=="map"){return t.metabaseToCX(xml,trg)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="graph"){return t.cytoscapeToCX(xml,trg)}else{if(ts1.tagName&&ts1.tagName.toLowerCase()=="pathway"){return t.wikipathwayToCX(xml,trg)}else{if(ts2&&ts2.tagName&&ts2.tagName.toLowerCase()=="pathway"){return t.keggToCX(xml,trg)}}}}}}}}}}data.records=0;data.renderTo=target?target:data.renderTo?data.renderTo:t.newId("-cX-data-url-");data.config=config?config:data.config?data.config:{graphType:"Scatter2D"};if(data.config.graphType=="Network"){data.config.appendNetworkData=t.appendNetworkData}data.events=events?events:data.events?data.events:false;data.info=info?info.toString().replace(/'/g,"'").replace(/"/g,"'"):data.info?data.info.toString().replace(/'/g,"'").replace(/"/g,"'"):false;data.noValidate=true;if(!data.afterRender){data.afterRender=[]}if(data.config.graphType=="Network"){data.afterRender.push(["appendNetworkDataFromURL",[]])}var rurl=t.dataURL;var cnfg=t.cloneObject(t.meta.config.user);t.updateRemoteData(data,function(that){that.meta.config.remote={data:rurl,config:cnfg};that.reInitStack(data);if(callback){callback()}})}}(this);this.ajaxRequest(this.dataURL,false,setData,format)}else{if(this.topoJSONURL){var setData=function(t){return function(r){var json=t.parseJSON(r);var rd=t.isExample?false:t.cloneObject(t.data);var rc=t.cloneObject(t.meta.config.user);var data={renderTo:t.target,data:t.isExample?false:t.data,config:t.meta.config.user};if(!window[t.mapId]||!t.isObject(window[t.mapId])){data.config.remoteTransitionEffect="none";window[t.mapId]=json;t.remoteServiceType="file";t.updateRemoteData(data,function(that){that.meta.config.remote={data:rd,config:rc};that.reInitStack(data);for(i in CanvasXpress.chain){if(CanvasXpress.chain[i]==that.target){if(CanvasXpress.stack[i].hasOwnProperty("afterRender")){that.afterRender(CanvasXpress.stack[i].afterRender)}}}if(callback){callback()}})}}}(this);this.ajaxRequest(this.topoJSONURL,false,setData)}else{if(this.dataString){this.loadXML(this.dataString,target,config,events)}}}};this.getDataSetListFromURL=function(u){this.remoteService=u;this.ajaxRequest(u,false,this.setDataSetsFromURL)};this.setDataSetsFromURL=function(t){return function(r){var setDataSetsFromURLRemote=function(t){return function(r){var obj=n.parseJSON(r);n.updateRemoteData({data:obj,ids:n.remoteIds,records:n.remoteIds.length})}}(n);var getParentId=function(){var par=t.$("container-"+t.target).parentNode;while(par.id.match("canvasXpressRemoteWindow")){par=par.parentNode}if(!par.id){par.id=t.newId("-cX-data-sets-url-container-")}return par.id};var obj=t.parseJSON(r);var url=obj[0][1];var ids=[];for(var i=0;i<obj.length;i++){ids.push(obj[i][0])}var pid=getParentId();var par=t.$("container-"+t.target).parentNode;var cid=t.newId("-cX-data-sets-");var cnv=t.$cX("canvas",{id:cid,width:t.originalWidth,height:t.originalHeight});t.castCanvasAttributes(cnv);par.appendChild(cnv);var n=new CanvasXpress(cid,false,{remoteService:t.remoteService});t.remoteIds=ids;t.destroy(t.target);n.remoteData=obj;n.remoteParentId=pid;n.remoteIds=ids;n.remoteServiceType="file";n.ajaxRequest(url,false,setDataSetsFromURLRemote)}}(this);this.initStack=function(data,config,events,info,afterRender){if(!CanvasXpress.stack){CanvasXpress.stack={}}var cnv=this.$(this.target);if(cnv){CanvasXpress.stack[this.target]={version:CanvasXpress.factory.version,renderTo:this.target,data:(data?this.cloneObject(data):false),config:config||false,events:events?events:false,info:info?info.toString().replace(/'/g,"'").replace(/"/g,"'"):false,afterRenderInit:afterRender?afterRender:false,afterRender:[["setDimensions",[cnv.originalWidth,cnv.originalHeight,true]]],state:[],stateIndex:0,noValidate:true}}};this.reInitStack=function(data){if(data.data){if(data.config.stringSampleFactors){for(var i=0;i<data.config.stringSampleFactors.length;i++){var f=data.config.stringSampleFactors[i];for(var j=0;j<data.data.x[f].length;j++){data.data.x[f][j]=data.data.x[f][j].replace("\x00","")}}}if(data.config.stringVariableFactors){for(var i=0;i<data.config.stringVariableFactors.length;i++){var f=data.config.stringVariableFactors[i];for(var j=0;j<data.data.z[f].length;j++){data.data.z[f][j]=data.data.z[f][j].replace("\x00","")}}}CanvasXpress.stack[this.target].data=data.data}};this.getStack=function(){return CanvasXpress.stack[this.target].afterRender};this.getConfigState=function(){var skip={meta:true,animationOn:true,arrows:true,beaconImage:true,bubble:true,changingColorItemOn:true,changingColorOn:true,changingSliderItemOn:true,currentCanvasContext:true,draggingOn:true,doubleClick:true,events:true,functions:true,gantt:true,images:true,info:true,infoStartTime:true,isHighlightCanvas:true,isTransitionOn:true,keyOn:true,lastCanvasEvent:true,lastMousemove:true,lines:true,moveSankey:true,movingOn:true,nodes:true,panningOn:true,patterns:true,resetOn:true,resizeCanvasCursorShow:true,shapes:true,sizes:true,skipClick:true,skipTransition:true,times:true,touchEvent:true,touches:true,transitionIter:true,userId:true,validGraphTypes:true,vennCompartments:true,xMouseDown:true,yMouseDown:true};if(this.graphType!="Network"){skip.data=true}var keys=Object.keys(this);var cfg=this.getObjectArray(CanvasXpress.config);var props=[];for(var i=0;i<keys.length;i++){var c=keys[i];if(cfg.hasOwnProperty(c)){props.push(c)}else{if(!this.isFunction(this[c])&&!skip.hasOwnProperty(c)){props.push(c)}}}var config={};for(var i=0;i<props.length;i++){var c=props[i];config[c]=this.isObject(this[c])?this.cloneObject(this[c],true):this[c]}return config};this.setConfigState=function(idx){if(!idx){idx=0}var config=CanvasXpress.stack[this.target].state[idx];for(var c in config){this[c]=config[c]}var tmp={calculateLayout:this.calculateLayout};this.calculateLayout=false;this.skipStack=true;this.draw({func:"setConfigState",par:[idx]});this.skipStack=false;for(var c in tmp){this[c]=tmp[c]}};this.stack=function(o){if(!this.skipStack&&o){var f=o.func;var a=o.par?this.cleanEventInArguments(o.par):[];var p=o.prop?this.cloneObject(o.prop):{};var t=new Date().getTime();var n=CanvasXpress.stack[this.target].afterRender.length;if(f){switch(f){case"setDimensions":if(a&&a[0]==this.width&&a[1]==this.height){return}if(a&&a[5]){f="clickGraphMaxMin";a=a[5]>0?[false,false,true]:[false,this.maximized,false]}CanvasXpress.stack[this.target].afterRender.push([f,a,{},t]);break;case"broadcastDraw":f=a[0].func;a=a[0]&&a[0].par?this.cleanEventInArguments(a[0].par):[];p=a[0]&&a[0].prop||{};if(f){CanvasXpress.stack[this.target].afterRender.push([f,a,p,t])}break;case"drawIndicesAfterPannEvent":case"drawIndicesAfterWheelEvent":case"drawRangesAfterWheelEvent":case"updateDragCircular":case"updateDragScatter":case"updateDragNetwork":case"updateDragGenome":case"updateDragMap":case"updateDragMarker":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;var m=f=="updateDragNetwork"&&a[0].shiftKey?false:true;if(n>1&&u[n-1][0]==f&&m){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}CanvasXpress.stack[this.target].afterRender.push([f,a,p,t]);break;case"handleWheelEvent":CanvasXpress.stack[this.target].afterRender.push([f,a,p,t]);break;case"resortSankey":var u=CanvasXpress.stack[this.target].afterRender;var q=CanvasXpress.stack[this.target].state;if(n>1&&u[n-1][0]=="resortSankey"){var l=t-u[n-1][3];if(l<1000){u.pop();q.pop()}}default:CanvasXpress.stack[this.target].afterRender.push([f,a,p,t]);break}if(!this.disableUndoRedoKeys&&CanvasXpress.stack[this.target].stateIndex<CanvasXpress.stack[this.target].state.length-1){CanvasXpress.stack[this.target].state.splice(CanvasXpress.stack[this.target].stateIndex,CanvasXpress.stack[this.target].state.length-1)}this.meta.stack.push([f,this.meta.time.start,this.meta.time.elapsed]);if(!this.disableUndoRedoKeys){var s=this.getConfigState();CanvasXpress.stack[this.target].state.push(s);CanvasXpress.stack[this.target].stateIndex=CanvasXpress.stack[this.target].state.length-1}}}};this.reproducePlay=function(t){return function(e){t.reproduce(e,true)}}(this);this.reproduce=function(t){return function(e,p,d){if(t.maximized){t.clickGraphMaxMin()}if(t.motionBy){return}t.skipStack=true;t.reproducing=true;t.resetMenus();t.resetLinks();t.resetSelected(e,true);t.meta.ids={};if(d){t.setMotionObject();t.clickMotion(e,true,true)}else{t.addMotionDiv(e);if((e&&e.shiftKey)||p){t.clickMotion(e,true)}}}}(this);this.animate=function(t){return function(e){t.replot(e,true)}}(this);this.replot=function(t){return function(e,a,o){var d=t.cloneObject(CanvasXpress.stack[t.target]);if(!this.isRawData){if(d.data.y){delete d.data.y.data}}this.isQQ=false;this.isCDF=false;d.config.showTransition=a?true:false;if(o){var ar=t.cloneObject(d.afterRender);d.afterRender=[];for(var i=0;i<ar.length;i++){var c=ar[i];if(c[0]=="addQQPlot"&&d.config.decorations){delete d.config.decorations.qq}if(c[0]=="addCDFPlot"&&d.config.decorations){delete d.config.decorations.cdf}if(c&&c[4]){d.afterRender.push(c)}}}var m=false;if(t.maximized){t.clickGraphMaxMin()}t.destroy(t.target,true);new CanvasXpress(d)}}(this)};CanvasXpress.prototype.initSave=function(){
/*! @source http://purl.eligrey.com/github/Blob.js/blob/master/Blob.js */
(function(g){g.URL=g.URL||g.webkitURL;if(g.Blob&&g.URL){try{new Blob;return}catch(j){}}var i=g.BlobBuilder||g.WebKitBlobBuilder||g.MozBlobBuilder||(function(v){var m=function(F){return Object.prototype.toString.call(F).match(/^\[object\s(.*)\]$/)[1]},E=function s(){this.data=[]},C=function o(H,F,G){this.data=H;this.size=H.length;this.type=F;this.encoding=G},w=E.prototype,B=C.prototype,y=v.FileReaderSync,k=function(F){this.code=this[this.name=F]},x=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),A=x.length,r=v.URL||v.webkitURL||v,z=r.createObjectURL,l=r.revokeObjectURL,q=r,u=v.btoa,p=v.atob,n=v.ArrayBuffer,t=v.Uint8Array,D=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;C.fake=B.fake=true;while(A--){k.prototype[x[A]]=A+1}if(!r.createObjectURL){q=v.URL=function(G){var F=document.createElementNS("http://www.w3.org/1999/xhtml","a"),H;F.href=G;if(!("origin" in F)){if(F.protocol.toLowerCase()==="data:"){F.origin=null}else{H=G.match(D);F.origin=H&&H[1]}}return F}}q.createObjectURL=function(G){var H=G.type,F;if(H===null){H="application/octet-stream"}if(G instanceof C){F="data:"+H;if(G.encoding==="base64"){return F+";base64,"+G.data}else{if(G.encoding==="URI"){return F+","+decodeURIComponent(G.data)}}if(u){return F+";base64,"+u(G.data)}else{return F+","+encodeURIComponent(G.data)}}else{if(z){return z.call(r,G)}}};q.revokeObjectURL=function(F){if(F.substring(0,5)!=="data:"&&l){l.call(r,F)}};w.append=function(J){var L=this.data;if(t&&(J instanceof n||J instanceof t)){var K="",G=new t(J),H=0,I=G.length;for(;H<I;H++){K+=String.fromCharCode(G[H])}L.push(K)}else{if(m(J)==="Blob"||m(J)==="File"){if(y){var F=new y;L.push(F.readAsBinaryString(J))}else{throw new k("NOT_READABLE_ERR")}}else{if(J instanceof C){if(J.encoding==="base64"&&p){L.push(p(J.data))}else{if(J.encoding==="URI"){L.push(decodeURIComponent(J.data))}else{if(J.encoding==="raw"){L.push(J.data)}}}}else{if(typeof J!=="string"){J+=""}L.push(unescape(encodeURIComponent(J)))}}}};w.getBlob=function(F){if(!arguments.length){F=null}return new C(this.data.join(""),F,"raw")};w.toString=function(){return"[object BlobBuilder]"};B.slice=function(I,F,H){var G=arguments.length;if(G<3){H=null}return new C(this.data.slice(I,G>1?F:this.data.length),H,this.encoding)};B.toString=function(){return"[object Blob]"};B.close=function(){this.size=0;delete this.data};return E}(g));g.Blob=function(o,n){var q=n?(n.type||""):"";var m=new i();if(o){for(var p=0,k=o.length;p<k;p++){if(Uint8Array&&o[p] instanceof Uint8Array){m.append(o[p].buffer)}else{m.append(o[p])}}}var l=m.getBlob(q);if(!l.slice&&l.webkitSlice){l.slice=l.webkitSlice}return l};var h=Object.getPrototypeOf||function(k){return k.__proto__};g.Blob.prototype=h(new g.Blob())}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/canvas-toBlob.js/blob/master/canvas-toBlob.js */
(function(g){var h=g.Uint8Array,j=g.HTMLCanvasElement,i=j&&j.prototype,k=/\s*;\s*base64\s*(?:;|$)/i,l="toDataURL",n,m=function(u){var v=u.length,r=new h(v/4*3|0),t=0,x=0,y=[0,0],o=0,w=0,s,p,q;while(v--){p=u.charCodeAt(t++);s=n[p-43];if(s!==255&&s!==q){y[1]=y[0];y[0]=p;w=(w<<6)|s;o++;if(o===4){r[x++]=w>>>16;if(y[1]!==61){r[x++]=w>>>8}if(y[0]!==61){r[x++]=w}o=0}}}return r};if(h){n=new h([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(j&&(!i.toBlob||!i.toBlobHD)){if(!i.toBlob){i.toBlob=function(v,t){if(!t){t="image/png"}if(this.mozGetAsFile){v(this.mozGetAsFile("canvas",t));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(t)){v(this.msToBlob());return}var s=Array.prototype.slice.call(arguments,1),q=this[l].apply(this,s),p=q.indexOf(","),u=q.substring(p+1),o=k.test(q.substring(0,p)),r;if(Blob.fake){r=new Blob;if(o){r.encoding="base64"}else{r.encoding="URI"}r.data=u;r.size=u.length}else{if(h){if(o){r=new Blob([m(u)],{type:t})}else{r=new Blob([decodeURIComponent(u)],{type:t})}}}v(r)}}if(!i.toBlobHD&&i.toDataURLHD){i.toBlobHD=function(){l="toDataURLHD";var o=this.toBlob();l="toDataURL";return o}}else{i.toBlobHD=i.toBlob}}}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));var f=typeof window==="object"&&window.window===window?window:typeof self==="object"&&self.self===self?self:typeof global==="object"&&global.global===global?global:this;function e(g,h){if(typeof h==="undefined"){h={autoBom:false}}else{if(typeof h!=="object"){console.warn("Depricated: Expected third argument to be a object");h={autoBom:!h}}}if(h.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(g.type)){return new Blob([String.fromCharCode(65279),g],{type:g.type})}return g}function b(h,g,i){var j=new XMLHttpRequest();j.open("GET",h);j.responseType="blob";j.onload=function(){a(j.response,g,i)};j.onerror=function(){console.error("could not download file")};j.send()}function c(g){var h=new XMLHttpRequest();h.open("HEAD",g,false);h.send();return h.status>=200&&h.status<=299}function d(h){try{h.dispatchEvent(new MouseEvent("click"))}catch(i){var g=document.createEvent("MouseEvents");g.initMouseEvent("click",true,true,window,0,0,0,80,20,false,false,false,false,0,null);h.dispatchEvent(g)}}var a=f.saveAs||(typeof window!=="object"||window!==f)?function a(){}:"download" in HTMLAnchorElement.prototype?function a(i,j,k){var g=f.URL||f.webkitURL;var h=document.createElement("a");j=j||i.name||"download";h.download=j;h.rel="noopener";if(typeof i==="string"){h.href=i;if(h.origin!==location.origin){c(h.href)?b(i,j,k):d(h,h.target="_blank")}else{d(h)}}else{h.href=g.createObjectURL(i);setTimeout(function(){g.revokeObjectURL(h.href)},40000);setTimeout(function(){d(h)},0)}}:"msSaveOrOpenBlob" in navigator?function a(h,i,j){i=i||h.name||"download";if(typeof h==="string"){if(c(h)){b(h,i,j)}else{var g=document.createElement("a");g.href=h;g.target="_blank";setTimeout(function(){d(g)})}}else{navigator.msSaveOrOpenBlob(e(h,j),i)}}:function a(h,j,g,k){k=k||open("","_blank");if(k){k.document.title=k.document.body.innerText="downloading..."}if(typeof h==="string"){return b(h,j,g)}var l=h.type==="application/octet-stream";var o=/constructor/i.test(f.HTMLElement)||f.safari;var p=/CriOS\/[\d]+/.test(navigator.userAgent);if((p||(l&&o))&&typeof FileReader==="object"){var m=new FileReader();m.onloadend=function(){var q=m.result;q=p?q:q.replace(/^data:[^;]*;/,"data:attachment/file;");if(k){k.location.href=q}else{location=q}k=null};m.readAsDataURL(h)}else{var n=f.URL||f.webkitURL;var i=n.createObjectURL(h);if(k){k.location=i}else{location.href=i}k=null;setTimeout(function(){n.revokeObjectURL(i)},40000)}};this.saveAs=a};CanvasXpress.prototype.initConfig=function(){this.setConfigDefaults=function(){var a=CanvasXpress.config;this.graphType="Bar";a.push("graphType");this.graphOrientation="horizontal";a.push("graphOrientation");this.transparency=null;a.push("transparency");this.transparencyHidden=0.1;a.push("transparencyHidden");this.canvasBox=false;a.push("canvasBox");this.canvasBoxColor="rgb(204,204,204)";a.push("canvasBoxColor");this.plotBox=false;a.push("plotBox");this.plotBoxColor="rgb(204,204,204)";a.push("plotBoxColor");this.invertGraph=false;a.push("invertGraph");this.view="canvas";a.push("view");this.isR=false;a.push("isR");this.isReproducibleResearch=true;a.push("isReproducibleResearch");this.reproduceTime=500;a.push("reproduceTime");this.printType="download";a.push("printType");this.printMagnification=1;a.push("printMagnification");this.printThumbnail=false;a.push("printThumbnail");this.cacheBase64=false;a.push("cacheBase64");this.editable=true;a.push("editable");this.highlightGreyOut=false;a.push("highlightGreyOut");this.highlightGreyOutTransparency=0.67;a.push("highlightGreyOutTransparency");this.theme="none";a.push("theme");this.useRawLines=false;a.push("useRawLines");this.fullTextMeasureCheck=500;a.push("fullTextMeasureCheck");this.showFunctionNamesAfterRender=false;a.push("showFunctionNamesAfterRender");this.saveFilename=false;a.push("saveFilename");this.skipRender=false;a.push("skipRender");this.tags=[];a.push("tags");this.createVersion=false;a.push("createVersion");this.createFactory=false;a.push("createFactory");this.metaData={};a.push("metaData");this.functions=[];this.effect="none";a.push("effect");this.codeEffectIn="swashIn";a.push("codeEffectIn");this.codeEffectOut="holeOut";a.push("codeEffectOut");this.configuratorEffectIn="swashIn";a.push("configuratorEffectIn");this.configuratorEffectOut="holeOut";a.push("configuratorEffectOut");this.dataexplorerEffectIn="holeOut";a.push("dataexplorerEffectIn");this.dataexplorerEffectOut="holeOut";a.push("dataexplorerEffectOut");this.datafilterEffectIn="holeOut";a.push("datafilterEffectIn");this.datafilterEffectOut="holeOut";a.push("datafilterEffectOut");this.datatableEffectIn="holeOut";a.push("datatableEffectIn");this.datatableEffectOut="holeOut";a.push("datatableEffectOut");this.motionEffectIn="swashIn";a.push("motionEffectIn");this.motionEffectOut="holeOut";a.push("motionEffectOut");this.remoteEffectIn="holeIn";a.push("remoteEffectIn");this.remoteEffectOut="holeOut";a.push("remoteEffectOut");this.toolbarEffectIn="holeIn";a.push("toolbarEffectIn");this.toolbarEffectOut="holeOut";a.push("toolbarEffectOut");this.tooltipDivEffectIn="holeOut";a.push("tooltipDivEffectIn");this.tooltipDivEffectOut="spaceInUp";a.push("tooltipDivEffectOut");this.gradient=false;a.push("gradient");this.gradientType="radial";a.push("gradientType");this.gradientOrientation="vertical";a.push("gradientOrientation");this.gradientRatio=1.3;a.push("gradientRatio");this.adjustAspectRatio=true;a.push("adjustAspectRatio");this.percentAspectRatioPlotArea=0.5;a.push("percentAspectRatioPlotArea");this.fixedAspectRatio=0;a.push("fixedAspectRatio");this.variableSpaceFactor=2;a.push("variableSpaceFactor");this.sampleSpaceFactor=1;a.push("sampleSpaceFactor");this.widthFactor=1;a.push("widthFactor");this.dataPointSize=20;a.push("dataPointSize");this.dataPointSizeScaleFactor=1;a.push("dataPointSizeScaleFactor");this.adjustAspectRatioMax=3;this.adjustAspectRatioYTries=0;this.adjustAspectRatioXTries=0;this.foreground="rgb(0,0,0)";a.push("foreground");this.background="rgb(255,255,255)";a.push("background");this.backgroundWindow="rgb(244,244,244)";a.push("backgroundWindow");this.backgroundType="solid";a.push("backgroundType");this.backgroundImage=false;a.push("backgroundImage");this.margin=5;a.push("margin");this.marginLeft=5;a.push("marginLeft");this.marginTop=5;a.push("marginTop");this.marginBottom=5;a.push("marginBottom");this.marginRight=5;a.push("marginRight");this.showShadow=false;a.push("showShadow");this.showTextShadow=false;a.push("showTextShadow");this.shadowOffsetX=1;a.push("shadowOffsetX");this.shadowOffsetY=1;a.push("shadowOffsetY");this.shadowBlur=2;a.push("shadowBlur");this.shadowColor="rgba(0,0,0,0.5)";a.push("shadowColor");this.topoJSON=false;a.push("topoJSON");this.mapId=false;a.push("mapId");this.mapPropertyId=false;a.push("mapPropertyId");this.mapProjection="mercator";a.push("mapProjection");this.mapLatitudeOrigin=23;a.push("mapLatitudeOrigin");this.mapCentralMeridian=-96;a.push("mapCentralMeridian");this.mapStandardParallel1=29.5;a.push("mapStandardParallel1");this.mapStandardParallel2=45.5;a.push("mapStandardParallel2");this.mapGraticuleShow=false;a.push("mapGraticuleShow");this.mapGraticuleType="solid";a.push("mapGraticuleType");this.mapConfig=false;a.push("mapConfig");this.mapConfigFeatures=false;a.push("mapConfigFeatures");this.mapSmps=[];a.push("mapSmps");this.hiddenMapFeatures=[];a.push("hiddenMapFeatures");this.visibleMapFeatures=[];a.push("visibleMapFeatures");this.mapColor="rgb(105,210,230)";a.push("mapColor");this.mapOutlineColor="rgb(204,204,204)";a.push("mapOutlineColor");this.fonts=[];a.push("fonts");this.fontsExternal=[];a.push("fontsExternal");this.fontName="Arial";a.push("fontName");this.fontStyle="";a.push("fontStyle");this.fontSize=12;a.push("fontSize");this.fontScaleFontFactor=1;a.push("fontScaleFontFactor");this.align="center";a.push("align");this.baseline="middle";a.push("baseline");this.maxTextSize=40;a.push("maxTextSize");this.minTextSize=4;a.push("minTextSize");this.autoScaleFont=true;a.push("autoScaleFont");this.scaleTextConstantMult=30;this.scaleTextConstantAdd=2;this.title=false;a.push("title");this.titleAlign="center";a.push("titleAlign");this.titleFontSize=16;a.push("titleFontSize");this.titleColor="rgb(0,0,0)";a.push("titleColor");this.titleColorBackground=false;a.push("titleColorBackground");this.titleScaleFontFactor=1;a.push("titleScaleFontFactor");this.titleFontStyle="";a.push("titleFontStyle");this.subtitle=false;a.push("subtitle");this.subtitleAlign="center";a.push("subtitleAlign");this.subtitleFontSize=14;a.push("subtitleFontSize");this.subtitleColor="rgb(0,0,0)";a.push("subtitleColor");this.subtitleScaleFontFactor=1;a.push("subtitleScaleFontFactor");this.subtitleFontStyle="";a.push("subtitleFontStyle");this.citation=false;a.push("citation");this.citationColor="rgb(0,0,0)";a.push("citationColor");this.citationFontStyle="";a.push("citationFontStyle");this.citationFontSize=7;a.push("citationFontSize");this.citationScaleFontFactor=1;a.push("citationScaleFontFactor");this.dashLength=8;a.push("dashLength");this.dotLength=1;a.push("dotLength");this.arrowPointSize=9;a.push("arrowPointSize");this.arrowQuadraticFactor=2.3;a.push("arrowQuadraticFactor");this.capType="butt";a.push("capType");this.joinType="mitter";a.push("joinType");this.lineWidthEvent=2;this.outlineWidth=1;a.push("outlineWidth");this.lineThickness=1;a.push("lineThickness");this.adjustBezier=false;a.push("adjustBezier");this.lines=["line","solid","straight","bezier","curved","curvedCC","dashedLine","dashedBezier","dashedCurved","dashedCurvedCC","dottedLine","dottedBezier","dottedCurved","dottedCurvedCC","blank","dashed","dotted","dotdash","longdash","twodash"];this.arrows=["arrow","square","round"];this.colorScheme="User";a.push("colorScheme");this.colors=["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"];a.push("colors");this.colorHSV=[0,0,1];this.colorRGB=[1,1,1];this.colorSpectrum=["#4575b4","#91bfdb","#e0f3f8","#ffffbf","#fee090","#fc8d59","#d73027"];a.push("colorSpectrum");this.colorSpectrumBreaks=[];a.push("colorSpectrumBreaks");this.colorSpectrumZeroValue=null;a.push("colorSpectrumZeroValue");this.colorSpectrumNumber=100;a.push("colorSpectrumNumber");this.colorSpectrumTarget=10;a.push("colorSpectrumTarget");this.oddColor=this.background;a.push("oddColor");this.evenColor="rgb(245,245,245)";a.push("evenColor");this.blindnessType=false;a.push("blindnessType");this.roundedPolygonRadius=5;a.push("roundedPolygonRadius");this.useRoundRectangles=false;a.push("useRoundRectangles");this.useOpenShapes=false;a.push("useOpenShapes");this.shapes=["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","pentagon","rect3","arc","rectangle"];a.push("shapes");this.sizes=[8,12,16,20,24,28,32,36,40,44,48];a.push("sizes");this.images=[];a.push("images");this.patterns=["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","minus","bars","squiglesVertical","squiglesHorizontal","brickForward","brickReverse","art","pcx","hatchForward3","hatchReverse3"];a.push("patterns");this.linePatterns=["solid","dotted","dashed","dotdash","longdash","twodash"];a.push("linePatterns");this.maxSmpStringLen=25;a.push("maxSmpStringLen");this.smpTitle=false;a.push("smpTitle");this.smpTitleFontStyle="";a.push("smpTitleFontStyle");this.smpTitleFontSize=12;a.push("smpTitleFontSize");this.smpTitleFontColor=this.foreground;a.push("smpTitleFontColor");this.smpTitleScaleFontFactor=1;a.push("smpTitleScaleFontFactor");this.smpLabelFontStyle="";a.push("smpLabelFontStyle");this.smpLabelFontSize=12;a.push("smpLabelFontSize");this.smpLabelFontColor=this.foreground;a.push("smpLabelFontColor");this.smpLabelScaleFontFactor=1;a.push("smpLabelScaleFontFactor");this.smpLabelRotate=0;a.push("smpLabelRotate");this.smpLabelInterval=1;a.push("smpLabelInterval");this.smpLabelImage=false;a.push("smpLabelImage");this.smpLabelImageRound=false;a.push("smpLabelImageRound");this.showSampleNames=true;a.push("showSampleNames");this.highlightSmp=[];a.push("highlightSmp");this.smpHighlightColor="rgb(255,0,0)";a.push("smpHighlightColor");this.maxVarStringLen=25;a.push("maxVarStringLen");this.varTitle=false;a.push("varTitle");this.varTitleFontStyle="";a.push("varTitleFontStyle");this.varTitleFontSize=12;a.push("varTitleFontSize");this.varTitleFontColor=this.foreground;a.push("varTitleFontColor");this.varTitleScaleFontFactor=1;a.push("varTitleScaleFontFactor");this.varLabelFontStyle="";a.push("varLabelFontStyle");this.varLabelFontSize=12;a.push("varLabelFontSize");this.varLabelFontColor=this.foreground;a.push("varLabelFontColor");this.varLabelScaleFontFactor=1;a.push("varLabelScaleFontFactor");this.varLabelRotate=0;a.push("varLabelRotate");this.varLabelInterval=1;a.push("varLabelInterval");this.showVariableNames=true;a.push("showVariableNames");this.highlightVar=[];a.push("highlightVar");this.varHighlightColor="rgb(255,0,0)";a.push("varHighlightColor");this.binConfigurations={};a.push("binConfigurations");this.maxOverlayStringLen=30;a.push("maxOverlayStringLen");this.overlaysThickness=18;a.push("overlaysThickness");this.smpOverlays=[];a.push("smpOverlays");this.smpOverlayProperties={};a.push("smpOverlayProperties");this.smpOverlaysLegendColumns=1;a.push("smpOverlaysLegendColumns");this.showSmpOverlaysLegend=false;a.push("showSmpOverlaysLegend");this.varOverlays=[];a.push("varOverlays");this.varOverlayProperties={};a.push("varOverlayProperties");this.varOverlaysLegendColumns=1;a.push("varOverlaysLegendColumns");this.showVarOverlaysLegend=false;a.push("showVarOverlaysLegend");this.overlaysLegendPosition="topRight";a.push("overlaysLegendPosition");this.showOverlays=true;a.push("showOverlays");this.showLevelOverlays=true;a.push("showLevelOverlays");this.overlayFontStyle="";a.push("overlayFontStyle");this.overlayFontSize=12;a.push("overlayFontSize");this.overlayFontColor=this.foreground;a.push("overlayFontColor");this.overlayScaleFontFactor=1;a.push("overlayScaleFontFactor");this.showLegend=true;a.push("showLegend");this.showLegendTitle=true;a.push("showLegendTitle");this.legendColumns=1;a.push("legendColumns");this.legendPosition="right";a.push("legendPosition");this.legendPositionAuto=false;a.push("legendPositionAuto");this.legendInside=false;a.push("legendInside");this.legendColor=this.foreground;a.push("legendColor");this.legendBox=false;a.push("legendBox");this.legendBoxColor="rgb(204,204,204)";a.push("legendBoxColor");this.legendBackgroundColor="rgba(255,255,255,0)";a.push("legendBackgroundColor");this.legendFontStyle="";a.push("legendFontStyle");this.legendFontSize=12;a.push("legendFontSize");this.legendScaleFontFactor=1;a.push("legendScaleFontFactor");this.legendOrder=false;a.push("legendOrder");this.legend=[];a.push("legend");this.showDecorations=true;a.push("showDecorations");this.showDecorationsLegend=true;a.push("showDecorationsLegend");this.decorationsPosition="bottom";a.push("decorationsPosition");this.decorationsColor=this.foreground;a.push("decorationsColor");this.decorationsBox=false;a.push("decorationsBox");this.decorationsBoxColor="rgb(204,204,204)";a.push("decorationsBoxColor");this.decorationsBackgroundColor="rgba(255,255,255,0)";a.push("decorationsBackgroundColor");this.decorationFontStyle="";a.push("decorationFontStyle");this.decorationFontSize=12;a.push("decorationFontSize");this.decorationScaleFontFactor=1;a.push("decorationScaleFontFactor");this.decorationsWidth=20;a.push("decorationsWidth");this.decorationsHeight=40;a.push("decorationsHeight");this.decorationsType="bar";a.push("decorationsType");this.decorations=false;a.push("decorations");this.decorationsColors=[];a.push("decorationsColors");this.decorationsProperties={};a.push("decorationsProperties");this.isGroupedData=false;this.isBoxplotCalc=false;this.groupingFactors=[];a.push("groupingFactors");this.segregateSamplesBy=[];a.push("segregateSamplesBy");this.segregateVariablesBy=[];a.push("segregateVariablesBy");this.summaryType=false;a.push("summaryType");this.isTransformedData=false;this.transformBase=10;this.transformData=false;a.push("transformData");this.transformAxis="samples";a.push("transformAxis");this.ratioReference=0;a.push("ratioReference");this.ratioSampleReference=false;a.push("ratioSampleReference");this.ratioGroupReference=false;a.push("ratioGroupReference");this.ratioLevelReference="";a.push("ratioLevelReference");this.transposeData=false;a.push("transposeData");this.asSampleFactors=[];a.push("asSampleFactors");this.asVariableFactors=[];a.push("asVariableFactors");this.stringSampleFactors=[];a.push("stringSampleFactors");this.stringVariableFactors=[];a.push("stringVariableFactors");this.histogramData=false;a.push("histogramData");this.appendNetworkData=[];a.push("appendNetworkData");this.timeFormat="isoDate";a.push("timeFormat");this.isGraphTime=false;a.push("isGraphTime");this.timeValues=[];this.timeValueIndices=[];this.timeValueProperties={};this.sortDir="ascending";a.push("sortDir");this.sortCaseSensitive=false;a.push("sortCaseSensitive");this.sortData=[];a.push("sortData");this.sortOnGrouping=false;a.push("sortOnGrouping");this.missingDataColor="rgb(245,245,245)";a.push("missingDataColor");this.missingDataValue="NA";a.push("missingDataValue");this.showErrorBars=true;a.push("showErrorBars");this.errorBarsType="confidenceInterval95";a.push("errorBarsType");this.errorBarsColor="rgb(0,0,0)";a.push("errorBarsColor");this.errorBarsThickness=3;a.push("errorBarsThickness");this.errorBarsWidth=2;a.push("errorBarsWidth");this.standardDeviationType="unbiased";a.push("standardDeviationType");this.showRegressionFullRange=false;a.push("showRegressionFullRange");this.regressionType="linear";a.push("regressionType");this.regressionOrder=2;a.push("regressionOrder");this.showConfidenceIntervals=true;a.push("showConfidenceIntervals");this.confidenceLevel=0.95;a.push("confidenceLevel");this.confidenceIntervalType="log";a.push("confidenceIntervalType");this.confidenceIntervalColor="rgb(50,50,50)";a.push("confidenceIntervalColor");this.invertCensored=false;a.push("invertCensored");this.kaplanMeierBy=false;a.push("kaplanMeierBy");this.fitLineColor="rgb(255,215,0)";a.push("fitLineColor");this.fitLineStyle="solid";a.push("fitLineStyle");this.randomSeed=8;a.push("randomSeed");this.pseudoRandom=true;a.push("pseudoRandom");this.randomMethod="numericalRecipes";a.push("randomMethod");this.randomData=false;this.randomDataDistribution="biased";a.push("randomDataDistribution");this.randomDataTime=false;a.push("randomDataTime");this.randomDataMin=1;a.push("randomDataMin");this.randomDataMax=100;a.push("randomDataMax");this.randomDataMean=0;a.push("randomDataMean");this.randomDataSigma=1;a.push("randomDataSigma");this.randomDataVariables=3;a.push("randomDataVariables");this.randomDataSamples=36;a.push("randomDataSamples");this.randomDataVariableAnnotations=2;a.push("randomDataVariableAnnotations");this.randomDataSampleAnnotations=2;a.push("randomDataSampleAnnotations");this.randomMissingDataPercentage=0;a.push("randomMissingDataPercentage");this.randomNetworkReduce=true;a.push("randomNetworkReduce");this.randomNetworkNodes=40;a.push("randomNetworkNodes");this.randomNetworkNodeEdgesMax=5;a.push("randomNetworkNodeEdgesMax");this.randomNetworkAll=true;a.push("randomNetworkAll");this.randomNetworkLayout="forceLayout";a.push("randomNetworkLayout");this.zoom=1;a.push("zoom");this.zoomGlobal=1;this.zoomStep=0.2;a.push("zoomStep");this.zoomScale=true;a.push("zoomScale");this.zoomVariablesDisable=false;a.push("zoomVariablesDisable");this.zoomSamplesDisable=false;a.push("zoomSamplesDisable");this.zoomDisable=false;a.push("zoomDisable");this.panningX=0;a.push("panningX");this.panningY=0;a.push("panningY");this.panningGlobalX=0;this.panningGlobalY=0;this.panningStep=0.2;a.push("panningStep");this.resizerBackgroundColor=CanvasXpress.system.isIE?"rgb(204,204,204)":"rgba(204,204,204,0.7)";a.push("resizerBackgroundColor");this.xAxisAbsMax=null;this.xAxisAbsMin=null;this.xAxisMaxStrLength=false;this.setMaxX=null;a.push("setMaxX");this.setMinX=null;a.push("setMinX");this.xAxisCurrent=0;a.push("xAxisCurrent");this.xAxisTitle=false;a.push("xAxisTitle");this.xAxisTitleDynamic=false;a.push("xAxisTitleDynamic");this.xAxis=[];a.push("xAxis");this.xAxisTickStyle="solid";a.push("xAxisTickStyle");this.xAxisTickFormat=false;a.push("xAxisTickFormat");this.xAxisTickColor="rgb(204,204,204)";a.push("xAxisTickColor");this.xAxisExact=false;a.push("xAxisExact");this.xAxisValues=[];this.xAxisValuesRaw=[];this.xAxisMinorValues=[];this.xAxisTransform=false;a.push("xAxisTransform");this.xAxisCeilValue=null;a.push("xAxisCeilValue");this.xAxisFloorValue=null;a.push("xAxisFloorValue");this.xAxisTransformTicks=true;a.push("xAxisTransformTicks");this.xAxisShow=true;a.push("xAxisShow");this.xAxisS2Show=false;a.push("xAxisS2Show");this.xAxisTicks=5;a.push("xAxisTicks");this.xAxisMinorTicks=true;a.push("xAxisMinorTicks");this.xAxisMajorTicks=true;a.push("xAxisMajorTicks");this.xAxisLeftMajorTick=true;a.push("xAxisLeftMajorTick");this.xAxisRightMajorTick=true;a.push("xAxisRightMajorTick");this.xAxisLeftRightTickColor="rgb(204,204,204)";a.push("xAxisLeftRightTickColor");this.xAxisHistogramShow=false;a.push("xAxisHistogramShow");this.xAxisHistogramHeight=80;a.push("xAxisHistogramHeight");this.xAxisRugShow=false;a.push("xAxisRugShow");this.xAxisRugHeight=15;a.push("xAxisRugHeight");this.xAxisRugPosition="bottom";a.push("xAxisRugPosition");this.xAxis2AbsMax=null;this.xAxis2AbsMin=null;this.xAxis2MaxStrLength=false;this.setMaxX2=null;a.push("setMaxX2");this.setMinX2=null;a.push("setMinX2");this.xAxis2Title=false;a.push("xAxis2Title");this.xAxis2=[];a.push("xAxis2");this.xAxis2TickFormat=false;a.push("xAxis2TickFormat");this.xAxis2Values=[];this.xAxis2ValuesRaw=[];this.xAxis2MinorValues=[];this.xAxis2Show=true;a.push("xAxis2Show");this.xAxis2Ticks=null;this.yAxisAbsMax=null;this.yAxisAbsMin=null;this.yAxisMaxStrLength=false;this.setMaxY=null;a.push("setMaxY");this.setMinY=null;a.push("setMinY");this.yAxisCurrent=0;a.push("yAxisCurrent");this.yAxisTitle=false;a.push("yAxisTitle");this.yAxisTitleDynamic=false;a.push("yAxisTitleDynamic");this.yAxis2Title=false;a.push("yAxis2Title");this.yAxis=[];a.push("yAxis");this.yAxisTickStyle="solid";a.push("yAxisTickStyle");this.yAxisTickFormat=false;a.push("yAxisTickFormat");this.yAxisTickColor="rgb(204,204,204)";a.push("yAxisTickColor");this.yAxisExact=false;a.push("yAxisExact");this.yAxisValues=[];this.yAxisValuesRaw=[];this.yAxisMinorValues=[];this.yAxisTransform=false;a.push("yAxisTransform");this.yAxisCeilValue=null;a.push("yAxisCeilValue");this.yAxisFloorValue=null;a.push("yAxisFloorValue");this.yAxisTransformTicks=true;a.push("yAxisTransformTicks");this.yAxisShow=true;a.push("yAxisShow");this.yAxis2Show=false;a.push("yAxis2Show");this.yAxisTicks=5;a.push("yAxisTicks");this.yAxisMinorTicks=true;a.push("yAxisMinorTicks");this.yAxisMajorTicks=true;a.push("yAxisMajorTicks");this.yAxisTopMajorTick=true;a.push("yAxisTopMajorTick");this.yAxisBottomMajorTick=true;a.push("yAxisBottomMajorTick");this.yAxisTopBottomTickColor="rgb(204,204,204)";a.push("yAxisTopBottomTickColor");this.yAxisHistogramShow=false;a.push("yAxisHistogramShow");this.yAxisHistogramHeight=80;a.push("yAxisHistogramHeight");this.yAxisRugShow=false;a.push("yAxisRugShow");this.yAxisRugHeight=15;a.push("yAxisRugHeight");this.yAxisRugPosition="left";a.push("yAxisRugPosition");this.zAxisAbsMax=null;this.zAxisAbsMin=null;this.zAxisMaxStrLength=false;this.setMaxZ=null;a.push("setMaxZ");this.setMinZ=null;a.push("setMinZ");this.zAxisCurrent=0;a.push("zAxisCurrent");this.zAxisTitle=false;a.push("zAxisTitle");this.zAxisTitleDynamic=false;a.push("zAxisTitleDynamic");this.zAxis=[];a.push("zAxis");this.zAxisTickStyle="solid";a.push("zAxisTickStyle");this.zAxisTickFormat=false;a.push("zAxisTickFormat");this.zAxisTickColor="rgb(204,204,204)";a.push("zAxisTickColor");this.zAxisExact=false;a.push("zAxisExact");this.zAxisValues=[];this.zAxisValuesRaw=[];this.zAxisMinorValues=[];this.zAxisTransform=false;a.push("zAxisTransform");this.zAxisCeilValue=null;a.push("zAxisCeilValue");this.zAxisFloorValue=null;a.push("zAxisFloorValue");this.zAxisTransformTicks=true;a.push("zAxisTransformTicks");this.zAxisShow=true;a.push("zAxisShow");this.zAxisTicks=10;this.rAxisAbsMax=null;this.rAxisAbsMin=null;this.rAxisMaxStrLength=false;this.rAxisTickFormat=false;a.push("rAxisTickFormat");this.rAxisTickColor=this.foreground;a.push("rAxisTickColor");this.rAxisValues=[];a.push("rAxisValues");this.rAxisValuesRaw=[];this.rAxisMinorValues=[];a.push("rAxisMinorValues");this.rAxisPercentShow=true;a.push("rAxisPercentShow");this.rAxisShow=true;a.push("rAxisShow");this.rAxisLabelOrientation="perpendicular";a.push("rAxisLabelOrientation");this.rAxisTicks=5;a.push("rAxisTicks");this.rAxisMinorTicks=true;a.push("rAxisMinorTicks");this.rAxisMajorTicks=true;a.push("rAxisMajorTicks");this.axisTickColor=this.foreground;a.push("axisTickColor");this.axisTickThickness=1;a.push("axisTickThickness");this.axisMinMaxTickThickness=1;a.push("axisMinMaxTickThickness");this.axisTickFontStyle="";a.push("axisTickFontStyle");this.axisTickFontSize=12;a.push("axisTickFontSize");this.axisTickScaleFontFactor=1;a.push("axisTickScaleFontFactor");this.axisTitleColor=this.foreground;a.push("axisTitleColor");this.axisTitleFontStyle="";a.push("axisTitleFontStyle");this.axisTitleFontSize=12;a.push("axisTitleFontSize");this.axisTitleScaleFontFactor=1;a.push("axisTitleScaleFontFactor");this.axisExtension=0.1;a.push("axisExtension");this.axisAlgorithm="wilkinson";a.push("axisAlgorithm");this.axisWilkinsonLoose=false;a.push("axisWilkinsonLoose");this.axisCoordinate=false;a.push("axisCoordinate");this.setMax=null;this.setMin=null;this.guides=false;a.push("guides");this.guidesWidth=1;a.push("guidesWidth");this.guidesColor="rgb(204,204,204)";a.push("guidesColor");this.blockContrast=false;a.push("blockContrast");this.plotByVariable=false;a.push("plotByVariable");this.is3DPlot=false;a.push("is3DPlot");this.showDataValues=false;a.push("showDataValues");this.binned=false;a.push("binned");this.binAlignment="center";a.push("binAlignment");this.jitter=true;a.push("jitter");this.jitterColumns=7;a.push("jitterColumns");this.objectBorderColor="rgb(0,0,0)";a.push("objectBorderColor");this.objectColorTransparency=1;a.push("objectColorTransparency");this.dotplotOutlineThreshold=500;a.push("dotplotOutlineThreshold");this.lineDecoration="symbol";a.push("lineDecoration");this.lineErrorType="bar";a.push("lineErrorType");this.coordinateLineColor=false;a.push("coordinateLineColor");this.lineType="rect";a.push("lineType");this.tension=0.3;a.push("tension");this.tensionSegments=16;a.push("tensionSegments");this.parallelCoordinates=[];this.boxplotOutliersRatio=8;a.push("boxplotOutliersRatio");this.boxplotWhiskersType="double";a.push("boxplotWhiskersType");this.boxplotType="boxWhiskers";a.push("boxplotType");this.boxplotNotched=false;a.push("boxplotNotched");this.boxplotTransparency=0.5;a.push("boxplotTransparency");this.boxplotColor=false;a.push("boxplotColor");this.boxplotCoef=1.5;a.push("boxplotCoef");this.boxplotHingeFunction="summary";a.push("boxplotHingeFunction");this.showBoxplotOriginalData=false;a.push("showBoxplotOriginalData");this.showViolinBoxplot=false;a.push("showViolinBoxplot");this.violinTrim=true;a.push("violinTrim");this.violinScale="area";a.push("violinScale");this.showBoxplotIfViolin=true;a.push("showBoxplotIfViolin");this.boxplotWidthRatioIfViolin=0.33;a.push("boxplotWidthRatioIfViolin");this.violinTransparency=0.5;a.push("violinTransparency");this.violinColor=false;a.push("violinColor");this.violinBorderColor="rgb(0,0,0)";a.push("violinBorderColor");this.boxplotDataPointTransparency=0.5;a.push("boxplotDataPointTransparency");this.boxplotMedianColor="rgb(0,0,0)";a.push("boxplotMedianColor");this.boxplotMedianWidth=1;a.push("boxplotMedianWidth");this.boxplotMean=false;a.push("boxplotMean");this.boxplotMeanColor="rgb(255,215,0)";a.push("boxplotMeanColor");this.boxplotMeanColorBorder="rgb(255,0,0)";a.push("boxplotMeanColorBorder");this.boxplotConnect=false;a.push("boxplotConnect");this.boxplotConnectWidth=2;a.push("boxplotConnectWidth");this.areaType="normal";a.push("areaType");this.dotplotType="normal";a.push("dotplotType");this.barType="normal";a.push("barType");this.barPath=false;a.push("barPath");this.barPathTransparency=0.1;a.push("barPathTransparency");this.barPathColor=false;a.push("barPathColor");this.barLollipopFactor=1.5;a.push("barLollipopFactor");this.barLollipopOpen=false;a.push("barLollipopOpen");this.swimHigh=false;a.push("swimHigh");this.swimStart=false;a.push("swimStart");this.swimEnd=false;a.push("swimEnd");this.swimStatus=false;a.push("swimStatus");this.swimHighCap=false;a.push("swimHighCap");this.ganttStart=false;a.push("ganttStart");this.ganttEnd=false;a.push("ganttEnd");this.ganttCompletion=false;a.push("ganttCompletion");this.ganttDependency=false;a.push("ganttDependency");this.ganttDependencyEnd=false;a.push("ganttDependencyEnd");this.ganttDependencyColor=false;a.push("ganttDependencyColor");this.ganttDependencyThickness=false;a.push("ganttDependencyThickness");this.ganttCompletionTransparency=0.5;a.push("ganttCompletionTransparency");this.meterType="gauge";a.push("meterType");this.meterMin=null;a.push("meterMin");this.meterMax=null;a.push("meterMax");this.meterStart=270;a.push("meterStart");this.meterEnd=90;a.push("meterEnd");this.meterSegments=[];a.push("meterSegments");this.meterColors=[];a.push("meterColors");this.meterVar=false;a.push("meterVar");this.meterIndex=0;this.meterNeedleColor="rgb(0,0,0)";a.push("meterNeedleColor");this.meterBackgroundColor="rgb(229,229,229)";a.push("meterBackgroundColor");this.meterThickness=50;a.push("meterThickness");this.fishParents=[];a.push("fishParents");this.fishTimepoints=[];a.push("fishTimepoints");this.fishSeparateIndependentClones=false;a.push("fishSeparateIndependentClones");this.fishShape="polygon";a.push("fishShape");this.fishAxis=[];a.push("fishAxis");this.fishAxisLabels=[];a.push("fishAxisLabels");this.fishCloneLabels=[];a.push("fishCloneLabels");this.sankeyNodeWidth=20;a.push("sankeyNodeWidth");this.sankeyIterations=32;this.sankeySource=false;a.push("sankeySource");this.sankeyTarget=false;a.push("sankeyTarget");this.sankeyColor="rgba(150,150,150,0.5)";a.push("sankeyColor");this.sankeyCoordinateColor=false;a.push("sankeyCoordinateColor");this.hierarchy=[];a.push("hierarchy");this.hierarchyVar=false;a.push("hierarchyVar");this.hierarchyVarIndex=0;this.treeNodeSize=5;this.treeLinkColor="rgb(150,150,150)";a.push("treeLinkColor");this.treeNodeOutlineColor="rgb(51,122,183)";a.push("treeNodeOutlineColor");this.treeLinkWidth=1;a.push("treeLinkWidth");this.treeCircular=false;a.push("treeCircular");this.treeInverted=false;a.push("treeInverted");this.treeVarIndex=0;a.push("treeVarIndex");this.treeNodeId=0;this.colorBy=false;a.push("colorBy");this.colorByShowLegend=true;a.push("colorByShowLegend");this.colorKey=false;a.push("colorKey");this.shapeBy=false;a.push("shapeBy");this.shapeByContinuous=false;a.push("shapeByContinuous");this.shapeByShowLegend=true;a.push("shapeByShowLegend");this.shapeKey=false;a.push("shapeKey");this.shapeByData=false;a.push("shapeByData");this.shapeByShape=false;a.push("shapeByShape");this.sizeBy=false;a.push("sizeBy");this.sizeByContinuous=false;a.push("sizeByContinuous");this.sizeByShowLegend=true;a.push("sizeByShowLegend");this.sizeKey=false;a.push("sizeKey");this.sizeByData=false;a.push("sizeByData");this.outlineBy=false;a.push("outlineBy");this.outlineByShowLegend=true;a.push("outlineByShowLegend");this.outlineByData=false;a.push("outlineByData");this.patternBy=false;a.push("patternBy");this.patternByShowLegend=true;a.push("patternByShowLegend");this.patternKey=false;a.push("patternKey");this.patternByData=false;a.push("patternByData");this.connectBy=false;a.push("connectBy");this.connectByNoColor=false;a.push("connectByNoColor");this.connectByColor="rgb(204,204,204)";a.push("connectByColor");this.connectByWidth=2;a.push("connectByWidth");this.connectByShowLegend=true;a.push("connectByShowLegend");this.connectKey=false;a.push("connectKey");this.connectByData={};this.treemapBy=[];a.push("treemapBy");this.stackBy=false;a.push("stackBy");this.lineBy=false;a.push("lineBy");this.motionBy=false;a.push("motionBy");this.markerBy=false;a.push("markerBy");this.ellipseBy=false;a.push("ellipseBy");this.ridgeBy=false;a.push("ridgeBy");this.motionWidth=250;a.push("motionWidth");this.motionCurrentColor="rgba(0,0,0,0.3)";a.push("motionCurrentColor");this.motionCurrentFontStyle="";a.push("motionCurrentFontStyle");this.motionCurrentFontSize=60;a.push("motionCurrentFontSize");this.motionCurrentScaleFontFactor=1;a.push("motionCurrentScaleFontFactor");this.scatterType=false;a.push("scatterType");this.visiumFlip=false;a.push("visiumFlip");this.visiumPanning=false;a.push("visiumPanning");this.visiumFixedAspectRatio=true;a.push("visiumFixedAspectRatio");this.scatterAxesEqual=false;a.push("scatterAxesEqual");this.scatterOutlineThreshold=50000;a.push("scatterOutlineThreshold");this.chromosomeLengths=[];a.push("chromosomeLengths");this.manhattanMarkerChromosomeNumber=false;a.push("manhattanMarkerChromosomeNumber");this.manhattanMarkerPosition=false;a.push("manhattanMarkerPosition");this.manhattanMarkerLogPValue=false;a.push("manhattanMarkerLogPValue");this.manhattanColors=["rgb(128,128,128)","rgb(135,206,235)"];a.push("manhattanColors");this.manhattanContrastColor="rgba(0,0,0,0.1)";a.push("manhattanContrastColor");this.selectionMode="highlight";a.push("selectionMode");this.selectionColor="rgb(255,0,0)";a.push("selectionColor");this.selectionMetadata=false;a.push("selectionMetadata");this.selectedDataPoints=[];a.push("selectedDataPoints");this.contourFilled=false;a.push("contourFilled");this.contourFilledTransparency=1;a.push("contourFilledTransparency");this.showContourBands=true;a.push("showContourBands");this.contourBandsColor="rgb(0,0,255)";a.push("contourBandsColor");this.contourLevelWidth=null;a.push("contourLevelWidth");this.contourLevelNumber=10;a.push("contourLevelNumber");this.contourLevels=[];a.push("contourLevels");this.showContourLevel=false;a.push("showContourLevel");this.showContourDataPoints=false;a.push("showContourDataPoints");this.contourDataPointsColor="rgb(0,0,0)";a.push("contourDataPointsColor");this.contourColorScheme="Viridis";a.push("contourColorScheme");this.isHistogram=false;a.push("isHistogram");this.histogramBarWidth=false;this.histogramBins=false;a.push("histogramBins");this.histogramBinWidth=false;a.push("histogramBinWidth");this.histogramType="dodged";a.push("histogramType");this.showHistogramDensity=false;a.push("showHistogramDensity");this.showFilledHistogramDensity=false;a.push("showFilledHistogramDensity");this.histogramDensityFillTransparency=0.6;a.push("histogramDensityFillTransparency");this.showHistogramDataPoints=false;a.push("showHistogramDataPoints");this.showHistogramQuantiles=false;a.push("showHistogramQuantiles");this.showHistogramMedian=false;a.push("showHistogramMedian");this.histogramMedianLineStyle="dashed";a.push("histogramMedianLineStyle");this.hideHistogram=false;a.push("hideHistogram");this.histogramSizeEstimator="sturges";a.push("histogramSizeEstimator");this.histogramStat="count";a.push("histogramStat");this.isCreateHistogram=false;this.showScatterDensity=false;a.push("showScatterDensity");this.densityPixels=1000;a.push("densityPixels");this.densityKernel="gaussian";a.push("densityKernel");this.densityPosition="normal";a.push("densityPosition");this.bandwidthRule="nrd0";a.push("bandwidthRule");this.bandwidthCut=3;a.push("bandwidthCut");this.bandwidthAdjust=1;a.push("bandwidthAdjust");this.ridgelineScale=1.5;a.push("ridgelineScale");this.loessDegree=2;a.push("loessDegree");this.loessSteps=30;a.push("loessSteps");this.loessSurfaceSteps=30;a.push("loessSurfaceSteps");this.loessBandwidth=0.8;a.push("loessBandwidth");this.loessSpan=0.8;a.push("loessSpan");this.loessIterations=1;this.loessAccuracy=1e-12;this.showLoessFit=false;a.push("showLoessFit");this.qqDistribution="normal";a.push("qqDistribution");this.qqSamples=10000;a.push("qqSamples");this.qqPoints=100;a.push("qqPoints");this.maxDOENumber=8;a.push("maxDOENumber");this.includeDOE=[];a.push("includeDOE");this.autoexpandDOE=true;a.push("autoexpandDOE");this.extendedDOE=true;a.push("extendedDOE");this.asDOE=false;a.push("asDOE");this.scatterPlotMatrix=false;a.push("scatterPlotMatrix");this.scatterPlotMatrixType="both";a.push("scatterPlotMatrixType");this.showScatterPlotMatrixLabels=false;a.push("showScatterPlotMatrixLabels");this.xRotate=45;a.push("xRotate");this.yRotate=0;a.push("yRotate");this.zRotate=0;a.push("zRotate");this.x3DRatio=1;a.push("x3DRatio");this.y3DRatio=1;a.push("y3DRatio");this.z3DRatio=1;a.push("z3DRatio");this.show3DGrid=true;a.push("show3DGrid");this.rotationSensitivity=450;a.push("rotationSensitivity");this.rotationStep=2;a.push("rotationStep");this.perspectiveFactor=2.2;a.push("perspectiveFactor");this.varIndicesStart=-1;this.smpIndicesStart=-1;this.grpIndicesStart=-1;this.isMultidimensionalData=false;this.heatmapAutoAdjust=false;a.push("heatmapAutoAdjust");this.heatmapCellBox=true;a.push("heatmapCellBox");this.heatmapCellBoxColor="rgb(102,102,102)";a.push("heatmapCellBoxColor");this.heatmapCellBoxWidth=1;a.push("heatmapCellBoxWidth");this.heatmapCellBoxColorHighlight="rgb(255,215,0)";a.push("heatmapCellBoxColorHighlight");this.heatmapCellBoxHighlightWidth=1;a.push("heatmapCellBoxHighlightWidth");this.heatmapSmpSeparateBy=false;a.push("heatmapSmpSeparateBy");this.heatmapVarSeparateBy=false;a.push("heatmapVarSeparateBy");this.heatmapSeparatorThickness=3;a.push("heatmapSeparatorThickness");this.varTitleLabelPosition="bottom";a.push("varTitleLabelPosition");this.smpTitleLabelPosition="left";a.push("smpTitleLabelPosition");this.showHeatmapIndicator=true;a.push("showHeatmapIndicator");this.heatmapIndicatorHeight=25;a.push("heatmapIndicatorHeight");this.heatmapIndicatorWidth=250;a.push("heatmapIndicatorWidth");this.adjustAspectRatioHeatmapIndicator=true;a.push("adjustAspectRatioHeatmapIndicator");this.heatmapIndicatorPosition="right";a.push("heatmapIndicatorPosition");this.heatmapIndicatorHistogram=false;a.push("heatmapIndicatorHistogram");this.heatmapIndicatorHistogramColor="rgb(0,255,255)";a.push("heatmapIndicatorHistogramColor");this.heatmapType="normal";a.push("heatmapType");this.heatmapCollapse=false;a.push("heatmapCollapse");this.isOncoprint=false;this.oncoprintCNA=false;a.push("oncoprintCNA");this.oncoprintMUT=false;a.push("oncoprintMUT");this.oncoprintHeatmapSwitch=false;a.push("oncoprintHeatmapSwitch");this.oncoprintNoAlterations=true;a.push("oncoprintNoAlterations");this.oncoprintColSummary=false;a.push("oncoprintColSummary");this.oncoprintRowSummary=false;a.push("oncoprintRowSummary");this.oncoprintHeatmapSwitch=false;a.push("oncoprintHeatmapSwitch");this.showHeatmapOncoprint=false;a.push("showHeatmapOncoprint");this.oncoprintHeatmapPosition="bottom";a.push("oncoprintHeatmapPosition");this.treemapBorderWidth=3;a.push("treemapBorderWidth");this.treemapBorderColor="rgb(204,204,204)";a.push("treemapBorderColor");this.correlationAxis="samples";a.push("correlationAxis");this.correlationAnchorLegend=false;a.push("correlationAnchorLegend");this.correlationAnchorLegendAlignWidth=40;a.push("correlationAnchorLegendAlignWidth");this.correlationLabelInterval=1;a.push("correlationLabelInterval");this.correlationType="diamond";a.push("correlationType");this.showVarDendrogram=true;a.push("showVarDendrogram");this.varDendrogramNewick=false;a.push("varDendrogramNewick");this.varDendrogramPosition="top";a.push("varDendrogramPosition");this.colorVarDendrogramBy=false;a.push("colorVarDendrogramBy");this.showSmpDendrogram=true;a.push("showSmpDendrogram");this.smpDendrogramNewick=false;a.push("smpDendrogramNewick");this.smpDendrogramPosition="left";a.push("smpDendrogramPosition");this.colorSmpDendrogramBy=false;a.push("colorSmpDendrogramBy");this.dendrogramHeight=80;a.push("dendrogramHeight");this.dendrogramColor="rgb(0,0,0)";a.push("dendrogramColor");this.distance="euclidian";a.push("distance");this.linkage="complete";a.push("linkage");this.clusterAxis="samples";this.kmeansVarClusters=3;a.push("kmeansVarClusters");this.kmeansSmpClusters=3;a.push("kmeansSmpClusters");this.maxIterations=500;a.push("maxIterations");this.imputeMethod="mean";a.push("imputeMethod");this.samplesClustered=false;a.push("samplesClustered");this.variablesClustered=false;a.push("variablesClustered");this.samplesKmeaned=false;a.push("samplesKmeaned");this.variablesKmeaned=false;a.push("variablesKmeaned");this.vennLegendColors=false;a.push("vennLegendColors");this.vennGroups=4;a.push("vennGroups");this.vennCompartments=["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"];a.push("vennCompartments");this.vennColors=[];a.push("vennColors");this.pieType="separated";a.push("pieType");this.pieSegmentPrecision=0;a.push("pieSegmentPrecision");this.pieSegmentSeparation=1;a.push("pieSegmentSeparation");this.pieSegmentLabels="inside";a.push("pieSegmentLabels");this.pieLabelType="percentage";a.push("pieLabelType");this.maxPieSectors=20;a.push("maxPieSectors");this.showPieGrid=true;a.push("showPieGrid");this.showPieValues=true;a.push("showPieValues");this.showPieSampleLabel=true;a.push("showPieSampleLabel");this.startPieSectors=270;a.push("startPieSectors");this.pieInnerRadius=0;a.push("pieInnerRadius");this.pieColors=[];a.push("pieColors");this.circularType="normal";a.push("circularType");this.chordThickness=28;a.push("chordThickness");this.chordColor="source";a.push("chordColor");this.bubbleColor="rgba(204,204,204,0.33)";a.push("bubbleColor");this.circularCenterProportion=0.3;a.push("circularCenterProportion");this.arcSegmentsSeparation=8;a.push("arcSegmentsSeparation");this.circularRotate=0;a.push("circularRotate");this.circularArc=360;a.push("circularArc");this.ringSeparation=5;a.push("ringSeparation");this.ringGraphType=[];a.push("ringGraphType");this.ringGraphWeight=[];a.push("ringGraphWeight");this.arcSegmentsRadius=[];a.push("arcSegmentsRadius");this.ringsOrder=[];a.push("ringsOrder");this.rAxis=false;a.push("rAxis");this.rAxisZero=false;a.push("rAxisZero");this.showCircularConnections=true;a.push("showCircularConnections");this.connections=[];a.push("connections");this.circularLetterSeparationFactor=1.5;a.push("circularLetterSeparationFactor");this.circularConnectionsTransparency=0.5;a.push("circularConnectionsTransparency");this.overlayLevelOrientation="circular";a.push("overlayLevelOrientation");this.smpLabelOrientation="perpendicular";a.push("smpLabelOrientation");this.circularLabelsAlign="outside";a.push("circularLabelsAlign");this.circularScalesAlign="inside";a.push("circularScalesAlign");this.circularAnchorsAlign="inside";a.push("circularAnchorsAlign");this.circularAnchors2Align="outside";a.push("circularAnchors2Align");this.circularDataPosition="distributed";a.push("circularDataPosition");this.circularAnchorLength=15;a.push("circularAnchorLength");this.circularAnchorColor="rgb(0,0,255)";a.push("circularAnchorColor");this.showIdeogram=false;a.push("showIdeogram");this.ideogram="hg38";a.push("ideogram");this.ideogramChromosome="chr";a.push("ideogramChromosome");this.ideogramChromosomePosition="pos";a.push("ideogramChromosomePosition");this.tagCloudTextWeightFactor=1;a.push("tagCloudTextWeightFactor");this.tagCloudTextGridSize=8;a.push("tagCloudTextGridSize");this.tagCloudTextEllipticity=0.65;a.push("tagCloudTextEllipticity");this.tagCloudTextRotateRatio=0.1;a.push("tagCloudTextRotateRatio");this.tagCloudShape=false;a.push("tagCloudShape");this.tagCloudMask=false;a.push("tagCloudMask");this.tagCloudGridPoints=[];this.calculateLayout=true;a.push("calculateLayout");this.networkFreeze=false;a.push("networkFreeze");this.networkFreezeOnLoad=false;a.push("networkFreezeOnLoad");this.preScaleNetwork=false;a.push("preScaleNetwork");this.ignoreEventlessOrder=false;a.push("ignoreEventlessOrder");this.subNetworks=false;this.networkLayoutType="forceDirected";a.push("networkLayoutType");this.networkRoot=false;a.push("networkRoot");this.isNetworkMetrics=false;a.push("isNetworkMetrics");this.showNetworkRadialLayout=false;a.push("showNetworkRadialLayout");this.is3DNetwork=false;a.push("is3DNetwork");this.networkNodesOnTop=true;a.push("networkNodesOnTop");this.moveParentsWithChildren=false;a.push("moveParentsWithChildren");this.highlightNode=[];a.push("highlightNode");this.nodeHighlightColor="rgb(255,0,0)";a.push("nodeHighlightColor");this.showNodeNameThreshold=50;a.push("showNodeNameThreshold");this.showNodeNameSizeThreshold=20;a.push("showNodeNameSizeThreshold");this.nodeSize=15;this.edgeThickness=1;this.labelNodePosition="auto";a.push("labelNodePosition");this.nodeFontStyle="";a.push("nodeFontStyle");this.nodeFontSize=15;this.nodeFontColor=this.foreground;a.push("nodeFontColor");this.nodeScaleFontFactor=1;a.push("nodeScaleFontFactor");this.networkVendor=false;a.push("networkVendor");this.attractiveForceFunction="square";a.push("attractiveForceFunction");this.repulsiveForceFunction="square";a.push("repulsiveForceFunction");this.useBarnesHutSimulation=false;a.push("useBarnesHutSimulation");this.networkSpeed=0.1;a.push("networkSpeed");this.networkGravity=0.75;a.push("networkGravity");this.networkSpringLength=35;a.push("networkSpringLength");this.networkSpringCoeff=0.0008;a.push("networkSpringCoeff");this.networkRepulsion=-1;a.push("networkRepulsion");this.networkTheta=0.8;a.push("networkTheta");this.networkDragCoeff=0.09;a.push("networkDragCoeff");this.networkTimeStep=20;a.push("networkTimeStep");this.barnesHutUpdateQueue=[];this.barnesHutNodesCache=[];this.barnesHutNodesCacheCurrent=0;this.colorNodeBy=false;a.push("colorNodeBy");this.shapeNodeBy=false;a.push("shapeNodeBy");this.sizeNodeBy=false;a.push("sizeNodeBy");this.patternNodeBy=false;a.push("patternNodeBy");this.colorEdgeBy=false;a.push("colorEdgeBy");this.sizeEdgeBy=false;a.push("sizeEdgeBy");this.showNetworkCommunities=false;a.push("showNetworkCommunities");this.calculateNetworkCommunities=true;a.push("calculateNetworkCommunities");this.coordinateNetworkConvexHullCommunityColor=false;a.push("coordinateNetworkConvexHullCommunityColor");this.hullScale=1.25;a.push("hullScale");this.networkCommunities=null;this.networkConvexHulls=[];this.genomeTicks=50;a.push("genomeTicks");this.trackNameFontStyle="";a.push("trackNameFontStyle");this.trackNameFontSize=12;a.push("trackNameFontSize");this.trackNameFontColor=this.foreground;a.push("trackNameFontColor");this.trackFillColor=this.background;a.push("trackFillColor");this.trackDirColor=this.foreground;a.push("trackDirColor");this.subtracksMaxDefault=8;a.push("subtracksMaxDefault");this.showFeatureNameThereshold=20;a.push("showFeatureNameThereshold");this.featureNameFontStyle="";a.push("featureNameFontStyle");this.featureNameFontSize=12;a.push("featureNameFontSize");this.featureNameFontColor=this.foreground;a.push("featureNameFontColor");this.featureFillColor=this.background;a.push("featureFillColor");this.featureDirColor=this.foreground;a.push("featureDirColor");this.maxFeatureStringLen=30;a.push("maxFeatureStringLen");this.featureWidthDefault=3;a.push("featureWidthDefault");this.featureHeightDefault=14;a.push("featureHeightDefault");this.featureSpliceStyle="rect";a.push("featureSpliceStyle");this.featureTraceHeight=40;a.push("featureTraceHeight");this.featureTraceTrim=1;a.push("featureTraceTrim");this.featureTracesShow=true;a.push("featureTracesShow");this.featureQualityHeight=14;a.push("featureQualityHeight");this.featureQualityValues=false;a.push("featureQualityValues");this.featureQualityShow=true;a.push("featureQualityShow");this.featureSignalToNoiseHeight=14;a.push("featureSignalToNoiseHeight");this.featureSignalToNoiseValues=false;a.push("featureSignalToNoiseValues");this.featureSignalToNoiseShow=true;a.push("featureSignalToNoiseShow");this.featureCoordinateHeight=14;a.push("featureCoordinateHeight");this.featureCoordinateShow=true;a.push("featureCoordinateShow");this.featureTranslateHeight=14;a.push("featureTranslateHeight");this.featureTranslateShow=true;a.push("featureTranslateShow");this.featureTypeDefault="line";a.push("featureTypeDefault");this.featureStaggered=false;a.push("featureStaggered");this.sequenceFontStyle="";a.push("sequenceFontStyle");this.sequenceFontSize=12;a.push("sequenceFontSize");this.sequenceFill=false;a.push("sequenceFill");this.sequenceGAPColor="rgb(255,0,255)";a.push("sequenceGAPColor");this.sequenceAColor="rgb(0,103,0)";a.push("sequenceAColor");this.sequenceBColor="rgb(0,0,0)";a.push("sequenceBColor");this.sequenceCColor="rgb(0,0,255)";a.push("sequenceCColor");this.sequenceDColor="rgb(0,0,0)";a.push("sequenceDColor");this.sequenceEColor="rgb(0,0,0)";a.push("sequenceEColor");this.sequenceFColor="rgb(0,0,255)";a.push("sequenceFColor");this.sequenceGColor="rgb(0,0,0)";a.push("sequenceGColor");this.sequenceHColor="rgb(255,0,0)";a.push("sequenceHColor");this.sequenceIColor="rgb(0,103,0)";a.push("sequenceIColor");this.sequenceKColor="rgb(255,0,0)";a.push("sequenceKColor");this.sequenceLColor="rgb(0,103,0)";a.push("sequenceLColor");this.sequenceMColor="rgb(0,103,0)";a.push("sequenceMColor");this.sequenceNColor="rgb(0,0,0)";a.push("sequenceNColor");this.sequencePColor="rgb(255,165,0)";a.push("sequencePColor");this.sequenceQColor="rgb(0,0,0)";a.push("sequenceQColor");this.sequenceRColor="rgb(255,0,0)";a.push("sequenceRColor");this.sequenceSColor="rgb(255,165,0)";a.push("sequenceSColor");this.sequenceTColor="rgb(255,0,0)";a.push("sequenceTColor");this.sequenceUColor="rgb(255,0,0)";a.push("sequenceUColor");this.sequenceVColor="rgb(0,103,0)";a.push("sequenceVColor");this.sequenceWColor="rgb(0,0,255)";a.push("sequenceWColor");this.sequenceXColor="rgb(0,0,0)";a.push("sequenceXColor");this.sequenceYColor="rgb(0,0,255)";a.push("sequenceYColor");this.sequenceZColor="rgb(0,0,0)";a.push("sequenceZColor");this.sequenceStartColor="rgb(0,204,0)";a.push("sequenceStartColor");this.sequenceEndColor="rgb(255,0,0)";a.push("sequenceEndColor");this.wireColor="rgba(204,204,204,0.1)";a.push("wireColor");this.periodTicksLabels=5;a.push("periodTicksLabels");this.genomeResolution="low";this.trackConfigurableProperties=["name","hideName","hideFeatureNames","type","height","fill","outline","hide","connect","subtracksMax","highlight"];a.push("trackConfigurableProperties");this.featureConfigurableProperties=["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"];a.push("featureConfigurableProperties");this.errors=[];this.debug=false;a.push("debug");this.verbose=false;a.push("verbose");this.offline=false;a.push("offline");this.showVersion=true;a.push("showVersion");this.showCode=false;a.push("showCode");this.codeType="params";a.push("codeType");this.disableEvents=false;a.push("disableEvents");this.disableCode=false;a.push("disableCode");this.disableMenu=false;a.push("disableMenu");this.disableToolbar=false;a.push("disableToolbar");this.disableDataTable=false;a.push("disableDataTable");this.disableDataFilters=false;a.push("disableDataFilters");this.disableConfigurator=false;a.push("disableConfigurator");this.disableDataExplorer=false;a.push("disableDataExplorer");this.disableCanvas=false;a.push("disableCanvas");this.disableKeys=false;a.push("disableKeys");this.disableShowShortcuts=false;a.push("disableShowShortcuts");this.disablePlusMinusKeys=true;a.push("disablePlusMinusKeys");this.disableUndoRedoKeys=true;a.push("disableUndoRedoKeys");this.disableDocument=false;a.push("disableDocument");this.disableWindow=false;a.push("disableWindow");this.disableWheel=false;a.push("disableWheel");this.playable=false;a.push("playable");this.resizable=true;a.push("resizable");this.resizableX=true;a.push("resizableX");this.resizableY=true;a.push("resizableY");this.movable=true;a.push("movable");this.maxSubMenus=25;a.push("maxSubMenus");this.showPrimaryMenus=false;a.push("showPrimaryMenus");this.maxItemMenuCheckbox=10;a.push("maxItemMenuCheckbox");this.configuratorWidth=250;a.push("configuratorWidth");this.configuratorExamplesSize=500;this.alignConfiguratorExamples=false;a.push("alignConfiguratorExamples");this.showConfiguratorExamplesOnSelect=false;a.push("showConfiguratorExamplesOnSelect");this.resizeWidthOnLayout=true;a.push("resizeWidthOnLayout");this.resizeHeightOnLayout=true;a.push("resizeHeightOnLayout");this.skipClick=false;this.infoTimeOut=3000;a.push("infoTimeOut");this.infoStartTime=new Date().getTime();this.infoTimeIn=50;a.push("infoTimeIn");this.broadcast=true;a.push("broadcast");this.showMousePositionOnDrag=true;a.push("showMousePositionOnDrag");this.toolbarType="under";a.push("toolbarType");this.lazyLoad=false;a.push("lazyLoad");this.showAnimation=false;a.push("showAnimation");this.showTransition=false;a.push("showTransition");this.transitionStep=20;a.push("transitionStep");this.transitionStaggering=10;a.push("transitionStaggering");this.transitionFunction="easeInOutQuad";a.push("transitionFunction");this.weight=1;this.scaleX=1;this.scaleY=1;this.translateX=0;this.translateY=0;this.offsetX=0;this.offsetY=0;this.layoutWidth=0;this.layoutHeight=0;this.layout="1X1";this.layoutTopology=false;a.push("layoutTopology");this.layoutComb=false;this.layoutAdjust=false;a.push("layoutAdjust");this.layoutCollapse=false;a.push("layoutCollapse");this.layoutType="wrap";a.push("layoutType");this.layoutRemoveEmpty=true;a.push("layoutRemoveEmpty");this.layoutCanvasCompartments=false;a.push("layoutCanvasCompartments");this.layoutBoxLabelColors=[];a.push("layoutBoxLabelColors");this.layoutBoxShow=true;a.push("layoutBoxShow");this.layoutLabelColor="rgb(0,0,0)";a.push("layoutLabelColor");this.layoutLabelBoxThickness=30;a.push("layoutLabelBoxThickness");this.layoutLabelShow=true;a.push("layoutLabelShow");this.layoutConfig=[];a.push("layoutConfig");this.layoutCurrent=0;this.layoutAxis=3;this.imageTimeOut=1000;a.push("imageTimeOut");this.imageMaxTries=10;a.push("imageMaxTries");this.imageTries=0;this.remoteService=false;a.push("remoteService");this.remoteServiceType="webService";a.push("remoteServiceType");this.remoteParams={};a.push("remoteParams");this.remoteDirection="next";a.push("remoteDirection");this.remoteAutoPlay=false;a.push("remoteAutoPlay");this.remoteAutoPlayDelay=3000;a.push("remoteAutoPlayDelay");this.remoteParamOverride=true;a.push("remoteParamOverride");this.remoteTransitionEffect="slide";a.push("remoteTransitionEffect");this.remoteAutoSize=true;a.push("remoteAutoSize");this.remoteParentId="";this.remoteDataIndex=0;this.remoteIds=[];this.remoteData=[];this.remoteUpdating=false;this.RdatasetsURL="https://raw.githubusercontent.com/neuhausi/Rdatasets/master/";this.loadRDatasets=false;a.push("loadRDatasets");this.maxDataExplorerEntries=10000;a.push("maxDataExplorerEntries");this.skipConfigurableProperties=true;a.push("skipConfigurableProperties");this.nodesProperties=[];a.push("nodesProperties");this.edgesProperties=[];a.push("edgesProperties");this.featuresProperties=[];a.push("featuresProperties");this.dataFilterWidth=220;a.push("dataFilterWidth");this.filterType="and";a.push("filterType");this.filterMode="remove";a.push("filterMode");this.filterSkipNullKeys=false;a.push("filterSkipNullKeys");this.filterSkipNullValues=false;a.push("filterSkipNullValues");this.filterVarBy={cases:[],comp:[],op:[],type:[],value:[]};a.push("filterVarBy");this.filterSmpBy={cases:[],comp:[],op:[],type:[],value:[]};a.push("filterSmpBy");this.filterNodeBy={cases:[],comp:[],op:[],type:[],value:[]};a.push("filterNodeBy");this.filterEdgeBy={cases:[],comp:[],op:[],type:[],value:[]};a.push("filterEdgeBy");this.filterFeatureBy={cases:[],comp:[],op:[],type:[],value:[]};a.push("filterFeatureBy");this.filterDataBy={cases:[],comp:[],op:[],type:[],value:[]};a.push("filterDataBy");this.filtersExposed=[];a.push("filtersExposed");this.showDataTable=false;a.push("showDataTable");this.dataTableTransposed=true;a.push("dataTableTransposed");this.maxRows=10;a.push("maxRows");this.maxCols=6;a.push("maxCols");this.colWidth=100;a.push("colWidth");this.rowHeight=18;a.push("rowHeight");this.dataTableFontSize=12;a.push("dataTableFontSize");this.dataTableFontFamily="unset";a.push("dataTableFontFamily");this.refresehDataTableOnDraw=false;a.push("refresehDataTableOnDraw");this.showDataTableOnSelect=false;a.push("showDataTableOnSelect");this.networkShowDataTable="nodes";a.push("networkShowDataTable");this.colorDataTable=true;a.push("colorDataTable");this.backgroundDataTable="rgba(255,255,255,0.95)";a.push("backgroundDataTable");this.colorDataTableTransparency=0.5;a.push("colorDataTableTransparency");this.dataTableStyle=false;a.push("dataTableStyle");this.startCol=0;this.startRow=0;this.totalCols=null;this.totalRows=null;this.dataTableColumnWidth=[];this.dataTableRowHeight=[]};this.updateTheme=function(a){for(var d in a){if(d=="conditional"){for(var e in a[d]){if(CanvasXpress.graphTypes[e].includes(this.graphType)){for(var b in a[d][e]){this[b]=a[d][e][b]}}}}else{this[d]=a[d]}}};this.setTheme=function(d){if(!d){d=CanvasXpress.stack[this.target]?CanvasXpress.stack[this.target].config:false}if(d&&d.hasOwnProperty("theme")&&d.theme){var a=d.theme.toLowerCase().replace(" ","");var b="none";switch(a){case"cx":case"canvasxpress":b="cx";break;case"paultol":b="paulTol";break;case"wallstreetjournal":case"wallstreet":b="wallStreetJournal";break;case"blackandwhite":b="blackAndWhite";break;case"lastairbenderfire":b="lastAirBender";this.colorScheme="LastAirBenderFire";break;case"lastairbenderair":b="lastAirBender";this.colorScheme="LastAirBenderAir";break;case"lastairbenderwater":b="lastAirBender";this.colorScheme="LastAirBenderWater";break;case"lastairbenderearth":b="lastAirBender";this.colorScheme="LastAirBenderEarth";break;case"gameofthronestargaryen":b="gameOfThrones";this.colorScheme="GameOfThronesTargaryen";break;case"gameofthronesstark":b="gameOfThrones";this.colorScheme="GameOfThronesStark";break;case"gameofthronesstannis":b="gameOfThrones";this.colorScheme="GameOfThronesStannis";break;case"gameofthroneslannister":b="gameOfThrones";this.colorScheme="GameOfThronesLannister";break;case"gameofthronestyrell":b="gameOfThrones";this.colorScheme="GameOfThronesTyrell";break;case"gameofthronesmartell":b="gameOfThrones";this.colorScheme="GameOfThronesMartell";break;case"gameofthronestully":b="gameOfThrones";this.colorScheme="GameOfThronesTully";break;case"gameofthronesgreyjoy":b="gameOfThrones";this.colorScheme="GameOfThronesGreyjoy";break;case"gameofthronesmanderly":b="gameOfThrones";this.colorScheme="GameOfThronesManderly";break;case"gameofthronesarryn":b="gameOfThrones";this.colorScheme="GameOfThronesArryn";break;default:b=a;break}if(CanvasXpress.themes.hasOwnProperty(b)){this.updateTheme(CanvasXpress.themes[b])}}};this.resetInitialFontSize=function(){var a=["fontSize","titleFontSize","subtitleFontSize","smpTitleFontSize","smpLabelFontSize","varTitleFontSize","varLabelFontSize","overlayFontSize","legendFontSize","decorationFontSize","axisTickFontSize","axisTitleFontSize","nodeFontSize","trackNameFontSize","featureNameFontSize","sequenceFontSize"];for(var b=0;b<a.length;b++){this[a[b]]=Number(CanvasXpress.doc.P[a[b]].D)}this.setInitialFonts()};this.setInitialFonts=function(){this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.titleFont=this.titleFontStyle+" "+this.titleFontSize+"px "+this.fontName;this.subtitleFont=this.subtitleFontStyle+" "+this.subtitleFontSize+"px "+this.fontName;this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpLabelFont=this.smpLabelFontStyle+" "+this.smpLabelFontSize+"px "+this.fontName;this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varLabelFont=this.varLabelFontStyle+" "+this.varLabelFontSize+"px "+this.fontName;this.overlayFont=this.overlayFontStyle+" "+this.overlayFontSize+"px "+this.fontName;this.legendFont=this.legendFontStyle+" "+this.legendFontSize+"px "+this.fontName;this.decorationFont=this.decorationFontStyle+" "+this.decorationFontSize+"px "+this.fontName;this.axisTickFont=this.axisTickFontStyle+" "+this.axisTickFontSize+"px "+this.fontName;this.axisTitleFont=this.axisTitleFontStyle+" "+this.axisTitleFontSize+"px "+this.fontName;this.motionCurrentFont=this.motionCurrentFontStyle+" "+this.motionCurrentFontSize+"px "+this.fontName;this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName};this.setInitialConfig=function(){if(this.meta.config.user){delete (this.meta.config.user.skipRender);for(var a in this.meta.config.user){if(this.isCreateHistogram){if(a=="setMaxX"||a=="setMinX"){continue}}if(this.isPivot){if(a=="groupingFactors"){continue}}if(CanvasXpress.doc.P[a]&&CanvasXpress.doc.P[a].hasOwnProperty("T")){if(CanvasXpress.doc.P[a].T=="integer"||CanvasXpress.doc.P[a].T=="float"){this.meta.config.user[a]=this.meta.config.user[a]===null?null:Number(this.meta.config.user[a])}this[a]=this.meta.config.user[a]}else{this[a]=this.meta.config.user[a]}}}};this.resetConfig=function(b){var d={};if(b){for(var c=0;c<b.length;c++){d[b[c]]=this[b[c]]}}this.setConfigDefaults();for(var c in d){this[c]=d[c]}};this.updateConfig=function(b){if(b){this.meta.config.user=b;for(var a in b){this[a]=b[a]}}};this.getConfig=function(){var g=this;var a={};var b=CanvasXpress.config.sort();var m=function(c){if(g.theme&&CanvasXpress.themes[g.theme]&&CanvasXpress.themes[g.theme].hasOwnProperty(c)){return CanvasXpress.themes[g.theme][c]}else{return CanvasXpress.doc.P[c].D}};var p={shapes:true,images:true,randomSeed:true,xAxisValues:true,xAxisValuesRaw:true,xAxisMinorValues:true,yAxisValues:true,yAxisValuesRaw:true,yAxisMinorValues:true,zAxisValues:true,zAxisValuesRaw:true,zAxisMinorValues:true,trackConfigurableProperties:true,featureConfigurableProperties:true,remoteServiceType:true};if(this.isTransformedData){a.isTransformedData=this.isTransformedData}for(var f=0;f<b.length;f++){var e=b[f];if(e.match(/FontSize$/)){continue}if(CanvasXpress.doc.P[e]&&CanvasXpress.doc.P[e].hasOwnProperty("D")){var h=m(e);if(p[e]){continue}var n=g[e]===undefined?false:g[e];if(typeof(n)=="object"){if(h=="[]"){h=[]}if(h=="{}"){h={}}if(n===null){if(h!="null"){a[e]=n}}else{if(e=="sizes"){if(!this.isSameObject(n,h.map(Number))){a[e]=n}}else{if(e=="colorSpectrum"||e=="colors"){var q=[];for(var l=0;l<n.length;l++){q.push(this.rgbToHex(n[l]).toLowerCase())}if(!this.isSameObject(q,h)){a[e]=n}}else{if(e.match("filter")&&e!="filtersExposed"){if(!this.isSameObject(n,this.parseJSON(h.replace(/'/g,'"')))){a[e]=n}}else{if(!this.isSameObject(n,h)){a[e]=n}}}}}}else{if(h.toString().match(/false|true|null/)){if(e=="summaryType"&&n=="raw"){continue}else{if(n.toString()!=h.toString()){a[e]=n}}}else{if(n!=h){a[e]=n}}}}}if(a.backgroundImage&&a.backgroundImage.match(/javascript:\/\//)){a.backgroundImageSrc=btoa(CanvasXpress.cacheImages[a.backgroundImage.split("//")[1]].replace("data:image/png;base64,",""))}return a};this.getUserConfig=function(){return this.meta.config.user};this.getNewCanvasContext=function(b){var a=this.$(b);if(!a||a.tagName.toLowerCase()!="canvas"){a=this.$cX("canvas",{id:b});window.body.appendChild(a)}return this.get2DCanvasContext(a)};this.setCanvasPixelRatio=function(){var b=window.devicePixelRatio||1;var a=this.get2DCanvasContext(this.$cX("canvas"));var c=a.webkitBackingStorePixelRatio||a.mozBackingStorePixelRatio||a.msBackingStorePixelRatio||a.oBackingStorePixelRatio||a.backingStorePixelRatio||1;this.meta.canvas.canvasPixelRatio=b/c};this.setDPI=function(b,c){b.style.width=b.style.width||b.width+"px";b.style.height=b.style.height||b.height+"px";var g=c/96;var a=parseFloat(b.style.width);var h=parseFloat(b.style.height);var d=b.width/a;var f=g/d;var e=b.cloneNode(false);this.get2DCanvasContext(e).drawImage(b,0,0);var i=this.get2DCanvasContext(b);b.width=Math.ceil(a*g);b.height=Math.ceil(h*g);i.setTransform(f,0,0,f,0,0);i.drawImage(e,0,0);i.setTransform(g,0,0,g,0,0)};this.setCanvas=function(){var a=this.$(this.target);if(a){this.setCanvasPixelRatio();this.checkCanvasXpressOrgSite();this.meta.canvas.ctx=this.get2DCanvasContext(a);this.meta.canvas.ctx.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0)}};this.get2DCanvasContext=function(a){return a.getContext("2d")};this.getCanvasContext=function(){var a=this.isSVG?this.meta.canvas.SVG:this.isHighlightCanvas?this.meta.canvas.ctx2:this.meta.canvas.ctx;this.currentCanvasContext=a.canvas.id;return a};this.checkCanvasXpressOrgSite=function(){var f=new RegExp("/www.canvasxpress.org/dist/");var b=window.document.getElementsByTagName("head")[0];for(var a=0;a<b.childNodes.length;a++){var d=b.childNodes[a];if(d.type=="text/javascript"&&f.test(d.src)){CanvasXpress.factory.siteSrc=true}}};this.inititalizeConfig=function(a){CanvasXpress.config=[];this.setConfigDefaults();if(a&&a.graphType){this.graphType=a.graphType}this.setTheme(a);if(a){for(var c=0;c<CanvasXpress.config.length;c++){var e=CanvasXpress.config[c];var b=CanvasXpress.doc.P[e]?CanvasXpress.doc.P[e].T:false;if(a.hasOwnProperty(e)){if(b=="array"){if(a[e] instanceof Array){this[e]=a[e]}else{this[e]=[a[e]];a[e]=[a[e]]}}else{this[e]=a[e]}}}}this.setInitialFonts();for(var d in this.url){if(this.hasOwnProperty(d)){this[d]=this.url[d]}}this.setCanvas();CanvasXpress.system.isR=this.isR;CanvasXpress.system.isHTMLWidgets=typeof HTMLWidgets!="undefined";CanvasXpress.system.isShiny=typeof window.Shiny!=="undefined"&&!!window.Shiny.outputBindings;CanvasXpress.system.isRViewer=/\bviewer_pane=1\b/.test(window.location);CanvasXpress.system.isRConsole=CanvasXpress.system.isHTMLWidgets&&!CanvasXpress.system.isShiny&&!CanvasXpress.system.isRViewer;CanvasXpress.system.isNode=typeof exports==="object"&&typeof module!=="undefined";if(CanvasXpress.system.isShiny){this.disableUndoRedoKeys=true}}};CanvasXpress.prototype.initDate=function(){var a=function(){var b=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,c=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,e=/[^-+\dA-Z]/g,d=function(g,f){g=String(g);f=f||2;while(g.length<f){g="0"+g}return g};return function(j,w,r){var h=a;if(arguments.length==1&&Object.prototype.toString.call(j)=="[object String]"&&!/\d/.test(j)){w=j;j=undefined}j=j?new Date(j):new Date;if(isNaN(j)){throw SyntaxError("invalid date")}w=String(h.masks[w]||w||h.masks["default"]);if(w.slice(0,4)=="UTC:"){w=w.slice(4);r=true}var u=r?"getUTC":"get",n=j[u+"Date"](),f=j[u+"Day"](),k=j[u+"Month"](),q=j[u+"FullYear"](),t=j[u+"Hours"](),l=j[u+"Minutes"](),v=j[u+"Seconds"](),p=j[u+"Milliseconds"](),g=r?0:j.getTimezoneOffset(),i={d:n,dd:d(n),ddd:h.i18n.dayNames[f],dddd:h.i18n.dayNames[f+7],m:k+1,mm:d(k+1),mmm:h.i18n.monthNames[k],mmmm:h.i18n.monthNames[k+12],yy:String(q).slice(2),yyyy:q,h:t%12||12,hh:d(t%12||12),H:t,HH:d(t),M:l,MM:d(l),s:v,ss:d(v),l:d(p,3),L:d(p>99?Math.round(p/10):p),t:t<12?"a":"p",tt:t<12?"am":"pm",T:t<12?"A":"P",TT:t<12?"AM":"PM",Z:r?"UTC":(String(j).match(c)||[""]).pop().replace(e,""),o:(g>0?"-":"+")+d(Math.floor(Math.abs(g)/60)*100+Math.abs(g)%60,4),S:["th","st","nd","rd"][n%10>3?0:(n%100-n%10!=10)*n%10]};return w.replace(b,function(m){return m in i?i[m]:m.slice(1,m.length-1)})}}();a.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'",year:"yyyy",month:"mmmm",day:"dddd",hour:"HH",minute:"MM",second:"ss"};a.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(b,c){return a(this,b,c)};this.isValidDateFormat=function(b){return !isNaN(new Date(b))};this.dateFormat=a};CanvasXpress.prototype.initText=function(){this.setTextShadow=function(a){if(this.showTextShadow){if(a){this.meta.canvas.ctx.shadowOffsetX=this.shadowOffsetX;this.meta.canvas.ctx.shadowOffsetY=this.shadowOffsetY;this.meta.canvas.ctx.shadowBlur=this.shadowBlur;this.meta.canvas.ctx.shadowColor=this.shadowColor}else{this.meta.canvas.ctx.shadowOffsetX=0;this.meta.canvas.ctx.shadowOffsetY=0;this.meta.canvas.ctx.shadowBlur=0;this.meta.canvas.ctx.shadowColor=this.background}}};this.getArcTextArea=function(C,A,z,a,D,u,p,v,j,w,d,g,B){if(C==undefined){C=""}var q=["poly"];var o=this.getFontPt(p);var j=this.measureText(C,p,B)*(Math.PI*0.5)/a;D=(D+(u/2))-(j/2)%(Math.PI*2);u=D+j;var n=this.traceArc1(A,z,a,D,u,true);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}n=this.traceArc1(A,z,a-o,D,u);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?q:this.adjustNetworkObjects(q)}else{return q}};this.drawArcText=function(B,z,w,a,C,p,o,q,j,v,g,h,A){if(B==undefined){B=""}if(!A){A=this.getCanvasContext()}if(B==null){return}if(!A){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(z)||isNaN(w)){if(this.debug){alert("Not a valid coordinate ("+z+", "+w+") to draw "+B)}return}if(!h&&!isNaN(B)){B=this.formatNumber(B)}B=B.toString().replace("\x00","");if(!z){z=0}if(!w){w=0}if(!o){o=this.font}if(!q){q=this.foreground}if(!j){j=this.align}if(!v){v=this.baseline}this.saveCanvas(A);A.strokeStyle=this.isArray(q)?q[0]:q;A.fillStyle=this.isArray(q)?q[0]:q;A.font=o;A.textAlign=j;A.textBaseline=v;this.setTextShadow(true);var d=j=="right"?1:-1;var u=this.getFontPt(o);if(((["left","center"].indexOf(j)>-1)&&g)||(j=="right"&&!g)){B=B.split("").reverse().join("");if(this.isArray(q)){q=q.reverse()}}A.translate(z,w);C+=(Math.PI*!g);C+=(Math.PI/2)+(p/2);if(j=="center"){for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o,A);C+=((n+(k==B.length-1?0:this.circularLetterSeparationFactor))/(a-u))/2*-d}}p=C;this.rotateCanvas(C,A);for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o,A);p+=(n/2)/(a-u)*d;this.rotateCanvas((n/2)/(a-u)*d,A);if(this.isArray(q)){A.strokeStyle=q[k];A.fillStyle=q[k]}A.fillText(B[k],0,(g?1:-1)*(0-a+u/2));p+=(n/2+this.circularLetterSeparationFactor)/(a-u)*d;this.rotateCanvas((n/2+this.circularLetterSeparationFactor)/(a-u)*d),A}this.restoreCanvas(A);this.setTextShadow(false)};this.getTextMultipleArea=function(o,n,k,A,B,E,D,g,q,p,j){if(o==undefined){o=""}var r=o.split(/\n/);var w=this.getFontPt(A);var C=[];var F=k+(r%2?0:w/2)-(r.length*w/2);for(var u=0;u<r.length;u++){C.push(this.getTextArea(r[u],n,F,A,B,E,D,g,q,p,j));F+=w}var z=C[0][1];var e=C[0][2];var v=C[0][3];var d=C[0][4];for(var u=1;u<C.length;u++){z=Math.min(z,C[u][1]);e=Math.min(e,C[u][2]);v=Math.max(v,C[u][3]);d=Math.max(d,C[u][4])}return[C[0][0],z,e,v,d]};this.drawTextMultiple=function(B,w,r,o,q,v,u,e,h,C,z,A){var j=B.split(/\n/);var d=o;if(!d){d=this.font}var n=this.getFontPt(d);var p=r+(j%2?0:n/2)-(j.length*n/2);for(var k=0;k<j.length;k++){this.drawText(j[k],w,p,d,q,v,u,e,h,C,z,A);p+=n;if(e&&e<90){w+=n;p-=n}}};this.getTextArea=function(p,n,l,C,D,F,E,g,r,q,k,u){var j=this;var v=function(b){b.shift();var a=["poly"];a=a.concat(j.rotatePoint(b[0],b[1],n,l,g));a=a.concat(j.rotatePoint(b[2],b[1],n,l,g));a=a.concat(j.rotatePoint(b[2],b[3],n,l,g));a=a.concat(j.rotatePoint(b[0],b[3],n,l,g));return a};if(p==undefined){p=""}if(k){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(l<this.marginTop+this.offsetY+this.top||l>this.marginTop+this.offsetY+this.top+this.y){return}}if(this.isMultipleLines(p)){return this.getTextMultipleArea(p,n,l,C,D,F,E,g,r,q,k)}var G=[];var o=this.measureText(p,C,u);var z=this.getFontPt(C);var B,e,A,d;var i=0;if(r){while(o>r&&i<10){p=p.substring(0,p.length-1);o=this.measureText(p,C,u);i++}}if(F=="left"){B=n;A=B+o}else{if(F=="right"){B=n-o;A=n}else{B=n-(o/2);A=n+(o/2)}}if(E=="top"){e=l;d=e+z}else{if(E=="bottom"){e=l-z;d=l}else{e=l-(z/2);d=l+(z/2)}}G=["rect",B,e,A,d];G=g?v(G):G;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?G:this.adjustNetworkObjects(G)}else{return G}};this.drawText=function(r,n,j,h,i,l,k,d,e,u,p,q){if(r==undefined){r=""}if(!q){q=this.getCanvasContext()}var g=0;if(r==null){return}if(this.isMultipleLines(r)){return this.drawTextMultiple(r,n,j,h,i,l,k,d,e,u,p,q)}if(!q){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(n)||isNaN(j)){if(this.debug){alert("Not a valid coordinate ("+n+", "+j+") to draw "+r)}return}if(p){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(j<this.marginTop+this.offsetY+this.top||j>this.marginTop+this.offsetY+this.top+this.y){return}}if(!n){n=0}if(!j){j=0}if(!h){h=this.font}if(!i){i=this.foreground}if(!l){l=this.align}if(!k){k=this.baseline}var o=this.measureText(r,h,q);if(e){while(o>e&&g<10){r=r.substring(0,r.length-1);o=this.measureText(r,h,q);g++}}this.saveCanvas(q);q.strokeStyle=i;q.fillStyle=i;q.font=h;this.translateCanvas(n,j,q);q.textAlign=l;q.textBaseline=k;this.setTextShadow(true);if(d){this.rotateCanvas(d,q)}r=r.toString().replace("\x00","").replace("u0000","");if(u){q.strokeText(r,0,0)}else{q.fillText(r,0,0)}this.restoreCanvas(q);this.setTextShadow(false)};this.isMultipleLines=function(b){var a=b.toString().split(/\n/);return a.length-1};this.capitalize=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.decapitalize=function(a){if(a){return a.charAt(0).toLowerCase()+a.slice(1)}};this.measureTextMultiple=function(e,g,c){var b=e.split(/\n/);var a=0;if(!c){c=this.getCanvasContext();if(!c){return 0}}if(!g){g=this.font}c.font=g;for(var d=0;d<b.length;d++){a=Math.max(a,c.measureText(b[d]).width)}return a};this.measureText=function(b,c,a){if(!a){a=this.getCanvasContext()}if(!b||!a){return 0}b=b.toString();if(!c){c=this.font}if(!CanvasXpress.cacheText[c]){CanvasXpress.cacheText[c]={}}if(!CanvasXpress.cacheText[c][b]){a.font=c;if(this.isMultipleLines(b)){CanvasXpress.cacheText[c][b]=this.measureTextMultiple(b,c,a)}else{CanvasXpress.cacheText[c][b]=a.measureText(b).width}}return CanvasXpress.cacheText[c][b]};this.measureTextWidth=function(b,c){var a=this.isMultipleLines(b);if(a>0){return(this.getFontPt(c)+this.margin)*(a+1)}else{return this.getFontPt(c)}};this.scaleTextToFont=function(c,i,b,d,a){var g=Math.ceil(i);var e=this.fontStyle+" "+g+"px "+this.fontName;if(c){while(this.measureText(c,e,a)>b&&g>=this.minTextSize){g-=2;e=this.fontStyle+" "+g+"px "+this.fontName}if(d){while(parseInt(g/1.33)>d-2){g--}e=this.fontStyle+" "+g+"px "+this.fontName}}return e};this.getFontPt=function(a){return a?Math.max(1,parseInt(a.toString().match(/[\-\d]+/)[0])):1};this.scaleTextToSize=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.wrapText=function(c,b){var a=new RegExp("(?![^\\n]{1,"+b+"}$)([^\\n]{1,"+b+"})([\\s|-])","g");return c.toString().replace(a,"$1$2\n").replace(" \n","\n")};this.scaleFont=function(a,b){var d=this.getFontPt(a);var c=Math.max(1,parseInt(d*b));return a.replace(d+"px",c+"px")};this.formatNumber=function(f,e){var c=(!isNaN(e)&&parseInt(e!=null?e:10)>0)?parseFloat(f).toFixed(parseInt(e!=null?e:10)):Number(f);var b=parseFloat(c);if(Math.abs(b)<0.0001||Math.abs(b)>99999||b.toString().length>=8){var a=b.toExponential(2).toString().replace("e+0","").replace(".00","").replace(/(\.[0-9])(0)/,"$1");if(a.match(/e\+1$/)||a.match(/e\+2$/)||a.match(/e\-1$/)){a=(a*1).toString()}return a}else{return b.toString()}};this.getMaxtTextBySampling=function(b,h){var c={};var f=[];var g=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;f.push([d,d.length])}}f.sort(function(j,i){return j[1]<i[1]?-1:j[1]>i[1]?1:0});if(!h){h=10}if(f.length<h){h=f.length}for(var e=0;e<h;e++){g.push(f[e][0])}return this.getMaxText(g)};this.getMaxText=function(e,j,d){var h="";var b=0;if(e&&e.length>0){if(!j){j=this.font}for(var g=0;g<e.length;g++){if(e[g]){var k=this.measureText(e[g].toString(),j,d);if(k>b){h=e[g].toString();b=k}}}}return h};this.shortenText=function(c,b,a){if(c==null){return""}c=c.toString();if(!c){return""}if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.convertToNumber=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}};this.stringToHex=function(c){var b="";for(var a=0;a<c.length;a++){b+=""+c.charCodeAt(a).toString(16)}return b};this.hexToString=function(b){var c="";for(var a=0;a<b.length;a+=2){c+=String.fromCharCode(parseInt(b.substr(a,2),16))}return c};this.sprintf=function(){var k=function(c,a){for(var f=[];a>0;f[--a]=c){}return(f.join(""))};var g=0,n,h=arguments[g++],d=[],e,b,j,l;while(h){if(e=/^[^\x25]+/.exec(h)){d.push(e[0])}else{if(e=/^\x25{2}/.exec(h)){d.push("%")}else{if(e=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gosuxX])/.exec(h)){if(((n=arguments[e[1]||g++])==null)||(n==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(e[7])&&(typeof(n)!="number")){throw ("Expecting number but found "+typeof(n))}switch(e[7]){case"b":n=n.toString(2);break;case"c":n=String.fromCharCode(n);break;case"d":n=parseInt(n);break;case"e":n=e[6]?n.toExponential(e[6]):n.toExponential();break;case"f":n=e[6]?parseFloat(n).toFixed(e[6]):parseFloat(n);break;case"g":n=e[6]?String(Number(n).toPrecision(e[6])):parseFloat(n);break;case"o":n=n.toString(8);break;case"s":n=((n=String(n))&&e[6]?n.substring(0,e[6]):n);break;case"u":n=Math.abs(n);break;case"x":n=n.toString(16);break;case"X":n=n.toString(16).toUpperCase();break}n=(/[def]/.test(e[7])&&e[2]&&n>0?"+"+n:n);j=e[3]?e[3]=="0"?"0":e[3].charAt(1):" ";l=e[5]-String(n).length;b=e[5]?k(j,l):"";d.push(e[4]?n+b:b+n)}else{throw ("Huh ?!")}}}h=h.substring(e[0].length)}return d.join("")}};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};Date.prototype.addMilliseconds=function(a){let date=new Date(this.valueOf());date.setDate(date.getMilliseconds()+a);return date};Date.prototype.addSeconds=function(a){let date=new Date(this.valueOf());date.setDate(date.getSeconds()+a);return date};Date.prototype.addMinutes=function(a){let date=new Date(this.valueOf());date.setDate(date.getMinutes()+a);return date};Date.prototype.addHours=function(a){let date=new Date(this.valueOf());date.setDate(date.getHours()+a);return date};Date.prototype.addDays=function(a){let date=new Date(this.valueOf());date.setDate(date.getDate()+a);return date};Date.prototype.addMonths=function(a){let date=new Date(this.valueOf());date.setMonth(date.getMonth()+a);return date};Date.prototype.addYears=function(a){let date=new Date(this.valueOf());date.setYear(date.getFullYear()+a);return date};this.getMillisecond=function(a){return a.getMilliseconds()};this.getSecond=function(a){return a.getSeconds()};this.getMinuteSecond=function(a){return a.getMinutes()+"."+a.getSeconds()};this.getMinute=function(a){return a.getMinutes()};this.getHourMinute=function(a){return a.getHours()+"."+a.getMinutes()};this.getHour=function(a){return a.getHours()};this.getYearWeek=function(a){return a.getFullYear()+"."+a.getWeek()};this.getMonthDay=function(a){return(a.getMonth()+1)+"."+(a.getDay()+1)};this.getYearMonth=function(a){return a.getFullYear()+"."+(a.getMonth()+1)};this.getYear=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.parseDate=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.formatDate=function(f,w){var A,j,q,b,p,i,k,g,u,o,d,v,c,x,y,r,t,n,l,z,a,e;f=new Date(f);j=((A=f.getFullYear())+"").slice(-2);p=(i=f.getMonth()+1)<10?("0"+i):i;b=(q=["January","February","March","April","May","June","July","August","September","October","November","December"][i-1]).substring(0,3);u=(o=f.getDate())<10?("0"+o):o;g=(k=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"][f.getDay()]).substring(0,3);e=(o>=10&&o<=20)?"th":((a=o%10)==1)?"st":(a==2)?"nd":(a==3)?"rd":"th";w=w.replace("#YYYY#",A).replace("#YY#",j).replace("#MMMM#",q).replace("#MMM#",b).replace("#MM#",p).replace("#M#",i).replace("#DDDD#",k).replace("#DDD#",g).replace("#DD#",u).replace("#D#",o).replace("#th#",e);x=(v=f.getHours());if(x==0){x=24}if(x>12){x-=12}c=x<10?("0"+x):x;d=v<10?("0"+v):v;z=(l=v<12?"am":"pm").toUpperCase();y=(r=f.getMinutes())<10?("0"+r):r;t=(n=f.getSeconds())<10?("0"+n):n;return w.replace("#hhhh#",d).replace("#hhh#",v).replace("#hh#",c).replace("#h#",x).replace("#mm#",y).replace("#m#",r).replace("#ss#",t).replace("#s#",n).replace("#ampm#",l).replace("#AMPM#",z)};this.setTimeAxis=function(){var h=this.validateTimeAxis();if(h.length){var k=Date.parse(h[0]);var a=Date.parse(h[h.length-1]);var g=a-k;var c;if(this.timeFormat=="year"||g>this.times.year*2){if(g/h.length>=this.times.year){c="addYears"}else{c="addDays"}}else{if(this.timeFormat=="month"||g>this.times.week){c="addDays"}else{if(g<this.times.second){c="addMilliseconds"}else{if(g<this.times.minute){c="addSeconds"}else{if(g<this.times.hour){c="addMinutes"}else{if(g<this.times.day){c="addHourss"}}}}}}this.timeValues=[this.dateFormat(new Date(k)[c](-1),this.timeFormat)];this.timeValueIndices=[-1];while(k<=a){var j=new Date(k);var e=this.dateFormat(j,this.timeFormat);var b=this.getSampleIndices(this.timeFormat.match(/year|hour|minute|second/)?Number(e):e);this.timeValues.push(e);this.timeValueIndices.push(b);j=j[c](1);k=Date.parse(j)}}else{return[]}};this.createRandomTimes=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w.labs:this.data.y.smps;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.length;c++){e=Date.parse(h[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.validateTimeAxis=function(){var j=this.isGroupedData?this.data.w.labs:this.data.y.smps;var b=false;var h=[];for(var c=0;c<j.length;c++){var a=j[c];var e=this.timeFormat;switch(this.timeFormat){case"Year":case"year":a+="/01/02";e="isoDate";break;case"Month":case"month":a="2018/"+CanvasXpress.dates[a]+"/02";e="isoDate";break;case"Day":case"day":a="2018/01/"+CanvasXpress.dates[a];e="isoDate";break}if(!this.isValidDateFormat(a)){this.isGraphTime=false;alert("Invalid Date! Graph converted from Time Graph");return[]}var g=Date.parse(this.dateFormat(a,e));if(isNaN(g)){if(this.isExample){h=this.createRandomTimes();return h}else{b=true;break}}else{h.push(new Date(g))}}h.sort(function(f,d){return f-d});return b?false:h}};CanvasXpress.prototype.initColor=function(){this.validateColor=function(j,e,g){var k=j;if(k){k=k.toString();k=k.replace(/\s/g,"");var b=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(k);var d=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(k);var i=(/^#?([0-9abcdef]{6})/i).exec(k);var a=(/^([0-9abcdef]{6})/i).exec(k);if(CanvasXpress.colorNames.hasOwnProperty(k)){k=this.hexToRgb(CanvasXpress.colorNames[k])}else{if(b!=null){k=b[0]}else{if(d!=null){k=d[0]}else{if(i!=null){k=this.hexToRgb(i[0])}else{if(a!=null){k=this.hexToRgb("#"+a[0])}else{if(k=="[objectCanvasGradient]"){return j}else{k=false}}}}}}}k=k&&e!=null?this.addColorTransparency(k,e,true):k?k:false;return k&&g?this.rgbToHex(k):k};this.darkenLightenColor=function(j,e){j=this.rgbToHex(this.validateColor(j)).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.hexToRgb(j.toString(16))};this.rgbToHex=function(b){var a=function(c){c=parseInt(c,10);if(isNaN(c)){return"00"}c=Math.max(0,Math.min(c,255));return"0123456789ABCDEF".charAt((c-c%16)/16)+"0123456789ABCDEF".charAt(c%16)};if(b&&b.substr(0,1)==="#"){return b}if(b&&b.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{if(b&&b.match(/^rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{return b}}};this.rgbToHsl=function(m){var i=this.colorAsArray(m);var a=i[0]/255;var j=i[1]/255;var n=i[2]/255;var o=Math.max(a,j,n);var e=Math.min(a,j,n);var f,p;var c=(o+e)/2;if(o==e){f=0;p=0}else{var k=o-e;p=c>0.5?k/(2-o-e):k/(o+e);switch(o){case a:f=(j-n)/k+(j<n?6:0);break;case j:f=(n-a)/k+2;break;case n:f=(a-j)/k+4;break}f/=6}return"hsl("+Math.floor(f*100)+","+Math.floor(p*100)+"%,"+Math.floor(c*100)+"%)"};this.complementaryColor=function(j,e){var d=this.validateColor(j.toString());if(d.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var i=parseInt(255-RegExp.$1);var f=parseInt(255-RegExp.$2);var a=parseInt(255-RegExp.$3);if(i==f&&f==a){if(i>=127){d="rgb(255,255,255)"}else{d="rgb(0,0,0)"}}else{d="rgb("+i+","+f+","+a+")"}return e?this.rgbToHex(d):d}else{return j}};this.hexToRgb=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.hslToRgb=function(n){var j=n.split(",");var i=Number(j[0].replace(/\s/g,"").replace("hsl(",""));var o=Number(j[0].replace(/\s/g,"").replace("%",""));var f=Number(j[0].replace(/\s/g,"").replace("%)",""));if(o==0){return"rgb("+f+","+f+","+f+")"}else{var e=function(h,g,b){if(b<0){b+=1}if(b>1){b-=1}if(b<1/6){return h+(g-h)*6*b}if(b<1/2){return g}if(b<2/3){return h+(g-h)*(2/3-b)*6}return h};var c=f<0.5?f*(1+o):f+o-f*o;var d=2*f-c;var a=Math.round(e(d,c,i+1/3)*255);var k=Math.round(e(d,c,i)*255);var m=Math.round(e(d,c,i-1/3)*255);return"rgb("+a+","+k+","+m+")"}};this.addColorTransparency=function(e,d,b){if(e){if(e instanceof CanvasGradient){return e}var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);if(!a||!b){e=this.validateColor(e);a=e&&e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)}return a?"rgba("+a[1]+","+Math.min(d,(a[2]!=null?a[2]:1))+")":false}else{return false}};this.removeColorTransparency=function(d,b){if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);if(!a||!b){d=this.validateColor(d);a=d&&d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)}return a?"rgb("+a[1]+")":false}else{return false}};this.isColorTransparency=function(d,b){if(!b){d=this.validateColor(d)}if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return !a?null:a[2]!=null?Number(a[2]):null}};this.isColorTransparent=function(e,b){if(!b){e=this.validateColor(e)}var d;if(e&&e.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return false}else{if(e){var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return !a?false:a[2]!=null&&a[2]==0?true:false}else{return false}}};this.combineColors=function(j){var e=[];var d=[];var n=[];var k=[];for(var f=0;f<j.length;f++){j[f]=this.validateColor(j[f])}for(var f=0;f<j.length;f++){var l=j[f];if(l&&l.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){e.push(parseInt(RegExp.$1));d.push(parseInt(RegExp.$2));n.push(parseInt(RegExp.$3));if(RegExp.$4){k.push(parseFloat(RegExp.$4))}}}if(e.length>0){var a=parseInt(this.mean(e));var h=parseInt(this.mean(d));var m=parseInt(this.mean(n));if(k.length>0){var o=parseFloat(this.mean(k));return"rgba("+a+","+h+","+m+","+o+")"}else{return"rgb("+a+","+h+","+m+")"}}return false};this.colorAsArray=function(f){f=this.validateColor(f);var b=[];if(f){var d=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(f);var e=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(f);if(d!=null){b=[parseInt(d[1]),parseInt(d[2]),parseInt(d[3])]}else{if(e!=null){b=[parseInt(e[1]),parseInt(e[2]),parseInt(e[3]),Number(e[4])]}}}return b};this.monoColor=function(f,d){var b=this.colorAsArray(f);var e=Math.ceil(0.3*b[0]+0.59*b[1]+0.11*b[2]);if(d!=null){return"rgba("+e+","+e+","+e+","+d+")"}else{return"rgb("+e+","+e+","+e+")"}};this.blindColor=function(S,I){var q=this.colorAsArray(this.validateColor(S,I));var J=q[0];var Q=q[1];var T=q[2];var x=[0.7465,0.2535,1.273463,-0.073894];var A=[1.4,-0.04,0.968437,0.003331];var u=[1.748,0,0.062921,0.292119];if(J==0&&Q==0&&T==0){return"rgb(0,0,0)"}var l;switch(this.blindnessType){case"protanopia":l=x;break;case"deuteranopia":l=A;break;case"tritanopia":l=u;break;case"monochromatic":var S=Math.ceil((J*0.212656+J*0.715158+J*0.072186));return"rgb("+S+","+S+","+S+")"}var F=l[0];var D=l[1];var K=l[2];var z=l[3];var n=1;var y=Math.pow(J,2.2);var B=Math.pow(Q,2.2);var C=Math.pow(T,2.2);var i=y*0.412424+B*0.357579+C*0.180464;var h=y*0.212656+B*0.715158+C*0.072185;var f=y*0.019332+B*0.119193+C*0.950444;var k=i/(i+h+f);var j=h/(i+h+f);var w=(j-D)/(k-F);var L=j-k*w;var e=(z-L)/(w-K);var a=(w*e)+L;i=e*h/a;f=(1-(e+a))*h/a;var O=0.312713*h/0.329016;var M=0.358271*h/0.329016;var G=O-i;var E=M-f;var H=G*3.24071+E*-0.498571;var N=G*-0.969258+E*0.0415557;var R=G*0.0556352+E*1.05707;var d=i*3.24071+h*-1.53726+f*-0.498571;var o=i*-0.969258+h*1.87599+f*0.0415557;var s=i*0.0556352+h*-0.203996+f*1.05707;var U=((H<0?0:1)-d)/H;var m=((N<0?0:1)-o)/N;var p=((R<0?0:1)-s)/R;var P=[(U>1||U<0)?0:U,(m>1||m<0)?0:m,(p>1||m<0)?0:p];P=Math.max.apply(null,P);d=d+(P*H);o=o+(P*N);s=s+(P*R);d=Math.pow(d,1/2.2);o=Math.pow(o,1/2.2);s=Math.pow(s,1/2.2);J=Math.ceil(d);Q=Math.ceil(o);T=Math.ceil(s);if(J>255){J-=255}if(Q>255){Q-=255}if(T>255){T-=255}return"rgb("+J+","+Q+","+J+")"};this.disableGradientTransparencyShadow=function(){if(!this.gradientTemp){this.gradientTemp=this.gradient}if(this.transparencyTemp==null){this.transparencyTemp=this.transparency}if(!this.showShadowTemp){this.showShadowTemp=this.showShadow}this.gradient=false;this.transparency=null;this.showShadow=false};this.enableGradientTransparencyShadow=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp;this.showShadow=this.showShadowTemp};this.resetGradientTransparencyShadow=function(){delete (this.gradientTemp);delete (this.transparencyTemp);delete (this.showShadowTemp)};this.getGradient=function(f,e,d,c,b,a){if(this.gradientType=="radial"){return this.getRadialGradient(f,e,d,b,a,true)}else{return this.getLinearGradient(f,e,d,c,b,a,true)}};this.getLinearGradient=function(d,o,a,m,j,l,k){if(!k){this.saveCanvas()}var p=this.getCanvasContext();var h=p.createLinearGradient(d,o,a,m);if(!j){j=this.colorSpectrum}else{if(this.validateColor(j)&&(!this.isArray(j)||j.length<2)){j=[j,"black"]}}if(!l||!this.isArray(l)){l=this.graphType=="Heatmap"?[]:this.colorSpectrumBreaks}var q=1/(j.length-1);var e=q;for(var f=0;f<j.length;f++){j[f]=this.validateColor(j[f])}h.addColorStop(l[0]||0,this.transparency!=null?this.addColorTransparency(j[0]):j[0]);for(var f=1;f<j.length;f++){h.addColorStop(l[f]||e,this.transparency!=null?this.addColorTransparency(j[0]):j[f]);e+=q}return h};this.getRadialGradient=function(p,k,a,j,m,l){if(!l){this.saveCanvas()}var q=this.getCanvasContext();var d=a/5.5;var h=q.createRadialGradient(p-d,k-d,1,p,k,a);if(!j){j=this.colorSpectrum}else{if(this.validateColor(j)&&(!this.isArray(j)||j.length<2)){j=[j,"black"]}}if(!m||!this.isArray(m)){m=this.graphType=="Heatmap"?[]:this.colorSpectrumBreaks}var t=1/(j.length-1);var e=t;h.addColorStop(m[0]||0,this.transparency!=null?this.addColorTransparency(j[0]):j[0]);for(var f=1;f<j.length;f++){h.addColorStop(m[f]||e,this.transparency!=null?this.addColorTransparency(j[0]):j[f]);e+=t}return h};this.colorRGBfromString=function(b){var a=b.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(a){if(a[1].length===6){this.colorFromRgb(parseInt(a[1].substr(0,2),16)/255,parseInt(a[1].substr(2,2),16)/255,parseInt(a[1].substr(4,2),16)/255)}else{this.colorFromRgb(parseInt(a[1].charAt(0)+a[1].charAt(0),16)/255,parseInt(a[1].charAt(1)+a[1].charAt(1),16)/255,parseInt(a[1].charAt(2)+a[1].charAt(2),16)/255)}}};this.colorFromRgb=function(e,d,a){if(this.colorRGB){if(e!=null){this.colorRGB[0]=Math.min(Math.max(0,e),1)}if(d!=null){this.colorRGB[1]=Math.min(Math.max(0,d),1)}if(a!=null){this.colorRGB[2]=Math.min(Math.max(0,a),1)}var c=this.rgbFromHsv(this.colorRGB[0],this.colorRGB[1],this.colorRGB[2]);if(c[0]!=null){this.colorHSV[0]=c[0]}if(c[2]!=0){this.colorHSV[1]=c[1]}this.colorHSV[2]=c[2]}};this.rgbFromHsv=function(i,f,c){var j=Math.min(Math.min(i,f),c);var d=Math.max(Math.max(i,f),c);var a=d-j;if(a==0){return[null,0,d]}else{var e=i==j?3+(c-f)/a:(f==j?5+(i-c)/a:1+(f-i)/a);return[e==6?0:e,a/d,d]}};this.colorFromHsv=function(c,b,a){if(c!=null){this.colorHSV[0]=Math.min(Math.max(0,c),6)}if(b!=null){this.colorHSV[1]=Math.min(Math.max(0,b),1)}if(a!=null){this.colorHSV[2]=Math.min(Math.max(0,a),1)}this.colorRGB=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],this.colorHSV[2])};this.hsvFromRgb=function(e,d,b){if(e==null){return[b,b,b]}var c=Math.floor(e);var g=c%2?e-c:1-(e-c);var a=b*(1-d);var j=b*(1-d*g);switch(c){case 0:return[b,j,a];case 1:return[j,b,a];case 2:return[a,b,j];case 3:return[a,j,b];case 4:return[j,a,b];case 5:return[b,a,j];case 6:return[b,a,j]}};this.colorRGBToString=function(){if(this.colorRGB){return(256|Math.round(255*this.colorRGB[0])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[1])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[2])).toString(16).substr(1)}};this.getColorNames=function(){return this.sortObject(CanvasXpress.colorNames)};this.getColorSchemes=function(){return this.sortObject(CanvasXpress.colorSchemes)};this.getHexColor=function(b){var c=/^#?[0-9a-fA-F]{6}$/i;var a=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;if(c.test(b)){return b.substring(b.length-6,b.length)}else{if(a.test(b)){return this.rgbToHex(b)}else{var d=b.toLowerCase();if(CanvasXpress.colorNames.hasOwnProperty(d)){return CanvasXpress.colorNames[d]}else{throw new Error(b+" is not a valid color.")}}}};this.getColorForValue=function(a,c){if(!a){a=this.meta.def.colorBrew}for(var d=0;d<a.breaks.length;d++){if(a.breaks[d]>=c){return a.colors[d]}}return a.colors[a.colors.length-1]};this.setColorForValues=function(a,d){var g=this;var c=function(l){var j=function(t,q){var n=a.grads[l];var s=n.min;var z=n.max;var p=n.scol.replace("#","").substring(t,q);var A=n.ecol.replace("#","").substring(t,q);var w=d<s?s:d>z?z:d;var i=z-s;var x=parseInt(p,16);var m=parseInt(A,16);var u=(m-x)/i;if(isNaN(u)){u=0}var o=Math.round(u*(w-s)+x);var y=o.toString(16);return y.length==1?"0"+y:y};var k=j(0,2);var h=j(2,4);var b=j(4,6);return g.hexToRgb("#"+k+h+b)};if(!a){a=this.meta.def.colorBrew}if(a.length==1){return c(0)}else{for(var e=0;e<a.grads.length;e++){if(a.grads[e].min<=d&&a.grads[e].max>d){return c(e)}}var f=(a.max-a.min)/a.grads.length;var e=Math.min(Math.floor((Math.max(d,a.min)-a.min)/f),a.grads.length-1);return isNaN(e)?"rgba(0,0,0,0)":c(e)}};this.getColorBrew=function(K,B,E,g,f,c){var h=K||this.colorSpectrum;if(B!=null&&E!=null&&B==E){E+=0.1}var F=B!=null&&f&&f.length?Math.min(B,f[0]):B!=null?B:this.minData!=null?this.minData:0;var o=E!=null&&f&&f.length?Math.max(E,f[f.length-1]):E!=null?E:this.maxData!=null?this.maxData:100;var I=!c&&this.setMinX!=null?this.setMinX:null;var w=!c&&this.setMaxX!=null?this.setMaxX:null;var C,t;var L=[];if(g==null){zero=(F+o)/2}else{zero=g;var C=g-F;var t=o-g;if(C>t){o=g+C}else{F=g-t}}var q=this[this.axisAlgorithm](Math.min(I||F,w||o),Math.max(I||F,w||o),5,this.axisWilkinsonLoose);if(o==Math.abs(F)&&g==0&&q.length%2){q[Math.floor(q.length/2)]=0}var G=(q[q.length-1]-q[0])/(h.length-1);var a=this.getAxisDecimals(q[1]-q[0]);var d=[];for(var D=0;D<q.length;D++){d[D]=q[D].toFixed(a)}var e=this.getMaxText(d);var H=this.measureText(e.toString(),this.font);var m=q[q.length-1]-q[0];var u=[];if(f&&f.length>1&&f.length==h.length){for(var D=0;D<f.length;D++){f[D]=Number(f[D]);u.push(this.formatNumber(f[D].toString()))}e=this.getMaxText(u);H=this.measureText(e.toString(),this.font);f=f.sort(function(l,i){return l-i});var x=f[0];var A=Math.ceil(100/h.length)+1;for(var D=1;D<f.length;D++){var k=f[D];var J=this.seq(x,k,false,A);x=J.pop();L=L.concat(J)}L.push(x);this.colorSpectrumNumber=L.length}else{L=this.seq(q[0],q[q.length-1],false,this.colorSpectrumNumber)}var j={spectrum:h,stops:f,z:g,colors:[],smooth:[],grads:[],rmin:F,rmax:o,min:(f&&f.length>1?f[0]:q[0]),max:(f&&f.length>1?f[f.length-1]:q[q.length-1]),range:m,zero:zero,vals:q,valStr:d,incr:G,decs:a,breaks:L,maxLevLen:H,maxLevChr:e.toString().length,maxLevStr:e};for(var D=0;D<h.length-1;D++){var y={scol:this.getHexColor(h[D]),ecol:this.getHexColor(h[D+1]),min:(f&&f.length>1?f[D]:q[0]+(G*D)),max:(f&&f.length>1?f[D+1]:q[0]+(G*(D+1)))};j.grads.push(y)}for(var D=0;D<this.colorSpectrumNumber;D++){v=this.setColorForValues(j,L[D]);j.colors.push(v)}return j};this.setColorBrew=function(d,e){this.setColorSpectrum();if(!this.meta.def.colorBrew||d){if(this.meta.vals.colors){this.meta.vals.colors={}}if(this.graphType.match(/Stacked/)){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minDataStacked,this.maxDataStacked,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(this.heatmapAutoAdjust||!this.meta.def.colorBrew){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData,this.maxData,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{var b=this.meta.def.colorBrew;if(e){if(this.isTransformedData){var c=this.isHistogram?0.000001:this.minData;var a=this.maxData;switch(this.isTransformedData){case"log2":c=Math.log(c)/Math.LN2;a=Math.log(a)/Math.LN2;break;case"log10":c=Math.log(c)/Math.LN10;a=Math.log(a)/Math.LN10;break;case"exp2":c=Math.pow(2,c);a=Math.pow(2,a);break;case"exp10":c=Math.pow(10,c);a=Math.pow(10,a);break}if(!this.isNumber(c,true)||!this.isNumber(a,true)){c=this.min(this.data.y.trans);a=this.max(this.data.y.trans)}this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,c,a,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData||b.rmin,this.maxData||b.rmax,this.colorSpectrumZeroValue||b.z,this.colorSpectrumBreaks||b.stops)}}else{this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,b.rmin,b.rmax,b.z,b.stops)}}}}};this.getCustomColorScheme=function(k,e){if(!k){k=8}if(!e||!CanvasXpress.colorSchemes.hasOwnProperty(e)){e=this.colorScheme}var c=this.getKeys(CanvasXpress.colorSchemes[e]);c.sort(function(f,d){return f-d});if(CanvasXpress.colorSchemes[e]){if(CanvasXpress.colorSchemes[e][k]){return CanvasXpress.colorSchemes[e][k]}else{if(c[c.length-1]==256){var h=this.frac(k);var g=[];for(var a=0;a<k;a++){var b=Math.max(0,Math.min(255,Math.floor(h[a]*256)));g.push(CanvasXpress.colorSchemes[e][256][b])}return g}else{if(k>c[c.length-1]){var j=k-c.length;k--;while(!CanvasXpress.colorSchemes[e][k]){k--}var g=CanvasXpress.colorSchemes[e][k];for(var a=0;a<j;a++){g.push(CanvasXpress.colorSchemes[e][k][a%CanvasXpress.colorSchemes[e][k].length])}return g}else{k++;while(!CanvasXpress.colorSchemes[e][k]){k++}return CanvasXpress.colorSchemes[e][k]}}}}else{return this.colors}};this.setColorSpectrum=function(){if(this.blindnessType&&!this.meta.def.colorSpectrum){this.meta.def.colorSpectrum=this.cloneObject(this.colorSpectrum);var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.blindColor(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{if(this.meta.def.colorSpectrum&&this.meta.def.blindnessTypeSpectrum!=this.blindnessType){if(this.blindnessType){var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.blindColor(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{this.colorSpectrum=this.cloneObject(this.meta.def.colorSpectrum)}}}this.meta.def.blindnessTypeSpectrum=this.blindnessType};this.setColorScheme=function(k){var e=this;var a=false;var h;var c=function(o){if(e.data[o]){if(e.colorBy){return e.data[o].hasOwnProperty(e.colorBy)&&e.meta.data[o][e.colorBy].colors?e.meta.data[o][e.colorBy].colors.length:e.data.y.smps.length}else{var n=e.data.y.smps.length;for(var m in e.meta.data[o]){if(e.meta.data[o][m].levels){n=Math.max(n,e.meta.data[o][m].levels.length)}}return n}}return e.data.y.smps.length};if(this.colorScheme=="User"){h=this.cloneObject(this.colors)}else{if(this.colorScheme=="ColorSpectrum"){var j=this.colorSpectrumNumber;this.colorSpectrumNumber=this.graphType=="Circular"?Math.max(this.data.y.vars.length,this.data.y.smps.length):this.data.y.vars.length;var l=this.getColorBrew(this.colorSpectrum,0,this.data.y.vars.length);h=l.colors;this.colorSpectrumNumber=j}else{if(CanvasXpress.colorSchemes[this.colorScheme]){var b;var g=this.getKeys(CanvasXpress.colorSchemes[this.colorScheme]);g.sort(function(m,i){return m-i});g=parseInt(g[g.length-1]);if(k&&k.type=="String"){b=k.levels.length}else{if(this.graphType.match(/Scatter/)){if(this.layoutValid){b=c("z")}else{if(this.colorBy&&this.meta.data.hasOwnProperty("z")&&this.meta.data.z.hasOwnProperty(this.colorBy)&&this.meta.data.z[this.colorBy].colors){b=this.meta.data.z[this.colorBy].levels.length}else{b=this.data.y.smps.length}}}else{if(this.graphType.match(/Treemap|TagCloud|Sankey|Tree|Circular/)){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/Venn/)){b=this.vennGroups}else{if(this.graphType.match(/Pie/)){b=this.data.y.vars.length}else{if(this.graphType.match(/Network|Genome|Correlation/)){b=g}else{if(this.graphType=="ParallelCoordinates"){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/BarLine|DotLine/)&&this.coordinateLineColor&&(!this.isGroupedData||!this.colorBy)){b=Math.max(this.xAxis.length,this.xAxis2.length)}else{if(this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){b=this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.meta.data.x[this.colorBy].levels?this.meta.data.x[this.colorBy].levels.length:this.data.y.vars.length}else{b=this.data.y.vars.length}}}}}}}}}if(CanvasXpress.colorSchemes[this.colorScheme][b]){h=CanvasXpress.colorSchemes[this.colorScheme][b]}else{if(b>g){b--;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b--}}else{b++;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b++}}h=CanvasXpress.colorSchemes[this.colorScheme][b]}if(this.meta.def.colors){this.meta.def.colors=this.cloneObject(h);a=true}}else{h=CanvasXpress.colorSchemes.Balanced[20]}}}if((this.blindnessType&&!this.meta.def.colors)||a){this.meta.def.colors=this.cloneObject(h);if(this.blindnessType){var f=[];for(var d=0;d<h.length;d++){f.push(this.blindColor(h[d]))}h=f}}else{if(this.meta.def.colors&&this.meta.def.blindnessTypeColors!=this.blindnessType){h=this.cloneObject(this.meta.def.colors);if(this.blindnessType){var f=[];for(var d=0;d<h.length;d++){f.push(this.blindColor(h[d]))}h=f}}}this.meta.def.blindnessTypeColors=this.blindnessType;for(var d=0;d<h.length;d++){h[d]=this.validateColor(h[d])}if(!k){this.colors=h}this.updateMetaDataColors(h,k)};this.validateUserColors=function(){var b=[];for(var c=0;c<this.colors.length;c++){b.push(this.validateColor(this.colors[c]))}if(b.length>0){this.colors=b}var a=[];for(var c=0;c<this.colorSpectrum.length;c++){a.push(this.validateColor(this.colorSpectrum[c]))}if(a.length>0){this.colorSpectrum=a}}};CanvasXpress.prototype.initAttributes=function(){this.setStyle=function(c,b,d,a){if(!a){a=this.getCanvasContext()}if(this.transparency!=null){c=this.addColorTransparency(c,this.transparency,true)}a.fillStyle=c;a.strokeStyle=c;a.lineWidth=b?b:this.outlineWidth;a.lineCap=d?d:this.capType;this.setShadow(true,a)};this.setClipBoundaries=function(c){var b,d,a,e;if(c&&c.length==4){b=c[0];d=c[1];a=c[2];e=c[3]}else{b=this.marginLeft+this.offsetX+this.left-1;d=this.marginTop+this.offsetY+this.top-1;a=this.x+2;e=this.y+2}return[b,d,a,e]};this.setClipArea=function(a,e){if(this.graphType=="Tree"){return}if(!e){e=this.getCanvasContext()}this.saveCanvas(e);var d,f,c,g;if(a){d=a[0];f=a[1];c=a[2];g=a[3]}else{d=this.marginLeft+this.offsetX+this.left;f=this.marginTop+this.offsetY+this.top;c=this.x+1;g=this.y+1}e.rect(d,f,c,g);e.clip();this.meta.state.clip=[d,f,c,g]};this.resetClipArea=function(a){if(this.graphType=="Tree"){return}this.restoreCanvas(a);this.setClipArea([0,0,0,0],a);this.restoreCanvas(a);this.meta.state.clip=false};this.resetStyle=function(a){this.setShadow(false,a)};this.setShadow=function(c,a){if(this.showShadow){if(!a){a=this.getCanvasContext()}var b="rgba(255,255,255,0)";if(c){a.shadowOffsetX=this.shadowOffsetX;a.shadowOffsetY=this.shadowOffsetY;a.shadowBlur=this.shadowBlur;a.shadowColor=this.shadowColor}else{a.shadowOffsetX=0;a.shadowOffsetY=0;a.shadowBlur=0;a.shadowColor=this.background;a.strokeStyle="rgba(255,255,255,0)";a.fillStyle="rgba(255,255,255,0)"}}};this.lineTo=function(c,h,b,g,i){if(this.graphType=="Network"){return this.lineRawTo(c,h,b,g,i)}var f=~~(c+0.5);var a=~~(h+0.5);var d=~~(b+0.5);var j=~~(g+0.5);if(Math.abs(f-d)==1){f=(f+d)/2;d=f}else{f+=0.5;d+=0.5}if(Math.abs(a-j)==1){a=(a+j)/2;j=a}else{a+=0.5;j+=0.5}if(!i){i=this.getCanvasContext()}if(f==d&&a==j){var e=this.lineThickness/1.5;i.fillRect(f,a,e,e)}else{i.moveTo(f,a);i.lineTo(d,j)}i.stroke()};this.lineRawTo=function(c,e,b,d,a){if(!a){a=this.getCanvasContext()}a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.lineToOld=function(c,e,b,d,a){if(c==b){c=(((c+0.5)<<1)>>1)+0.5;b=c}else{if(e==d){e=(((e+0.5)<<1)>>1)+0.5;d=e}}if(!a){a=this.getCanvasContext()}a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.bitCode=function(b,c){var a=0;if(b[0]<c[0]){a|=1}else{if(b[0]>c[2]){a|=2}}if(b[1]<c[1]){a|=4}else{if(b[1]>c[3]){a|=8}}return a};this.intersect=function(d,c,e,f){return e&8?[d[0]+(c[0]-d[0])*(f[3]-d[1])/(c[1]-d[1]),f[3]]:e&4?[d[0]+(c[0]-d[0])*(f[1]-d[1])/(c[1]-d[1]),f[1]]:e&2?[f[2],d[1]+(c[1]-d[1])*(f[2]-d[0])/(c[0]-d[0])]:e&1?[f[0],d[1]+(c[1]-d[1])*(f[0]-d[0])/(c[0]-d[0])]:null};this.lineClip=function(n,l,h){var k,j,d,m;if(!l){l=this.setClipBoundaries();l[2]+=l[0];l[3]+=l[1]}if(!h){h=[]}var g=n.length;var e=this.bitCode(n[0],l);var c=[];for(var f=1;f<g;f++){k=n[f-1];j=n[f];d=m=this.bitCode(j,l);while(true){if(!(e|d)){c.push(k);if(d!==m){c.push(j);if(f<g-1){h.push(c);c=[]}}else{if(f===g-1){c.push(j)}}break}else{if(e&d){break}else{if(e){k=this.intersect(k,j,e,l);e=this.bitCode(k,l)}else{j=this.intersect(k,j,d,l);d=this.bitCode(j,l)}}}}e=m}if(c.length){h.push(c)}return h};this.polygonClip=function(k,j,c){var h,d,g,a,e;if(!j){j=this.setClipBoundaries();j[2]+=j[0];j[3]+=j[1]}if(c){xy=[];for(var f=1;f<k.length;f+=2){xy.push([k[f],k[f+1]])}}else{xy=k}for(var b=1;b<=8;b*=2){h=[];d=xy[xy.length-1];g=!(this.bitCode(d,j)&b);for(var f=0;f<xy.length;f++){a=xy[f];e=!(this.bitCode(a,j)&b);if(e!==g){h.push(this.intersect(d,a,b,j))}if(e){h.push(a)}d=a;g=e}xy=h;if(!xy.length){break}}if(c){k=["poly"];for(var f=0;f<h.length;f++){k.push(h[f][0]);k.push(h[f][1])}return k}return h};this.lineIntersect=function(e,l,d,j,b,h,m,g){if((e===d&&l===j)||(b===m&&h===g)){return false}var f=((g-h)*(d-e)-(m-b)*(j-l));if(f===0){return false}var c=((m-b)*(l-h)-(g-h)*(e-b))/f;var a=((d-e)*(l-h)-(j-l)*(e-b))/f;if(c<0||c>1||a<0||a>1){return false}var k=e+c*(d-e);var i=l+c*(j-l);return[k,i]};this.clip=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(!k){k=this.setClipBoundaries()}var e=k[0];var q=k[1];var a=k[2];var m=k[3];switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"arrow":case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":d=this.parseInt(f[0]-(f[2]/2));p=this.parseInt(f[1]-(f[3]/2));c=this.parseInt(d+f[2]);n=this.parseInt(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"pentagon":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>e+a||d<e||p<q||p>q+m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.getLineArea=function(P,D,a,B,af,aa,O,T,Q,ab,ac,ad,R,U,V,E){var W=Math.max((O||1),this.lineWidthEvent);var S=[];var I=["poly"];P=this.validateBezier(P,D,a,B,af,Q,ab);if(P.match(/error/)){if(this.showErrorBars&&this.isNumeric([D,a,B,af,O])){D=Math.ceil(D);B=Math.ceil(B);a=Math.ceil(a);af=Math.ceil(af);O=Math.ceil(O);var K=O/2;if(O>0){I=["poly",D,a-W,B-W,af-W,B-W,af-K,B+W,af-K,B+W,af+K,B-W,af+K,B-W,af+W,D,a+W]}else{I=["poly",B-W,af+W,B-K,af+W,B-K,af-W,B+K,af-W,B+K,af+W,B+W,af+W,D+W,a,D-W,a]}}else{return false}}else{if(P=="spline"||P=="cardinalSpline"){if(D.length<3){return D.length<2?false:this.getLineArea("line",D[0],a[0],D[1],a[1],aa,O,T,Q,ab,ac,ad,R,U,V)}for(var Z=0;Z<D.length;Z++){I.push(D[Z],a[Z]-W);S.push(a[Z]+W,D[Z])}I=I.concat(S.reverse())}else{if(P=="arch"){if(D.length!=3||a.length!=3){return false}for(var Z=0;Z<D.length;Z++){if(!this.isNumeric([D[Z],a[Z]])){return false}}S=this.traceQuadraticCurve(D[0],a[0],D[1],a[1],D[2],a[2],0.25,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceQuadraticCurve(D[0],a[0],D[1],a[1],D[2],a[2],0.25);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P=="arc"){I=["poly"];S=this.traceArc1(D,a,B,Q,ab,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceArc1(D,a,B-W,Q,ab);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P=="quadratic"){var v=this.perpendicularLinePoints(D,a,B,af,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(R))*(R>0?-1:1));var C=this.shortenLine(D,a,B,af,Q,ab,P,R);var x=this.parallelLinePoints(C[0],C[1],v[0],v[1],W);var u=this.parallelLinePoints(v[0],v[1],C[2],C[3],W);S=this.traceQuadraticCurve(x[0],x[1],x[4],x[5],u[4],u[5],0.1,true);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}var M=[];S=this.traceQuadraticCurve(x[2],x[3],x[6],x[7],u[6],u[7],0.1,true);for(var Z=0;Z<S.length;Z++){M.push(S[Z][1],S[Z][0])}I=I.concat(M.reverse())}else{if(P=="roundLine"){I=["poly",D-W,a,D-W,af+W,B,af+W,B,af-W,D+W,af-W,D+W,a]}else{if(this.isNumeric([D,a,B,af])){var G=this.shortenLine(D,a,B,af,(Q||0),(ab||0),P);D=G[0];a=G[1];B=G[2];af=G[3];if(ac){G=this.clip("line",[D,a,B,af],ad);if(G){D=G[0];a=G[1];B=G[2];af=G[3]}else{return false}}if(R&&this.isArray(R)&&R.length>0){if(this.isNumeric2DArray(R)){if(P.match(/bezier/i)){if(R[0].length==6){var ae=[R[0][0],R[0][1]];for(var Z=0;Z<R.length;Z++){ae=ae.concat(R[Z])}ae.push(R[R.length-1][0],R[R.length-1][1]);var d=this.cloneObject(ae);for(var Z=0;Z<R.length;Z++){S=this.traceBezierCurve(d[0],d[1]-W,d[2],d[3]-W,d[4],d[5]-W,d[6],d[7]-W,0.1,true);for(var Y=0;Y<S.length;Y++){I.push(S[Y][0],S[Y][1])}for(var Y=0;Y<6;Y++){d.shift()}}d=this.cloneObject(ae);var M=[];for(var Z=0;Z<R.length;Z++){S=this.traceBezierCurve(d[0],d[1]+W,d[2],d[3]+W,d[4],d[5]+W,d[6],d[7]+W,0.1,true);for(var Y=0;Y<S.length;Y++){M.push(S[Y][1],S[Y][0])}for(var Y=0;Y<6;Y++){d.shift()}}I=I.concat(M.reverse())}else{if(R.length==4){var x=this.parallelLinePoints(R[0][0],R[0][1],R[1][0],R[1][1],W);var u=this.parallelLinePoints(R[2][0],R[2][1],R[3][0],R[3][1],W);S=this.traceBezierCurve(x[0],x[1],x[4],x[5],u[0],u[1],u[4],u[5],0.1,true);for(var Y=0;Y<S.length;Y++){I.push(S[Y][0],S[Y][1])}S=this.traceBezierCurve(x[2],x[3],x[6],x[7],u[2],u[3],u[6],u[7],0.1,true);var M=[];for(var Y=0;Y<S.length;Y++){M.push(S[Y][1],S[Y][0])}I=I.concat(M.reverse())}else{var A=this.parallelLinePoints(R[0][0],R[0][1],R[R.length-1][0],R[R.length-1][1],W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}else{if(R.length>2){I=["poly"];var L=[];for(var Z=0;Z<R.length-1;Z++){L.push([R[Z][0],R[Z][1]])}for(var Z=R.length-1;Z>=1;Z--){L.push([R[Z][0],R[Z][1]])}S=this.enlargePolygon(L,W,1);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{var A=this.parallelLinePoints(R[0][0],R[0][1],R[1][0],R[1][1],W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}else{return false}}else{if(P.match(/curved/i)){var z=D==B&&a==af&&E;var o=this.lineMidPoint(D,a,B,af);var N=this.lineLength(D,a,o[0],o[1]);var J=(Q||0)/N;var F=(ab||0)/N;var y=P.match(/curvedcc/i)&&D>B?false:!P.match(/curvedcc/i)&&B>=D?true:false;var l=B>=D?Math.asin((o[1]-a)/N):Math.asin(-(o[1]-a)/N);var X=l+Math.PI;var k=[];if(z){if(l<0){l+=Math.PI*2}var r=E.size*1.25;var H=E.size/1.25;switch(E.pos){case"top":k=[D,a-r,H,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":k=[D+r,a-r,H,Math.PI,Math.PI*0.5,false];break;case"right":k=[D+r,a,H,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":k=[D+r,a+r,H,Math.PI*1.5,Math.PI,false];break;case"bottom":k=[D,a+r,H,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":k=[D-r,a+r,H,0,Math.PI*1.5,false];break;case"left":k=[D-r,a,H,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":k=[D-r,a-r,H,Math.PI*0.5,0,false];break}}else{if(B>=D){k=[o[0],o[1],Math.max(0,N),l-F,X+J,y]}else{k=[o[0],o[1],Math.max(0,N),l+J,X-F,y]}}I=["poly"];S=this.traceArc(k[0],k[1],k[2]+W,k[3],k[4],k[5]);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}S=this.traceArc(k[0],k[1],k[2]-W,k[3],k[4],!k[5]);for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(P.match(/bezier/i)){var h=(D+B)/2;var g=(a+af)/2;if(P.match(/beziery/i)){S=this.traceBezierCurve(D,a-W,D,g-W,B,g-W,B,af-W,0.25,true)}else{S=this.traceBezierCurve(D,a-W,h,a-W,h,af-W,B,af-W,0.25,true)}for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}if(P.match(/beziery/i)){S=this.traceBezierCurve(D,a+W,D,g+W,B,g+W,B,af+W,0.25)}else{S=this.traceBezierCurve(D,a+W,h,a+W,h,af+W,B,af+W,0.25)}for(var Z=0;Z<S.length;Z++){I.push(S[Z][0],S[Z][1])}}else{if(D==B&&a!=af){I=["poly",D-W,a,D+W,a,B+W,af,B-W,af]}else{if(a==af&&D!=B){I=["poly",D,a-W,B,a-W,B,af+W,D,af+W]}else{var A=this.parallelLinePoints(D,a,B,af,W);I=["poly",A[0],A[1],A[2],A[3],A[6],A[7],A[4],A[5]]}}}}}}else{return false}}}}}}}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?I:this.adjustNetworkObjects(I)}else{return I}};this.setDashDot=function(c,a){if(!a){a=this.getCanvasContext()}var b=[];this.tempCap=a.lineCap;if(c.match(/blank/i)){b=CanvasXpress.R.lty[0]}else{if(c.match(/solid/i)){b=CanvasXpress.R.lty[1]}else{if(c.match(/dashed/i)){b=CanvasXpress.R.lty[2];b=[this.dashLength,this.dashLength-2]}else{if(c.match(/dotted/i)){b=CanvasXpress.R.lty[3];b=[this.dotLength,this.dotLength+2]}else{if(c.match(/dotdash/i)){b=CanvasXpress.R.lty[4]}else{if(c.match(/longdash/i)){b=CanvasXpress.R.lty[5]}else{if(c.match(/twodash/i)){b=CanvasXpress.R.lty[6]}}}}}}}a.setLineDash(b)};this.resetDashDot=function(a){if(!a){a=this.getCanvasContext()}a.lineCap=this.tempCap;a.setLineDash([])};this.validateBezier=function(c,b,g,a,f,d,h){if(this.adjustBezier){if(c.match(/bezier/i)&&(b==a||g==f)){return"line"}if(Math.abs(a-b)>=Math.abs(f-g)){if(c.match(/beziery/i)){c=c.replace("beziery","bezier");c=c.replace("bezierY","bezier")}}else{if(c.match(/bezierx/i)){c=c.replace("bezierx","beziery");c=c.replace("bezierX","bezierY")}else{if(c.match(/bezier/i)){c=c.replace("bezier","bezierY")}}}if(d!=null&&h!=null){if(c.match(/beziery/i)){if(f>g){if(g+d>f-h){c="line"}}else{if(g-d<f+h){c="line"}}}else{if(c.match(/beziery/i)){if(a>b){if(b+d>a-h){c="line"}}else{if(b-d<a+h){c="line"}}}}}}return c};this.drawLine=function(N,z,a,x,ad,W,M,R,P,Y,Z,ab,Q,S,T,A,K,B){if(!B){B=this.getCanvasContext()}this.setDashDot(N,B);N=this.validateBezier(N,z,a,x,ad,P,Y);var d=false;var H=function(){var c=Math.sqrt(Math.pow(x-z,2)+Math.pow(ad-a,2));var b=ad>a?this.roundedPolygonRadius/c:(c-this.roundedPolygonRadius)/c;return[z+(b*(x-z)),a+(b*(ad-a))]};var C=function(b){switch(b){case"arrow":d=0;break;case"square":d=1;break;case"round":d=2;break;case"roundDocked":d=false;break}};if(N.match(/error/)){if(this.showErrorBars&&this.isNumeric([z,a,x,ad,M])){z=Math.ceil(z);x=Math.ceil(x);a=Math.ceil(a);ad=Math.ceil(ad);M=Math.ceil(M);var J=M/2;this.setStyle(W,false,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();this.lineTo(z,a,x,ad,B);if(Math.abs(M)>this.errorBarsWidth){if(M>0){this.lineTo(x,ad-J,x,ad+J,B)}else{this.lineTo(x-J,ad,x+J,ad,B)}}}}this.resetStyle(B)}else{if(N.match(/spline|cardinalSpline/i)){if(z.length<3){return z.length<2?false:this.drawLine(N=="dashedSpline"?"dashedLine":"line",z[0],a[0],z[1],a[1],W,M,R,P,Y,Z,ab,Q,S,T,false,false,B)}var O=[];var aa=[];var X=0;for(var V=0;V<z.length;V++){if(this.isNumeric([z[V],a[V]])){aa.push(z[V],a[V]);X+=2}else{return}}this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){if(N.match(/spline/i)){for(var V=0;V<X-4;V+=2){O=O.concat(this.splineControlPoint(aa[V],aa[V+1],aa[V+2],aa[V+3],aa[V+4],aa[V+5]))}B.beginPath();B.moveTo(aa[0],aa[1]);B.quadraticCurveTo(O[0],O[1],aa[2],aa[3]);for(var V=2;V<X-5;V+=2){B.bezierCurveTo(O[2*V-2],O[2*V-1],O[2*V],O[2*V+1],aa[V+2],aa[V+3])}B.moveTo(aa[X-2],aa[X-1]);B.quadraticCurveTo(O[2*X-10],O[2*X-9],aa[X-4],aa[X-3]);B.stroke()}else{aa=this.curvePoints(aa);B.beginPath();B.moveTo(aa[0],aa[1]);for(var V=2;V<aa.length-1;V+=2){B.lineTo(aa[V],aa[V+1])}B.stroke()}}this.resetStyle(B)}else{if(N.match(/arch/)){if(z.length!=3||a.length!=3){return false}for(var V=0;V<z.length;V++){if(!this.isNumeric([z[V],a[V]])){return false}}this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();B.moveTo(z[0],a[0]);B.quadraticCurveTo(z[1],a[1],z[2],a[2]);B.stroke()}this.resetStyle(B)}else{if(N=="arc"){this.setStyle(W,M,R,B);B.beginPath();B.arc(z,a,Math.max(0,x),P,Y,false);B.stroke();this.resetStyle(B)}else{if(N=="quadratic"){this.setStyle(W,M,R,B);var r=this.perpendicularLinePoints(z,a,x,ad,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(Q))*(Q>0?-1:1));var y=this.shortenLine(z,a,x,ad,P,Y,N,Q);var ac=this.traceQuadraticCurve(y[0],y[1],r[0],r[1],y[2],y[3],0.1,true);B.beginPath();B.moveTo(y[0],y[1]);B.quadraticCurveTo(r[0],r[1],y[2],y[3]);B.stroke();this.resetStyle(B);if(T){z=ac[9][0];a=ac[9][1];x=y[2];ad=y[3];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=ac[1][0];a=ac[1][1];x=y[0];ad=y[1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{if(N=="roundLine"){this.setStyle(W,M,R,B);B.beginPath();B.moveTo(z,a);if(a>ad){B.lineTo(z,ad+this.roundedPolygonRadius);if(z>x){B.quadraticCurveTo(z,ad,z+this.roundedPolygonRadius,ad)}else{B.quadraticCurveTo(z,ad,z-this.roundedPolygonRadius,ad)}}else{B.lineTo(z,ad-this.roundedPolygonRadius);if(z>x){B.quadraticCurveTo(z,ad,z-this.roundedPolygonRadius,ad)}else{B.quadraticCurveTo(z,ad,z+this.roundedPolygonRadius,ad)}}B.lineTo(x,ad);B.stroke();this.resetStyle(B);if(T){C(T);this.drawArrowHead(z,ad,x,ad,W,M,d,false,B)}if(S){C(S);this.drawArrowHead(z,ad,x,ad,W,M,d,true,B)}}else{if(this.isNumeric([z,a,x,ad])){var E=this.shortenLine(z,a,x,ad,(P||0),(Y||0),N);z=E[0];a=E[1];x=E[2];ad=E[3];if(Z){E=this.clip("line",[z,a,x,ad],ab);if(E){z=E[0];a=E[1];x=E[2];ad=E[3]}else{return false}}if(Q&&this.isArray(Q)&&Q.length>0){var G=Q.length-1;if(this.isNumeric2DArray(Q)){this.setStyle(W,M,R,B);if(N.match(/bezier/i)){if(!this.isColorTransparent(W,true)){if(Q[0].length==6){B.beginPath();B.moveTo(Q[0][0],Q[0][1]);for(var V=0;V<Q.length;V++){B.bezierCurveTo(Q[V][0],Q[V][1],Q[V][2],Q[V][3],Q[V][4],Q[V][5])}B.stroke();var ac;if(T){ac=this.traceBezierCurve(Q[G][0],Q[G][1],Q[G][0],Q[G][1],Q[G][2],Q[G][3],Q[G][4],Q[G][5],0.1,true);z=ac[9][0];a=ac[9][1];x=ac[10][0];ad=ac[10][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){ac=this.traceBezierCurve(Q[0][0],Q[0][1],Q[0][0],Q[0][1],Q[0][2],Q[0][3],Q[0][4],Q[0][5],0.1,true);z=ac[1][0];a=ac[1][1];x=ac[0][0];ad=ac[0][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{if(Q.length==4){B.beginPath();B.moveTo(Q[0][0],Q[0][1]);B.bezierCurveTo(Q[1][0],Q[1][1],Q[2][0],Q[2][1],Q[3][0],Q[3][1]);B.stroke();var ac=this.traceBezierCurve(Q[0][0],Q[0][1],Q[1][0],Q[1][1],Q[2][0],Q[2][1],Q[3][0],Q[3][1],0.1,true);if(T){z=ac[9][0];a=ac[9][1];x=Q[3][0];ad=Q[3][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=ac[1][0];a=ac[1][1];x=Q[1][0];ad=Q[1][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{B.beginPath();B.moveTo(Q[0][0],Q[0][1]);this.lineTo(Q[G][0],Q[G][1],false,false,B);B.stroke();if(T){z=Q[G-1][0];a=Q[G-1][1];x=Q[G][0];ad=Q[G][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=Q[0][0];a=Q[0][1];x=Q[1][0];ad=Q[1][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}}}}else{if(!this.isColorTransparent(W,true)){B.beginPath();this.lineTo(Q[0][0],Q[0][1],Q[1][0],Q[1][1],B);for(var V=1;V<G;V++){this.lineTo(Q[V][0],Q[V][1],Q[V+1][0],Q[V+1][1],B)}if(T){z=Q[G-1][0];a=Q[G-1][1];x=Q[G][0];ad=Q[G][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=Q[0][0];a=Q[0][1];x=Q[1][0];ad=Q[1][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}}this.resetStyle(B)}else{return false}}else{if(N.match(/curved/i)){var v=z==x&&a==ad&&A;var l=this.lineMidPoint(z,a,x,ad);var L=this.lineLength(z,a,l[0],l[1]);var I=(P||0)/L;var D=(Y||0)/L;var u=N.match(/curvedcc/i)&&z>x?false:!N.match(/curvedcc/i)&&x>=z?true:false;var k=x>=z?Math.asin((l[1]-a)/L):Math.asin(-(l[1]-a)/L);var U=k+Math.PI;var j=[];this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();if(v){if(k<0){k+=Math.PI*2}if(A.dir){T=false;S=A.end}else{T=A.end;S=false}var o=A.size*1.25;var F=A.size/1.25;switch(A.pos){case"top":j=[z,a-o,F,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":j=[z+o,a-o,F,Math.PI,Math.PI*0.5,false];break;case"right":j=[z+o,a,F,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":j=[z+o,a+o,F,Math.PI*1.5,Math.PI,false];break;case"bottom":j=[z,a+o,F,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":j=[z-o,a+o,F,0,Math.PI*1.5,false];break;case"left":j=[z-o,a,F,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":j=[z-o,a-o,F,Math.PI*0.5,0,false];break}}else{if(x>=z){j=[l[0],l[1],Math.max(0,L),k-D,U+I,u]}else{j=[l[0],l[1],Math.max(0,L),k+I,U-D,u]}}B.arc(j[0],j[1],j[2],j[3],j[4],j[5]);var ac=this.traceArc(j[0],j[1],j[2],j[3],j[4],j[5]);B.stroke()}this.resetStyle(B);if(T){C(T);z=ac[15][0];a=ac[15][1];x=ac[16][0];ad=ac[16][1];this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){z=ac[1][0];a=ac[1][1];x=ac[0][0];ad=ac[0][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{if(N.match(/bezier/i)){var h=(z+x)/2;var g=(a+ad)/2;var ac;this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();B.moveTo(z,a);if(this.graphType=="Tree"&&this.treeCircular&&K){B.bezierCurveTo(K[2],K[3],K[0],K[1],x,ad);ac=this.traceBezierCurve(z,a,K[0],K[1],K[0],K[1],x,ad,0.1,true)}else{if(N.match(/beziery/i)){B.bezierCurveTo(z,g,x,g,x,ad);ac=this.traceBezierCurve(z,a,z,g,x,g,x,ad,0.1,true)}else{B.bezierCurveTo(h,a,h,ad,x,ad);ac=this.traceBezierCurve(z,a,h,a,h,ad,x,ad,0.1,true)}}B.stroke()}this.resetStyle(B);if(T){z=ac[9][0];a=ac[9][1];x=ac[10][0];ad=ac[10][1];C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){x=ac[0][0];ad=ac[0][1];z=ac[1][0];a=ac[1][1];C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}else{if(N.match(/needle/i)){this.setStyle(W,M,R,B);var r=this.parallelLinePoints(z,a,x,ad,M);if(!this.isColorTransparent(W,true)){B.beginPath();B.moveTo(r[0],r[1]);B.lineTo(x,ad);B.lineTo(r[2],r[3]);B.closePath();B.stroke();B.fill();B.arc(z,a,M*3,0,Math.PI*2);B.stroke();B.fill()}this.resetStyle(B)}else{this.setStyle(W,M,R,B);if(!this.isColorTransparent(W,true)){B.beginPath();if(N.match(/R$/)||this.useRawLines){this.lineRawTo(z,a,x,ad,B)}else{this.lineTo(z,a,x,ad,B)}}this.resetStyle(B);if(T){C(T);this.drawArrowHead(z,a,x,ad,W,M,d,false,B)}if(S){C(S);this.drawArrowHead(z,a,x,ad,W,M,d,true,B)}}}}}}else{this.resetDashDot(B);return false}}}}}}}this.resetDashDot(B)};this.drawArrowHead=function(v,c,t,b,u,l,h,e,q){if(!q){q=this.getCanvasContext()}var s=function(z,C,f,D){var w=[];for(var A=0;A<z.length;A++){w.push([(z[A][0]*Math.cos(C))-(z[A][1]*Math.sin(C)),(z[A][0]*Math.sin(C))+(z[A][1]*Math.cos(C))])}var B=[];for(var A=0;A<w.length;A++){B.push([w[A][0]+f,w[A][1]+D])}return B};var p=this.arrowPointSize;var d=Math.max((p/2)-1,1);var a=Math.max((p*2/3),1);var n=l?l/2:this.outlineWidth/2;var j=l?l*2:this.outlineWidth*2;var o=h==1?[[-n,-p],[-n,p]]:h==0?[[1.5,-0.5],[-p,-d*l],[-p,d*l]]:false;var m=t-v;var k=b-c;this.setStyle(u,h==1?l+2:l,false,q);if(h<2){var g=s(o,Math.atan2(k,m),t,b);q.beginPath();q.moveTo(g[0][0],g[0][1]);for(var r=1;r<g.length;r++){if(!isNaN(g[r][0])&&!isNaN(g[r][1])){q.lineTo(g[r][0],g[r][1])}}if(h==0){if(!isNaN(g[0][0])&&!isNaN(g[0][1])){q.lineTo(g[0][0],g[0][1])}q.closePath();q.fill()}else{q.closePath();q.stroke()}}else{if(h==2){q.beginPath();q.arc(t,b,Math.max(0,d*1.3),0,Math.PI*2,true);q.closePath();q.fill()}else{}}this.resetStyle(q)};this.createPatterns=function(b){var h=function(c){c.strokeStyle="rgb(29,137,182)";var j=[4,6,9,12,16,21,27,14,17,21,26];var l=[27,21,16,12,9,6,4,26,21,17,14];for(var k=0;k<j.length;k++){c.moveTo(j[k],l[k]);c.arc(j[k],l[k],2,0,Math.PI*2)}c.moveTo(3,32);c.arc(3,32,2,Math.PI,0);c.moveTo(13,32);c.arc(13,32,2,Math.PI,0);c.moveTo(32,3);c.arc(32,3,2,Math.PI*0.5,Math.PI*1.5);c.moveTo(32,13);c.arc(32,13,2,Math.PI*0.5,Math.PI*1.5);j=[[7,11],[8,12],[11,14],[14,17],[18,20],[22,24],[28,29]];l=[[28,29],[22,24],[18,20],[14,17],[11,14],[8,12],[7,11]];for(var k=0;k<j.length;k++){c.moveTo(j[k][0],l[k][0]);c.lineTo(j[k][1],l[k][1])}c.stroke()};var g=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(3,0);c.arc(3,0,2,Math.PI,0,true);c.moveTo(3,5);c.arc(3,5,2,Math.PI,0);c.moveTo(6,1);c.lineTo(8,4);c.lineTo(10,1);c.moveTo(13,0);c.arc(13,0,2,Math.PI,0,true);c.moveTo(13,5);c.arc(13,5,2,Math.PI,0);c.stroke()};var d=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(0,3);c.arc(0,3,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,3);c.arc(5,3,2,Math.PI*1.5,Math.PI*0.5,true);c.moveTo(1,6);c.lineTo(4,8);c.lineTo(1,10);c.moveTo(0,13);c.arc(0,13,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,13);c.arc(5,13,2,Math.PI*1.5,Math.PI*0.5,true);c.stroke()};if(!b){b=this.getCanvasContext()}var e;var f=this.$cX("canvas");f.width=5;f.height=5;var a=this.get2DCanvasContext(f);if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.hatchForward=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.hatchReverse=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeVertical")){f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();CanvasXpress.cachePatterns.stripeVertical=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeHorizontal")){a.clearRect(0,0,3,3);a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.stripeHorizontal=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("polkaDot")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.fill();CanvasXpress.cachePatterns.polkaDot=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossHatch")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.crossHatch=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossStripe")){f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.crossStripe=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squares")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.strokeRect(1,1,4,4);a.stroke();CanvasXpress.cachePatterns.squares=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("circles")){a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,1,0,Math.PI*2);a.stroke();CanvasXpress.cachePatterns.circles=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("plus")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.plus=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("minus")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.minus=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("bars")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();CanvasXpress.cachePatterns.bars=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesHorizontal")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,5);a.lineTo(2.5,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.squiglesHorizontal=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesVertical")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,2.5);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.squiglesVertical=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickForward")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(3,0);a.lineTo(0,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(2,5);a.lineTo(5,2);a.lineTo(5,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickForward=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickReverse")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(2,0);a.lineTo(5,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(0,5);a.lineTo(0,2);a.lineTo(3,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickReverse=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("art")){a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.moveTo(0,5);a.lineTo(5,0);a.stroke();CanvasXpress.cachePatterns.art=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("pcx")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(2,0);a.lineTo(0,0);a.lineTo(0,3);a.lineTo(2,3);a.stroke();a.beginPath();a.moveTo(3,3);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,3);a.lineTo(3,5);a.stroke();CanvasXpress.cachePatterns.pcx=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward3")){f.width=5;f.height=3;a.clearRect(0,0,5,3);a.beginPath();a.moveTo(0,0);a.lineTo(5,3);a.stroke();CanvasXpress.cachePatterns.hatchForward3=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse3")){a.clearRect(0,0,5,3);a.beginPath();a.moveTo(5,0);a.lineTo(0,3);a.stroke();CanvasXpress.cachePatterns.hatchReverse3=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTop")){f.width=5;f.height=16;a.clearRect(0,0,5,16);d(a);CanvasXpress.cachePatterns.membraneTop=b.createPattern(f,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBottom")){f.width=5;f.height=16;a.clearRect(0,0,5,16);a.translate(5,0);a.scale(-1,1);d(a);CanvasXpress.cachePatterns.membraneBottom=b.createPattern(f,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneRight")){f.width=16;f.height=5;a.clearRect(0,0,16,5);g(a);CanvasXpress.cachePatterns.membraneRight=b.createPattern(f,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneLeft")){f.width=16;f.height=5;a.clearRect(0,0,16,5);a.translate(0,5);a.scale(1,-1);g(a);CanvasXpress.cachePatterns.membraneLeft=b.createPattern(f,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTL")){f.width=32;f.height=32;a.clearRect(0,0,32,32);h(a);CanvasXpress.cachePatterns.membraneTL=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBL")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(0,32);a.scale(1,-1);h(a);CanvasXpress.cachePatterns.membraneBL=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTR")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,0);a.scale(-1,1);h(a);CanvasXpress.cachePatterns.membraneTR=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBR")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,32);a.scale(-1,-1);h(a);CanvasXpress.cachePatterns.membraneBR=b.createPattern(f,"no-repeat")}};this.sphere=function(f,e,d,m,h,g,F,E,D){var c=Math.sin(F);var A=Math.cos(F);var b=Math.sin(E);var x=Math.cos(E);var a=Math.sin(D);var v=Math.cos(D);var C=function(j){var k=j.y;j.y=(k*A)+(j.z*c*-1);j.z=(k*c)+(j.z*A);var i=j.x;j.x=(i*x)+(j.z*b*-1);j.z=(i*b)+(j.z*x);var i=j.x;j.x=(i*v)+(j.y*a*-1);j.y=(i*a)+(j.y*v)};var l=[];var n=Math.PI/12;var t=Math.PI*2;var r=Math.PI/2;for(var B=1;B>=-1;B-=2){for(var z=0;z<r;z+=n){var u=Math.cos(z)*m;var o=Math.cos(z)*g;var q=Math.sin(z)*h*B*-1;for(var w=0;w<t;w+=n){var s={x:(Math.cos(w)*u),y:q,z:(Math.sin(w)*o)};C(s);s.x+=f;s.y+=e;s.z+=d;if(B>0){l.push([s.x,s.y,s.z])}else{l.unshift([s.x,s.y,s.z])}}}}return l};this.roundedPolygon=function(h){var v=function(x,r,i){i.x=r.x-x.x;i.y=r.y-x.y;i.len=Math.sqrt(i.x*i.x+i.y*i.y);i.nx=i.x/i.len;i.ny=i.y/i.len;i.ang=Math.atan2(i.ny,i.nx)};var s=[];for(var t=0;t<h.length;t++){s.push({x:h[t][0],y:h[t][1]})}var m=[];var o=this.roundedPolygonRadius;var e={};var d={};var u=s.length;var c=s[u-1];for(var t=0;t<u;t++){var b=s[(t)%u];var a=s[(t+1)%u];v(b,c,e);v(b,a,d);var j=e.nx*d.ny-e.ny*d.nx;var p=e.nx*d.nx-e.ny*-d.ny;var w=Math.asin(j);var q=1;var f=false;if(p<0){if(w<0){w=Math.PI+w}else{w=Math.PI-w;q=-1;f=true}}else{if(w>0){q=-1;f=true}}var g;var n=w/2;var z=Math.abs(Math.cos(n)*o/Math.sin(n));if(z>Math.min(e.len/2,d.len/2)){z=Math.min(e.len/2,d.len/2);g=Math.abs(z*Math.sin(n)/Math.cos(n))}else{g=o}var l=b.x+d.nx*z;var k=b.y+d.ny*z;l+=-d.ny*g*q;k+=d.nx*g*q;m.push([l,k,g,e.ang+Math.PI/2*q,d.ang-Math.PI/2*q,f]);c=b;b=a}return m};this.drawShapeSetShapeStyle=function(j,i,k,d,e,c,b,a,g,l){if(!l){l=this.getCanvasContext()}this.saveCanvas(l);this.translateCanvas(j,i,l);if(a){this.rotateCanvas(a,l)}if(this.transparency!=null){e=this.addColorTransparency(e,this.transparency,true)}if(this.gradient){if(this.gradientType=="radial"){l.fillStyle=this.getGradient(0,0,Math.max(Math.abs(k),Math.abs(d)),false,e)}else{l.fillStyle=this.getGradient(0,0,k,d,e)}}else{if(b){switch(b){case"closed":case"solid":l.fillStyle=e;break;case"open":break;default:if(e){if(e.match(/0.1\)$/)&&c.match(/0.1\)$/)){l.globalAlpha=0.1}}l.fillStyle=CanvasXpress.cachePatterns[b]?CanvasXpress.cachePatterns[b]:e;break}}else{l.fillStyle=e}}l.strokeStyle=c?c:this.foreground;l.lineWidth=g?g:this.outlineWidth;l.lineJoin=this.joinType;if((k&&l.lineWidth>=k)||(d&&l.lineWidth>=d)){l.strokeStyle=e}this.setShadow(true,l)};this.drawShapeDraw=function(d,c,b){if(!b){b=this.getCanvasContext()}if(d&&d.length>1){var a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.beginPath();b.moveTo(a[0]+0.5,a[1]+0.5);while(d.length>0){a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.lineTo(a[0]+0.5,a[1]+0.5)}if(!c){b.closePath()}}};this.drawShapeFillStroke=function(b,d,c,a){if(!a){a=this.getCanvasContext()}if(c&&c=="open"){a.stroke()}else{if(d==b||a.strokeStyle==a.fillStyle){a.fill()}else{a.fill();a.stroke()}}};this.drawShapeRestore=function(a,d,c,b){if(!b){b=this.getCanvasContext()}b.globalAlpha=1;this.setShadow(false,b);if(c){}this.restoreCanvas(b)};this.getShapeArea=function(v,m,l,n,G,H,D,C,B,k,L,M,A,I,q,J){var j=this;var F=function(d){if(j.graphType=="Network"||v=="arrow"){return d}d.shift();var b=["poly"];var f=Math.cos(B);var c=Math.sin(B);for(var e=0;e<d.length;e+=2){b.push((f*(m-d[e]))+(c*(l-d[e+1]))+d[e]);b.push((f*(l-d[e+1]))-(c*(m-d[e]))+d[e+1])}return b};var g,a;var N=["poly"];var K=[];if(!M){M=this.setClipBoundaries()}switch(v){case"arc2":K=this.traceArc1(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m,l,G-n,A,I);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"pie":N.push(m,l);K=this.traceArc1(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"confidence":for(var E=0;E<m.length;E++){N.push(m[E][0],l[E][0]);K.push(l[E][1],m[E][1])}N=this.polygonClip(N.concat(K.reverse()),false,true);break;case"violin":case"fish":for(var E=0;E<m[0].length;E++){N.push(m[0][E],l[0][E]);K.push(l[1][E],m[1][E])}N=N.concat(K.reverse());break;case"bezier":K=this.traceBezierCurve(m[0],l[0],m[1],l[1],m[2],l[2],m[3],l[3],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceBezierCurve(m[0],l[0]+G,m[1],l[1]+G,m[2],l[2]+G,m[3],l[3]+G,0.25);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"arch":K=this.traceQuadraticCurve(m[0],l[0],m[1],l[1],m[2],l[2],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m[4],l[4],G[0],n[2],n[3]);for(var E=1;E<K.length;E++){N.push(K[E][0],K[E][1])}if(m[0]==m[3]&&l[0]==l[3]&&m[1]==m[4]&&l[1]==l[4]&&m[2]==m[5]&&l[2]==l[5]){break}K=this.traceQuadraticCurve(m[3],l[3],m[4],l[4],m[5],l[5],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc1(m[1],l[1],G[1],n[0],n[1]);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"polygon":case"roundpolygon":case"path":case"spline":case"hull":for(var E=0;E<m.length;E++){if(v=="spline"){N.push(m[E],l[E]-2)}else{N.push(m[E],l[E]-2);K.unshift(m[E],l[E]+2)}}break;default:g=n/2;a=G/2;break}switch(v){case"image":N=["rect",m-(g*this.zoom),l-(a*this.zoom),m+(g*this.zoom),l+(a*this.zoom)];break;case"path":N=N.concat(K);break;case"mdavid":case"star":case"circle":case"sphere":N=["circle",m,l,n];break;case"drop":case"teardrop":case"marker":N=["circle",m,l-n,g];break;case"diamond":case"rhombus":N=["poly",m,l-a,m+g,l,m,l+a,m-g,l];break;case"arrow":case"box":case"rect":case"rectangle":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":case"brace":case"square":case"pentagon":case"hexagon":case"octagon":case"oval":case"arc":case"arc3":case"ellipse":case"plus":case"minus":case"pch0":case"pch1":case"pch2":case"pch3":case"pch4":case"pch5":case"pch6":case"pch7":case"pch8":case"pch9":case"pch10":case"pch11":case"pch12":case"pch13":case"pch14":case"pch15":case"pch16":case"pch17":case"pch18":case"pch21":case"pch22":case"pch23":case"pch24":case"pch25":N=["rect",m-g,l-a,m+g,l+a];break;case"pch19":g+=2;a+=2;N=["rect",m-g,l-a,m+g,l+a];break;case"pch20":g-=2;a-=2;g=Math.max(2,g);a=Math.max(2,a);N=["rect",m-g,l-a,m+g,l+a];break;case"rect2":return this.getShapeArea("rectangle",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"rect3":return this.getShapeArea("rectangle",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"triangle":case"equilateral":N=["poly",m,l-a,m+g,l+a,m-g,l+a];break;case"triangle2":case"equilateral2":N=["poly",m,l+a,m+g,l-a,m-g,l-a];break;case"oval2":return this.getShapeArea("oval",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"oval3":return this.getShapeArea("oval",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"ellipse2":return this.getShapeArea("ellipse",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"ellipse3":return this.getShapeArea("ellipse",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"pie0":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/5,q,J);case"pie1":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/3.5,q,J);case"pie2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/2,q,J);case"pie3":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/1.5,q,J);case"pie4":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI,q,J);case"pie5":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.2,q,J);case"pie6":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.4,q,J);case"pie7":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.6,q,J);case"pie8":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.8,q,J);case"pie9":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*2,q,J);case"pacman":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*1/4,Math.PI*7/4,q,J);case"pacman2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*5/4,Math.PI*3/4,q,J)}N=B?F(N):N;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?N:this.adjustNetworkObjects(N)}else{return N}};this.drawShape=function(ab,W,V,Y,ap,aq,ag,af,ad,U,aw,ay,ac,at,Z,av,O){var T,ax,j,az,ae,aj;if(!O){O=this.getCanvasContext()}if(af){switch(af){case"closed":case"solid":case"open":break;default:var aA=af;af="closed";this.drawShape(ab,W,V,Y,ap,aq,aq,af,ad,U,aw,ay,ac,at,Z,av);af=aA;break}}switch(ab){case"polygon":case"roundpolygon":case"path":case"spline":case"arch":case"hull":case"confidence":case"violin":case"bezier":case"fish":var al=Number.MAX_VALUE;var R=Number.MAX_VALUE*-1;var ak=Number.MAX_VALUE;var P=Number.MAX_VALUE*-1;ax=[];T=[];if(W.length==V.length){if(ab=="spline"&&W.length<5){return this.drawShape("polygon",W,V,Y,ap,aq,ag,af,ad,U,aw,ay,ac,at,Z,av)}if(ab=="arch"&&(W.length!=6||V.length!=6||Y.length!=4||ap.length!=2)){return false}if(ab=="bezier"){if(this.isNumeric(W)&&this.isNumeric(V)&&this.isNumeric(ap)){for(var ao=0;ao<W.length;ao++){al=Math.min(al,W[ao]);R=Math.max(R,W[ao]);ak=Math.min(ak,V[ao]);P=Math.max(P,V[ao]);T.push([W[ao],V[ao]])}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0]-=W;T[ao][1]-=V;ax.push(T[ao][0],T[ao][1])}}else{return false}}else{if(ab=="confidence"){if(W.length>2){for(var ao=0;ao<W.length;ao++){if(W[ao][0]!=null&&W[ao][1]!=null&&V[ao][0]!=null&&V[ao][1]!=null&&this.isNumeric([W[ao][0],W[ao][1],V[ao][0],V[ao][1]])){al=Math.min(al,Math.min(W[ao][0],W[ao][1]));R=Math.max(R,Math.max(W[ao][0],W[ao][1]));ak=Math.min(ak,Math.min(V[ao][0],V[ao][1]));P=Math.max(P,Math.max(V[ao][0],V[ao][1]));T.push([[W[ao][0],W[ao][1]],[V[ao][0],V[ao][1]]])}}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0][0]-=W;T[ao][0][1]-=W;T[ao][1][0]-=V;T[ao][1][1]-=V;ax.push([T[ao][0][0],T[ao][0][1]],[T[ao][1][0],T[ao][1][1]])}}else{return false}}else{if(ab=="violin"||ab=="fish"){if(W[0].length==V[0].length&&W[1].length==V[1].length&&W[0].length==W[1].length){for(var ao=0;ao<W[0].length;ao++){if(this.isNumeric([W[0][ao],W[1][ao],V[0][ao],V[1][ao]])){al=Math.min(al,Math.min(W[0][ao],W[1][ao]));R=Math.max(R,Math.max(W[0][ao],W[1][ao]));ak=Math.min(ak,Math.min(V[0][ao],V[1][ao]));P=Math.max(P,Math.max(V[0][ao],V[1][ao]));T.push([[W[0][ao],W[1][ao]],[V[0][ao],V[1][ao]]])}}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0][0]-=W;T[ao][0][1]-=W;T[ao][1][0]-=V;T[ao][1][1]-=V;ax.push([T[ao][0][0],T[ao][0][1]],[T[ao][1][0],T[ao][1][1]])}}else{return false}}else{for(var ao=0;ao<W.length;ao++){if(W[ao]&&V[ao]&&this.isNumeric([W[ao],V[ao]])){al=Math.min(al,W[ao]);R=Math.max(R,W[ao]);ak=Math.min(ak,V[ao]);P=Math.max(P,V[ao]);T.push([W[ao],V[ao]])}}W=ab=="arch"?W[1]:(al+R)/2;V=ab=="arch"?V[1]:(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0]-=W;T[ao][1]-=V;ax.push(T[ao][0],T[ao][1])}}}}}else{return false}break;default:if(this.isNumeric([W,V,Y,ap])){if(aw){T=this.clip(ab,[W,V,Y,ap],ay);if(T){if(T.length==4){Y=Math.max(1,T[2]);ap=Math.max(1,T[3]);W=T[0]+(Y/2);V=T[1]+(ap/2)}else{if(T.length==2){W=T[0];V=T[1]}}}else{return false}}else{Y=Math.max(1,Y);ap=Math.max(1,ap)}j=Y/2;az=ap/2;ae=ap/Y;aj=1.5}else{return false}break}switch(ab){case"image":var N=Array.isArray(Z)?this.backgroundImageMD5:this.getFileName(Z);if(Z&&(CanvasXpress.cacheImages[N]||CanvasXpress.images[Z])){this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);if(CanvasXpress.images[Z]){this.drawImage(CanvasXpress.images[Z],-j*this.zoom,-az*this.zoom,Y*this.zoom,ap*this.zoom,false,false,false,false,aq,af,O)}else{this.drawImage(CanvasXpress.cacheImages[N],-j*this.zoom,-az*this.zoom,Y*this.zoom,ap*this.zoom,false,false,false,false,aq,af,O)}}else{return this.drawShape("rectangle",W,V,Y,ap,"rgba(0,0,0,0.5)","rgba(0,0,0,0.5)",af,ad,U,aw,ay,ac,at,Z,av)}break;case"circle":case"sphere":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);if(!this.isColorTransparent(aq,true)||!this.isColorTransparent(ag,true)){O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,false);O.closePath();this.drawShapeFillStroke(aq,ag,af,O)}break;case"drop":case"teardrop":case"marker":var F=j*2/3;var E=F*0.5;var S=this.graphType=="Map"?-F*3:0;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.arc(0,S,Math.max(0,j),0,Math.PI,true);O.bezierCurveTo(-j,S+j,0,S+E,0,S+(F*3));O.bezierCurveTo(0,S+E,j,S+j,j,S);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);O.beginPath();O.arc(0,S,Math.max(0,j*0.3),0,Math.PI*2,true);O.closePath();this.drawShapeFillStroke("white","black",af,O);break;case"arrow":T=[[-j,-az],[j,-az],[j,az],[-j,az]];if(ad){ad=false;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);var F=ap/4;O.beginPath();O.moveTo(j-ap,-az);O.lineTo(j-ap,-az-F);O.lineTo(j,0);O.lineTo(j-ap,az+F);O.lineTo(j-ap,az);O.lineTo(-j,az);O.lineTo(-j,-az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O)}else{this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);var q=Y/4;O.beginPath();O.moveTo(-j,-az+Y);O.lineTo(-j-q,-az+Y);O.lineTo(0,-az);O.lineTo(j+q,-az+Y);O.lineTo(j,-az+Y);O.lineTo(j,az);O.lineTo(-j,az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O)}break;case"box":case"rect":T=[[-j,-az],[j,-az],[j,az],[-j,az]];this.drawShapeSetShapeStyle(Math.round(W),Math.round(V),Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az);O.lineTo(j,-az);O.lineTo(j,az);O.lineTo(-j,az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"rectangle":T=[[-j,-az],[j,-az],[j,az],[-j,az]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);if(af&&af=="open"){O.strokeRect(-j,-az,Y,ap)}else{if(ag==aq||O.strokeStyle==O.fillStyle){O.fillRect(-j,-az,Y,ap)}else{O.fillRect(-j,-az,Y,ap);O.strokeRect(-j,-az,Y,ap)}}break;case"rect2":return this.drawShape("rectangle",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,ac,at,Z,av);break;case"rect3":return this.drawShape("rectangle",W,V,Y,Y/3,aq,ag,af,ad,U,aw,ay,ac,at,Z,av);break;case"roundrectt":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az+X);O.lineTo(-j,az);O.lineTo(j,az);O.lineTo(j,-az+X);O.quadraticCurveTo(j,-az,j-X,-az);O.lineTo(-j+X,-az);O.quadraticCurveTo(-j,-az,-j,-az+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectb":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az);O.lineTo(-j,az-X);O.quadraticCurveTo(-j,az,-j+X,az);O.lineTo(j-X,az);O.quadraticCurveTo(j,az,j,az-X);O.lineTo(j,-az);O.lineTo(-j,-az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az);O.lineTo(-j,az);O.lineTo(j-X,az);O.quadraticCurveTo(j,az,j,az-X);O.lineTo(j,-az+X);O.quadraticCurveTo(j,-az,j-X,-az);O.lineTo(-j,-az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az+X);O.lineTo(-j,az-X);O.quadraticCurveTo(-j,az,-j+X,az);O.lineTo(j,az);O.lineTo(j,-az);O.lineTo(-j+X,-az);O.quadraticCurveTo(-j,-az,-j,-az+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrecttr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az);O.lineTo(-j,az);O.lineTo(j,az);O.lineTo(j,-az+X);O.quadraticCurveTo(j,-az,j-X,-az);O.lineTo(-j,-az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrecttl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az+X);O.lineTo(-j,az);O.lineTo(j,az);O.lineTo(j,-az);O.lineTo(-j+X,-az);O.quadraticCurveTo(-j,-az,-j,-az+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectbr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az);O.lineTo(-j,az);O.lineTo(j-X,az);O.quadraticCurveTo(j,az,j,az-X);O.lineTo(j,-az);O.lineTo(-j,-az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrectbl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az);O.lineTo(-j,az-X);O.quadraticCurveTo(-j,az,-j+X,az);O.lineTo(j,az);O.lineTo(j,-az);O.lineTo(-j,-az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrecto":var X=Y<ap?j:az;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();if(Y<ap){O.arc(0,-az+X,X,Math.PI,0);O.lineTo(j,az-X);O.arc(0,az-X,X,0,Math.PI);O.lineTo(-j,-az+X)}else{O.arc(-j+X,0,X,Math.PI*0.5,Math.PI*1.5);O.lineTo(j-X,-az);O.arc(j-X,0,X,Math.PI*1.5,Math.PI*0.5);O.lineTo(-j+X,az)}O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"roundrect":case"roundrect2":case"roundrectd":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap/4:Y/4;if(ab=="roundrect2"){X*=4}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az+X);O.lineTo(-j,az-X);O.quadraticCurveTo(-j,az,-j+X,az);O.lineTo(j-X,az);O.quadraticCurveTo(j,az,j,az-X);O.lineTo(j,-az+X);O.quadraticCurveTo(j,-az,j-X,-az);O.lineTo(-j+X,-az);O.quadraticCurveTo(-j,-az,-j,-az+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);if(ab=="roundrectd"&&Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius){Y-=this.roundedPolygonRadius;ap-=this.roundedPolygonRadius;j=Y/2;az=ap/2;O.beginPath();O.moveTo(-j,-az+X);O.lineTo(-j,az-X);O.quadraticCurveTo(-j,az,-j+X,az);O.lineTo(j-X,az);O.quadraticCurveTo(j,az,j,az-X);O.lineTo(j,-az+X);O.quadraticCurveTo(j,-az,j-X,-az);O.lineTo(-j+X,-az);O.quadraticCurveTo(-j,-az,-j,-az+X);O.closePath();this.drawShapeFillStroke(aq,ag,af,O)}break;case"brace":var X=Y>ap?ap/4:Y/4;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-j,-az);O.bezierCurveTo(-j,0,0,0,0,az);O.bezierCurveTo(0,0,j,0,j,-az);this.drawShapeFillStroke(aq,ag,af,O);break;case"square":T=[[-j,-j],[j,-j],[j,j],[-j,j]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"triangle":if(Y==ap){return this.drawShape("equilateral",W,V,Y,ap,aq,ag,af,ad,U,aw,ay,ac,at,Z,av)}T=[[0,-az],[j,az],[-j,az]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"triangle2":if(Y==ap){return this.drawShape("equilateral2",W,V,Y,ap,aq,ag,af,ad,U,aw,ay,ac,at,Z,av)}T=[[0,az],[j,-az],[-j,-az]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"equilateral":var X=Y*Math.sqrt(3)/6;var g=X/2;var H=Math.sqrt((X*X)-(g*g));T=[[0,-az],[j,az],[-j,az]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"equilateral2":var X=Y*Math.sqrt(3)/6;var g=X/2;var H=Math.sqrt((X*X)-(g*g));T=[[0,az],[j,-az],[-j,-az]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"diamond":case"rhombus":T=[[0,-az],[j,0],[0,az],[-j,0]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"hexagon":var au=Y/3;var v=au-j;T=[[v,-az],[-v,-az],[j,0],[-v,az],[v,az],[-j,0]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"pentagon":var au=Y/3;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();for(var ao=0;ao<5;ao++){var G=(ao/5)*Math.PI*2+(-Math.PI/2);O.lineTo(Math.cos(G)*au,Math.sin(G)*au)}O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"octagon":var aB=Y/4;var an=ap/4;T=[[-aB,-az],[aB,-az],[j,-an],[j,an],[aB,az],[-aB,az],[-j,an],[-j,-an]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"oval":case"ovald":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,true);O.closePath();this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);if(ab=="ovald"){Y-=this.margin*2;ap-=this.margin*2;ae=ap/Y;this.saveCanvas(O);this.scaleCanvas(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,true);O.closePath();this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O)}break;case"oval2":return this.drawShape("oval",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,ac,at,Z,av);break;case"oval3":return this.drawShape("oval",W,V,Y,Y/3,aq,ag,af,ad,U,aw,ay,ac,at,Z,av);break;case"arc":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI,true);if(af!="open"){O.closePath()}this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);break;case"arc2":var J=ap*Math.cos(ac);var aE=ap*Math.sin(ac);var I=ap*Math.cos(at);var aC=ap*Math.sin(at);var D=this.shortenLine(0,0,J,aE,0,Y,"line");var B=this.shortenLine(0,0,I,aC,0,Y,"line");this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(D[2],D[3]);O.lineTo(J,aE);O.arc(0,0,Math.max(0,ap),ac,at,false);O.lineTo(B[2],B[3]);O.arc(0,0,Math.max(0,ap-Y),at,ac,true);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"arc3":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI,true);this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);break;case"arch":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(T[0][0],T[0][1]);O.quadraticCurveTo(T[1][0],T[1][1],T[2][0],T[2][1]);O.arc(0,0,Math.max(0,ap[0]),Y[3],Y[2],true);O.quadraticCurveTo(T[4][0],T[4][1],T[5][0],T[5][1]);O.arc(0,0,Math.max(0,ap[1]),Y[1],Y[0],true);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"path":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T,af=="open");this.drawShapeFillStroke(aq,ag,af,O);break;case"roundpolygon":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);T=this.roundedPolygon(T);O.beginPath();for(var ao=0;ao<T.length;ao++){O.arc(T[ao][0],T[ao][1],T[ao][2],T[ao][3],T[ao][4])}O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"polygon":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T,af=="open");this.drawShapeFillStroke(aq,ag,af,O);break;case"spline":var aa=[];var ai=[];var K=[];ai.push(ax.shift());ai.push(ax.shift());K.push(ax.pop());K.unshift(ax.pop());var ah=ax.length;for(var ao=0;ao<ah-4;ao+=2){aa=aa.concat(this.splineControlPoint(ax[ao],ax[ao+1],ax[ao+2],ax[ao+3],ax[ao+4],ax[ao+5]))}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ai[0],ai[1]);O.lineTo(ax[0],ax[1]);O.quadraticCurveTo(aa[0],aa[1],ax[2],ax[3]);for(var ao=2;ao<ah-5;ao+=2){O.bezierCurveTo(aa[2*ao-2],aa[2*ao-1],aa[2*ao],aa[2*ao+1],ax[ao+2],ax[ao+3])}O.quadraticCurveTo(aa[2*ah-10],aa[2*ah-9],ax[ah-2],ax[ah-1]);O.lineTo(K[0],K[1]);O.lineTo(ai[0],ai[1]);this.drawShapeFillStroke(aq,ag,af,O);break;case"hull":var am;var ah=1;var L=[];while(ax.length>1){L.push([ax.shift(),ax.shift()])}var aa=this.hullControlPoints(L);var m=[[L[0][0],L[0][1],aa[aa.length-1][0],aa[aa.length-1][1],aa[0][0],aa[0][1],L[1][0],L[1][1]]];for(var ao=1;ao<L.length-1;ao++){m.push([L[ao][0],L[ao][1],aa[ah][0],aa[ah][1],aa[ah+1][0],aa[ah+1][1],L[ao+1][0],L[ao+1][1]]);ah+=2}m.push([L[ao][0],L[ao][1],aa[ah][0],aa[ah][1],aa[ah+1][0],aa[ah+1][1],L[0][0],L[0][1]]);this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(m[0][0],m[0][1]);for(var ao=0;ao<m.length;ao++){O.bezierCurveTo(m[ao][2],m[ao][3],m[ao][4],m[ao][5],m[ao][6],m[ao][7])}this.drawShapeFillStroke(aq,ag,af,O);break;case"violin":var ah=ax.length;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ax[0][0],ax[1][0]);for(var ao=2;ao<ah;ao+=2){O.lineTo(ax[ao][0],ax[ao+1][0])}O.lineTo(ax[ah-2][1],ax[ah-1][1]);for(var ao=2;ao<ah;ao+=2){var aD=(ah-1)-ao;O.lineTo(ax[aD-1][1],ax[aD][1])}O.lineTo(ax[0][0],ax[1][0]);this.drawShapeFillStroke(aq,ag,af,O);break;case"fish":var ah=ax.length;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ax[0][0],ax[1][0]);for(var ao=2;ao<ah;ao+=2){var A=(ax[ao-2][0]+ax[ao][0])/2;O.bezierCurveTo(A,ax[ao-1][0],A,ax[ao+1][0],ax[ao][0],ax[ao+1][0])}O.lineTo(ax[ah-2][1],ax[ah-1][1]);for(var ao=2;ao<ah;ao+=2){var aD=(ah-1)-ao;var A=(ax[aD+1][1]+ax[aD-1][1])/2;O.bezierCurveTo(A,ax[aD+2][1],A,ax[aD][1],ax[aD-1][1],ax[aD][1])}O.lineTo(ax[0][0],ax[1][0]);this.drawShapeFillStroke(aq,ag,af,O);break;case"confidence":var ah=ax.length;var aa=[];var Q=[];for(var ao=0;ao<ah-4;ao+=2){var aD=(ah-1)-ao;aa=aa.concat(this.splineControlPoint(ax[ao][0],ax[ao+1][0],ax[ao+2][0],ax[ao+3][0],ax[ao+4][0],ax[ao+5][0]));Q=Q.concat(this.splineControlPoint(ax[aD-1][1],ax[aD][1],ax[aD-3][1],ax[aD-2][1],ax[aD-5][1],ax[aD-4][1]))}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ax[0][0],ax[1][0]);O.quadraticCurveTo(aa[0],aa[1],ax[2][0],ax[3][0]);for(var ao=2;ao<ah-5;ao+=2){O.bezierCurveTo(aa[2*ao-2],aa[2*ao-1],aa[2*ao],aa[2*ao+1],ax[ao+2][0],ax[ao+3][0])}O.quadraticCurveTo(aa[2*ah-10],aa[2*ah-9],ax[ah-2][0],ax[ah-1][0]);O.lineTo(ax[ah-2][1],ax[ah-1][1]);O.quadraticCurveTo(Q[0],Q[1],ax[ah-4][1],ax[ah-3][1]);for(var ao=2;ao<ah-5;ao+=2){var aD=(ah-1)-ao;O.bezierCurveTo(Q[2*ao-2],Q[2*ao-1],Q[2*ao],Q[2*ao+1],ax[aD-3][1],ax[aD-2][1])}O.quadraticCurveTo(Q[2*ah-10],Q[2*ah-9],ax[0][1],ax[1][1]);O.lineTo(ax[0][0],ax[1][0]);this.drawShapeFillStroke(aq,ag,af,O);break;case"bezier":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ax[0],ax[1]);O.bezierCurveTo(ax[2],ax[3],ax[4],ax[5],ax[6],ax[7]);O.lineTo(ax[6],ax[7]+ap);O.bezierCurveTo(ax[4],ax[5]+ap,ax[2],ax[3]+ap,ax[0],ax[1]+ap);O.lineTo(ax[0],ax[1]);this.drawShapeFillStroke(aq,ag,af,O);break;case"ellipse":var a=j*0.5522848;var ar=az*0.5522848;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(0,az);O.bezierCurveTo(0,az-ar,j-a,0,j,0);O.bezierCurveTo(j+a,0,Y,az-ar,Y,az);O.bezierCurveTo(Y,az+ar,j+a,ap,j,ap);O.bezierCurveTo(j-a,ap,0,az+ar,0,az);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"ellipse2":return this.drawShape("ellipse",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,ac,at,Z,av);break;case"ellipse3":return this.drawShape("ellipse",W,V,Y,Y/3,aq,ag,af,ad,U,aw,ay,ac,at,Z,av);break;case"plus":T=[[-aj,-az],[aj,-az],[aj,-aj],[j,-aj],[j,aj],[aj,aj],[aj,az],[-aj,az],[-aj,aj],[-j,aj],[-j,-aj],[-aj,-aj],[-aj,-az]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"minus":T=[[-j,-aj],[j,-aj],[j,aj],[-j,aj],[-j,-aj]];this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.drawShapeDraw(T);this.drawShapeFillStroke(aq,ag,af,O);break;case"mdavid":var au=Y/3;var C=Math.PI/6;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(0.8,0.8,O);this.rotateCanvas(M*0.45,O);O.beginPath();O.moveTo(au,0);for(var ao=0;ao<11;ao++){this.rotateCanvas(C,O);if(ao%2==0){O.lineTo((au/0.55),0)}else{O.lineTo(au,0)}}O.closePath();this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);break;case"star":var k=(Y/4);var M=Math.PI/5;this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);this.saveCanvas(O);this.scaleCanvas(0.7,0.7,O);this.rotateCanvas(M*0.45,O);O.beginPath();O.moveTo(k,0);for(var ao=0;ao<9;ao++){this.rotateCanvas(M,O);if(ao%2==0){O.lineTo((k/0.35),0)}else{O.lineTo(k,0)}}O.closePath();this.restoreCanvas(O);this.drawShapeFillStroke(aq,ag,af,O);break;case"pie":if(typeof(ac)=="undefined"){ac=0}if(typeof(at)=="undefined"){at=Math.PI*2}this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),ac,at,false);O.lineTo(0,0);O.closePath();this.drawShapeFillStroke(aq,ag,af,O);break;case"pie0":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI/5,Z,av);break;case"pie1":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI/3.5,Z,av);break;case"pie2":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI/2,Z,av);break;case"pie3":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI/1.5,Z,av);break;case"pie4":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI,Z,av);break;case"pie5":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI*1.2,Z,av);break;case"pie6":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI*1.4,Z,av);break;case"pie7":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI*1.6,Z,av);break;case"pie8":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI*1.8,Z,av);break;case"pie9":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,0,Math.PI*2,Z,av);break;case"pacman":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,Math.PI*1/4,Math.PI*7/4,Z,av);break;case"pacman2":return this.drawShape("pie",W,V,Y,Y/2,aq,ag,af,ad,U,aw,ay,Math.PI*5/4,Math.PI*3/4,Z,av);break;case"pch0":this.drawShape("square",W,V,Y,Y,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch1":this.drawShape("circle",W,V,Y,Y,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch2":this.drawShape("equilateral",W,V,Y,Y,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch3":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,"open",false,U,O);O.moveTo(0,-az);this.lineTo(0,-az,0,az,O);O.stroke();O.moveTo(-j,0);this.lineTo(-j,0,j,0,O);O.stroke();this.drawShapeFillStroke(aq,ag,af,O);break;case"pch4":this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,"open",false,U,O);O.moveTo(-j,-az);this.lineTo(-j,-az,j,az,O);O.stroke();O.moveTo(j,-az);this.lineTo(j,-az,-j,az,O);O.stroke();this.drawShapeFillStroke(aq,ag,af,O);break;case"pch5":this.drawShape("diamond",W,V,Y,Y,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch6":this.drawShape("equilateral2",W,V,Y,Y,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch7":this.drawShape("pch0",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);this.drawShape("pch4",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch8":this.drawShape("pch3",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);this.drawShape("pch4",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch9":this.drawShape("pch3",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);this.drawShape("pch5",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch10":this.drawShape("pch1",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);this.drawShape("pch3",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch11":this.drawShape("pch2",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);this.drawShape("pch6",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch12":this.drawShape("pch0",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);this.drawShape("pch3",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch13":this.drawShape("pch1",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);this.drawShape("pch4",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch14":this.drawShape("pch0",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);this.drawShape("pch6",W,V,Y,ap,aq,ag,"open",false,U,aw,ay,ac,at,Z,av);break;case"pch15":case"pch22":this.drawShape("square",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,aw,ay,ac,at,Z,av);break;case"pch16":case"pch21":this.drawShape("circle",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,aw,ay,ac,at,Z,av);break;case"pch17":case"pch24":this.drawShape("equilateral",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,aw,ay,ac,at,Z,av);break;case"pch18":case"pch23":this.drawShape("diamond",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,aw,ay,ac,at,Z,av);break;case"pch19":this.drawShape("circle",W,V,Y+2,Y+2,aq||this.foreground,ag,"closed",false,U,aw,ay,ac,at,Z,av);break;case"pch20":this.drawShape("circle",W,V,Math.max(2,Y-2),Math.max(2,Y-2),aq||this.foreground,ag,"closed",false,U,aw,ay,ac,at,Z,av);break;case"pch25":this.drawShape("equilateral2",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,aw,ay,ac,at,Z,av);break;default:this.drawShapeSetShapeStyle(W,V,Y,ap,aq,ag,af,ad,U,O);break}if(ab=="box"||ab=="rect"){this.drawShapeRestore(Math.round(W),Math.round(V),ad,O)}else{this.drawShapeRestore(W,V,ad,O)}};this.imageToCanvas=function(a){var b=this.$cX("canvas",{width:a.naturalWidth,height:a.naturalHeight});b.ctx=this.get2DCanvasContext(b);b.ctx.drawImage(a,0,0);return b};this.colorizeImage=function(e,k){var m=this.imageToCanvas(e);var b=k?this.colorAsArray(k):false;var j=m.ctx.getImageData(0,0,e.naturalWidth,e.naturalHeight);var l=j.data;for(var e=0;e<l.length;e+=4){var h=0.34*l[e]+0.5*l[e+1]+0.16*l[e+2];if(h>220){h=255;l[e]=h;l[e+1]=h;l[e+2]=h;l[e+3]=0}else{l[e]=k?b[0]:h;l[e+1]=k?b[1]:h;l[e+2]=k?b[2]:h}}m.ctx.putImageData(j,0,0);return m};this.createImage=function(l){var k=l.length;var q=l[0].length;var n=this.$cX("canvas",{width:q,height:k});n.ctx=this.get2DCanvasContext(n);n.ctx.clearRect(0,0,q,k);for(var f=0;f<k;f++){var s=k-(f+1);for(var e=0;e<q;e++){var d=parseInt(l[s][e][0]*255);var m=parseInt(l[s][e][1]*255);var o=parseInt(l[s][e][2]*255);var p=l[s][e][3]?parseInt(l[s][e][3]*255):255;n.ctx.fillStyle="rgba("+d+","+m+","+o+","+p+")";if(this.scatterType=="visium"&&this.visiumFlip){n.ctx.fillRect(e,f,1,1)}else{n.ctx.fillRect(e,s,1,1)}}}if(this.scatterType=="visium"){this.backgroundImageRows=k;this.backgroundImageCols=q}return n.toDataURL("img/png")};this.drawImage=function(x,v,m,j,y,D,s,p,F,g,o,u){if(!u){u=this.getCanvasContext()}try{v=parseInt(Math.round(v||0));m=parseInt(Math.round(m||0));j=parseInt(Math.round(j||x.naturalWidth));y=parseInt(Math.round(y||x.naturalHeight));if(this.scatterType=="visium"){if(this.visiumFlip){var A=this.xAxisMin;var z=this.xAxisMax;var b=x.naturalHeight-this.yAxisMax;var c=x.naturalHeight-this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=this.yAxisMax;u.scale(a,G);u.drawImage(x,A,n,f,E,v+k,m+B,f,E);u.scale(1/a,1/G)}else{var A=this.xAxisMin;var z=this.xAxisMax;var b=this.yAxisMax;var c=this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=x.naturalHeight-this.yAxisMax;u.scale(a,G);u.drawImage(x,A,n,f,E,v+k,m+B,f,E);u.scale(1/a,1/G)}}else{if(D&&s&&p&&F){D=parseInt(Math.round(D));s=parseInt(Math.round(s));p=parseInt(Math.round(p));F=parseInt(Math.round(F));u.drawImage(x,v,m,j,y,D,s,p,F);u.drawImage(this.colorizeImage(x,g),v,m,j,y,D,s,p,F)}else{if(g&&g=="b&w"){u.drawImage(this.colorizeImage(x),v,m,j,y)}else{if(g){u.drawImage(x,v,m,j,y);u.drawImage(this.colorizeImage(x,g),v,m,j,y)}else{if(o){var q=Math.max(j,y)/2;this.saveCanvas(u);u.arc(v+q,m+q,q,0,Math.PI*2);u.clip();u.drawImage(x,v,m,j,y);this.restoreCanvas(u);this.setClipArea([0,0,0,0],u);this.restoreCanvas(u)}else{u.drawImage(x,v,m,j,y)}}}}}}catch(C){console.log(C);var d=this;setTimeout(function(){d.draw({func:"drawImage",par:[x,v,m,j,y,D,s,p,F,g]})},100)}};this.trackTransforms=function(k){if(!k){k=this.getCanvasContext()}var f=document.createElementNS("http://www.w3.org/2000/svg","svg");var i=f.createSVGMatrix();k.getTransform=function(){return i};var j=[];var g=k.save;k.save=function(){j.push(i.translate(0,0));return g.call(k)};var h=k.restore;k.restore=function(){i=j.pop();return h.call(k)};var c=k.scale;k.scale=function(n,m){i=i.scaleNonUniform(n,m);return c.call(k,n,m)};var d=k.rotate;k.rotate=function(m){i=i.rotate(m*180/Math.PI);return d.call(k,m)};var b=k.translate;k.translate=function(n,m){i=i.translate(n,m);return b.call(k,n,m)};var a=k.transform;k.transform=function(n,m,s,r,q,p){var o=f.createSVGMatrix();o.a=n;o.b=m;o.c=s;o.d=r;o.e=q;o.f=p;i=i.multiply(o);return a.call(k,n,m,s,r,q,p)};var e=k.setTransform;k.setTransform=function(n,m,r,q,p,o){i.a=n;i.b=m;i.c=r;i.d=q;i.e=p;i.f=o;return e.call(k,n,m,r,q,p,o)};var l=f.createSVGPoint();k.transformedPoint=function(m,n){l.x=m;l.y=n;return l.matrixTransform(i.inverse())}};this.setGlobalCompositionOperation=function(b,a){if(!CanvasXpress.system.isIE&&b){if(!a){a=this.getCanvasContext()}a.globalCompositeOperation=b;this.meta.state.globalCompositeOperation=b}};this.rectangleClear=function(a,e,c,d,b){if(!b){b=this.getCanvasContext()}b.clearRect(a,e,c,d)};this.translateCanvas=function(a,c,b){if(!b){b=this.getCanvasContext()}b.translate(a,c);this.meta.state.translate[0]+=a;this.meta.state.translate[1]+=c};this.rotateCanvas=function(b,a){if(!a){a=this.getCanvasContext()}a.rotate(b);this.meta.state.rotate[0]+=b};this.scaleCanvas=function(a,c,b){if(!b){b=this.getCanvasContext()}b.scale(a,c);this.meta.state.scale[0]*=a;this.meta.state.scale[1]*=c};this.saveCanvas=function(a){if(!a){a=this.getCanvasContext()}a.save();this.meta.state.save++;this.meta.state.last={translate:[this.meta.state.translate[0],this.meta.state.translate[1]],scale:[this.meta.state.scale[0],this.meta.state.scale[1]],rotate:[this.meta.state.rotate[0]]}};this.restoreCanvas=function(a){if(!a){a=this.getCanvasContext()}a.restore();this.meta.state.translate[0]=this.meta.state.last.translate[0];this.meta.state.translate[1]=this.meta.state.last.translate[1];this.meta.state.scale[0]=this.meta.state.last.scale[0];this.meta.state.scale[1]=this.meta.state.last.scale[1];this.meta.state.rotate[0]=this.meta.state.last.rotate[0];this.meta.state.save--}};CanvasXpress.prototype.initRangeAlgorithms=function(){this.heckbert=function(d,k,b){var c=function(i,m){var o;var p=Math.floor(Math.log(i)/Math.LN10);var n=i/Math.pow(10,p);if(m){if(n<1.5){o=1}else{if(n<3){o=2}else{if(n<7){o=5}else{o=10}}}}else{if(n<1){o=1}else{if(n<2){o=2}else{if(n<5){o=5}else{o=10}}}}return o*Math.pow(10,p)};if(d>k){var f=k;d=k;d=f}else{if(k-d<1e-8){k+=0.1}}var j=[];var g=c(k-d,false);var l=c(g/(b-1),true);var a=Math.floor(d/l)*l;var h=Math.ceil(k/l)*l;for(var e=a;e<=h;e+=l){j.push(this.approx(e))}if(j[0]==j[j.length-1]){var j=[];for(var e=a;e<=h;e+=l){j.push(e)}}return this.cleanVals(j)};this.wilkinson=function(c,h,a){var b=function(z,B,A,y){var u=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var w=B-z;var r=A-1;var o=1-Math.abs(A-y)/y;var D=w/r;var t=Math.floor(Math.log(D)/Math.LN10);var E=Math.pow(10,t);var p=null;for(var C=0;C<u.length;C++){var s=u[C]*E;var F=Math.floor(z/s)*s;var n=F+r*s;if(F<=z&&n>=B){var v=1-(C-(F<=0&&n>=0?1:0))/u.length;var q=(B-z)/(n-F);if(q>0.8){var x=o+v+q;if(p==null||x>p.score){p={lmin:F,lmax:n,lstep:s,score:x}}}}}if(!p){p={lmin:z,lmax:B,lstep:1,score:0}}return p};if(c>h){var g=h;c=h;c=g}else{if(h-c<1e-8){h+=0.1}}var j=[];var e=null;var l=[];for(var f=Math.max(Math.floor(a/2),2);f<=Math.ceil(6*a);f++){l.push(f)}for(var f=0;f<l.length;f++){var d=l[f];var m=b(c,h,d,a);if((m!=null&&e==null)||(m&&e&&m.score>e.score)){e=m}}for(var f=e.lmin;f<=e.lmax;f+=e.lstep){j.push(this.approx(f))}if(j[0]==j[j.length-1]){var j=[];for(var f=e.lmin;f<=e.lmax;f+=e.lstep){j.push(f)}}return this.cleanVals(j)};this.wilkinsonExtended=function(a,y,R,C){var A=2.22e-14;var f=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var J=function(c,w,m,g,z,Y){var k=w.length;var s=f(c,w);var Z=(g%Y<A||Y-(g%Y)<A)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+Z};var K=function(s,m,g){var w=m.length;var k=f(s,m);var c=1;return 1-k/(w-1)-g+c};var h=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var r=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var o=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var X=function(g,c){return g>=c?2-(g-1)/(c-1):1};var e=[1,5,2,2.5,4,3];var G=[0.25,0.2,0.5,0.05];var P=e.length;var L={score:-2};var H=[];if(a>y){var l=a;a=y;y=l}else{if(y-a<1e-8){y+=0.1}}if(y-a<A){for(var U=0;U<=R;U++){H.push(a)}return H}var T=1;while(T<Number.POSITIVE_INFINITY){for(var U=0;U<P;U++){var N=e[U];var u=K(N,e,T);if((G[0]*u+G[1]+G[2]+G[3]<L.score)){T=Number.POSITIVE_INFINITY;break}var S=2;while(S<Number.POSITIVE_INFINITY){var p=X(S,R);if((G[0]*u+G[1]+G[2]*p+G[3]<L.score)){break}var E=(y-a)/(S+1)/T/N;var F=Math.ceil(Math.log(E)/Math.LN10);while(F<Number.POSITIVE_INFINITY){var D=T*N*Math.pow(10,F);var B=r(a,y,D*(S-1));if((G[0]*u+G[1]*B+G[2]*p+G[3]<L.score)){break}var v=Math.floor(y/D)*T-(S-1)*T;var O=Math.ceil(a/D)*T;if(v>O){F++;continue}for(var x=v;x<=O;x++){var t=x*(D/T);var M=t+D*(S-1);var d=D;var I=J(N,e,T,t,M,d);var W=h(a,y,t,M);var V=o(S,R,a,y,t,M);var b=G[0]*I+G[1]*W+G[2]*V+G[3];if(b>L.score&&(!C||(t<=a&&M>=y))){L={lmin:t,lmax:M,lstep:d,score:b}}}F++}S++}}T++}for(var U=L.lmin;U<=L.lmax;U+=L.lstep){H.push(this.approx(U))}if(H[0]==H[H.length-1]){var H=[];for(var U=L.lmin;U<=L.lmax;U+=L.lstep){H.push(U)}}return this.cleanVals(H)};this.rPretty=function(o,p,r){if(o>p){var w=p;o=p;o=w}else{if(p-o<1e-8){p+=0.1}}var a,e,b;var l=[];var q=Math.floor(r)-1;var s=Math.floor(q%3);var g=0.75;var v=1.5;var d=0.5+1.5*v;var f=p-o;if(f==0&&p==0){a=1;e=true;b=1}else{a=Math.max(Math.abs(o),Math.abs(p));b=1+d>=1.5*v+0.5?1/(1+v):1.5/1+d;e=f<(a*b*Math.max(1,q)*1e-7*3)}if(e){if(a>10){a=9+a/10}a=a*g;if(s>1){a/=s}}else{a=f;if(q>1){a/=q}}if(a<20*1e-7){a=20*1e-7}var c=Math.pow(10,Math.floor(Math.log(a)/Math.LN10));var j=c;if((2*c)-a<v*(a-j)){j=2*c;if((5*c)-a<d*(a-j)){j=5*c;if((10*c)-a<v*(a-j)){j=10*c}}}var y=Math.floor(o/j+1e-7);var x=Math.ceil(p/j-1e-7);while(y*j>o+(1e-7*j)){y--}while(x*j<p-(1e-7*j)){x++}var t=Math.floor(0.5+x-y);if(t<s){t=s-t;if(y>=0){x+=t/2;y=y-t/2+t%2}else{y-=t/2;x=x+t/2+t%2}q=s}else{q=t}for(var u=y*j;u<=x*j;u+=j){l.push(this.approx(u))}if(l[0]==l[l.length-1]){var l=[];for(var u=y*j;u<=x*j;u+=j){l.push(u)}}return this.cleanVals(l)};this.cleanVals=function(c){var b=[];if(c.length>1){var f=0;for(var a=0;a<c.length;a++){var e=this.getAxisDecimals(c[a]);if(e<8){f=Math.max(f,e)}}for(var a=0;a<c.length;a++){b.push(Number(this.formatNumber(c[a],f)))}}return b};this.getAxisDecimals=function(a){a=this.approx(a).toString();return a.indexOf(".")>=0?Math.min(Number(a.length-(a.indexOf(".")+1)),20):0}};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes();this.initRangeAlgorithms()};CanvasXpress.prototype.initGeneralUtils=function(){this.modifyObjectArray=function(c,g,h,f,j){if(this.isTransition()){return}var e=this[h];if(f){var a={};if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=true}}else{a[c]=true}for(var d in a){if(e.includes(d)){e=this.removeFromArray(d,e);delete (a[d])}}for(var d in a){e.push(d)}this[h]=e}else{if(g){var a={};var k=[];if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=1}}else{a[c]=1}var b=e.length;for(var d=0;d<b;d++){if(!a.hasOwnProperty(e[d])){k.push(e[d])}}this[h]=k}else{if(this.isArray(c)){var b=c.length;for(var d=0;d<b;d++){e.push(c[d])}}else{e.push(c)}}}if(j){this.draw({func:"modifyObjectArray",par:[c,g,h,f,j]})}};this.getObjectArray=function(b){var d={};if(b&&this.isArray(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]]=true}}return d};this.getObjectArrayOrder=function(b){var d={};if(b&&this.isArray(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]+""]=c}}return d};this.intersectArray=function(e,d){var h=[];if(!this.isArray(e)){e=this.toArray(e)}var f=this.getObjectArray(this.toArray(d));for(var g=0;g<e.length;g++){if(f.hasOwnProperty(e[g].toString())){h.push(e[g])}}return h};this.removeFromArray=function(e,b){if(this.isArray(b)){var d=[];var f=b.length;for(var c=0;c<f;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.isFunction=function(a){return a&&typeof a==="function";var b={};return a&&b.toString.call(a)==="[object Function]"};this.isArray=function(a){return Array.isArray(a)};this.isObject=function(a){return a instanceof Object};this.isUnique=function(b){return this.getUniqueEls(b).length==b.length};this.isBoolean=function(b){var d=b.length;if(this.isR){for(var c=0;c<d;c++){if(this.isObject(b[c])){return false}else{if(b[c]==null){continue}else{if(typeof(b[c])=="string"){if(b[c].toLowerCase()!="true"&&b[c].toLowerCase()!="false"&&b[c]!==""){return false}}}}}}else{for(var c=0;c<d;c++){if(this.isObject(b[c])){return false}else{if(b[c]!==true&&b[c]!==false&&b[c]!==""&&b[c]!==null){return false}}}}return true};this.toArray=function(a){return this.isArray(a)?a:[a]};this.getKeys=function(a){return this.isArray(a)?a:this.isObject(a)?Object.keys(a):[]};this.unique=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return Object.keys(a)}else{return[a]}}};this.getUniqueEls=function(b){var g=b.length;var f=[];var e=new Set();for(var d=0;d<g;d++){var c=b[d];if(e.has(c)){continue}e.add(c);f.push(c)}return f};this.getUniqueKeys=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return this.getUniqueEls(this.getKeys(a))}else{return[a]}}};this.shuffleArray=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.random()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.toNumber=function(c){var f=[];var d=this.isArray(c);c=this.toArray(c);var b=c.length;for(var e=0;e<b;e++){f.push(Number(c[e]))}return d?f:f[0]};this.zip=function(d,c){return d.map(function(b,a){return[d[a],c[a]]})};this.unzip=function(b,a){return b.map(function(d,c){return d[a]})};this.extend=function(c,b){if(c==null||typeof(c)!="object"){return b}if(b==null||typeof(b)!="object"){return c}if(Object.assign){return Object.assign({},c,b)}else{for(var a in c){if(c.hasOwnProperty(a)){b[a]=c[a]}}return b}};this.cloneObjectR=function(c,a){var b=this;if(c==null||typeof(c)!="object"){return c}if(this.isArray(c)){return c.map(function(d){return b.isArray(d)?d.slice():b.cloneObjectR(d,a)})}else{if(a){return this.isObject(c)?Object.assign({},c):this.parseJSON(this.stringifyJSON(c))}else{return this.parseJSON(this.stringifyJSON(c))}}};this.cloneObject=function(e,d){var c={bubble:true,gantt:true,sankey:true,tree:true};if(typeof e!=="object"){return e}if(!e){return e}if(Object.prototype.toString.apply(e)==="[object Array]"){var f=[];var a=e.length;for(var b=0;b<a;b++){f[b]=this.cloneObject(e[b])}return f}var f={};for(b in e){if(d&&c.hasOwnProperty(b)){continue}if((e[b]&&e.hasOwnProperty(b))||e[b]===false||e[b]===0){f[b]=this.cloneObject(e[b],b=="data")}}return f};this.isSameObject=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}return JSON.stringify(d)==JSON.stringify(c)};this.isNumber=function(b,a){if(a){return !isNaN(parseFloat(b))&&isFinite(b)}else{return b===null||b===undefined?true:!isNaN(parseFloat(b))&&isFinite(b)}};this.toNumber=function(a){if(this.isNumber(a,true)){return a}else{return Number.NaN}};this.isNumeric2DArray=function(a){var e=a.length;for(var d=0;d<e;d++){var c=a[d].length;for(var b=0;b<c;b++){if(!this.isNumber(a[d][b])){return false}}}return true};this.isNumeric=function(a){var c=a.length;for(var b=0;b<c;b++){if(!this.isNumber(a[b])){return false}}return true};this.isNull=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null){return false}}return true};this.isEmpty=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!==""){return false}}return true};this.isDate=function(a){var c=function(e){if(toString.call(e)==="[object Date]"){return true}if(typeof e.replace==="function"){e.replace(/^\s+|\s+$/gm,"")}var g=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return g.test(e)};var d=a.length;for(var b=0;b<d;b++){if(a[b]&&!c(a[b])){return false}}return true};this.isMonthDay=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]&&!CanvasXpress.dates.hasOwnProperty(a[b])){return false}}return true};this.isCountry=function(a){var b=function(e){return CanvasXpress.countries.hasOwnProperty(e)};var d=a.length;for(var c=0;c<d;c++){if(a[c]&&!b(a[c])){return false}}return true};this.isUsa=function(a){var b=function(e){return CanvasXpress.usa.hasOwnProperty(e)};var d=a.length;for(var c=0;c<d;c++){if(a[c]&&!b(a[c])){return false}}return true};this.padNumber=function(b,a){if(!a){a=4}b=b+"";return b.length>=a?b:new Array(a-b.length+1).join("0")+b};this.isPivotable=function(){var b=this.data.y.vars.length;var c=this.data.x?this.getKeys(this.data.x):[];var a=c.length;return(this.data.x||b+a==3)?true:false};this.pivotMatrix=function(j,g,l,d){var c={};var f=[];var e=[];var a=j.length;for(var b=0;b<a;b++){if(!c[j[b][g]]){c[j[b][g]]={}}c[j[b][g]][j[b][l]]=j[b][d];if(f.indexOf(j[b][l])==-1){f.push(j[b][l])}}f=this.stringRangeSort(f);var k=[];k.push("Vars");k.push.apply(k,f);e.push(k);for(var h in c){k=[];k.push(h);a=f.length;for(var b=0;b<a;b++){k.push(c[h][f[b]]||"")}e.push(k)}return e};this.transposeMatrix=function(a){return a[0].map(function(b,d){return a.map(function(c){return c[d]})})};this.filterNumbers=function(a,c){var d=[];var e=a.length;for(var b=0;b<e;b++){if(this.isNumber(a[b],c)){d.push(a[b])}}return d};this.cleanArray=function(b,a,e){var d=[];if(a){var f=this.smpIndices.length;for(var c=0;c<f;c++){d.push(b[this.smpIndices[c]])}d=this.filterNumbers(d,true)}else{if(e){var f=this.varIndices.length;for(var c=0;c<f;c++){d.push(b[this.varIndices[c]])}d=this.filterNumbers(d,true)}else{d=this.filterNumbers(b,true)}}return d};this.cleanArrays=function(j,h,g,e){var d=[];var c=[];if(g){var b=this.smpIndices.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[this.smpIndices[f]],h[this.smpIndices[f]]],true);if(k.length==2){d.push(j[this.smpIndices[f]]);c.push(h[this.smpIndices[f]])}}}else{if(e){var b=this.varIndices.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[this.varIndices[f]],h[this.varIndices[f]]],true);if(k.length==2){d.push(j[this.varIndices[f]]);c.push(h[this.varIndices[f]])}}}else{var b=j.length;for(var f=0;f<b;f++){var k=this.filterNumbers([j[f],h[f]],true);if(k.length==2){d.push(j[f]);c.push(h[f])}}}}return[d,c]};this.reverseArray=function(a){tmp=a.reverse();return tmp};this.parseInt=function(a){return((a+0.5)<<1)>>1};this.ungroupGroupedData=function(){return this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Gantt")};this.getIpRangeFromAddressAndNetmask=function(g){var c=g.split("/");var e=c[0].split(".");var d=["0","0","0","0"];if(!/\d+\.\d+\.\d+\.\d+/.test(c[1])){d=("1".repeat(parseInt(c[1],10))+"0".repeat(32-parseInt(c[1],10))).match(/.{1,8}/g);d=d.map(function(h){return parseInt(h,2)})}else{d=c[1].split(".").map(function(h){return parseInt(h,10)})}var b=d.map(function(h){return h^255});var a=e.map(function(i,h){return i&d[h]});var f=e.map(function(i,h){return i|b[h]});return[a.join("."),f.join(".")]};this.int2Ip=function(a){return((a>>>24)+"."+(a>>16&255)+"."+(a>>8&255)+"."+(a&255))};this.ip2Int=function(a){return a.split(".").reduce(function(c,b){return(c<<8)+parseInt(b,10)},0)>>>0};this.md5=function(b){var d=function(o,q){var p=o[0];var n=o[1];var s=o[2];var r=o[3];p=a(p,n,s,r,q[0],7,-680876936);r=a(r,p,n,s,q[1],12,-389564586);s=a(s,r,p,n,q[2],17,606105819);n=a(n,s,r,p,q[3],22,-1044525330);p=a(p,n,s,r,q[4],7,-176418897);r=a(r,p,n,s,q[5],12,1200080426);s=a(s,r,p,n,q[6],17,-1473231341);n=a(n,s,r,p,q[7],22,-45705983);p=a(p,n,s,r,q[8],7,1770035416);r=a(r,p,n,s,q[9],12,-1958414417);s=a(s,r,p,n,q[10],17,-42063);n=a(n,s,r,p,q[11],22,-1990404162);p=a(p,n,s,r,q[12],7,1804603682);r=a(r,p,n,s,q[13],12,-40341101);s=a(s,r,p,n,q[14],17,-1502002290);n=a(n,s,r,p,q[15],22,1236535329);p=i(p,n,s,r,q[1],5,-165796510);r=i(r,p,n,s,q[6],9,-1069501632);s=i(s,r,p,n,q[11],14,643717713);n=i(n,s,r,p,q[0],20,-373897302);p=i(p,n,s,r,q[5],5,-701558691);r=i(r,p,n,s,q[10],9,38016083);s=i(s,r,p,n,q[15],14,-660478335);n=i(n,s,r,p,q[4],20,-405537848);p=i(p,n,s,r,q[9],5,568446438);r=i(r,p,n,s,q[14],9,-1019803690);s=i(s,r,p,n,q[3],14,-187363961);n=i(n,s,r,p,q[8],20,1163531501);p=i(p,n,s,r,q[13],5,-1444681467);r=i(r,p,n,s,q[2],9,-51403784);s=i(s,r,p,n,q[7],14,1735328473);n=i(n,s,r,p,q[12],20,-1926607734);p=f(p,n,s,r,q[5],4,-378558);r=f(r,p,n,s,q[8],11,-2022574463);s=f(s,r,p,n,q[11],16,1839030562);n=f(n,s,r,p,q[14],23,-35309556);p=f(p,n,s,r,q[1],4,-1530992060);r=f(r,p,n,s,q[4],11,1272893353);s=f(s,r,p,n,q[7],16,-155497632);n=f(n,s,r,p,q[10],23,-1094730640);p=f(p,n,s,r,q[13],4,681279174);r=f(r,p,n,s,q[0],11,-358537222);s=f(s,r,p,n,q[3],16,-722521979);n=f(n,s,r,p,q[6],23,76029189);p=f(p,n,s,r,q[9],4,-640364487);r=f(r,p,n,s,q[12],11,-421815835);s=f(s,r,p,n,q[15],16,530742520);n=f(n,s,r,p,q[2],23,-995338651);p=l(p,n,s,r,q[0],6,-198630844);r=l(r,p,n,s,q[7],10,1126891415);s=l(s,r,p,n,q[14],15,-1416354905);n=l(n,s,r,p,q[5],21,-57434055);p=l(p,n,s,r,q[12],6,1700485571);r=l(r,p,n,s,q[3],10,-1894986606);s=l(s,r,p,n,q[10],15,-1051523);n=l(n,s,r,p,q[1],21,-2054922799);p=l(p,n,s,r,q[8],6,1873313359);r=l(r,p,n,s,q[15],10,-30611744);s=l(s,r,p,n,q[6],15,-1560198380);n=l(n,s,r,p,q[13],21,1309151649);p=l(p,n,s,r,q[4],6,-145523070);r=l(r,p,n,s,q[11],10,-1120210379);s=l(s,r,p,n,q[2],15,718787259);n=l(n,s,r,p,q[9],21,-343485551);o[0]=e(p,o[0]);o[1]=e(n,o[1]);o[2]=e(s,o[2]);o[3]=e(r,o[3])};var k=function(v,p,o,n,u,r){p=e(e(p,v),e(n,r));return e((p<<u)|(p>>>(32-u)),o)};var a=function(p,o,v,u,n,r,q){return k((o&v)|((~o)&u),p,o,n,r,q)};var i=function(p,o,v,u,n,r,q){return k((o&u)|(v&(~u)),p,o,n,r,q)};var f=function(p,o,v,u,n,r,q){return k(o^v^u,p,o,n,r,q)};var l=function(p,o,v,u,n,r,q){return k(v^(o|(~u)),p,o,n,r,q)};var j=function(q){txt="";var t=q.length;var r=[1732584193,-271733879,-1732584194,271733878];var p;for(p=64;p<=q.length;p+=64){d(r,m(q.substring(p-64,p)))}q=q.substring(p-64);var o=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(p=0;p<q.length;p++){o[p>>2]|=q.charCodeAt(p)<<((p%4)<<3)}o[p>>2]|=128<<((p%4)<<3);if(p>55){d(r,o);for(p=0;p<16;p++){o[p]=0}}o[14]=t*8;d(r,o);return r};var m=function(o){var p=[];var n;for(n=0;n<64;n+=4){p[n>>2]=o.charCodeAt(n)+(o.charCodeAt(n+1)<<8)+(o.charCodeAt(n+2)<<16)+(o.charCodeAt(n+3)<<24)}return p};var h="0123456789abcdef".split("");var g=function(q){var p="";var o=0;for(;o<4;o++){p+=h[(q>>(o*8+4))&15]+h[(q>>(o*8))&15]}return p};var c=function(n){for(var o=0;o<n.length;o++){n[o]=g(n[o])}return n.join("")};var e=function(o,n){return(o+n)&4294967295};return c(j(this.stringifyJSON(b)))}};CanvasXpress.prototype.initPlotUtils=function(){this.drawLayoutCanvasCompartments=function(){var n=this.canvasBoxColor;var m=this.height;var s=this.width;var g=this.left;var d=this.right;var p=this.bottom;var u=this.top;var j=this.marginLeft;var e=this.marginRight;var q=this.marginBottom;var a=this.marginTop;var o=this.layoutLeft;var k=this.layoutRight;var f=this.layoutBottom;var i=this.layoutTop;this.toRender({p:["drawShape","rectangle",(j+this.offsetX)+(this.layoutWidth/2),(a+this.offsetY)+(this.layoutHeight/2),this.layoutWidth,this.layoutHeight,false,n,"open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY+u)+(this.y/2),this.x,this.y,false,"red","open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX+g+this.x)+(d/2),(a+this.offsetY+u)+(this.y/2),d,this.y,false,"blue","open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX)+(g/2),(a+this.offsetY+u)+(this.y/2),g,this.y,false,"blue","open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY)+(u/2),this.x,u,false,"blue","open"],t:"Size"});this.toRender({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY+u+this.y)+(p/2),this.x,p,false,"blue","open"],t:"Size"});return};this.drawCanvasBox=function(a){if(this.canvasBox&&(this.graphType!="Network"||a)){this.toRender({p:["disableGradientTransparencyShadow"],t:"Size"});this.toRender({p:["drawShape","rectangle",this.width/2,this.height/2,this.width-2,this.height-2,false,this.canvasBoxColor,"open"],t:"Size"});this.toRender({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.drawPlotWindow=function(){if(this.backgroundType.match("window")){this.toRender({p:["disableGradientTransparencyShadow"],t:"Size"});var c=this.graphType.match(/Sankey/)?this.margin*6:0;var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;if(!this.layoutValid){this.toRender({p:["drawShape","rectangle",this.width*0.5,this.height*0.5,this.width,this.height,this.background,this.background],t:"Size"})}if(this.backgroundType=="windowSolidGradient"){var d=this.getLinearGradient(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b);this.toRender({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,d,d],t:"Size"})}else{if(this.backgroundType=="windowImage"){this.toRender({p:["drawShape","image",a+(this.x/2),b+(this.y/2),this.x-c,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{var e=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.backgroundWindow;this.toRender({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,e,e],t:"Size"})}}this.toRender({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.validateSegregation=function(){var e="";var b=this.segregateVariablesBy;var d=this.segregateSamplesBy;if(b.length>0){var a=[];for(var c=0;c<b.length;c++){if((this.data.z&&this.data.z.hasOwnProperty(b[c]))||b[c]=="variable"){a.push(b[c])}}b=a}if(d.length>0){var a=[];for(var c=0;c<d.length;c++){if((this.data.x&&this.data.x.hasOwnProperty(d[c]))||d[c]=="sample"){a.push(d[c])}}d=a}if(b.length>0&&d.length>0){if(d.length>1){while(d.length>1){d.pop()}e+="Only one sample segregation when variable segregation is selected\n";e+="segregateSamplesBy was set to: "+d[0]+"\n"}if(b.length>1){while(b.length>1){b.pop()}e+="Only one variable segregation when sample segregation is selected\n";e+="segregateVariblesBy was set to: "+b[0]+"\n"}}else{if(d.length>0){if(d.length>2){while(d.length>2){d.pop()}e+="Maximum of two sample segregations\n";e+="segregateSamplesBy was set to: "+d[0]+","+d[1]+"\n"}}else{if(b.length>0){if(b.length>2){while(b.length>2){b.pop()}e+="Maximum of two variable segregations\n";e+="segregateVariablesBy was set to: "+b[0]+","+b[1]+"\n"}}}}if(e!=""){this.removeMenus();alert(e);return false}return true};this.checkSegregation=function(){if(!this.isDOE){if(this.validateSegregation()){if(this.layoutValid&&this.data.l){if(this.segregateSamplesBy.length==0){}else{if(!this.data.l.smps){this.segregateSamples(this.segregateSamplesBy,true)}}if(this.segregateVariablesBy.length==0){}else{if(!this.data.l.vars){this.segregateVariables(this.segregateVariablesBy,true)}}}else{if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.segregateSamplesVariables(true)}else{if(this.segregateSamplesBy.length>0){this.segregateSamples(this.segregateSamplesBy,true)}else{if(this.segregateVariablesBy.length>0){this.segregateVariables(this.segregateVariablesBy,true)}}}}}}};this.validateOverlays=function(){if(this.smpOverlays.length>0){var a=[];for(var b=0;b<this.smpOverlays.length;b++){if(this.smpOverlays[b]=="-"||(this.data.x&&this.data.x.hasOwnProperty(this.smpOverlays[b]))){a.push(this.smpOverlays[b])}}this.smpOverlays=a}if(this.varOverlays.length>0){var a=[];for(var b=0;b<this.varOverlays.length;b++){if(this.varOverlays[b]=="-"||(this.data.z&&this.data.z.hasOwnProperty(this.varOverlays[b]))){a.push(this.varOverlays[b])}}this.varOverlays=a}};this.isDotplotGraph=function(){if(this.graphType.match(/Dotplot/)){return true}else{if(this.graphType=="Boxplot"&&(this.showBoxplotOriginalData||this.showViolinBoxplot)){return true}else{return false}}};this.isAttributedGraph=function(){return this.colorBy||this.shapeBy||this.sizeBy||this.patternBy};this.isSegregatable=function(){var a=this;var b=function(){if(a.isTransitionOn){CanvasXpress.transitions[a.target].push([a.isSegregatable]);return true}else{return false}};return !b()&&!this.isDOE&&!CanvasXpress.graphTypes.NonSegregatable.includes(this.graphType)};this.isDOEable=function(){if(this.graphType.match(/Gantt|Circular|Fish|Meter|Network|Correlation|Genome|Pie|Scatter3D|TagCloud|Venn/)||this.is3DPlot||this.scatterPlotMatrix||this.isContour||this.isOncoprint){return false}return true};this.validateNetworkDecorations=function(){if(this.decorations.length){var c=this.meta.data.nodes;var a=[];for(var b=0;b<this.decorations.length;b++){if(c.hasOwnProperty(this.decorations[b])){a.push(this.decorations[b])}}this.decorations=a}}};CanvasXpress.prototype.initConfigUtils=function(){this.encode=function(a){return btoa(encodeURIComponent(a).replace(/%([0-9A-F]{2})/g,function(b,c){return String.fromCharCode("0x"+c)}))};this.decode=function(a){return decodeURIComponent(Array.prototype.map.call(atob(a),function(b){return"%"+("00"+b.charCodeAt(0).toString(16)).slice(-2)}).join(""))};this.getFileName=function(a){return a.substring(a.lastIndexOf("/")+1)};this.getTitleSubtitleHeight=function(){var b=0;var a;this.setTitleSubtitleFont();if(this.title){a=this.title.split(/\n/);b+=(this.margin+this.getFontPt(this.titleFont))*a.length;if(this.subtitle){a=this.subtitle.split(/\n/);b+=(this.margin+this.getFontPt(this.subtitleFont))*a.length}b+=this.margin}return b};this.setTitleSubtitleFont=function(){this.setPropertyFontSize(this.width,"titleFont");this.adjustFont(this.title,"titleFont",this.width);this.setPropertyFontSize(this.width,"subtitleFont");this.adjustFont(this.subtitle,"subtitleFont",this.width)};this.drawTitle=function(){this.setTitleSubtitleFont();if(this.title){var a=this.title.split(/\n/);var c=this.marginTop+((this.getFontPt(this.titleFont)+this.margin)*a.length);if(this.subtitle){a=this.subtitle.split(/\n/);c+=(this.getFontPt(this.subtitleFont)+this.margin)*a.length}if(this.titleColorBackground){this.toRender({p:["drawShape","rectangle",this.width/2,c/2,this.width,c,this.titleColorBackground,this.titleColorBackground],t:"Titles"})}var b=this.titleAlign=="left"?this.marginLeft+this.left:this.titleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;var d=this.marginTop+(this.measureTextWidth(this.title,this.titleFont)/2);this.toRender({p:["drawText",this.title,b,d,this.titleFont,this.titleColor,this.titleAlign=="left"?"left":this.titleAlign=="right"?"right":"center","middle"],t:"Titles"});if(this.subtitle){b=this.subtitleAlign=="left"?this.marginLeft+this.left:this.subtitleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.toRender({p:["drawText",this.subtitle,b,d+(this.getFontPt(this.titleFont)/2)+this.margin+(this.getFontPt(this.subtitleFont)/2),this.subtitleFont,this.subtitleColor,this.subtitleAlign=="left"?"left":this.subtitleAlign=="right"?"right":"center","middle"],t:"Titles"})}}};this.getCitationHeight=function(){var b=0;var a;this.setCitationFont();if(this.citation){a=this.citation.split(/\n/);b+=(this.margin+this.getFontPt(this.citationFont))*a.length;b+=this.margin}return b};this.setCitationFont=function(){var b=20*this.printMagnification;this.setPropertyFontSize(this.width,"citationFont",b);var a=this.measureText(this.citation,this.citationFont);var c=1;while(a>this.width||c>9){b/=2;this.setPropertyFontSize(this.width,"citationFont",b);a=this.measureText(this.citation,this.citationFont);c++}return};this.drawCitation=function(){if(this.citation){var a=this.width-this.margin;var b=this.height-this.margin;this.toRender({p:["drawText",this.citation,a,b,this.citationFont,this.citationColor,"right","bottom"],t:"Citations"})}};this.getFontHeight=function(){this.setMainFont();return this.getFontPt(this.font)};this.setMainFont=function(){var b;if(this.autoScaleFont){var c=1-this.percentAspectRatioPlotArea;var a=this.layoutComb?(this.width/this.layoutCols)*c*2.5:this.width*c;var e=this.layoutComb?(this.height/this.layoutRows)*c*2.5:this.height*c;b=Math.min(Math.max(parseInt((Math.max(a,e)/30)*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}else{b=Math.min(Math.max(parseInt(this.fontSize*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}this.font=this.fontStyle+" "+b+"px "+this.fontName};this.setPropertyFontSize=function(h,f,c){if(!h||!f){return}var a=5;var e={titleFont:a+4,subtitleFont:a+2,decorationFont:a,axisTickFont:a,axisTitleFont:a,smpLabelFont:a,smpTitleFont:(this.graphType=="Meter"?a+4:a),varLabelFont:a,varTitleFont:a,legendFont:a-2,overlayFont:a-6,citationFont:a-10,motionCurrentFont:a+50};var g=f.replace("Font","ScaleFontFactor");this[f+"Size"]=Math.min(Math.max(parseInt((h/30)*this[g])+e[f],this.minTextSize),c||this.maxTextSize);this[f]=this[f+"Style"]+" "+this[f+"Size"]+"px "+this.fontName};this.adjustFont=function(b,c,g){if(b&&c&&g){var e=this.getFontPt(this[c]);var a=this.measureText(b,this[c]);while(a>g&&e>this.minTextSize){e--;this[c]=this[c+"Style"]+" "+e+"px "+this.fontName;a=this.measureText(b,this[c])}}};this.setAspectRatioProperties=function(){if(this.adjustAspectRatio&&this.graphType!="Genome"){var a=this.meta.config.orig;var b=this.meta.config.user;var g=Math.min(this.width,this.height);var f=this.zoomScale?this.zoom:1;var e=["ringSeparation","roundedPolygonRadius","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","xAxisHistogramHeight","xAxisRugHeight","yAxisHistogramHeight","yAxisRugHeight","dataPointSize","layoutLabelBoxThickness"];if(this.adjustAspectRatioHeatmapIndicator){e.push("heatmapIndicatorHeight");e.push("heatmapIndicatorWidth")}for(var c=0;c<e.length;c++){if(!a[e[c]]){a[e[c]]=this[e[c]]}}for(var c=0;c<e.length;c++){this[e[c]]=Number(Math.max(0.5,g*this[e[c]]/833).toFixed(1))}if(this.isDOE||(this.layoutValid&&this.graphType.match(/Scatter/)&&this.scatterPlotMatrix&&this.scatterPlotMatrixType.match(/Density|Histogram|all/))){this.dataPointSize=Number(Math.max(0.5,this.dataPointSize/Math.max(this.layoutRows,this.layoutCols)).toFixed(1))*(this.isDOE?1.5:1)}}};this.resetAspectRatioProperties=function(){if(this.adjustAspectRatio&&this.graphType!="Genome"){if(this.graphType=="Network"&&!this.isLayoutDone){this.setTimeout(this.resetAspectRatioProperties,50);return}var a=this.meta.config.orig;var c=["ringSeparation","roundedPolygonRadius","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","xAxisHistogramHeight","xAxisRugHeight","yAxisHistogramHeight","yAxisRugHeight","dataPointSize","layoutLabelBoxThickness"];if(this.adjustAspectRatioHeatmapIndicator){c.push("heatmapIndicatorHeight");c.push("heatmapIndicatorWidth")}for(var b=0;b<c.length;b++){if(a[c[b]]){this[c[b]]=a[c[b]];delete (a[c[b]])}}}};this.getGroupColor=function(b,e){var h;if(this.isGroupedData){var a=this.data.w.grps[e];if(a){this.isGroupedData=false;h=this.getPropertyValue(b,a[0],"colorBy");for(var d=1;d<a.length;d++){var f=this.getPropertyValue(b,a[d],"colorBy");if(f!=h){this.isGroupedData=true;return this.foreground}}this.isGroupedData=true}else{h=this.getPropertyValue(b,e,"colorBy")}}else{h=this.getPropertyValue(b,e,"colorBy")}return h};this.getVarColor=function(a,c){if(this.isArray(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return c?this.dendrogramColor:this.varLabelFontColor};this.getSmpColor=function(c,b){if(this.isArray(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==c){return this.smpHighlightColor}}}else{if(this.highlightSmp==c){return this.smpHighlightColor}}return b?this.dendrogramColor:this.smpLabelFontColor};this.getNodeColor=function(e,a){if(this.isArray(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==e){return this.nodeHighlightColor}}}else{if(this.highlightNode==e){return this.nodeHighlightColor}}var d=this.isSelected(e);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!d;return d&&this.selectionMode=="highlight"?this.selectionColor:b?this.addColorTransparency(a,0.1,true):a?a:this.nodeColor};this.getEdgeColor=function(f,d,a){if(this.isArray(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==f||this.highlightNode[c]==d){return this.nodeHighlightColor}}}else{if(this.highlightNode==f||this.highlightNode==d){return this.nodeHighlightColor}}var e=this.isSelected(f)||this.isSelected(d);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!e;return e&&this.selectionMode=="highlight"?this.selectionColor:b?this.addColorTransparency(a,0.1,true):a?a:this.nodeColor};this.getDendrogramColor=function(a,c){if(a){if(this.colorVarDendrogramBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorVarDendrogramBy)){var b=this.getVariableIndices(a);if(b>-1){return this.getPropertyValue(b,false,"colorVarDendrogramBy")}}return this.getVarColor(a,true)}else{if(this.colorSmpDendrogramBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorSmpDendrogramBy)){var b=this.getSampleIndices(c);if(b>-1){return this.getPropertyValue(false,b,"colorSmpDendrogramBy")}}return this.getSmpColor(c,true)}};this.isStringOverlays=function(c){var a=this.meta.data;if((!c||c=="v")&&a.z&&this.varOverlays.length>0){for(var b=0;b<this.varOverlays.length;b++){var d=this.varOverlays[b];if(a.z[d].type!="Numeric"){return true}}}if((!c||c=="s")&&a.x&&this.smpOverlays.length>0){for(var b=0;b<this.smpOverlays.length;b++){var d=this.smpOverlays[b];if(a.x[d].type!="Numeric"){return true}}}return false};this.isUniqueFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].unique){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].unique){return true}}}return false};this.isNumericFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type=="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type=="Numeric"){return true}}}return false};this.isStringFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type!="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type!="Numeric"){return true}}}return false};this.getBestSizes=function(g,f){if(this.graphType=="Network"){var d=f?0.5:0.05;var a=Math.min(parseInt(2/g*10)/10,d);var e=[0.5];for(var c=0;c<g-1;c++){e.push(e[c]+a)}return e}else{if(g>this.sizes.length){return this.cloneObject(this.sizes)}else{var e=[];var b=Math.floor(this.sizes.length/g);for(var c=0;c<g;c++){e.push(this.sizes[c*b])}return e}}};this.isBinConfigurations=function(){for(var a in this.binConfigurations){return true}return false};this.initValidity=function(){var B=this.hexToString("686578546f537472696e67");var E=this[B]("6d657461");var p=this[B]("666163746f7279");var o=this[B]("636c69656e74");var g=this[B]("656e636f6465");var e=this[B]("73797374656d");var C=this[B]("76616c6964");var d=this[B]("74696d65");var F=this[B]("7374617274");var b=this[B]("73697465537263");var D=this[B]("757365724964");var b=this[B]("76657273696f6e");var j=this[B]("68726566");var A=this[B]("69734e6f6465");var y=new RegExp(this[B]("63616e7661737870726573732e6f7267"));var k=new RegExp(this[B]("5e66696c653a"));var i=new RegExp(this[B]("6c6f63616c686f7374"));CanvasXpress[p][o]=this[g]([this[E][d][F],this[D],CanvasXpress[p][b],this[j]].join("::"));this.setPixelImage();if(this[D]==1){if(window.navigator.onLine){if(this[j]&&CanvasXpress[p][b]){CanvasXpress[p][C]=0}else{if(this[j]&&k.test(this[j])){CanvasXpress[p][C]=0}else{if(this[j]&&i.test(this[j])){CanvasXpress[p][C]=0}else{if(this[j]&&!y.test(this[j])){CanvasXpress[p][C]=1}else{CanvasXpress[p][C]=0}}}}}else{CanvasXpress[p][C]=0}}else{if(this[D]==2){if(this.isR){CanvasXpress[p][C]=0}else{CanvasXpress[p][C]=3}}else{if(CanvasXpress[e][A]){if(this[D]<5){CanvasXpress[p][C]=4}else{CanvasXpress[p][C]=0}}else{CanvasXpress[p][C]=0}}}};this.getWorstAspectRatio=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.adjustTreemapCoords=function(f,e){if(f){var c=this.treemapBorderWidth&&!this.isDOE?1:0;var a=this.treemapBorderWidth;var b=a*2;var d=this.smpLabelFontSize*c;e.left+=a;if(e.height>d+b){e.top+=d+a;e.height-=(d+b);e.border=2}else{if(e.height>b){e.top+=a;e.height-=b;e.border=1}else{if(e.height>a){e.height-=a;e.border=0}else{e.border=-1}}}e.width-=b}};this.setTreemapRowVerticalLayout=function(k,h,g,f){var c=0;for(var b=0;b<k.length;b++){c+=k[b].area}var a=c/h;var e=0;for(var b=0;b<k.length;b++){var j=k[b].area/a;k[b].coords={width:a,height:j,left:g.left,top:g.top+e};this.adjustTreemapCoords(f,k[b].coords);e+=j}var d={width:g.width-a,height:g.height,left:g.left+a,top:g.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.setTreemapRowHorizontalLayout=function(l,j,h,g){var d=0;for(var c=0;c<l.length;c++){d+=l[c].area}var k=d/j;var f=h.top;var b=0;for(var c=0;c<l.length;c++){var a=l[c].area/k;l[c].coords={width:a,height:k,left:h.left+b,top:f};this.adjustTreemapCoords(g,l[c].coords);b+=a}var e={width:h.width,height:h.height-k,left:h.left,top:h.top+k};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.setTreemapRowLayout=function(a,b,c,d){if(this.treemapOrientation=="horizontal"){return this.setTreemapRowVerticalLayout(a,b,c,d)}else{return this.setTreemapRowHorizontalLayout(a,b,c,d)}};this.computeTreemapDimensions=function(a,c,b,f,h){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;this.adjustTreemapCoords(h,e[0].coords);return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.setTreemapRowLayout(c,b,f,h)}return}var d=a[0];if(this.getWorstAspectRatio(c,b)>=this.getWorstAspectRatio([d].concat(c),b)){this.computeTreemapDimensions(a.slice(1),c.concat([d]),b,f,d.title)}else{var g=this.setTreemapRowLayout(c,b,f,h);this.computeTreemapDimensions(a,[],g.orientation,g,d.title)}};this.squarifyTreemap=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.computeTreemapDimensions(a.slice(1),[a[0]],c,g,a[0].title)};this.processTreemap=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.squarifyTreemap(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.processTreemap(a,d)}}return b};this.getCloudPointsAtRadius=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){var e=1;if(this.tagCloudShapeFunction!=="circle"){e=this.tagCloudShapeFunction(c/b*2*Math.PI)}d.push([this.tagCloudGridCenter[0]+a*e*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*e*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.getCloudRotateDeg=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.random()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.random()*Math.PI)};this.getCloudTextInfo=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=this.$cX("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.measureText(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;if(v<1||r<1){return{occupied:[],bounds:[0,0,0,0],gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}}s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.canFitCloudText=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.fillCloudGridAt=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.updateCloudGrid=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.fillCloudGridAt(e+a[b][0],c+a[b][1])}};this.drawCloudTag=function(c,i,g,d){var k=this;var m=this.getCloudRotateDeg();var e=this.getCloudTextInfo(c,i,m);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;var j=this.addColorTransparency(g,0,true);var f=this.get1DLeft();var p=this.get1DTop();while(a--){var n=this.getCloudPointsAtRadius(this.tagCloudGridMaxRadius-a);n=[].concat(n);this.shuffleArray(n);var h=n.some(function o(q){var w=Math.floor(q[0]-e.gw/2);var v=Math.floor(q[1]-e.gh/2);var z=e.gw;var s=e.gh;var r=e.fontSize+"px "+k.fontName;var l="1px "+k.fontName;if(!k.canFitCloudText(w,v,z,s,e.occupied)){return false}var u=((w+e.gw/2)*k.tagCloudTextGridSize);var t=((v+e.gh/2)*k.tagCloudTextGridSize);k.renderTagCloud.push([["drawText",c,u+f,t+p,r,g,"center","middle",-m],d,false,null,false,[k.width/2,k.height/2,l,j,-Math.PI*2]]);k.updateCloudGrid(w,v,e);return true});if(h){return true}}return false};this.setTagCloud=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize);this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.setTagCloudTextWeightFactor()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.setTagCloudTextWeightFactor=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.getDataAtPos(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}if(!this.tagCloudTries){this.tagCloudTries=1}b=parseInt(Math.max(this.x,this.y));if(h>b){this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries)}else{this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries*(b/h))}this.tagCloudTries+=1};this.tryRenderTagCloud=function(g){var e=this.randomSeed;this.renderTagCloud=[];this.setTagCloud(g);var j=this.varIndices[0];for(var b=0;b<this.smpIndices.length;b++){var a=this.smpIndices[b];var h=this.getDataAtPos(j,a);var k=this.colorBy?this.getPropertyValue(j,a,"colorBy"):this.foreground;if(!this.drawCloudTag(this.data.y.smps[a],h,k,[j,a])){this.resizeCanvas();this.renderTagCloud=[];if(this.pseudoRandom){this.randomSeed=e}this.tryRenderTagCloud(0.9);break}}if(this.pseudoRandom){this.randomSeed=e}};this.getVariableColor=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.getOutlineColor=function(b,a,g){var i;if((this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)||(this.useOpenShapes&&!g)){i=this.removeColorTransparency(b,true)}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){var d=this.layoutValid?this.data.y.vars.length*this.data.y.smps.length:this.varIndices.length*this.smpIndices.length;if(d>this.dotplotOutlineThreshold){i=b}else{i=this.objectBorderColor?this.objectBorderColor:this.removeColorTransparency(b,true)}}else{i=this.objectBorderColor&&this.graphType!="Map"?this.objectBorderColor:this.removeColorTransparency(b,true)}}if(a){var f=this.isSelected(a);var e=this.isVarHighlughted(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;i=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.addColorTransparency(i,0.1,true):i}return i};this.getFillColor=function(b,a,g){var i=(this.useOpenShapes&&!g)&&(!this.isDOE||!this.layoutCurrent);var j=this.addColorTransparency(b,(i?0:this.objectColorTransparency),true);if(a){var f=this.isSelected(a);var e=this.isVarHighlughted(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;j=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.addColorTransparency(j,0.1,true):j}return j};this.isVarHighlughted=function(a){if(this.highlightVar.length&&a!=null){var b=this.data.y.vars[a];return this.highlightVar.includes(b)}};this.getDefaultMetaDataObject=function(){var a=this.meta.def.colorBrew;return{rmin:a.rmin,rmax:a.rmax,min:a.min,max:a.max,decs:a.decs,vals:a.vals,maxLevLen:a.maxLevLen,maxLevChr:a.maxLevChr,maxLevStr:a.maxLevStr,colorBrew:a}};this.resetCacheColors=function(){delete (this.cacheColors)};this.setCacheColors=function(){if(!this.cacheColors){this.cacheColors={}}if(!this.cacheColors[this.colorScheme]){this.cacheColors[this.colorScheme]={}}};this.setPieData=function(n,q,m){this.setCacheColors();var e={no:0,idso:[],ids:[],cols:[],data:{},raw:{},oprc:0,tot:this.sum(n)};var b=this.getCustomColorScheme(n.length);for(var l=0;l<n.length;l++){var h=q?this.varIndices[l]:l;var a=n[h]/e.tot;var g=q?this.data.y.vars[h]:l;var o;if(m&&m[l%m.length]){o=m[l%m.length]}else{if(this.cacheColors[this.colorScheme].hasOwnProperty(g)){o=this.cacheColors[this.colorScheme][g]}else{o=this.pieColors[l]||b[l%b.length];this.cacheColors[this.colorScheme][g]=o}}if(this.isNumber(a,true)){e.data[h]=a;e.raw[h]=n[h];if(l>=this.maxPieSectors-1){e.oprc+=a;e.idso.push(h);e.no++}else{e.ids.push(h)}e.cols.push(o)}}if(e.no){e.ids.push(-1)}return e};this.drawPie=function(u,h,g,t,I,w){var f=this;var q=function(){for(var a=0;a<u.ids.length;a++){if(u.data[u.ids[a]]&&u.data[u.ids[a]]>-1&&!f.isNumber(u.data[u.ids[a]],true)){return false}}return true};if(q()){var z,d;var m=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var A=this.pieSegmentLabels=="inside"?t-(t/3):t+(t/6);var G=0;var C=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var o=this.graphType=="Network"||this.graphType!="Pie"?I[E]:k>-1?[k,C]:u.idso;var e=this.graphType=="Map"?u.cols[E]:this.getFillColor(u.cols[E],o,this.isDOE);var D=this.getOutlineColor(e,this.graphType=="Map"?E:o);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var H=(z+d)/2;var B=(d-z)/32;var J=this.graphType=="Network"||this.graphType=="Map"?"Decorations":this.graphType!="Pie"?"Overlays":"Data";var D=this.pieType=="separated"?this.background:this.getOutlineColor(e);if(this.graphType=="Network"||this.graphType=="Map"){this.toRender({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],a:this.getShapeArea("pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d),i:(this.graphType=="Map"?I[0]:I[E]),m:w,t:J,h:this.isHidden(this.graphType=="Map"?I[0][0]:I[E])})}else{if(this.graphType!="Pie"){this.toRender({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],a:this.getShapeArea("pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d),i:I[E],t:J})}else{if(k>-1){I=this.isDOE?[k,C,"Facet-"+this.layoutCurrent]:[k,C];this.toRender({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],a:this.getShapeArea("pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d),i:I,t:J,h:this.isHidden(I[0])})}else{this.toRender({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],a:this.getShapeArea("pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d),i:u.idso,t:J})}}}var F=u.ids.length>1?h-Math.sin(H-(Math.PI/2))*A:h;var b=u.ids.length>1?g+Math.cos(H-(Math.PI/2))*A:g;if(this.graphType!="Network"&&this.graphType!="Map"&&this.showPieValues&&(d-z)>0.05){if(this.pieLabelType=="value"){this.toRender({p:["drawText",u.raw[k],F,b,this.axisTickFont,this.axisTickColor,"center","middle"],t:J})}else{this.toRender({p:["drawText",this.sprintf("%."+this.pieSegmentPrecision+"f",v*100)+"%",F,b,this.axisTickFont,this.axisTickColor,"center","middle"],t:J})}}G+=v}G=0;d=null;if(u.ids.length>1&&this.graphType!="Map"){for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var e=this.getFillColor(u.cols[E]);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var D=this.pieType=="separated"?this.background:this.getOutlineColor(e);this.toRender({p:["drawShape","pie",h,g,(t*2),t,false,D,"open",false,this.pieSegmentSeparation,false,false,z,d],s:true,t:J});G+=v}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1&&this.graphType!="Map"){this.toRender({p:["drawShape","circle",h,g,t*this.pieInnerRadius*2,t*this.pieInnerRadius*2,this.background,this.background,"closed"],t:J})}}};this.drawBarPlot=function(ah,ag,Y,Q,N,T,P,K,X,V,ak,U,an,W,ae,aa,M,am){var O,L,af,S;var J=this;var j=function(a){return J.isGroupedData?M.smps[J.data.w.smps[J.grpIndices[a]]]:M.smps[J.data.y.smps[J.smpIndices[a]]]};var R=this.variableSpaceFactor/2;var ad=N/2;var ac=am?"Overlays":this.graphType=="Network"?"Decorations":"Data";if(V=="vertical"||this.graphType=="Network"){for(var ab=0;ab<ah.length;ab++){O=((ah[ab]-X)*P)-K;var ai;var Z=(M&&M.cap&&M.cap[j(ab)])||this.barType=="arrow"?"arrow":this.useRoundRectangles&&O>0?"roundrectt":this.useRoundRectangles?"roundrectb":"rectangle";var A=this.getFillColor(M?M.fill[j(ab)]:ak[ab],an[ab]);var al=N-this.variableSpaceFactor>5?this.getOutlineColor(A,an[ab]):A;var I=this.isHidden(an[ab][0],an[ab][1]);if(this.isNumber(O,true)){if(this.barPath){var B=this.addColorTransparency(this.barPathColor||A,this.barPathTransparency);this.toRender({p:["drawShape","rectangle",(Y+R)+((N-this.variableSpaceFactor)/2),K+(this.y/2),N-this.variableSpaceFactor,this.y*2,B,B],t:"Decorations"})}if(O<0){ai=this.toRender({p:["drawShape",Z,(Y+R)+((N-this.variableSpaceFactor)/2),Q+(-O/2),N-this.variableSpaceFactor,-O,A,al,U[ab],false,false,ae],a:this.getShapeArea(Z,(Y+R)+((N-this.variableSpaceFactor)/2),Q+(-O/2),N-this.variableSpaceFactor,-O,A,al,U[ab],false,false,ae),i:an[ab],m:W,t:ac,h:I})}else{ai=this.toRender({p:["drawShape",Z,(Y+R)+((N-this.variableSpaceFactor)/2),Q-(O/2),N-this.variableSpaceFactor,O,A,al,U[ab],false,false,ae],a:this.getShapeArea(Z,(Y+R)+((N-this.variableSpaceFactor)/2),Q-(O/2),N-this.variableSpaceFactor,O,A,al,U[ab],false,false,ae),i:an[ab],m:W,t:ac,h:I})}af=Q-O;S=Y+ad;if(ag[ab]&&this.isNumber(ag[ab],true)){L=(ag[ab]/2)*P;this.toRender({p:["drawLine","error",S,af,S,af-L,this.errorBarsColor,-ad,"butt"],g:ai,t:ac,h:I});this.toRender({p:["drawLine","error",S,af,S,af+L,this.errorBarsColor,-ad,"butt"],g:ai,t:ac,h:I})}if(M){var H=j(ab);for(var aj in M){if(aj!="cap"&&aj!="high"&&aj!="color"&&aj!="fill"){if(M[aj][H]){for(var F=0;F<M[aj][H].length;F++){var E=((M[aj][H][F][0]-X)*P)-K;var G=((M[aj][H][F][1]-X)*P)-K;var D=(Y+R)+((N-this.variableSpaceFactor)/2);this.toRender({p:["drawShape",this.shapes[0],D,Q-E,N/2,N/2,M.color[aj],M.color[aj]],g:ai,t:ac,h:I});if(!this.isNumber(G,true)){G=O-this.margin}else{this.toRender({p:["drawShape",this.shapes[1],D,Q-G,N/2,N/2,M.color[aj],M.color[aj]],g:ai,t:ac,h:I})}this.toRender({p:["drawLine","line",D,Q-E,D,Q-G,M.color[aj],this.margin],g:ai,t:ac,h:I})}}}}}if(this.showDataValues&&this.barType!="lollipop"){this.toRender({p:["drawText",this.formatNumber(ah[ab]),S,Q-(O+(this.margin/4)),this.smpLabelFont,A,"center","bottom"],g:ai,t:ac,h:I})}}Y+=T}}else{for(var ab=0;ab<ah.length;ab++){O=((ah[ab]-X)*P)-K;var ai;var Z=(M&&M.cap&&M.cap[j(ab)])||this.barType=="arrow"?"arrow":!this.useRoundRectangles?"rectangle":aa||O<0?"roundrectl":"roundrectr";var A=this.getFillColor(M?M.fill[j(ab)]:ak[ab],an[ab]);var al=N-this.variableSpaceFactor>5?this.getOutlineColor(A,an[ab]):A;var I=this.isHidden(an[ab][0],an[ab][1]);if(this.isNumber(O,true)){if(this.barPath){var B=this.addColorTransparency(this.barPathColor||A,this.barPathTransparency);this.toRender({p:["drawShape","rectangle",K+(this.x/2),(Q+R)+((N-this.variableSpaceFactor)/2),this.x*2,N-this.variableSpaceFactor,B,B],t:"Decorations"})}if(O<0){if(aa){ai=this.toRender({p:["drawShape",Z,((Y+aa)-K)+(-O/2),(Q+R)+((N-this.variableSpaceFactor)/2),-O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae],a:this.getShapeArea(Z,((Y+aa)-K)+(-O/2),(Q+R)+((N-this.variableSpaceFactor)/2),-O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae),i:an[ab],m:W,t:ac,h:I})}else{ai=this.toRender({p:["drawShape",Z,(Y+O)+(-O/2),(Q+R)+((N-this.variableSpaceFactor)/2),-O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae],a:this.getShapeArea(Z,(Y+O)+(-O/2),(Q+R)+((N-this.variableSpaceFactor)/2),-O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae),i:an[ab],m:W,t:ac,h:I})}}else{if(aa){ai=this.toRender({p:["drawShape",Z,((Y+aa)-(O+K))+(O/2),(Q+R)+((N-this.variableSpaceFactor)/2),O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae],a:this.getShapeArea(Z,((Y+aa)-(O+K))+(O/2),(Q+R)+((N-this.variableSpaceFactor)/2),O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae),i:an[ab],m:W,t:ac,h:I})}else{ai=this.toRender({p:["drawShape",Z,Y+(O/2),(Q+R)+((N-this.variableSpaceFactor)/2),O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae],a:this.getShapeArea(Z,Y+(O/2),(Q+R)+((N-this.variableSpaceFactor)/2),O,N-this.variableSpaceFactor,A,al,U[ab],Z=="arrow"?true:false,false,ae),i:an[ab],m:W,t:ac,h:I})}}af=aa?(Y+aa)-(O+K):Y+O;S=Q+ad;if(ag[ab]&&this.isNumber(ag[ab],true)){L=(ag[ab]/2)*P;this.toRender({p:["drawLine","error",af,S,af+L,S,this.errorBarsColor,ad,"butt"],g:ai,t:ac,h:I});this.toRender({p:["drawLine","error",af,S,af-L,S,this.errorBarsColor,ad,"butt"],g:ai,t:ac,h:I})}if(M){var H=j(ab);for(var aj in M){if(aj!="cap"&&aj!="high"&&aj!="color"&&aj!="fill"){if(M[aj][H]){for(var F=0;F<M[aj][H].length;F++){var E=((M[aj][H][F][0]-X)*P)-K;var G=((M[aj][H][F][1]-X)*P)-K;var C=(Q+R)+((N-this.variableSpaceFactor)/2);this.toRender({p:["drawShape",this.shapes[0],Y+E,C,N/2,N/2,M.color[aj],M.color[aj]],g:ai,t:ac,h:I});if(!this.isNumber(G,true)){G=O-this.margin}else{this.toRender({p:["drawShape",this.shapes[1],Y+G,C,N/2,N/2,M.color[aj],M.color[aj]],g:ai,t:ac,h:I})}this.toRender({p:["drawLine","line",Y+E,C,Y+G,C,M.color[aj],this.margin],g:ai,t:ac,h:I})}}}}}if(this.showDataValues&&this.barType!="lollipop"){this.toRender({p:["drawText",this.formatNumber(ah[ab]),af+(this.margin/4),S,this.smpLabelFont,ak[ab],"left","middle"],g:ai,t:ac,h:I})}}Q+=T}}};this.drawLinePlot=function(af,ae,W,P,N,ab,O,V,T,ah,R,Q,ak,ad,ac,X,F,aj){var J=function(){var b=[[],[]];if(T=="vertical"){for(var a=0;a<r[0].length;a++){b[0].push(r[0][a]);b[1].push(r[1][a][0])}for(var a=r[0].length-1;a>=0;a--){b[0].push(r[0][a]);b[1].push(r[1][a][1])}}else{for(var a=0;a<r[1].length;a++){b[0].push(r[0][a][0]);b[1].push(r[1][a])}for(var a=r[1].length-1;a>=0;a--){b[0].push(r[0][a][1]);b[1].push(r[1][a])}}return b};var S,A,y,x,j,am,al,ag,K,B,I;var M=null;var D=null;var H=N/2;var G=Math.min(10,N/3);var ai=R=="open"?ah:this.foreground;var U=af.length-1;var L=[[],[]];var r=[[],[]];var Y=[];var C=this.getVariableIndices(F);var aa=aj?"Overlays":"Data";if(T=="vertical"){A=W;y=W+ab;if(M==null){M=A}for(var Z=1;Z<af.length;Z++){S=Z-1;if(this.isObject(O)){j=P-((af[S]-O[S].min)*O[S].units);am=P-((af[Z]-O[Z].min)*O[Z].units)}else{j=P-((af[S]-V)*O);am=P-((af[Z]-V)*O)}if(D==null){D=j}I=this.lineBy?this.isHidden(false,false,"Property:"+this.lineBy+":"+ak[S][2]+":x"):false;if(this.isNumber(j,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&Q){ag=this.toRender({p:["drawShape",Q,A,j,G,G,ah,ai,R[S],false,false,ac],a:this.getShapeArea(Q,A,j,G,G,ah,ai,R[S],false,false,ac),i:ak[S],m:ad,g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}else{ag=this.toRender({p:["drawShape","sphere",A,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[S],false,false,ac],a:this.getShapeArea("sphere",A,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[S],false,false,ac),i:ak[S],m:ad,g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(af[S]),A,j-this.margin,this.smpLabelFont,this.smpLabelFontColor,"center","bottom"],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}if(!K){K=ag}if(this.isNumber(ae[S],true)){al=(ae[S]/2)*this.isObject(O)?O[S].units:O;if(this.lineErrorType=="bar"){this.toRender({p:["drawLine","error",A,j,A,j+al,ah,-H,"butt"],a:this.getLineArea("error",A,j,A,j+al,ah,-H,"butt"),i:["Line:"+F+":"+C],g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)});this.toRender({p:["drawLine","error",A,j,A,j-al,ah,-H,"butt"],a:this.getLineArea("error",A,j,A,j-al,ah,-H,"butt"),i:["Line:"+F+":"+C],g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}else{r[0].push([A,A]);r[1].push([j+al,j-al]);Y.push([A,j])}}if(this.lineType=="spline"){L[0].push(A);L[1].push(j)}}if((this.lineType!="spline"&&this.isNumber(j,true)&&this.isNumber(am,true))||af.length<3){ag=this.toRender({p:["drawLine",this.lineDecoration=="pattern"?R[S]:this.lineType,A,j,y,am,ah,this.lineThickness,"butt",false,false,ac],a:this.getLineArea("line",A,j,y,am,ah,this.lineThickness,"butt",false,false,ac),i:["Line:"+F+":"+C],g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}else{if(this.lineType=="spline"&&!this.isNumber(am,true)){ag=this.toRender({p:["drawLine","spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac],a:this.getLineArea("spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac),i:["Line:"+F+":"+C],g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)});L=[[],[]];M=null;D=null}}if(!K){K=ag}if(r[0].length>0&&!this.isNumber(am,true)){var v=this.addColorTransparency(ah,0.3,true);if(this.lineType=="spline"){this.toRender({p:["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],a:this.getShapeArea("confidence",r[0],r[1],false,false,v,v,"closed"),i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{var E=J();this.toRender({p:["drawShape","path",E[0],E[1],false,false,v,v,"closed"],a:this.getShapeArea("path",E[0],E[1],false,false,v,v,"closed"),i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}r=[[],[]];Y=[]}A+=ab;y+=ab}I=this.lineBy?this.isHidden(false,false,"Property:"+this.lineBy+":"+ak[U][2]+":x"):false;if(this.isNumber(am,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&Q){ag=this.toRender({p:["drawShape",Q,A,am,G,G,ah,ai,R[U],false,false,ac],a:this.getShapeArea(Q,A,am,G,G,ah,ai,R[U],false,false,ac),i:ak[U],m:ad,g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}else{ag=this.toRender({p:["drawShape","sphere",A,am,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[U],false,false,ac],a:this.getShapeArea("sphere",A,am,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[U],false,false,ac),i:ak[U],m:ad,g:K,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(af[U]),A,am-this.margin,this.smpLabelFont,this.smpLabelFontColor,"center","bottom"],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}if(!K){K=ag}if(this.isNumber(ae[U],true)){al=(ae[U]/2)*this.isObject(O)?O[U].units:O;if(this.lineErrorType=="bar"){this.toRender({p:["drawLine","error",A,am,A,am+al,ah,-H,"butt"],a:this.getLineArea("error",A,am,A,am+al,ah,-H,"butt"),i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)});this.toRender({p:["drawLine","error",A,am,A,am-al,ah,-H,"butt"],a:this.getLineArea("error",A,am,A,am-al,ah,-H,"butt"),i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{if(Z==af.length){r[0].push([A,A]);r[1].push([am+al,am-al]);Y.push([A,am])}}}if(this.lineType=="spline"){L[0].push(A);L[1].push(am)}}if(this.lineType=="spline"){ag=this.toRender({p:["drawLine","spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac],a:this.getLineArea("spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac),i:["Line:"+F+":"+C],b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}if(!K){K=ag}if(r[0].length>0){var v=this.addColorTransparency(ah,0.3,true);if(this.lineType=="spline"){this.toRender({p:["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],a:this.getShapeArea("confidence",r[0],r[1],false,false,v,v,"closed"),i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{var E=J();this.toRender({p:["drawShape","path",E[0],E[1],false,false,v,v,"closed"],a:this.getShapeArea("path",E[0],E[1],false,false,v,v,"closed"),i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}}}else{j=P;am=P+ab;if(D==null){D=j}for(var Z=1;Z<af.length;Z++){S=Z-1;if(this.isObject(O)){A=X?W+X-((af[S]-O[S].min)*O[S].units):W+((af[S]-O[S].min)*O[S].units);y=X?W+X-((af[Z]-O[Z].min)*O[Z].units):W+((af[Z]-O[Z].min)*O[Z].units)}else{A=X?W+X-((af[S]-V)*O):W+((af[S]-V)*O);y=X?W+X-((af[Z]-V)*O):W+((af[Z]-V)*O)}if(M==null){M=A}I=this.lineBy?this.isHidden(false,false,"Property:"+this.lineBy+":"+ak[S][2]+":x"):false;if(this.isNumber(A,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&Q){this.toRender({p:["drawShape",Q,A,j,G,G,ah,ai,R[S],false,false,ac],a:this.getShapeArea(Q,A,j,G,G,ah,ai,R[S],false,false,ac),i:ak[S],m:ad,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}else{this.toRender({p:["drawShape","sphere",A,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[S],false,false,ac],a:this.getShapeArea("sphere",A,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[S],false,false,ac),i:ak[S],m:ad,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(af[S]),A,j-this.margin,this.smpLabelFont,this.smpLabelFontColor,"center","bottom"],t:aa,h:this.lineBy?I:this.isHidden(ak[S][0],ak[S][1])})}if(this.isNumber(ae[S],true)){x=(ae[S]/2)*this.isObject(O)?O[S].units:O;if(this.lineErrorType=="bar"){ag=this.toRender({p:["drawLine","error",A,j,A+x,j,ah,H,"butt"],a:this.getLineArea("error",A,j,A+x,j,ah,H,"butt"),i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)});if(!K){K=ag}this.toRender({p:["drawLine","error",A,j,A-x,j,ah,H,"butt"],a:this.getLineArea("error",A,j,A-x,j,ah,H,"butt"),i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{r[0].push([A+x,A-x]);r[1].push([j,j]);Y.push([A,j])}}if(this.lineType=="spline"){L[0].push(A);L[1].push(j)}}if((this.lineType!="spline"&&this.isNumber(A,true)&&this.isNumber(y,true))||af.length<3){ag=this.toRender({p:["drawLine",this.lineDecoration=="pattern"?R[S]:this.lineType,A,j,y,am,ah,this.lineThickness,"butt",false,false,ac],a:this.getLineArea("line",A,j,y,am,ah,this.lineThickness,"butt",false,false,ac),i:["Line:"+F+":"+C],b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}else{if(this.lineType=="spline"&&!this.isNumber(y,true)){ag=this.toRender({p:["drawLine","spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac],a:this.getLineArea("spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac),i:["Line:"+F+":"+C],b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)});L=[[],[]];M=null;D=null}}if(!K){K=ag}if(r[1].length>0&&!this.isNumber(y,true)){var v=this.addColorTransparency(ah,0.3,true);if(this.lineType=="spline"){this.toRender({p:["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],a:this.getShapeArea("confidence",r[0],r[1],false,false,v,v,"closed"),i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{var E=J();this.toRender({p:["drawShape","path",E[0],E[1],false,false,v,v,"closed"],a:this.getShapeArea("path",E[0],E[1],false,false,v,v,"closed"),i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}r=[[],[]];Y=[]}j+=ab;am+=ab}I=this.lineBy?this.isHidden(false,false,"Property:"+this.lineBy+":"+ak[U][2]+":x"):false;if(this.isNumber(y,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&Q){this.toRender({p:["drawShape",Q,y,j,G,G,ah,ai,R[U],false,false,ac],a:this.getShapeArea(Q,y,j,G,G,ah,ai,R[U],false,false,ac),i:ak[U],m:ad,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}else{this.toRender({p:["drawShape","sphere",y,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[U],false,false,ac],a:this.getShapeArea("sphere",y,j,G,G,this.addColorTransparency(ah,0,true),"rgba(0,0,0,0)",R[U],false,false,ac),i:ak[U],m:ad,b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(af[U]),y,j-this.margin,this.smpLabelFont,this.smpLabelFontColor,"center","bottom"],t:aa,h:this.lineBy?I:this.isHidden(ak[U][0],ak[U][1])})}if(this.isNumber(ae[U],true)){x=(ae[U]/2)*this.isObject(O)?O[U].units:O;if(this.lineErrorType=="bar"){ag=this.toRender({p:["drawLine","error",y,j,y+x,j,ah,H,"butt"],a:this.getLineArea("error",y,j,y+x,j,ah,H,"butt"),i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)});if(!K){K=ag}this.toRender({p:["drawLine","error",y,j,y-x,j,ah,H,"butt"],a:this.getLineArea("error",y,j,y-x,j,ah,H,"butt"),i:["Line:"+F+":"+C],g:K,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{r[0].push([y+x,y-x]);r[1].push([j,j]);Y.push([y,j])}}if(this.lineType=="spline"){L[0].push(y);L[1].push(j)}}if(this.lineType=="spline"){ag=this.toRender({p:["drawLine","spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac],a:this.getLineArea("spline",L[0],L[1],false,false,ah,this.lineThickness,false,false,false,ac),i:["Line:"+F+":"+C],b:[M,D],t:aa,h:this.lineBy?I:this.isHidden(C)})}if(!K){K=ag}if(r[1].length>0){var v=this.addColorTransparency(ah,0.3,true);if(this.lineType=="spline"){this.toRender({p:["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],a:this.getShapeArea("confidence",r[0],r[1],false,false,v,v,"closed"),i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}else{var E=J();this.toRender({p:["drawShape","path",E[0],E[1],false,false,v,v,"closed"],a:this.getShapeArea("path",E[0],E[1],false,false,v,v,"closed"),i:["Line-Error:"+F+":"+C],b:Y,t:aa,h:this.lineBy?I:this.isHidden(C)})}}}};this.drawStackedPlot=function(S,L,D,A,U,G,P,C,x,H,T,F,V,J,M,Q,R){var j=D;var y=L;var r=this;var W=R?"Overlays":"Data";var O=function(c,e,b,d,a){return r.processTreemap(c,{width:d,height:a,left:e,top:b})};if(H=="vertical"){D=j-x;for(var N=0;N<S.length;N++){if(S[N]>0){var B=G?(S[N]*100/P[0])*C:S[N]*C;var K=N==S.length-1&&this.useRoundRectangles?"roundrectt":"rectangle";var s=this.getFillColor(T[N],V[N]);var m=A>5?this.getOutlineColor(s,V[N]):s;if(this.graphType=="Network"){this.toRender({p:["drawShape",K,L+(A/2),D-(B/2),A,B,T[N],T[N]],a:this.getShapeArea(K,L+(A/2),D-(B/2),A,B,T[N],T[N]),i:V[N],m:J,t:"Decorations"})}else{if(U){var I=O(U[N],L,D-B,A,B);this.drawTreemap(I,0,0)}else{var h=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+V[N][4]+":x"):this.isHidden(V[N][0],V[N][1]);var E=this.toRender({p:["drawShape",K,L+(A/2),D-(B/2),A,B,s,m,F[N]],a:this.getShapeArea(K,L+(A/2),D-(B/2),A,B,s,m,F[N]),i:V[N],m:J,b:Q,t:W,h:h});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(S[N]),L+(A/2),D-(B/2),this.smpLabelFont,this.smpLabelFontColor,"center","middle"],g:E,t:W,h:h})}}}D-=B}}D=j-x;for(var N=S.length-1;N>=0;N--){if(S[N]<0){var B=G?(S[N]*100/-P[1])*C:S[N]*C;var K=N>0||!this.useRoundRectangles?"rectangle":"roundrectb";var s=this.getFillColor(T[N],V[N]);var m=A>5?this.getOutlineColor(s,V[N]):s;if(this.graphType=="Network"){this.toRender({p:["drawShape",K,L+(A/2),D-(B/2),A,-B,T[N],T[N]],a:this.getShapeArea(K,L+(A/2),D-(B/2),A,-B,T[N],T[N]),i:V[N],m:J,t:"Decorations"})}else{if(U){var I=O(U[N],L,D-B,A,-B);this.drawTreemap(I,0,0)}else{var h=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+V[N][4]+":x"):this.isHidden(V[N][0],V[N][1]);var E=this.toRender({p:["drawShape",K,L+(A/2),D-(B/2),A,-B,s,m,F[N]],a:this.getShapeArea(K,L+(A/2),D-(B/2),A,-B,s,m,F[N]),i:V[N],m:J,b:Q,t:W,h:h});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(S[N]),L+(A/2),D-(B/2),this.smpLabelFont,this.smpLabelFontColor,"center","middle"],g:E,t:W,h:h})}}}D-=B}}}else{L=y+x;for(var N=0;N<S.length;N++){if(S[N]>0){var B=G?(S[N]*100/P[0])*C:S[N]*C;var K=N<S.length-1||!this.useRoundRectangles?"rectangle":M?"roundrectl":"roundrectr";var s=this.getFillColor(T[N],V[N]);var m=A>5?this.getOutlineColor(s,V[N]):s;if(M){if(this.graphType=="Network"){this.toRender({p:["drawShape",K,L+M-(B/2),D+(A/2),B,A,T[N],T[N],F[N]],a:this.getShapeArea(K,L+M-(B/2),D+(A/2),B,A,T[N],T[N],F[N]),i:V[N],m:J,t:"Decorations"})}else{if(U){var I=O(U[N],L+M-B,D,B,A);this.drawTreemap(I,0,0)}else{var h=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+V[N][4]+":x"):this.isHidden(V[N][0],V[N][1]);var E=this.toRender({p:["drawShape",K,L+M-(B/2),D+(A/2),B,A,s,m,F[N]],a:this.getShapeArea(K,L+M-(B/2),D+(A/2),B,A,s,m,F[N]),i:V[N],m:J,b:Q,t:W,h:h});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(S[N]),L+M-(B/2),D+(A/2),this.smpLabelFont,this.smpLabelFontColor,"center","middle"],g:E,t:W,h:h})}}}L-=B}else{if(this.graphType=="Network"){this.toRender({p:["drawShape",K,L+(B/2),D+(A/2),B,A,T[N],T[N],F[N]],a:this.getShapeArea(K,L+(B/2),D+(A/2),B,A,T[N],T[N],F[N]),i:V[N],m:J,t:"Decorations"})}else{if(U){var R=O(U[N],L,D,B,A);this.drawTreemap(R,0,0)}else{var h=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+V[N][4]+":x"):this.isHidden(V[N][0],V[N][1]);var E=this.toRender({p:["drawShape",K,L+(B/2),D+(A/2),B,A,s,m,F[N]],a:this.getShapeArea(K,L+(B/2),D+(A/2),B,A,s,m,F[N]),i:V[N],m:J,b:Q,t:W,h:h});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(S[N]),L+(B/2),D+(A/2),this.smpLabelFont,this.smpLabelFontColor,"center","middle"],g:E,t:W,h:h})}}}L+=B}}}L=y+x;for(var N=S.length-1;N>=0;N--){if(S[N]<0){var B=G?(S[N]*100/-P[1])*C:S[N]*C;var K=N>0||!this.useRoundRectangles?"rectangle":M?"roundrectr":"roundrectl";var s=this.getFillColor(T[N],V[N]);var m=A>5?this.getOutlineColor(s,V[N]):s;if(M){if(this.graphType=="Network"){this.toRender({p:["drawShape",K,L+M-(B/2),D+(A/2),-B,A,T[N],T[N],F[N]],a:this.getShapeArea(K,L+M-(B/2),D+(A/2),-B,A,T[N],T[N],F[N]),i:V[N],m:J,t:"Decorations"})}else{if(U){var I=O(U[N],L+M-B,D,-B,A);this.drawTreemap(I,0,0)}else{var h=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+V[N][4]+":x"):this.isHidden(V[N][0],V[N][1]);var E=this.toRender({p:["drawShape",K,L+M-(B/2),D+(A/2),-B,A,s,m,F[N]],a:this.getShapeArea(K,L+M-(B/2),D+(A/2),-B,A,s,m,F[N]),i:V[N],m:J,b:Q,t:W,h:h});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(S[N]),L+M-(B/2),D+(A/2),this.smpLabelFont,this.smpLabelFontColor,"center","middle"],g:E,t:W,h:h})}}}L-=B}else{if(this.graphType=="Network"){this.toRender({p:["drawShape",K,L+(B/2),D+(A/2),-B,A,T[N],T[N],F[N]],a:this.getShapeArea(K,L+(B/2),D+(A/2),-B,A,T[N],T[N],F[N]),i:V[N],m:J,t:"Decorations"})}else{if(U){var R=O(U[N],L,D,-B,A);this.drawTreemap(R,0,0)}else{var h=this.stackBy?this.isHidden(false,false,"Property:"+this.stackBy+":"+V[N][4]+":x"):this.isHidden(V[N][0],V[N][1]);var E=this.toRender({p:["drawShape",K,L+(B/2),D+(A/2),-B,A,s,m,F[N]],a:this.getShapeArea(K,L+(B/2),D+(A/2),-B,A,s,m,F[N]),i:V[N],m:J,b:Q,t:W,h:h});if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(S[N]),L+(B/2),D+(A/2),this.smpLabelFont,this.smpLabelFontColor,"center","middle"],g:E,t:W,h:h})}}}L+=B}}}}};this.drawAreaPlot=function(ai,Z,S,Q,ae,T,ag,V,J,D,m,X,af,ak,W,an,al,M,G,am){var Y=ai.length-1;var aa=af&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var A=[];var B=[];var U=[];var ao=-D*J;var C=m*J;var ad=am?"Overlays":"Data";var L=function(b,a){for(var c=a+1;c<ai[b].length;c++){if(ai[b][c]>0){return 1}else{if(ai[b][c]<0){return -1}}}return 0};if(X=="vertical"){for(var ac=0;ac<ai[0].length;ac++){A[ac]=ag=="stacked"&&D<0?S-C:S;B[ac]=S-C}for(var ac=0;ac<ai.length;ac++){var ah=Z;var P=af?[]:[Z];var N=af?[]:[S-ao];var H=0;var aj,K;for(var ab=0;ab<ai[0].length;ab++){if(!this.isNumber(ai[ac][ab],true)){if(!af){P.push(ah-T);N.push(S-ao)}if(af&&this.lineType=="spline"){this.toRender({p:["drawLine",aa,P,N,false,false,ak[ac],this.lineThickness],a:this.getLineArea(aa,P,N,false,false,ak[ac],this.lineThickness),i:an[ac],m:al,b:S-ao,t:ad,h:this.isHidden(an[ac][0])})}else{if(D>=0&&Y>0&&ag!="normal"){var E=U[U.length-1][1];P.shift();var F=[];var ap=[];for(var ac=1;ac<N.length;ac++){F.push([P[ac-1],P[ac-1]]);ap.push([N[ac],E[ac]])}this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ak[Y],an[Y]),this.getOutlineColor(ak[Y],an[Y]),W[Y]],a:this.getShapeArea("confidence",F,ap,this.width,this.height,this.getFillColor(ak[Y],an[Y]),this.getOutlineColor(ak[Y],an[Y]),W[Y]),i:an[Y],m:al,b:S-ao,t:ad,h:this.isHidden(an[Y][0])})}else{this.toRender({p:["drawShape",aa,P,N,this.width,this.height,this.getFillColor(ak[ac],an[ac]),this.getOutlineColor(ak[ac],an[ac]),W[ac]],a:this.getShapeArea(aa,P,N,this.width,this.height,this.getFillColor(ak[ac],an[ac]),this.getOutlineColor(ak[ac],an[ac]),W[ac]),i:an[ac],m:al,b:S-ao,t:ad,h:this.isHidden(an[ac][0])})}}if(G){var u=this.addColorTransparency(ak[ac],0,true);for(var I=0;I<P.length;I++){aj=this.toRender({p:["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],a:this.getShapeArea("sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]),i:[an[ac][0],G[I]],s:true,t:ad});if(!af){this.toRender({p:["drawLine","line",P[I],N[I]+T,P[I],N[0],u,T],a:this.getLineArea("line",P[I],N[I]+T,P[I],N[0],u,T),i:[an[ac][0],G[I]],g:aj,s:true,t:ad})}}}P=af?[]:[ah+T];N=af?[]:[S-ao]}else{var R=ag=="percent"?((ai[ac][ab]-D)*100/V[ab])*J:(ai[ac][ab]-(ag=="stacked"&&D<0?0:D))*J;P.push(ah);if(ag&&(ag=="stacked"||ag=="percent")){if(ai[ac][ab]>0||H>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{if(ai[ac][ab]<0||H<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{var O=L(ac,ab);if(O<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{if(O>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{N.push(ao)}}}}}else{N.push(S-R)}}ah+=T}if(!af){P.push(Z+Q);N.push(S-ao)}U.push([P,N,ak[ac],W[ac],an[ac]])}}else{for(var ac=0;ac<ai[0].length;ac++){A[ac]=M?Z+M:ag=="stacked"&&D<0?Z+C:Z;B[ac]=Z+C}for(var ac=0;ac<ai.length;ac++){var ah=S;var P=af?[]:M?[Z+M]:[Z+ao];var N=af?[]:[S];var H=0;var aj,K;for(var ab=0;ab<ai[0].length;ab++){if(!this.isNumber(ai[ac][ab],true)){if(!af){P.push(M?Z+M:Z+ao);N.push(ah-T)}if(af&&this.lineType=="spline"){this.toRender({p:["drawLine",aa,P,N,false,false,ak[ac],this.lineThickness],a:this.getLineArea(aa,P,N,false,false,ak[ac],this.lineThickness),i:an[ac],m:al,b:Z+ao,t:ad,h:this.isHidden(an[ac][0])})}else{var E=U[U.length-1][0];if(D>=0&&Y>0&&ag!="normal"){N.shift();var F=[];var ap=[];for(var ac=1;ac<P.length;ac++){F.push([P[ac],E[ac]]);ap.push([N[ac-1],N[ac-1]])}this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ak[Y],an[Y]),this.getOutlineColor(ak[Y],an[Y]),W[Y]],a:this.getShapeArea("confidence",F,ap,this.width,this.height,this.getFillColor(ak[Y],an[Y]),this.getOutlineColor(ak[Y],an[Y]),W[Y]),i:an[Y],m:al,b:Z+ao,t:ad,h:this.isHidden(an[Y][0])})}else{this.toRender({p:["drawShape",aa,P,N,this.width,this.height,this.getFillColor(ak[ac],an[ac]),this.getOutlineColor(ak[ac],an[ac]),W[ac]],a:this.getShapeArea(aa,P,N,this.width,this.height,this.getFillColor(ak[ac],an[ac]),this.getOutlineColor(ak[ac],an[ac]),W[ac]),i:an[ac],m:al,b:Z+ao,t:ad,h:this.isHidden(an[ac][0])})}}if(G){var u=this.addColorTransparency(ak[ac],0,true);for(var I=0;I<P.length;I++){aj=this.toRender({p:["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],a:this.getShapeArea("sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]),i:[an[ac][0],G[I]],s:true,t:ad});if(!af){this.toRender({p:["drawLine","line",P[I]-T,N[I],P[0],N[I],u,T],a:this.getLineArea("line",P[I]-T,N[I],P[0],N[I],u,T),i:[an[ac][0],G[I]],g:aj,s:true,t:ad})}}}P=af?[]:[M?Z+M:Z+ao];N=af?[]:[ah+T]}else{var R=ag=="percent"?((ai[ac][ab]-D)*100/V[ab])*J:(ai[ac][ab]-(ag=="stacked"&&D<0?0:D))*J;N.push(ah);if(ag&&(ag=="stacked"||ag=="percent")){if(M){P.push(A[ab]-R);A[ab]-=R}else{if(ai[ac][ab]>0||H>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{if(ai[ac][ab]<0||H<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{var O=L(ac,ab);if(O<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{if(O>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{N.push(ao)}}}}}}else{P.push(M?Z+M-R:Z+R)}}ah+=T}if(!af){P.push(M?Z+M:Z+ao);N.push(S+ae)}U.push([P,N,ak[ac],W[ac],an[ac]])}}while(Y>=0){var aj,K;var ab=U.pop();if(af){if(this.lineType=="spline"){this.toRender({p:["drawLine",aa,ab[0],ab[1],false,false,ab[2],this.lineThickness],a:this.getLineArea(aa,ab[0],ab[1],false,false,ab[2],this.lineThickness),i:ab[4],m:al,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.isHidden(ab[4][0])})}else{var K=null;for(var ac=1;ac<ab[0].length;ac++){var aj=this.toRender({p:["drawLine",aa,ab[0][ac-1],ab[1][ac-1],ab[0][ac],ab[1][ac],ab[2],this.lineThickness],a:this.getLineArea(aa,ab[0][ac-1],ab[1][ac-1],ab[0][ac],ab[1][ac],ab[2],this.lineThickness),i:ab[4],m:al,g:K,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.isHidden(ab[4][0])});if(K==null){K=aj}}}}else{if(D>=0&&Y>0&&ag!="normal"){var E=X=="vertical"?U[U.length-1][1]:U[U.length-1][0];if(X=="vertical"){ab[0].shift();ab[0].pop();var F=[];var ap=[];for(var ac=1;ac<ab[1].length-1;ac++){F.push([ab[0][ac-1],ab[0][ac-1]]);ap.push([ab[1][ac],E[ac]])}ab[1].shift();ab[1].pop();this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],a:this.getShapeArea("confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]),i:ab[4],m:al,b:S-ao,t:ad,h:this.isHidden(ab[4][0])})}else{ab[1].shift();ab[1].pop();var F=[];var ap=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],E[ac]]);ap.push([ab[1][ac-1],ab[1][ac-1]])}ab[0].shift();ab[0].pop();this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],a:this.getShapeArea("confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]),i:ab[4],m:al,b:Z+ao,t:ad,h:this.isHidden(ab[4][0])})}}else{if(ag=="normal"||ag=="stacked"){this.toRender({p:["drawShape",aa,ab[0],ab[1],this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],a:this.getShapeArea(aa,ab[0],ab[1],this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]),i:ab[4],m:al,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.isHidden(ab[4][0])})}else{if(X=="vertical"){var ap=[];for(var ac=1;ac<ab[1].length-1;ac++){ap.push([ab[1][ac],ab[1][0]])}this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],a:this.getShapeArea("confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]),i:ab[4],m:al,b:S-ao,t:ad,h:this.isHidden(ab[4][0])})}else{var F=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],ab[0][0]])}this.toRender({p:["drawShape","confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]],a:this.getShapeArea("confidence",F,ap,this.width,this.height,this.getFillColor(ab[2]),this.getOutlineColor(ab[2]),ab[3]),i:ab[4],m:al,b:Z+ao,t:ad,h:this.isHidden(ab[4][0])})}}}}if(G){var u=this.addColorTransparency(ab[2],0,true);var g=Math.min(10,T);for(var ac=1;ac<ab[0].length-1;ac++){if(this.isGraphTime&&G[ac-1]<0){continue}aj=this.toRender({p:["drawShape","sphere",ab[0][ac],ab[1][ac],g,g,u,"rgba(0,0,0,0)",ab[3]],a:this.getShapeArea("sphere",ab[0][ac],ab[1][ac],g,g,u,"rgba(0,0,0,0)",ab[3]),i:[ab[4][0],G[ac-1]],s:true,t:ad});if(!af){if(X=="vertical"){this.toRender({p:["drawLine","line",ab[0][ac],ab[1][ac]+T,ab[0][ac],ab[1][0],u,T],a:this.getLineArea("line",ab[0][ac],ab[1][ac]+T,ab[0][ac],ab[1][0],u,T),i:[ab[4][0],G[ac-1]],g:aj,s:true,t:ad})}else{this.toRender({p:["drawLine","line",ab[0][ac]-T,ab[1][ac],ab[0][0],ab[1][ac],u,T],a:this.getLineArea("line",ab[0][ac]-T,ab[1][ac],ab[0][0],ab[1][ac],u,T),i:[ab[4][0],G[ac-1]],g:aj,s:true,t:ad})}}}}Y--}};this.drawBoxPlot=function(aq,ag,Y,V,ab,X,af,ad,ar,ac,au,am,n,U){var S=this;var ae=this.segregateSamplesBy.length&&this.isGroupedData&&this.groupingFactors.includes(this.segregateSamplesBy[0]);var C=function(f){var d;if(S.layoutValid&&!S.isDOE){if(S.segregateVariablesBy.length>0){d=f}else{if(S.segregateSamplesBy.length>0){var a=!ae?[S.data.l.name[S.layoutCurrent],S.data.w.glab[f]].join("::"):S.data.w.labs[f]?S.data.w.labs[f]:S.data.w.glab[f];for(var c=0;c<k.g[D].length;c++){if(k.g[D][c].density.name==a){d=c;break}}}}}else{d=S.grpIndices[f]}return k.g[D][d]};var T=function(a){return ad=="vertical"?Y-((a-af)*X):ag+((a-af)*X)};var k=this.meta.data.d;var D=this.getVariableIndices(U);var Z=this.variableSpaceFactor/2;var ak=V/2;var G=ak/2;var E=G/2;var ao=V/this.boxplotOutliersRatio;var F={};var R={};var K=false;var P=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?(V-this.variableSpaceFactor)*this.boxplotWidthRatioIfViolin:V-this.variableSpaceFactor;var O=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?V*this.boxplotWidthRatioIfViolin:0;var N=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?O/2:ak;var b=Math.max(1,V/4);if(ad=="vertical"){for(var aj=0;aj<aq.length;aj++){if(this.isGraphTime&&au[aj][1]<0){ag+=ab;continue}var Q=this.showBoxplotOriginalData?this.isHidden(au[aj][0]):this.scatterPlotMatrix&&this.scatterType=="boxplot"?this.isHidden(false,false,au[aj][1]):this.isHidden(au[aj][0],au[aj][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&aq[aj].length>1){var B=C(this.layoutValid?au[aj][1]:aj);if(B){this.drawViolin(B,ag+(V/2),Y,V/this.varIndices.length,X,af,ad,am[aj],n[aj],au[aj],Q);if(!this.showBoxplotIfViolin){K=true}}}var aa=ag+ak;var W=[];var A=[];var L=this.showBoxplotOriginalData||this.showViolinBoxplot?am[aj]:ar[aj];for(var ai=0;ai<5;ai++){W.push(T(aq[aj][ai]));A.push(W[W.length-1].toString())}if(!K){var M=(ag+Z)+((V-this.variableSpaceFactor)/2);var an=W[3]+((W[2]-W[3])/2);var al=P;var at=W[2]-W[3];var e=this.boxplotNotched?T(aq[aj][7][0]):false;var ah=this.boxplotNotched?T(aq[aj][7][1]):false;var I=this.showBoxplotOriginalData?this.addColorTransparency(this.getFillColor(ar[aj],au[aj]),this.boxplotTransparency,true):this.getFillColor(ar[aj],au[aj]);var H=this.getOutlineColor(I,au[aj]);var ap,J,x;if(this.boxplotNotched&&this.boxplotType!="range"){if(this.showViolinBoxplot){J=[ag+(V-Z-O)-b,ag+Z+O,ag+Z+O,ag+(V-Z-O),ag+(V-Z-O),ag+Z+O+b,ag+(V-Z-O)-b]}else{J=[ag+Z+O+b,ag+Z+O,ag+Z+O,ag+(V-Z-O),ag+(V-Z-O),ag+(V-Z-O)-b,ag+Z+O+b]}x=[W[4],e,W[2],W[2],e,W[4],W[4]];ap=this.toRender({p:["drawShape","polygon",J,x,false,false,I,H,ac[aj]],a:this.getShapeArea("polygon",J,x,false,false,I,H,ac[aj]),i:au[aj],b:Y,t:"Data",h:Q});x=[W[4],ah,W[3],W[3],ah,W[4],W[4]];this.toRender({p:["drawShape","polygon",J,x,false,false,I,H,ac[aj]],a:this.getShapeArea("polygon",J,x,false,false,I,H,ac[aj]),i:au[aj],g:ap,b:Y,t:"Data",h:Q})}else{if(this.boxplotType=="range"){ap=this.toRender({p:["drawLine","line",M,W[1],M,W[0],this.useOpenShapes?H:I,ao,"round"],a:this.getLineArea("line",M,W[1],M,W[0],this.useOpenShapes?H:I,ao,"round"),i:au[aj],b:Y,t:"Data",h:Q})}else{ap=this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",M,an,al,at,I,H,ac[aj]],a:this.getShapeArea(this.useRoundRectangles?"roundrect":"rectangle",M,an,al,at,I,H,ac[aj]),i:au[aj],b:Y,t:"Data",h:Q})}}if(this.unique(A).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.toRender({p:["drawLine","median",ag+Z+O+b,W[4],ag+(V-Z-O)-b,W[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],a:this.getLineArea("median",ag+Z+O+b,W[4],ag+(V-Z-O)-b,W[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"),i:au[aj],g:ap,t:"Data",h:Q})}else{if(this.boxplotType=="range"){this.toRender({p:["drawShape","sphere",M,W[4],ao*2.5,ao*2.5,this.useOpenShapes?H:I,this.useOpenShapes?H:I],a:this.getShapeArea("sphere",M,W[4],ao*2.5,ao*2.5,this.useOpenShapes?H:I,this.useOpenShapes?H:I),i:au[aj],g:ap,t:"Data",h:Q})}else{this.toRender({p:["drawLine","median",ag+Z+O,W[4],ag+(V-Z-O),W[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],a:this.getLineArea("median",ag+Z+O,W[4],ag+(V-Z-O),W[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"),i:au[aj],g:ap,t:"Data",h:Q})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){this.toRender({p:["drawLine","line",aa,W[2],aa,W[0],H,false,"butt"],a:this.getLineArea("line",aa,W[2],aa,W[0],H,false,"butt"),i:au[aj],g:ap,t:"Data",h:Q});this.toRender({p:["drawLine","line",aa,W[3],aa,W[1],H,false,"butt"],a:this.getLineArea("line",aa,W[3],aa,W[1],H,false,"butt"),i:au[aj],g:ap,t:"Data",h:Q})}else{if(this.boxplotWhiskersType=="double"){this.toRender({p:["drawLine","error",aa,W[2],aa,W[0],H,-N,"butt"],a:this.getLineArea("error",aa,W[2],aa,W[0],H,-N,"butt"),i:au[aj],g:ap,t:"Data",h:Q});this.toRender({p:["drawLine","error",aa,W[3],aa,W[1],H,-N,"butt"],a:this.getLineArea("error",aa,W[3],aa,W[1],H,-N,"butt"),i:au[aj],g:ap,t:"Data",h:Q})}}}}if(this.boxplotMean){this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",aa,T(aq[aj][6]),G,G,this.boxplotMeanColor,this.boxplotMeanColorBorder],a:this.getShapeArea(this.useRoundRectangles?"roundrect":"rectangle",aa,T(aq[aj][6]),G,G,this.boxplotMeanColor,this.boxplotMeanColorBorder),i:au[aj],g:ap,b:Y,t:"Data",h:Q})}if(aq[aj][5]&&!this.showBoxplotOriginalData){for(var ai=0;ai<aq[aj][5].length;ai++){this.toRender({p:["drawShape","sphere",aa,T(aq[aj][5][ai]),ao,ao,I,H,ac[aj]],a:this.getShapeArea("sphere",aa,T(aq[aj][5][ai]),ao,ao,I,H,ac[aj]),i:au[aj],g:ap,b:Y,t:"Data",h:Q})}}}if(!F.hasOwnProperty(L)){F[L]=[];R[L]=this.cloneObject(au[aj])}F[L].push([ag+Z+(V/2),W[4]]);ag+=ab}}else{for(var aj=0;aj<aq.length;aj++){if(this.isGraphTime&&au[aj][1]<0){Y+=ab;continue}var Q=this.showBoxplotOriginalData?this.isHidden(au[aj][0]):this.isHidden(au[aj][0],au[aj][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&aq[aj].length>1){var B=C(this.layoutValid?au[aj][1]:aj);if(B){this.drawViolin(B,ag,Y+(V/2),V/this.varIndices.length,X,af,ad,am[aj],n[aj],au[aj],Q);if(!this.showBoxplotIfViolin){K=true}}}var aa=Y+ak;var W=[];var A=[];var L=this.showBoxplotOriginalData||this.showViolinBoxplot?am[aj]:ar[aj];for(var ai=0;ai<5;ai++){W.push(T(aq[aj][ai]));A.push(W[W.length-1].toString())}if(!K){var M=W[2]+((W[3]-W[2])/2);var an=(Y+Z)+((V-this.variableSpaceFactor)/2);var al=W[3]-W[2];var at=P;var e=this.boxplotNotched?T(aq[aj][7][0]):false;var ah=this.boxplotNotched?T(aq[aj][7][1]):false;var I=this.showBoxplotOriginalData?this.addColorTransparency(this.getFillColor(ar[aj],au[aj]),this.boxplotTransparency,true):this.getFillColor(ar[aj],au[aj]);var H=this.getOutlineColor(I,au[aj]);var ap,J,x;if(this.boxplotNotched&&this.boxplotType!="range"){J=[W[4],e,W[2],W[2],e,W[4],W[4]];if(this.showViolinBoxplot){x=[Y+(V-Z-O)-b,Y+Z+O,Y+Z+O,Y+(V-Z-O),Y+(V-Z-O),Y+Z+O+b,Y+(V-Z-O)-b]}else{x=[Y+Z+O+b,Y+Z+O,Y+Z+O,Y+(V-Z-O),Y+(V-Z-O),Y+(V-Z-O)-b,Y+Z+O+b]}ap=this.toRender({p:["drawShape","polygon",J,x,false,false,I,H,ac[aj]],a:this.getShapeArea("polygon",J,x,false,false,I,H,ac[aj]),i:au[aj],b:Y,t:"Data",h:Q});J=[W[4],ah,W[3],W[3],ah,W[4],W[4]];this.toRender({p:["drawShape","polygon",J,x,false,false,I,H,ac[aj]],a:this.getShapeArea("polygon",J,x,false,false,I,H,ac[aj]),i:au[aj],g:ap,b:Y,t:"Data",h:Q})}else{if(this.boxplotType=="range"){ap=this.toRender({p:["drawLine","line",W[0],an,W[1],an,this.useOpenShapes?H:I,ao,"round"],a:this.getLineArea("line",W[0],an,W[1],an,this.useOpenShapes?H:I,ao,"round"),i:au[aj],b:ag,t:"Data",h:Q})}else{ap=this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",M,an,al,at,I,H,ac[aj]],a:this.getShapeArea(this.useRoundRectangles?"roundrect":"rectangle",M,an,al,at,I,H,ac[aj]),i:au[aj],b:ag,t:"Data",h:Q})}}if(this.unique(A).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.toRender({p:["drawLine","median",W[4],Y+Z+O+b,W[4],Y+(V-Z-O)-b,this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],a:this.getLineArea("median",W[4],Y+Z+O+b,W[4],Y+(V-Z-O)-b,this.boxplotMedianColor,this.boxplotMedianWidth,"butt"),i:au[aj],g:ap,t:"Data",h:Q})}else{if(this.boxplotType=="range"){this.toRender({p:["drawShape","sphere",W[4],an,ao*2.5,ao*2.5,this.useOpenShapes?H:I,this.useOpenShapes?H:I],a:this.getShapeArea("sphere",W[4],an,ao*2.5,ao*2.5,this.useOpenShapes?H:I,this.useOpenShapes?H:I),i:au[aj],g:ap,t:"Data",h:Q})}else{this.toRender({p:["drawLine","median",W[4],Y+Z+O,W[4],Y+(V-Z-O),this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],a:this.getLineArea("median",W[4],Y+Z+O,W[4],Y+(V-Z-O),this.boxplotMedianColor,this.boxplotMedianWidth,"butt"),i:au[aj],g:ap,t:"Data",h:Q})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){this.toRender({p:["drawLine","line",W[2],aa,W[0],aa,H,false,"butt"],a:this.getLineArea("line",W[2],aa,W[0],aa,H,false,"butt"),i:au[aj],g:ap,t:"Data",h:Q});this.toRender({p:["drawLine","line",W[3],aa,W[1],aa,H,false,"butt"],a:this.getLineArea("line",W[3],aa,W[1],aa,H,false,"butt"),i:au[aj],g:ap,t:"Data",h:Q})}else{if(this.boxplotWhiskersType=="double"){this.toRender({p:["drawLine","error",W[2],aa,W[0],aa,H,N,"butt"],a:this.getLineArea("error",W[2],aa,W[0],aa,H,N,"butt"),i:au[aj],g:ap,t:"Data",h:Q});this.toRender({p:["drawLine","error",W[3],aa,W[1],aa,H,N,"butt"],a:this.getLineArea("error",W[3],aa,W[1],aa,H,N,"butt"),i:au[aj],g:ap,t:"Data",h:Q})}}}}if(this.boxplotMean){this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",T(aq[aj][6]),aa,G,G,this.boxplotMeanColor,this.boxplotMeanColorBorder],a:this.getShapeArea(this.useRoundRectangles?"roundrect":"rectangle",T(aq[aj][6]),aa,G,G,this.boxplotMeanColor,this.boxplotMeanColorBorder),i:au[aj],g:ap,b:ag,t:"Data",h:Q})}if(aq[aj][5]&&!this.showBoxplotOriginalData){for(var ai=0;ai<aq[aj][5].length;ai++){this.toRender({p:["drawShape","sphere",T(aq[aj][5][ai]),aa,ao,ao,I,H,ac[aj]],a:this.getShapeArea("sphere",T(aq[aj][5][ai]),aa,ao,ao,I,H,ac[aj]),i:au[aj],g:ap,b:ag,t:"Data",h:Q})}}}if(!F.hasOwnProperty(L)){F[L]=[];R[L]=this.cloneObject(au[aj])}F[L].push([W[4],Y+Z+(V/2)]);Y+=ab}}if(this.boxplotConnect){for(var L in F){if(F[L].length>1){var ap=this.toRender({p:["drawLine","line",F[L][0][0],F[L][0][1],F[L][1][0],F[L][1][1],L,this.boxplotConnectWidth,"butt"],a:this.getLineArea("line",F[L][0][0],F[L][0][1],F[L][1][0],F[L][1][1],L,this.boxplotConnectWidth,"butt"),i:["Line:",R[L][0],R[L][1]],t:"Data",h:Q});for(var aj=1;aj<F[L].length-1;aj++){this.toRender({p:["drawLine","line",F[L][aj][0],F[L][aj][1],F[L][aj+1][0],F[L][aj+1][1],L,this.boxplotConnectWidth,"butt"],a:this.getLineArea("line",F[L][aj][0],F[L][aj][1],F[L][aj+1][0],F[L][aj+1][1],L,this.boxplotConnectWidth,"butt"),i:["Line:",R[L][0],R[L][1]],g:ap,t:"Data",h:Q})}}}}};this.drawGanttPlot=function(R,E,T,H,L,C,P,B,K,F,S,U){var y=function(a){return L+((a-K)*B)};var x=null;for(var N=0;N<R.length;N++){var J=y(R[N][0]);var f=y(R[N][1]);var A=J+((f-J)/2);var e=C+(P/2);var W=f-J;var v=E[N]?W*E[N]:false;var w=this.getFillColor(S[N],U[N]);var g=this.addColorTransparency(w,this.ganttCompletionTransparency,true);var s=this.getOutlineColor(w,U[N]);var r=this.isHidden(false,U[N][0]);var D=this.toRender({p:["drawShape","roundrect",A,e,W,P,g,g,F[N]],a:this.getShapeArea("roundrect",A,e,W,P,g,g,F[N]),i:U[N],g:x,b:L,t:"Data",h:r});if(!x){x=D}if(E[N]){if(E[N]==1){this.toRender({p:["drawShape","roundrect",A,e,W,P,w,w,F[N]],a:this.getShapeArea("roundrect",A,e,W,P,w,w,F[N]),i:U[N],g:x,b:L,t:"Data",h:r})}else{this.toRender({p:["drawShape","roundrectl",A-((W-v)/2),e,v,P,w,w,F[N]],a:this.getShapeArea("roundrectl",A-((W-v)/2),e,v,P,w,w,F[N]),i:U[N],g:x,b:L,t:"Data",h:r})}}this.toRender({p:["drawShape","roundrect",A,e,W,P,false,s,"open"],a:this.getShapeArea("roundrect",A,e,W,P,false,s,"open"),i:U[N],g:x,b:L,t:"Data",h:r});if(H.length){for(var M=0;M<H.length;M++){var I=y(H[M][0]);this.toRender({p:["drawShape","triangle2",I,C,P/3,P/3,w,s],a:this.getShapeArea("triangle2",I,C,P/3,P/3,w,s),i:[].concat(U[N].concat(H[M][1])),g:x,b:L,t:"Data",h:r})}}if(T[N]){var G=y(T[N][0]);var X=y(T[N][1]);var V=T[N][2]+(P/2);var Q=e==V?X:G+((X-G)/2);var n=e==V?V:V+(P/2);var O=A-(W/2);var k=e;this.toRender({p:["drawLine",n==k?"line":"roundLine",Q,n,O,k,this.getOutlineColor(T[N][4]),T[N][5],"butt",0,0,false,false,false,false,T[N][3]],a:this.getLineArea(n==k?"line":"roundLine",Q,n,O,k,this.getOutlineColor(T[N][4]),T[N][5],"butt",0,0,false,false,false,false,T[N][3]),i:U[N],g:x,b:L,t:"Data",h:r})}}};this.drawViolin=function(k,E,r,I,n,D,B,J,A,w,e){var f=[];var G=[];var b=[];var C=[];var a=[[],[]];var F,d,j,g;switch(this.violinScale){case"area":F=I/k.density.maxY*k.density.maxY/k.scale*0.9;break;case"count":F=I/k.density.maxY*k.density.sumY/k.area*0.9;break;case"width":F=I/k.density.maxY*0.9;break}var s=this.addColorTransparency(this.violinColor||J,this.showBoxplotOriginalData&&!this.violinColor?0:this.violinTransparency,true);if(this.violinTrim){d=[];for(var H=k.density.trim[0];H<k.density.trim[1];H++){d.push(k.density.xy[H])}}else{d=k.density.xy}if(B=="vertical"){for(var H=0;H<d.length;H++){j=(d[H][1]*F);g=((d[H][0]-D)*n);f.push(E-j);G.push(r-g);b.push(E+j);C.push(r-g);a[0].push(E);a[1].push(r-g)}}else{for(var H=0;H<d.length;H++){j=((d[H][0]-D)*n);g=(d[H][1]*F);f.push(E+j);G.push(r-g);b.push(E+j);C.push(r+g);a[0].push(E+j);a[1].push(r)}}if(f.length>1&&G.length>1){this.toRender({p:["drawShape","violin",[f,b],[G,C],false,false,s,this.violinBorderColor,A],a:this.getShapeArea("violin",[f,b],[G,C],false,false,s,this.violinBorderColor,A),i:w,b:a,t:"Data",h:e})}};this.drawDotPlot=function(an,am,ab,T,ag,W,S,aa,U,Y,ap,ac,X,av,Q,V,P,I,H,ar){var O=this;var b=function(){var h=O.jitterColumns%2?O.jitterColumns+2:O.jitterColumns+3;var c=Math.max(ag-O.sizes[0],O.sizes[0])/(h-1);var a=[0];var d=1;for(var e=0;e<h/2;e+=2){a.push(d*-c);a.push(d*c);d++}return a};var G=function(l,c){var a=c[0];var j=0;var e="";var m={n:{},arr:{}};for(var h=0;h<l.length;h++){var d=l[h]!=null?l[h].toString():"";if(!m.n.hasOwnProperty(d)){m.n[d]=0;m.arr[d]=[]}m.n[d]++;if(m.n[d]>j){j=m.n[d];e=d}}if(m.n[e]*a>ag){a=ag*(O.binAlignment=="center"?1:0.5)/m.n[e]}for(var d in m.n){switch(O.binAlignment){case"bottom":case"right":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--}break;case"top":case"left":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break;case"center":if(m.n[d]%2){m.arr[d].push(0);m.n[d]--}else{m.arr[d].push(-a/2);m.n[d]--;m.arr[d].push(a/2);m.n[d]--}while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--;k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break}}return m.arr};var B=[];var E=this.dotplotType=="movement"?false:b();var af=ar?"Overlays":"Data";if(Y=="vertical"){for(var ae=0;ae<an.length;ae++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var aq=this.dotplotType=="movement"?false:this.binned?G(an[ae],U[ae]):false;for(var ad=0;ad<an[ae].length;ad++){if(this.isGraphTime&&an[ae][ad]==null){continue}var Z=this.dotplotType=="movement"?0:this.binned?aq[an[ae][ad].toString()].shift():this.jitter?E[ad%E.length]:0;var g=av?av[ae][ad]:false;var R=T-((an[ae][ad]-aa)*S);var K=this.getFillColor(ap[ae][ad],g);var L=this.getOutlineColor(K,g);if(this.graphType.match(/Bar/)&&this.barType=="lollipop"){g.push("Lollipop")}if(this.isNumber(R,true)){var ao;B.push([ab+Z,R,U[ae][ad]/2,g]);if(this.graphType.match(/Dot/)&&this.dotplotType=="movement"&&ad>0){var M=B.length-1;var D=B.length-2;while(!this.isNumber(B[D][1],true)&&D>=0){D--}if(this.isNumber(B[D][1],true)){var au=B[M];var al=B[D];var ak=this.addColorTransparency(K,0.2);this.toRender({p:["drawShape","polygon",[au[0]-au[2],al[0]-al[2],al[0]+al[2],au[0]+au[2]],[au[1],al[1],al[1],au[1]],false,false,ak,ak],t:"Decorations",h:this.isHidden(au[3][0],au[3][1])||this.isHidden(al[3][0],al[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){ao=this.toRender({p:["drawShape",X[ae][ad],ab+Z,R,U[ae][ad],U[ae][ad],this.background,K,ac[ae][ad],false,2,V],a:this.getShapeArea(X[ae][ad],ab+Z,R,U[ae][ad],U[ae][ad],this.background,K,ac[ae][ad],false,2,V),i:g,m:Q,b:T,t:af,h:this.isHidden(g[0],g[1])})}else{ao=this.toRender({p:["drawShape",X[ae][ad],ab+Z,R,U[ae][ad],U[ae][ad],K,L,ac[ae][ad],false,false,V],a:this.getShapeArea(X[ae][ad],ab+Z,R,U[ae][ad],U[ae][ad],K,L,ac[ae][ad],false,false,V),i:g,m:Q,b:T,t:af,h:this.isHidden(g[0],this.isGroupedData||(this.graphType=="Dotplot"&&g[2]!=null)?g[2]:g[1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(an[ae][ad]),ab+Z,R,this.smpLabelFont,this.barLollipopOpen?K:this.foreground,"center","middle"],g:ao,t:af,h:this.isHidden(g[0],g[1])})}if(!this.isGroupedData){if(am[ae]&&am[ae][ad]&&this.isNumber(am[ae][ad],true)){var at=(am[ae][ad]/2)*S;this.toRender({p:["drawLine","error",ab+Z,R,ab+Z,R+at,K,-ag,"butt",false,false,true],a:this.getLineArea("error",ab+Z,R,ab+Z,R+at,K,-ag,"butt",false,false,true),i:g,g:ao,t:af,h:this.isHidden(g[0],g[1])});this.toRender({p:["drawLine","error",ab+Z,R,ab+Z,R-at,K,-ag,"butt",false,false,true],a:this.getLineArea("error",ab+Z,R,ab+Z,R-at,K,-ag,"butt",false,false,true),i:g,g:ao,t:af,h:this.isHidden(g[0],g[1])})}}}else{B.push([ab+Z,Number.NaN,U[ae][ad]/2,g])}}if(this.showErrorBars&&this.isGroupedData&&am[ae]&&am[ae]&&this.isNumber(am[ae][0],true)&&this.isNumber(am[ae][1],true)){var R=T-((am[ae][0]-aa)*S);var at=(am[ae][1]/2)*S;var g=av?[av[ae][0][0],av[ae][0][1],"error"]:false;this.toRender({p:["drawShape","diamond",ab,R,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,V],h:this.isHidden(false,av[ae][0][0]),t:af});this.toRender({p:["drawLine","line",ab,R-at,ab,R+at,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,V],h:this.isHidden(false,av[ae][0][0]),t:af})}}ab+=W}}else{for(var ae=0;ae<an.length;ae++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var aq=this.dotplotType=="movement"?false:this.binned?G(an[ae],U[ae]):false;for(var ad=0;ad<an[ae].length;ad++){if(this.isGraphTime&&an[ae][ad]==null){continue}var Z=this.dotplotType=="movement"?0:this.binned?aq[an[ae][ad].toString()].shift():this.jitter?E[ad%E.length]:0;var g=av?av[ae][ad]:false;var R=P?ab+P-((an[ae][ad]-aa)*S):ab+((an[ae][ad]-aa)*S);var K=this.getFillColor(ap[ae][ad],g);var L=this.getOutlineColor(K,g);if(this.graphType.match(/Bar/)&&this.barType=="lollipop"){g.push("Lollipop")}if(this.isNumber(R,true)){var ao;B.push([R,T+Z,U[ae][ad]/2,g]);if(this.graphType.match(/Dot/)&&this.dotplotType=="movement"&&ad>0){var M=B.length-1;var D=B.length-2;while(!this.isNumber(B[D][0],true)&&D>=0){D--}if(this.isNumber(B[D][0],true)){var au=B[M];var al=B[D];var ak=this.addColorTransparency(K,0.2);this.toRender({p:["drawShape","polygon",[au[0],al[0],al[0],au[0]],[au[1]-au[2],al[1]-al[2],al[1]+al[2],au[1]+au[2]],false,false,ak,ak],t:"Decorations",h:this.isHidden(au[3][0],au[3][1])||this.isHidden(al[3][0],al[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){ao=this.toRender({p:["drawShape",X[ae][ad],R,T+Z,U[ae][ad],U[ae][ad],this.background,K,ac[ae][ad],false,2,V],a:this.getShapeArea(X[ae][ad],R,T+Z,U[ae][ad],U[ae][ad],this.background,K,ac[ae][ad],false,2,V),i:g,m:Q,b:ab,t:af,h:this.isHidden(g[0],g[1])})}else{ao=this.toRender({p:["drawShape",X[ae][ad],R,T+Z,U[ae][ad],U[ae][ad],K,L,ac[ae][ad],false,false,V],a:this.getShapeArea(X[ae][ad],R,T+Z,U[ae][ad],U[ae][ad],K,L,ac[ae][ad],false,false,V),i:g,m:Q,b:ab,t:af,h:this.isHidden(g[0],this.isGroupedData||(this.graphType=="Dotplot"&&g[2]!=null)?g[2]:g[1])})}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(an[ae][ad]),R,T+Z,this.smpLabelFont,this.barLollipopOpen?K:this.foreground,"center","middle"],g:ao,t:af,h:this.isHidden(g[0],g[1])})}if(!this.isGroupedData){if(am[ae]&&am[ae][ad]&&this.isNumber(am[ae][ad],true)){var at=(am[ae][ad]/2)*S;this.toRender({p:["drawLine","error",R,T+Z,R+at,T+Z,K,ag,"butt",false,false,true],a:this.getLineArea("error",R,T+Z,R+at,T+Z,K,ag,"butt",false,false,true),i:g,g:ao,t:af,h:this.isHidden(g[0],g[1])});this.toRender({p:["drawLine","error",R,T+Z,R-at,T+Z,K,ag,"butt",false,false,true],a:this.getLineArea("error",R,T+Z,R-at,T+Z,K,ag,"butt",false,false,true),i:g,g:ao,t:af,h:this.isHidden(g[0],g[1])})}}}else{B.push([Number.NaN,T+Z,U[ae][ad]/2,g])}}}if(this.showErrorBars&&this.isGroupedData&&am[ae]&&am[ae]&&this.isNumber(am[ae][0],true)&&this.isNumber(am[ae][1],true)){var R=ab+((am[ae][0]-aa)*S);var at=(am[ae][1]/2)*S;var g=av?[av[ae][0][0],av[ae][0][1],"error"]:false;this.toRender({p:["drawShape","diamond",R,T,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,V],h:this.isHidden(false,false,"Var-"+av[ae][0][0]),t:af});this.toRender({p:["drawLine","line",R-at,T,R+at,T,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,V],h:this.isHidden(false,false,"Var-"+av[ae][0][0]),t:af})}T+=W}}if(this.connectBy&&this.data.x&&this.data.x.hasOwnProperty(this.connectBy)&&this.isRawData){var x=this.meta.data.x[this.connectBy];var F=0;var ah=this.getKeys(this.connectByData);var f=this.getCustomColorScheme(ah.length);var J={};if(this.isGraphTime){for(var ae=0;ae<this.timeValueIndices.length;ae++){if(this.timeValueIndices[ae]>0){J[ae.toString()]=this.timeValueIndices[ae]}}}for(var ae in this.connectByData){var ao;var N=null;var an=this.connectByData[ae];var K=this.connectByNoColor?this.connectByColor:x&&x.type!="Numeric"?x.connects[x.order[ae]%x.connects.length]:f[F%f.length];if(an.length>1){for(var ad=1;ad<an.length;ad++){var R=this.isGraphTime?B[J[an[ad-1]]]:B[an[ad-1]];var at=this.isGraphTime?B[J[an[ad]]]:B[an[ad]];if(R&&at){ao=this.toRender({p:["drawLine","line",R[0],R[1],at[0],at[1],K,this.connectByWidth,"butt",R[2],at[2],V],a:this.getLineArea("line",R[0],R[1],at[0],at[1],K,this.connectByWidth,"butt",R[2],at[2],V),i:["Line:"+this.connectBy+" "+ae,R[3][0],R[3][2],at[3][2]],g:N,t:af,h:this.isHidden(false,R[3][2])});if(N==null){N=ao}}}}F++}}else{if(this.connectBy&&this.data.z&&this.data.z.hasOwnProperty(this.connectBy)&&this.isRawData){this.connectByDataVar.push(B);if(H){var x=this.connectBy==this.colorBy?this.meta.data.z[this.colorBy]:false;for(var ae in this.connectByData){var an=this.connectByData[ae];if(an.length>1){for(var ac=0;ac<this.connectByDataVar[0].length;ac++){for(var ad=1;ad<an.length;ad++){var R=this.connectByDataVar[an[ad-1]][ac];var at=this.connectByDataVar[an[ad]][ac];var aj=ae;if(R&&at){var C=this.data.y.vars[R[3][0]];var ai=this.data.y.vars[at[3][0]];var A=this.data.y.smps[R[3][(this.isGroupedData?2:1)]];var z=this.data.y.smps[at[3][(this.isGroupedData?2:1)]];if(A==z){aj=C+" - "+ai+" ("+A+")"}else{aj=C+" ("+A+") - "+ai+" ("+z+")"}}this.toRender({p:["drawLine","line",R[0],R[1],at[0],at[1],this.connectByColor,this.connectByWidth,"butt",R[2],at[2],V],a:this.getLineArea("line",R[0],R[1],at[0],at[1],this.connectByColor,this.connectByWidth,"butt",R[2],at[2],V),i:["Line:"+this.connectBy+" "+aj],t:af,h:this.isHidden(false,R[3][2])})}}}}}}}};this.drawHeatmap=function(H,C,s,j,E,G,K,F,z,J,y){var n=0;var g=C;var x=0.75;var B=this.meta.vals;if(!B.colors){B.colors={}}for(var D=0;D<H.length;D++){var k=H[D];var I=this.isContour?"rgba(0,0,0,0)":k==null||!this.isNumber(k,true)?this.missingDataColor:B.colors[k.toString()]?B.colors[k.toString()]:this.getColorForValue(J,k);var A=G&&y?this.addColorTransparency(I,y,true):G?I:this.heatmapCellBoxColor;B.colors[k==null?"null":k.toString()]=I;if(y){I=this.addColorTransparency(I,y,true)}if(this.graphType=="Network"){if(this.shapeByShape){this.toRender({p:["drawShape",this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z[D]],a:this.getShapeArea(this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z[D]),i:K[D],m:F,t:"Decorations",h:this.isHidden(K[D])})}else{this.toRender({p:["drawShape","rectangle",C+(j/2),s+(E/2),j,E,I,I,z[D]],a:this.getShapeArea("rectangle",C+(j/2),s+(E/2),j,E,I,I,z[D]),i:K[D],m:F,t:"Decorations",h:this.isHidden(K[D])})}}else{if(this.shapeByShape){this.toRender({p:["drawShape",this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z?z[D]:false],a:this.getShapeArea(this.shapeByShape,C+(j/2),s+(E/2),j/2,E/2,I,A,z?z[D]:false),i:K[D],m:F,t:"Data",h:this.isHidden(K[D][0],K[D][1])})}else{if(D>0&&D<H.length-1){if(n>=0.5){this.toRender({p:["drawShape","rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false],a:this.getShapeArea("rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false),i:K[D],m:F,b:[g,s+((E+x)/2),0,E+x],h:this.isHidden(K[D][0],K[D][1]),t:"Data"});n=0}}else{this.toRender({p:["drawShape","rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false],a:this.getShapeArea("rect",C+((j+x)/2),s+((E+x)/2),j+x,E+x,I,I,z?z[D]:false),i:K[D],m:F,b:[g,s+((E+x)/2),0,E+x],h:this.isHidden(K[D][0],K[D][1]),t:"Data"})}}}if(this.showDataValues){this.toRender({p:["drawText",this.formatNumber(k),(C+j)-2,(s+E)-2,this.smpLabelFont,this.foreground,"right","bottom"],t:"Data"})}C+=j;n+=j}};this.drawTreemap=function(B,u,p,C,D){var f=this;var r=this.graphOrientation=="vertical"?this.top+this.y:this.left;var k=function(d,c){if(c){f.toRender({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,false,f.getOutlineColor(d.color),"open",false,d.outline,C,D],b:r,t:"Data"})}else{f.toRender({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,f.getFillColor(d.color,d.index),f.getOutlineColor(d.color,d.index),"closed",false,false,C,D],a:f.getShapeArea("rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,f.getFillColor(d.color,d.index),f.getOutlineColor(d.color,d.index),"closed",false,false,C,D),i:d.index,b:r,t:"Data",h:f.isHidden(d.index[0],d.index[1])})}if(d.label){var b=f.measureText(d.label,f.overlayFont);if(b+f.margin<d.coords.width&&f.overlayFontSize+f.margin<d.coords.height){if(c){f.toRender({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5,true),"center","middle"],t:"Data"})}else{f.toRender({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"left","top"],t:"Data"})}}else{if(b+f.margin<d.coords.height&&f.overlayFontSize+f.margin<d.coords.width){if(c){f.toRender({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5,true),"center","middle",-Math.PI/2],t:"Data"})}else{f.toRender({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"right","top",-Math.PI/2],t:"Data"})}}}}};var s=function(c){for(var b=0;b<c.length;b++){if(c[b].children){s(c[b].children);k(c[b],true)}else{k(c[b])}}};for(var v=0;v<B.length;v++){var a=B[v];var q=this.treemapBorderWidth&&!this.isDOE?1:0;var E=this.isDOE?0:this.treemapBorderWidth;var o=E*2;var e=this.smpLabelFontSize*q;var g=this.treemapBorderColor;var m=u+a.coords.left-E;var j=p+a.coords.top-(e+E);var n=a.coords.width+o;var A=a.coords.height+e+o;if(a.title){this.toRender({p:["disableGradientTransparencyShadow"],t:"Data"});if(a.coords.border>1){this.toRender({p:["drawShape","rectangle",m+(n/2),j+((e+(E/2))/2),n,e+(E/2),g,g,"close",false,E,C,D],t:"Data"});this.toRender({p:["drawShape","rectangle",m+(n/2),j+(A/2),n,A,false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>0){this.toRender({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>-1){this.toRender({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}}}var z=this.measureText(a.title,this.smpLabelFont);if(z+this.margin<n&&this.smpLabelFontSize<=e&&a.coords.height>e+(E/2)){this.toRender({p:["drawText",a.title,m+this.margin,j+(this.smpLabelFontSize/2),this.smpLabelFont,this.foreground,"left","middle"],t:"Data"})}this.toRender({p:["enableGradientTransparencyShadow"],t:"Data"})}if(a.children){s(a.children)}else{k(a)}}};this.drawSankey=function(b){var f=b.links[0].target.x-b.links[0].source.x;for(var a=0;a<b.links.length;a++){var c=b.links[a];this.toRender({p:["drawShape","bezier",c.plotX,c.plotY,f,c.dy,this.getFillColor(c.color),this.getOutlineColor(c.color),false,c.colors],a:this.getShapeArea("bezier",c.plotX,c.plotY,f,c.dy,this.getFillColor(c.color),this.getOutlineColor(c.color),false,c.colors),i:c.tooltip,b:[this.left,this.top+this.y/2,f,c.dy],t:"Data"})}for(var a=0;a<b.nodes.length;a++){var e=b.nodes[a];this.toRender({p:["drawShape","rectangle",e.plotX+(e.dx/2),e.plotY+(e.dy/2),e.dx,e.dy,e.color,this.foreground],a:this.getShapeArea("rectangle",e.plotX+(e.dx/2),e.plotY+(e.dy/2),e.dx,e.dy,e.color,this.foreground),i:e.tooltip,b:[this.left,this.top+this.y/2,e.dx,e.dy],t:"Data"});this.toRender({p:["drawText",e.name,e.plotX+(e.dx/2),e.plotY+(e.dy/2),this.overlayFont,this.overlayFontColor,"center","middle",-Math.PI/2],a:this.getTextArea(e.name,e.plotX+(e.dx/2),e.plotY+(e.dy/2),this.overlayFont,this.overlayFontColor,"center","middle",-Math.PI/2),i:[e.tooltip[0]+":T"],t:"Data"})}};this.drawTree=function(a,f){if(this.data.tree&&this.data.tree.plot){var l=this.data.tree.plot;var k=this.treeNodeSize;var d=k/2;var h=k/4;var e=a=="vertical"?true:false;var g=this;var j=function(u){var m=e?u.x0:u.y0;var t=e?u.y0:u.x0;var q=g.isHidden(false,u.id);g.toRender({p:["drawShape",u.data.shape,m,t,u.data.size,u.data.size,g.getFillColor(u.data.color,u.id),g.treeNodeOutlineColor,u.data.pattern,false,g.treeLinkWidth],a:g.getShapeArea(u.data.shape,m,t,u.data.size,u.data.size,g.getFillColor(u.data.color,u.id),g.treeNodeOutlineColor,u.data.pattern,false,g.treeLinkWidth),i:["Tree-Node:"+u.id],b:[b,i],t:"Data",h:q});if(u.children){for(var p=0;p<u.children.length;p++){j(u.children[p])}if(g.treeCircular){var o=(Math.PI/2)-u.angle;var r=(((k/2)+g.margin)*Math.cos(o))*(g.treeInverted?-1:1);var s=(((k/2)+g.margin)*Math.sin(o))*(g.treeInverted?-1:1);if(u.angle<=Math.PI){g.toRender({p:["drawText",u.data.name,m-r,t-s,g.smpLabelFont,g.smpLabelFontColor,g.treeInverted?"left":"right","middle",o],a:g.getTextArea(u.data.name,m-r,t-s,g.smpLabelFont,g.smpLabelFontColor,g.treeInverted?"left":"right","middle",o),i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.toRender({p:["drawText",u.data.name,m-r,t-s,g.smpLabelFont,g.smpLabelFontColor,g.treeInverted?"right":"left","middle",o-Math.PI],a:g.getTextArea(u.data.name,m-r,t-s,g.smpLabelFont,g.smpLabelFontColor,g.treeInverted?"right":"left","middle",o-Math.PI),i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{if(e){if(u.parent){g.toRender({p:["drawText",u.data.name,m,t-((k/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"right","middle",Math.PI/2],a:g.getTextArea(u.data.name,m,t-((k/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"right","middle",Math.PI/2),i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.toRender({p:["drawText",u.data.name,m,t-((k/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"center","bottom"],a:g.getTextArea(u.data.name,m,t-((k/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"center","bottom"),i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{g.toRender({p:["drawText",u.data.name,m-((k/2)+g.margin),t,g.smpLabelFont,g.smpLabelFontColor,"right","middle"],a:g.getTextArea(u.data.name,m-((k/2)+g.margin),t,g.smpLabelFont,g.smpLabelFontColor,"right","middle"),i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}}else{if(g.treeCircular){var o=(Math.PI/2)-u.angle;var r=(((k/2)+g.margin)*Math.cos(o))*(g.treeInverted?-1:1);var s=(((k/2)+g.margin)*Math.sin(o))*(g.treeInverted?-1:1);if(u.angle<=Math.PI){g.toRender({p:["drawText",u.data.name,m+r,t+s,g.smpLabelFont,g.smpLabelFontColor,g.treeInverted?"right":"left","middle",o],a:g.getTextArea(u.data.name,m+r,t+s,g.smpLabelFont,g.smpLabelFontColor,g.treeInverted?"right":"left","middle",o),i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.toRender({p:["drawText",u.data.name,m+r,t+s,g.smpLabelFont,g.smpLabelFontColor,g.treeInverted?"left":"right","middle",o-Math.PI],a:g.getTextArea(u.data.name,m+r,t+s,g.smpLabelFont,g.smpLabelFontColor,g.treeInverted?"left":"right","middle",o-Math.PI),i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{if(e){g.toRender({p:["drawText",u.data.name,m,t+(k/2)+g.margin,g.smpLabelFont,g.smpLabelFontColor,"left","middle",Math.PI/2],a:g.getTextArea(u.data.name,m,t+(k/2)+g.margin,g.smpLabelFont,g.smpLabelFontColor,"left","middle",Math.PI/2),i:["Tree-Text-:"+u.id],b:[b,i],t:"Data",h:q})}else{g.toRender({p:["drawText",u.data.name,m+(k/2)+g.margin,t,g.smpLabelFont,g.smpLabelFontColor,"left","middle"],a:g.getTextArea(u.data.name,m+(k/2)+g.margin,t,g.smpLabelFont,g.smpLabelFontColor,"left","middle"),i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}}if(u._children){g.toRender({p:["drawLine","line",m-h,t,m+h,t,g.foreground],a:g.getLineArea("line",m-h,t,m+h,t,g.foreground),i:["Tree-Line1:"+u.id],b:[b,i],t:"Data",h:q});g.toRender({p:["drawLine","line",m,t-h,m,t+h,g.foreground],a:g.getLineArea("line",m,t-h,m,t+h,g.foreground),i:["Tree-Line2:"+u.id],b:[b,i],t:"Data",h:q})}else{if(u.children){g.toRender({p:["drawLine","line",m-h,t,m+h,t,g.foreground],a:g.getLineArea("line",m-h,t,m+h,t,g.foreground),i:["Tree-Line1:"+u.id],b:[b,i],t:"Data",h:q})}}};var c=function(u){if(u.children){for(var o=0;o<u.children.length;o++){c(u.children[o])}}if(u.parent){var m=e?u.x0:u.y0;var t=e?u.y0:u.x0;var q=e?u.parent.x0:u.parent.y0;var s=e?u.parent.y0:u.parent.x0;var r=u._clicked?[q,s,q,s]:[b,i,b,i];var p=g.isHidden(false,u.id);g.toRender({p:["drawLine","bezier",q,s,m,t,g.treeLinkColor,g.treeLinkWidth,false,false,false,false,false,false,false,false,false,g.treeCircular?[u.mx,u.my,u.mx2,u.my2]:false],a:g.getLineArea("bezier",q,s,m,t,g.treeLinkColor,g.treeLinkWidth,false,false,false,false,false,false,false,false,false,g.treeCircular?[u.mx,u.my,u.mx2,u.my2]:false),i:[u.parent.id+":"+u.id],b:r,t:"Data",h:p});u._clicked=false}};var b=e?l.x0:l.y0;var i=e?l.y0:l.x0;c(l);if(!f){j(l)}}};this.zoomOncoprintVariables=function(c){if(this.isTransition()){return}var b=[];this.setOriginalIndices(false,this.varIndices,this.smpIndices);this.varIndicesStart=0;for(var a=0;a<Math.min(c,this.varIndices.length);a++){b.push(this.varIndices[a])}this.varIndices=b;this.draw({func:"zoomOncoprintVariables",par:[c]})}};CanvasXpress.prototype.init3dUtils=function(){this.setTrigonometry=function(){if(!this.meta.math){this.meta.math={sin:[0],cos:[1]};for(var b=1;b<=360;b++){var a=Math.PI/(180/b);this.meta.math.sin[b]=Math.sin(a);this.meta.math.cos[b]=Math.cos(a)}}};this.set3DRotation=function(){this.setTrigonometry();var a=["xRotate","yRotate","zRotate"];for(var b=0;b<a.length;b++){if(this[a[b]]>360){this[a[b]]-=360}if(this[a[b]]<0){this[a[b]]=360}}};this.set3DParams=function(){var b=this.zoom;var a=this.x;this.perspective=a*this.perspectiveFactor;this.lenX=a/4*b*this.x3DRatio;this.lenY=a/4*b*this.y3DRatio;this.lenZ=a/4*b*this.z3DRatio;this.padX=a/2;this.padY=this.y/2;this.padZ=this.padY};this.get3DTransfrom=function(g,a,k){var f,e,b;var h=[];var n=this.meta.math.sin;var j=this.meta.math.cos;var d=this.perspective;var m=this.xRotate;var l=this.yRotate;var i=this.zRotate;e=a;b=k;a=e*j[parseInt(l)]-b*n[parseInt(l)];k=e*n[parseInt(l)]+b*j[parseInt(l)];f=g;b=k;g=b*n[parseInt(m)]+f*j[parseInt(m)];k=b*j[parseInt(m)]-f*n[parseInt(m)];f=g;e=a;g=f*j[parseInt(i)]-e*n[parseInt(i)];a=f*n[parseInt(i)]+e*j[parseInt(i)];if(this.perspective){g=g*(d/(k+d));a=a*(d/(k+d));k=k*(d/(k+d))}h.push(g+this.padX);h.push(a+this.padY);h.push(k+this.padZ);return h}};CanvasXpress.prototype.initApiUtils=function(){this.getValidGraphTypes=function(){return this.validGraphTypes};this.setHeatmapScheme=function(){this.initializeAttributes()};this.hasIndicator=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.hasLegend=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.hasLegendProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.hasData=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.hasDataSamples=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.hasDataGroups=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.hasDataVariables=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.hasDataProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.hasOrientation=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasOverlays=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasDendrograms=function(){if(this.graphType!="Heatmap"&&(this.smpDendrogramNewick||this.varDendrogramNewick)){return true}else{return false}};this.hasDecorations=function(){return this.decorations&&(this.decorations.nlfit||this.decorations.line||this.decorations.reg||this.decorations.nor||this.decorations.area)?true:false};this.isSegregable=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.getLineTypes=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.capitalize(a[b])+"Line")}}return e};this.isValidShape=function(c){var a=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","pentagon","hexagon","octagon"];a=a.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","roundpolygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);a=a.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);a=a.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var b=0;b<a.length;b++){if(a[b]==c){return true}}return false};this.getHeatmapSchemes=function(){var c=[];var d=["blue","red","green","yellow","cyan","purple","white","black"];for(var b=0;b<d.length;b++){c.push(d[b]);for(var a=0;a<d.length;a++){if(d[b]!=d[a]){c.push(d[b]+"-"+d[a])}}}return c};this.isCompatibleGraphType=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.isOneDimensionalGraph=function(){return !this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)};this.isOneDimensionalCombinationGraph=function(){return this.graphType.match(/BarLine|StackedLine|StackedPercentLine|AreaLine|DotLine/)};this.isHistogramLayout=function(){return this.isHistogram&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0};this.modifyHighlights=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.modifyObjectArray(c,b,a)};this.getHighlights=function(a){return this.getObjectArray(a?this.highlightVar:this.highlightSmp)};this.modifyOverlaysProperties=function(g){if(this.isTransition()){return}var e=[];if(!this.isArray(g)){for(var d=0;d<arguments.length;d++){e.push(this.cloneObject(arguments[d]))}g=this.cloneObject(e)}else{e=this.cloneObject(g)}var b;var c=this;var a=e.shift();var f=this.cloneObject(e);while(f.length>1){b=f.shift();if(!c[b]){c[b]={}}c=c[b]}b=f.shift();c[b]=b=="showLegend"?!c[b]:isNaN(a)?a:Number(a);this.draw({func:"modifyOverlaysProperties",par:[g]})};this.modifySmpOverlays=function(b,a){this.modifyObjectArray(b,a,"smpOverlays")};this.modifyVarOverlays=function(b,a){this.modifyObjectArray(b,a,"varOverlays")};this.getSmpOverlays=function(){return this.getObjectArray(this.smpOverlays)};this.getVarOverlays=function(){return this.getObjectArray(this.varOverlays)};this.getXData=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.getZData=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.getXZData=function(){return this.graphType.match(/Scatter/)?this.getZData():this.getXData()};this.getSamplesVariablesAsArray=function(){return this.graphType.match(/scatter/i)?this.getSamplesAsArray():this.getVariablesAsArray};this.getSamplesAsArray=function(){var d=this.getSamples();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getVariablesAsArray=function(){var d=this.getVariables();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getNodeData=function(a){return this.getNetworkData("nodes",a)};this.getEdgeData=function(a){return this.getNetworkData("edges",a)};this.isBooleanData=function(c){for(var a in c){if(c[a]["t"]=="numeric"){var b=this.getKeys(c[a]["o"]);if(b.length==2&&(c[a]["o"].hasOwnProperty("true")&&c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&(c[a]["o"].hasOwnProperty("true")||c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&c[a]["o"].hasOwnProperty("")){c[a]["t"]="string"}}}}}};this.getSampleVariableData=function(l,r,q,k,s){var h={smps:{idx:"smpIndices",spc:"x"},vars:{idx:"varIndices",spc:"z"}};var c={};c[l]={o:{},t:"string"};if(r){c[l]["o"]=this.getObjectArray(this.data.y[l])}else{for(var f=0;f<this[h[l]["idx"]].length;f++){c[l]["o"][this.data.y[l][this[h[l]["idx"]][f]]]=true}}if(k||s){var n=k?this.getVariableIndices(q):this.getSampleIndices(q,true);if(this.isArray(q)){for(var b=0;b<q.length;b++){var n=k?this.getVariableIndices(q[b]):this.getSampleIndices(q[b],true);if(n>-1){c[q[b]]={o:{},t:"numeric"};if(r){var e=this.meta.data.y.range[q[b]];c[q[b]]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.range(g);c[q[b]]["o"]={min:a[0],max:a[1]}}}}}else{var n=k?this.getVariableIndices(q):this.getSampleIndices(q,true);if(n>-1){c={};c[q]={o:{},t:"numeric"};if(r){var e=this.meta.data.y.range[q];c[q]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.range(g);c[q]["o"]={min:a[0],max:a[1]}}}}}if(this.data[h[l]["spc"]]){for(var j in this.data[h[l]["spc"]]){if(q&&j!=q){continue}var e=this.meta.data[h[l]["spc"]][j];c[j]={o:{},t:e.type.toLowerCase()};if(r){if(e.type=="Numeric"){c[j]["t"]="numeric";c[j]["o"]={min:e.rmin,max:e.rmax}}else{c[j]["t"]="string";c[j]["o"]=this.cloneObject(e.levels)}}else{for(var f=0;f<this[h[l]["idx"]].length;f++){var d=this.getMetadataValue(this[h[l]["idx"]][f],h[l]["spc"],j,true);if(!c[j]["o"].hasOwnProperty(d)){c[j]["o"][d]=true}}if(c[j]["t"]=="numeric"){var g=[];for(var d in c[j]["o"]){for(var f=0;f<c[j]["o"][d];f++){g.push(d)}}var a=this.range(g);c[j]["o"]={min:a[0],max:a[1]}}}}}return c};this.getNetworkData=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.meta.data[d];for(var b in f){if(f[b].type=="String"){this[d+"Data"][b]={o:f[b].order,t:f[b].type.toLowerCase()}}else{this[d+"Data"][b]={o:{min:f[b].rmin,max:f[b].rmax},t:f[b].type.toLowerCase()}}}if(this[d+"Properties"].length>0){for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];this.getAdditionalData(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.getKeys(this[d+"Data"])}else{return false}};this.getFilteredNetworkData=function(g,j){var b={};b[g]={};if(this.graphType=="Network"){for(var e=0;e<this.data[g].length;e++){var d=this.data[g][e];if(j||(!j&&!d.hide)){for(var h in d){if(typeof(d[h])!="object"){if(b[g].hasOwnProperty(h)){b[g][h]["o"][d[h]]=true;if(isNaN(d[h])){b[g][h]["t"]="string"}}else{b[g][h]={o:{},t:isNaN(d[h])?"string":"numeric"};b[g][h]["o"][d[h]]=true}}}}if(this[g+"Properties"].length>0){this.getAdditionalData(d,b,this[g+"Properties"])}}this.isBooleanData(b[g]);for(var h in b[g]){if(b[g][h]["t"]=="numeric"){var f=[];for(var c in b[g][h]["o"]){f.push(c)}var a=this.range(f);b[g][h]["o"]={min:a[0],max:a[1]}}}}return b[g]};this.getFeatureData=function(a){if(!this.featuresData){var h={};var d=this.skipConfigurableProperties?this.getObjectArray(this.featureConfigurableProperties):{};for(var g=0;g<this.data.tracks.length;g++){var c=this.data.tracks[g];var b=c.data;for(var e=0;e<b.length;e++){var l=b[e];for(var k in l){if(!d[k]){if(typeof(l[k])!="object"){if(h.hasOwnProperty(k)){if(h[k]["o"].hasOwnProperty(l[k])){h[k]["o"][l[k]]=true}if(isNaN(l[k])){h[k]["t"]="string"}}else{h[k]={o:{},t:isNaN(l[k])?"string":"numeric"};h[k]["o"][l[k]]=true}}}}}if(this.featuresProperties.length>0){this.getAdditionalData(b,h,this.featuresProperties)}}this.featuresData=h}return a?this.featuresData:this.getKeys(this.featuresData)};this.getAdditionalData=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=true}}}}}}};this.getOperators=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.zoonIn=function(a){this.handleWheelEvent(a,1)};this.zoonOut=function(a){this.handleWheelEvent(a,-1)};this.clusterSamples=function(b,a){if(this.isTransition()){return}this.clusterAxis="samples";if(b||!this.smpDendrogramNewick){this.smpDendrogramNewick=this.cluster()}if(!a){this.draw({func:"clusterSamples",par:[b,a]})}};this.clusterVariables=function(b,a){if(this.isTransition()){return}this.clusterAxis="variables";if(b||!this.varDendrogramNewick){this.varDendrogramNewick=this.cluster()}if(!a){this.draw({func:"clusterVariables",par:[b,a]})}};this.kmeansSamples=function(e,d){if(this.isTransition()){return}this.clusterAxis="samples";if(!this.data.x){this.data.x={}}if(e||!this.data.x["k-Means-S"]){var a=this.kmeans();this.data.x["k-Means-S"]=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];this.data.x["k-Means-S"][c]=a[b]}if(!this.smpOverlays.includes("k-Means-S")){this.smpOverlays.push("k-Means-S")}this.updateMetaData("x","k-Means-S",false,true);this.modifySort("cat","smp","k-Means-S",true)}if(!d){this.draw({func:"kmeansSamples",par:[e,d]})}};this.kmeansVariables=function(e,d){if(this.isTransition()){return}this.clusterAxis="variables";if(!this.data.z){this.data.z={}}if(e||!this.data.z["k-Means-V"]){var a=this.kmeans();this.data.z["k-Means-V"]=[];for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];this.data.z["k-Means-V"][c]=a[b]}if(!this.varOverlays.includes("k-Means-V")){this.varOverlays.push("k-Means-V")}this.updateMetaData("z","k-Means-V",false,true);this.modifySort("cat","var","k-Means-V",true)}if(!d){this.draw({func:"kmeansVariables",par:[e,d]})}};this.setFunctions=function(){var a=this.functions;a.push("clusterSamples");a.push("clusterVariables");a.push("transpose");a.push("transform");a.push("hideUnhideSmps");a.push("hideUnhideVars");a.push("desegregateSamples");a.push("segregateSamples");a.push("groupSamples");a.push("ungroupSamples");a.push("desegregateVariables");a.push("segregateVariables");a.push("kmeansSamples");a.push("kmeansVariables");a.push("createContour");a.push("removeContour");a.push("showCodeDiv");a.push("hideCodeDiv");a.push("showInfoDiv");a.push("hideInfoDiv");a.push("updateCodeDiv");a.push("createHistogram");a.push("removeHistogram");a.push("addRegressionLine");a.push("addNormalDistributionLine");a.push("recalculateLayout");a.push("createRandomData");a.push("drawArea");a.push("draw");a.push("reset");a.push("print")};this.initializeApi=function(){this.setFunctions()}};CanvasXpress.prototype.initDimensionUtils=function(){this.resizeCanvas=function(a,o,e){var c=this.margin;var j=this.meta.canvas.canvasPixelRatio;if(a||o||e){if(o||e){if(o){this.width=o;this.originalWidth=o}if(e){this.height=e;this.originalHeight=e}}else{if(a){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=c+this.getTitleSubtitleHeight();this.left=c;this.right=c;this.bottom=c;this.resetRender()}if(!this.isSVG){this.meta.canvas.ctx.canvas.width=this.width*j;this.meta.canvas.ctx.canvas.height=this.height*j;this.meta.canvas.ctx.canvas.style.width=this.width+"px";this.meta.canvas.ctx.canvas.style.height=this.height+"px";this.meta.canvas.ctx2.canvas.width=this.width*j;this.meta.canvas.ctx2.canvas.height=this.height*j;this.meta.canvas.ctx2.canvas.style.width=this.width+"px";this.meta.canvas.ctx2.canvas.style.height=this.height+"px";this.meta.canvas.ctx.scale(j,j);this.meta.canvas.ctx2.scale(j,j)}this.toRender({p:["disableGradientTransparencyShadow"],t:"Size"});if(this.backgroundType=="image"){if(this.graphType=="Network"){var n=this.scaleFactorX||1;var l=this.scaleFactorY||1;var b=this.offsetX*n;var q=this.offsetY*l;var k=this.maxX?this.maxX*n:this.maxX;var d=this.maxY?this.maxY*l:this.maxY;var p=this.colorNodeBy||(this.decorations.length&&this.showDecorations)?"b&w":false;CanvasXpress.system.isRStudio=this.isInIframe()&&this.isR?true:false;if(CanvasXpress.system.isRStudio){this.toRender({p:["drawShape","image",(k/2)+b,(d/2)+q,k,d,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{this.drawImage(CanvasXpress.cacheImages[this.getFileName(this.backgroundImage)],0,0,this.maxX,this.maxY,b,q,k,d,p)}}else{this.toRender({p:["drawShape","image",this.width/2,this.height/2,this.width,this.height,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="windowImage"){if(this.graphType=="Network"){this.toRender({p:["drawShape","image",this.left+(this.x/2),this.top+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"){this.toRender({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,this.background,this.background],t:"Size"})}else{var i=this.getLinearGradient(0,0,this.gradientOrientation=="vertical"?0:this.height,this.gradientOrientation=="vertical"?this.height:0);this.toRender({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,i,i],t:"Size"})}}}this.toRender({p:["enableGradientTransparencyShadow"],t:"Size"})};this.setWidth=function(a,b){this.setDimensions(a,false,b)};this.setHeight=function(b,a){this.setDimensions(false,b,a)};this.getWidth=function(){return this.marginLeft+this.left+this.x+this.right+this.marginRight};this.getHeight=function(){return this.marginTop+this.top+this.y+this.bottom+this.marginBottom};this.setDimensions=function(j,b,l,k,i,a){if(this.isTransition()){return}if(!this.resizable){return}if(j&&b){if(Math.abs(this.width-j)<5&&Math.abs(this.height-b)<5){return}}if(!j||!this.resizableX){j=this.width}if(!b||!this.resizableY){b=this.height}var g=this.meta.canvas.ctx.canvas;j=g.originalWidth=parseInt(j);b=g.originalHeight=parseInt(b);this.clickLayoutNoAnimation(l);if(!this.reproducing){this.removeMotionDiv(true)}if(this.graphType=="Network"){this.scaleFactorX=null;this.scaleFactorY=null}this.draw({width:j,height:b,func:"setDimensions",par:[j,b,l,k,i,a]});this.updateRemoteNavigationWindow();if(k){var d=this;setTimeout(function(){d.resizeViewport()},k)}else{this.resizeViewport()}if(i){try{i()}catch(f){}}};this.initializeDimensions=function(){var a=this.margin;var b=this.meta.canvas.ctx.canvas;if(b.width){this.originalWidth=b.width;this.width=b.width}else{if(this.width){this.originalWidth=this.width;b.width=this.width}else{this.width=600;this.originalWidth=this.width;b.width=this.width}}if(b.height){this.originalHeight=b.height;this.height=b.height}else{if(this.height){this.originalHeight=this.height;b.height=this.height}else{this.height=600;this.originalHeight=this.height;b.height=this.height}}this.top=a+this.getTitleSubtitleHeight();this.left=a;this.right=a;this.bottom=a;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)}};CanvasXpress.prototype.initUtils=function(){this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApiUtils();this.initDimensionUtils()};CanvasXpress.prototype.initLegendUtils=function(){this.validateLegendPositions=function(){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){if(this.graphType=="Circular"){if(this.legendPosition!="top"){this.legendPosition="right"}}else{if(this.graphType!="Pie"){this.legendPosition="right"}}}}if(this.graphType=="Pie"&&this.layoutValid){this.legendPosition="right"}if(!this.overlaysLegendPosition){this.overlaysLegendPosition="topRight"}if(this.layoutValid&&!this.getLayoutConfig("legendPosition")){var a=this.meta.config.orig;a.insideLegend=this.insideLegend;this.insideLegend=false;if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){a.legendPosition=this.legendPosition;this.legendPosition="right"}}};this.setLegendFont=function(){if(this.autoScaleFont){var e=(1-this.percentAspectRatioPlotArea);var b=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var c=this.layoutComb&&this.isDOE?this.layoutHeight:this.height;var a=this.min(b*e,c*e);this.setPropertyFontSize(a/(this.graphType=="Circular"?1.66:1),"legendFont")}else{this.legendFont=this.legendFontStyle+" "+parseInt(this.legendFontSize)+"px "+this.fontName}};this.drawLegendBackgroundBox=function(e,s,p,g,m,o,j,f){var n=j?this.decorationsBackgroundColor:this.legendBackgroundColor;var c=f?this.legendBackgroundColor:j?this.decorationsBoxColor:this.legendBoxColor;var q=j?this.decorationsBox:this.legendBox;var k=this.graphType;var u=[0,0,this.width,this.height];var r=this.useRoundRectangles?"roundrect":"rectangle";if(m){if(q&&n&&!f&&k!="Network"){this.toRender({p:["disableGradientTransparencyShadow"],t:"Legends"});this.toRender({p:["drawShape",r,e+(p/2),s+(g/2),p,g,n,n,"solid",false,false,true,u],a:this.getShapeArea(r,e+(p/2),s+(g/2),p,g,n,n,"solid",false,false,true,u),i:[-1],m:o,t:"Legends"});this.toRender({p:["enableGradientTransparencyShadow"],t:"Legends"})}else{if(n){this.toRender({p:["drawShape",r,e+(p/2),s+(g/2),p,g,n,n,"solid",false,false,true,u],a:this.getShapeArea(r,e+(p/2),s+(g/2),p,g,n,n,"solid",false,false,true,u),i:[-1],m:o,t:"Legends"})}else{this.toRender({p:["drawShape",r,e+(p/2),s+(g/2),p,g,false,"rgba(0,0,0,0)","open",false,false,true,u],a:this.getShapeArea(r,e+(p/2),s+(g/2),p,g,false,"rgba(0,0,0,0)","open",false,false,true,u),i:[-1],m:o,t:"Legends"})}}}else{if(q){this.toRender({p:["disableGradientTransparencyShadow"],t:"Legends"});this.toRender({p:["drawShape",r,e+(p/2),s+(g/2),p,g,false,c,"open",false,false,true,u],t:"Legends"});this.toRender({p:["enableGradientTransparencyShadow"],t:"Legends"})}}};this.getDiameterLegend=function(){var a=Math.min(this.width,this.height);return Number(Math.max(0.5,a*12/833).toFixed(1))*this.legendScaleFontFactor};this.setCustomLegendDimensions=function(j){var e=j.text.length;var u=this.getDiameterLegend();var z=j.size;if(z){for(var k=0;k<z.length;k++){if(z[k]){u=Math.max(u,z[k])}}}var y=this.measureText(j.title&&this.showLegendTitle?j.title:"",this.legendFont);var g=this.measureText(this.getMaxText(j.text),this.legendFont);var p=this.getFontPt(this.legendFont);var v=this.legendColumns>e?e:this.legendColumns;var a=Math.ceil(e/v);var b=Math.max(y,(g+u+(this.margin*2))*v);var x=b+(this.margin*(v+2));var o=j.title&&this.showLegendTitle?(a*(Math.max(u,p)+this.margin))+p+(this.margin*2):(a*(Math.max(u,p)+this.margin))+(this.margin*1);this["legend"+j.id+"Width"]=x;this["legend"+j.id+"Height"]=o+this.margin};this.setPropertyLegendDimensions=function(c,n,b){var a=this.decapitalize(c)+"By";if((this[a]&&(this[a+"ShowLegend"]||this.graphType=="Network"))||c=="Sample"){var r,g,o;if(n){r=this[a];if(b.type=="Numeric"&&((c.match(/shape/i)&&!this.shapeByContinuous)||(c.match(/size/i)&&!this.sizeByContinuous))){g=" "+n+" - "+n+" ";if(b){b.maxLevStrMod=g;b.isRange=true}}else{g=n}o=b&&b.sizes?b.sizes:this.sizes}else{if(this.data.x&&this.data.x.hasOwnProperty(this[a])){r=this[a];g=this.meta.data.x[this[a]].maxLevStrMod||this.meta.data.x[this[a]].maxLevStr;o=this.meta.data.x[this[a]].sizes||this.sizes}else{if(this.data.z&&this.data.z.hasOwnProperty(this[a])){r=this[a];g=this.meta.data.z[this[a]].maxLevStrMod||this.meta.data.z[this[a]].maxLevStr;o=this.meta.data.z[this[a]].sizes||this.sizes}else{if(a.match("Node")){r=this[a];g=this.meta.data.nodes[this[a]].maxLevStr;o=this.meta.data.nodes[this[a]].sizes||this.sizes}else{if(a.match("Edge")){r=this[a];g=this.meta.data.edges[this[a]].maxLevStr;o=this.meta.data.edges[this[a]].sizes||this.sizes}else{r=0;g=0;o=this.sizes}}}}}var k=this.getDiameterLegend();if(c=="Size"||c=="SizeNode"||c=="SizeEdge"){for(var h=0;h<this["legend"+c+"sN"];h++){if(o[h]){k=Math.max(k,o[h])}}}else{if(c=="Sample"){r=0;g=this.legendSampleMaxStr}}if(g.length>this.maxTextSize){g=g.substring(0,this.maxTextSize-3)+"..."}var j=this.getFontPt(this.legendFont);var t=this.legendColumns>this["legend"+(c=="Outline"?"Color":c)+"sN"]?this["legend"+(c=="Outline"?"Color":c)+"sN"]:this.legendColumns;var e=Math.ceil(this["legend"+(c=="Outline"?"Color":c)+"sN"]/t);var q=this.showLegendTitle?this.measureText(r,this.legendFont):0;var s=(this.measureText(g,this.legendFont)+k+(this.margin*2))*t;this["legend"+(c=="Outline"?"Color":c)+"Width"]=Math.max(q,s)+(this.margin*(t+2));this["legend"+(c=="Outline"?"Color":c)+"Height"]=(e*(Math.max(k,j)+this.margin))+(c=="Sample"?0:(this.showLegendTitle?j+(this.margin*5):(this.margin*3)));if(this["legend"+(c=="Outline"?"Color":c)+"Height"]>this.height){this.legendColumns++;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.setPropertyLegendDimensions(c,n,b)}}};this.setPropertyLegendIndicatorDimensions=function(e,b){var j=this.decapitalize(e)+"By";var d=0;var g=0;var i=this.getFontPt(this.legendFont);if(this[j]||e=="Decoration"||e=="Contour"){switch(e){case"Color":case"ColorNode":case"ColorEdge":case"Outline":case"Decoration":case"Contour":var a=this.showLegendTitle?this.measureText(this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||"",this.legendFont):0;var c=b.maxLevLen;if(this.legendPosition.match(/top|bottom/)){g=this.heatmapIndicatorHeight+(this.margin*4)+(i*2);if(this.showLegendTitle){g+=i+this.margin}d=this.heatmapIndicatorWidth+Math.max(a,c)}else{g=this.heatmapIndicatorWidth+(this.margin*3)+(this.showLegendTitle?(i*2):0);d=this.heatmapIndicatorHeight+(this.margin*4)+Math.max(a,c)}break;case"Shape":case"ShapeNode":case"ShapeEdge":case"Size":case"SizeNode":case"SizeEdge":this.setPropertyLegendDimensions(e,b.maxLevStr,b);return;case"Pattern":case"PatternNode":case"PatternEdge":d=0;g=0;break}}this["legend"+(e=="Outline"?"Color":e)+"Width"]=d;this["legend"+(e=="Outline"?"Color":e)+"Height"]=g};this.setDecorationsLegendDimensions=function(){this.legendDecorationWidth=0;this.legendDecorationHeight=0;this.legendDecorationMaxLabel=0;if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}}var o=this.getFontPt(this.decorationFont);var h=this.decorations;var n=0;var m=["nlfit","reg","nor","area","qq","cdf","kaplanMeier"];var g=[96,45,30,0,0,0,0];var k=[5,2,1,0,0,0,0];for(var f=0;f<m.length;f++){if(h[m[f]]){var b=k[f]?this.measureText(this.sprintf("%"+g[f]+"s","X"),this.decorationFont)+(this.margin*k[f])+this.margin:0;var l=0;for(var c=0;c<h[m[f]].length;c++){var e=this.measureText(h[m[f]][c].label,this.decorationFont);l=Math.max(e,l);this.legendDecorationMaxLabel=Math.max(l,this.legendDecorationMaxLabel)}n=Math.max(n,this.margin+l+this.margin+b);this.legendDecorationHeight=(h[m[f]].length*o*2)+o+this.margin}}if(this.graphType=="Map"&&h.pie&&h.pie[0]&&h.pie[0].smps&&h.pie[0].smps.length){var l=0;var a=this.getFontPt(this.decorationFont);for(var f=0;f<h.pie[0].smps.length;f++){var e=this.measureText(h.pie[0].smps[f],this.decorationFont);l=Math.max(e,l);this.legendDecorationMaxLabel=Math.max(l,this.legendDecorationMaxLabel)}n=Math.max(n,(l+(this.margin*3)+(a*2))*Math.min(h.pie[0].smps.length,this.legendColumns));this.legendDecorationHeight+=(Math.ceil(h.pie[0].smps.length/Math.min(h.pie[0].smps.length,this.legendColumns))*a*1.5)+(this.margin*2)}this.legendDecorationWidth=n}};this.setOncoprintLegendDimension=function(){this.legendOncoprintWidth=0;this.legendOncoprintHeight=0;this.legendOncoprintColors={};if(this.isOncoprint){var g=this.cloneObject(this.meta.data[this.oncoprintCNA].levels);var h=this.cloneObject(this.meta.data[this.oncoprintCNA].colors);var b=[];g.push("No Alteration");h.push("rgb(220,220,220");for(var e=0;e<g.length;e++){b.push("CNA")}var k=g.length;if(this.oncoprintMUT){g=g.concat(this.cloneObject(this.meta.data[this.oncoprintMUT].levels));h=h.concat(this.cloneObject(this.meta.data[this.oncoprintMUT].colors));for(var e=k;e<g.length;e++){b.push("MUT")}}var j=[];var f=[];for(var e=0;e<g.length;e++){if(g[e]){j.push(g[e]);f.push(b[e]);this.legendOncoprintColors[g[e]]=h[e];if(h[e]=="rgb(220,220,220"){this.legendOncoprintMutations=j.length}}}var d=this.getMaxText(j,this.legendFont);var c=this.measureText(d,this.legendFont);var a=Math.ceil(c+5+(this.margin*8));var h=Math.floor(this.width/a);var l=Math.ceil(j.length/h);this.legendOncoprintWidth=a*h;this.legendOncoprintHeight=((21+this.margin)*l)+this.margin;this.legendOncoprintRows=l;this.legendOncoprintCols=h;this.legendOncoprintLabels=j;this.legendOncoprintObjects=f}};this.setSampleLegendDimension=function(){this.legendSampleWidth=0;this.legendSampleHeight=0;this.legendSampleMaxStr="";this.legendSampleMaxStrLen=0;this.legendSamplesN=1;var n=this.getFontPt(this.legendFont);var k=0;var m=0;var a=this.decorations&&this.decorations.kaplanMeier;var l=this.decorations&&this.decorations.qq;var d=this.decorations&&this.decorations.cdf;var b=[];var c={};if(this.ridgeBy&&this.dataStndBy.y.smps.length==1){return}if(this.isHistogram&&this.isHistogramLayout()){for(var f=0;f<this.data.l.axes.length;f++){for(var e=0;e<this.data.l.axes[f].yAxis.length;e++){if(this.data.l.axes[f].yAxis[e]){if(this.segregateVariablesBy.length||!this.data.l.axes[f].yAxis[e].match(":")){c[this.data.l.axes[f].yAxis[e].split(":")[0]]=true}else{if(this.data.l.axes.length==this.dataStndBy.y.smps.length){c[this.data.l.axes[f].yAxis[e].split(":")[1]]=true}else{c[this.data.l.axes[f].yAxis[e]]=true}}}}}b=this.getKeys(c)}if(this.graphType.match(/Scatter/)&&!a&&!l&&!d){m=this.ridgeBy?this.dataStndBy.y.smps.length:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);if(this.ridgeBy){k=this.measureText(this.shortenText(this.getMaxText(this.dataStndBy.y.smps),this.maxSmpStringLen),this.legendFont)}else{if(this.isHistogram){k=this.measureText(this.shortenText(this.getMaxText(this.data.y.smps),this.maxSmpStringLen),this.legendFont);m=this.data.y.smps.length-1;if(this.isHistogramLayout()){m=b.length;k=this.measureText(this.shortenText(this.getMaxText(b),this.maxSmpStringLen),this.legendFont)}}else{if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){for(var f=0;f<this.xAxisIndices.length;f++){var h=this.shortenText(this.xAxis[f],this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[f],this.maxSmpStringLen);var g=this.measureText(h,this.legendFont);if(g>k){this.legendSampleMaxStr=h}k=Math.max(g,k)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){this.legendSampleMaxStr=this.shortenText(this.getMaxText(this.xAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[0],this.maxSmpStringLen);k=this.measureText(this.legendSampleMaxStr,this.legendFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){this.legendSampleMaxStr=this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.xAxis[0],this.maxSmpStringLen);k=this.measureText(this.legendSampleMaxStr,this.legendFont)}}}}}}if(k){this.legendSamplesN=m;this.legendSampleMaxStrLen=k;this.legendSampleWidth=((n-1)+k+(this.margin*3))*this.legendColumns;this.legendSampleHeight=(Math.ceil(m/this.legendColumns)*(n+this.margin))+this.margin}}};this.setVariableLegendDimension=function(){if(this.showLegend){this.legendVariableWidth=0;this.legendVariableHeight=0;var h=this;var g=function(){if(h.isDOE&&h.layoutCurrentDOE){if(h.layoutCurrentDOE){if(h.meta.data.x&&h.meta.data.x.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.x[h.layoutCurrentDOE]}else{if(h.meta.data.z&&h.meta.data.z.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.z[h.layoutCurrentDOE]}}}}return h.meta.data.y};var c=g();var a=this.getFontPt(this.legendFont);if(this.graphType=="Fish"){var o=this.getFontPt(this.legendFont);var b=this.varIndices.length;var f=this.shortenText(c.maxVarStr,this.maxVarStringLen);this.legendVariableWidth=((o-1)+this.measureText(f,this.legendFont)+(this.margin*6))*Math.min(b,this.legendColumns);this.legendVariableHeight=(Math.ceil(b/Math.min(b,this.legendColumns))*(o+this.margin))+(this.margin*5)}if(this.graphType=="Pie"){var b=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var f=this.isDOE&&this.layoutCurrentDOE?this.shortenText(c.maxLevStr,this.maxVarStringLen):this.shortenText(c.maxVarStr,this.maxVarStringLen);if(this.maxPieSectors<this.varIndices.length&&f.length<5){f=this.shortenText("Other",this.maxVarStringLen)}var e=this.measureText(f,this.legendFont)+a+(this.margin*3);var k=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var j=(1-this.percentAspectRatioPlotArea);this.legendVariableWidth=e>k*j?k*j:this.measureText(f,this.legendFont)+a+(this.margin*5);this.legendVariableHeight=((a+this.margin)*b)+(this.margin*2)}else{if(this.layoutValid&&this.segregateVariablesBy.length>0&&!this.graphType.match(/Scatter/)){if(this.segregateVariablesBy[0]=="variable"||(this.segregateVariablesBy.length>1&&this.segregateVariablesBy[1]=="variable")){return}else{if(!this.colorBy||(this.colorBy&&this.colorBy=="variable")){var o=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.varIndices.length;this.legendVariableWidth=((this.margin*3)+(a*2)+this.measureText(o,this.legendFont))*Math.min(b,this.legendColumns);this.legendVariableHeight=(Math.ceil(b/Math.min(b,this.legendColumns))*a*1.5)+(this.margin*2)}else{return}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var o=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.getFontPt(this.legendFont)):this.getFontPt(this.legendFont);var b=this.varIndices.length;var f=this.shortenText(c.maxVarStr,this.maxVarStringLen);this.legendVariableWidth=((o-1)+this.measureText(f,this.legendFont)+(this.margin*3))*Math.min(b,this.legendColumns);this.legendVariableHeight=(Math.ceil(b/Math.min(b,this.legendColumns))*(o+this.margin))+(this.margin*2)}else{if(!this.colorBy&&(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine")){var o=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.xAxisVarIndices.length+this.xAxis2VarIndices.length;this.legendVariableWidth=((this.margin*3)+(a*2)+this.measureText(o,this.legendFont))*Math.min(b,this.legendColumns);this.legendVariableHeight=(Math.ceil(b/Math.min(b,this.legendColumns))*a*1.5)+(this.margin*2)}else{if(!this.colorBy&&(this.graphType=="Bar"||this.graphType=="Line"||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot")){var o=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.varIndices.length;this.legendVariableWidth=((this.margin*3)+(a*2)+this.measureText(o,this.legendFont))*Math.min(b,this.legendColumns);this.legendVariableHeight=(Math.ceil(this.varIndices.length/Math.min(b,this.legendColumns))*a*1.5)+(this.margin*2)}else{if(this.graphType=="Circular"&&!this.showIdeogram){var o=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var i=this.rAxisIndex>=0?this.varIndices.length-1:this.varIndices.length;this.legendVariableWidth=((this.margin*3)+(a*2)+this.measureText(o,this.legendFont))*Math.min(i,this.legendColumns);this.legendVariableHeight=(Math.ceil(i/Math.min(i,this.legendColumns))*a*1.5)+(this.margin*2)}}}}}}if(this.legendVariableHeight>this.height){this.legendColumns++;this.maxVarStringLen=Math.max(10,this.maxVarStringLen-5);this.setVariableLegendDimension()}}};this.setVennLegendDimension=function(){var a=this.data.venn.legend?this.getMaxText(this.data.venn.legend):"N/A";this.legendWidth=this.measureText(a,this.legendFont)+(this.margin*6);this.legendHeight=this.margin+this.margin+((this.getFontPt(this.legendFont)+this.margin)*this.vennGroups)};this.setOverlaysLegendDimensions=function(){var b=this.getFontPt(this.legendFont)+2;var s=this.getDiameterLegend();var k=Math.max(b,s);var d=["varOverlays","smpOverlays"];var e=["varOverlayProperties","smpOverlayProperties"];var y=["showVarOverlaysLegend","showSmpOverlaysLegend"];this.legendOverlaysLayout=[];this.legendOverlaysWidth=0;this.legendOverlaysHeight=0;var q=this.margin;var n=this.margin;var a=0;var g=0;var l=0;var B=false;if(this.showOverlays&&(this.showVarOverlaysLegend||this.showSmpOverlaysLegend)){for(var v=0;v<d.length;v++){if(this[d[v]].length>0&&this[y[v]]){for(var t=0;t<this[d[v]].length;t++){var f=0;var x=0;var p=this[d[v]][t];if(p!="-"){var A=d[v]=="varOverlays"?"z":"x";var r=this.meta.data[A][p];var u=this.measureText(r.maxLevStr,this.legendFont);var z=this.measureText(p,this.legendFont);if(this.graphType=="Circular"||(this[e[v]][p]&&this[e[v]][p].type=="Default"&&this[e[v]][p].showLegend)){B=true;if(r.type=="String"){f=Math.max(z,u+k+(this.margin*3))*this[d[v]+"LegendColumns"];x=((Math.max(b,s)+this.margin)*Math.ceil(r.levels.length/this[d[v]+"LegendColumns"]))+b+this.margin}else{if(this.overlaysLegendPosition.match(/right/i)){f=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z);x=this.heatmapIndicatorWidth+(this.margin*3)+b}else{f=this.heatmapIndicatorWidth+(this.margin*3)+b;x=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z)}}this["legend"+p+"Width"]=f;this["legend"+p+"Height"]=x;if(this.overlaysLegendPosition.match(/right/i)){if(g+this.margin+x>(this.height-(this.top+this.bottom))){q+=this.margin+f;a=f;g=x;if(this.legendOverlaysLayout[l]){l++}this.legendOverlaysLayout[l]=[[A,p,f,x]]}else{if(f>a){q+=(f-a);a=f}g+=x;if(!this.legendOverlaysLayout[l]){this.legendOverlaysLayout[l]=[]}this.legendOverlaysLayout[l].push([A,p,f,x])}}else{if(a+this.margin+f>(this.width-(this.left+this.right))){n+=this.margin+x;a=f;g=x;if(this.legendOverlaysLayout[l]){l++}this.legendOverlaysLayout[l]=[[A,p,f,x]]}else{if(x>g){n+=(x-g);g=x}a+=f;if(!this.legendOverlaysLayout[l]){this.legendOverlaysLayout[l]=[]}this.legendOverlaysLayout[l].push([A,p,f,x])}}}}}}}}if(this.overlaysLegendPosition.match(/right/i)){this.legendOverlaysWidth=B?q+this.margin:0;this.legendOverlaysHeight=B?g+this.margin:0}else{this.legendOverlaysWidth=B?a+this.margin:0;this.legendOverlaysHeight=B?n+this.margin:0}};this.setLegendDimensions=function(){if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){this.decorationLayout=[0]}if(this.showLegend){this.legendLayout=[];this.legendWidth=0;this.legendHeight=0;var a=this.margin;var k=this.margin;var b=0;var j=0;var g=0;var e=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge","Decoration"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:this.connectByNoColor?["Color","Shape","Size","Pattern","Variable","Sample"]:["Color","Shape","Size","Pattern","Connect","Variable","Sample","Contour"];for(var c=0;c<e.length;c++){var f=this["legend"+e[c]+"Width"];var d=this["legend"+e[c]+"Height"];if(e[c]=="Decoration"&&!this.showDecorations){continue}if(e[c]=="Size"&&this.graphType=="Map"&&this.decorations&&this.decorations.pie){continue}if(f>0){if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legendLayout[g]=[e[c]];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legendLayout[c]=[e[c]];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}}}for(var c=0;c<this.legend.length;c++){this.legend[c].id="Custom"+c;this.setCustomLegendDimensions(this.legend[c]);var f=this["legendCustom"+c+"Width"];var d=this["legendCustom"+c+"Height"];if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legendLayout[g]=[this.legend[c].id];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(this.legend[c].id)}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legendLayout[c]=[this.legend[c].id];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(this.legend[c].id)}}}this.legendWidth=b==0&&a==this.margin?0:this.legendPosition.match(/right|left/i)?a+this.margin:b+this.margin;this.legendHeight=j==0&&k==this.margin?0:this.legendPosition.match(/right|left/i)?j+this.margin:k+this.margin;if(this.legendPositionAuto&&!this.legendInside&&!this.legendPositionTest){if(this.legendPosition.match(/right|left/i)&&this.legendWidth>this.legendHeight*1.5){this.legendPositionTest=true;this.legendPosition="bottom";this.setLegends()}else{if(this.legendPosition.match(/top|bottom/i)&&this.legendHeight>this.legendWidth*1.5){this.legendPositionTest=true;this.legendPosition="right";this.setLegends()}}this.legendPositionTest=false}}};this.setLegends=function(q){var h=this;var g=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:this.connectByNoColor?["Color","Shape","Size","Pattern","Outline"]:["Color","Shape","Size","Pattern","Outline","Connect","Contour"];var r=["shapeByData","sizeByData","patternByData","outlineByData"];var n=function(a,o,t){var u=o=="Outline"?"Color":o;var s=(h.decapitalize(u)+"s").replace("Node","").replace("Edge","").replace("decorations","colors");delete (h["legend"+u+"sS"]);h["legend"+u+"Meta"]=a;if(t){h["legend"+u+"Meta"].vals=h.colorSpectrumBreaks.length?h.colorSpectrumBreaks:h.rPretty(t[0],t[1],5);h["legend"+u+"Meta"].decs=h.getAxisDecimals(t[1]-t[0]);h["legend"+u+"Meta"].maxLevStr=h.getMaxText(h["legend"+(o=="Outline"?"Color":o)+"Meta"].vals);h["legend"+u+"Meta"].maxLevLen=h.measureText(h["legend"+u+"Meta"].maxLevStr,h.font);h["legend"+u+"Meta"].maxLevChr=h["legend"+u+"Meta"].maxLevStr.toString().length}if(h.ridgeBy&&h.colorBy=="data"){h["legend"+u+"Meta"].min=h["legend"+u+"Meta"].vals[0];h["legend"+u+"Meta"].max=h["legend"+u+"Meta"].vals[h["legend"+u+"Meta"].vals.length-1]}h["legend"+u+"sMax"]=h["legend"+u+"Meta"].maxLevStr;h["legend"+u+"sN"]=h["legend"+u+"Meta"].vals.length;if(!h["legend"+u+"s"]){h["legend"+u+"s"]=[]}for(var p=0;p<h["legend"+u+"Meta"].vals.length;p++){h["legend"+u+"s"][h["legend"+u+"Meta"].vals[p].toString()]=u=="Connect"?h.colors[p]:u=="Contour"?h.getColorForValue(a,h["legend"+u+"Meta"].vals[p]):h[s][p]}h.setPropertyLegendIndicatorDimensions(o,h["legend"+u+"Meta"])};var j=function(B,I,x,D,y){var F=0;var v=0;var A=false;var C={};var s={};var a=B[h.decapitalize(D).replace("Node","").replace("Edge","")+"s"]||h[h.decapitalize(D).replace("Node","").replace("Edge","")+"s"];var z=h.isGroupedData&&h.graphType!="Dotplot"&&h.graphType!="Boxplot"&&!h.showBoxplotOriginalData&&h.groupingFactors.length==1;if(I=="x"){var t=h.isGroupedData?h.grpIndices:h.smpIndices;for(var G=0;G<t.length;G++){var u=t[G];if(h.isGroupedData&&(h.graphType=="Dotplot"||h.graphType=="Boxplot"||h.barType=="swimmer"||h.graphType=="Gantt"||h.stackBy||h.lineBy)){h.isGroupedData=false;for(var E=0;E<h.data.w.grps[u].length;E++){var w=h.getMetadataValue(h.data.w.grps[u][E],I,h[x]);s[w]=true}h.isGroupedData=true}else{var w;if(h.isGroupedData){h.isGroupedData=false;w=h.getSmpAnnotations(h[x],h.data.w.grps[G],true);h.isGroupedData=true}else{w=h.getMetadataValue(u,I,h[x])}s[w]=true}}}else{if(I=="z"){if(h.graphType=="Map"&&h.varIndices.length<B.levels.length){for(var G=0;G<B.levels.length;G++){var w=B.levels[G];s[w]=true}}else{for(var G=0;G<h.varIndices.length;G++){var u=h.varIndices[G];var w=h.getMetadataValue(u,I,h[x]);s[w]=true}}}else{if(I=="m"){for(var G=0;G<h.varIndices.length;G++){for(var E=0;E<h.smpIndices.length;E++){var w=y[h.varIndices[G]][h.smpIndices[E]];s[w]=true}}}else{if(I=="modified"){B.order={};for(var G=0;G<B.levels.length;G++){s[B.levels[G]]=true;B.order[B.levels[G]]=G}}else{if(I=="nodes"||I=="edges"){B.order={};for(var G=0;G<B.levels.length;G++){s[B.levels[G]]=true;B.order[B.levels[G]]=G}}}}}}s=h.getKeys(s);if(B.type=="Numeric"){if(B.orderS){s.sort(function(l,i){return B.orderS[l]-B.orderS[i]})}else{s.sort(function(l,i){return l-i});B.orderS={};for(var G=0;G<s.length;G++){B.orderS[s[G]]=G}}}else{s.sort(function(l,i){return B.order[l]-B.order[i]})}for(var G=0;G<s.length;G++){var w=s[G]!=null?s[G]:"NA";var H=h.measureText(w,h.legendFont);if(H>F){F=H;h["legend"+D+"sMax"]=w}C[w]=(B.type=="Numeric"?B.orderS[w]:B.order[w])%a.length;h["legend"+D+"s"][w]=a[C[w]];v++}h["legend"+D+"sS"]=s;A=I=="m"||I=="modified"?h["legend"+D+"sMax"]:false;h["legend"+D+"sN"]=v;h["legend"+D+"Meta"]=B;h.setPropertyLegendDimensions(D,A,B)};if(!this.hiddenLegends){this.hiddenLegends={}}this.validateLegendPositions();this.setLegendFont();if(this.graphType=="Meter"){return}else{if(this.graphType=="Venn"){this.setVennLegendDimension();return}else{if(this.graphType=="Network"){for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;if(this[b]){var d=this.meta.data[e.match("Node")?"nodes":"edges"][this[b]];if(d.type=="Numeric"){n(d,e)}else{j(d,e.match("Node")?"nodes":"edges",b,e)}}}if(this.decorations.length&&this.decorationsType=="heatmap"&&this.meta.data.decorations.n&&this.showDecorations){var d=this.meta.data.decorations;var e="Decoration";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;n(d,e)}}else{if(this.isMultidimensionalData){for(var f=0;f<r.length;f++){if(this.data.y[this[r[f]]]){var c=this.data.y[this[r[f]]];var d=this.meta.data[this[r[f]]];var e=r[f].replace("ByData","");e=this.capitalize(e);var k=this.decapitalize(e);var b=k+"By";this["legend"+(e=="Outline"?"Color":e)+"s"]=[];this["legend"+(e=="Outline"?"Color":e)+"sN"]=0;if(d.type=="Numeric"){n(d,e,[d.min,d.max])}else{j(d,"m",b,e,c)}}}}else{if(this.isContour==true&&this.contourFilled){for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0}if(!this.meta.data.q.o){this.createContour(this.isContour,true)}var e="Contour";var d=this.meta.data.q.o;n(d,e)}else{for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;if(q){continue}if(this[b]){if(this.data.x&&this.data.x.hasOwnProperty(this[b])){var d=this.meta.data.x[this[b]];this[k+"ByType"]="x";if(d.type=="Numeric"&&!d[b]){n(d,e)}else{j(d,"x",b,e)}}else{if(this.data.z&&this.data.z.hasOwnProperty(this[b])){var d=this.meta.data.z[this[b]];this[k+"ByType"]="z";if(d.type=="Numeric"&&!d[b]){n(d,e,this.colorSpectrumBreaks.length?true:false)}else{j(d,"z",b,e)}}else{if(this.getSampleIndices(this[b])>-1&&this.meta.data.y.range[this[b]]){var d=this.meta.data;if(d.modified&&d.modified.z&&d.modified.z[this[b]]){d=d.modified.z;if(!d.meta){d.meta={}}d.meta[this[b]]={levels:d[this[b]]};j(d.meta[this[b]],"modified",b,e)}else{d=d.y.range[this[b]];n(d,e,[d.min,d.max])}}else{if(this[b]=="variable"){h["legend"+e+"sN"]=this.varIndices.length}else{if(this.ridgeBy&&this[b]=="data"){n({type:"Numeric"},e,[this.xAxisMin,this.xAxisMax])}}}}}}}}}}}}this.setDecorationsLegendDimensions();this.setSampleLegendDimension();this.setVariableLegendDimension();this.setOncoprintLegendDimension();this.setOverlaysLegendDimensions();this.setLegendDimensions()};this.addLegend=function(c,b){if(c){if(b){var a=this.findXYCoordinates(b);c.x=a.x;c.y=a.y}this.legend.push(c)}};this.deleteLegend=function(c){if(c&&c.id){var b=[];for(var a=0;a<this.legend.length;a++){if(this.legend[a].id!=c.id){b.push(this.legend[a])}}this.legend=b}};this.drawDecorationData=function(){this.toRender({p:["setClipArea",this.setClipBoundaries()],t:"Decorations"});var ae=this.marginLeft+this.offsetX+this.left;var Z=this.marginTop+this.offsetY+this.top;var am=this.decorations;if(this.showDecorations&&am){if(this.graphType.match(/Scatter/)){if(am.qq){for(var ai=0;ai<am.qq.length;ai++){var ao=am.qq[ai].data;var O=am.qq[ai].color;var aI=am.qq[ai].index;if(this.smpIndices.includes(aI)){for(var ah=0;ah<this.qqPoints;ah++){var K=ae+(ao.x[ah]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var g=(Z+this.y)-(ao.y[ah]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);this.toRender({p:["drawShape","circle",K,g,this.dataPointSize,this.dataPointSize,false,O,"open"],a:this.getShapeArea("circle",K,g,this.dataPointSize,this.dataPointSize,false,O,"open"),i:["QQ-"+ai+"-"+ah],t:"Decorations"})}this.toRender({p:["drawLine","line",ae,Z+this.y,ae+this.x,Z,this.fitLineColor,2],t:"Decorations"})}}}else{if(am.cdf){for(var ai=0;ai<am.cdf.length;ai++){var ao=am.cdf[ai].data;var O=am.cdf[ai].color;var aI=am.cdf[ai].index;if(this.smpIndices.includes(aI)){var aO=[];var aC=[];for(var ah=0;ah<ao.x.length;ah++){aO.push(ae+(ao.x[ah]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit));aC.push((Z+this.y)-(ao.y[ah]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit))}this.toRender({p:["drawLine","spline",aO,aC,false,false,O,2],a:this.getLineArea("spline",aO,aC,false,false,O,2),i:["CDF-"+ai],t:"Decorations"})}}}else{if(!am.qq&&!am.cdf){if(am.nlfit){var h,P,f;var H=this.varIndices;var K,g;for(var ai=0;ai<am.nlfit.length;ai++){var aM=[];var aK=[];var O=ai%this.colors.length;var a=Number(this.transformValue(this.yAxisTransform,am.nlfit[ai].param[0]));var a4=Number(this.transformValue(this.yAxisTransform,am.nlfit[ai].param[1]));var aZ=Number(am.nlfit[ai].param[2]);var aX=Number(am.nlfit[ai].param[3]);var aa=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[ai];var aO=this.getDataForSmpGrpAtIndex(aa);if(this.xAxisTransform=="percentile"){h=this.range(aO);f=h[0];P=h[1]}H.sort(function(i,d){return aO[i]-aO[d]});O=am.nlfit[ai].color?am.nlfit[ai].color:this.colors[O];for(var ah=0;ah<H.length;ah++){var D=H[ah];var S=this.getDataAtPos(D,aa);var R;var N=[];if(S>0){if(ah>0){var aL=H[ah-1];var aP=this.getDataAtPos(aL,aa);if(aP>0){var T=(S-aP)/25;for(var ag=0;ag<25;ag++){N.push(aP);aP+=T}}}else{N=[S]}for(var ag=0;ag<N.length;ag++){if(am.nlfit[ai].type=="reg"){R=a+((a4-a)/(1+aZ/(Math.pow(N[ag],aX))))}else{R=a+((a4-a)/(1+(Math.pow((N[ag]/aZ),aX))))}if(this.xAxisTransform){N[ag]=this.xAxisTransform=="percentile"?this.percentile(f,P,N[ag]):this.transformValue(this.xAxisTransform,N[ag])}K=ae+((N[ag]-this.xAxisMin)*this.xAxisUnit);g=(Z+this.y)-((R-this.yAxisMin)*this.yAxisUnit);aM.push(K);aK.push(g)}}}if(aM.length>0){this.toRender({p:["drawShape","path",aM,aK,false,false,O,O,"open",false,false,true],a:this.getShapeArea("path",aM,aK,false,false,O,O,"open",false,false,true),i:["Decor-Non-Lin-"+ah+"-"+ai],t:"Decorations"});if(am.nlfit[ai].type=="reg"){R=a+((a4-a)/(1+aZ/(Math.pow(aZ,aX))))}else{R=a+((a4-a)/(1+(Math.pow((aZ/aZ),aX))))}if(this.xAxisTransform){aZ=this.xAxisTransform=="percentile"?this.percentile(f,P,aZ):this.transformValue(this.xAxisTransform,aZ)}K=ae+((aZ-this.xAxisMin)*this.xAxisUnit);g=(Z+this.y)-((R-this.yAxisMin)*this.yAxisUnit);var aI=this.toRender({p:["drawLine","dottedLine",ae,g,K,g,O],a:this.getLineArea("dottedLine",ae,g,K,g,O),i:["Decor-Non-Lin-EC-h"+ah+"-"+ai],t:"Decorations"});this.toRender({p:["drawLine","dottedLine",K,g,K,(Z+this.y),O],a:this.getLineArea("dottedLine",K,g,K,(Z+this.y),O),i:["Decor-Non-Lin-EC-v"+ah+"-"+ai],g:aI,t:"Decorations"})}}}if(am.text){for(var ai=0;ai<am.text.length;ai++){if(am.text[ai].x!=null||am.text[ai].y!=null){var O=am.text[ai].color?am.text[ai].color:this.foreground;var S=am.text[ai].x!=null?am.text[ai].x:null;var R=am.text[ai].y!=null?am.text[ai].y:null;var o=am.text[ai].label||false;var aA=am.text[ai].scope||false;var aR=am.text[ai].align||"left";var K,g;if(aA){var av=this.layoutValid?false:true;if(this.layoutValid){var X=this.data.l.name[this.layoutCurrent];if(!this.isArray(X)){X=[X]}for(var ah=0;ah<X.length;ah++){if(aA.toString()==X[ah].toString().replace("\x00","")){av=true;break}}}if(!av){continue}}if(S!=null&&R!=null&&o){K=ae+((S-this.xAxisMin)*this.xAxisUnit);g=Z+this.y-((R-this.yAxisMin)*this.yAxisUnit);if(aR=="right"){this.toRender({p:["drawText",o,K,g,this.decorationFont,O,"right","middle"],t:"Decorations"})}else{if(aR=="center"){this.toRender({p:["drawText",o,K,g,this.decorationFont,O,"center","middle"],t:"Decorations"})}else{this.toRender({p:["drawText",o,K,g,this.decorationFont,O,"left","middle"],t:"Decorations"})}}}}}}if(am.line){for(var ai=0;ai<am.line.length;ai++){if(am.line[ai].x!=null||am.line[ai].y!=null){var O=am.line[ai].color?am.line[ai].color:this.colors[ai%this.colors.length];var aq=am.line[ai].type?am.line[ai].type:"line";var S=am.line[ai].x!=null?am.line[ai].x:null;var R=am.line[ai].y!=null?am.line[ai].y:null;var G=am.line[ai].x2!=null?am.line[ai].x2:null;var c=am.line[ai].y2!=null?am.line[ai].y2:null;var U=am.line[ai].width?am.line[ai].width:1;var o=am.line[ai].label||false;var aR=am.line[ai].align||"left";var aA=am.line[ai].scope||false;var r=this.isArray(S)&&this.isArray(R)&&G==null&&c==null;var ax=null;var K,g,I,e,at;if(this.isCreateHistogram){if(S!=null){S-=this.isCreateHistogram.min}if(G!=null){G-=this.isCreateHistogram.min}}if(aA){var av=this.layoutValid?false:true;if(this.layoutValid){var X=this.data.l.name[this.layoutCurrent];if(!this.isArray(X)){X=[X]}for(var ah=0;ah<X.length;ah++){if(aA.toString()==X[ah].toString().replace("\x00","")){av=true;break}}}if(!av){continue}}if(r){for(var ah=1;ah<S.length;ah++){K=ae+((S[ah-1]-this.xAxisMin)*this.xAxisUnit);I=ae+((S[ah]-this.xAxisMin)*this.xAxisUnit);g=Z+this.y-((R[ah-1]-this.yAxisMin)*this.yAxisUnit);e=Z+this.y-((R[ah]-this.yAxisMin)*this.yAxisUnit);at=o?o:"";if(ah==1){ax=this.toRender({p:["drawLine",aq,K,g,I,e,O,U],a:this.getLineArea(aq,K,g,I,e,O,U),i:[at+":Decor-Line-"+ai],t:"Decorations"})}else{this.toRender({p:["drawLine",aq,K,g,I,e,O,U],a:this.getLineArea(aq,K,g,I,e,O,U),i:[at+":Decor-Line-"+ai],g:ax,t:"Decorations"})}}}else{if(S!=null&&R!=null&&G!=null&&c!=null){K=ae+((S-this.xAxisMin)*this.xAxisUnit);I=ae+((G-this.xAxisMin)*this.xAxisUnit);g=Z+this.y-((R-this.yAxisMin)*this.yAxisUnit);e=Z+this.y-((c-this.yAxisMin)*this.yAxisUnit);at=am.line[ai].tooltip||("("+S+","+R+") &rarr; ("+G+","+c+")");this.toRender({p:["drawLine",aq,K,g,I,e,O,U],a:this.getLineArea(aq,K,g,I,e,O,U),i:[at+":Decor-Line-"+ai],t:"Decorations"})}else{if(S!=null){K=ae+((S-this.xAxisMin)*this.xAxisUnit);g=Z;I=K;e=g+this.y;at=am.line[ai].tooltip||("x &rarr; "+(this.isCreateHistogram?S+this.isCreateHistogram.min:S));this.toRender({p:["drawLine",aq,K,g,I,e,O,U],a:this.getLineArea(aq,K,g,I,e,O,U),i:[at+":Decor-Line-"+ai],t:"Decorations"})}else{if(R!=null){K=ae;g=Z+this.y-((R-this.yAxisMin)*this.yAxisUnit);I=K+this.x;e=g;at=am.line[ai].tooltip||("y &rarr; "+R);this.toRender({p:["drawLine",aq,K,g,I,e,O,U],a:this.getLineArea(aq,K,g,I,e,O,U),i:[at+":Decor-Line-"+ai],t:"Decorations"})}}}}if(o&&!r){if(am.line[ai].y2!=null){var aF=this.getRadians(K,g,I,e);if(aR=="right"){this.toRender({p:["drawText",o,I,e,this.decorationFont,this.decorationColor,"right","bottom",aF],t:"Decorations"})}else{if(aR=="center"){this.toRender({p:["drawText",o,(K+I)/2,(g+e)/2,this.decorationFont,this.decorationColor,"center","bottom",aF],t:"Decorations"})}else{this.toRender({p:["drawText",o,K,g,this.decorationFont,this.decorationColor,"left","bottom",aF],t:"Decorations"})}}}else{if(aR=="right"){this.toRender({p:["drawText",o,I-this.margin,e-this.margin,this.decorationFont,this.decorationColor,"right","bottom"],t:"Decorations"})}else{if(aR=="center"){this.toRender({p:["drawText",o,(K+I)/2,e-this.margin,this.decorationFont,this.decorationColor,"center","bottom"],t:"Decorations"})}else{this.toRender({p:["drawText",o,K+this.margin,e-this.margin,this.decorationFont,this.decorationColor,"left","bottom"],t:"Decorations"})}}}}}}}if(am.reg){for(var ai=0;ai<am.reg.length;ai++){if(am.reg[ai].slope&&am.reg[ai].intercept){var p=am.reg[ai].fit?am.reg[ai].fit:this.colors[ai%this.colors.length];var O=am.reg[ai].color?am.reg[ai].color:this.colors[ai%this.colors.length];var J=this.addColorTransparency(O,0.3,true);var m=this.getPropertyValue(ai,false,"patternBy");var an=am.reg[ai].style?am.reg[ai].style:this.fitLineStyle;var aT=Number(am.reg[ai].slope);var al=Number(am.reg[ai].intercept);var af=am.reg[ai].id;var L=am.reg[ai].cor;var A="y ~ "+this.formatNumber(aT,this.yAxisDecs+1)+"x + "+this.formatNumber(al,this.yAxisDecs+1)+(L?" (r = "+this.formatNumber(L,3)+")":"");var V=am.reg[ai].ci?am.reg[ai].ci:false;var M=V?V.length-1:false;var K=this.showRegressionFullRange||!V?this.xAxisMin:V[0][0];var g=(aT*K)+al;var I=this.showRegressionFullRange||!V?this.xAxisMax:V[M][0];var e=(aT*I)+al;K=ae+(K*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Z+this.y)-(g*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);I=ae+(I*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(Z+this.y)-(e*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var aE=this.lineClip([[K,g],[I,e]]);if(aE.length){this.toRender({p:["drawLine",an,aE[0][0][0],aE[0][0][1],aE[0][1][0],aE[0][1][1],p,2],a:this.getLineArea(an,aE[0][0][0],aE[0][0][1],aE[0][1][0],aE[0][1][1],p,2),i:["Decor-Reg-"+ai,af],t:"Decorations",h:this.isHidden(false,false,af)})}if(V){var B=[];var z=[];var ay=[];for(var ah=0;ah<V.length;ah++){K=ae+(V[ah][0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Z+this.y)-(V[ah][1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);e=(Z+this.y)-(V[ah][2]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);B.push([K,K]);z.push([g,e]);ay.push([K,(g+e)/2])}if(this.showConfidenceIntervals){this.toRender({p:["drawShape","confidence",B,z,false,false,J,O,m],a:this.getShapeArea("confidence",B,z,false,false,J,O,m),i:[A+":Confidence",af],b:ay,t:"Decorations",h:this.isHidden(false,false,af)})}}}}}if(am.nor){for(var ai=0;ai<am.nor.length;ai++){if(am.nor[ai].mu&&am.nor[ai].sigma){var F=[];var E=[];var aJ=[];var K,g;var O=ai%this.colors.length;var az=am.nor[ai].mu;var au=am.nor[ai].sigma;var s=am.nor[ai].start?am.nor[ai].start:am.nor[ai].yAxis?this.yAxisMin:this.xAxisMin;var aj=am.nor[ai].end?am.nor[ai].end:am.nor[ai].yAxis?this.yAxisMax:this.xAxisMax;var aB=120;if(s<az&&az<aj){var aP,aD,u,b;var T=(az-s)/aB;var v=au*au;var Y=v*2;var ak=1/Math.sqrt(2*Math.PI*v);if(am.nor[ai].yAxis){u=am.nor[ai].max?am.nor[ai].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);b=u/ak;aP=s;for(var ah=0;ah<aB-1;ah++){aD=(ak*Math.pow(Math.E,-Math.pow(aP-az,2)/v));aJ.push([aP,aD]);K=ae+(aD*b);g=(Z+this.y)-(aP*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);F.push(K);E.push(g);aP+=T}T=(aj-az)/aB;aP=az;for(var ah=0;ah<aB;ah++){aD=(ak*Math.pow(Math.E,-Math.pow(aP-az,2)/v));aJ.push([aP,aD]);K=ae+(aD*b);g=(Z+this.y)-(aP*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);F.push(K);E.push(g);aP+=T}O=am.nor[ai].color?am.nor[ai].color:this.colors[O];this.toRender({p:["drawShape","path",F,E,false,false,O,O,"open",false,false,true],a:this.getShapeArea("path",F,E,false,false,O,O,"open",false,false,true),i:["Decor-Nor-"+ai],t:"Decorations"})}else{u=am.nor[ai].max?am.nor[ai].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);b=u/ak;aP=s;for(var ah=0;ah<aB-1;ah++){aD=(ak*Math.pow(Math.E,-Math.pow(aP-az,2)/v));aJ.push([aP,aD]);K=ae+(aP*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Z+this.y)-(aD*b);F.push(K);E.push(g);aP+=T}T=(aj-az)/aB;aP=az;for(var ah=0;ah<aB;ah++){aD=(ak*Math.pow(Math.E,-Math.pow(aP-az,2)/v));aJ.push([aP,aD]);K=ae+(aP*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Z+this.y)-(aD*b);F.push(K);E.push(g);aP+=T}O=am.nor[ai].color?am.nor[ai].color:this.colors[O];this.toRender({p:["drawShape","path",F,E,false,false,O,O,"open",false,false,true],a:this.getShapeArea("path",F,E,false,false,O,O,"open",false,false,true),i:["Decor-Nor-"+ai],t:"Decorations"})}}}}}if(am.area){for(var ai=0;ai<am.area.length;ai++){if(am.area[ai].type&&am.area[ai].x&&am.area[ai].y&&am.area[ai].width&&am.area[ai].height){if(this.isValidShape(am.area[ai].type)){var K=ae+(am.area[ai].x*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var g=(Z+this.y)-(am.area[ai].y*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var O=am.area[ai].color?am.area[ai].color:this.colors[ai%this.colors.length];var q=am.area[ai].width*this.xAxisUnit;var ap=am.area[ai].height*this.yAxisUnit;this.oRender({p:["drawShape",am.area[ai].type,K,g,q,ap,O,am.area[ai].outline,am.area[ai].pattern,am.area[ai].rotate],a:this.getShapeArea(am.area[ai].type,K,g,q,ap,O,am.area[ai].outline,am.area[ai].pattern,am.area[ai].rotate),i:["Decor-Area-"+ai],t:"Decorations"})}}}}if(am.point){for(var ai=0;ai<am.point.length;ai++){if(am.point[ai].x&&am.point[ai].y){var K=ae+(am.point[ai].x*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var g=(Z+this.y)-(am.point[ai].y*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var aN=am.point[ai].shape||"circle";var O=am.point[ai].color||this.foreground;var q=am.point[ai].width||this.dataPointSize;var ap=am.point[ai].height||this.dataPointSize;this.toRender({p:["drawShape",aN,K,g,q,ap,O,O],a:this.getShapeArea(aN,K,g,q,ap,O,O),t:"Decorations"})}}}if(am.kaplanMeier){var K,g,I,e,aS,aQ,ac,ab,O,J,ar,aU,aW,aV,aH,aI,ad,a0,aY,n,aw;for(var ai=0;ai<am.kaplanMeier.length;ai++){ar=[[],[]];aU=[[],[]];aW=[[],[]];O=am.kaplanMeier[ai].color;J=this.addColorTransparency(O,0.3,true);n=this.getSampleIndices(am.kaplanMeier[ai].time,false,this.isDOE);aw=this.getSampleIndices(am.kaplanMeier[ai].censored,false,this.isDOE);ad=this.kaplanMeier(this.getDataForSmpGrpAtIndex(n,am.kaplanMeier[ai].indices),this.getDataForSmpGrpAtIndex(aw,am.kaplanMeier[ai].indices));K=ae;g=(Z+this.y)-(this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);I=ae+(Number(ad.time[0])*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(Z+this.y)-(ad.kaplanMeier[0]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aQ=(Z+this.y)-(ad.upperLimit[0]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);ab=(Z+this.y)-(ad.lowerLimit[0]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aV=K;aH=g;a0=e-this.margin;aY=e+this.margin;aI=this.toRender({p:["drawLine","line",K,g,I,g,O],a:this.getLineArea("line",K,g,I,g,O),i:["Decor-KM-h-0-"+ai],b:[aV,aH,aV,aH],t:"Decorations"});this.toRender({p:["drawShape","circle",I,e,1,1,O],a:this.getShapeArea("circle",I,e,1,1,O),i:["Decor-KM-x-0-"+ai],g:aI,b:[aV,aH],t:"Decorations"});this.toRender({p:["drawLine","line",I,g,I,e,O],a:this.getLineArea("line",I,g,I,e,O),i:["Decor-KM-v-0-"+ai],g:aI,b:[aV,aH,aV,aH],t:"Decorations"});if(ad.nCensored[0]){this.toRender({p:["drawLine","line",I,a0,I,aY,O,2],a:this.getLineArea("line",I,a0,I,aY,O,2),i:["Decor-KM-c-0-"+ai],g:aI,b:[aV,aH,aV,aH],t:"Decorations"})}ar[0].push(K,I);ar[1].push(aQ,aQ);aU[0].push(K,I);aU[1].push(ab,ab);for(var ah=1;ah<ad.time.length-1;ah++){K=ae+(Number(ad.time[ah-1])*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(Z+this.y)-(ad.kaplanMeier[ah]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aS=(Z+this.y)-(ad.upperLimit[ah]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);ac=(Z+this.y)-(ad.lowerLimit[ah]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);I=ae+(Number(ad.time[ah])*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(Z+this.y)-(ad.kaplanMeier[ah+1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aQ=(Z+this.y)-(ad.upperLimit[ah+1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);ab=(Z+this.y)-(ad.lowerLimit[ah+1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);a0=e-this.margin;aY=e+this.margin;this.toRender({p:["drawLine","line",K,g,I,g,O],a:this.getLineArea("line",K,g,I,g,O),i:["Decor-KM-h-"+ah+"-"+ai],g:aI,b:[aV,aH,aV,aH],t:"Decorations"});this.toRender({p:["drawShape","circle",I,e,1,1,O],a:this.getShapeArea("circle",I,e,1,1,O),i:["Decor-KM-x-"+ah+"-"+ai],g:aI,b:[aV,aH],t:"Decorations"});this.toRender({p:["drawLine","line",I,g,I,e,O],a:this.getLineArea("line",I,g,I,e,O),i:["Decor-KM-v-"+ah+"-"+ai],g:aI,b:[aV,aH,aV,aH],t:"Decorations"});if(ad.nCensored[ah]){this.toRender({p:["drawLine","line",I,a0,I,aY,O,2],a:this.getLineArea("line",I,a0,I,aY,O,2),i:["Decor-KM-c-"+ah+"-"+ai],g:aI,b:[aV,aH,aV,aH],t:"Decorations"})}ar[0].push(K,I,I);ar[1].push(aS,aS,aQ);aU[0].push(K,I,I);aU[1].push(ac,ac,ab)}K=I;I=ae+(Number(ad.time[ah])*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);this.toRender({p:["drawLine","line",K,e,I,e,O],a:this.getLineArea("line",K,e,I,e,O),i:["Decor-KM-h-"+ah+"-"+ai],g:aI,b:[aV,aH,aV,aH],t:"Decorations"});ar[0].push(I,I);ar[1].push(aQ,aQ);aU[0].push(I,I);aU[1].push(ab,ab);if(this.showConfidenceIntervals){aW[0]=ar[0].concat(aU[0].reverse());aW[1]=ar[1].concat(aU[1].reverse());this.toRender({p:["drawShape","polygon",aW[0],aW[1],false,false,J,J,"closed"],a:this.getShapeArea("polygon",aW[0],aW[1],false,false,J,J,"closed"),i:["Decor-KM-Conf"+ai],t:"Decorations"})}}}}}}}else{if(am.line){for(var ai=0;ai<am.line.length;ai++){var K,g,I,e;var av=true;var aq=am.line[ai].type||"line";var C=am.line[ai].color;var W=this.transformValue(this.isTransformedData,am.line[ai].value||0);var o=am.line[ai].label||false;var aG=am.line[ai].width||1;var aR=am.line[ai].align||"left";var aA=am.line[ai].scope||false;if(this.graphOrientation=="vertical"){K=this.marginLeft+this.offsetX+this.left;I=K+this.x;g=this.marginTop+this.offsetY+this.top+this.y-((W-this.xAxisMin)*this.xAxisUnit);e=g;av=g<=this.marginTop+this.offsetY+this.top+this.y&&g>=this.marginTop+this.offsetY+this.top?true:false}else{K=this.marginLeft+this.offsetX+this.left+((W-this.xAxisMin)*this.xAxisUnit);I=K;g=this.marginTop+this.offsetY+this.top;e=g+this.y;av=K<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(av&&aA){if(this.layoutValid){av=false;var X=this.toArray(this.data.l.name[this.layoutCurrent]);for(var ah=0;ah<X.length;ah++){if(aA==X[ah]){av=true}}}}if(av){var Q=this.isR?6:3;if(o){if(this.graphOrientation=="vertical"){if(aR=="right"){this.toRender({p:["drawText",o,I-this.margin,e-this.margin,this.decorationFont,this.decorationColor,"right","bottom"],t:"Decorations"})}else{if(aR=="center"){this.toRender({p:["drawText",o,K+(this.x/2),e-this.margin,this.decorationFont,this.decorationColor,"center","bottom"],t:"Decorations"})}else{this.toRender({p:["drawText",o,K+this.margin,e-this.margin,this.decorationFont,this.decorationColor,"left","bottom"],t:"Decorations"})}}}else{if(aR=="right"){this.toRender({p:["drawText",o,I+(this.margin*2),e-(this.margin*Q),this.decorationFont,this.decorationColor,"left","middle"],t:"Decorations"})}else{if(aR=="center"){this.toRender({p:["drawText",o,I+(this.margin*2),g+(this.y/2),this.decorationFont,this.decorationColor,"left","middle"],t:"Decorations"})}else{this.toRender({p:["drawText",o,I+(this.margin*2),g+(this.margin*Q),this.decorationFont,this.decorationColor,"left","middle"],t:"Decorations"})}}}}var at=am.line[ai].tooltip||("&rarr; "+W);this.toRender({p:["drawLine",aq,K,g,I,e,C,aG],a:this.getLineArea(aq,K,g,I,e,C,aG),i:[at+":Decor-Line"+ai],t:"Decorations"})}}}if(am.marker){this.drawMarkers()}}}this.toRender({p:["resetClipArea"],t:"Decorations"})};this.drawOncoprintLegend=function(){if(this.isOncoprint){var b=(this.width/2)-(this.legendOncoprintWidth/2);var p=this.height-(this.marginBottom+this.legendOncoprintHeight-this.margin);var a=0;var o=this.legendOncoprintWidth/this.legendOncoprintCols;var k=2;this.toRender({p:["drawShape","rect",this.width/2,p+(this.legendOncoprintHeight/2)-this.margin,this.legendOncoprintWidth,this.legendOncoprintHeight,this.background,this.background],a:this.getShapeArea("rect",this.width/2,p+(this.legendOncoprintHeight/2)-this.margin,this.legendOncoprintWidth,this.legendOncoprintHeight,this.background,this.background),i:[-1],m:["-legend-oncoprint"],t:"Legends"});for(var g=0;g<this.legendOncoprintRows;g++){var d=b;for(var e=0;e<this.legendOncoprintCols;e++){if(a<this.legendOncoprintLabels.length){var h=this.legendOncoprintLabels[a];var m=this.legendOncoprintObjects[a];if(a<this.legendOncoprintMutations){this.toRender({p:["drawShape","rect",d+2.5,p+10.5,5,21,this.legendOncoprintColors[h]],a:this.getShapeArea("rect",d+2.5,p+10.5,5,21,this.legendOncoprintColors[h]),i:["Onc-"+h+"-"+m],t:"Legends"});d+=5+this.margin;this.toRender({p:["drawText",h,d,p+10.5+k,this.legendFont,this.legendColor,"left","middle"],t:"Legends"});d+=o}else{this.toRender({p:["drawShape","rect",d+2.5,p+10.5,5,21,"rgb(220,220,220"],a:this.getShapeArea("rect",d+2.5,p+10.5,5,21,"rgb(220,220,220"),i:["Onc-"+h+"-"+m],t:"Legends"});this.toRender({p:["drawShape","rect",d+2.5,p+10.5,5,7,this.legendOncoprintColors[h]],a:this.getShapeArea("rect",d+2.5,p+10.5,5,7,this.legendOncoprintColors[h]),i:["Onc-"+h+"-"+m],t:"Legends"});d+=5+this.margin;this.toRender({p:["drawText",h,d,p+10.5+k,this.legendFont,this.legendColor,"left","middle"],t:"Legends"});d+=o}a++}}p+=21+this.margin}}};this.drawSampleLegend=function(z,d){var f=this;var c=function(i,j){if(f.isCreateHistogram){if(f.isCreateHistogram.colors.length<f.legendSamplesN&&f.isCreateHistogram.factor){if(f.cacheColors[f.colorScheme].hasOwnProperty(j)){return f.cacheColors[f.colorScheme][j]}else{return k[f.isCreateHistogram.factor].colors?k[f.isCreateHistogram.factor].colors[i]:f.colors[i%f.colors.length]}}else{if(f.isCreateHistogram.colors.length==f.legendSamplesN){if(f.densityPosition=="filled"&&f.graphType=="Scatter2D"){return f.isCreateHistogram.colors[f.legendSamplesN-(1+i)]}else{return f.isCreateHistogram.colors[i]}}else{return f.cacheColors[f.colorScheme].hasOwnProperty(j)?f.cacheColors[f.colorScheme][j]:f.colors[i%f.colors.length]}}}else{return f.colors[i%f.colors.length]}};var v=function(j){if(f.isCreateHistogram){if(!f.xAxisIndices.length&&!f.yAxisIndices.length){var i;if(f.isHistogramLayout()){i=f.getSampleIndices(b[j]);if(i<0){i=j+1}}else{i=f.getSampleIndices(f.data.l.axes[0].yAxis[j])}return"Series:0:"+i}else{if(f.data.l&&f.data.l.axes&&f.data.l.axes[u]&&f.data.l.axes[u].yAxis&&f.data.l.axes[u].yAxis[s]&&!f.data.l.axes[u].yAxis[s].match(":")){return"Series:0:"+f.data.l.ids[j+1]}else{return f.xAxisIndices.length==f.yAxisIndices.length?"Series:"+f.xAxisIndices[j]+":"+f.yAxisIndices[j]:f.xAxisIndices.length>f.yAxisIndices.length?"Series:"+f.xAxisIndices[j]+":0":"Series:0:"+f.yAxisIndices[j]}}}else{return f.xAxisIndices.length==f.yAxisIndices.length?"Series:"+f.xAxisIndices[j]+":"+f.yAxisIndices[j]:f.xAxisIndices.length>f.yAxisIndices.length?"Series:"+f.xAxisIndices[j]+":0":"Series:0:"+f.yAxisIndices[j]}};var p=z;var A=d;var t=0;var o=this.getFontPt(this.legendFont);var r=(o-1)/2;d+=this.margin+r;this.drawLegendBackgroundBox(p,A,this.legendSampleWidth,this.legendSampleHeight,true,"-legend-sample");var y=this.legendSampleWidth/this.legendColumns;var a=Math.ceil(this.legendSamplesN/this.legendColumns);var k=f.meta.data.z;var b=[];var x={};if(this.ridgeBy){for(var u=0;u<a;u++){for(var s=0;s<this.legendColumns;s++){z=p+((this.margin+y)*s);if(t<this.legendSamplesN){var m=this.shortenText(this.dataStndBy.y.smps[t],this.maxSmpStringLen);var e=this.colors[t%this.colors.length];var B="Series:0:"+t;var g=z+r+this.margin;this.toRender({p:["drawShape","circle",g,d,o-1,o-1,this.getFillColor(e),this.getOutlineColor(e),"solid"],a:this.getShapeArea("circle",g,d,o-1,o-1,this.getFillColor(e),this.getOutlineColor(e),"solid"),i:[B],t:"Legends",h:this.isHidden(false,false,B)});this.toRender({p:["drawText",m,g+r+this.margin,d,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(m,g+r+this.margin,d,this.legendFont,this.legendColor,"left","middle"),i:[B],t:"Legends",h:this.isHidden(false,false,B)});t++}}d+=o+this.margin}}else{if(this.isHistogram&&this.isHistogramLayout()){for(var u=0;u<this.data.l.axes.length;u++){for(var s=0;s<this.data.l.axes[u].yAxis.length;s++){if(this.data.l.axes[u].yAxis[s]){if(this.segregateVariablesBy.length||!this.data.l.axes[u].yAxis[s].match(":")){x[this.data.l.axes[u].yAxis[s].split(":")[0]]=true}else{if(this.data.l.axes.length==this.dataStndBy.y.smps.length){x[this.data.l.axes[u].yAxis[s].split(":")[1]]=true}else{x[this.data.l.axes[u].yAxis[s]]=true}}}}}b=this.getKeys(x)}}if(!this.ridgeBy){for(var u=0;u<a;u++){for(var s=0;s<this.legendColumns;s++){z=p+((this.margin+y)*s);if(t<this.legendSamplesN){var q=0;var h=this.getPropertyValue(u,false,"patternBy");var l=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[t]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[this.yAxisCurrent]:this.yAxis[t];var n=this.xAxisIndices.length==this.yAxisIndices.length?this.xAxis[t]:this.xAxisIndices.length>this.yAxisIndices.length?this.xAxis[t]:this.xAxis[this.xAxisCurrent];var B=v(t);var m=this.isHistogramLayout()?b[t]:this.isHistogram?this.shortenText(l,this.maxSmpStringLen):this.shortenText(l,this.maxSmpStringLen)+" vs "+this.shortenText(n,this.maxSmpStringLen);var e=c(t,m);var g=z+r+this.margin;var w=d+r+this.margin;if(this.isCreateHistogram){this.toRender({p:["drawShape",this.shapes[q],g,d,o-1,o-1,this.getFillColor(e),this.getOutlineColor(e),h],a:this.getShapeArea(this.shapes[q],g,d,o-1,o-1,this.getFillColor(e),this.getOutlineColor(e),h),i:[B],t:"Legends",h:this.isHidden(false,false,B)})}else{if(this.colorBy){this.toRender({p:["drawShape",this.shapes[q],g,d,o-1,o-1,false,this.getFillColor(e),"open"],a:this.getShapeArea(this.shapes[q],g,d,o-1,o-1,false,this.getFillColor(e),"open"),i:[B],t:"Legends",h:this.isHidden(false,false,B)})}else{this.toRender({p:["drawShape",this.shapes[q],g,d,o-1,o-1,this.getFillColor(e),this.getOutlineColor(e),h],a:this.getShapeArea(this.shapes[q],g,d,o-1,o-1,this.getFillColor(e),this.getOutlineColor(e),h),i:[B],t:"Legends",h:this.isHidden(false,false,B)})}}this.toRender({p:["drawText",m,g+r+this.margin,d,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(m,g+r+this.margin,d,this.legendFont,this.legendColor,"left","middle"),i:[B],t:"Legends",h:this.isHidden(false,false,B)})}else{break}t++}d+=o+this.margin}}this.drawLegendBackgroundBox(p,A,this.legendSampleWidth,this.legendSampleHeight)};this.drawVariableLegend=function(p,a){var D=p;var t=a;var k=this.getFontPt(this.legendFont);var f=k/2;var M=k*2;var e=k*1.5;var u=0;var C=this;var L=this.layoutValid&&!this.isDOE&&this.isOneDimensionalGraph()&&this.meta.config.user.graphType!=this.graphType?this.meta.config.user.graphType:this.graphType;var F=function(g){if(g<C.xAxisVarIndices.length){return C.colors[g%C.colors.length]}else{return C.colors[(g-C.xAxisVarIndices.length)%C.colors.length]}};if(this.legendVariableWidth==0||this.legendVariableHeight==0){return}else{if(L=="Circular"&&this.circularType=="sunburst"){return}else{if(L=="Pie"){var n=!this.layoutComb?this.width-(p+(this.margin*1.5)):this.isDOE?this.layoutWidth-((p-this.offsetX)+(this.margin*1.5)):999999;if(this.isDOE&&this.legendVariableWidth>n){this.legendVariableWidth=n}this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");p+=f+(this.margin*2);a+=k;for(var J=0;J<this.varPie.ids.length;J++){var I=false;var z=this.varPie.ids[J];var l=this.varPie.cols[J];var G=z>-1?this.shortenText(this.data.y.vars[z],this.maxVarStringLen):"Other";this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"square",p,a,k,k,this.getFillColor(l),this.getOutlineColor(l),"closed"],a:this.getShapeArea(this.useRoundRectangles?"roundrect":"square",p,a,k,k,this.getFillColor(l),this.getOutlineColor(l),"closed"),i:["PieVar-"+z],t:"Legends",h:this.isHidden(false,false,"Var-"+z)});if(n>0){while((this.measureText(G,this.legendFont)+k+(this.margin*3))>n&&G.length>1){G=G.substring(0,G.length-1);I=true}if(I){G=G+"..."}this.toRender({p:["drawText",G,p+k,a,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(G,p+k,a,this.legendFont,this.legendColor,"left","middle"),i:["PieVar-"+z],t:"Legends",h:this.isHidden(false,false,"Var-"+z)})}a+=k+this.margin;if(this.layoutComb){if((a-this.offsetY)>this.layoutHeight){this.toRender({p:["drawText","...",p+k,a,this.legendFont,this.legendColor,"left","bottom"],t:"Legends"});break}}else{if(a>this.height){this.toRender({p:["drawText","...",p+k,a,this.legendFont,this.legendColor,"left","bottom"],t:"Legends"});break}}}this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight)}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var x=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],k):k;var b=x/2;var o=this.legendVariableWidth/this.legendColumns;var w=Math.ceil(this.varIndices.length/this.legendColumns);a+=(this.margin*3);for(var J=0;J<w;J++){for(var H=0;H<this.legendColumns;H++){p=D+(this.margin+(o*H));if(u<this.varIndices.length){var z=this.varIndices[u];var l=L=="Circular"||(this.colorBy&&this.colorBy=="variable")?u%this.colors.length:0;var y=this.shapeBy&&this.shapeBy=="variable"?u%this.shapes.length:0;var d=this.sizeBy&&this.sizeBy=="variable"?this.sizes[u%this.sizes.length]:x;var h=this.patternBy&&this.patternBy=="variable"?this.patterns[u%this.patterns.length]:this.getPropertyValue(z,false,"patternBy");var B=p+b;var q=a+b;var G=this.shortenText(this.data.y.vars[z],this.maxVarStringLen);var A=this.isHidden(false,false,"Var-"+z);if(this.colorBy&&this.colorBy!="variable"){this.toRender({p:["drawShape",this.shapes[y],B,a,d,d,this.background,this.foreground,h],a:this.getShapeArea(this.shapes[y],B,a,d,d,this.background,this.foreground,h),i:["Var-"+z],t:"Legends",h:A})}else{this.toRender({p:["drawShape",this.shapes[y],B,a,d,d,this.getFillColor(this.colors[l]),this.getOutlineColor(this.colors[l]),h],a:this.getShapeArea(this.shapes[y],B,a,d,d,this.getFillColor(this.colors[l]),this.getOutlineColor(this.colors[l]),h),i:["Var-"+z],t:"Legends",h:A})}this.toRender({p:["drawText",G,B+b+this.margin,a,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(G,B+b+this.margin,a,this.legendFont,this.legendColor,"left","middle"),i:["Var-"+z],t:"Legends",h:A})}else{break}u++}a+=x+this.margin}this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight)}else{if(L=="BarLine"||L=="DotLine"||L=="AreaLine"||L=="StackedLine"||L=="StackedPercentLine"){this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var c=this.xAxisVarIndices.concat(this.xAxis2VarIndices);var o=this.legendVariableWidth/this.legendColumns;var w=Math.ceil(c.length/this.legendColumns);a+=(this.margin*2);for(var J=0;J<w;J++){for(var H=0;H<this.legendColumns;H++){p=D+this.margin+(o*H);if(u<c.length){var z=u<this.xAxisVarIndices.length?this.xAxisVarIndices[u]:this.xAxis2VarIndices[u-this.xAxisVarIndices.length];var l=this.theme=="blackAndWhite"?"rgb(0,0,0)":this.coordinateLineColor?F(u):this.getVariableColor(this.data.y.vars[z]);var h=this.getPropertyValue(z,false,"patternBy");var G=this.shortenText(this.data.y.vars[z],this.maxVarStringLen);var A=this.isHidden(false,false,"Var-"+z);if(u<this.xAxisVarIndices.length){var s=L=="DotLine"?"circle":this.useRoundRectangles?"roundrect":"rectangle";var K;if(this.lineDecoration=="pattern"){K=this.toRender({p:["drawShape",s,p+(k/2),a+(k/2),k,k,"rgba(0,0,0,0)","rgba(0,0,0,0)",h],a:this.getShapeArea(s,p+(k/2),a+(k/2),k,k,"rgba(0,0,0,0)","rgba(0,0,0,0)",h),i:["Var-"+z],t:"Legends",h:A})}else{K=this.toRender({p:["drawShape",s,p+(k/2),a+(k/2),k,k,this.getFillColor(l),this.getOutlineColor(l),h],a:this.getShapeArea(s,p+(k/2),a+(k/2),k,k,this.getFillColor(l),this.getOutlineColor(l),h),i:["Var-"+z],t:"Legends",h:A})}this.toRender({p:["drawText",G,p+M,a+f,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(G,p+M,a+f,this.legendFont,this.legendColor,"left","middle"),i:["Var-"+z],g:K,t:"Legends",h:A})}else{var r=this.lineDecoration=="pattern"?this.linePatterns[u%this.linePatterns.length]:"line";var K=this.toRender({p:["drawLine",r,p,a+f,p+k,a+f,l,2],a:this.getLineArea("line",p,a+f,p+k,a+f,l,2),i:["Var-"+z],t:"Legends",h:A});if(this.lineDecoration&&this.lineDecoration!="pattern"&&!this.segregateVariablesBy.length&&L!="DotLine"&&L!="AreaLine"){this.toRender({p:["drawShape",this.lineDecoration=="symbol"?this.shapes[(u-this.xAxisVarIndices.length)%this.shapes.length]:"circle",p+f,a+f,f,f,l,this.foreground,h],a:this.getShapeArea(this.lineDecoration=="symbol"?this.shapes[(u-this.xAxisVarIndices.length)%this.shapes.length]:"circle",p+f,a+f,f,f,l,this.foreground,h),i:["Var-"+z],g:K,t:"Legends",h:A})}this.toRender({p:["drawText",G,p+M,a+f,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(G,p+M,a+f,this.legendFont,this.legendColor,"left","middle"),i:["Var-"+z],g:K,t:"Legends",h:A})}}else{break}u++}a+=e}this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight)}else{if(L=="Bar"||L=="Line"||L=="ParallelCoordinates"||L=="Area"||L=="Dotplot"||L=="Stacked"||L=="StackedPercent"||L=="Boxplot"||L=="Fish"){this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var o=this.legendVariableWidth/Math.min(this.varIndices.length,this.legendColumns);var w=Math.ceil(this.varIndices.length/Math.min(this.varIndices.length,this.legendColumns));a+=(this.margin*2);for(var J=0;J<w;J++){for(var H=0;H<Math.min(this.varIndices.length,this.legendColumns);H++){p=D+this.margin+(o*H);if(u<this.varIndices.length){var z=this.varIndices[u];var l=this.theme=="blackAndWhite"&&L=="Line"?"rgb(0,0,0)":this.getFillColor(this.getVariableColor(this.data.y.vars[z]));var E=this.getOutlineColor(l);var h=this.getPropertyValue(z,false,"patternBy");var G=this.shortenText(this.data.y.vars[z],this.maxVarStringLen);var A=this.isHidden(false,false,"Var-"+z);var K=null;if(L=="Line"||L=="ParallelCoordinates"){var r=this.lineDecoration=="pattern"?this.linePatterns[u%this.linePatterns.length]:this.lineType;K=this.toRender({p:["drawLine",r,p,a+f,p+k,a+f,l,2],a:this.getLineArea("line",p,a+f,p+k,a+f,l,2),i:["Var-"+z],g:K,t:"Legends",h:A});if(this.lineDecoration&&this.lineDecoration!="pattern"&&!this.segregateVariablesBy.length){this.toRender({p:["drawShape",this.lineDecoration=="symbol"?this.shapes[u%this.shapes.length]:"circle",p+f,a+f,f,f,l,E,h],a:this.getShapeArea(this.lineDecoration=="symbol"?this.shapes[u%this.shapes.length]:"circle",p+f,a+f,f,f,l,E,h),i:["Var-"+z],g:K,t:"Legends",h:A})}}else{if(L=="Dotplot"||(L=="Boxplot"&&this.showBoxplotOriginalData)){if(this.shapeBy){K=this.toRender({p:["drawShape",this.shapes[u%this.shapes.length],p+f,a+f,k,k,l,E,h],a:this.getShapeArea(this.shapes[u%this.shapes.length],p+f,a+f,k,k,l,E,h),i:["Var-"+z],g:K,t:"Legends",h:A})}else{K=this.toRender({p:["drawShape","circle",p+f,a+f,k,k,l,E,h],a:this.getShapeArea("circle",p+f,a+f,k,k,l,E,h),i:["Var-"+z],g:K,t:"Legends",h:A})}}else{K=this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",p+(k/2),a+(k/2),k,k,l,E,h],a:this.getShapeArea(this.useRoundRectangles?"roundrect":"rectangle",p+(k/2),a+(k/2),k,k,l,E,h),i:["Var-"+z],g:K,t:"Legends",h:A});if(L=="Boxplot"&&(!this.showBoxplotOriginalData||this.boxplotColor)){this.toRender({p:["drawLine","line",p,a+(k/2),p+k,a+(k/2),this.foreground],t:"Legends",g:K,h:A});this.toRender({p:["drawLine","line",p+(k/2),a,p+(k/2),a-this.margin,this.foreground],t:"Legends",g:K,h:A});this.toRender({p:["drawLine","line",p+(k/2),a+k,p+(k/2),a+k+this.margin,this.foreground],t:"Legends",g:K,h:A})}}}this.toRender({p:["drawText",G,p+M,a+f,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(G,p+M,a+f,this.legendFont,this.legendColor,"left","middle"),i:["Var-"+z],g:K,t:"Legends",h:A})}else{break}u++}a+=e}this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight)}else{if(L=="Circular"&&!this.showIdeogram){var m=this.r/2.7;if(this.legendVariableWidth>m||this.legendVariableHeight>m){}this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var v=[];if(this.rAxisIndex>=0){for(var J=0;J<this.varIndices.length;J++){if(J==this.rAxisIndex){continue}v.push(this.varIndices[J])}}else{v=this.varIndices}var o=this.legendVariableWidth/this.legendColumns;var w=Math.ceil(v.length/this.legendColumns);a+=(this.margin*2);for(var J=0;J<w;J++){for(var H=0;H<this.legendColumns;H++){p=D+this.margin+(o*H);if(u<v.length){var z=v[u];var l=this.colors[u%this.colors.length];var h=this.getPropertyValue(z,false,"patternBy");var G=this.shortenText(this.data.y.vars[z],this.maxVarStringLen);this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",p+(k/2),a+(k/2),k,k,this.getFillColor(l),this.getOutlineColor(l),h],a:this.getShapeArea(this.useRoundRectangles?"roundrect":"rectangle",p+(k/2),a+(k/2),k,k,this.getFillColor(l),this.getOutlineColor(l),h),i:["Var-"+z],t:"Legends",h:this.isHidden(false,false,"Var-"+z)});this.toRender({p:["drawText",G,p+M,a+f,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(G,p+M,a+f,this.legendFont,this.legendColor,"left","middle"),i:["VarLbl-"+z],t:"Legends",h:this.isHidden(false,false,"VarLbl-"+z)})}else{break}u++}a+=e}this.drawLegendBackgroundBox(D,t,this.legendVariableWidth,this.legendVariableHeight)}}}}}}}};this.drawVennLegend=function(){if(this.showLegend){var j=this.getFontPt(this.legendFont);var d=this.vennMarginLeft+this.marginLeft+this.left;var c=d+(j*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(j/2);var h=[];var a=[];for(var f in this.data.venn.legend){a.push(f)}a=a.sort();if(this.vennGroups==4){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,153,51)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[3]):"rgb(153,204,0)");h.push(this.vennColors.length>3&&this.validateColor(this.vennColors[3])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==3){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,255,0)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==2){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(0,0,255)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(255,0,0)")}else{h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)")}}}for(var f=0;f<this.vennGroups;f++){if(!this.vennLegendColors){this.toRender({p:["drawText",a[f]+": ",d,g,this.legendFont,this.legendColor,"left","middle"],t:"Legends"})}var b=this.data.venn.legend&&this.data.venn.legend[a[f]]?this.data.venn.legend[a[f]]:"N/A";var e=(this.measureText(b,this.legendFont)>this.x)?this.scaleTextToFont(b,j,this.x-this.margin):this.legendFont;if(!this.vennLegendColors){this.toRender({p:["drawText",b,c,g,e,this.legendColor,"left","middle"],t:"Legends"})}else{this.toRender({p:["drawText",b,d,g,e,h[f],"left","middle"],t:"Legends"})}g+=this.margin+j}}};this.drawColorIndicator=function(A,d,o,G,D,f){if(f||D||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||this.colorNodeBy||this.colorEdgeBy||this.graphType=="Genome"||(this.isContour==true&&this.contourFilled)||(this.graphType=="Network"&&this.decorations.length&&this.decorationsType=="heatmap"&&this.showDecorations&&!this.colorNodeBy&&!this.colorEdgeBy)){var l=this;var h=function(H){if(o.decs>3){o.decs=l.getAxisDecimals(H[1]-H[0])}var j=[];for(var c=0;c<H.length;c++){j[c]=H[c].toFixed(o.decs)}return j};var r=G||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy;var n=f?"-legend-"+f+"-color":D?"-legend-indicator-color":"-legend-color";var g=f?"overlaysLegendPosition":D?"heatmapIndicatorPosition":"legendPosition";var F=f?f:D?0:this.legendColorWidth?this.legendColorWidth/2:10;var s=A;var E=d;var a=0;var z=this.heatmapIndicatorHeight;var b=this.heatmapIndicatorHeight;var u=o.min;var x=o.max;var q=this.graphType=="Genome"?o.values:o.vals;var e=o.valStr?o.valStr:o.colorBrew&&o.colorBrew.valStr?o.colorBrew.valStr:h(q);var p=this.heatmapIndicatorWidth/(x-u);var C=this.graphType=="Circular"||(this.isContour&&!o.colorBrew)?o:o.colorBrew?o.colorBrew:this.meta.def.colorBrew;var m=this.heatmapIndicatorWidth/this.colorSpectrumNumber;var t=g=="overlaysLegendPosition"&&this[g]=="topRight"?true:false;if(this[g]&&this[g].toString().match(/top|bottom/)&&!t){if(r){if(this.showLegendTitle){this.toRender({p:["drawText",r,A+(this.heatmapIndicatorWidth/2),d,this.legendFont,this.legendColor,"center","top"],t:"Legends"})}a=this.margin+this.getFontPt(this.legendFont);d+=a}for(var w=0;w<this.colorSpectrumNumber;w++){var B=this.transparency!=null?this.addColorTransparency(C.colors[w],this.transparency,true):C.colors[w];this.toRender({p:["drawLine","line",A,d,A,d+b,B,Math.round(m+1.5)],t:"Legends"});A+=m}A=s;d+=b+this.margin;if(C&&C.stops&&C.stops.length){var y=0;for(var w=0;w<C.stops.length;w++){for(var v=0;v<this.colorSpectrumNumber;v++){if(C.breaks[v]>=C.stops[w]){A=s+(v*m);var k=(this.measureText(this.formatNumber(C.stops[w].toString()),this.legendFont)/2);if(A-k>y||w==0||w==C.stops.length-1){this.toRender({p:["drawText",this.formatNumber(C.stops[w]),A,d,this.legendFont,this.legendColor,"center","top"],t:"Legends"});y=A+k}break}}}}else{for(var w=0;w<q.length;w++){A=s+((q[w]-u)*p);this.toRender({p:["drawText",e[w],A,d,this.legendFont,this.legendColor,"center","top"],t:"Legends"})}}if(this.graphType=="Heatmap"&&this.heatmapIndicatorHistogram){this.drawHeatmapIndicatorHistogram(s,E+a)}}else{if(r){if(this.showLegendTitle){this.toRender({p:["drawText",r,A+F+this.margin,d,this.legendFont,this.legendColor,"center","top"],t:"Legends"})}d+=(this.margin*1.5)+this.getFontPt(this.legendFont)}d+=(this.colorSpectrumNumber*m)-m;for(var w=0;w<this.colorSpectrumNumber;w++){var B=this.transparency!=null?this.addColorTransparency(C.colors[w],this.transparency,true):C.colors[w];this.toRender({p:["drawLine","line",A,d,A+z,d,B,Math.round(m+1.5)],t:"Legends"});d-=m}A+=z;if(r){d=E+(this.margin*1.5)+this.getFontPt(this.legendFont)}else{d=E}if(C&&C.stops&&C.stops.length){d+=this.colorSpectrumNumber*m;var y=d;for(var w=0;w<C.stops.length;w++){for(var v=0;v<this.colorSpectrumNumber;v++){if(C.breaks[v]>=C.stops[w]){b=d-(v*m);if(b+this.legendFontSize<y||w==0||w==C.stops.length-1){this.toRender({p:["drawText",this.formatNumber(C.stops[w]),A+this.margin,b,this.legendFont,this.legendColor,"left","middle"],t:"Legends"});y=b}break}}}}else{d+=this.colorSpectrumNumber*m;for(var w=0;w<q.length;w++){var b=d-((q[w]-u)*p);this.toRender({p:["drawText",e[w],A+this.margin,b,this.legendFont,this.legendColor,"left","middle"],t:"Legends"})}}}}};this.drawHeatmapIndicatorHistogram=function(x,b){var w,a;var o=x;var z=b+this.heatmapIndicatorHeight;var y=[];for(var u=0;u<this.data.y.vars.length;u++){for(var s=0;s<this.data.y.smps.length;s++){var g=this.getDataAtPos(u,s,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue);if(g!=null&&g!==""&&!isNaN(g)){y.push(g)}}}var k=this.range(y);var r=k[0];var t=k[1];var q=this[this.histogramSizeEstimator](y);var m=Math.ceil((t-r)/q);if(q>1000){m*=q/1000;q=1000}var e=[];for(var u=0;u<q;u++){e[u]=0}for(var u=0;u<this.data.y.vars.length;u++){for(var s=0;s<this.data.y.smps.length;s++){var g=this.getDataAtPos(u,s,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue);if(g!=null&&g!==""&&!isNaN(g)){var n=parseInt((g-r)/m);e[n]++}}}r=0;t=0;for(var u=0;u<q;u++){r=Math.min(r,e[u]);t=Math.max(t,e[u])}var l=this.legendFont;var h=this[this.axisAlgorithm](r,t,3,this.axisWilkinsonLoose);var p=this.getMaxText(h);var f=(this.heatmapIndicatorWidth-1)/q;var c=this.heatmapIndicatorHeight/h[h.length-1];if(this.heatmapIndicatorPosition=="topLeft"){l=this.scaleTextToFont(p,this.getFontPt(this.legendFont),this.left-(this.heatmapIndicatorWidth+(this.margin*3)))}for(var u=0;u<h.length;u++){b=(h[u]*c);this.toRender({p:["drawLine","line",o-this.margin,z-b,o,z-b,this.foreground],t:"Legends"});this.toRender({p:["drawText",this.formatNumber(h[u]),o-(this.margin*1.5),z-b,l,this.legendColor,"right","middle"],t:"Legends"})}b=(e[0]*c);this.toRender({p:["drawLine","line",o,z,o,z-b,this.heatmapIndicatorHistogramColor],t:"Legends"});for(var u=0;u<q;u++){b=(e[u]*c);this.toRender({p:["drawLine","line",o,z-b,o+f,z-b,this.heatmapIndicatorHistogramColor],t:"Legends"});if(u<q-1){a=(e[u+1]*c);this.toRender({p:["drawLine","line",o+f,z-b,o+f,z-a,this.heatmapIndicatorHistogramColor],t:"Legends"})}o+=f}this.toRender({p:["drawLine","line",o,z-a,o,z,this.heatmapIndicatorHistogramColor],t:"Legends"})};this.isDrawPropertyLegend=function(a){if(a){if(this.graphType=="Network"){return(this[a+"By"]&&this.meta.data.edges[this[a+"By"]])||(this[a+"By"]&&this.meta.data.nodes[this[a+"By"]])}else{return(this[a+"By"]&&this.isMultidimensionalData)||(this[a+"By"]&&((this.data.x&&this.data.x.hasOwnProperty(this[a+"By"]))||(this.data.z&&this.data.z.hasOwnProperty(this[a+"By"]))||this.getSampleIndices(this[a+"By"])>-1))}}else{if(this.graphType=="Network"){return(this.colorEdgeBy&&this.meta.data.edges[this.colorEdgeBy])||(this.colorNodeBy&&this.meta.data.nodes[this.colorNodeBy])||(this.decorations.length&&this.decorationsType=="heatmap")}else{return(this.outlineBy&&this.isMultidimensionalData)||(this.isContour==true&&this.contourFilled)||(this.colorBy&&((this.data.x&&this.data.x.hasOwnProperty(this.colorBy))||(this.data.z&&this.data.z.hasOwnProperty(this.colorBy))||this.getSampleIndices(this.colorBy)>-1||(this.colorBy=="data"&&this.ridgeBy)))}}};this.drawColorLegend=function(a,b,d,c){if(this.graphType=="Map"){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);b+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}if(this.isDrawPropertyLegend()){if((d.type=="Numeric"&&!d.colorBy)||(this.isContour==true&&this.contourFilled)){this.drawColorIndicator(a,b,(this.isTransformedData&&this.graphType!="Heatmap")?this.getDefaultMetaDataObject():this.isContour?this.meta.data.q.o:d)}else{this.drawPropertyLegend(c,a,b,d)}}};this.drawShapeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawSizeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPatternLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawConnectLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPropertyLegend=function(f,G,h,u){var n=this;var v=function(){if(n.graphType=="Boxplot"){if(!n.showBoxplotOriginalData&&!n.boxplotColor){return n.useRoundRectangles?"roundrect":"rectangle"}else{return"circle"}}else{return"circle"}};var x=this.decapitalize(f);if(this.isDrawPropertyLegend(x)){var H=f.replace("Node","").replace("Edge","")=="Size"?0:this.getDiameterLegend();if(f.replace("Node","").replace("Edge","")=="Size"){for(var E=0;E<(this.legendSizesN||u.levels.length);E++){H=Math.max(H,u.sizes?u.sizes[E]:this.sizes[E])}}var z=this.getFontPt(this.legendFont);var j=z/2;var b=this.legendColumns>this["legend"+f+"sN"]?this["legend"+f+"sN"]:this.legendColumns;var e=Math.ceil(this["legend"+f+"sN"]/b);var o=this["legend"+f+"Width"]/b;var t="legend"+f+"Meta";var g=h+(this.margin*2)+j;var D=Math.max(H,z);var l=v();var B=0;this.drawLegendBackgroundBox(G,h,this["legend"+f+"Width"],this["legend"+f+"Height"],true,"-legend-"+x);var K=f.replace("Node","").replace("Edge","")=="Color"&&this.outlineBy?this.outlineBy:this[x+"By"];if(this.showLegendTitle){this.toRender({p:["drawText",K,G+(this["legend"+f+"Width"]/2),g,this.legendFont,this.legendColor,"center","middle"],t:"Legends"});g+=j+this.margin;this.disableGradientTransparencyShadow();if(this.legendBox){this.toRender({p:["drawLine","line",G,g,G+this["legend"+f+"Width"],g,this.legendBoxColor],t:"Legends"})}this.enableGradientTransparencyShadow();g+=this.margin+(D/2)}var a=this["legend"+f+"sS"]||this.sortObject(this["legend"+f+"s"]);var J=u.origin?u.origin:this.meta.data.modified?"modified":this.isOncoprint||this.isMultidimensionalData?this[x+"ByData"]:"y";for(var w=0;w<e;w++){for(var I=0;I<b;I++){var q=G+this.margin+H/2+(o*I);if(B<this["legend"+f+"sN"]&&B>=0){var A=a[B];var m=this.isHidden(false,false,"Property:"+K+":"+A+":"+J);if(f.replace("Node","").replace("Edge","")=="Color"){var k=u.colorBy&&u.colorBy.hasOwnProperty(A)?this.validateColor(u.colorBy[A]):this.legendColors?this.validateColor(this.legendColors[A]):this.validateColor(u.colors[B]);if(this.graphType=="Boxplot"&&this.showViolinBoxplot){k=this.addColorTransparency(k,this.violinTransparency,true)}if(this.outlineBy){this.toRender({p:["drawShape",l,q,g,H,H,false,this.getFillColor(k),"open",false,2],a:this.getShapeArea(l,q,g,H,H,false,this.getFillColor(k),"open",false,2),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}else{this.toRender({p:["drawShape",l,q,g,H,H,this.getFillColor(k),this.getOutlineColor(k),"closed"],a:this.getShapeArea(l,q,g,H,H,this.getFillColor(k),this.getOutlineColor(k),"closed"),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}}else{if(f.replace("Node","").replace("Edge","")=="Shape"){var y=u.shapeBy&&u.shapeBy.hasOwnProperty(A)?u.shapeBy[A]:this.legendShapes?this.legendShapes[A]:u.shapes[B];this.toRender({p:["drawShape",y,q,g,H,H,this.background,this.foreground,"closed"],a:this.getShapeArea(y,q,g,H,H,this.background,this.foreground,"closed"),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}else{if(f.replace("Node","").replace("Edge","")=="Size"){var C=u.sizeBy&&u.sizeBy.hasOwnProperty(A)?u.sizeBy[A]:this.legendSizes?this.legendSizes[A]:u.sizes[B];if(u.rmax==u.max&&u.rmin==u.min){this.toRender({p:["drawShape",l,q,g,C,C,this.background,this.foreground,"closed"],a:this.getShapeArea(l,q,g,C,C,this.background,this.foreground,"closed"),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}else{this.toRender({p:["drawShape",l,q,g,C,C,this.background,this.foreground,"closed"],t:"Legends",h:m})}}else{if(f.replace("Node","").replace("Edge","")=="Pattern"){var s=u.patternBy&&u.patternBy.hasOwnProperty(A)?u.patternBy[A]:this.legendPatterns?this.legendPatterns[A]:u.patterns[B];this.toRender({p:["drawShape",this.useRoundRectangles?"roundrect":"square",q,g,H,H,this.background,this.foreground,s],a:this.getShapeArea(this.useRoundRectangles?"roundrect":"square",q,g,H,H,this.background,this.foreground,s),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}else{if(f=="Connect"){var k=u.connectBy&&u.connectBy.hasOwnProperty(A)?u.connectBy[A]:this.legendConnects?this.legendConnects[A]:u.connects[B];this.toRender({p:["drawLine","line",q-(H/2),g,q+(H/2),g,k,this.connectByWidth],t:"Legends",h:m})}}}}}if(this.graphType=="Boxplot"&&f!="Connect"&&(!this.showBoxplotOriginalData||this.boxplotColor)){var k=u.connectBy&&u.connectBy.hasOwnProperty(A)?u.connectBy[A]:this.legendConnects?this.legendConnects[A]:u.connects[B];this.toRender({p:["drawLine","line",q-(H/2),g,q+(H/2),g,this.getOutlineColor(k)],t:"Legends",h:m});this.toRender({p:["drawLine","line",q,g-(H/2),q,g-((H/2)+this.margin),this.getOutlineColor(k)],t:"Legends",h:m});this.toRender({p:["drawLine","line",q,g+(H/2),q,g+((H/2)+this.margin),this.getOutlineColor(k)],t:"Legends",h:m})}if(u.type=="Numeric"&&((f=="Shape"&&!this.shapeByContinuous)||(f=="Size"&&!this.sizeByContinuous))){if(w==0&&I==0){this.toRender({p:["drawText","<= "+A,q+(D/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea("<= "+A,q+(D/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}else{if(w==e-1&&I==b-1){this.toRender({p:["drawText",a[B-1]+" - "+A,q+(D/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(a[B-1]+" - "+A,q+(D/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}else{nxt=A;this.toRender({p:["drawText",Number(a[B-1])+" - "+nxt,q+(D/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(Number(a[B-1])+" - "+nxt,q+(D/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}}}else{var F=A.length>this.maxTextSize?A.substring(0,this.maxTextSize-3)+"...":A;this.toRender({p:["drawText",F,q+(D/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(A,q+(D/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"),i:["Property:"+K+":"+A+":"+J],t:"Legends",h:m})}}B++}g+=this.margin+D}this.drawLegendBackgroundBox(G,h,this["legend"+f+"Width"],this["legend"+f+"Height"])}};this.drawCustomLegend=function(F,b,k,H,w){var z=w.text.length;var B=this.getDiameterLegend();var u=w.size;if(u){for(var C=0;C<u.length;C++){if(u[C]){B=Math.max(B,u[C])}}}var g=this.getFontPt(this.legendFont);var d=g/2;var l=this.legendColumns>z?z:this.legendColumns;var e=Math.ceil(z/l);var m=k/l;var E=b+this.margin+d;var t=Math.max(B,g);var j=0;this.drawLegendBackgroundBox(F,b,k,H,true,"-legend-"+w.id);if(w.title){this.toRender({p:["drawText",w.title,F+(k/2),E,this.legendFont,this.legendColor,"center","middle"],t:"Legends"});E+=d+this.margin;this.disableGradientTransparencyShadow();if(this.legendBox){this.toRender({p:["drawLine","line",F,E,F+k,E,this.legendBoxColor],t:"Legends"})}this.enableGradientTransparencyShadow();E+=this.margin+(t/2)}else{E+=(t/2)-d}var A=false;for(var v=0;v<e;v++){for(var G=0;G<l;G++){var p=F+this.margin+B/2+(m*G);if(j<z){var a=w.text[j];if(w.shape&&w.shape[j]){var q=w.size[j]||B;var G=this.getFillColor(w.shapeColor[j]||this.background);var y=this.getOutlineColor(G);this.toRender({p:["drawShape",w.shape[j],p,E,q,q,G,y,"closed"],a:this.getShapeArea(w.shape[j],p,E,q,q,G,y,"closed"),i:["legend-shape-"+a],t:"Legends",h:this.isHidden(false,false,"legend-shape-"+a)});A=true}if(w.line&&w.line[j]){var q=w.size[j]||B;var D=q/2;var G=w.lineColor[j]||this.background;var f=w.lineStart&&w.lineStart[j]?w.lineStart[j]:false;var x=w.lineEnd&&w.lineEnd[j]?w.lineEnd[j]:false;this.toRender({p:["drawLine",w.line[j],p-D,E,p+D,E,G,false,false,false,false,false,false,false,f,x],a:this.getLineArea(w.line[j],p-D,E,p+D,E,G,false,false,false,false,false,false,false,f,x),i:["legend-line-"+a],t:"Legends",h:this.isHidden(false,false,"legend-line-"+a)});A=true}if(A){this.toRender({p:["drawText",w.text[j],p+(t/2)+this.margin,E,this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(w.text[j],p+(t/2)+this.margin,E,this.legendFont,this.legendColor,"left","middle"),i:["legend-text-"+a],t:"Legends",h:this.isHidden(false,false,"legend-text-"+a)})}else{this.toRender({p:["drawText",w.text[j],p+(k/2),E,this.legendFont,this.legendColor,"center","middle"],a:this.getTextArea(w.text[j],p+(k/2),E,this.legendFont,this.legendColor,"center","middle"),i:["legend-text-"+a],t:"Legends",h:this.isHidden(false,false,"legend-text-"+a)})}}j++}E+=this.margin+t}this.drawLegendBackgroundBox(F,b,k,H)};this.drawGenericLegend=function(r,o,m,x,p,z,n){var s=this.getDiameterLegend();var c=this.getFontPt(this.legendFont)+2;var q=Math.max(s,c);var d=0;this.drawLegendBackgroundBox(r,o,m,x,true,"-legend");this.toRender({p:["drawText",z,r+(m/2),o+this.margin+(c/2),this.legendFont,this.legendColor,"center","middle"],t:"Legends"});d=o+c+this.margin;if(this.legendBox){this.toRender({p:["drawLine","line",r,d,r+m,d,this.legendBoxColor],t:"Legends"})}d+=this.margin;if(!n){n=1}var b=m/n;var e=Math.ceil(p.levels.length/n);var f=0;var a=d;var g=p.origin?p.origin:this.meta.data.modified?"modified":"y";for(var v=0;v<e;v++){for(var u=0;u<n;u++){var y=r+this.margin+(b*u);if(f<p.levels.length){var k=p.type=="String"?p.colors[f]:this.getColorForValue(p.colorBrew,p.levels[f]);this.toRender({p:["drawShape",this.useRoundRectangles?"rounderect":"square",y+(q/2),a+(q/2),q,q,this.getFillColor(k),this.getOutlineColor(k)],a:this.getShapeArea(this.useRoundRectangles?"rounderect":"square",y+(q/2),a+(q/2),q,q,this.getFillColor(k),this.getOutlineColor(k)),i:["Property:"+z+":"+p.levels[f]+":"+g],t:"Legends",h:this.isHidden(false,false,"Property:"+z+":"+p.levels[f]+":"+g)});this.toRender({p:["drawText",p.levels[f],y+q+this.margin,a+(q/2),this.legendFont,this.legendColor,"left","middle"],a:this.getTextArea(p.levels[f],y+q+this.margin,a+(q/2),this.legendFont,this.legendColor,"left","middle"),i:["Property:"+z+":"+p.levels[f]+":"+g],t:"Legends",h:this.isHidden(false,false,"Property:"+z+":"+p.levels[f]+":"+g)})}else{break}f++}a+=q}this.drawLegendBackgroundBox(r,o,m,x)};this.drawDecorationLegend=function(m,f){if(this.graphType.match(/Scatter/)){var v=this.decorations;var k=this.getFontPt(this.decorationFont);var c=this.measureText(this.sprintf("%15s","X"),this.decorationFont);var g=v.nlfit||v.nor||v.reg?c:0;var h=m+(g?this.legendDecorationMaxLabel+c:this.margin);var u=h;var x=f;var a=x;this.legendDecorationCurX=m;this.legendDecorationCurY=f;this.drawLegendBackgroundBox(m,(f-((k/2)+this.margin)),this.legendDecorationWidth,this.legendDecorationHeight+this.margin,true,"-legend-decorations",true);if(v.qq){for(var q=0;q<v.qq.length;q++){this.toRender({p:["drawText",v.qq[q].label,u,a,this.decorationFont,v.qq[q].color,"left","middle"],t:"Legends"});a+=k+k}}else{if(v.cdf){for(var q=0;q<v.cdf.length;q++){this.toRender({p:["drawText",v.cdf[q].label,u,a,this.decorationFont,v.cdf[q].color,"left","middle"],t:"Legends"});a+=k+k}}else{if(!v.qq&&!v.cdf){if(v.nlfit){this.toRender({p:["drawText","Min",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText","Max",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText","EC50",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText","Slope",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText","p-Val",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText","F-Chg",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});a+=k+k;for(var q=0;q<v.nlfit.length;q++){var n=q%this.colors.length;n=v.nlfit[q].color?v.nlfit[q].color:this.colors[n];u=(h+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){u+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.toRender({p:["drawText",v.nlfit[q].label,u,a,this.decorationFont,n,"right","middle"],t:"Legends"});u=h;for(var p=0;p<6;p++){var y=v.nlfit[q].param[p];if(p<2){y=this.transformValue(this.yAxisTransform,y)}else{if(p==2){}}this.toRender({p:["drawText",this.formatNumber(y,this.yAxisDecs+1),u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin}a+=k+k}}if(v.line){for(var q=0;q<v.line.length;q++){if(v.line[q].label){for(var q=0;q<v.line.length;q++){var n=v.line[q].color?v.line[q].color:this.colors[q%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){u+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.toRender({p:["drawText",v.line[q].label,u,a,this.decorationFont,n,"left","middle"],t:"Legends"});a+=k+k}}}}if(v.reg){this.toRender({p:["drawText","Slope",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText","Int",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText","Cor",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});a+=k+k;for(var q=0;q<v.reg.length;q++){var n=v.reg[q].color?v.reg[q].color:this.colors[q%this.colors.length];u=(h+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){u+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.toRender({p:["drawText",v.reg[q].label,u,a,this.decorationFont,n,"right","middle"],t:"Legends"});u=h;this.toRender({p:["drawText",this.formatNumber(v.reg[q].slope,2),u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText",this.formatNumber(v.reg[q].intercept,this.yAxisDecs+1),u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText",(v.reg[q].cor?this.formatNumber(v.reg[q].cor,3):"NA"),u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;a+=k+k}}if(v.nor){this.toRender({p:["drawText","Mu",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText","Sigma",u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});a+=k+k;for(var q=0;q<v.nor.length;q++){var n=q%this.colors.length;n=v.nor[q].color?v.nor[q].color:this.colors[n];u=(h+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){u+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.toRender({p:["drawText",v.nor[q].label,u,a,this.decorationFont,n,"right","middle"],t:"Legends"});u=h;this.toRender({p:["drawText",this.formatNumber(v.nor[q].mu,this.xAxisDecs+1),u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;this.toRender({p:["drawText",this.formatNumber(v.nor[q].sigma,this.xAxisDecs+2),u,a,this.decorationFont,this.decorationsColor,"right","middle"],t:"Legends"});u+=c+this.margin;a+=k+k}}if(v.area){for(var q=0;q<v.area.length;q++){if(v.area[q].label){var n=v.area[q].color?v.area[q].color:this.colors[q%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){u+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.toRender(["drawText",v.area[q].label,u,a,this.decorationFont,n,"left","middle"]);a+=k+k}}}if(v.kaplanMeier){for(var q=0;q<v.kaplanMeier.length;q++){if(v.kaplanMeier[q].label){var n=v.kaplanMeier[q].color?v.kaplanMeier[q].color:this.colors[q%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){u+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.toRender({p:["drawText",v.kaplanMeier[q].label,u,a,this.decorationFont,n,"left","middle"],t:"Legends"});a+=k+k}}}}}}this.drawLegendBackgroundBox(m,(f-((k/2)+this.margin)),this.legendDecorationWidth,this.legendDecorationHeight+this.margin,false,false,true)}else{if(this.graphType=="Map"&&this.decorations.pie&&this.decorations.pie[0]&&this.decorations.pie[0].smps&&this.decorations.pie[0].smps.length){var v=this.decorations.pie[0];var k=this.getFontPt(this.decorationFont);var b=k/2;var w=Math.ceil(v.smps.length/this.legendColumns);var s=this.legendDecorationWidth/this.legendColumns;var o=0;var h=m;var x=f;for(var q=0;q<w;q++){for(var p=0;p<this.legendColumns;p++){u=h+(this.margin+(s*p));if(o<v.smps.length){var c=v.colors[o];var e=u+b;var r=x+b;this.toRender({p:["drawShape","circle",e,r,k,k,c,this.background],a:this.getShapeArea("circle",e,r,k,k,c,this.background),t:"Legends"});this.toRender({p:["drawText",v.smps[o],e+b+this.margin,r,this.decorationFont,this.decorationColor,"left","middle"],a:this.getTextArea(v.smps[o],e+b+this.margin,r,this.decorationFont,this.decorationColor,"left","middle"),t:"Legends"})}else{break}o++}}}}};this.resetLegends=function(c){if(c){delete (this.legendDecorationCurX);delete (this.legendDecorationCurY);delete (this.legendDecorationX);delete (this.legendDecorationY)}var a=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:this.connectByNoColor?["Color","Shape","Size","Pattern","Variable","Sample"]:["Color","Shape","Size","Pattern","Connect","Variable","Sample"];for(var b=0;b<a.length;b++){this["legend"+a[b]+"Width"]=0;this["legend"+a[b]+"Height"]=0;if(c){delete (this["legend"+a[b]+"CurX"]);delete (this["legend"+a[b]+"CurY"]);delete (this["legend"+a[b]+"X"]);delete (this["legend"+a[b]+"Y"])}}delete (this.legendColorIndicatorCurX);delete (this.legendColorIndicatorCurY)};this.getXYLegendCoords=function(B,s,o){var k,g,r;var n=-1;var A=-1;var f=this;var c=this.graphType=="Network"?0:this.offsetX;var b=this.graphType=="Network"?0:this.offsetY;var d=function(){for(var l=0;l<f.legendLayout.length;l++){if(f.legendLayout[l]){for(var h=0;h<f.legendLayout[l].length;h++){if(f.legendLayout[l][h]==B){return[l,h]}}}}return[-1,-1]};if(this.legendLayout){var e=d();n=e[0];A=e[1];if(n>-1&&A>-1){var a=0;var p=0;if(this.legendPosition.match(/right|left/i)){for(var v=0;v<n;v++){var m=0;if(this.legendLayout[v]){for(var u=0;u<this.legendLayout[v].length;u++){m=Math.max(m,this["legend"+this.legendLayout[v][u]+"Width"]+this.margin)}}a+=m}if(this.legendLayout[v]){for(var u=0;u<this.legendLayout[n].length;u++){p+=this["legend"+this.legendLayout[n][u]+"Height"]+this.margin}}}else{for(var v=0;v<n;v++){var z=0;if(this.legendLayout[v]){for(var u=0;u<this.legendLayout[v].length;u++){z=Math.max(z,this["legend"+this.legendLayout[v][u]+"Height"]+this.margin)}}p+=z}if(this.legendLayout[v]){for(var u=0;u<this.legendLayout[n].length;u++){a+=this["legend"+this.legendLayout[n][u]+"Width"]+this.margin}}}if(this.graphType=="Circular"){k=s;g=o}else{if(this.legendPosition.match(/right|left/i)){o=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?this.marginTop+this.layoutTop:A==0?this.marginTop+b+this.top:o;k=s+a+(this.graphType=="Network"?-10:0);r=this.legendPosition.match(/top/)?this.margin:this.legendPosition.match(/bottom/)?this.y-(p+this.margin):((this.y-p)/2);g=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?(this.height-p)/2:A==0?this.marginTop+b+this.top+r:o;s=A==this.legendLayout[n].length-1?s+a:s;o=g+this["legend"+this.legendLayout[n][A]+"Height"]+this.margin}else{s=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?this.marginLeft+this.layoutLeft:A==0?this.marginLeft+c+this.left:s;k=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition")))?(this.width-a)/2:A==0?this.marginLeft+c+this.left+((this.x-a)/2)+this.margin:s+this.margin;g=o+p;s=k+this["legend"+this.legendLayout[n][A]+"Width"]+this.margin;o=A==this.legendLayout[n].length-1?o+p:o}}}}return[k,g,s,o]};this.getVariableLegendPosition=function(){var c,h;if(this.graphType=="Pie"&&this.layoutValid){if(this.legendPosition=="right"){c=this.width-(this.marginRight+this.legendVariableWidth+this.margin);h=(this.height/2)-(this.legendVariableHeight/2)}else{c=(this.width/2)-(this.legendVariableWidth/2);h=this.height-(this.marginBottom+this.legendVariableHeight+this.margin)}}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return[0,0]}else{if(this.graphType=="Circular"){c=this.width-(this.marginRight+this.legendVariableWidth+this.margin);h=this.height-(this.marginBottom+this.legendVariableHeight+this.margin);return[c,h]}else{if(this.layoutValid&&this.graphType!="Pie"){var d=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var b=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);var j=this.legendVariableHeight+this.legendOverlaysHeight+(this.margin*-0.5);var e=this.legendVariableWidth+this.legendOverlaysWidth+(this.margin*-0.5);c=this.legendPosition=="right"?this.width-(this.marginRight+e):this.legendPosition=="left"?this.marginLeft+this.margin:this.marginLeft+this.layoutLeft+(d/2)-(e/2);h=this.legendPosition=="bottom"?this.height-(this.marginBottom+j):this.legendPosition=="top"?this.marginTop+this.margin+this.getTitleSubtitleHeight():this.marginTop+this.layoutTop+(b/2)-(j/2)}else{var f=this.marginLeft+this.offsetX+this.left;var k=this.marginTop+this.offsetY+this.top;var a=this.legendVariableHeight;var i=this.legendVariableWidth;if(this.legendInside||this.graphType=="Pie"){switch(this.legendPosition){case"bottomRight":c=f+this.x-(i+this.margin);h=k+this.y-(a+this.margin);break;case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y-(this.graphType=="Pie"?0:(a+this.margin));break;case"bottomLeft":c=f+this.margin;h=k+this.y-(a+this.margin);break;case"left":c=f+this.margin-(this.graphType=="Pie"?(i+this.margin):0);h=k+(this.y/2)-(a/2);break;case"topLeft":c=f+this.margin;h=k+this.margin;break;case"top":c=f+(this.x/2)-(i/2);h=k+this.margin-(this.graphType=="Pie"?(a+this.margin):0);break;case"topRight":c=f+this.x-(i+this.margin);h=k+this.margin;break;default:c=f+this.x-(this.graphType=="Pie"?0:(i+this.margin));h=k+(this.y/2)-(a/2)}}else{var m=this.overlaysLegendPosition.match(/top|bottom/i)?this.legendOverlaysHeight:0;var g=this.overlaysLegendPosition.match(/right|left/i)?this.legendOverlaysWidth:0;switch(this.legendPosition){case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y+this.bottom-(a+m+this.margin);break;case"top":c=f+(this.x/2)-(i/2);h=this.marginTop+this.offsetY+this.margin+this.getTitleSubtitleHeight();break;case"left":c=this.marginLeft+this.offsetX+this.margin;h=k+(this.y/2)-(a/2);break;default:c=f+this.x+this.right-(i+g+this.margin);h=k+(this.y/2)-(a/2)}}}}}}return[c,h]};this.getScatterLegendPosition=function(){var j=0;var h=0;var g=0;var d=0;var a=0;var i=0;var c=this.graphType=="Network"?10:this.offsetX;var b=this.graphType=="Network"?10:this.offsetY;var e=this.marginLeft+c+this.left+this.margin;var k=this.marginTop+b+this.top+this.margin;if(this.scatterPlotMatrix||(this.layoutValid&&!this.getLayoutConfig("legendPosition"))){if(this.legendPosition=="left"){g=this.marginLeft+this.margin}else{g=this.width+this.margin-(this.marginRight+(this.legendWidth||0))}if(this.legendPosition=="top"){d=this.marginTop+this.margin+this.getTitleSubtitleHeight()}else{d=this.height+this.margin-(this.marginBottom+(this.legendHeight||0))}j=g-(this.legendDecorationWidth+this.margin);h=d-(this.legendDecorationHeight+this.margin)}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"&&this.colorBy){g=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legendColorWidth+this.right+this.marginRight);d=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legendColorHeight+this.bottom+this.marginBottom)}else{g=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legendVariableWidth+this.right+this.marginRight);d=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legendVariableHeight+this.bottom+this.marginBottom)}}else{if(this.legendInside||this.isQQ||this.isCDF){if(this.legendDecorationWidth>0&&this.legendDecorationHeight>0){var f=this.legendDecorationWidth+(this.margin*2);if(this.isQQ||this.isCDF){j=e+this.x-f;h=k+this.y-(this.legendDecorationHeight+this.margin)}else{switch(this.decorationsPosition){case"bottomRight":j=e+this.x-f;h=k+this.y-(this.legendDecorationHeight+this.margin);break;case"bottom":j=e+(this.x/2)-(this.legendDecorationWidth/2);h=k+this.y-(this.legendDecorationHeight+this.margin);break;case"bottomLeft":j=e+this.margin;h=k+this.y-(this.legendDecorationHeight+this.margin);break;case"left":j=e+this.margin;h=k+(this.y/2)-(this.legendDecorationHeight/2);break;case"topLeft":j=e+this.margin;h=k+(this.margin*2);break;case"top":j=e+(this.x/2)-(this.legendDecorationWidth/2);h=k+(this.margin*2);break;case"topRight":j=e+this.x-f;h=k+(this.margin*2);break;default:j=e+this.x-f;h=k+(this.y/2)-(this.legendDecorationHeight/2);break}}}if(this.legendWidth>0&&this.legendHeight>0){switch(this.legendPosition){case"bottomRight":g=e+this.x-this.legendWidth;d=k+this.y-this.legendHeight;break;case"bottom":g=e+(this.x/2)-(this.legendWidth/2);d=k+this.y-this.legendHeight;break;case"bottomLeft":g=e;d=k+this.y-this.legendHeight;break;case"left":g=e;d=k+(this.y/2)-(this.legendHeight/2);break;case"topLeft":g=e;d=k;break;case"top":g=e+(this.x/2)-(this.legendWidth/2);d=k;break;case"topRight":g=e+this.x-this.legendWidth;d=k;break;default:g=e+this.x-this.legendWidth;d=k+(this.y/2)-(this.legendHeight/2);break}}}else{switch(this.decorationsPosition){case"bottom":j=e+(this.x/2)-(this.legendDecorationWidth/2);h=k+this.y+this.bottom-this.legendDecorationHeight;break;default:j=e+this.x+this.right-(this.legendDecorationWidth+(this.margin*2));h=k+(this.y/2)-(this.legendDecorationHeight/2);break}a=this.legendPosition==this.decorationsPosition?this.legendDecorationWidth:0;i=this.legendPosition==this.decorationsPosition?this.legendDecorationHeight:0;switch(this.legendPosition){case"bottom":g=e+(this.x/2)-(this.legendWidth/2);d=k+this.y+this.bottom-(this.legendHeight+(i?i+this.margin:0));if(this.graphType=="Scatter3D"||this.is3DPlot){d+=this.legendHeight}break;case"top":g=e+(this.x/2)-(this.legendWidth/2);d=this.marginTop+b+this.margin+this.getTitleSubtitleHeight();if(this.graphType=="Scatter3D"||this.is3DPlot){d+=this.legendHeight}break;case"left":g=this.marginLeft+c+this.margin;d=k+(this.y/2)-(this.legendHeight/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legendWidth}break;default:g=e+this.x+this.right-(this.legendWidth+a);d=k+(this.y/2)-(this.legendHeight/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legendWidth}if(this.isMultidimensionalData&&this.heatmapIndicatorPosition=="right"){g-=(this.heatmapIndicatorHeight+this.meta.def.colorBrew.maxLevLen+this.margin)}if(this.scatterType=="visium"){g-=this.margin*3}break}}}}return[j,h,g,d]};this.drawIndicator=function(a,b,c){delete (this.legendColorIndicatorCurX);delete (this.legendColorIndicatorCurY);this.drawColorIndicator(a,b,false,c)};this.drawLegend=function(a){if(this.graphType=="Meter"){return}else{if(this.graphType=="Fish"){var b=this.getVariableLegendPosition();this.drawVariableLegend(b[0],b[1])}else{if(this.graphType=="Venn"){this.drawVennLegend()}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"){this.drawScatterLegend(a)}else{if(this.circularType=="bubble"){}else{if(this.showLegend){this.drawOverlaysLegend();var b=this.getVariableLegendPosition();this.drawVariableLegend(b[0],b[1])}}}}else{if(this.graphType=="Network"){this.drawScatterLegend()}else{if(this.graphType.match(/Scatter/)||this.is3DPlot||((this.isAttributedGraph()||this.connectBy)&&(CanvasXpress.graphTypes.AttGraphs.includes(this.graphType)||this.graphType=="Map"))){this.drawScatterLegend(a);if(this.isOncoprint){this.drawOncoprintLegend()}this.drawOverlaysLegend()}else{if(this.graphType=="Pie"&&this.layoutValid&&!this.isDOE){if(this.layoutCurrent==this.data.l.smps.length-1){this.draw1DLegend()}}else{this.draw1DLegend();this.drawOverlaysLegend()}}}}}}}};this.draw1DLegend=function(){if(this.showLegend&&((this.graphType!="Heatmap")||(this.graphType=="Heatmap"&&this.isAttributedGraph()))){if(this.isMultidimensionalData||(this.isAttributedGraph()&&CanvasXpress.graphTypes.AttGraphs.includes(this.graphType))){if(this.isOncoprint){this.drawOncoprintLegend()}this.drawScatterLegend()}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return}var c=this.getVariableLegendPosition();var a=c[0];var b=c[1];if(this.legendVariableX&&this.legendVariableY){a=this.legendVariableX;b=this.legendVariableY}this.legendVariableCurX=a;this.legendVariableCurY=b;this.drawVariableLegend(a,b)}}else{if(this.isOncoprint){this.drawOncoprintLegend()}}};this.drawOverlaysLegend=function(){var s,e;if(this.overlaysLegendPosition.match(/right/i)){s=this.layoutValid?this.marginTop+this.layoutTop:this.marginTop+this.offsetY+this.top;if(this.overlaysLegendPosition=="right"){s+=(this.y/2)-(this.legendOverlaysHeight/2)}e=this.layoutValid?this.width-(this.marginRight+this.layoutRight+this.legendOverlaysWidth):this.width-(this.marginRight+this.legendOverlaysWidth);if(this.graphType=="Heatmap"&&this.heatmapIndicatorPosition=="right"){e-=this.getHeatmapIndicatorWidth()-this.margin}}else{s=this.layoutValid?this.height-(this.marginBottom+this.layoutBottom+this.legendOverlaysHeight):this.height-(this.marginBottom+this.legendOverlaysHeight);e=this.layoutValid?this.marginLeft+this.layoutLeft:this.marginLeft+this.offsetX+this.left;if(this.overlaysLegendPosition=="bottom"){e+=(this.x/2)-(this.legendOverlaysWidth/2)}}var v=s;var f=e;for(var k=0;k<this.legendOverlaysLayout.length;k++){var n=this.legendOverlaysLayout[k];var r,b,d,a;var u=mw=0;var p=mh=0;for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];mw=Math.max(u,n[g][2]);mh=Math.max(p,n[g][3])}for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];d=this.meta.data[r][b];u=this["legend"+b+"Width"];p=this["legend"+b+"Height"];a=r=="z"?this.varOverlaysLegendColumns:this.smpOverlaysLegendColumns;if(d.type=="String"){this.drawGenericLegend(f,v,u,p,d,b,a)}else{this.drawColorIndicator(f,v,d,b,false,u/2)}if(this.overlaysLegendPosition.match(/right/i)){v+=p+this.margin}else{f+=u+this.margin}}if(this.overlaysLegendPosition.match(/right/i)){f+=mw+this.margin;v=s}else{f=e;v+=mh+this.margin}}};this.drawScatterLegend=function(f){var n=this.getScatterLegendPosition();if(this.showDecorations&&this.showDecorationsLegend&&this.decorations&&!this.layoutValid){if(this.legendDecorationX!=null&&this.legendDecorationY!=null){this.drawDecorationLegend(this.legendDecorationX,this.legendDecorationY)}else{this.drawDecorationLegend(n[0],n[1])}}if(this.graphType.match(/Scatter/)&&(this.isQQ||this.isCDF)){return}if(this.showLegend){var k=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge","Decoration"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:this.connectByNoColor?["Color","Shape","Size","Pattern","Variable","Sample"]:["Color","Shape","Size","Pattern","Connect","Variable","Sample","Contour"];var e=n[2];var o=n[3];for(var g=0;g<k.length;g++){var s=this["legend"+k[g]+"Width"];var j=this["legend"+k[g]+"Height"];var r=this["legend"+k[g]+"X"];var l=this["legend"+k[g]+"Y"];var a=this.isHistogramLayout()&&k[g]=="Sample";if(s>0){if(f&&!a){this.setPropertyLegendDimensions(k[g]);s=this["legend"+k[g]+"Width"];j=this["legend"+k[g]+"Height"]}var d=("draw"+k[g]+"Legend").replace("Node","").replace("Edge","").replace("Decoration","Color").replace("Contour","Color");var c=this["legend"+k[g]+"Meta"];var p=this.getXYLegendCoords(k[g],e,o);if(r&&l){this[d](r,l,c,k[g]);this["legend"+k[g]+"CurX"]=r;this["legend"+k[g]+"CurY"]=l}else{this[d](p[0],p[1],c,k[g]);this["legend"+k[g]+"CurX"]=p[0];this["legend"+k[g]+"CurY"]=p[1]}if(this.legendPosition.match(/right|left/i)){o=p[3]+this.margin}else{e=p[2]+this.margin}}}for(var g=0;g<this.legend.length;g++){if(this.graphType=="Network"&&!this.showDecorations){continue}var b="Custom"+g;var s=this["legend"+b+"Width"];var j=this["legend"+b+"Height"];var r=this["legend"+b+"X"];var l=this["legend"+b+"Y"];var p=this.getXYLegendCoords(b,e,o);if(r&&l){this.drawCustomLegend(r,l,s,j,this.legend[g]);this["legend"+b+"CurX"]=r;this["legend"+b+"CurY"]=l}else{this.drawCustomLegend(p[0],p[1],s,j,this.legend[g]);this["legend"+b+"CurX"]=p[0];this["legend"+b+"CurY"]=p[1]}if(this.legendPosition.match(/right|left/i)){o=p[3]+this.margin}else{e=p[2]+this.margin}}}};this.setMarker=function(u){var g=this;var B=function(p){var m=g.meta.render.objects;for(var j=0;j<m.length;j++){var k=m[j];if(k.type=="Data"&&k.idx){var h=k.idx.join(":");if(h==p||h==p+":false"||h==p+":true"||h==p+":box"){if(g.layoutValid){if(k.layout==g.layoutCurrent){return k}}else{return k}}}}return false};var c=function(){if(u.fontSize){return(u.fontStyle||"")+" "+parseInt(u.fontSize)+"px "+g.fontName}else{return g.decorationFont}};if(!u.variable){return false}var e=this.graphType.match(/Treemap|Stacked|Dotplot/)||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)?true:false;var F=!u.variable?[]:this.isArray(u.variable)?this.getVariableIndices(u.variable):this.getVariableIndices([u.variable]);var b=u.variable2&&this.isArray(u.variable2)?this.getVariableIndices(u.variable2):u.variable2?this.getVariableIndices([u.variable2]):false;var C=[];var a;if(this.layoutValid&&this.data.l&&this.data.l.smps&&this.data.l.smps[this.layoutCurrent]){for(var z=0;z<this.data.l.smps[this.layoutCurrent].length;z++){if(this.data.l.smps[this.layoutCurrent][z]==u.sample){if(((this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Dotplot")&&this.isGroupedData&&this.data.w){var E=false;for(var y=0;y<this.data.w.grps.length;y++){for(var x=0;x<this.data.w.grps[y].length;x++){if(this.data.l.ids[this.layoutCurrent][z]==this.data.w.grps[y][x]){C.push(y);C.push(this.data.l.ids[this.layoutCurrent][z]);E=true}}if(E){break}}}else{C.push(this.data.l.ids[this.layoutCurrent][z])}break}}if(!C.length&&this.isGroupedData&&this.data.w){for(var z=0;z<this.data.w.labs.length;z++){if(this.data.w.labs[z]==u.sample){C.push(z)}}}if(u.scope&&this.isArray(u.scope)){if(this.data.x){for(var z=0;z<C.length;z++){var o=C[z];var A=0;for(var q in this.data.x){if(u.scope.includes(this.data.x[q][o])){A++}}if(A==u.scope.length){C=o;break}}if(this.isArray(C)){C=[C[0]]}}else{C=[C[0]]}}}else{C=!u.sample?[]:this.isArray(u.sample)?this.getSampleIndices(u.sample,e):this.getSampleIndices([u.sample],e);if(((this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Dotplot")&&this.isGroupedData&&this.data.w){if(C.length){var E=false;for(var z=0;z<this.data.w.grps.length;z++){for(var y=0;y<this.data.w.grps[z].length;y++){if(C[0]==this.data.w.grps[z][y]){C.unshift(z);E=true;break}}if(E){break}}}else{C=!u.sample?[]:this.isArray(u.sample)?this.getSampleIndices(u.sample):this.getSampleIndices([u.sample])}}a=u.sample2&&this.isArray(u.sample2)?this.getSampleIndices(u.sample2,e):u.sample2?this.getSampleIndices([u.sample2],e):false}var r=F.concat(C).join(":");var t=b&&a?b.concat(a).join(":"):false;var v=B(r);var w=t?B(t):false;var d=v?this.centroidArea(v.area):false;var s=w?this.centroidArea(w.area):false;var l=v?v.params[4]:0;var D=v?v.params[3]:0;var n=w?w.params[4]:0;var f=w?w.params[3]:0;if(u.id==null){u.id=this.newId("-marker-")}u.vi=F;u.si=C;u.vi2=b;u.si2=a;if(!this.isArray(u.variable)){u.variable=[u.variable]}if(!this.isArray(u.sample)){u.sample=[u.sample]}if(u.variable2&&!this.isArray(u.variable2)){u.variable2=[u.variable2]}if(u.sample2&&!this.isArray(u.sample2)){u.sample2=[u.sample2]}if(!u.type){u.type="line"}u.b=[this.marginLeft+this.offsetX+this.left,this.marginTop+this.offsetY+this.top,this.x,this.y];u.len=this.measureText(u.text,c());u.width=this.measureTextWidth(u.text,c());u.tx=d&&this.graphOrientation=="vertical"?d[0]:d&&this.graphOrientation!="vertical"?d[0]+(D/2)+(u.width*2)+(this.margin*2):false;u.ty=d&&u.type!="line"&&this.graphOrientation=="vertical"?d[1]-((l/2)+u.width):d&&u.type!="line"&&this.graphOrientation!="vertical"?d[1]:d?d[1]:false;u.tx2=s&&this.graphOrientation=="vertical"?s[0]:s&&this.graphOrientation!="vertical"?s[0]+(f/2)+(u.width*2)+(this.margin*2):false;u.ty2=s&&u.type!="line"&&this.graphOrientation=="vertical"?s[1]-((n/2)+u.width):s&&u.type!="line"&&this.graphOrientation!="vertical"?s[1]:s?s[1]:false;if(d&&this.graphType.match(/Scatter/)){u.tx=d[0];u.ty=d[1]}if(u.offsetX&&d){u.tx=d[0]+u.offsetX}if(u.offsetX&&s){u.tx2=s[0]+u.offsetX}if(u.offsetY&&d){u.ty=d[1]+u.offsetY}if(u.offsetY&&s){u.ty2=s[1]+u.offsetY}return u};this.getMarker=function(c){if(c&&this.decorations&&this.decorations.marker){for(var b=0;b<this.decorations.marker.length;b++){var a=this.decorations.marker[b];if(c==a.id){return a}}}};this.drawMarkers=function(a){var f=this;var z=function(d,c,h){if(f.layoutValid){if(d.si!=null){return d.ty>f.offsetY&&d.ty<f.offsetY+f.layoutParams[f.layoutCurrent].height&&d.tx>f.offsetX&&d.tx<f.offsetX+f.layoutParams[f.layoutCurrent].width}else{return false}}else{return d.ty>0&&d.ty<f.height&&d.tx>0&&d.tx<f.width}};var b=function(){if(A.fontSize){return(A.fontStyle||"")+" "+parseInt(A.fontSize)+"px "+f.fontName}else{return f.decorationFont}};if(a){this.clearHighlightCanvas();this.isHighlightCanvas=true}else{if(this.moveMarker){return}}if(this.decorations&&this.decorations.marker){var G=this.decorations.marker;for(var D=0;D<G.length;D++){var A=this.setMarker(G[D]);if(A&&A.tx&&A.ty&&A.b){var o,l,F,e;o=A.offsetX?A.tx:A.x?A.b[0]+(A.x*A.b[2]):this.graphOrientation=="vertical"?A.tx:A.tx+this.margin;l=A.offsetY?A.ty:A.y?A.b[1]+(A.y*A.b[3]):this.graphOrientation=="vertical"?A.ty-this.margin:A.ty;F=A.tx2&&A.offsetX?A.tx2:A.tx2&&this.graphOrientation=="vertical"?A.tx2:A.tx2?A.tx2+this.margin:false;e=A.ty2&&A.offsetY?A.ty2:A.ty2&&this.graphOrientation=="vertical"?A.ty2-this.margin:A.ty2?A.ty2:false;if(A.type=="comparison"&&o&&l&&F&&e){if(this.graphOrientation=="vertical"){l=Math.min(l,e)-this.getFontPt(b(A));e=l}else{o=Math.max(o,F);F=o}}if(z(A,o,l)){var q=A.scope||false;if(q){var p=this.layoutValid?false:true;if(this.layoutValid){var t=this.data.l.name[this.layoutCurrent];if(!this.isArray(t)){t=[t]}for(var C=0;C<t.length;C++){var w=t[C].toString().replace("\x00","");if(this.isArray(q)){for(var B=0;B<q.length;B++){if(q[B].toString()==w){p=true;break}}}else{if(q.toString()==w){p=true;break}}}}if(!p){continue}}var g=A.rotate?Math.PI*A.rotate/180:false;var v;if(A.type=="comparison"){if(this.graphOrientation=="vertical"){v=this.toRender({p:["drawText",A.text,(o+F)/2,l,b(A),A.color||this.decorationsColor,A.align,A.baseline,g],a:this.getTextArea(A.text,(o+F)/2,l,b(A),A.color||this.decorationsColor,A.align,A.baseline,g),i:["Marker:"+A.id],t:"Decorations",d:this.moveMarker?true:false})}else{v=this.toRender({p:["drawText",A.text,o+(A.len/2),(l+e)/2,b(A),A.color||this.decorationsColor,A.align,A.baseline,g],a:this.getTextArea(A.text,o+(A.len/2),(l+e)/2,b(A),A.color||this.decorationsColor,A.align,A.baseline,g),i:["Marker:"+A.id],t:"Decorations",d:this.moveMarker?true:false})}}else{if(A.text){v=this.toRender({p:["drawText",A.text,o,l,b(A),A.color||this.decorationsColor,A.align,A.baseline,g],a:this.getTextArea(A.text,o,l,b(A),A.color||this.decorationsColor,A.align,A.baseline,g),i:["Marker:"+A.id],t:"Decorations",d:this.moveMarker?true:false})}}var u=this.meta.render.objects[v].area;if(A.type=="comparison"){var H=A.color||this.decorationsColor;var E=this.getFontPt(b(A));if(this.graphOrientation=="vertical"){this.toRender({p:["drawLine","line",o,l+E,F,e+E,H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine","line",o,l+E-this.margin,o,l+E+this.margin,H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine","line",F,e+E-this.margin,F,e+E+this.margin,H],g:v,t:"Decorations",d:this.moveMarker?true:false})}else{this.toRender({p:["drawLine","line",o-E,l,F-E,e,H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine","line",o-(E+this.margin),l,o+this.margin-E,l,H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine","line",F-(E+this.margin),e,F+this.margin-E,e,H],g:v,t:"Decorations",d:this.moveMarker?true:false})}}if(A.type=="line"){var H=A.color||this.decorationsColor;var E;A.curX=o;A.curY=l;if(A.tx<u[1]-A.len){E=(u[2]+u[4])/2;this.toRender({p:["drawLine","line",u[1]-this.margin,u[2],u[1]-this.margin,u[4],H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine",A.type,A.tx,A.ty,u[1]-this.margin,E,H],g:v,t:"Decorations",d:this.moveMarker?true:false})}else{if(A.tx>u[3]+A.len){E=(u[2]+u[4])/2;this.toRender({p:["drawLine","line",u[3]+this.margin,u[2],u[3]+this.margin,u[4],H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine",A.type,A.tx,A.ty,u[3]+this.margin,E,H],g:v,t:"Decorations",d:this.moveMarker?true:false})}else{if(A.ty>u[4]+(A.width*0.2)){E=(u[1]+u[3])/2;this.toRender({p:["drawLine","line",u[1],u[4]+this.margin,u[3],u[4]+this.margin,H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine",A.type,A.tx,A.ty,E,u[4]+this.margin,H],g:v,t:"Decorations",d:this.moveMarker?true:false})}else{if(A.ty<u[2]-(A.width*0.2)){E=(u[1]+u[3])/2;this.toRender({p:["drawLine","line",u[1],u[2]-this.margin,u[3],u[2]-this.margin,H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine",A.type,A.tx,A.ty,E,u[2]-this.margin,H],g:v,t:"Decorations",d:this.moveMarker?true:false})}else{if(A.tx<u[1]){E=(u[2]+u[4])/2;this.toRender({p:["drawLine","line",u[1]-this.margin,u[2],u[1]-this.margin,u[4],H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine",A.type,A.tx,A.ty,u[1]-this.margin,E,H],g:v,t:"Decorations",d:this.moveMarker?true:false})}else{E=(u[2]+u[4])/2;this.toRender({p:["drawLine","line",u[3]+this.margin,u[2],u[3]+this.margin,u[4],H],g:v,t:"Decorations",d:this.moveMarker?true:false});this.toRender({p:["drawLine",A.type,A.tx,A.ty,u[3]+this.margin,E,H],g:v,t:"Decorations",d:this.moveMarker?true:false})}}}}}}else{A.curX=o;A.curY=l}}}}}if(a){this.isHighlightCanvas=false}}};CanvasXpress.prototype.initFilterUtils=function(){this.handleSelector=function(l){this.hiddenLegends[l.id]=this.hiddenLegends[l.id]?false:true;var c=!this.hiddenLegends[l.id];var m=this.showTransition;this.showTransition=false;switch(l.type){case"var":this.filterVariables(l.type+"s","exact",(this.isArray(l.name)?l.name:[l.name]),c);break;case"smp":this.filterSamples(l.type+"s","exact",(this.isArray(l.name)?l.name:[l.name]),c);break;case"series":if(this.isHistogramLayout()){var b=(!this.segregateVariablesBy.length||this.segregateVariablesBy[0]!=this.isCreateHistogram.factor)?l.name[1].split(":")[1]:(this.segregateVariablesBy[0]==this.isCreateHistogram.factor)?l.name[1].split(":")[0]:false;if(b){l.name=[l.name[0]];for(var e=0;e<this.data.y.smps.length;e++){var g=this.data.y.smps[e].split(":");for(var d=0;d<g.length;d++){if(g[d]==b){l.name.push(this.data.y.smps[e]);continue}}}}}this.filterSamples("smps","exact",(this.isArray(l.name)?l.name:[l.name]),c);break;case"meta":var k=this.isOncoprint||this.isMultidimensionalData&&!this.meta.data[l.object][l.factor]&&this.meta.data[l.object]?this.meta.data[l.object]:this.meta.data[l.object][l.factor];switch(l.object){case"x":if(k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.filterSamplesByCategory(l.factor,"between",[f,a],c)}else{this.filterSamplesByCategory(l.factor,"exact",(this.isArray(l.level)?l.level:[l.level]),c)}break;case"z":if(k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.filterVariablesByCategory(l.factor,"between",[f,a],c)}else{this.filterVariablesByCategory(l.factor,"exact",(this.isArray(l.level)?l.level:[l.level]),c)}break;case"y":var k=this.shapeBy==l.factor?this.legendShapeMeta:this.sizeBy==l.factor?this.legendSizeMeta:false;if(!k){return}var h=0;for(var e=0;e<k.vals.length;e++){if(Number(l.level)==k.vals[e]){h=e;break}}var a=k.vals[h];var f=h==0?Number(l.level)-1e-9:k.vals[h-1]+1e-9;this.filterVariablesByCategory(l.factor,"between",[f,a],c);break;case"modified":if(this.meta.data.modified.x&&this.meta.data.modified.x.meta&&this.meta.data.modified.x.meta[l.factor]){alert("Ooops! Needs to develop this case!")}else{if(this.meta.data.modified.z&&this.meta.data.modified.z.meta&&this.meta.data.modified.z.meta[l.factor]){this.filterUserData("filterSmpBy",l.factor,"exact",[this.meta.data.modified.z.meta[l.factor].order[l.level]],c)}}break;default:if(k&&k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.filterDataByCategory(l.object,"between",[f,a],c)}else{this.filterDataByCategory(l.object,"exact",[l.level],c)}break}break;case"data":this.filterDataByCategory(l.object,"exact",[l.name],c);break}this.showTransition=m};this.filterVariables=function(f,e,c,d,a){this.filterUserData("filterVarBy","vars",e,c,d,a)};this.filterVariablesByCategory=function(f,e,c,d,a){this.filterUserData("filterVarBy",f,e,c,d,a)};this.filterSamples=function(f,e,c,d,a){this.filterUserData("filterSmpBy","smps",e,c,d,a)};this.filterSamplesByCategory=function(c,f,d,e,a){this.filterUserData("filterSmpBy",c,f,d,e,a)};this.filterDataByCategory=function(g,f,d,e,a){this.filterUserData("filterDataBy",g,f,d,e,a)};this.filterUserData=function(j,k,c,l,a,m){if(this.isTransition()){return}var e={min:">=",max:"<=",between:"between",like:"like",exact:"exact"};this.showMask();var f=this.ungroupGroupedData();if(a){for(var d=0;d<this[j].comp.length;d++){if(this[j].comp[d]==k&&this[j].op[d]==e[c]&&this[j].cases[d]==false&&this[j].type[d]=="Legend"&&this.isSameObject(this[j].value[d],l)){this[j].comp.splice(d,1);this[j].op.splice(d,1);this[j].cases.splice(d,1);this[j].type.splice(d,1);this[j].value.splice(d,1)}}}else{this[j].comp.push(k);this[j].op.push(e[c]);this[j].cases.push(false);this[j].type.push("Legend");this[j].value.push(l)}this.reset(true,true,false,m);this.filterData(f,!m);if(this.isGroupedData&&this.smpIndices.length>0){var b=this.cloneObject(this.data.w.grpIdxs);this.groupSamples(this.groupingFactors,false,b,true,true,false,f?false:true)}this.draw({func:"filterUserData",par:[j,k,c,l,a,m],prop:{hiddenLegends:this.hiddenLegends}})};this.filterData=function(E,H){if(this.isDOE){return}this.showMask();var y={};var P={};var c={};var J=false;var F=this;var u=function(){var a=[];if(F.graphType.match(/line/i)&&F.xAxis.length&&F.xAxis2.length){a=F.getVariableIndices(F.xAxis);return a.concat(F.getVariableIndices(F.xAxis2))}else{return F.varIndices}};var G=function(s,v,g){if(v.hasOwnProperty(s)){return v[s]}else{if(s.match(":::")){var d=s.split(":::");if(g[d[1]]){d[1]=parseInt(d[1]);for(var k=0;k<g[d[1]].length;k++){var h=g[d[1]][k];if(v.hasOwnProperty(h)){v=v[h]}else{return false}}if(v.hasOwnProperty(d[0])){return v[d[0]]}}}return false}};var o=function(a){var d={s:[],v:[]};if(F.filterSmpBy.comp.length){for(var g=0;g<F.filterSmpBy.comp.length;g++){if(F.filterSmpBy.comp[g]){if(a&&F.filterSmpBy.type[g]!="Legend"){continue}d.s[g]=F.getSampleIndices(F.filterSmpBy.comp[g])}}}if(F.filterVarBy.comp.length){for(var g=0;g<F.filterVarBy.comp.length;g++){if(F.filterVarBy.comp[g]){if(a&&F.filterVarBy.type[g]!="Legend"){continue}d.v[g]=F.getVariableIndices(F.filterVarBy.comp[g])}}}return d};var I=function(aa){var ac=F.motionBy?F.seq(0,F.data.y.vars.length-1,1):F.graphType.match(/line/i)?u():F.varIndices;var Z=o(aa);var s=[];var a;var k=false;for(var v=0;v<ac.length;v++){var ad=ac[v];var h=false;a=F.filterSmpBy;if(a.comp.length>0){for(var p=0;p<a.comp.length;p++){if(a.comp[p]){if(aa&&a.type[p]!="Legend"){continue}var ab=Z.s[p];if(ab>=0){k=true;var g=A(F.data.y.data[ad][ab],a.op[p],a.value[p],a.cases[p]);if(F.filterType=="and"&&!aa){if(g){h=true}else{h=false;break}}else{if(g){h=true;break}}}}}}a=F.filterVarBy;if(a.comp.length>0){for(var p=0;p<a.comp.length;p++){if(a.comp[p]){if(aa&&a.type[p]!="Legend"){continue}var ab=Z.v[p];if(ab==-1){k=true;var d=a.comp[p]=="vars"?F.data.y.vars[ad]:F.getMetadataValue(ad,"z",a.comp[p]);var g=A(d,a.op[p],a.value[p],a.cases[p]);if(F.filterType=="and"&&!aa){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}else{k=true;var d=F.data.y.data[ad][ab];var g=A(d,a.op[p],a.value[p],a.cases[p]);if(F.filterType=="and"&&!aa){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}}}}if(h){s.push(ad)}}return k?s:false};var M=function(ad,ac){if(F.isGroupedData&&(!E||ac)){var af=F.grpIndices;var Z=[];var a;var s=false;for(var aa=0;aa<af.length;aa++){var ag=af[aa];var h=false;a=F.filterSmpBy;if(a.comp.length>0){for(var v=0;v<a.comp.length;v++){if(a.comp[v]){if(ad&&a.type[v]!="Legend"){continue}s=true;if(a.comp[v]=="smps"){var g=false;for(var p=0;p<F.data.w.grps[ag].length;p++){if(A(F.data.y.smps[F.data.w.grps[ag][p]],a.op[v],a.value[v],a.cases[v])){g=true;break}}if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}else{var g=A(F.data.w.factors[a.comp[v]][aa],a.op[v],a.value[v],a.cases[v]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}}}}if(h){Z.push(ag)}}}else{var af=F.smpIndices;var ab=o(ad);var Z=[];var a;var s=false;for(var aa=0;aa<af.length;aa++){var ag=af[aa];var h=false;a=F.filterVarBy;if(a.comp.length>0){for(var v=0;v<a.comp.length;v++){if(a.comp[v]){if(ad&&a.type[v]!="Legend"){continue}var ae=ab.v[v];if(ae>=0){s=true;var g=A(F.data.y.data[ae][ag],a.op[v],a.value[v],a.cases[v]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;break}}else{if(g){h=true;break}}}}}}a=F.filterSmpBy;if(a.comp.length>0){for(var v=0;v<a.comp.length;v++){if(a.comp[v]){if(ad&&a.type[v]!="Legend"){continue}var ae=ab.s[v];if(ae==-1){s=true;var d=a.comp[v]=="smps"?F.data.y.smps[ag]:F.getMetadataValue(ag,"x",a.comp[v],true);var g=A(d,a.op[v],a.value[v],a.cases[v]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}}}}if(h){Z.push(ag)}}}return s?Z:false};var A=function(j,s,h,g){if(!s){return true}if(F.filterSkipNullValues&&(j==null||j=="")){return true}if(s==">"){return parseFloat(j)-parseFloat(h)>0}else{if(s==">="){return parseFloat(j)-parseFloat(h)>0||parseFloat(j)-parseFloat(h)==0}else{if(s=="<"){return parseFloat(j)-parseFloat(h)<0}else{if(s=="<="){return parseFloat(j)-parseFloat(h)<0||parseFloat(j)-parseFloat(h)==0}else{if(s=="between"){return(parseFloat(j)-parseFloat(h[0])>0||parseFloat(j)-parseFloat(h[0])==0)&&(parseFloat(j)-parseFloat(h[1])<0||parseFloat(j)-parseFloat(h[1])==0)}else{if(s=="="||s=="=="){return parseFloat(j)-parseFloat(h)==0}else{if(s=="null"){return j==null}else{if(s=="not null"){return j!=null}else{if(s=="exact"){for(var d=0;d<h.length;d++){if((j+"").toString()==(h[d]+"").toString()){return true}}return false}else{if(s=="like"||s=="not like"){var k=false;if(g){for(var d=0;d<h.length;d++){if((j+"").search(h[d]+"")!=-1||h[d].toString()==j.toString()){k=true;if(s=="like"){break}}}}else{var a=(j+"").toLowerCase();for(var d=0;d<h.length;d++){var p=(h[d]+"").toLowerCase();if(a.search(p)!=-1||a.toString()==p.toString()){k=true;if(s=="like"){break}}}}return s=="like"?k:!k}}}}}}}}}}};var w=function(a){if(!c[a]){c[a]=0}c[a]++};if(this.graphType=="Genome"&&this.filterFeatureBy.comp.length>0){for(var T=0;T<this.filterFeatureBy.comp.length;T++){if(this.filterFeatureBy.comp[T]){for(var S=0;S<this.data.tracks.length;S++){var q=this.data.tracks[S];var e=q.data;for(var R=0;R<e.length;R++){var B=e[R];if(this.filterSkipNullKeys&&!B.hasOwnProperty(this.filterFeatureBy.comp[T])){continue}var K=G(this.filterFeatureBy.comp[T],B,this.featuresProperties);if(!A(K,this.filterFeatureBy.opp[T],this.filterFeatureBy.value[T],this.filterFeatureBy.cases[T])){B.hide=this.filterType=="and"?true:y[S+":"+R]?false:true;P[S+":"+R]=true}else{y[S+":"+R]=true;if(this.filterType=="or"&&P[S+":"+R]){B.hide=false}}}}}}}else{if(this.graphType=="Network"&&(this.filterNodeBy.comp.length>0||this.filterEdgeBy.comp.length)){for(var T=0;T<this.filterNodeBy.comp.length;T++){if(this.filterNodeBy.comp[T]){for(var S=0;S<this.data.nodes.length;S++){if(this.filterSkipNullKeys&&!this.data.nodes[S].hasOwnProperty(this.filterNodeBy.comp[T])){continue}if(this.data.nodes[S].hide){continue}var K=G(this.filterNodeBy.comp[T],this.data.nodes[S],this.nodesProperties);if(!A(K,this.filterNodeBy.op[T],this.filterNodeBy.value[T],this.filterNodeBy.cases[T])){this.data.nodes[S].hide=this.filterType=="and"?true:y[this.data.nodes[S].id]?false:true;P[this.data.nodes[S].id]=true}else{y[this.data.nodes[S].id]=true;if(this.filterType=="or"&&P[this.data.nodes[S].id]){this.data.nodes[S].hide=false}}}}}for(var T=0;T<this.filterEdgeBy.comp.length;T++){if(this.filterEdgeBy.comp[T]){for(var S=0;S<this.data.edges.length;S++){var z=this.data.nodes[this.data.nodeIndices[this.data.edges[S].id1]];var x=this.data.nodes[this.data.nodeIndices[this.data.edges[S].id2]];var D=z.id+":"+x.id;if(this.filterSkipNullKeys&&!this.data.edges[S].hasOwnProperty(this.filterEdgeBy.comp[T])){continue}var K=G(this.filterEdgeBy.comp[T],this.data.edges[S],this.edgesProperties);if(!A(K,this.filterEdgeBy.op[T],this.filterEdgeBy.value[T],this.filterEdgeBy.cases[T])){this.data.edges[S].hide=this.filterType=="and"?true:y[D]?false:true;P[D]=true}else{y[D]=true;if(this.filterType=="or"&&P[D]){this.data.edges[S].hide=false}}if(!this.data.edges[S].hide){w(z.id);w(x.id)}}}}if(this.filterEdgeBy.comp.length>0){for(var T=0;T<this.data.nodes.length;T++){var b=this.data.nodes[T];if(!c[b.id]){b.hide=true}}}}else{if(this.isCreateHistogram&&!H){if(this.filterVarBy.length>0){var X=this.dataStndBy;var U=this.data.y.histogram;console.log("Not implemented Yet")}}else{if(this.graphType=="Scatter2D"&&this.scatterPlotMatrix&&this.scatterPlotMatrixType.match(/correlation|all/)&&!H){if(this.filterVarBy.length>0){console.log("Not implemented Yet")}}else{if(this.filterDataBy.comp.length>0){var N=[];var f=this.filterDataBy;for(var T=0;T<this.varIndices.length;T++){var K=this.varIndices[T];var V=false;for(var S=0;S<this.smpIndices.length;S++){var L=this.smpIndices[S];for(var R=0;R<f.comp.length;R++){var t=this.data.y[f.comp[R]][K][L];var r=f.value[R]=="No Alteration"?[""]:f.value[R];var C=A(t,f.op[R],r,f.cases[R]);if(this.filterType=="and"&&!H){if(C){V=true}else{V=false;break}}else{if(C){V=true;break}}}if(V){break}}if(V){N.push(K)}}if(H){for(var T=0;T<N.length;T++){this.hiddenVars[N[T]]=true}}}else{if(this.filterVarBy.comp.length>0||this.filterSmpBy.comp.length>0){var N=I(H);var Q=M(H);var n=this.isGroupedData&&this.layoutValid?M(H,true):false;delete this.data.bubble;delete this.data.tree;if(H&&N){for(var T=0;T<N.length;T++){this.hiddenVars[N[T]]=true}}else{if(this.filterMode!="remove"&&N){for(var T=0;T<this.hiddenVars.length;T++){this.hiddenVars[T]=true}for(var T=0;T<N.length;T++){this.hiddenVars[N[T]]=false}}else{if(N){this.varIndices=N}}}if(this.isGroupedData&&!E){if(H&&Q){for(var T=0;T<Q.length;T++){this.hiddenGrps[Q[T]]=true}}else{if(Q){this.grpIndices=Q}}}else{if(H&&Q){for(var T=0;T<Q.length;T++){this.hiddenSmps[Q[T]]=true}if(this.graphType.match(/Scatter/)){if(this.axesType=="X"&&this.xAxisIndices.length>1){if(this.hiddenSmps[this.yAxisIndices[0]]){this.hiddenSmps[this.yAxisIndices[0]]=false}}else{if(this.axesType=="Y"&&this.yAxisIndices.length>1){if(this.hiddenSmps[this.xAxisIndices[0]]){this.hiddenSmps[this.xAxisIndices[0]]=false}}}}}else{if(this.filterMode!="remove"&&Q){for(var T=0;T<this.hiddenSmps.length;T++){this.hiddenSMps[T]=true}for(var T=0;T<Q.length;T++){this.hiddenSmps[Q[T]]=false}}else{if(Q){this.smpIndices=Q}}}}if(n&&H){this.hiddenGrpsLayout=[];for(var T=0;T<n.length;T++){this.hiddenGrpsLayout[n[T]]=true}}else{this.hiddenGrpsLayout=false}}else{this.hiddenGrpsLayout=false}}}}}}if(this.layoutComb&&this.layoutParams&&!this.graphType.match(/Scatter/)){this.restoreEmptyCompartments();var m=this.getObjectArray(this.varIndices);var l=this.getObjectArray(this.smpIndices);for(var T=0;T<this.data.l.comp.length;T++){var O=this.layoutParams[T];var K=O.startingVarIndices;var L=O.startingSmpIndices;var W=O.startingGrpIndices;var Y=[];if(K){for(var S=0;S<K.length;S++){if(m.hasOwnProperty(K[S])){Y.push(K[S])}}O.varIndices=Y}Y=[];if(this.isGroupedData){if(W){for(var S=0;S<W.length;S++){if(l.hasOwnProperty(W[S])){Y.push(W[S])}}O.grpIndices=Y}}else{if(L){for(var S=0;S<L.length;S++){if(l.hasOwnProperty(L[S])){Y.push(L[S])}}O.smpIndices=Y}}}}};this.resetFilters=function(f,b){var e=this;var d=function(g){if(b!=null&&e[g].comp.length>0){e[g].comp.splice(b,1);e[g].op.splice(b,1);e[g].value.splice(b,1);e[g].cases.splice(b,1);e[g].type.splice(b,1)}else{e[g].comp=[];e[g].op=[];e[g].value=[];e[g].cases=[];e[g].type=[]}};var a=f?[f]:["filterSmpBy","filterVarBy","filterNodeBy","filterEdgeBy","filterFeatureBy"];this.hiddenLegends={};for(var c=0;c<a.length;c++){d(a[c])}delete this.data.bubble;delete this.data.tree};this.isHidden=function(b,c,a,d){if(this.graphType=="Network"){return false}else{if(this.graphType=="Boxplot"&&!a){if(!this.showBoxplotOriginalData){if(this.hiddenGrpsLayout){return this.hiddenGrpsLayout[this.data.l.groupLayout[this.layoutCurrent][c]]}else{if(this.hiddenGrps){return this.hiddenVars[b]||this.hiddenGrps[c]}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}}else{if(c!=null){if(this.hiddenGrps){return this.hiddenVars[b]||(d?this.hiddenGrps[c]:this.hiddenSmps[c])}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}else{return this.hiddenVars[b]}}}else{if(this.graphType=="Gantt"){return a?this.hiddenLegends[a]:this.hiddenSmps[c]}else{if(this.graphType=="Dotplot"){return a?this.hiddenLegends[a]:(this.hiddenVars[b]||this.hiddenSmps[c])}else{if(this.graphType=="Bar"&&this.is3DPlot){return a?this.hiddenLegends[a]:this.hiddenVars[b]}else{if(a){return this.hiddenLegends[a]}else{if(this.isGroupedData&&this.hiddenGrps){return this.hiddenVars[b]||this.hiddenGrps[c]}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}}}}}}}};CanvasXpress.prototype.initClusterUtils=function(){this.setDendrograms=function(){if(this.smpDendrogramNewick&&(!this.toDoFilter||!this.toDoFilter.hasOwnProperty("sample"))){this.smpDendrogram={};this.parseNewick(this.smpDendrogramNewick,"smpDendrogram")}if(this.varDendrogramNewick&&(!this.toDoFilter||!this.toDoFilter.hasOwnProperty("variable"))){this.varDendrogram={};this.parseNewick(this.varDendrogramNewick,"varDendrogram")}};this.parseNewick=function(a,d){var k=this;var w=0;var b=[];var t={};var c=0;var g=0;var u=0;var p=0;var j=[];var z=0;var A=0;this[d+"NodeId"]=0;var q=a.split(/\s*(;|\(|\)|,|:)\s*/);var l=function(D){var x=[];for(var C=0;C<D.length;C++){x.push(D[C].mid)}return k.mean(x)};var o=function(C){if(C.children){C.depth=g++;z=Math.max(z,C.depth);for(var x=0;x<C.children.length;x++){o(C.children[x]);if(C.children[x].children){C.children[x].mid=l(C.children[x].children)}}g--;p++}else{C.depth=g;u++}};var e=function(C){if(C.children){for(var x=0;x<C.children.length;x++){e(C.children[x]);if(C.children[x].children){C.children[x].len=1+z-C.children[x].depth}}}else{C.len=1+z-C.depth}};for(var y=0;y<q.length;y++){if(!w){var h=q[y];switch(h){case"(":var B={};t.children=[B];b.push(t);t=B;break;case",":if(b.length>0){var B={};b[b.length-1].children.push(B);t=B}else{w++}break;case")":t=b.pop();t.nodeId=this[d+"NodeId"]++;break;case":":break;default:var m=q[y-1];if(m==")"||m=="("||m==","){t.name=h;if(h&&!t.children){var s=d=="smpDendrogram"?this.getSampleIndices(h):this.getVariableIndices(h);if(s==-1){s=parseInt(h);t.name=d=="smpDendrogram"?this.data.y.smps[s]:this.data.y.vars[s];t.idx=s}else{t.idx=s}j.push(t.idx);t.ord=c++;t.mid=t.ord}}else{if(m==":"){t.height=parseFloat(h);A++}}}}else{if(w<3){this.parseNewick("("+a+")",d);return}else{alert(d+"is not in a valid Newick format");this[d]=false;if(d=="varDendrogram"){this.varDendrogramNewick=false}else{this.smpDendrogramNewick=false}return}}}o(t);e(t);t.max=z+1;t.leafs=u;t.useHeight=A==p;t.mid=l(t.children);t.axis=d;this[d]=t;var r={labl:d=="varDendrogram"?"variable":"sample",show:d=="varDendrogram"?"showVarDendrogram":"showSmpDendrogram",data:d=="varDendrogram"?"vars":"smps",indx:d=="varDendrogram"?"varIndices":"smpIndices",strt:d=="varDendrogram"?"varIndicesStart":this.isGroupedData?"grpIndicesStart":"smpIndicesStart"};if(this[r.show]){var f;if(this[r.strt]<0){if(u!=this.data.y[r.data].length){f="Dude! The length of the "+r.labl+" nodes in the dendrogram ("+u+") is different to that one in the data ("+this.data.y[r.data].length+"). This ain't gonna work!";this.logConsole(f);if(this.verbose){this.flashInfoSpan(100,100,f,3000)}this[r.show]=false}else{if(u!=this[r.indx].length){f="Ooops! Cannot show dendrogram with "+u+" nodes when only "+this[r.indx].length+" "+r.labl+" are visible.";this.logConsole(f);if(this.verbose){this.flashInfoSpan(100,100,f,3000)}this[r.show]=false}else{this[r.indx]=j}}}else{var v=this[r.strt]+this[r.indx].length;this[r.indx]=[];for(var y=this[r.strt];y<v;y++){this[r.indx].push(j[y])}}}else{if(this[r.strt]<0){this[r.indx]=j}else{var v=this[r.strt]+this[r.indx].length;this[r.indx]=[];for(var y=this[r.strt];y<v;y++){this[r.indx].push(j[y])}}}};this.writeNewick=function(b){var d="";if(b.children){var a=[];for(var c=0;c<b.children.length;c++){a.push(this.writeNewick(b.children[c]))}if(a.length>0){d="("+a.join(",")+")"}}else{d=b.idx}if(b.height){d+=":"+this.sprintf("%.1f",b.height)}return d};this.euclidianDistance=function(b,a){b=this.filterNumbers(b,true);a=this.filterNumbers(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=Math.pow(b[c]-a[c],2)}e=Math.sqrt(e)}return e};this.manhattanDistance=function(b,a){b=this.filterNumbers(b,true);a=this.filterNumbers(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=Math.abs(b[c]-a[c])}}return e};this.maxDistance=function(b,a){b=this.filterNumbers(b,true);a=this.filterNumbers(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e=Math.max(e,Math.abs(b[c]-a[c]))}}return e};this.classifyKmeansVector=function(f,c){var e=Number.POSITIVE_INFINITY;var a=0;for(var d=0;d<c.length;d++){var b=this[this.distance+"Distance"](f,c[d]);if(b<e){e=b;a=d}}return a};this.addVectors=function(c,b){c=this.filterNumbers(c,true);b=this.filterNumbers(b,true);var a=[];if(c.length==b.length){for(var d=0;d<c.length;d++){a.push(c[d]+b[d])}}return a};this.compareVectors=function(b,a){if(this.isArray(b)&&this.isArray(a)){if(b.length!=a.length){return false}for(var c=0;c<b.length;c++){if(this.isArray(b[c])&&this.isArray(a[c])){if(!this.compareArrays(b[c],a[c])){return false}}if(b[c]!==a[c]){return false}}return true}};this.vectorDotProduct=function(b,a){b=this.filterNumbers(b,true);a=this.filterNumbers(a,true);var d=0;if(b.length==a.length){for(var c=0;c<b.length;c++){d+=b[c]*a[c]}}return d};this.multiplyVectorByValue=function(a,c){a=this.filterNumbers(a,true);for(var b=0;b<a.length;b++){a[b]*=c}return a};this.getCentroid=function(d,g,f,a){var h=[];if(g.length==a.length){var e=d+f;for(var b=0;b<g.length;b++){h.push((d*g[b]+f*a[b])/e)}}return h};this.createClusterNode=function(i,b,e,f,h,a){var g={id:i,left:b,right:e,dist:f,centroid:h};if(a!=null){g.mid=a}if(b==null&&e==null){g.size=1;g.depth=0}else{g.size=b.size+e.size;g.depth=1+Math.max(b.depth,e.depth)}return g};this.createRandomCentroids=function(c){var b=this;var a=c.slice(0);a.sort(function(){return(Math.round(b.random())-0.5)});return a.slice(0,this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters)};this.createRandomVectors=function(d,g){var c=g.length;if(d>c){return null}var l=[];var f=[];var a={};var m=0;var o=0;var j,b;while(o<d){if(m==c){return null}var h=Math.floor(this.random()*c);if(h in a){continue}a[h]=1;m++;j=g[h];b=true;for(var e=0;e<o;e++){if(this.compareVectors(j,l[e])){b=false;break}}if(b){l[o]=j;f[o]=h;o++}}return{vectors:l,indices:f}};this.imputeDatum=function(a){var d=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];d.push(this.data.y.data[c][a])}}else{for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];d.push(this.data.y.data[a][c])}}return this[this.imputeMethod](d)};this.getIdsForClustering=function(){var e=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];var a=this.getSampleIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}else{for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];var a=this.getVariableIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}return e};this.getDataForClustering=function(){var h=[];var a=[];if(this.clusterAxis=="samples"){for(var c=0;c<this.smpIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[b]){a[b]=this.imputeDatum(f)}g=a[b]}h[b][c]=g}}}else{for(var c=0;c<this.varIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[c]){a[c]=this.imputeDatum(e)}g=a[c]}h[c][b]=g}}}return h};this.cluster=function(){var n=function(){var i=a[s][0].id;var d=a[r][0].id;if(i<0&&d>=0){return true}else{if(i<0&&d<0){return d>i}else{if(i>=0&&d>=0){return i>d}else{return false}}}};var h;var z=this.getDataForClustering();var v=this.getIdsForClustering();var o=[];var e=[];var B=[];var a=[];if(!this.meta.tree){this.meta.tree={}}var u=this.meta.tree;u[this.clusterAxis]=[];for(var y=0;y<z.length;y++){o[y]=[]}o[0][0]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length-1;y++){for(var x=y+1;x<z.length;x++){o[x][x]=Number.POSITIVE_INFINITY;o[y][x]=this[this.distance+"Distance"](z[y],z[x]);o[x][y]=o[y][x]}}for(var y=0;y<z.length;y++){e[y]=0;for(var x=0;x<z.length;x++){if(o[y][e[y]]>o[y][x]){e[y]=x}}}for(var y=0;y<z.length;y++){a[y]=[];a[y][0]=this.createClusterNode(v[y],null,null,0,z[y]);B[y]=1}var b=-1;for(var q=0;q<z.length-1;q++){var s=0;for(var y=0;y<z.length;y++){if(o[y][e[y]]<o[s][e[s]]){s=y}}var r=e[s];if(n()){var c=r;r=s;s=c}var f=a[s][0];var t=a[r][0];var g=this.getCentroid(f.size,f.centroid,t.size,t.centroid);var A=this.createClusterNode(b,f,t,o[s][r],g);a[s].splice(0,0,A);for(var x=0;x<z.length;x++){if(this.linkage=="single"){if(o[s][x]>o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="complete"){if(o[s][x]<o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="average"){o[x][s]=o[s][x]=((B[s]*o[s][x])+(B[r]*o[r][x]))/(B[s]+B[r])}}}}B[s]+=B[r];o[s][s]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length;y++){o[y][r]=o[r][y]=Number.POSITIVE_INFINITY}for(var x=0;x<z.length;x++){if(e[x]==r){e[x]=s}}for(var x=0;x<z.length;x++){for(var w=0;w<z.length;w++){if(o[w][x]<o[w][e[w]]){e[w]=x}}}h=A;u[this.clusterAxis].push([f.id,t.id,h.dist]);b--}return this.writeNewickCluster(h,true)};this.isLeafNode=function(a){if(a.left==null&&a.right==null){return true}else{return false}};this.writeNewickCluster=function(k,g,j){var h="";var e="";var f=false;if(this.isLeafNode(k)){f=true;if(isNaN(k.id)){h=this.clusterAxis=="variables"?this.getVariableIndices(k.id):this.getSampleIndices(k.id)}else{h=k.id}}else{var b;var c=this.writeNewickCluster(k.left,g,true);var a=this.writeNewickCluster(k.right,g,false);if(k.mid){for(var d=0;d<k.mid.length;d++){if(g&&k.mid[d].dist){e+=","+k.mid[d].id+":"+k.mid[d].dist}else{e+=","+k.mid[d].id}e+=k.mid[d].id}}h="("+c+e+","+a+")"}if(g&&!f){h+=":"+this.sprintf("%.1f",k.dist)}return h};this.kmeans=function(){var p=this.getDataForClustering();var q=this.createRandomCentroids(p);var m=new Array(p.length);var b=this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters;var n=new Array(b);var s=0;var v=true;while(v){for(var e=0;e<p.length;e++){m[e]=this.classifyKmeansVector(p[e],q)}v=false;for(var c=0;c<b;c++){var l=[];for(var e=0;e<m.length;e++){if(m[e]==c){l.push(p[e])}}if(!l.length){continue}var o=q[c];var u=new Array(o.length);for(var f=0;f<o.length;f++){var h=0;for(var e=0;e<l.length;e++){if(!isNaN(l[e][f])){h+=l[e][f]}}u[f]=h/l.length;if(u[f]!=o[f]){v=true}}q[c]=u;n[c]=l}s++;if(s>this.maxIterations){v=false}}var r=[];for(var e=0;e<b;e++){r[e]={distance:this[this.distance+"Distance"](q[0],q[e]),assign:e}}r=r.sort(function(g,d){return g.distance-d.distance});var a={};for(var e=0;e<r.length;e++){a[r[e].assign]=e}for(var e=0;e<m.length;e++){var t=a[m[e]]+1;if(t>9){m[e]="K"+t}else{m[e]="K-0"+t}}return m}};CanvasXpress.prototype.initSortUtils=function(){this.sortNetworkIndices=function(h){if(this.isTransition()){return}var g=this.data[this.networkShowDataTable];var c=[h]?h:this.networkShowDataTable=="nodes"?"id":"id1";var b=[];var f=[];for(var e=0;e<g.length;e++){b.push(e);f.push(g[e][c]?g[e][c]:null)}if(this.isNumeric(f)){var a=Number.MAX_VALUE*-1;b.sort(function(j,i){return(f[j]||a)-(f[i]||a)})}else{b.sort(function(j,i){return f[j]>f[i]?1:f[j]<f[i]?-1:0})}var d=[];for(var e=0;e<g.length;e++){d.push(g[b[e]])}if(this.sortDir=="ascending"){d.reverse()}this.data[this.networkShowDataTable]=d;if(this.networkShowDataTable=="nodes"){this.setNodeIndices()}this.draw({func:"sortNetworkIndices",par:[h]})};this.sortOncoprint=function(){if(this.isOncoprint){this.sortIndices("smps","desc",["Altered-Smps"]);this.sortIndices("vars","desc",["Altered-Vars"])}};this.sortIndices=function(d,k,b,c,n,p){var e=this.sortCaseSensitive;var v=function(m,i){if(m==null){m=""}if(i==null){i=""}if(e){return(m.toString()).localeCompare(i.toString())}else{return(m.toString().toLowerCase()).localeCompare(i.toString().toLowerCase())}};var h="";var l;var a=[];var q=this.meta.data;var x=[];for(var s=0;s<this.varIndices.length;s++){x.push(this.varIndices[s])}x.sort(function(m,i){return m-i});var w=[];for(var s=0;s<this.smpIndices.length;s++){w.push(this.smpIndices[s])}w.sort(function(m,i){return m-i});var u=[];if(this.grpIndices&&this.grpIndices.length){for(var s=0;s<this.grpIndices.length;s++){u.push(this.grpIndices[s])}}else{if(this.isGroupedData&&this.data.w){u=this.data.w.grpIdxs}}if(b){b=this.toArray(b)}if(c){c=this.toArray(c)}if(n){n=this.toArray(n)}if(!k){k=this.sortDir}if(b&&d=="vars"){for(var s=0;s<b.length;s++){var f=b[s];a.push(this.data.z[f]);h+=q.z[f].type=="Numeric"?"N":"S"}l="varIndices"}else{if(b&&d=="smps"){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,k,b,c,n,p);this.isGroupedData=true}for(var s=0;s<b.length;s++){var f=b[s];a.push(this.isGroupedData?this.data.w.factors[f]:this.data.x[f]);h+=q.x[f].type=="Numeric"?"N":"S"}l=this.isGroupedData?"grpIndices":"smpIndices"}else{if(p){if(p=="varIndex"||p=="smpIndex"||p=="grpIndex"){j=p=="grpIndex"?u:p=="smpIndex"?w:x;l=p=="grpIndex"?"grpIndices":p=="smpIndex"?"smpIndices":"varIndices";if(this.sortDir=="ascending"){j=j.sort(function(m,i){return m-i})}else{j=j.sort(function(m,i){return i-m})}this[l]=j;if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l]=this.sortDir=="ascending"?this.layoutParams[s][l].sort(function(m,i){return m-i}):this.layoutParams[s][l].sort(function(m,i){return i-m});this.layoutParams[s].dragged=true}}h="I"}else{var s=c?parseInt(this.getVariableIndices(c[0])):parseInt(this.getSampleIndices(n[0]));a.push(this.data.y[p][s]);h="N"}}else{if(c){for(var s=0;s<c.length;s++){a.push(this.getDataForSmpGrpAtIndex(c[s]-1,x,p));h+="N"}l="varIndices"}else{if(n){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,k,b,c,n,p);this.isGroupedData=true}var y=this.isGroupedData&&this.summaryType=="iqr"?this.data.w.median:this.isGroupedData?this.data.w[this.summaryType]:p?this.data.y[p]:this.data.y.data;for(var s=0;s<n.length;s++){var g=n[s]-1;if(!y[g]){g=0}a.push(y[g]);h+="N"}l=this.isGroupedData?"grpIndices":"smpIndices"}else{if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(d,k,b,c,n,p);this.isGroupedData=true}a.push(this.isGroupedData?this.data.w.smps:d=="vars"?this.data.y.vars:this.data.y.smps);l=this.isGroupedData?"grpIndices":d=="vars"?"varIndices":"smpIndices";h="S"}}}}}var j=l=="grpIndices"?u:l=="smpIndices"?w:x;var r=Number.MAX_VALUE*-1;switch(h){case"I":break;case"S":j.sort(function(m,i){return v(a[0][m],a[0][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"N":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"SS":j.sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"SN":j.sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"NN":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"NS":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"SSS":j.sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||v(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||v(a[2][m],a[2][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"SSN":j.sort(function(m,i){return v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||((a[2][m]||r)-(a[2][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){v(a[0][m],a[0][i])||v(a[1][m],a[1][i])||((a[2][m]||r)-(a[2][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"SNS":j.sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||v(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||v(a[2][m],a[2][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"NSS":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||v(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||v(a[2][m],a[2][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"NNN":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||((a[2][m]||r)-(a[2][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||((a[2][m]||r)-(a[2][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"NNS":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||v(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||((a[1][m]||r)-(a[1][i]||r))||v(a[2][m],a[2][i])||(m-i)});this.layoutParams[s].dragged=true}}break;case"NSN":j.sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||((a[2][m]||r)-(a[2][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return((a[0][m]||r)-(a[0][i]||r))||v(a[1][m],a[1][i])||((a[2][m]||r)-(a[2][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break;case"SNN":j.sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||((a[2][m]||r)-(a[2][i]||r))||(m-i)});if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].sort(function(m,i){return v(a[0][m],a[0][i])||((a[1][m]||r)-(a[1][i]||r))||((a[2][m]||r)-(a[2][i]||r))||(m-i)});this.layoutParams[s].dragged=true}}break}if(k!="ascending"&&k!="asc"&&h!="I"){j.reverse();if(this.layoutValid&&this.layoutParams){for(var s=0;s<this.layoutParams.length;s++){this.layoutParams[s][l].reverse();this.layoutParams[s].dragged=true}}}this.sorting=[d,k,b,c,n,p];this[l]=j;if(this.isGroupedData&&l=="grpIndices"&&this.data.w&&this[l].length==this.data.w.grpIdxs.length){this.data.w.grpIdxs=this.cloneObject(j)}};this.sortArray=function(a,b){var d=[];if(a.length!=b.length){return a}for(var c=0;c<a.length;c++){if(a[b[c]]){d[c]=a[b[c]]}else{return a}}return d};this.isAsciiArray=function(a){return !this.isNumeric(a)};this.sortObject=function(b){var a=Object.keys(b);if(this.isAsciiArray(a)){if(this.sortCaseSensitive){return a.sort()}else{return a.sort(function(d,c){return d.toLowerCase().localeCompare(c.toLowerCase())})}}else{return a.sort(function(d,c){return d-c})}};this.stringRangeSort=function(d){var c={};var a;for(var b=0;b<d.length;b++){if(d[b].match(/^\d+\-\d+/)){a=d[b].split(/\-/);c[b]=Number(a[0])}else{if(d[b].match(/^\>\d+/)){a=d[b].split(/\>/);c[b]=Number(a[1])+1e-8}else{if(d[b].match(/^\<\d+/)){a=d[b].split(/\</);c[b]=Number(a[1])-1e-8}else{if(d[b].match(/^\d+/)){a=d[b];c[b]=a}else{return d.sort()}}}}}d.sort(function(f,e){c[f]-c[e]});return d};this.resetSorting=function(){delete this.sorting};this.radixSort=function(n){var h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var e=new Int32Array(n.length);var f=[].concat(h);var g=[].concat(h);var j=[].concat(h);var l=[].concat(h);var a=0;var i;var b=0;var k;var c=0;var m;var d=0;var o;var p;for(p=0;p<n.length;p++){i=n[p]&255;k=(n[p]>>8)&255;m=(n[p]>>16)&255;o=(n[p]>>24)&255^128;f[i]++;g[k]++;j[m]++;l[o]++}for(p=0;p<256;p++){i=a+f[p];k=b+g[p];m=c+j[p];o=d+l[p];f[p]=a;g[p]=b;j[p]=c;l[p]=d;a=i;b=k;c=m;d=o}for(p=0;p<n.length;p++){i=n[p]&255;e[f[i]]=n[p];f[i]++}for(p=0;p<n.length;p++){k=(e[p]>>8)&255;n[g[k]]=e[p];g[k]++}for(p=0;p<n.length;p++){m=(n[p]>>16)&255;e[j[m]]=n[p];j[m]++}for(p=0;p<n.length;p++){o=(e[p]>>24)&255^128;n[l[o]]=e[p];l[o]++}return n};this.resortData=function(){var g={y:{vars:[],smps:[],data:[]}};var h=[];var b=[];var a=this.data.l?true:false;for(var d=0;d<this.varIndices.length;d++){var e=this.varIndices[d];g.y.vars[d]=this.data.y.vars[e];h.push(d)}for(var c=0;c<this.smpIndices.length;c++){var f=this.smpIndices[c];g.y.smps[c]=this.data.y.smps[f];b.push(c)}for(var d=0;d<this.varIndices.length;d++){var e=this.varIndices[d];g.y.data[d]=[];for(var c=0;c<this.smpIndices.length;c++){var f=this.smpIndices[c];g.y.data[d][c]=this.data.y.data[e][f]}}if(this.data.x){g.x={};for(var d in this.data.x){g.x[d]=[];for(var c=0;c<this.smpIndices.length;c++){var f=this.smpIndices[c];g.x[d][c]=this.data.x[d][f]}}}if(this.data.z){g.z={};for(var d in this.data.z){g.z[d]=[];for(var c=0;c<this.varIndices.length;c++){var f=this.varIndices[c];g.z[d][c]=this.data.z[d][f]}}}this.data=g;this.varIndices=h;this.smpIndices=b;this.startingVarIndices=h;this.startingSmpIndices=b;if(this.isGroupedData){this.isGroupedData=false;this.groupSamples(this.groupingFactors,false,false,false,true)}if(this.segregateVariablesBy.length+this.segregateSamplesBy.length>0){this.segregateVariablesAndOrSamples(this.segregateVariablesBy,this.segregateSamplesBy)}}};CanvasXpress.prototype.initNumeric=function(){this.numeric=function(s,m){var M=function(S){var U=this.length,T;for(T=0;T<U;++T){if(this[T]===S){return T}}return -1};var p=(Array.prototype.indexOf)?Array.prototype.indexOf:M;var a=function a(S){var V,U;function T(W){var X=[];while(typeof W==="object"){X.push(W.length);W=W[0]}return X}if(typeof S==="object"){V=S[0];if(typeof V==="object"){U=V[0];if(typeof U==="object"){return T(S)}return[S.length,V.length]}return[S.length]}return[]};var D=function(W,T,S){if(typeof S==="undefined"){S=0}var X=W[S],U=Array(X),V;if(S===W.length-1){for(V=X-2;V>=0;V-=2){U[V+1]=T;U[V]=T}if(V===-1){U[0]=T}return U}for(V=X-1;V>=0;V--){U[V]=D(W,T,S+1)}return U};var R=function(Z,Y){var S=function(ap,ao){var aj,ah,af,ad,ac,ab,al,an,ak,ai,ag,am,aq,ae;ad=ap.length;ac=ao.length;ab=ao[0].length;al=Array(ad);for(aj=ad-1;aj>=0;aj--){an=Array(ab);ak=ap[aj];for(af=ab-1;af>=0;af--){ai=ak[ac-1]*ao[ac-1][af];for(ah=ac-2;ah>=1;ah-=2){ag=ah-1;ai+=ak[ah]*ao[ah][af]+ak[ag]*ao[ag][af]}if(ah===0){ai+=ak[0]*ao[0][af]}an[af]=ai}al[aj]=an}return al};var V=function(ac,ad,ab){var af=ac.length,ae;for(ae=af-1;ae>0;--ae){ab[ae]=ac[ae][ad];--ae;ab[ae]=ac[ae][ad]}if(ae===0){ab[0]=ac[0][ad]}};var W=function(am,al){var an=V,ab=al.length,ao=Array(ab);var ae=am.length,ad=al[0].length,ac=new Array(ae),aj;var ag=aa;var ai,ah,af,ak;--ab;--ae;for(ai=ae;ai!==-1;--ai){ac[ai]=Array(ad)}--ad;for(ai=ad;ai!==-1;--ai){an(al,ai,ao);for(ah=ae;ah!==-1;--ah){ak=0;aj=am[ah];ac[ah][ai]=ag(aj,ao)}}return ac};var T=function(ab,ag){var af=ab.length,ae=ag.length,ad;var ac=Array(af);for(ad=af-1;ad>=0;ad--){ac[ad]=aa(ab[ad],ag)}return ac};var U=function(ai,ah){var aq,ap,ao,al,ak,aj,aw,au,at,af,an,ag,ad,ar,ae,ac,ab,am,av;al=ai.length;ak=ah[0].length;aw=Array(ak);for(ao=ak-1;ao>=0;ao--){af=ai[al-1]*ah[al-1][ao];for(ap=al-2;ap>=1;ap-=2){an=ap-1;af+=ai[ap]*ah[ap][ao]+ai[an]*ah[an][ao]}if(ap===0){af+=ai[0]*ah[0][ao]}aw[ao]=af}return aw};var aa=function(ab,ag){var ad,af=ab.length,ae,ac=ab[af-1]*ag[af-1];for(ad=af-2;ad>=1;ad-=2){ae=ad-1;ac+=ab[ad]*ag[ad]+ab[ae]*ag[ae]}if(ad===0){ac+=ab[0]*ag[0]}return ac};var X=a;switch(X(Z).length*1000+X(Y).length){case 2002:if(Y.length<10){return S(Z,Y)}else{return W(Z,Y)}case 2001:return T(Z,Y);case 1002:return U(Z,Y);case 1001:return aa(Z,Y);case 1000:return mulVS(Z,Y);case 1:return mulSV(Z,Y);case 0:return Z*Y;default:throw new Error("dot only works on vectors and matrices")}};var k=function(X){var V,W,U,Y=X.length,S=Array(Y),T;for(V=Y-1;V>=0;V--){T=Array(Y);W=V+2;for(U=Y-1;U>=W;U-=2){T[U]=0;T[U-1]=0}if(U>V){T[U]=0}T[V]=X[V];for(U=V-1;U>=1;U-=2){T[U]=0;T[U-1]=0}if(U===0){T[0]=0}S[V]=T}return S};var C=function(S){var V=Math.min(S.length,S[0].length),U,T=Array(V);for(U=V-1;U>=1;--U){T[U]=S[U][U];--U;T[U]=S[U][U]}if(U===0){T[0]=S[0][0]}return T};var G=function(S){return k(D([S],1))};var I=function(S,Y,V,T,W){if(T===V.length-1){W(S,Y);return}var U,X=V[T];for(U=X-1;U>=0;U--){I(typeof S==="object"?S[U]:S,typeof Y==="object"?Y[U]:Y,V,T+1,W)}};var L=function(S,Z,W,T,X){if(T===W.length-1){return X(S,Z)}var V,Y=W[T],U=Array(Y);for(V=Y-1;V>=0;--V){U[V]=L(typeof S==="object"?S[V]:S,typeof Z==="object"?Z[V]:Z,W,T+1,X)}return U};var A=function(S,V,T,W){if(T===V.length-1){W(S);return}var U,X=V[T];for(U=X-1;U>=0;U--){A(S[U],V,T+1,W)}};var H=function(S,W,T,X){if(T===W.length-1){return X(S)}var V,Y=W[T],U=Array(Y);for(V=Y-1;V>=0;V--){U[V]=H(S[V],W,T+1,X)}return U};var d=function(){var X=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]+ag[af]}return ae};var Y=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac+ag[af]}return ae};var Z=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]+ag}return ae};var S=arguments.length,V,ab=arguments[0],aa;var T=X,W=Z,U=Y;for(V=1;V!==S;++V){aa=arguments[V];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,T)}else{ab=L(ab,aa,a(ab),0,W)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,U)}else{ab+=aa}}}return ab};var x=function(){var S=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]-ag[af]}return ae};var T=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac-ag[af]}return ae};var V=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]-ag}return ae};var U=arguments.length,Y,ab=arguments[0],aa;var W=S,Z=V,X=T;for(Y=1;Y!==U;++Y){aa=arguments[Y];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,W)}else{ab=L(ab,aa,a(ab),0,Z)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,X)}else{ab-=aa}}}return ab};var c=function(){var Z=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]*ag[af]}return ae};var aa=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac*ag[af]}return ae};var ab=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]*ag}return ae};var S=arguments.length,V,Y=arguments[0],X;var T=Z,W=ab,U=aa;for(V=1;V!==S;++V){X=arguments[V];if(typeof Y==="object"){if(typeof X==="object"){Y=L(Y,X,a(Y),0,T)}else{Y=L(Y,X,a(Y),0,W)}}else{if(typeof X==="object"){Y=L(Y,X,a(X),0,U)}else{Y*=X}}}return Y};var K=function(){var aa=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]/ag[af]}return ae};var ab=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac/ag[af]}return ae};var S=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]/ag}return ae};var T=arguments.length,W,Z=arguments[0],Y;var U=aa,X=S,V=ab;for(W=1;W!==T;++W){Y=arguments[W];if(typeof Z==="object"){if(typeof Y==="object"){Z=L(Z,Y,a(Z),0,U)}else{Z=L(Z,Y,a(Z),0,X)}}else{if(typeof Y==="object"){Z=L(Z,Y,a(Y),0,V)}else{Z/=Y}}}return Z};var h=function(){var ab=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]!==ag[af]}return ae};var S=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac!==ag[af]}return ae};var T=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]!==ag}return ae};var U=arguments.length,X,aa=arguments[0],Z;var V=ab,Y=T,W=S;for(X=1;X!==U;++X){Z=arguments[X];if(typeof aa==="object"){if(typeof Z==="object"){aa=L(aa,Z,a(aa),0,V)}else{aa=L(aa,Z,a(aa),0,Y)}}else{if(typeof Z==="object"){aa=L(aa,Z,a(Z),0,W)}else{aa=aa!==Z}}}return aa};var u=function(){var T=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah[ag])}return ae};var U=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac,ah[ag])}return ae};var X=function(ac,ah){var ad=ac.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah)}return ae};var S=arguments.length,Y,ab=arguments[0],aa;var V=T,Z=X,W=U;for(Y=1;Y!==S;++Y){aa=arguments[Y];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,V)}else{ab=L(ab,aa,a(ab),0,Z)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,W)}else{ab=u(ab,aa)}}}return ab};var w=function(){var X=function(ad,ah){var ae=ah.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad[ag],ah[ag])}return af};var Y=function(ad,ah){var ae=ah.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad,ah[ag])}return af};var aa=function(ad,ah){var ae=ad.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad[ag],ah)}return af};var S=arguments.length,V,ab=arguments[0],Z;var T=X,W=aa,U=Y;for(V=1;V!==S;++V){Z=arguments[V];if(typeof ab==="object"){if(typeof Z==="object"){ab=L(ab,Z,a(ab),0,T)}else{ab=L(ab,Z,a(ab),0,W)}}else{if(typeof Z==="object"){ab=L(ab,Z,a(Z),0,U)}else{ab=w(ab,Z)}}}return ab};var O=function(){var V=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah[ag])}return ae};var X=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac,ah[ag])}return ae};var Z=function(ac,ah){var ad=ac.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah)}return ae};var S=arguments.length,W,ab=arguments[0],aa;var T=V,Y=Z,U=X;for(W=1;W!==S;++W){aa=arguments[W];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,T)}else{ab=L(ab,aa,a(ab),0,Y)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,U)}else{ab=O(ab,aa)}}}return ab};var q=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);for(aa=Y-1;aa!==-1;--aa){Z[aa]=-(V[aa])}return Z};if(typeof S!=="object"){return -(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var v=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);for(aa=Y-1;aa!==-1;--aa){Z[aa]=(V[aa])}return Z};if(typeof S!=="object"){return(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var y=function(S){var X=function(Y){var Z=Y.length;var ab,aa=Array(Z);var V=Math.abs;for(ab=Z-1;ab!==-1;--ab){aa[ab]=V(Y[ab])}return aa};if(typeof S!=="object"){return y(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var f=function(S){var X=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.cos;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return f(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var Q=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.exp;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return Q(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var o=function(T){var S=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.log;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof T!=="object"){return o(T)}var W;var U=S;var X=a(T);return H(T,X,0,U)};var r=function(S){var X=function(V){var Z=V.length;var ab,aa=Array(Z);var Y=Math.sin;for(ab=Z-1;ab!==-1;--ab){aa[ab]=Y(V[ab])}return aa};if(typeof S!=="object"){return r(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var F=function(S){var X=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.sqrt;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return F(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var J=function(S,Y,V){var X=function(aa){var ae=aa.length;var ad,ac;var ab=0;for(ad=ae-1;ad!==-1;--ad){ac=aa[ad];ab+=ac*ac}return ab};var U=0;if(typeof S!=="object"){T=S;U+=T*T;return U}if(typeof Y==="undefined"){Y=a(S)}if(typeof V==="undefined"){V=0}if(V===Y.length-1){return X(S)}var T;var Z=S.length,W;for(W=Z-1;W!==-1;--W){T=arguments.callee(S[W]);U+=T*T}return U};var t=function(aa){var Y,W,U=aa.length,S=aa[0].length,Z=Array(S),V,T,X;for(W=0;W<S;W++){Z[W]=Array(U)}for(Y=U-1;Y>=1;Y-=2){T=aa[Y];V=aa[Y-1];for(W=S-1;W>=1;--W){X=Z[W];X[Y]=T[W];X[Y-1]=V[W];--W;X=Z[W];X[Y]=T[W];X[Y-1]=V[W]}if(W===0){X=Z[0];X[Y]=T[0];X[Y-1]=V[0]}}if(Y===0){V=aa[0];for(W=S-1;W>=1;--W){Z[W][0]=V[W];--W;Z[W][0]=V[W]}if(W===0){Z[0][0]=V[0]}}return Z};var n=function(aa){var Y,W,U=aa.length,S=aa[0].length,Z=Array(S),V,T,X;for(W=0;W<S;W++){Z[W]=Array(U)}for(Y=U-1;Y>=1;Y-=2){T=aa[Y];V=aa[Y-1];for(W=S-1;W>=1;--W){X=Z[W];X[Y]=-T[W];X[Y-1]=-V[W];--W;X=Z[W];X[Y]=-T[W];X[Y-1]=-V[W]}if(W===0){X=Z[0];X[Y]=-T[0];X[Y-1]=-V[0]}}if(Y===0){V=aa[0];for(W=S-1;W>=1;--W){Z[W][0]=-V[W];--W;Z[W][0]=-V[W]}if(W===0){Z[0][0]=-V[0]}}return Z};var l=function(S){return Math.sqrt(J(S))};var j=function(S,W,V){var T=a(S);function U(X,Z){var ab,Y=W[Z],ac=V[Z]-Y,aa=Array(ac);if(Z===T.length-1){for(ab=ac;ab>=0;ab--){aa[ab]=X[ab+Y]}return aa}for(ab=ac;ab>=0;ab--){aa[ab]=U(X[ab+Y],Z+1)}return aa}return U(S,0)};var e=function(S,X,W,V){var T=a(S);function U(Y,ad,aa){var ab,Z=X[aa],ac=W[aa]-Z;if(aa===T.length-1){for(ab=ac;ab>=0;ab--){Y[ab+Z]=ad[ab]}}for(ab=ac;ab>=0;ab--){U(Y[ab+Z],ad[ab],aa+1)}}U(S,V,0);return S};var i=function(T,ab,aa){var W=ab.length,V=aa.length;var Y,X;var S=Array(W),Z,U;for(Y=W-1;Y!==-1;--Y){S[Y]=Array(V);Z=S[Y];U=T[ab[Y]];for(X=V-1;X!==-1;--X){Z[X]=U[aa[X]]}}return S};var B=function(Z,Y){if(typeof Z==="number"||typeof Y==="number"){return c(Z,Y)}var ac=a(Z),aa=a(Y);if(ac.length!==1||aa.length!==1){throw new Error("numeric: tensor product is only defined for vectors")}var U=ac[0],T=aa[0],S=Array(U),ab,W,V,X;for(W=U-1;W>=0;W--){ab=Array(T);X=Z[W];for(V=T-1;V>=3;--V){ab[V]=X*Y[V];--V;ab[V]=X*Y[V];--V;ab[V]=X*Y[V];--V;ab[V]=X*Y[V]}while(V>=0){ab[V]=X*Y[V];--V}S[W]=ab}return S};var g=function g(S,T){this.x=S;this.y=T};g.prototype={};g.prototype.add=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(d(S.x,T.x),d(S.y,T.y))}return new g(d(S.x,T.x),S.y)}if(T.y){return new g(d(S.x,T.x),T.y)}return new g(d(S.x,T.x))};g.prototype.sub=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(S.x,T.x),x(S.y,T.y))}return new g(x(S.x,T.x),S.y)}if(T.y){return new g(x(S.x,T.x),q(T.y))}return new g(x(S.x,T.x))};g.prototype.mul=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(c(S.x,T.x),c(S.y,T.y)),d(c(S.x,T.y),c(S.y,T.x)))}return new g(c(S.x,T.x),c(S.y,T.x))}if(T.y){return new g(c(S.x,T.x),c(S.x,T.y))}return new g(c(S.x,T.x))};g.prototype.reciprocal=function(){if(this.y){var S=d(c(this.x,this.x),c(this.y,this.y));return new g(K(this.x,S),K(q(this.y),S))}return new g(K(1,this.x))};g.prototype.div=function(S){if(!(S instanceof g)){S=new g(S)}if(S.y){return this.mul(S.reciprocal())}if(this.y){return new g(K(this.x,S.x),K(this.y,S.x))}return new g(K(this.x,S.x))};g.prototype.dot=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(R(S.x,T.x),R(S.y,T.y)),d(R(S.x,T.y),R(S.y,T.x)))}return new g(R(S.x,T.x),R(S.y,T.x))}if(T.y){return new g(R(S.x,T.x),R(S.x,T.y))}return new g(R(S.x,T.x))};g.prototype.transpose=function(){var T=t,S=this.x,U=this.y;if(U){return new g(T(S),T(U))}return new g(T(S))};g.prototype.transjugate=function(){var T=t,S=this.x,U=this.y;if(U){return new g(T(S),n(U))}return new g(T(S))};g.prototype.exp=function(){var S=this;var T=Q(S.x);if(S.y){return new g(c(f(S.y),T),c(r(S.y),T))}return new g(T)};g.prototype.conj=function(){var S=this;if(S.y){return new g(S.x,q(S.y))}return new g(S.x)};g.prototype.neg=function(){var S=this;if(S.y){return new g(q(S.x),q(S.y))}return new g(q(S.x))};g.prototype.sin=function(){var S=this;if(S.y){return S.exp().sub(S.neg().exp()).div(new g(0,2))}return new g(r(S.x))};g.prototype.cos=function(){var S=this;if(S.y){return S.exp().add(S.neg().exp()).div(2)}return new g(f(S.x))};g.prototype.abs=function(){var S=this;if(S.y){return new g(F(d(c(S.x,S.x),c(S.y,S.y))))}return new g(y(S.x))};g.prototype.log=function(){var S=this;if(S.y){var T=new g(u(S.y,S.x)),U=S.abs();return new g(o(U.x),T.x)}return new g(o(S.x))};g.prototype.norm2=function(){var S=this;if(S.y){var T=J;return Math.sqrt(T(S.x)+T(S.y))}return l(S.x)};g.prototype.get=function(V){var S=this.x,X=this.y,T=0,U,W=V.length;if(X){while(T<W){U=V[T];S=S[U];X=X[U];T++}return new g(S,X)}while(T<W){U=V[T];S=S[U];T++}return new g(S)};g.prototype.set=function(U,aa){var Y=this.x,W=this.y,T=0,Z,S=U.length,X=aa.x,V=aa.y;if(S===0){if(V){this.y=V}else{if(W){this.y=undefined}}this.x=Y;return this}if(V){if(W){}else{W=D(a(Y),0);this.y=W}while(T<S-1){Z=U[T];Y=Y[Z];W=W[Z];T++}Z=U[T];Y[Z]=X;W[Z]=V;return this}if(W){while(T<S-1){Z=U[T];Y=Y[Z];W=W[Z];T++}Z=U[T];Y[Z]=X;if(X instanceof Array){W[Z]=D(a(X),0)}else{W[Z]=0}return this}while(T<S-1){Z=U[T];Y=Y[Z];T++}Z=U[T];Y[Z]=X;return this};g.prototype.getRows=function(W,U){var Z=U-W+1,T;var X=Array(Z),V,S=this.x,Y=this.y;for(T=W;T<=U;T++){X[T-W]=S[T]}if(Y){V=Array(Z);for(T=W;T<=U;T++){V[T-W]=Y[T]}return new g(X,V)}return new g(X)};g.prototype.setRows=function(X,V,T){var U;var Y=this.x,W=this.y,S=T.x,Z=T.y;for(U=X;U<=V;U++){Y[U]=S[U-X]}if(Z){if(!W){W=D(a(Y),0);this.y=W}for(U=X;U<=V;U++){W[U]=Z[U-X]}}else{if(W){for(U=X;U<=V;U++){W[U]=D([S[U-X].length],0)}}}return this};g.prototype.getRow=function(T){var S=this.x,U=this.y;if(U){return new g(S[T],U[T])}return new g(S[T])};g.prototype.setRow=function(U,T){var W=this.x,V=this.y,S=T.x,X=T.y;W[U]=S;if(X){if(!V){V=D(a(W),0);this.y=V}V[U]=X}else{if(V){V=D([S.length],0)}}return this};g.prototype.getBlock=function(W,V){var T=this.x,U=this.y,S=j;if(U){return new g(S(T,W,V),S(U,W,V))}return new g(S(T,W,V))};g.prototype.setBlock=function(Z,Y,U){if(!(U instanceof g)){U=new g(U)}var T=this.x,X=this.y,S=e,W=U.x,V=U.y;if(V){if(!X){this.y=D(a(this),0);X=this.y}S(T,Z,Y,W);S(X,Z,Y,V);return this}S(T,Z,Y,W);if(X){S(X,Z,Y,D(a(W),0))}};g.rep=function(U,T){if(!(T instanceof g)){T=new g(T)}var S=T.x,W=T.y,V=D;if(W){return new g(V(U,S),V(U,W))}return new g(V(U,S))};g.diag=function(T){if(!(T instanceof g)){T=new g(T)}var S=T.x,U=T.y;if(U){return new g(k(S),k(U))}return new g(k(S))};g.eig=function(){if(this.y){throw new Error("eig: not implemented for complex matrices.")}return N(this.x)};g.identity=function(S){return new g(G(S))};g.prototype.getDiag=function(){var S=this.x,T=this.y;if(T){return new g(C(S),C(T))}return new g(C(S))};var P=function(S){var T=v(S);var U=S[0]>=0?1:-1;var V=U*l(S);T[0]+=V;var W=l(T);if(W===0){throw new Error("eig: internal error")}return K(T,W)};var b=function(ac){var ag=a(ac);if(ag.length!==2||ag[0]!==ag[1]){throw new Error("numeric: toUpperHessenberg() only works on square matrices")}var X=ag[0],aa,Z,Y,ad,af,V=v(ac),U,S,ae,T,ab=G(X),W;for(Z=0;Z<X-2;Z++){ad=Array(X-Z-1);for(aa=Z+1;aa<X;aa++){ad[aa-Z-1]=V[aa][Z]}if(l(ad)>0){af=P(ad);U=j(V,[Z+1,Z],[X-1,X-1]);S=B(af,R(af,U));for(aa=Z+1;aa<X;aa++){ae=V[aa];T=S[aa-Z-1];for(Y=Z;Y<X;Y++){ae[Y]-=2*T[Y-Z]}}U=j(V,[0,Z+1],[X-1,X-1]);S=B(R(U,af),af);for(aa=0;aa<X;aa++){ae=V[aa];T=S[aa];for(Y=Z+1;Y<X;Y++){ae[Y]-=2*T[Y-Z-1]}}U=Array(X-Z-1);for(aa=Z+1;aa<X;aa++){U[aa-Z-1]=ab[aa]}S=B(af,R(af,U));for(aa=Z+1;aa<X;aa++){W=ab[aa];T=S[aa-Z-1];for(Y=0;Y<X;Y++){W[Y]-=2*T[Y]}}}}return{H:V,Q:ab}};var z=function(af,V){if(typeof V==="undefined"){V=10000}af=v(af);var ah=v(af);var ai=a(af),am=ai[0],ae,ag,av,au,at,ar,X,S,W,aa=G(am),ac,ab,al,ak,aj,aq,ao,an,ap;if(am<3){return{Q:aa,B:[[0,am-1]]}}var aw=2.220446049250313e-16;for(ap=0;ap<V;ap++){for(ao=0;ao<am-1;ao++){if(Math.abs(af[ao+1][ao])<aw*(Math.abs(af[ao][ao])+Math.abs(af[ao+1][ao+1]))){var Z=z(j(af,[0,0],[ao,ao]),V);var Y=z(j(af,[ao+1,ao+1],[am-1,am-1]),V);al=Array(ao+1);for(aq=0;aq<=ao;aq++){al[aq]=aa[aq]}ak=R(Z.Q,al);for(aq=0;aq<=ao;aq++){aa[aq]=ak[aq]}al=Array(am-ao-1);for(aq=ao+1;aq<am;aq++){al[aq-ao-1]=aa[aq]}ak=R(Y.Q,al);for(aq=ao+1;aq<am;aq++){aa[aq]=ak[aq-ao-1]}return{Q:aa,B:Z.B.concat(d(Y.B,ao+1))}}}av=af[am-2][am-2];au=af[am-2][am-1];at=af[am-1][am-2];ar=af[am-1][am-1];S=av+ar;X=(av*ar-au*at);W=j(af,[0,0],[2,2]);if(S*S>=4*X){var U,T;U=0.5*(S+Math.sqrt(S*S-4*X));T=0.5*(S-Math.sqrt(S*S-4*X));W=d(x(R(W,W),c(W,U+T)),k(D([3],U*T)))}else{W=d(x(R(W,W),c(W,S)),k(D([3],X)))}ae=[W[0][0],W[1][0],W[2][0]];ag=P(ae);al=[af[0],af[1],af[2]];ak=B(ag,R(ag,al));for(aq=0;aq<3;aq++){ab=af[aq];aj=ak[aq];for(an=0;an<am;an++){ab[an]-=2*aj[an]}}al=j(af,[0,0],[am-1,2]);ak=B(R(al,ag),ag);for(aq=0;aq<am;aq++){ab=af[aq];aj=ak[aq];for(an=0;an<3;an++){ab[an]-=2*aj[an]}}al=[aa[0],aa[1],aa[2]];ak=B(ag,R(ag,al));for(aq=0;aq<3;aq++){ac=aa[aq];aj=ak[aq];for(an=0;an<am;an++){ac[an]-=2*aj[an]}}var ad;for(ao=0;ao<am-2;ao++){for(an=ao;an<=ao+1;an++){if(Math.abs(af[an+1][an])<aw*(Math.abs(af[an][an])+Math.abs(af[an+1][an+1]))){var Z=z(j(af,[0,0],[an,an]),V);var Y=z(j(af,[an+1,an+1],[am-1,am-1]),V);al=Array(an+1);for(aq=0;aq<=an;aq++){al[aq]=aa[aq]}ak=R(Z.Q,al);for(aq=0;aq<=an;aq++){aa[aq]=ak[aq]}al=Array(am-an-1);for(aq=an+1;aq<am;aq++){al[aq-an-1]=aa[aq]}ak=R(Y.Q,al);for(aq=an+1;aq<am;aq++){aa[aq]=ak[aq-an-1]}return{Q:aa,B:Z.B.concat(d(Y.B,an+1))}}}ad=Math.min(am-1,ao+3);ae=Array(ad-ao);for(aq=ao+1;aq<=ad;aq++){ae[aq-ao-1]=af[aq][ao]}ag=P(ae);al=j(af,[ao+1,ao],[ad,am-1]);ak=B(ag,R(ag,al));for(aq=ao+1;aq<=ad;aq++){ab=af[aq];aj=ak[aq-ao-1];for(an=ao;an<am;an++){ab[an]-=2*aj[an-ao]}}al=j(af,[0,ao+1],[am-1,ad]);ak=B(R(al,ag),ag);for(aq=0;aq<am;aq++){ab=af[aq];aj=ak[aq];for(an=ao+1;an<=ad;an++){ab[an]-=2*aj[an-ao-1]}}al=Array(ad-ao);for(aq=ao+1;aq<=ad;aq++){al[aq-ao-1]=aa[aq]}ak=B(ag,R(ag,al));for(aq=ao+1;aq<=ad;aq++){ac=aa[aq];aj=ak[aq-ao-1];for(an=0;an<am;an++){ac[an]-=2*aj[an]}}}}throw new Error("numeric: eigenvalue iteration does not converge -- increase maxiter?")};var N=function(ak,W){var T=b(ak);var X=z(T.H,W);var an=ak.length,at,ap,ar=false,ai=X.B,ae=R(X.Q,R(T.H,t(X.Q)));var Z=new g(R(X.Q,T.Q)),ag;var ao=ai.length,aq;var ax,aw,av,au,V,U,S,ad,ac,aj,ah,ab,aa;var ay=Math.sqrt;for(ap=0;ap<ao;ap++){at=ai[ap][0];if(at===ai[ap][1]){}else{aq=at+1;ax=ae[at][at];aw=ae[at][aq];av=ae[aq][at];au=ae[aq][aq];if(aw===0&&av===0){continue}V=-ax-au;U=ax*au-aw*av;S=V*V-4*U;if(S>=0){if(V<0){ad=-0.5*(V-ay(S))}else{ad=-0.5*(V+ay(S))}ab=(ax-ad)*(ax-ad)+aw*aw;aa=av*av+(au-ad)*(au-ad);if(ab>aa){ab=ay(ab);aj=(ax-ad)/ab;ah=aw/ab}else{aa=ay(aa);aj=av/aa;ah=(au-ad)/aa}ag=new g([[ah,-aj],[aj,ah]]);Z.setRows(at,aq,ag.dot(Z.getRows(at,aq)))}else{ad=-0.5*V;ac=0.5*ay(-S);ab=(ax-ad)*(ax-ad)+aw*aw;aa=av*av+(au-ad)*(au-ad);if(ab>aa){ab=ay(ab+ac*ac);aj=(ax-ad)/ab;ah=aw/ab;ad=0;ac/=ab}else{aa=ay(aa+ac*ac);aj=av/aa;ah=(au-ad)/aa;ad=ac/aa;ac=0}ag=new g([[ah,-aj],[aj,ah]],[[ad,ac],[ac,-ad]]);Z.setRows(at,aq,ag.dot(Z.getRows(at,aq)))}}}var Y=Z.dot(ak).dot(Z.transjugate()),an=ak.length,af=g.identity(an);for(aq=0;aq<an;aq++){if(aq>0){for(ap=aq-1;ap>=0;ap--){var al=Y.get([ap,ap]),am=Y.get([aq,aq]);if(h(al.x,am.x)||h(al.y,am.y)){ad=Y.getRow(ap).getBlock([ap],[aq-1]);ac=af.getRow(aq).getBlock([ap],[aq-1]);af.set([aq,ap],(Y.get([ap,aq]).neg().sub(ad.dot(ac))).div(al.sub(am)))}else{af.setRow(aq,af.getRow(ap));continue}}}}for(aq=0;aq<an;aq++){ad=af.getRow(aq);af.setRow(aq,ad.div(ad.norm2()))}af=af.transpose();af=Z.transjugate().dot(af);return{lambda:Y.getDiag(),E:af}};var E=function(ab){var ag=a(ab),ah=Math.abs,V=ag[0],U=ag[1];var T=v(ab),ad,aa;var ac=G(V),S,af;var Z,Y,W,ab;for(Y=0;Y<U;++Y){var X=-1;var ae=-1;for(Z=Y;Z!==V;++Z){W=ah(T[Z][Y]);if(W>ae){X=Z;ae=W}}aa=T[X];T[X]=T[Y];T[Y]=aa;af=ac[X];ac[X]=ac[Y];ac[Y]=af;ab=aa[Y];for(W=Y;W!==U;++W){aa[W]/=ab}for(W=U-1;W!==-1;--W){af[W]/=ab}for(Z=V-1;Z!==-1;--Z){if(Z!==Y){ad=T[Z];S=ac[Z];ab=ad[Y];for(W=Y+1;W!==U;++W){ad[W]-=aa[W]*ab}for(W=U-1;W>0;--W){S[W]-=af[W]*ab;--W;S[W]-=af[W]*ab}if(W===0){S[0]-=af[0]*ab}}}}return ac};switch(s){case"inv":return E(m);case"eig":return N(m)}}};CanvasXpress.prototype.initjLouvain=function(){this.jLouvain=function(){var l=-1;var k=1e-7;var i;var y;var s={};var a;function d(C){var B={};C.forEach(function(E,D){B[E]=true});return Object.keys(B)}function x(D){var C=[];for(var B in D){if(D.hasOwnProperty(B)){C.push(D[B])}}return C}function v(E,C){var B=E._assoc_mat[C]?Object.keys(E._assoc_mat[C]):[];var D=0;B.forEach(function(F,G){var H=E._assoc_mat[C][F]||1;if(C==F){H*=2}D+=H});return D}function f(D,C){if(typeof D._assoc_mat[C]=="undefined"){return[]}var B=Object.keys(D._assoc_mat[C]);return B}function g(D,C,B){return D._assoc_mat[C]?D._assoc_mat[C][B]:undefined}function A(C){var B=0;C.edges.forEach(function(D){B+=D.weight});return B}function c(D,C){e(D,C);var B=D.edges.map(function(E){return E.id1+"_"+E.id2}).indexOf(C.id1+"_"+C.id2);if(B!=-1){D.edges[B].weight=C.weight}else{D.edges.push(C)}}function z(B){var C={};B.forEach(function(E,D){E.weight=E.weight||1;C[E.id1]=C[E.id1]||{};C[E.id1][E.id2]=E.weight;C[E.id2]=C[E.id2]||{};C[E.id2][E.id1]=E.weight});return C}function e(C,B){C._assoc_mat[B.id1]=C._assoc_mat[B.id1]||{};C._assoc_mat[B.id1][B.id2]=B.weight;C._assoc_mat[B.id2]=C._assoc_mat[B.id2]||{};C._assoc_mat[B.id2][B.id1]=B.weight}function t(D){if(D==null||typeof(D)!="object"){return D}var B=D.constructor();for(var C in D){B[C]=t(D[C])}return B}function p(D,B,C){B.nodes_to_com={};B.total_weight=0;B.internals={};B.degrees={};B.gdegrees={};B.loops={};B.total_weight=A(D);if(typeof C=="undefined"){D.nodes.forEach(function(G,E){B.nodes_to_com[G]=E;var F=v(D,G);if(F<0){throw"Bad graph type, use positive weights!"}B.degrees[E]=F;B.gdegrees[G]=F;B.loops[G]=g(D,G,G)||0;B.internals[E]=B.loops[G]})}else{D.nodes.forEach(function(I,G){var E=C[I];B.nodes_to_com[I]=E;var H=v(D,I);B.degrees[E]=(B.degrees[E]||0)+H;B.gdegrees[I]=H;var J=0;var F=f(D,I);F.forEach(function(K,L){var M=D._assoc_mat[I][K];if(M<=0){throw"Bad graph type, use positive weights"}if(C[K]==E){if(K==I){J+=M}else{J+=M/2}}});B.internals[E]=(B.internals[E]||0)+J})}}function o(C){var E=C.total_weight;var B=0;var D=d(x(C.nodes_to_com));D.forEach(function(F,G){var I=C.internals[F]||0;var H=C.degrees[F]||0;if(E>0){B=B+I/E-Math.pow((H/(2*E)),2)}});return B}function m(D,E,B){var C={};var F=f(E,D);F.forEach(function(G,H){if(G!=D){var I=E._assoc_mat[D][G]||1;var J=B.nodes_to_com[G];C[J]=(C[J]||0)+I}});return C}function u(D,C,E,B){B.nodes_to_com[D]=+C;B.degrees[C]=(B.degrees[C]||0)+(B.gdegrees[D]||0);B.internals[C]=(B.internals[C]||0)+E+(B.loops[D]||0)}function r(D,C,E,B){B.degrees[C]=((B.degrees[C]||0)-(B.gdegrees[D]||0));B.internals[C]=((B.internals[C]||0)-E-(B.loops[D]||0));B.nodes_to_com[D]=-1}function j(F){var D=0;var B=t(F);var C={};var E=Object.keys(F);E.forEach(function(H){var I=F[H];var G=typeof C[I]=="undefined"?-1:C[I];if(G==-1){C[I]=D;G=D;D=D+1}B[H]=G});return B}function b(F,B){var D=true,G=0,E=o(B),C=E;while(D&&G!=l){E=C;D=false;G+=1;F.nodes.forEach(function(J,I){var M=B.nodes_to_com[J];var O=(B.gdegrees[J]||0)/(B.total_weight*2);var L=m(J,F,B);r(J,M,(L[M]||0),B);var N=M;var H=0;var K=Object.keys(L);K.forEach(function(P,Q){var R=L[P]-(B.degrees[P]||0)*O;if(R>H){H=R;N=P}});u(J,N,L[N]||0,B);if(N!=M){D=true}});C=o(B);if(C-E<k){break}}}function h(C,G){var B={nodes:[],edges:[],_assoc_mat:{}};var D,F;var E=x(C);B.nodes=B.nodes.concat(d(E));G.edges.forEach(function(I,H){F=I.weight||1;var L=C[I.id1];var J=C[I.id2];D=(g(B,L,J)||0);var K=(D+F);c(B,{source:L,target:J,weight:K})});return B}function w(C,E){var B=t(C[0]);for(var D=1;D<E+1;D++){Object.keys(B).forEach(function(H,G){var I=H;var F=B[H];B[I]=C[D][F]})}return B}function n(J,D){if(J.edges.length==0){var C={};J.nodes.forEach(function(L,K){C[L]=L});return C}var F={};p(s,F,D);var H=o(F);var I=[];b(s,F);var B=o(F);var G=j(F.nodes_to_com);I.push(G);H=B;var E=h(G,s);p(E,F);while(true){b(E,F);B=o(F);if(B-H<k){break}G=j(F.nodes_to_com);I.push(G);H=B;E=h(G,E);p(E,F)}return I}var q=function(){var B={};var C=n(s,a);return w(C,C.length-1)};q.nodes=function(B){if(arguments.length>0){i=B}return q};q.edges=function(C){if(typeof i=="undefined"){throw"Please provide the graph nodes first!"}if(arguments.length>0){y=C;var B=z(C);s={nodes:i,edges:y,_assoc_mat:B}}return q};q.partition_init=function(B){if(arguments.length>0){a=B}return q};return q}};CanvasXpress.prototype.initMathUtils=function(){this.isNaN=function(a){return isNaN(a)?true:a==Number.POSITIVE_INFINITY?true:a==Number.NEGATIVE_INFINITY?true:false};this.isInteger=function(a){return !isNaN(a)&&(function(b){return(b|0)===b})(parseFloat(a))};this.isFinite=function(a){if(this.isArray(a)){for(var b=0;b<a.length;b++){if(!isFinite(a[b])){return false}}return true}else{return isFinite(a)}};this.getPolar=function(b,e,d,c){return{x:b+d*Math.cos(c*Math.PI/180),y:e+d*Math.sin(c*Math.PI/180)}};this.triCube=function(a){return(a=1-a*a*a)*a*a};this.degreesToArcLength=function(b,a){return b*a};this.radiansToArcLength=function(a,b){return(a*Math.PI*b)/180};this.arcLengthToDegrees=function(b,a){return(a*180)/(b*Math.PI)};this.arcLengthToRadians=function(b,a){return a/b};this.radians=function(a){return a*Math.PI/180};this.degrees=function(a){return a*180/Math.PI};this.getAngle=function(e,h,c,g,d){var b=(Math.atan2(g-h,c-e)*180/Math.PI)%360;if(!d){d=0}while(b<d){b+=360}while(b>=(d+360)){b-=360}return b};this.getRadians=function(d,g,c,e){var b=Math.atan2(e-g,c-d);if(b<0){b+=(2*Math.PI)}return b};this.rotatePoint=function(c,i,b,h,d){var g=Math.cos(d)*(c-b)-Math.sin(d)*(i-h)+b;var e=Math.sin(d)*(c-b)+Math.cos(d)*(i-h)+h;return[g,e]};this.lineLength=function(b,d,a,c){return Math.sqrt(Math.pow(a-b,2)+Math.pow(c-d,2))};this.lineMidPoint=function(b,d,a,c){return[(b+a)/2,(d+c)/2]};this.getCoordinateAtDistance=function(b,j,a,i,h){var c=a-b;var k=i-j;var e=Math.sqrt(Math.pow(c,2)+Math.pow(k,2));var g=h/e;return[b+(c*g),j+(k*g)]};this.parallelLinePoints=function(t,d,r,b,p){var j=r-t;var i=b-d;var q=this.lineLength(t,d,r,b);var x=j/q;var w=i/q;var u=-w;var s=x;var c=t+p*u;var g=d+p*s;var a=t-p*u;var e=d-p*s;var k=r+p*u;var o=b+p*s;var h=r-p*u;var n=b-p*s;return[c,g,a,e,k,o,h,n]};this.perpendicularLinePoints=function(b,o,a,j,c,g){var h=this.lineLength(b,o,a,j);var p=this.lineMidPoint(b,o,a,j);if(!c){c=h*g}var s=a-p[0];var r=j-p[1];var e=s/h;var d=r/h;var q=-d;var n=e;var k=p[0]+c*q;var i=p[1]+c*n;return[k,i]};this.shortenLine=function(g,p,c,o,t,j,u,a){if(this.isNumeric([g,p,c,o,t,j])){if(u.match(/bezier/i)){if(u.match(/beziery/i)){return o>p?[g,p+t,c,o-j]:[g,p-t,c,o+j]}else{return c>g?[g+t,p,c-j,o]:[g-t,p,c+j,o]}}else{if(u.match(/quadratic/i)){var l=this.lineLength(g,p,c,o);var d=this.perpendicularLinePoints(g,p,c,o,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(a))*(a>0?-1:1));var b=this.traceQuadraticCurve(g,p,d[0],d[1],c,o,t/l,true);var r=this.traceQuadraticCurve(c,o,d[0],d[1],g,p,j/l,true);return[b[1][0],b[1][1],r[1][0],r[1][1]]}else{if(u.match(/curved/i)){return[g,p,c,o]}else{var h=Math.atan2(o-p,c-g);var i=Math.cos(h);var n=Math.sin(h);var k=this.lineLength(g,p,c,o);if(k){while(k<(t+j)){t/=1.1;j/=1.1}g+=i*t;p+=n*t;c-=i*j;o-=n*j}return[g,p,c,o]}}}}};this.traceArc=function(c,b,a,n,h,d){if(n>h){var k=n;n=h;h=k}var l=[];var j=((Math.PI*2)-(h-n))/16;l.push([a*Math.cos(n)+c,a*Math.sin(n)+b]);for(var g=0;g<16;g++){n-=j;l.push([a*Math.cos(n)+c,a*Math.sin(n)+b])}return d?l.reverse():l};this.traceArc1=function(c,b,a,o,i,d){if(o>i){var l=o;o=i;i=l}var n=[];var h=Math.PI;var j=i-o;var g=32;var k=j/g;if(k<1e-9){n.push([a*Math.cos(o)+c,a*Math.sin(o)+b])}else{n.push([a*Math.cos(o)+c,a*Math.sin(o)+b]);o+=k;while(o<i){n.push([a*Math.cos(o)+c,a*Math.sin(o)+b]);o+=k}n.push([a*Math.cos(i)+c,a*Math.sin(i)+b])}return d?n:n.reverse()};this.traceQuadraticCurve=function(n,l,e,c,k,j,b,g){var o=[];b=Math.max(0.01,b);var a=function(i,s,r,q){var p=1-i;return p*p*s+2*p*i*r+i*i*q};var d=function(i){return[a(i,n,e,k),a(i,l,c,j)]};for(var h=0;h<=1;h+=b){o.push(d(h))}return g?o:o.reverse()};this.traceBezierCurve=function(k,j,c,b,n,l,h,g,a,d){var o=[];a=Math.max(0.01,a);for(var e=0;e<=1;e+=a){o.push(this.deCasteljau([[k,j],[c,b],[n,l],[h,g]],e))}return d?o:o.reverse()};this.splineControlPoint=function(e,o,d,n,c,l){var p=Math.sqrt(Math.pow(d-e,2)+Math.pow(n-o,2));var i=Math.sqrt(Math.pow(c-d,2)+Math.pow(l-n,2));var h=this.tension*p/(p+i);var g=this.tension-h;var b=d+h*(e-c);var a=n+h*(o-l);var k=d-g*(e-c);var j=n-g*(o-l);return[b,a,k,j]};this.smooth=function(d,g){var n=[];for(var c=0;c<d.length;c++){var a=c-g;var k=a>=0?a:0;var l=c+g+1;var h=0;var e=0;for(var b=k;b<l&&b<d.length;b++){e+=d[b];h++}n[c]=e/h}return n};this.spline=function(e,h){var g=[];var a=e[0];var d=e[1];for(var c=0;c<a.length;c++){g.push(a[c]);g.push(d[c])}var b=this.curvePoints(g,h);a=[];d=[];while(b.length){a.push(b.shift());d.push(b.shift())}return[a,d]};this.curvePoints=function(A,l){var a=[];var B=[];var g=this.tension;var h=this.tensionSegments;l=l?l:false;a=A.slice(0);if(l){a.unshift(A[A.length-1]);a.unshift(A[A.length-2]);a.unshift(A[A.length-1]);a.unshift(A[A.length-2]);a.push(A[0]);a.push(A[1])}else{a.unshift(A[1]);a.unshift(A[0]);a.push(A[A.length-2]);a.push(A[A.length-1])}var e,d,c,p,b,n,r,q,o,k,u;for(var z=2;z<(a.length-4);z+=2){for(var w=0;w<=h;w++){c=(a[z+2]-a[z-2])*g;p=(a[z+4]-a[z])*g;b=(a[z+3]-a[z-1])*g;n=(a[z+5]-a[z+1])*g;u=w/h;r=2*Math.pow(u,3)-3*Math.pow(u,2)+1;q=-(2*Math.pow(u,3))+3*Math.pow(u,2);o=Math.pow(u,3)-2*Math.pow(u,2)+u;k=Math.pow(u,3)-Math.pow(u,2);e=r*a[z]+q*a[z+2]+o*c+k*p;d=r*a[z+1]+q*a[z+3]+o*b+k*n;B.push(e);B.push(d)}}return B};this.hullControlPoints=function(g){var c=this;var g;var e=[];var h=0;var b,a;var d=function(r,p,o){var n=function(t,s){var w=s[0]-t[0];var u=s[1]-t[1];return Math.sqrt(w*w+u*u)};var q=n(r,p);var l=n(p,o);var i=c.tension*q/(q+l);var k=[((r[0]-o[0])*i)+p[0],((r[1]-o[1])*i)+p[1]];var j=[p[0]-((r[0]-o[0])*i),(p[1]-(r[1]-o[1])*i)];return[k,j]};for(b=0;b<g.length-2;b++){e.push.apply(e,d(g[b],g[b+1],g[b+2]))}e.push.apply(e,d(g[b],g[b+1],g[0]));e.push.apply(e,d(g[b+1],g[0],g[1]));return e};this.expandPolygon=function(r,z){var b=function(i){var d=Math.sqrt(i.x*i.x+i.y*i.y);return{x:i.x/d,y:i.y/d}};var u=function(d,i){return{x:d.x*i,y:d.y*i}};var n=function(i,d){return i.x*d.x+i.y*d.y};var c=function(d){return{x:d.y,y:-d.x}};var A=function(d){return{x:-d.y,y:d.x}};var y=function(I,H){var i=I[1].x-I[0].x;var G=H[0].x-H[1].x;var E=H[0].x-I[0].x;var d=I[1].y-I[0].y;var F=H[0].y-H[1].y;var p=H[0].y-I[0].y;var J=(G*p-F*E)/(d*G-i*F);return{x:I[0].x+J*(I[1].x-I[0].x),y:I[0].y+J*(I[1].y-I[0].y)}};var C=function(d){return n(c({x:d[1].x-d[0].x,y:d[1].y-d[0].y}),{x:d[2].x-d[1].x,y:d[2].y-d[1].y})>=0};var w=[];var h=C(r)?A:c;for(var x=0;x<r.length;++x){var l=r[(x>0)?x-1:r.length-1];var j=r[x];var g=r[(x<r.length-1)?x+1:0];var o={x:j[0]-l[0],y:j[1]-l[1]};var B={x:g[0]-j[0],y:g[1]-j[1]};var q=u(b(h(o)),z);var D=u(b(h(B)),z);var t={x:l[0]+q.x,y:l[1]+q.y};var k={x:j[0]+q.x,y:j[1]+q.y};var e={x:j[0]+D.x,y:j[1]+D.y};var s={x:g[0]+D.x,y:g[1]+D.y};var a=y([t,k],[e,s]);w.push([a.x,a.y])}return w};this.enlargePolygon=function(u,A,t){var g=function(i,e,d){return((d.x-i.x)*(e.y-i.y))-((e.x-i.x)*(d.y-i.y))};var B=function(p,s){var e=p.vrs[s];var d=p.vrs[(s+1)%p.vrs.length];var i=p.vrs[(s+p.vrs.length-1)%p.vrs.length];return(g(i,d,e)<0)?true:false};var j=function(s){var i=s.v2.x-s.v1.x;var d=s.v2.y-s.v1.y;var p=Math.sqrt(i*i+d*d);return{x:-d/p,y:i/p}};var r=function(d){var i=j(d);return{x:-i.x,y:-i.y}};var b=function(M){var p={vrs:M};var L=[];var G=(M.length>0)?M[0].x:undefined;var F=(M.length>0)?M[0].y:undefined;var s=G;var d=F;for(var H=0;H<p.vrs.length;H++){M[H].label=String(H);M[H].isReflex=B(p,H);var I={v1:M[H],v2:M[(H+1)%M.length],pol:p,index:H};I.outwardNormal=r(I);I.inwardNormal=j(I);L.push(I);var K=M[H].x;var J=M[H].y;G=Math.min(K,G);F=Math.min(J,F);s=Math.max(K,s);d=Math.max(J,d)}p.edges=L;p.minX=G;p.minY=F;p.maxX=s;p.maxY=d;p.closed=true;return p};var n=function(p,i,d){return{v1:{x:p.v1.x+i,y:p.v1.y+d},v2:{x:p.v2.x+i,y:p.v2.y+d}}};var E=function(p,e){var s=(e.v2.y-e.v1.y)*(p.v2.x-p.v1.x)-(e.v2.x-e.v1.x)*(p.v2.y-p.v1.y);if(s==0){return null}var i=((e.v2.x-e.v1.x)*(p.v1.y-e.v1.y)-(e.v2.y-e.v1.y)*(p.v1.x-e.v1.x))/s;var d=((p.v2.x-p.v1.x)*(p.v1.y-e.v1.y)-(p.v2.y-p.v1.y)*(p.v1.x-e.v1.x))/s;if(i<0||d<0||i>1||d>1){return null}return{x:p.v1.x+i*(p.v2.x-p.v1.x),y:p.v1.y+i*(p.v2.y-p.v1.y)}};var c=function(N,G,d,M,H,s){var L=Math.PI*2;var J=Math.atan2(M.y-G.y,M.x-G.x);var F=Math.atan2(H.y-G.y,H.x-G.x);if(J<0){J+=L}if(F<0){F+=L}var I=((J>F)?(J-F):(J+L-F));var e=((s)?-I:L-I)/t;N.push(M);for(var p=1;p<t;++p){var I=J+e*p;var K={x:G.x+Math.cos(I)*d,y:G.y+Math.sin(I)*d};N.push(K)}N.push(H)};var w=[];var x=[];for(var y=0;y<u.length;y++){x.push({x:u[y][0],y:u[y][1]})}var k=b(x);for(var y=0;y<k.edges.length;y++){var z=k.edges[y];var q=z.outwardNormal.x*A;var l=z.outwardNormal.y*A;w.push(n(z,q,l))}x=[];for(var y=0;y<w.length;y++){var h=w[y];var D=w[(y+w.length-1)%w.length];var o=E(D,h);if(o){x.push(o)}else{var C=k.edges[y].v1;c(x,C,A,D.v2,h.v1,false)}}var a=[];for(var y=0;y<x.length;y++){a.push([x[y].x,x[y].y])}return a};this.sample=function(c,h){if(c){if(!h||h<=0){h=c.length}var e,b;var g=c.slice(0);var d=c.length;var a=d-h;while(d-->a){b=Math.floor((d+1)*this.random());e=g[b];g[b]=g[d];g[d]=e}return g.slice(a)}else{return[]}};this.rep=function(b,c){var g=b.length;var a=[];if(!Array.isArray(b)){return this.rep([b],c)}else{if(!Array.isArray(c)){for(var e=0;e<c;e++){for(var d=0;d<g;d++){a[d+e*g]=b[d]}}}else{if(c.length!=b.length){alert("If x and k are both arrays in 'rep', then they need to have the same length.")}for(var e=0;e<g;e++){for(var d=0;d<c[e];d++){a.push(b[e])}}}}return a};this.seq=function(h,c,g,a){var d=[];if(h!=null&&c!=null&&(a||g)){var b=c<h;if(c<h){var e=h;h=c;c=e}if(a){a=Math.abs(a);g=(c-h)/(a-1)}else{g=Math.abs(g)}if(g){while(c>=h){d.push(h);h+=g}}if(a){d[a-1]=c}else{if(d[d.length-1]<c){d.push(c)}}}return b?d.reverse():d};this.frac=function(j){var h=0;var d=1+1/(j-1);var b=1/(j-1);for(var c=-1,a=0|Math.max(0,Math.ceil((d-h)/b)),g=new Array(a);++c<a;){g[c]=h+c*b}g.splice(j);return g};this.runif=function(g,e,b){var c=[];if(e!=null&&b!=null){for(var d=0;d<g;d++){c.push(this.randomBetween(e,b))}}else{for(var d=0;d<g;d++){c.push(this.random())}}return c};this.dnorm=function(n,c,o,g){if(this.isArray(n)){var j=[];for(var h=0;h<n.length;h++){j[h]=this.dnorm(n[h],c,o,g)}return j}else{var k=function(d,i){if(Number.isNaN(d)||Number.isNaN(i)){return d+i}if(!Number.isFinite(d)||!Number.isFinite(i)){return Number.POSITIVE_INFINITY}return d*Math.pow(2,i)};if(c==null){c=0}if(o==null){o=1}var e=Math.abs((n-c)/o);if(e>=2*Number.MAX_VALUE){return g?Number.NEGATIVE_INFINITY:0}if(g){return -(0.9189385332046728+0.5*e*e+Mat.log(o))}if(e<5){return 0.3989422804014327*Math.exp(-0.5*e*e)/o}if(e>Math.sqrt(-2*0.6931471805599453*(Math.log2(Number.MIN_VALUE)+1-18))){return 0}var b=k(Math.round(k(e,16)),-16);var a=e-b;return 0.3989422804014327/o*(Math.exp(-0.5*b*b)*Math.exp((-0.5*a-b)*a))}};this.rnorm=function(j,b,d){var h=this;var c=[];if(b==null){b=0}if(d==null){d=1}d=Math.sqrt(d);var g=function(){var k,i;var a=2;while(a>1){k=h.random()*2-1;i=h.random()*2-1;a=k*k+i*i}return b+d*k*Math.sqrt(-2*Math.log(a)/a)};for(var e=0;e<j;e++){c.push(g())}return c};this.percentile2=function(a,g){if(a.length===0){return 0}if(typeof g!=="number"){throw new TypeError("p must be a number")}if(g<=0){return a[0]}if(g>=1){return a[a.length-1]}var c=a.length*g;var b=Math.floor(c);var d=b+1;var e=c%1;if(d>=a.length){return a[b]}else{return a[b]*(1-e)+a[d]*e}};this.percentRank=function(a,c){if(typeof c!=="number"){throw new TypeError("v must be a number")}for(var d=0,b=a.length;d<b;d++){if(c<=a[d]){while(d<b&&c===a[d]){d++}if(d===0){return 0}if(c!==a[d-1]){d+=(c-a[d-1])/(a[d]-a[d-1])}return d/b}}return 1};this.percentile=function(d,a,e){var b=a-d;if(b==0){return 50}var c=e-d;return c*100/b};this.percentile3=function(b){if(b.length===0){return b}var e=this.min(b);var a=this.max(b);var c=a-e;var g=[];for(var d=0;d<b.length;d++){var h=b[d]-e;g.push(h/c)}return g};this.rank=function(a){var c=[];for(var b=0;b<a.length;b++){c.push(b)}c.sort(function(e,d){return a[e]-a[d]});return c};this.rank2=function(b){var d=b.slice().sort(function(h,g){return h-g});var e=b.slice().map(function(g){return d.indexOf(g)+1});var c={};e.map(function(g){c[g]=c[g]?c[g]++:1});var a=e.map(function(g){return g/c[g]});return a};this.min=function(b,a,g){if(this.isArray(b)){var e=Number.POSITIVE_INFINITY;if(this.isArray(b[0])){for(var d=0;d<b.length;d++){for(var c=0;c<b[d].length;c++){if(this.isNumber(b[d][c],true)){e=Math.min(e,b[d][c])}}}}else{b=this.cleanArray(b,a,g);for(var d=0;d<b.length;d++){if(this.isNumber(b[d],true)){e=Math.min(e,b[d])}}}return e}else{return this.Min(b,a)}};this.max=function(c,b,g){if(this.isArray(c)){var a=Number.NEGATIVE_INFINITY;if(this.isArray(c[0])){for(var e=0;e<c.length;e++){for(var d=0;d<c[e].length;d++){if(this.isNumber(c[e][d],true)){a=Math.max(a,c[e][d])}}}}else{c=this.cleanArray(c,b,g);for(var e=0;e<c.length;e++){if(this.isNumber(c[e],true)){a=Math.max(a,c[e])}}}return a}else{return this.Max(c,b)}};this.sum=function(b,a,h,e,g){b=this.cleanArray(b,a,h);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]}}else{if(g){if(b[c]<0){d+=b[c]}}else{d+=b[c]}}}return d};this.sumSquared=function(b,a,g,e){b=this.cleanArray(b,a,g);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]*b[c]}}else{d+=b[c]*b[c]}}return d};this.sumSquaredError=function(b,a,h){b=this.cleanArray(b,a,h);var c=this.mean(b);var g=0;for(var e=0;e<b.length;e++){var d=b[e]-c;g+=d*d}return g};this.mean=function(b,a,e){b=this.cleanArray(b,a,e);var c=0;var g=0;for(var d=0;d<b.length;d++){if(!this.isNaN(b[d])){c+=Number(b[d]);g++}}if(g>0){c/=g}return c};this.range=function(c,b,g){c=this.cleanArray(c,b,g);var e=Number.MAX_VALUE;var a=Number.MAX_VALUE*-1;for(var d=0;d<c.length;d++){e=Math.min(c[d],e);a=Math.max(c[d],a)}return e==a&&e==0?[-0.005,0.005]:e==a?[Number(e)-0.005,Number(a)+0.005]:[Number(e),Number(a)]};this.range2D=function(b){var e=Number.MAX_VALUE;var a=Number.MAX_VALUE*-1;for(var d=0;d<b.length;d++){for(var c=0;c<b[d].length;c++){if(this.isNumber(b[d][c],true)){e=Math.min(b[d][c],e);a=Math.max(b[d][c],a)}}}return e==a&&e==0?[0,0.01]:e==a?[Number(e),Number(a)]:[Number(e),Number(a)]};this.median=function(b,a,g){b=this.cleanArray(b,a,g);var e=[];var d=[];var h=0;e[0]=Number.NaN;e[1]=Number.NaN;for(var c=0;c<b.length;c++){d.push(b[c]);h++}if(h>0){e[1]=h;d.sort(function(j,i){return j-i});if(h%2){e[0]=d[parseInt(h/2)]}else{e[0]=(d[parseInt((h-1)/2)]+d[h/2])/2}}return e};this.Abs=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(Math.abs(b[c]))}return d};this.square=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(b[c]*b[c])}return d};this.subtractArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]-e)}return b};this.addArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]+e)}return b};this.replaceArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(e)}return b};this.nextSeed=function(a){if(this.randomMethod=="numericalRecipes"){return(a*9301+49297)%233280}else{a=((a+2127912214)+(a<<12))&4294967295;a=((a^3345072700)^(a>>>19))&4294967295;a=((a+374761393)+(a<<5))&4294967295;a=((a+3550635116)^(a<<9))&4294967295;a=((a+4251993797)+(a<<3))&4294967295;a=((a^3042594569)^(a>>>16))&4294967295;return a}};this.random=function(a){if(this.pseudoRandom){this.randomSeed=this.nextSeed(a||this.randomSeed);return this.randomMethod=="numericalRecipes"?this.randomSeed/233280:(this.randomSeed&268435455)/268435456;return}else{return Math.random()}};this.randomBetween=function(c,a,b){return(this.random(b)*(a-c+1))+c};this.randomInt=function(a){return parseInt(this.random(a))};this.randomIntBetween=function(c,a,b){return Math.floor(this.random(b)*(a-c+1))+c};this.sumarizeErrorData=function(b,a,c){if(this.errorBarsType=="standardErrorMean"){return this.meanStandardErrorN(b,a,c)}else{if(this.errorBarsType=="confidenceInterval95"){return this.mean95ConfidenceIntervalN(b,a,c)}else{return this.meanStandardDeviationN(b,a,c)}}};this.meanStandardErrorN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],Math.sqrt(c[1])/Math.sqrt(c[2]),c[2]]};this.mean95ConfidenceIntervalN=function(b,a,d){var c=this.meanStandardErrorN(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],c[1]*1.96,c[2]]};this.meanStandardDeviationN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[Number.NaN,Number.NaN,Number.NaN]}return[c[0],Math.sqrt(c[1]),c[2]]};this.fivenum=function(a){a.sort(function(i,d){return i-d});var h=a.length;var b=Math.floor((h+3)/2)/2;var g=[1,b,(h+1)/2,h+1-b,h];var e=[];for(var c=0;c<g.length;c++){e.push((a[Math.floor(g[c])-1]+a[Math.ceil(g[c])-1])*0.5)}return e};this.boxplot=function(a,d,c){if(a.length>0){a=this.cleanArray(a,d,c);var e=[];var n=[];var b=this.fivenum(a);var h=this.boxplotHingeFunction=="summary"?this.quantile(a,[0.25,0.75]):[b[1],b[3]];var x=b[0];var s=h[0];var q=b[2];var u=b[2];var p=h[1];var w=b[4];var l=p-s;var r=s-this.boxplotCoef*l;var o=p+this.boxplotCoef*l;var k=(b[3]-b[1])/Math.sqrt(a.length);for(var t=0;t<a.length;t++){if(a[t]<r||a[t]>o){e.push(a[t])}else{n.push(a[t])}}if(e.length>0){var g=this.range(n);x=g[0];w=g[1]}var j=[u-1.58*k,u+1.58*k];return[u,s,q,p,x,w,e,a.length,j]}return[Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN,Number.NaN]};this.quantileBin=function(b,a){if(a<b[0]){return 0}else{if(a>=b[0]&&a<b[1]){return 1}else{if(a>=b[1]&&a<b[2]){return 2}else{if(a>=b[2]){return 3}}}}};this.quantile=function(b,c){b=this.cleanArray(b);b=b.slice().sort(function(g,e){return g-e});var d=b.length-1;var a=c||[0.25,0.5,0.75];return a.map(function(k){if(k===0){return b[0]}else{if(k===1){return b[d]}else{var g=1+k*d;var j=Math.floor(g);var i=g-j;var e=b[j-1];return i===0?e:e+i*(b[j]-e)}}})};this.iqr=function(a){var b=this.quantile(a,[0.25,0.75]);return b[1]-b[0]};this.variance=function(e,g,c,a){e=this.cleanArray(e,g,c);var b=e.length;if(b<1){return a?[Number.NaN,Number.NaN,Number.NaN]:Number.NaN}else{if(b==1){return a?[e[0],0,1]:0}else{var k=this.mean(e);var j=0;var d=b;while(--d>=0){if(!this.isNaN(e[d])){var h=e[d]-k;j+=h*h}}if(a){return this.standardDeviationType=="unbiased"?[k,j/(b-1),b]:[k,j/b,b]}else{return this.standardDeviationType=="unbiased"?j/(b-1):j/b}}}};this.deviation=function(b,a,g){b=this.cleanArray(b,a,g);var h=b.length;if(h<1){return[Number.NaN]}else{if(h==1){return[0]}else{var c=this.mean(b);var d=[];for(var e=0;e<h;e++){if(!this.isNaN(b[e])){d[e]=b[e]-c}else{d[e]=NaN}}return d}}};this.standardDeviation=function(b,a,d){var c=this.variance(b,a,d);if(this.isNaN(c)){return c}return Math.sqrt(c)};this.standardError=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return c[1]}return Math.sqrt(c[1])/Math.sqrt(c[2])};this.meanSquaredError=function(b,a,c){b=this.cleanArray(b,a,c);return this.sumSquaredError(this.sumSquaredError(b,a,c))/b.length};this.confidenceInterval95=function(c,b,d){var a=this.standardError(c,b,d);if(this.isNaN(a)){return a}return a*1.96};this.covariance=function(j,h,e,c){var g=this.cleanArrays(j,h,e,c);j=g[0];h=g[1];var o=0;var a=[];var b=0;var l=this.mean(j);var k=this.mean(h);for(var d=0;d<j.length;d++){a[d]=(j[d]-l)*(h[d]-k);o+=a[d];b++}if(b>0){return o/(this.standardDeviationType=="unbiased"?b-1:b)}else{return NaN}};this.correlation=function(c,b,a,e,d){if(d&&d=="spearman"){return this.correlationSpearman(c,b,a,e)}else{return this.correlationPearson(c,b,a,e)}};this.correlationSpearman=function(p,o,j,g){var l=this.cleanArrays(p,o,j,g);p=l[0];o=l[1];var a=p.length;var b=0;var e=this.rank2(p);var c=this.rank2(o);for(var h=0;h<p.length;h++){var k=e[h]-c[h];b+=k*k}return 1-(6*b/(a*(a*a-1)))};this.correlationPearson=function(c,b,a,d){return this.covariance(c,b,a,d)/this.standardDeviation(c,a,d)/this.standardDeviation(b,a,d)};this.regression=function(l,k,h,b,c,n){var g=[];var j=this.cleanArrays(l,k,h,b);l=j[0];k=j[1];for(var e=0;e<l.length;e++){if(!this.isNaN(l[e])&&!this.isNaN(k[e])){g.push([l[e],k[e]])}}var a=this.regressionType+"Regression";var d=this[a](g);return[d.params[0],d.params[1],d.r2,d.confidence]};this.slope=function(b,d,a,c){return d!=c?(a-b)/(c-d):0};this.intercept=function(a,c,b){return c-(a*b)};this.slopeIntercept=function(b,e,a,d){var c=this.slope(b,e,a,d);return[c,this.intercept(b,e,c)]};this.normalize=function(g){var e=this.standardDeviationType;this.standardDeviationType="biased";for(var c=0;c<g.length;c++){var a=this.meanStandardDeviationN(g[c]);for(var b=0;b<g[c].length;b++){g[c][b]=(g[c][b]-a[0])/a[1]}}this.standardDeviationType=e;return g};this.coefficientDetermination=function(j,g){var c=0;for(var b=0;b<j.length;b++){c+=j[b][1]}var k=c/j.length;var e=0;for(var b=0;b<j.length;b++){var h=j[b][1]-k;e+=h*h}var d=0;for(var b=0;b<j.length;b++){var a=j[b][1]-g[b][1];d+=a*a}return 1-(d/e)};this.gaussianElimination=function(p,b){var q=p;var a=p.length-1;var c=[b];for(var h=0;h<a;h++){var l=h;for(var e=h+1;e<a;e++){if(Math.abs(q[h][e])>Math.abs(q[h][l])){l=e}}for(var d=h;d<a+1;d++){var g=q[d][h];q[d][h]=q[d][l];q[d][l]=g}for(var e=h+1;e<a;e++){for(var d=a;d>=h;d--){q[d][e]-=(q[d][h]*q[h][e])/q[h][h]}}}for(var e=a-1;e>=0;e--){var o=0;for(var d=e+1;d<a;d++){o+=q[d][e]*c[d]}c[e]=(q[a][e]-o)/q[e][e]}return c};this.linearRegression=function(y){var c=[0,0,0,0,0];var t=0;var r=Number.NEGATIVE_INFINITY;var o=Number.POSITIVE_INFINITY;for(var l=0;l<y.length;l++){t++;r=Math.max(r,y[l][0]);o=Math.min(o,y[l][0]);c[0]+=y[l][0];c[1]+=y[l][1];c[2]+=y[l][0]*y[l][0];c[3]+=y[l][0]*y[l][1];c[4]+=y[l][1]*y[l][1]}var j=((t*c[2])-(c[0]*c[0]));var a=((t*c[3])-(c[0]*c[1]));var b=j===0?0:a/j;var w=(c[1]/t)-((b*c[0])/t);var q=[];for(var l=0;l<y.length;l++){q[l]=[y[l][0],(y[l][0]*b)+w]}var e=[];var k=0;var x=0;var s=c[0]/t;var h=Math.max(l-2,1);var d=this.seq(o,r,(r-o)/10);var g=this.tinv(1-this.confidenceLevel,h,true);for(var p=0;p<l;p++){k+=Math.pow(y[p][1]-q[p][1],2);x+=Math.pow(y[p][0]-s,2)}k=Math.sqrt(k/h);for(var p=0;p<d.length;p++){var z=-g*k*Math.sqrt((1/l)+Math.pow(d[p]-s,2)/x);var u=b*d[p]+w;e.push([d[p],u+z,u-z,z])}return{predict:q,params:[b,w],r2:this.coefficientDetermination(y,q),confidence:e,string:w===0?"y = "+b+"x":"y = "+b+"x + "+w}};this.exponentialRegression=function(h){var g=[0,0,0,0,0,0];for(var j=0;j<h.length;j++){g[0]+=h[j][0];g[1]+=h[j][1];g[2]+=h[j][0]*h[j][0]*h[j][1];g[3]+=h[j][1]*Math.log(h[j][1]);g[4]+=h[j][0]*h[j][1]*Math.log(h[j][1]);g[5]+=h[j][0]*h[j][1]}var i=((g[1]*g[2])-(g[5]*g[5]));var d=Math.exp(((g[2]*g[3])-(g[5]*g[4]))/i);var c=((g[1]*g[4])-(g[5]*g[3]))/i;var e=[];for(var j=0;j<h.length;j++){e[j]=[h[j][0],d*Math.exp(c*h[j][0])]}return{predict:e,params:[d,c],r2:this.coefficientDetermination(h,e),confidence:false,string:"y = "+d+"e^("+c+"x)"}};this.logarithmicRegression=function(i){var h=[0,0,0,0];var d=i.length;for(var j=0;j<d;j++){h[0]+=Math.log(i[j][0]);h[1]+=i[j][1]*Math.log(i[j][0]);h[2]+=i[j][1];h[3]+=Math.pow(Math.log(i[j][0]),2)}const c=((d*h[1])-(h[2]*h[0]))/((d*h[3])-(h[0]*h[0]));const e=(h[2]-(c*h[0]))/d;var g=[];for(var j=0;j<i.length;j++){g[j]=[i[j][0],e+(c*Math.log(i[j][0]))]}return{predict:g,params:[e,c],r2:this.coefficientDetermination(i,g),confidence:false,string:"y = "+e+" + "+c+"ln(x)"}};this.powerRegression=function(i){var h=[0,0,0,0,0];var d=i.length;for(var j=0;j<d;j++){h[0]+=Math.log(i[j][0]);h[1]+=Math.log(i[j][1])*Math.log(i[j][0]);h[2]+=Math.log(i[j][1]);h[3]+=Math.pow(Math.log(i[j][0]),2)}var c=((d*h[1])-(h[0]*h[2]))/((d*h[3])-Math.pow(h[0],2));var e=Math.exp(((h[2]-(c*h[0]))/d));var g=[];for(var j=0;j<i.length;j++){g[j]=[i[j][0],e*Math.pow(i[j][0],c)]}return{predict:g,params:[e,c],r2:this.coefficientDetermination(i,g),confidence:false,string:"y = "+e+"x^"+c}};this.polynomialRegression=function(q){this.regressionOrder=2;var h=[];var u=[];var y=0;var x=0;var t=q.length;var o=this.regressionOrder+1;for(var r=0;r<o;r++){for(var g=0;g<t;g++){y+=Math.pow(q[g][0],r)*q[g][1]}h.push(y);y=0;var w=[];for(var p=0;p<o;p++){for(var g=0;g<t;g++){x+=Math.pow(q[g][0],(r+p))}w.push(x);x=0}u.push(w)}u.push(h);var e=this.gaussianElimination(u,o);var z=[];for(var d=0;d<q.length;d++){z[d]=[q[d][0],e[0]+(e[1]*Math.pow(q[d][0],e[2]))]}var s="y = ";for(var r=e.length-1;r>=0;r--){if(r>1){s+=e[r]+"x^"+r+" + "}else{if(r===1){s+=e[r]+"x + "}else{s+=e[r]}}}return{predict:z,params:e.reverse(),r2:this.coefficientDetermination(q,z),confidence:false,string:s}};this.commonElementsInArrays=function(c,b){var a=[];var e={};for(var d=0;d<c.length;d++){e[c[d]]=true}for(var d=0;d<b.length;d++){if(e[b[d]]){a.push(b[d])}}return a};this.checkLoessCache=function(b){var a=this.meta;if(!a.vals.loess){a.vals.loess={}}var c=this.cloneObject(b);c.push(this.loessDegree,this.loessSteps,this.loessSurfaceSteps,this.loessBandwidth,this.loessSpan,this.transformData);c=c.join(":");return a.vals.loess.hasOwnProperty(c)?a.vals.loess[c]:false};this.loess=function(ab,K,T){var o=this.checkLoessCache(T);if(o){return o}var I=this;var Z=function(d){var k=Math.abs(d);var i=1/(1+k/2);var j=i*Math.exp(-k*k-1.26551223+i*(1.00002368+i*(0.37409196+i*(0.09678418+i*(-0.18628806+i*(0.27886807+i*(-1.13520398+i*(1.48851587+i*(-0.82215223+i*0.17087277)))))))));return d>=0?j:2-j};var n=function(d){if(d>=2){return -100}if(d<=0){return 100}var ad=(d<1)?d:2-d;var k=Math.sqrt(-2*Math.log(ad/2));var y=-0.70711*((2.30753+k*0.27061)/(1+k*(0.99229+k*0.04481))-k);for(var i=0;i<2;i++){var w=Z(y)-ad;y+=w/(1.1283791670955126*Math.exp(-(y*y))-y*w)}return(d<1)?y:-y};var aa=function(i,j,d){var k=Math.sqrt(j);return i-k*Math.sqrt(2)*n(2*d)};var R=function(d){var y=Math.ceil(0.1*d.length);var k=I.cloneObject(d);k=k.sort(function(i,ad){return i-ad});for(var j=0;j<y;j++){k.shift();k.pop()}var w=I.standardDeviation(k);return function(i){return i.map(function(ad){return ad/w})}};var a=function(j,d){var w=[];for(var k=0;k<j.length;k++){if(I.isArray(j[k])&&I.isArray(d[k])){w.push(a(j[k],d[k]))}else{w.push(j[k]*d[k])}}return w};var q=function(j,ae){var w=function(d,af,ah){if(ah>1){for(var ag=af;ag<j.length;ag++){w(a(d,j[ag]),ag,ah-1)}}else{ad.push(d)}};var ad=[];var y=Array(j[0].length).fill(1);for(var k=0;k<=ae;k++){w(y,0,k+1)}return ad};var p=function(j,i){if(j.length<2){return Math.abs(j[0]-i[0])}else{return Math.sqrt(j.reduce(function(d,k,w){return d+Math.pow(k-i[w],2)},0))}};var S=function(i,d){return i.map(function(j){return d.map(function(k){return p(j,k)})})};var s=function(k,j,i){return k<j?Math.pow(1-Math.pow(k/j,i),i):0};var t=function(k,j,i){return k.map(function(ad){var af=I.rank(ad);var ae=[];for(var y=0;y<af.length;y++){ae.push([ad[af[y]],j[af[y]]])}var ah=I.sum(j)*i;var d=0;var w=ae.findIndex(function(ai){d+=ai[1];return d>=ah});var ag=i>1?ae[ae.length-1][0]*i:ae[w][0];return a(ad.map(function(ai){return s(ai,ag,3)}),j)})};var u=function(ag,af){var ae=ag.length;var k=ag[0].length;var w=af.length;var ah=af[0].length;var j=new Array(ae);for(var d=0;d<ae;d++){j[d]=new Array(ah);for(var ad=0;ad<ah;ad++){j[d][ad]=0;for(var y=0;y<k;y++){j[d][ad]+=ag[d][y]*af[y][ad]}}}return j};var h=function(w,k){var d=new Array(w.length);for(var ad=0;ad<d.length;ad++){d[ad]=new Array(w[ad].length);for(var y=0;y<d[ad].length;y++){d[ad][y]=w[ad][y]-k[ad][y]}}return d};var z=function(d){var j=[];for(var k=0;k<d.length;k++){j.push(d[k][0])}return j};var L=function(j,k,w){var ae=a(w,k);var af=I.transpose(j.map(function(ah){return a(w,ah)}));var ad=u(j,af);var d=u(j,I.transpose([ae]));var y=u(I.numeric("inv",ad),d);var i=u(I.transpose(y),j);var ag=h([k],i);return{beta:y,yhat:i,residuals:ag}};var e=function(d){b=[];W=[];Q=a(d,N);var i=I.transpose(P);i.forEach(function(k,j){var w=L(ac,J,Q[j]);b.push(z(u([k],w.beta)));W.push(w.residuals);var y=I.median(I.Abs(w.residuals[0]));d[j]=w.residuals.map(function(ad){return s(ad,6*y[0],2)})})};this.loessDegree=parseInt(this.loessDegree);if(this.loessDegree<0||this.loessDegree>2){this.loessDegree=2}this.loessBandWidth=Number(this.loessBandwidth);if(this.loessBandwidth<0||this.loessBandwidth>1){this.loessBandwidth=0.8}this.loessSpan=Number(this.loessSpan);if(this.loessSpan<0||this.loessSpan>1){this.loessSpan=0.8}var C=[ab[0]];var x=[this.loessSteps];var J=ab[1];if(ab[2]){C.push(ab[2]);x.push(this.loessSteps)}if(!K){K=Array(ab[0].length).fill(1)}var ac=q(C,this.loessDegree);var c=C.map(R);var O=C.map(function(i,d){return c[d](i)});var l=this.transposeMatrix(O);var H=[];var M=[];C.forEach(function(af,ag){var d=af.sort(function(ah,i){return ah-i});var j=d[0];var y=d[d.length-1];var k=(y-j)/(x[ag]-1);M.push([]);for(var w=0;w<x[ag];w++){M[ag].push(j+w*k)}var ad=1;var ae=1;for(var w=ag-1;w>=0;w--){ad*=x[w]}for(var w=ag+1;w<C.length;w++){ae*=x[w]}H.push([]);for(var w=0;w<ad;w++){H[ag]=H[ag].concat(M[ag].reduce(function(i,ah){return i.concat(Array(ae).fill(ah))},[]))}});var D=this.cloneObject(H);var Y=H[0].length;var P=q(D,this.loessDegree);var X=D.map(function(i,d){return c[d](i)});var g=S(this.transpose(X),l);var N=t(g,K,this.loessBandwidth);var b;var W;var Q;var F=Array(Y).fill(Array(ab[0].length).fill(1));for(var B=0;B<this.loessIterations;B++){e(F)}var A={fitted:z(b),residuals:W,weights:Q};(function(){var i=aa(0,1,1-(1-I.loessSpan)/2);var d=Q.map(function(ad,k){var w=I.sum(ad);var j=u([ad],I.transpose([ad]));var y=Math.sqrt(u([I.square(W[k][0])],I.transpose([ad]))/(w-j[0]/w));return y*i});Object.assign(A,{halfwidth:d})})();var E=[];if(ab[2]){for(var V=0;V<this.loessSurfaceSteps;V++){var G=[];for(var U=0;U<this.loessSurfaceSteps;U++){G.push(A.fitted[U*this.loessSurfaceSteps+V])}E.push(G)}}if(!this.meta.vals.loess){this.meta.vals.loess={}}var r=this.cloneObject(T);r.push(this.loessDegree,this.loessSteps,this.loessSurfaceSteps,this.loessBandwidth,this.loessSpan);r=r.join(":");if(ab[2]){this.meta.vals.loess[r]={x:M[0],y:M[1],z:E,c:A.halfwidth}}else{this.meta.vals.loess[r]={x:H[0],y:A.fitted,c:A.halfwidth}}return this.meta.vals.loess[r]};this.errorEllipse=function(a,c,b){if(b){return this.errorEllipse3D(a,c,b)}else{return this.errorEllipse2D(a,c)}};this.errorEllipse2D=function(l,h){var j=this.variance(l,false,false,true);var i=this.variance(h,false,false,true);var k=this.covariance(l,h);var o=[[j[1],k],[k,i[1]]];var p=this.numeric("eig",o);var n=Math.sqrt(2*this.gammaPinv(this.confidenceLevel,1));var g=p.lambda.x[0]>p.lambda.x[1]?0:1;var e=p.lambda.x[0]<p.lambda.x[1]?0:1;var b=j[1]>i[1]?Math.sqrt(p.lambda.x[g])*n:Math.sqrt(p.lambda.x[e])*n;var a=i[1]>j[1]?Math.sqrt(p.lambda.x[g])*n:Math.sqrt(p.lambda.x[e])*n;var c=Math.atan2(p.E.x[g][1],p.E.x[g][0]);if(c<0){c+=Math.PI/2}var d={rx:b,ry:a,cx:j[0],cy:i[0],rot:c};return d};this.errorEllipse3D=function(p,o,l){var j=function(z){for(var y=0;y<z.length;y++){for(var x=0;x<z[y].length;x++){if(isNaN(z[y][x])){return false}}}return true};var s=this.variance(p,false,false,true);var r=this.variance(o,false,false,true);var q=this.variance(l,false,false,true);var c=this.covariance(p,o);var b=this.covariance(p,l);var k=this.covariance(o,l);var A=[[s[1],c,b],[c,r[1],k],[b,k,q[1]]];if(j(A)){var n=this.numeric("eig",A);var a=Math.sqrt(2*this.gammaPinv(this.confidenceLevel,1));var g=this.rank(n.lambda.x);var w=g[2];var t=g[1];var u=g[0];var i=Math.sqrt(n.lambda.x[w])*a;var e=Math.sqrt(n.lambda.x[t])*a;var d=Math.sqrt(n.lambda.x[u])*a;var D=Math.atan2(n.E.x[2][w]*-1,n.E.x[1][w]*-1);var C=Math.atan2(n.E.x[2][w]*-1,n.E.x[0][w]*-1);var B=Math.atan2(n.E.x[1][w]*-1,n.E.x[0][w]*-1);if(D<0){}if(C<0){C+=Math.PI/2}if(B<0){}var h={rx:[i],ry:[e],rz:[d],cx:s[0],cy:r[0],cz:q[0],rot:[D,C,B]};return h}else{return false}};this.cdfNormal=function(a,c,b){var a=(a-c)/b;var g=1/(1+0.2315419*Math.abs(a));var h=0.3989423*Math.exp(-a*a/2);var e=h*g*(0.3193815+g*(-0.3565638+g*(1.781478+g*(-1.821256+g*1.330274))));if(a>0){e=1-e}return e};this.cdf=function(c){var b=this.cleanArray(c);var a=this.cloneObject(b);a=a.sort(function(i,h){return i-h});var g=[];var e=b.length;for(var d=0;d<e;d++){g.push((d+1)/e)}return{x:a,y:g}};this.qq=function(c){var h=this.cleanArray(c);var p=this.mean(h);var b=this.standardDeviation(h);var n;var l=this.cloneObject(h);switch(this.qqDistribution){case"normal":n=this.rnorm(this.qqSamples,p,b);case"uniform":n=this.runif(this.qqSamples)}n=n.sort(function(q,i){return q-i});l=l.sort(function(q,i){return q-i});var g=n.length-1;var a=l.length-1;var o=[];var j=[];for(var e=0;e<this.qqPoints;e++){var k=~~(e*g/this.qqPoints);var d=~~(e*a/this.qqPoints);o.push(n[k]);j.push(l[d])}return{x:o,y:this.percentile3(j)}};this.silvermanRule=function(c){var a=Math.sqrt(this.variance(c));var b=4*Math.pow(a,5);var d=3*c.length;return Math.pow(b/d,0.2)};this.nrd0Rule=function(d){var a=Math.sqrt(this.variance(d));var e=this.iqr(d)/1.34;var c=Math.pow(d.length,-0.2);var b=e>0?Math.min(a,e):a;return 0.9*b*c};this.nrdRule=function(d){var a=Math.sqrt(this.variance(d));var e=this.iqr(d)/1.34;var c=Math.pow(d.length,-0.2);var b=e>0?Math.min(a,e):a;return 4*1.06*b*c};this.density=function(u,D){var o=function(j){var F=[];for(var E=0;E<j.length;E++){if(!isNaN(parseFloat(j[E]))&&isFinite(j[E])){F.push(j[E])}}return F};var B=o(u);if(!B.length){return{range:[0,0],median:0,trim:[0,0],xy:[],bw:0,values:[],quantilesX:[],quantilesY:[],indecesY:[],sumY:0,maxY:0,minY:0,minData:0,maxData:0,globalMaxY:0,histogram:{estimator:0.5,breaks:[0.5],count:[0],mids:[0.5],idxs:[[]],size:1,half:0.5,maxY:1,name:D,labels:["Bin 1 (0 - 1)"]},name:D,n:0}}var h=this.range(B);var p=this.median(B);var A=this.hist(B,D);var k=this.calculateDensity(u);var w=h[0];var y=h[1];var n=k.summX;var l=k.summY;var s=k.bw;var a=[];for(var z=0;z<k.x.length;z++){a.push([k.x[z],k.y[z]])}var g=[];var e=[];var r=Number.NEGATIVE_INFINITY;var c=Number.POSITIVE_INFINITY;var b=0;var t,d;for(var z=0;z<k.x.length;z++){if(k.x[z]>w&&k.x[z]<y){if(g.length==0){t=z;g.push(k.x[z-1]);e.push(k.y[z-1]);b+=k.y[z-1];r=Math.max(r,k.y[z-1]);c=Math.min(c,k.y[z-1])}g.push(k.x[z]);e.push(k.y[z]);b+=k.y[z];r=Math.max(r,k.y[z]);c=Math.min(c,k.y[z])}else{if(k.x[z]>=y){d=z;g.push(k.x[z]);e.push(k.y[z]);b+=k.y[z];r=Math.max(r,k.y[z]);c=Math.min(c,k.y[z]);break}}}var C=this[this.axisAlgorithm](0,r,this.yAxisTicks,this.axisWilkinsonLoose);var q=[];for(var z=0;z<6;z++){for(var x=0;x<g.length;x++){if(g[x]>=n[z]){q.push(e[x]);break}}}return{range:h,median:p,trim:[t,Math.max(t,d)],xy:a,bw:s,values:C,quantilesX:n,quantilesY:l,indecesY:q,sumY:b,maxY:r,minY:c,minData:w,maxData:y,globalMaxY:r,histogram:A,name:D,n:B.length}};this.freedmanDiaconis=function(b,a,c){if(b&&b.length>1){b=this.cleanArray(b,a,c);var d=this.iqr(b);return d==0?1:Math.ceil(2*d*Math.pow(b.length,-1/3))}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.sturges=function(b,a,c){if(b&&b.length>1){b=this.cleanArray(b,a,c);return Math.ceil(Math.log(b.length)/Math.LN2)+1}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.scott=function(b,a,e){if(b&&b.length>1){b=this.cleanArray(b,a,e);var c=this.range(b);var d=Math.sqrt(this.vriance(b));return Math.ceil((c[1]-c[0])/(3.5*d*Math.pow(b.length,-1/3)))}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.histBin=function(e,d,g,c){var a=Math.floor((e-d)/g);if(e==c[a]&&a>0){a--}return a};this.hist2D=function(a,s,z){if(this.isArray(a)&&this.isArray(a[0])&&a.length>0){var k=0;for(var w=0;w<s.length;w++){k=Math.max(k,this.meta.data.d.s[s[w].toString()].maxY)}for(var w=0;w<s.length;w++){this.meta.data.d.s[s[w].toString()].globalMaxY=k}var y=[];for(var w=0;w<a.length;w++){y=y.concat(a[w])}var d=this.density(y,z);var r=d.histogram.count.length;var l=d.histogram.size;var p=d.histogram.breaks;var e=this.isTransformedData?this.data.y.trans:this.data.y.data;var t=p[0];var h={data:[],vars:[],smps:[],histogram:[],cols:[],values:[],density:[],global:d.histogram};for(var w=0;w<r;w++){h.vars.push("Bin"+(w+1)+" ("+d.histogram.breaks[w]+" - "+d.histogram.breaks[w+1]+")");h.data[w]=[];h.data[w][0]=p[w+1]-t;h.histogram[w]=[];h.values[w]=[];for(var u=0;u<s.length;u++){h.histogram[w][u]=[];h.values[w][u]=[]}}h.smps.push("Bin");for(var w=0;w<s.length;w++){var q=0;var x=0;h.smps.push(this.data.y.smps[s[w]]);var b=[];for(var u=0;u<r;u++){b[u]=0}for(var u=0;u<this.varIndices.length;u++){var g=e[this.varIndices[u]][s[w]];if(g!=null&&g!==""&&!isNaN(g)){var o=this.histBin(g,t,l,p);b[o]++;h.histogram[o][w].push(this.varIndices[u]);h.values[o][w].push(g);q++}}for(var u=0;u<r;u++){h.data[u][w+1]=b[u];x=Math.max(x,b[u])}h.cols.push(x);h.density[w]=this.meta.data.d.s[s[w].toString()]}return h}};this.hist=function(t,w){var c=this;var r=function(A,i,x){if(c.histogramBinWidth){var z=c.rPretty(A,i,Math.ceil((i-A)/x));A=z[0];i=z.pop();var y=[A];while(y[y.length-1]<i){y.push(y[y.length-1]+c.histogramBinWidth)}return y}else{return c.rPretty(A,i,Math.max(c.histogramBins||10,x))}};var b=this.range(t);var g=b[0];var l=b[0]==b[1]?b[0]+1:b[1];var u=this.histogramBinWidth||this[this.histogramSizeEstimator](t);var j=r(g,l,u);var h=this.approx(j[1]-j[0]);if(h==0){h=(l-g)/j.length}var a=this.approx(h/2);var k=[];var s=[];var q=[];var e=[];if(j[0]>g){j.unshift(j[0]-h)}if(j[j.length-1]<l){j.push(j[j.length-1]+h)}var o=j.length;for(var n=0;n<o-1;n++){k[n]=0;q[n]=[];s[n]=this.approx(j[n]+a)}for(var n=0;n<t.length;n++){var d=this.histBin(t[n],j[0],h,j);k[d]++;q[d].push(n)}var p=-Infinity;for(var n=0;n<k.length;n++){p=Math.max(p,k[n]);e.push("Bin"+(n+1)+" ("+j[n]+" - "+j[n+1]+")")}return{estimator:u,breaks:j,count:k,mids:s,idxs:q,size:h,half:a,maxY:p,name:w,labels:e}};this.getHistogramBin=function(c,a){var d=a*Math.floor(c/a);return parseFloat(d.toFixed(this.getAxisDecimals(a)))};this.approx=function(g){var e=g;var d=g.toString();var j=d.indexOf("99999");var h=d.indexOf("00000");var i=d.indexOf(".");var b=j>=0&&i<j?j:h>=0?h:null;if(b!=null){e=d.substring(0,b);f=Math.pow(10,e.length-(e.indexOf(".")+1));return Number(Math.round(Number(d)*f)/f)}else{return Number(d)}};this.bezierCalculatePoints=function(h,e){var b=h[0][0];var a=h[0][1];var d=h[1][0];var c=h[1][1];var i=b+(d-b)*e;var g=a+(c-a)*e;return[i,g]};this.deCasteljau=function(e,d){if(d===1){return e[e.length-1]}if(d===0){return e[0]}if(e.length==1){return e[0]}var b=[];for(var c=1,a=e.length;c<a;c++){b.push(this.bezierCalculatePoints([e[c-1],e[c]],d))}return this.deCasteljau(b,d)};this.divideBezierCurve=function(g,e,c,h){c=c||[];h=h||[];c.push(g[0]);h.push(g[g.length-1]);if(g.length===1){return[c,h]}var b=[];for(var d=1,a=g.length;d<a;d++){b.push(this.bezierCalculatePoints([g[d-1],g[d]],e))}return this.divideBezierCurve(b,e,c,h)};this.centroid=function(a){var c=[];if(!a||a.length<2){return[0,0]}else{if(a.length<3||a.length%2){return[a[0],a[1]]}else{while(a.length>1){c.push([a.shift(),a.shift()])}}}var b=c.reduce(function(d,e){return[d[0]+e[0]/c.length,d[1]+e[1]/c.length]},[0,0]);return b};this.centroidArea=function(a){var b=this.cloneObject(a);b.shift();return this.centroid(b)};this.prufer=function(c){var b=[];var e=Array.apply(null,Array(c.length+2)).map(function(a,j){return j});var k=Array.apply(null,Array(1*e.length)).map(function(){return 1});c.map(function(a){k[a]++});for(var g=0;g<c.length;g++){for(var d=0;d<e.length;d++){if(k[e[d]]===1){b.push([c[g],e[d]]);k[c[g]]--;k[e[d]]--;break}}}var h=e.filter(function(a){return k[a]===1});b.push(h);return b};this.probabilityOfZ=function(c){var e=6;var d,a,b;if(c==0){a=0}else{d=0.5*Math.abs(c);if(d>(e*0.5)){a=1}else{if(d<1){b=d*d;a=((((((((0.000124818987*b-0.001075204047)*b+0.005198775019)*b-0.019198292004)*b+0.059054035642)*b-0.151968751364)*b+0.319152932694)*b-0.5319230073)*b+0.797884560593)*d*2}else{d-=2;a=(((((((((((((-0.000045255659*d+0.00015252929)*d-0.000019538132)*d-0.000676904986)*d+0.001390604284)*d-0.00079462082)*d-0.002034254874)*d+0.006549791214)*d-0.010557625006)*d+0.011630447319)*d-0.009279453341)*d+0.005353579108)*d-0.002141268741)*d+0.000535310849)*d+0.999936657524}}}return c>0?((a+1)*0.5):((1-a)*0.5)};this.criticalNormalZ=function(e){var h=6;var c=0.000001;var g=-h;var d=h;var b=0;var a;if(e<0){e=0}if(e>1){e=1}while((d-g)>c){a=this.probabilityOfZ(b);if(a>e){d=b}else{g=b}b=(d+g)*0.5}return b};this.kaplanMeier=function(k,b){var h=this;function l(x,i){firstSecond=h.zip(x,i);firstSecond.sort(function(z,y){return z[1]-y[1]});return h.unzip(firstSecond,0)}function u(x,i){return x-i}var t={times:[],events:[]};for(var q=0;q<k.length;q++){if(!isNaN(k[q])){t.times.push(k[q]);if(this.invertCensored){t.events.push(isNaN(b[q])?1:b[q]?0:1)}else{t.events.push(isNaN(b[q])?0:b[q])}}}k=t.times;b=t.events;var d=this.unique(k).sort(u);var r=new Array(d.length);var a=new Array(d.length);var n=new Array(d.length);var e=new Array(d.length);var w=new Array(d.length);var j=new Array(d.length);var o=new Array(d.length);var p=0;b=l(b,k);k.sort(u);for(var g=0;g<d.length;g++){w[g]=k.length;j[g]=0;o[g]=0;for(var q=0;q<k.length;q++){if(k[q]==d[g]){j[g]+=b[q];o[g]+=!b[q]}else{break}}var s=q;r[g]=(1-j[g]/w[g])*((g==0)?1:r[g-1]);p+=j[g]/(w[g]*(w[g]-j[g]));a[g]=Math.sqrt(p)*r[g];n[g]=Math.sqrt(p);e[g]=Math.sqrt(p)/Math.log(r[g]);b=b.slice(s);k=k.slice(s)}var c=this.kaplanMeierConfidence(r,this.confidenceIntervalType=="log"?n:this.confidenceIntervalType=="loglog"?e:a);return{time:d,nAtRisk:w,nEvents:j,nCensored:o,kaplanMeier:r,greenwoodSE:a,greenwoodSELog:n,greenwoodSELogLog:e,lowerLimit:c[0],upperLimit:c[1]}};this.kaplanMeierConfidence=function(b,g){var h=this.criticalNormalZ(this.confidenceLevel);var j=b.length;var c=new Array(j);var e=new Array(j);for(var d=0;d<j;d++){var a=b[d];if(this.confidenceIntervalType=="log"){a=Math.log(a)}if(this.confidenceIntervalType=="loglog"){a=Math.log(-Math.log(a))}c[d]=a-h*g[d];e[d]=a+h*g[d];if(this.confidenceIntervalType=="log"){c[d]=Math.exp(c[d]);e[d]=Math.exp(e[d])}if(this.confidenceIntervalType=="loglog"){c[d]=Math.exp(-Math.exp(c[d]));e[d]=Math.exp(-Math.exp(e[d]))}c[d]=Math.max(0,c[d]);e[d]=Math.min(1,e[d])}return[c,e]};this.getD3Sankey=function(){var i=function(G,F){return G<F?-1:G>F?1:G>=F?0:NaN};var g=function(K,I){var H=0,J=K.length,F,G=-1;if(I==null){while(++G<J){if(F=+K[G]){H+=F}}}else{while(++G<J){if(F=+I(K[G],G,K)){H+=F}}}return H};var w=function(K,I){var H=-1,J=K.length,G,F;if(I==null){while(++H<J){if((F=K[H])!=null&&F>=F){G=F;break}}while(++H<J){if((F=K[H])!=null&&G>F){G=F}}}else{while(++H<J){if((F=I(K[H],H,K))!=null&&F>=F){G=F;break}}while(++H<J){if((F=I(K[H],H,K))!=null&&G>F){G=F}}}return G};var A=function(G,F){return G=+G,F-=G,function(H){return G+F*H}};var y="$";function k(){}k.prototype=D.prototype={constructor:k,has:function(F){return(y+F) in this},get:function(F){return this[y+F]},set:function(F,G){this[y+F]=G;return this},remove:function(F){var G=y+F;return G in this&&delete this[G]},clear:function(){for(var F in this){if(F[0]===y){delete this[F]}}},keys:function(){var F=[];for(var G in this){if(G[0]===y){F.push(G.slice(1))}}return F},values:function(){var F=[];for(var G in this){if(G[0]===y){F.push(this[G])}}return F},entries:function(){var F=[];for(var G in this){if(G[0]===y){F.push({key:G.slice(1),value:this[G]})}}return F},size:function(){var F=0;for(var G in this){if(G[0]===y){++F}}return F},empty:function(){for(var F in this){if(F[0]===y){return false}}return true},each:function(G){for(var F in this){if(F[0]===y){G(this[F],F.slice(1),this)}}}};function D(F,I){var J=new k;if(F instanceof k){F.each(function(N,M){J.set(M,N)})}else{if(Array.isArray(F)){var H=-1,L=F.length,K;if(I==null){while(++H<L){J.set(H,F[H])}}else{while(++H<L){J.set(I(K=F[H],H,F),K)}}}else{if(F){for(var G in F){J.set(G,F[G])}}}}return J}var C=function(){var J=[],L=[],I,K,H;function G(S,Q,O,T){if(Q>=J.length){return K!=null?K(S):(I!=null?S.sort(I):S)}var R=-1,M=S.length,W=J[Q++],P,U,N=D(),V,X=O();while(++R<M){if(V=N.get(P=W(U=S[R])+"")){V.push(U)}else{N.set(P,[U])}}N.each(function(Y,Z){T(X,Z,G(Y,Q,O,T))});return X}function F(N,O){if(++O>J.length){return N}var P,M=L[O-1];if(K!=null&&O>=J.length){P=N.entries()}else{P=[],N.each(function(R,Q){P.push({key:Q,values:F(R,O)})})}return M!=null?P.sort(function(R,Q){return M(R.key,Q.key)}):P}return H={object:function(M){return G(M,0,t,q)},map:function(M){return G(M,0,u,E)},entries:function(M){return F(G(M,0,u,E),0)},key:function(M){J.push(M);return H},sortKeys:function(M){L[J.length-1]=M;return H},sortValues:function(M){I=M;return H},rollup:function(M){K=M;return H}}};function t(){return{}}function q(F,G,H){F[G]=H}function u(){return D()}function E(H,F,G){H.set(F,G)}var n={};var e=12;var j=5;var o=[1,1];var r=[];var d=[];n.nodeWidth=function(F){if(!arguments.length){return e}e=+F;return n};n.nodePadding=function(F){if(!arguments.length){return j}j=+F;return n};n.nodes=function(F){if(!arguments.length){return r}r=F;return n};n.links=function(F){if(!arguments.length){return d}d=F;return n};n.size=function(F){if(!arguments.length){return o}o=F;return n};n.layout=function(F){c();l();a();h(F);b();x();return n};n.relayout=function(){b();x();return n};n.link=function(){var G=0.5;function F(O){var L=O.source.x+O.source.dx,K=O.target.x,J=A(L,K),I=J(G),H=J(1-G),N=O.source.y+O.sy+O.dy/2,M=O.target.y+O.ty+O.dy/2;return"M"+L+","+N+"C"+I+","+N+" "+H+","+M+" "+K+","+M}F.curvature=function(H){if(!arguments.length){return G}G=+H;return F};return F};function x(){var F=0.5;d.forEach(function(N){var K=N.source.x+N.source.dx,J=N.target.x,I=A(K,J),H=I(F),G=I(1-F),M=N.source.y+N.sy+N.dy/2,L=N.target.y+N.ty+N.dy/2;N.bezier=[[K,H,G,J],[M,M,L,L]]})}function c(){r.forEach(function(F){F.sourceLinks=[];F.targetLinks=[]});d.forEach(function(F){var G=F.source,H=F.target;if(typeof G==="number"){G=F.source=r[F.source]}if(typeof H==="number"){H=F.target=r[F.target]}G.sourceLinks.push(F);H.targetLinks.push(F)})}function l(){r.forEach(function(F){F.value=Math.max(g(F.sourceLinks,s),g(F.targetLinks,s))})}function a(){var G=r,H,F=0;while(G.length){H=[];G.forEach(function(I){I.x=F;I.breadth=F;I.dx=e;I.sourceLinks.forEach(function(J){H.push(J.target)})});G=H;++F}z(F);p((o[0]-e)/(F-1))}function z(F){r.forEach(function(G){if(!G.sourceLinks.length){G.x=F-1}})}function p(F){r.forEach(function(G){G.x*=F})}function h(K){var F=C().key(function(N){return N.x}).sortKeys(i).entries(r).map(function(N){return N.values});I();M();for(var L=1;K>0;--K){G(L*=0.99);M();H(L);M()}function I(){var N=w(F,function(O){return(o[1]-(O.length-1)*j)/g(O,s)});F.forEach(function(O){O.forEach(function(Q,P){Q.y=P;Q.dy=Q.value*N})});d.forEach(function(O){O.dy=O.value*N})}function H(O){F.forEach(function(P,Q){P.forEach(function(R){if(R.targetLinks.length){var S=g(R.targetLinks,N)/g(R.targetLinks,s);R.y+=(S-B(R))*O}})});function N(P){return B(P.source)*P.value}}function G(O){F.slice().reverse().forEach(function(P){P.forEach(function(Q){if(Q.sourceLinks.length){var R=g(Q.sourceLinks,N)/g(Q.sourceLinks,s);Q.y+=(R-B(Q))*O}})});function N(P){return B(P.target)*P.value}}function M(){F.forEach(function(O){var R,N,Q=0,S=O.length,P;O.sort(J);for(P=0;P<S;++P){R=O[P];N=Q-R.y;if(N>0){R.y+=N}Q=R.y+R.dy+j}N=Q-j-o[1];if(N>0){Q=R.y-=N;for(P=S-2;P>=0;--P){R=O[P];N=R.y+R.dy+j-Q;if(N>0){R.y-=N}Q=R.y}}})}function J(O,N){return O.y-N.y}}function b(){r.forEach(function(H){H.sourceLinks.sort(F);H.targetLinks.sort(G)});r.forEach(function(I){var J=0,H=0;I.sourceLinks.forEach(function(K){K.sy=J;J+=K.dy});I.targetLinks.forEach(function(K){K.ty=H;H+=K.dy})});function G(I,H){return I.source.y-H.source.y}function F(I,H){return I.target.y-H.target.y}}function B(F){return F.y+F.dy/2}function s(F){return F.value}return n};this.setSankey=function(){var a=this.getD3Sankey();a.nodeWidth(this.sankeyNodeWidth);a.nodePadding(this.margin);if(this.isDOE){a.size([this.x-(this.margin*6),this.y])}else{a.size([this.x,this.y])}a.nodes(this.data.sankey.nodes);a.links(this.data.sankey.links);a.layout(this.sankeyIterations);this.data.sankey.object=a};this.getD3Tree=function(){var b=this;var n=function(B,A,z){var C=z/(A.i-B.i);A.c-=C;A.s+=z;B.c+=C;A.z+=z;A.m+=z};var g=function(B){var A=0;var E=0;var D=B.children;var C=D.length;var z;while(--C>=0){z=D[C];z.z+=A;z.m+=A;A+=z.s+(E+=z.c)}};var a=function(A,z,B){return A.a.parent===z.parent?A.a:B};var t=function(z){var A=z.children;return A?A[0]:z.t};var y=function(z){var A=z.children;return A?A[A.length-1]:z.t};var e=function(A,z){return A.parent===z.parent?1:2};var j=1;var h=1;var p=null;var i=function(C,A){if(C===A){return C}var B=C.ancestors();var z=A.ancestors();var D=null;C=B.pop();A=z.pop();while(C===A){D=C;C=B.pop();A=z.pop()}return D};var d=function(z){z.data=z.data.data};var k=function(A){var z=0;do{A.height=z}while((A=A.parent)&&(A.height<++z))};var c=function(F,B){var I=new x(F);var G=+F.value&&(I.value=F.value);var D;var z=[I];var A;var H;var E;var C;if(B==null){B=function(J){return J.children}}while(D=z.pop()){if(G){D.value=+D.data.value}if((H=B(D.data))&&(C=H.length)){D.children=new Array(C);for(E=C-1;E>=0;--E){z.push(A=D.children[E]=new x(H[E]));A.parent=D;A.depth=D.depth+1}}}return I.eachBefore(k)};var x=function(z){this.data=z;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=b.treeNodeId++}};x.prototype=c.prototype={constructor:x,count:function(){return this.eachAfter(count)},each:function(F){var C=this;var D;var B=[C];var A,z,E;do{D=B.reverse();B=[];while(C=D.pop()){F(C);A=C.children;if(A){for(z=0,E=A.length;z<E;++z){B.push(A[z])}}}}while(B.length);return this},eachAfter:function(F){var D=this;var z=[D];var C=[];var B,A,E;while(D=z.pop()){C.push(D);B=D.children;if(B){for(A=0,E=B.length;A<E;++A){z.push(B[A])}}}while(D=C.pop()){F(D)}return this},eachBefore:function(D){var C=this;var z=[C];var B,A;while(C=z.pop()){D(C);B=C.children;if(B){for(A=B.length-1;A>=0;--A){z.push(B[A])}}}return this},sum:function(z){return this.eachAfter(function(D){var C=+z(D.data)||0;var B=D.children;var A=B&&B.length;while(--A>=0){C+=B[A].value}D.value=C})},sort:function(z){return this.eachBefore(function(A){if(A.children){A.children.sort(z)}})},path:function(z){var D=this;var C=i(D,z);var B=[D];while(D!==C){D=D.parent;B.push(D)}var A=B.length;while(z!==C){B.splice(A,0,z);z=z.parent}return B},ancestors:function(){var A=this;var z=[A];while(A=A.parent){z.push(A)}return z},descendants:function(){var z=[];this.each(function(A){z.push(A)});return z},leaves:function(){var z=[];this.eachBefore(function(A){if(!A.children){z.push(A)}});return z},links:function(){var z=this;var A=[];z.each(function(B){if(B!==z){A.push({source:B.parent,target:B})}});return A},copy:function(){return c(this).eachBefore(d)}};var r=function(A,z){this._=A;this.parent=null;this.children=null;this.A=null;this.a=this;this.z=0;this.m=0;this.c=0;this.s=0;this.t=null;this.i=z};r.prototype=Object.create(x.prototype);var s=function(A){var z=new r(A,0);var E;var B=[z];var G;var D;var C;var F;while(E=B.pop()){if(D=E._.children){E.children=new Array(F=D.length);for(C=F-1;C>=0;--C){B.push(G=E.children[C]=new r(D[C],C));G.parent=E}}}(z.parent=new r(null,0)).children=[z];return z};function l(E){var G=s(E);G.eachAfter(w),G.parent.m=-G.z;G.eachBefore(q);if(p){E.eachBefore(u)}else{var A=E;var F=E;var z=E;E.eachBefore(function(I){if(I.x<A.x){A=I}if(I.x>F.x){F=I}if(I.depth>z.depth){z=I}});var H=A===F?1:e(A,F)/2;var B=H-A.x;var D=j/(F.x+H+B);var C=h/(z.depth||1);E.eachBefore(function(I){I.x=(I.x+B)*D;I.y=I.depth*C})}return E}function w(A){var C=A.children;var D=A.parent.children;var z=A.i?D[A.i-1]:null;if(C){g(A);var B=(C[0].z+C[C.length-1].z)/2;if(z){A.z=z.z+e(A._,z._);A.m=A.z-B}else{A.z=B}}else{if(z){A.z=z.z+e(A._,z._)}}A.parent.A=o(A,z,A.parent.A||D[0])}function q(z){z._.x=z.z+z.parent.m;z.m+=z.parent.m}function o(K,J,E){if(J){var B=K;var A=K;var D=J;var C=B.parent.children[0];var G=B.m;var F=A.m;var I=D.m;var H=C.m;var z;while(D=y(D),B=t(B),D&&B){C=t(C);A=y(A);A.a=K;z=D.z+I-B.z-G+e(D._,B._);if(z>0){n(a(D,K,E),K,z);G+=z;F+=z}I+=D.m;G+=B.m;H+=C.m;F+=A.m}if(D&&!y(A)){A.t=D;A.m+=I-F}if(B&&!t(C)){C.t=B;C.m+=G-H;E=K}}return E}function u(z){z.x*=j;z.y=z.depth*h}l.separation=function(z){return arguments.length?(e=z,l):e};l.size=function(z){return arguments.length?(p=false,j=+z[0],h=+z[1],l):(p?null:[j,h])};l.nodeSize=function(z){return arguments.length?(p=true,j=+z[0],h=+z[1],l):(p?[j,h]:null)};l.setTree=function(A,z){return c(A,z)};l.collapse=function(z){l.collapseTree(z);l.update(z)};l.expand=function(z){l.expandTree(z);l.update(z)};l.collapseTree=function(z){if(z.children){z._children=z.children;z._children.forEach(l.collapseTree);z.children=null}};l.expandTree=function(z){if(z._children){z.children=z._children;z.children.forEach(l.expandTree);delete z._children}};return l};this.setTree=function(){var b=[];var c=this.isDOE?this.margin*6:0;if(this.treeCircular){b=this.x>this.y?[360,this.y/2]:[360,this.x/2]}else{b=[this.graphOrientation=="vertical"?this.x-c:this.y,this.graphOrientation=="vertical"?this.y:this.x-c]}var a=function(e,d){return(e.parent==d.parent?1:2)/e.depth};this.data.tree.object=this.treeCircular?this.getD3Tree().size(b).separation(a):this.getD3Tree().size(b);if(!this.data.tree.root){this.data.tree.root=this.getD3Tree().setTree(this.data.tree.data,function(e){return e.children})}this.data.tree.plot=this.data.tree.object(this.data.tree.root);this.data.tree.plot.size=b};this.getD3CirclePack=function(){var n=this;var t=function(N,L){if(N===L){return N}var M=N.ancestors();var K=L.ancestors();var O=null;N=M.pop();L=K.pop();while(N===L){O=N;N=M.pop();L=K.pop()}return O};var q=function(K){K.data=K.data.data};var z=function(L){var K=0;do{L.height=K}while((L=L.parent)&&(L.height<++K))};var o=function(Q,M){var T=new I(Q);var R=+Q.value&&(T.value=Q.value);var O;var K=[T];var L;var S;var P;var N;if(M==null){M=function(U){return U.children}}while(O=K.pop()){if(R){O.value=+O.data.value}if((S=M(O.data))&&(N=S.length)){O.children=new Array(N);for(P=N-1;P>=0;--P){K.push(L=O.children[P]=new I(S[P]));L.parent=O;L.depth=O.depth+1}}}return T.eachBefore(z)};var I=function(K){this.data=K;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=n.treeNodeId++}};I.prototype=o.prototype={constructor:I,count:function(){return this.eachAfter(count)},each:function(Q){var N=this;var O;var M=[N];var L,K,P;do{O=M.reverse();M=[];while(N=O.pop()){Q(N);L=N.children;if(L){for(K=0,P=L.length;K<P;++K){M.push(L[K])}}}}while(M.length);return this},eachAfter:function(Q){var O=this;var K=[O];var N=[];var M,L,P;while(O=K.pop()){N.push(O);M=O.children;if(M){for(L=0,P=M.length;L<P;++L){K.push(M[L])}}}while(O=N.pop()){Q(O)}return this},eachBefore:function(O){var N=this;var K=[N];var M,L;while(N=K.pop()){O(N);M=N.children;if(M){for(L=M.length-1;L>=0;--L){K.push(M[L])}}}return this},sum:function(K){return this.eachAfter(function(O){var N=+K(O.data)||0;var M=O.children;var L=M&&M.length;while(--L>=0){N+=M[L].value}O.value=N})},sort:function(K){return this.eachBefore(function(L){if(L.children){L.children.sort(K)}})},path:function(K){var O=this;var N=t(O,K);var M=[O];while(O!==N){O=O.parent;M.push(O)}var L=M.length;while(K!==N){M.splice(L,0,K);K=K.parent}return M},ancestors:function(){var L=this;var K=[L];while(L=L.parent){K.push(L)}return K},descendants:function(){var K=[];this.each(function(L){K.push(L)});return K},leaves:function(){var K=[];this.eachBefore(function(L){if(!L.children){K.push(L)}});return K},links:function(){var K=this;var L=[];K.each(function(M){if(M!==K){L.push({source:M.parent,target:M})}});return L},copy:function(){return o(this).eachBefore(q)}};var e=null;var u=1;var s=1;var i=function(K){this._=K;this.next=null};var h=function(P){var L;var O=(P=P.slice()).length;var K=null;var N=K;while(O){var M=new i(P[O-1]);if(N){N=N.next=M}else{N=K=M}P[L]=P[--O]}return{head:K,tail:N}};var w=function(K){return J(h(K),[])};var d=function(M,K){var N=K.x-M.x;var L=K.y-M.y;var O=M.r-K.r;return O*O+0.000001>N*N+L*L};var J=function(M,R){var P;var O=null;var N=M.head;var K;var Q;switch(R.length){case 1:P=B(R[0]);break;case 2:P=A(R[0],R[1]);break;case 3:P=x(R[0],R[1],R[2]);break}while(N){Q=N._;K=N.next;if(!P||!d(P,Q)){if(O){M.tail=O;O.next=null}else{M.head=M.tail=null}R.push(Q);P=J(M,R);R.pop();if(M.head){N.next=M.head;M.head=N}else{N.next=null;M.head=M.tail=N}O=M.tail;O.next=K}else{O=N}N=K}M.tail=O;return P};var B=function(K){return{x:K.x,y:K.y,r:K.r}};var A=function(V,S){var L=V.x;var U=V.y;var N=V.r;var K=S.x;var R=S.y;var M=S.r;var Q=K-L;var T=R-U;var O=M-N;var P=Math.sqrt(Q*Q+T*T);return{x:(L+K+Q/P*O)/2,y:(U+R+T/P*O)/2,r:(P+N+M)/2}};var x=function(aj,ah,ag){var af=aj.x;var O=aj.y;var aa=aj.r;var ae=ah.x;var N=ah.y;var Y=ah.r;var ac=ag.x;var L=ag.y;var X=ag.r;var am=2*(af-ae);var Q=2*(O-N);var W=2*(Y-aa);var an=af*af+O*O-aa*aa-ae*ae-N*N+Y*Y;var ak=2*(af-ac);var P=2*(O-L);var V=2*(X-aa);var al=af*af+O*O-aa*aa-ac*ac-L*L+X*X;var ai=ak*Q-am*P;var ad=(Q*al-P*an)/ai-af;var Z=(P*W-Q*V)/ai;var M=(ak*an-am*al)/ai-O;var K=(am*V-ak*W)/ai;var U=Z*Z+K*K-1;var T=2*(ad*Z+M*K+aa);var S=ad*ad+M*M-aa*aa;var R=(-T-Math.sqrt(T*T-4*U*S))/(2*U);return{x:ad+Z*R+af,y:M+K*R+O,r:R}};var p=function(P,N,L){var K=P.x;var T=P.y;var U=N.r+L.r;var S=P.r+L.r;var V=N.x-K;var R=N.y-T;var Q=V*V+R*R;if(Q){var O=0.5+((S*=S)-(U*=U))/(2*Q);var M=Math.sqrt(Math.max(0,2*U*(S+Q)-(S-=Q)*S-U*U))/(2*Q);L.x=K+O*V+M*R;L.y=T+O*R-M*V}else{L.x=K+S;L.y=T}};var a=function(M,K){var N=K.x-M.x;var L=K.y-M.y;var O=M.r+K.r;return O*O-0.000001>N*N+L*L};var D=function(P,L,R){var N=P._;var K=P.next._;var Q=N.r+K.r;var O=(N.x*K.r+K.x*N.r)/Q-L;var M=(N.y*K.r+K.y*N.r)/Q-R;return O*O+M*M};var j=function(K){this._=K;this.next=null;this.previous=null};var l=function(S){if(!(Q=S.length)){return 0}var X,Q,U,Y,Y,W;var ab=S[0];ab.x=0;ab.y=0;if(!(Q>1)){return ab.r}var Z=S[1];ab.x=-Z.r;Z.x=ab.r;Z.y=0;if(!(Q>2)){return ab.r+Z.r}p(Z,ab,X=S[2]);var ac=ab.r*ab.r;var O=Z.r*Z.r;var P=X.r*X.r;var T=ac+O+P;var N=ac*ab.x+O*Z.x+P*X.x;var M=ac*ab.y+O*Z.y+P*X.y;var L,K,V,U,R,Y,W;ab=new j(ab);Z=new j(Z);X=new j(X);ab.next=X.previous=Z;Z.next=ab.previous=X;X.next=Z.previous=ab;E:for(var V=3;V<Q;++V){p(ab._,Z._,X=S[V]);X=new j(X);U=Z.next;R=ab.previous;Y=Z._.r;W=ab._.r;do{if(Y<=W){if(a(U._,X._)){Z=U;ab.next=Z;Z.previous=ab;--V;continue E}Y+=U._.r;U=U.next}else{if(a(R._,X._)){ab=R;ab.next=Z;Z.previous=ab;--V;continue E}W+=R._.r;R=R.previous}}while(U!==R.next);X.previous=ab;X.next=Z;ab.next=Z.previous=Z=X;T+=P=X._.r*X._.r;N+=P*X._.x;M+=P*X._.y;ac=D(ab,L=N/T,K=M/T);while((X=X.next)!==Z){if((P=D(X,L,K))<ac){ab=X;ac=P}}Z=ab.next}ab=[Z._];X=Z;while((X=X.next)!==Z){ab.push(X._)}X=w(ab);for(var V=0;V<Q;++V){ab=S[V];ab.x-=X.x;ab.y-=X.y}return X.r};var k=function(K){l(K);return K};var H=function(K){return K==null?null:r(K)};var r=function(K){if(typeof K!=="function"){throw new Error}return K};var C=function(){return 0};var g=function(K){return function(){return K}};var G=function(K){return Math.sqrt(K.value)};var H=function(K){return K==null?null:r(K)};var F=function(K){return function(L){if(!L.children){L.r=Math.max(0,+K(L)||0)}}};var c=function(L,K){return function(P){if(N=P.children){var N,M,R=N.length,O=L(P)*K||0,Q;if(O){for(M=0;M<R;++M){N[M].r+=O}}Q=l(N);if(O){for(M=0;M<R;++M){N[M].r-=O}}P.r=Q+O}}};var b=function(K){return function(M){var L=M.parent;M.r*=K;if(L){M.x=L.x+K*M.x;M.y=L.y+K*M.y}}};var y=C;function E(K){K.x=u/2,K.y=s/2;if(e){K.eachBefore(F(e)).eachAfter(c(y,0.5)).eachBefore(b(1))}else{K.eachBefore(F(G)).eachAfter(c(C,1)).eachAfter(c(y,K.r/Math.min(u,s))).eachBefore(b(Math.min(u,s)/(2*K.r)))}return K}E.radius=function(K){return arguments.length?(e=H(K),E):e};E.size=function(K){return arguments.length?(u=+K[0],s=+K[1],E):[u,s]};E.padding=function(K){return arguments.length?(y=typeof K==="function"?K:g(+K),E):y};E.setPack=function(K){return o(K).sum(function(L){return L.size}).sort(function(M,L){return L.value-M.value})};return E};this.setCirclePack=function(){var b=Math.max(this.top,this.right);var a=this.width-(this.right+this.left+this.marginLeft+this.marginRight);var e=this.height-(this.top+this.bottom+this.marginTop+this.marginBottom);var c=a>e?e:a;this.data.bubble.object=this.getD3CirclePack().size([c,c]).padding(2);if(!this.data.bubble.root){this.data.bubble.root=this.getD3CirclePack().setPack(this.data.bubble.data)}this.data.bubble.plot=this.data.bubble.object(this.data.bubble.root);this.data.bubble.plot.diameter=c};this.getD3Contour=function(){var t=Math.sqrt(50);var k=Math.sqrt(10);var l=Math.sqrt(2);var C=function(L,G,J){var E;var F=-1;var K,I,H;G=+G,L=+L,J=+J;if(L===G&&J>0){return[L]}if(E=G<L){K=L,L=G,G=K}if((H=u(L,G,J))===0||!isFinite(H)){return[]}if(H>0){let r0=Math.round(L/H),r1=Math.round(G/H);if(r0*H<L){++r0}if(r1*H>G){--r1}I=new Array(K=r1-r0+1);while(++F<K){I[F]=(r0+F)*H}}else{H=-H;let r0=Math.round(L*H),r1=Math.round(G*H);if(r0/H<L){++r0}if(r1/H>G){--r1}I=new Array(K=r1-r0+1);while(++F<K){I[F]=(r0+F)/H}}if(E){I.reverse()}return I};var u=function(J,F,I){var H=(F-J)/Math.max(0,I);var G=Math.floor(Math.log(H)/Math.LN10);var E=H/Math.pow(10,G);return G>=0?(E>=t?10:E>=k?5:E>=l?2:1)*Math.pow(10,G):-Math.pow(10,-G)/(E>=t?10:E>=k?5:E>=l?2:1)};var n=function(J,H,I){var G=Math.abs(H-J)/Math.max(0,I);var E=Math.pow(10,Math.floor(Math.log(G)/Math.LN10));var F=G/E;if(F>=t){E*=10}else{if(F>=k){E*=5}else{if(F>=l){E*=2}}}return H<J?-E:E};var a=function(E){return E[0]};var D=function(E){return E[1]};var d=function(){return 1};var j=function(F,L,G){var H=F.width;var I=F.height;var M=(G<<1)+1;for(var J=0;J<I;++J){for(var K=0,E=0;K<H+G;++K){if(K<H){E+=F.data[K+J*H]}if(K>=G){if(K>=M){E-=F.data[K-M+J*H]}L.data[K-G+J*H]=E/Math.min(K+1,H-1+M-K,M)}}}};var i=function(F,L,G){var H=F.width;var I=F.height;var M=(G<<1)+1;for(var K=0;K<H;++K){for(var J=0,E=0;J<I+G;++J){if(J<I){E+=F.data[K+J*H]}if(J>=G){if(J>=M){E-=F.data[K+(J-M)*H]}L.data[K+(J-G)*H]=E/Math.min(J+1,I-1+M-J,M)}}}};var A=function(J,H){var G=-1,I=J.length,F,E;if(arguments.length===1){while(++G<I){if((E=J[G])!=null&&E>=E){F=E;break}}while(++G<I){if((E=J[G])!=null&&E>F){F=E}}}else{while(++G<I){if((E=H.call(J,J[G],G))!=null&&E>=E){F=E;break}}while(++G<I){if((E=H.call(J,J[G],G))!=null&&E>F){F=E}}}return F};var o=function(E,F){let o=0;if(F===undefined){for(let v in E){let value=E[v];if(value!=null&&(value=+value)>=value){++o}}}else{let index=-1;for(let v in E){let value=E[v];if((value=F(value,++index,E))!=null&&(value=+value)>=value){++o}}}return o};var w=function(J,G,H){J=+J,G=+G,H=(I=arguments.length)<2?(G=J,J=0,1):I<3?1:+H;var F=-1,I=Math.max(0,Math.ceil((G-J)/H))|0,E=new Array(I);while(++F<I){E[F]=J+F*H}return E};var z=Array.prototype.slice;var g=function(F,E){return F-E};var B=function(E){var F=0;var H=E.length;var G=E[H-1][1]*E[0][0]-E[H-1][0]*E[0][1];while(++F<H){G+=E[F-1][1]*E[F][0]-E[F-1][0]*E[F][1]}return G};var e=function(E){return function(){return E}};var p=function(E,G){var F=-1;var I=G.length;var H;while(++F<I){if(H=y(E,G[F])){return H}}return 0};var s=function(K,H){var G=-1,J=K.length,F,E,I;if(arguments.length===1){while(++G<J){if((E=K[G])!=null&&E>=E){F=I=E;break}}while(++G<J){if((E=K[G])!=null){if(F>E){F=E}if(I<E){I=E}}}}else{while(++G<J){if((E=H.call(K,K[G],G))!=null&&E>=E){F=I=E;break}}while(++G<J){if((E=H.call(K,K[G],G))!=null){if(F>E){F=E}if(I<E){I=E}}}}return[F,I]};var y=function(I,R){var Q=R[0];var P=R[1];var G=-1;for(var L=0,E=I.length,J=E-1;L<E;J=L++){var M=I[L],O=M[0],H=M[1],K=I[J],N=K[0],F=K[1];if(b(M,K,R)){return 0}if(((H>P)!==(F>P))&&((Q<(N-O)*(P-H)/(F-H)+O))){G=-G}}return G};var b=function(F,E,H){var G;return r(F,E,H)&&x(F[G=+(F[0]===E[0])],H[G],E[G])};var r=function(F,E,G){return(E[0]-F[0])*(G[1]-F[1])===(G[0]-F[0])*(E[1]-F[1])};var x=function(G,F,E){return G<=F&&F<=E||E<=F&&F<=G};var h=function(){};var c=[[],[[[1,1.5],[0.5,1]]],[[[1.5,1],[1,1.5]]],[[[1.5,1],[0.5,1]]],[[[1,0.5],[1.5,1]]],[[[1,1.5],[0.5,1]],[[1,0.5],[1.5,1]]],[[[1,0.5],[1,1.5]]],[[[1,0.5],[0.5,1]]],[[[0.5,1],[1,0.5]]],[[[1,1.5],[1,0.5]]],[[[0.5,1],[1,0.5]],[[1.5,1],[1,1.5]]],[[[1.5,1],[1,0.5]]],[[[0.5,1],[1.5,1]]],[[[1,1.5],[1.5,1]]],[[[0.5,1],[1,1.5]]],[]];var q=function(){var M=1;var L=1;var I=function(N){return Math.ceil(Math.log(o(N))/Math.LN2)+1};var K=function(N){var Q=I(N);if(!Array.isArray(Q)){const P=s(N),O=n(P[0],P[1],Q);Q=C(Math.floor(P[0]/O)*O,Math.floor(P[1]/O-1)*O,Q)}else{Q=Q.slice().sort(g)}return Q.map(function(R){return H(N,R)})};var J=function(N){return N[0]*2+N[1]*(M+1)*4};var F=function(O,N,P){O.forEach(function(S){var R=S[0];var W=S[1];var T=R|0;var U=W|0;var Q;var V=N[U*M+T];if(R>0&&R<M&&T===R){Q=N[U*M+T-1];S[0]=R+(P-Q)/(V-Q)-0.5}if(W>0&&W<L&&U===W){Q=N[(U-1)*M+T];S[1]=W+(P-Q)/(V-Q)-0.5}})};var E=F;var H=function(P,Q){var O=[];var N=[];G(P,Q,function(R){E(R,P,Q);if(B(R)>0){O.push([R])}else{N.push(R)}});N.forEach(function(T){for(var S=0,U=O.length,R;S<U;++S){if(p((R=O[S])[0],T)!==-1){R.push(T);return}}});return{type:"MultiPolygon",value:Q,coordinates:O}};var G=function(X,W,Y){var O=new Array;var P=new Array;var V,U,T,S,R,Q;var N=function(aa){var af=[aa[0][0]+V,aa[0][1]+U];var Z=[aa[1][0]+V,aa[1][1]+U];var ae=J(af);var ad=J(Z);var ac,ab;if(ac=P[ae]){if(ab=O[ad]){delete P[ac.end];delete O[ab.start];if(ac===ab){ac.ring.push(Z);Y(ac.ring)}else{O[ac.start]=P[ab.end]={start:ac.start,end:ab.end,ring:ac.ring.concat(ab.ring)}}}else{delete P[ac.end];ac.ring.push(Z);P[ac.end=ad]=ac}}else{if(ac=O[ad]){if(ab=P[ae]){delete O[ac.start];delete P[ab.end];if(ac===ab){ac.ring.push(Z);Y(ac.ring)}else{O[ab.start]=P[ac.end]={start:ab.start,end:ac.end,ring:ab.ring.concat(ac.ring)}}}else{delete O[ac.start];ac.ring.unshift(af);O[ac.start=ae]=ac}}else{O[ae]=P[ad]={start:ae,end:ad,ring:[af,Z]}}}};V=U=-1;S=X[0]>=W;c[S<<1].forEach(N);while(++V<M-1){T=S,S=X[V+1]>=W;c[T|S<<1].forEach(N)}c[S<<0].forEach(N);while(++U<L-1){V=-1;S=X[U*M+M]>=W;R=X[U*M]>=W;c[S<<1|R<<2].forEach(N);while(++V<M-1){T=S,S=X[U*M+M+V+1]>=W;Q=R,R=X[U*M+V+1]>=W;c[T|S<<1|R<<2|Q<<3].forEach(N)}c[S|R<<3].forEach(N)}V=-1;R=X[U*M]>=W;c[R<<2].forEach(N);while(++V<M-1){Q=R,R=X[U*M+V+1]>=W;c[R<<2|Q<<3].forEach(N)}c[R<<3].forEach(N)};K.contour=H;K.size=function(N){if(!arguments.length){return[M,L]}var P=Math.ceil(N[0]);var O=Math.ceil(N[1]);if(!(P>0)||!(O>0)){throw new Error("invalid size")}return M=P,L=O,K};K.thresholds=function(N){return arguments.length?(I=typeof N==="function"?N:Array.isArray(N)?e(z.call(N)):e(N),K):I};K.smooth=function(N){return arguments.length?(E=N?F:h,K):E===F};K.density=function(){var Z=a;var Y=D;var W=d;var ad=960;var ab=500;var N=20;var U=2;var P=N*3;var R=(ad+P*2)>>U;var S=(ab+P*2)>>U;var V=e(20);var aa=function(ah){var ag=new Float32Array(R*S);var af=new Float32Array(R*S);ah.forEach(function(ao,am,an){var ak=(+Z(ao,am,an)+P)>>U,al=(+Y(ao,am,an)+P)>>U,aj=+W(ao,am,an);if(ak>=0&&ak<R&&al>=0&&al<S){ag[ak+al*R]+=aj}});j({width:R,height:S,data:ag},{width:R,height:S,data:af},N>>U);i({width:R,height:S,data:af},{width:R,height:S,data:ag},N>>U);j({width:R,height:S,data:ag},{width:R,height:S,data:af},N>>U);i({width:R,height:S,data:af},{width:R,height:S,data:ag},N>>U);j({width:R,height:S,data:ag},{width:R,height:S,data:af},N>>U);i({width:R,height:S,data:af},{width:R,height:S,data:ag},N>>U);var ai=V(ag);if(!Array.isArray(ai)){var ae=A(ag);ai=n(0,ae,ai);ai=w(0,Math.floor(ae/ai)*ai,ai);ai.shift()}return[ai,[R,S],ag,Q]};var Q=function(ae){ae.value*=Math.pow(2,-2*U);ae.coordinates.forEach(T);return ae};var T=function(ae){ae.forEach(ac)};var ac=function(ae){ae.forEach(X)};var X=function(ae){ae[0]=ae[0]*Math.pow(2,U)-P;ae[1]=ae[1]*Math.pow(2,U)-P};var O=function(){P=N*3;R=(ad+P*2)>>U;S=(ab+P*2)>>U;return aa};aa.x=function(ae){return arguments.length?(Z=typeof ae==="function"?ae:e(+ae),aa):Z};aa.y=function(ae){return arguments.length?(Y=typeof ae==="function"?ae:e(+ae),aa):Y};aa.weight=function(ae){return arguments.length?(W=typeof ae==="function"?ae:e(+ae),aa):W};aa.size=function(ae){if(!arguments.length){return[ad,ab]}var ag=+ae[0],af=+ae[1];if(!(ag>=0&&af>=0)){throw new Error("invalid size")}return ad=ag,ab=af,O()};aa.cellSize=function(ae){if(!arguments.length){return 1<<U}if(!((ae=+ae)>=1)){throw new Error("invalid cell size")}return U=Math.floor(Math.log(ae)/Math.LN2),O()};aa.thresholds=function(ae){return arguments.length?(V=typeof ae==="function"?ae:Array.isArray(ae)?e(z.call(ae)):e(ae),aa):V};aa.bandwidth=function(ae){if(!arguments.length){return Math.sqrt(N*(N+1))}if(!((ae=+ae)>=0)){throw new Error("invalid bandwidth")}return N=Math.round((Math.sqrt(4*ae*ae+1)-1)/2),O()};return aa};return K};return q};this.circularLayout=function(c,g){var e=this;if(c.length>0){var b,h,d;if(g){}else{b=this.x/2;h=this.y/2;d=Math.max(this.x,this.y)}this.calculateCircularLayoutFinalNodePosition(c,b,h,d);var a=function(){if(e.iteration<=15){e.updateCircularLayoutNodePositions(c);e.renderNetwork(false);e.drawNetworkProgressBar("Optimizing ...",e.iteration/15);e.requestAnimationFrame(a)}else{e.finalizeNetworkLayout("circularLayout")}};a()}};this.calculateCircularLayoutFinalNodePosition=function(b,h,g,a){if(this.sizeNodeBy){var k=0;for(var d=0;d<b.length;d++){var c=b[d];if(!c.hide){k+=(this.nodeSize*this.getNodeEdgePropertyValue(c,false,"sizeNodeBy")*2)+this.nodeSize}}var e=2*Math.PI/k;var j=0;for(var d=0;d<b.length;d++){var c=b[d];var k=(this.nodeSize*this.getNodeEdgePropertyValue(c,false,"sizeNodeBy")*2)+this.nodeSize;if(!c.hide){j+=e*k*0.5;c.layout.lastPosition.x=h+a+a*Math.sin(j);c.layout.lastPosition.y=g+a+a*Math.cos(j);c.layout.lastPosition.r=this.networkRadialRadius;c.layout.lastPosition.a=j*180/Math.PI;c.radius=this.networkRadialRadius;c.angle=j*180/Math.PI;j+=e*k*0.5}}}else{var e=2*Math.PI/b.length;for(var d=0;d<b.length;d++){var c=b[d];if(!c.hide){c.layout.lastPosition.x=h+a+a*Math.sin(d*e);c.layout.lastPosition.y=g+a+a*Math.cos(d*e);c.layout.lastPosition.r=this.networkRadialRadius;c.layout.lastPosition.a=d*e*180/Math.PI;c.radius=this.networkRadialRadius;c.angle=d*e*180/Math.PI}}}};this.updateCircularLayoutNodePositions=function(d){var l=Math.atan((this.iteration++/15)*10-5)*0.5/Math.atan(5)+0.5;for(var e=0;e<d.length;e++){var j=d[e].layout;var h=j.lastPosition;var b=h.a*l;var g=h.r*l;var k=this.getPolar(this.networkXCenter,this.networkYCenter,g,b);j.position.x=k.x;j.position.y=k.y}this.updateLayoutNodePositions(d)};this.radialLayout=function(a,d){var c=this;if(a&&a.length){this.calculateRadialLayoutFinalNodePosition(d);this.resetRadialLayoutNodePositions(a);var b=function(){if(c.iteration<15){c.updateRadialLayoutNodePositions(a);c.renderNetwork(false);c.drawNetworkProgressBar("Optimizing ...",c.iteration/15);c.requestAnimationFrame(b)}else{c.finalizeNetworkLayout("radialLayout")}};b()}};this.orderRadialLayout=function(d){var b=this.data.nodeIndices[d];var c=0;for(var a=b;a<this.data.nodes.length;a++){this.data.nodes[a].layout.order=c++}for(var a=0;a<b;a++){this.data.nodes[a].layout.order=c++}};this.updateRadialLayoutNodePositions=function(d){var g=Math.atan((this.iteration++/15)*10-5)*0.5/Math.atan(5)+0.5;var e=1-g;for(var j=0;j<d.length;j++){var h=d[j].layout;var p=h.lastPosition;var l=((e*h.angle)+(g*p.a));var b=((e*h.radius)+(g*p.r));var k=this.getPolar(this.networkXCenter,this.networkYCenter,b,l);d[j].layout.position.x=k.x;d[j].layout.position.y=k.y}this.updateLayoutNodePositions(d)};this.resetRadialLayoutNodePositions=function(a){for(var b=0;b<a.length;b++){var e=a[b].layout;var c=e.lastPosition;if(c.r==0){e.angle=c.a}if(c.r==0){c.a=e.angle}var g=(c.a-e.angle);if(g<0){g+=360}if(g>360){g-=360}if(g>180){g-=360}c.a=e.angle+g}};this.calculateRadialLayoutFinalNodePosition=function(h,d){var q=this;var u=0;var t=[];var p=this.data.nodes[this.data.nodeIndices[h]];var j=p.layout;if(j.hierarchy!="done"){if(!p.hide&&!p.hiddenParent){if(j.children.length>1&&!d){this.orderRadialLayout(h);j.children.sort(function(i,c){var n=q.data.nodes[q.data.nodeIndices[i]].layout;var l=q.data.nodes[q.data.nodeIndices[c]].layout;return n.order-l.order});for(var o=0;o<j.children.length;o++){var e=j.children[o];var w=this.data.nodes[this.data.nodeIndices[e]].layout;if(w.level>j.level){this.calculateRadialLayoutFinalNodePosition(e);t.push(w.angle)}}if(t.length>0){var g=t.length-1;if(t.length==1){u=t[0]}else{if(t[0]>t[g]){u=((t[0]+t[g])%360)/2}else{u=(t[0]+t[g])/2}}}else{this.calculateRadialLayoutFinalNodePosition(h,true)}}else{u=this.networkCurrentAngle;this.networkCurrentAngle=(this.networkCurrentAngle+this.networkAngleStep)}var k=(this.networkDepth-1)-j.level;var s=this.getPolar(this.networkXCenter,this.networkYCenter,this.networkRadialRadius,u);var x=this.shortenLine(this.networkXCenter,this.networkYCenter,s.x,s.y,0,this.networkLevelSize*k,"line");var b=this.lineLength(this.networkXCenter,this.networkYCenter,x[2],x[3]);if(j.level==0){u=0;b=0}j.lastPosition.x=x[2];j.lastPosition.y=x[3];j.lastPosition.r=b;j.lastPosition.a=u%360;j.hierarchy="done";j.angle=u}}};this.forceDirectedLayout=function(b,a){var d=this;if(b&&b.length){var c=function(){var e=d.calculateForcedDirectedLayoutMovement(b,a);var g=e/b.length;if(g>=0.01&&d.iteration<d.maxIterations){d.iteration++;if(d.iteration%2){d.renderNetwork(false)}d.drawNetworkProgressBar("Optimizing ...",d.iteration/d.maxIterations);d.requestAnimationFrame(c)}else{d.finalizeNetworkLayout("forceDirectedLayout")}};c()}};this.calculateForcedDirectedLayoutMovement=function(b,a){if(this.useBarnesHutSimulation||a){this.accumulateForceDirectedLayoutForces();return this.integrateForceDirectedLayout(b)}else{this.setForceDirectedLayoutNodeDisplacement(b);return this.integrateForceDirectedLayoutDisplacement(b)}};this.integrateForceDirectedLayoutDisplacement=function(a){var d=this.averageForceDirectedLayoutMovement(a);var b=a.length;if(b){while(b--){var c=a[b];if(!c.fixed&&this.iteration%2){c.layout.prevPosition.x=c.layout.position.x;c.layout.prevPosition.y=c.layout.position.y}}}this.updateLayoutNodePositions(a);return d*a.length};this.setForceDirectedLayoutNodeDisplacement=function(d){var b={};var j=[];var h=d.length;for(var k=0;k<h;k++){var g=d[k];for(var p=0;p<g.layout.edges.length;p++){var n=g.layout.edges[p];var o=n.id1+":"+n.id2;if(!b.hasOwnProperty(o)){j.push(n);b[o]=true}}if(!g.fixed&&!this.iteration){g.layout.displacement={x:g.x,y:g.y,z:g.z};g.layout.force={x:0,y:0,z:0}}}this.calculateForceDirectedLayoutRepulsiveDisplacement(d);this.calculateForceDirectedLayoutAttractiveDisplacement(d,j);this.applyForceDirectedLayoutDisplacement(d)};this.calculateForceDirectedLayoutRepulsiveDisplacement=function(b){var x=this;var g=b.length;var h=Math.sqrt((g*g)/g+1);var s=function(i){switch(x.repulsiveForceFunction){case"FruchtermanReingold":case"square":return(h*h)/i;case"cubic":return(h*h*h)/i;case"Eades":case"log":return h/Math.log(i);case"pow":return h*Math.pow(2,i);case"sqrt":return h/Math.sqrt(i)}};for(var o=0;o<g;o++){var e=b[o];var c=e.layout.displacement;var r=e.layout.force;if(!e.fixed){for(var n=0;n<g;n++){if(o!=n){var d=b[n];var a=d.layout.displacement;var y=c.x-a.x;var w=c.y-a.y;var u=c.z-a.z;var q=Math.sqrt((y*y)+(w*w)+(u*u))+0.01;var p=s(q);r.x+=y/q*p;r.y+=w/q*p;r.z+=u/q*p}}}}};this.calculateForceDirectedLayoutAttractiveDisplacement=function(j,a){var g=this;var p=j.length;var s=Math.sqrt((p*p)/p+1);var y=function(i){switch(g.attractiveForceFunction){case"FruchtermanReingold":case"square":return(i*i)/s;case"cubic":return(i*i*i)/s;case"Eades":case"log":return i*Math.log(m);case"pow":return i*Math.pow(2,s);case"sqrt":return i/Math.sqrt(s)}};var p=a.length;for(var w=0;w<p;w++){var b=a[w];var u=this.nodes[b.id1];var q=this.nodes[b.id2];var r=u.layout.displacement;var o=q.layout.displacement;var z=u.layout.force;var x=q.layout.force;var e=r.x-o.x;var d=r.y-o.y;var c=r.z-o.z;var h=Math.sqrt((e*e)+(d*d)+(c*c))+0.01;var n=y(h);if(!u.fixed){z.x-=e/h*n;z.y-=d/h*n;z.z-=c/h*n}if(!q.fixed){x.x+=e/h*n;x.y+=d/h*n;x.z+=c/h*n}}};this.applyForceDirectedLayoutDisplacement=function(b){var s=this;var e=b.length;var d=Math.sqrt(e*e)/10;var g=Math.sqrt((e*e)/e+1);for(var h=0;h<e;h++){var p=b[h].layout.displacement;var j=b[h].layout.force;var n=Math.sqrt((p.x*p.x)+(p.y*p.y)+(p.z*p.z));var a=g*this.networkGravity*n*0.01;j.x-=a*p.x/n;j.y-=a*p.y/n;j.z-=a*p.z/n;j.x*=this.networkSpeed;j.y*=this.networkSpeed;j.z*=this.networkSpeed;if(!b[h].fixed){var u=j.x;var r=j.y;var q=j.z;var n=Math.sqrt((u*u)+(r*r)+(q*q));if(n>0){var o=Math.min(d*this.networkSpeed,n);p.x+=u/n*o;p.y+=r/n*o;p.z+=q/n*o}}}for(var h=0;h<e;h++){var c=b[h];var p=b[h].layout.displacement;c.layout.position={x:p.x,y:p.y,z:p.z}}};this.accumulateForceDirectedLayoutForces=function(){var c=this.data.nodes;var b=this.data.edges;var d=c.length;if(d){var a=this.barnesHutInsertBodies(c);while(d--){var e=c[d];if(!e.fixed){e.layout.force={x:0,y:0,z:0};this.barnesHutUpdateBodyForce(e,a);this.updateForceDirectedLayoutDragForce(e)}}}d=b.length;while(d--){this.updateForceDirectedLayoutSpringForce(b[d])}this.updateLayoutNodePositions(c)};this.barnesHutNewNode=function(){this.barnesHutNodesCache[this.barnesHutNodesCacheCurrent]={body:null,quad0:null,quad1:null,quad2:null,quad3:null,quad4:null,quad5:null,quad6:null,quad7:null,mass:0,massX:0,massY:0,left:0,top:0,bottom:0,right:0,back:0,front:0};var a=this.barnesHutNodesCache[this.barnesHutNodesCacheCurrent];++this.barnesHutNodesCacheCurrent;return a};this.barnesHutInsertBodies=function(e,q){var d=this;var a=function(Z){var V=function(y,x){if(x===0){return y.quad0}if(x===1){return y.quad1}if(x===2){return y.quad2}if(x===3){return y.quad3}return null};var U=function(y,x,z){if(x===0){y.quad0=z}else{if(x===1){y.quad1=z}else{if(x===2){y.quad2=z}else{if(x===3){y.quad3=z}}}}};var Y=function(ac,ab){var z=Math.abs(ac.x-ab.x);var y=Math.abs(ac.y-ab.y);var x=Math.abs(ac.z-ab.z);return(z<1e-8&&y<1e-8&&x<1e-8)};var aa={stack:[],popIdx:0,isEmpty:function(){return this.popIdx===0},push:function(y,x){this.stack[this.popIdx]={node:y,body:x};++this.popIdx},pop:function(){if(this.popIdx>0){return this.stack[--this.popIdx]}},reset:function(){this.popIdx=0}};aa.reset();aa.push(q,Z);while(!aa.isEmpty()){var C=aa.pop();var S=C.node;var O=C.body;if(!S.body){var L=O.layout.position.x;var J=O.layout.position.y;var I=O.layout.position.z;S.mass=S.mass+O.layout.mass;S.massX=S.massX+O.layout.mass*L;S.massY=S.massY+O.layout.mass*J;S.massZ=S.massZ+O.layout.mass*I;var B=0;var D=S.left;var X=(S.right+D)/2;var Q=S.top;var H=(S.bottom+Q)/2;var R=S.back;var G=(S.front-R)/2;if(this.is3DNetwork){if(L>X){B=B+1;var T=D;D=X;X=X+(X-T)}if(J>H){B=B+2;var i=Q;Q=H;H=H+(H-i)}if(I>G){B=B+4;var A=R;R=G;G=R+(R-A)}}else{if(L>X){B=B+1;D=X;X=S.right}if(J>H){B=B+2;Q=H;H=S.bottom}}var F=V(S,B);if(!F){F=d.barnesHutNewNode();F.left=D;F.top=Q;F.right=X;F.bottom=H;F.back=R;F.front=G;F.body=O;U(S,B,F)}else{aa.push(F,O)}}else{var N=S.body;S.body=null;if(Y(N.layout.position,O.layout.position)){var W=3;while(W>0&&Y(N.layout.position,O.layout.position)){var E=d.random();var P=(S.right-S.left)*E;var M=(S.bottom-S.top)*E;var K=(S.front-S.back)*E;N.layout.position.x=S.left+P;N.layout.position.y=S.top+M;N.layout.position.z=S.back+K;W-=1}if(W===0&&Y(N.layout.position,O.layout.position)){return}}aa.push(S,N);aa.push(S,O)}}};var w=Number.MAX_VALUE;var c=Number.MAX_VALUE;var p=Number.MAX_VALUE;var u=Number.MIN_VALUE;var b=Number.MIN_VALUE;var n=Number.MIN_VALUE;var s=e.length;var t=s;while(t--){var k=e[t].layout.position.x;var h=e[t].layout.position.y;var g=e[t].layout.position.y;if(k<w){w=k}if(k>u){u=k}if(h<c){c=h}if(h>b){b=h}if(g<p){p=g}if(g>n){n=g}}var o=u-w;var l=b-c;var j=n-p;var r=Math.max(o,Math.max(l,j));if(this.is3DNetwork){u=w+r;b=c+r;n=p+r}else{if(o>l){b=c+o}else{u=w+l}}this.barnesHutNodesCacheCurrent=0;q=this.barnesHutNewNode();q.left=w;q.right=u;q.top=c;q.bottom=b;q.back=p;q.from=n;t=s-1;if(t>=0){q.body=e[t]}while(t--){a(e[t],q)}return q};this.barnesHutUpdateBodyForce=function(k,n){var j=this.barnesHutUpdateQueue;var o;var t;var s;var q;var a;var h=0;var d=0;var b=0;var g=1;var l=0;var e=1;j[0]=n;while(g){var c=j[l];var i=c.body;g-=1;l+=1;var p=(i!==k);if(i&&p){t=i.layout.position.x-k.layout.position.x;s=i.layout.position.y-k.layout.position.y;q=i.layout.position.z-k.layout.position.z;a=Math.sqrt(t*t+s*s+q*q);if(a===0){t=(this.random()-0.5)/50;s=(this.random()-0.5)/50;q=(this.random()-0.5)/50;a=Math.sqrt(t*t+s*s+q*q)}o=this.networkRepulsion*i.layout.mass*k.layout.mass/(a*a*a);h+=o*t;d+=o*s;b+=o*q}else{if(p){t=c.massX/c.mass-k.layout.position.x;s=c.massY/c.mass-k.layout.position.y;q=c.massZ/c.mass-k.layout.position.z;a=Math.sqrt(t*t+s*s+q*q);if(a===0){t=(this.random()-0.5)/50;s=(this.random()-0.5)/50;q=(this.random()-0.5)/50;a=Math.sqrt(t*t+s*s+q*q)}if((c.right-c.left)/a<this.networkTheta){o=this.networkRepulsion*c.mass*k.layout.mass/(a*a*a);h+=o*t;d+=o*s;b+=o*q}else{if(c.quad0){j[e]=c.quad0;g+=1;e+=1}if(c.quad1){j[e]=c.quad1;g+=1;e+=1}if(c.quad2){j[e]=c.quad2;g+=1;e+=1}if(c.quad3){j[e]=c.quad3;g+=1;e+=1}if(this.is3DNetwork){if(c.quad4){j[e]=c.quad4;g+=1;e+=1}if(c.quad5){j[e]=c.quad5;g+=1;e+=1}if(c.quad6){j[e]=c.quad6;g+=1;e+=1}if(c.quad7){j[e]=c.quad7;g+=1;e+=1}}}}}}k.layout.force.x+=h;k.layout.force.y+=d;k.layout.force.z+=b};this.updateLayoutNodePositions=function(a){var b=a.length;while(b--){a[b].x=a[b].layout.position.x;a[b].y=a[b].layout.position.y;a[b].z=a[b].layout.position.z}};this.updateForceDirectedLayoutSpringForce=function(b){var i=this.data.nodes[this.data.nodeIndices[b.id1]];var h=this.data.nodes[this.data.nodeIndices[b.id2]];var c=b.layout.length<0?this.networkSpringLength:b.layout.length;var k=h.layout.position.x-i.layout.position.x;var j=h.layout.position.y-i.layout.position.y;var a=Math.sqrt(k*k+j*j);if(a===0){k=(this.random()-0.5)/50;j=(this.random()-0.5)/50;a=Math.sqrt(k*k+j*j)}var g=a-c;var e=((!b.layout.coeff||b.layout.coeff<0)?this.networkSpringCoeff:b.layout.coeff)*g/a*b.layout.weight;i.layout.force.x+=e*k;i.layout.force.y+=e*j;h.layout.force.x-=e*k;h.layout.force.y-=e*j};this.integrateForceDirectedLayout=function(a){var o=0;var e=0;var n=0;var c=0;var k=a.length;if(k===0){return 0}for(var d=0;d<k;++d){var b=a[d];var g=this.networkTimeStep/b.layout.mass;b.layout.velocity.x+=g*b.layout.force.x;b.layout.velocity.y+=g*b.layout.force.y;var j=b.layout.velocity.x;var h=b.layout.velocity.y;var l=Math.sqrt(j*j+h*h);if(l>1){b.layout.velocity.x=j/l;b.layout.velocity.y=h/l}o=this.networkTimeStep*b.layout.velocity.x;n=this.networkTimeStep*b.layout.velocity.y;b.layout.position.x+=o;b.layout.position.y+=n;e+=Math.abs(o);c+=Math.abs(n)}return(e*e+c*c)/k};this.updateForceDirectedLayoutDragForce=function(a){a.layout.force.x-=this.networkDragCoeff*a.layout.velocity.x;a.layout.force.y-=this.networkDragCoeff*a.layout.velocity.y};this.averageForceDirectedLayoutMovement=function(c){var d=c.length;var b=0;var a=0;while(d--){var g=c[d];var h=g.layout.position;var e=g.layout.prevPosition;b+=Math.abs(h.x-e.x);a+=Math.abs(h.y-e.y)}return Math.sqrt(b*b+a*a)/c.length};this.networkBetweenness=function(c,g){var l=this;var k=[];var h=[];var d={};var n={};var p={};var o={};var a={};var b=function(w){var z=function(s,i){if(n[i]===-1){n[i]=n[s]+1;k.push(i)}if(n[i]===n[s]+1){p[i]+=p[s];d[i].push(s)}};var x=function(B){var A=l.nodes[B].layout.edges;for(var C=0;C<A.length;C++){var D=A[C];var s=D.id1;if(B==s){if(z(B,s)){return true}}}};var u=function(B){var A=l.nodes[B].layout.edges;for(var C=0;C<A.length;C++){var D=A[C];var s=D.id1==B?D.id2:D.id1;if(z(B,s)){return true}}};var y=function(i){if(g){return x(i)}else{return u(i)}};for(var t=0;t<c.length;t++){d[c[t].id]=[];n[c[t].id]=-1;p[c[t].id]=0}n[w]=0;p[w]=1;k.push(w);while(k.length){var r=k.shift();h.push(r);y(r)}};var q=function(){for(var x=0;x<c.length;x++){o[c[x].id]=0}while(h.length){var r=h.pop();var t=(1+o[r])/p[r];var u=d[r];for(var x=0;x<u.length;++x){var s=u[x];o[s]+=p[s]*t}if(r!==e.id){a[r]+=o[r]}}};for(var j=0;j<c.length;j++){var e=c[j].layout;if(!e.metrics){e.metrics={betweenness:-1,closeness:-1,degree:-1,eccentricity:-1};e.edges=this.edgesForNode(this.data.edges,c[j].id)}a[c[j].id]=0}for(var j=0;j<c.length;j++){var e=c[j];b(e.id);q()}for(var j=0;j<c.length;j++){var e=c[j].layout;e.metrics.betweenness=g?a[c[j].id]:a[c[j].id]/2}};this.networkCloseness=function(b,e){var k=this;var j=[];var l={};var g={};var c;var a=function(r){var w=function(s,i){if(l[i]===-1){l[i]=l[s]+1;j.push(i)}};var t=function(y){var x=k.nodes[y].layout.edges;for(var z=0;z<x.length;z++){var A=x[z];var s=A.id1;if(y==s){if(w(y,s)){return true}}}};var q=function(y){var x=k.nodes[y].layout.edges;for(var z=0;z<x.length;z++){var A=x[z];var s=A.id1==y?A.id2:A.id1;if(w(y,s)){return true}}};var u=function(i){if(e){return t(i)}else{return q(i)}};for(var p=0;p<b.length;p++){l[b[p].id]=-1}l[r]=0;j.push(r);while(j.length){var o=j.shift();u(o)}};var n=function(){var o=Object.keys(l).map(function(q){return l[q]}).filter(function(q){return q!==-1});var p=o.length;var i=o.reduce(function(r,q){return r+q});if(i>0){g[c]=(p-1)/i}else{g[c]=0}};for(var h=0;h<b.length;h++){var d=b[h].layout;if(!d.metrics){d.metrics={betweenness:-1,closeness:-1,degree:-1,eccentricity:-1};d.edges=this.edgesForNode(this.data.edges,b[h].id)}g[b[h].id]=0}for(var h=0;h<b.length;h++){var d=b[h];c=b[h].id;a(d.id);n()}for(var h=0;h<b.length;h++){var d=b[h].layout;d.metrics.closeness=g[b[h].id]}};this.networkEccentricity=function(b,g){var k=this;var j=[];var l={};var c={};var d;var a=function(r){var w=function(s,i){if(l[i]===-1){l[i]=l[s]+1;j.push(i)}};var t=function(y){var x=k.nodes[y].layout.edges;for(var z=0;z<x.length;z++){var A=x[z];var s=A.id1;if(y==s){if(w(y,s)){return true}}}};var q=function(y){var x=k.nodes[y].layout.edges;for(var z=0;z<x.length;z++){var A=x[z];var s=A.id1==y?A.id2:A.id1;if(w(y,s)){return true}}};var u=function(i){if(g){return t(i)}else{return q(i)}};for(var p=0;p<b.length;p++){l[b[p].id]=-1}l[r]=0;j.push(r);while(j.length){var o=j.shift();u(o)}};var n=function(){var i=0;Object.keys(l).forEach(function(o){var p=l[o];if(i<p){i=p}});c[d]=i};for(var h=0;h<b.length;h++){var e=b[h].layout;if(!e.metrics){e.metrics={betweenness:-1,closeness:-1,degree:-1,eccentricity:-1};e.edges=this.edgesForNode(this.data.edges,b[h].id)}c[b[h].id]=0}for(var h=0;h<b.length;h++){var e=b[h];d=b[h].id;a(e.id);n()}for(var h=0;h<b.length;h++){var e=b[h].layout;e.metrics.eccentricity=c[b[h].id]}};this.networkDegree=function(b,d){for(var c=0;c<b.length;c++){var g=b[c].layout;var a=g.edges||this.edgesForNode(this.data.edges,b[c].id);var e=0;switch(d){case"in":for(var c=0;c<a.length;c++){e+=(a[c].id1==b[c].id)?1:0}break;case"out":for(var c=0;c<a.length;c++){e+=(a[c].id2==b[c].id)?1:0}break;default:e=a.length}g.metrics.degree=e}};this.exposeNetworkMetrics=function(){for(var a=0;a<this.data.nodes.length;a++){var b=this.data.nodes[a];if(b.layout){b.betweenness=b.layout.metrics.betweenness;b.closeness=b.layout.metrics.closeness;b.degree=b.layout.metrics.degree;b.eccentricity=b.layout.metrics.eccentricity}}};this.updateForceDirectedLayoutBoundingBox=function(q,h,z,c,x,a){var B=Number.MAX_VALUE;var d=Number.MAX_VALUE;var A=Number.MIN_VALUE;var b=Number.MIN_VALUE;var w,u,t,s;var y=q.length;if(y===0){return}while(y--){var r=q[y];if(!r.hide){if(r.fixed){r.layout.position.x=r.layout.prevPosition.x;r.layout.position.y=r.layout.prevPosition.y}else{r.layout.prevPosition.x=r.layout.position.x;r.layout.prevPosition.y=r.layout.position.y}if(r.layout.position.x<B){B=r.layout.position.x;w=r}if(r.layout.position.x>A){A=r.layout.position.x;u=r}if(r.layout.position.y<d){d=r.layout.position.y;t=r}if(r.layout.position.y>b){b=r.layout.position.y;s=r}}}h.x1=B;h.x2=A;h.y1=d;h.y2=b;return;var D=w.width?w.width:w.size?(this.nodeSize*w.size*this.scaleFactorX):this.nodeSize*this.scaleFactorX;var C=u.width?u.width:u.size?(this.nodeSize*u.size*this.scaleFactorX):this.nodeSize*this.scaleFactorX;var g=t.height?t.height:t.size?(this.nodeSize*t.size*this.scaleFactorY):this.nodeSize*this.scaleFactorY;var e=s.height?s.height:s.size?(this.nodeSize*s.size*this.scaleFactorY):this.nodeSize*this.scaleFactorY;if(!z){z=this.left}if(!x){x=this.left+this.x}if(!c){c=this.top}if(!a){a=this.top+this.y}D=B-(D/2);C=A+(C/2);g=d-(g/2);e=b+(e/2);var k=x-z;var j=a-c;var n=C-D;var l=e-g;var p=k/n;var o=j/l;var y=q.length;while(y--){var r=q[y];if(!r.hide){r.layout.position.x=(r.layout.position.x-D)*p;r.layout.position.y=(r.layout.position.y-g)*o}if(r.fixed){r.layout.position.x=r.layout.prevPosition.x;r.layout.position.y=r.layout.prevPosition.y}else{r.layout.prevPosition.x=r.layout.position.x;r.layout.prevPosition.y=r.layout.position.y}}h.x1=z;h.x2=x;h.y1=c;h.y2=a};this.initComplex();this.initFFT();this.initContour();this.initDensity()};CanvasXpress.prototype.initComplex=function(){this.complexRe=function(a){return a[0]};this.complexIm=function(a){return a[1]};this.complexMod=function(e){var d=e[0].length;var a=new Float32Array(d);for(var b=0;b<d;b++){a[b]=e[0][b]!=0&&e[1][b]?Math.sqrt(e[0][b]*e[0][b]+e[1][b]*e[1][b]):0}return a};this.complexArg=function(f){var e=f[0].length;var b=new Float32Array(e);for(var d=0;d<e;d++){m[d]=Math.atan2(f[1][d],f[0][d])}return b};this.complexConj=function(d){var b=d[1].length;for(var a=0;a<b;a++){d[1][a]*=-1}};this.complexPlus=function(e,d){var h=e[0].length;var c=new Float32Array(h);var g=new Float32Array(h);for(var f=0;f<h;f++){c[f]=e[0][f]+d[0];g[f]=e[1][f]+d[1]}return[c,g]};this.complexMinus=function(e,d){var h=e[0].length;var c=new Float32Array(h);var g=new Float32Array(h);for(var f=0;f<h;f++){c[f]=e[0][f]-d[0];g[f]=e[1][f]-d[1]}return[c,g]};this.complexProd=function(e,d){var h=e[0].length;var c=new Float32Array(h);var g=new Float32Array(h);for(var f=0;f<h;f++){c[f]=(e[0][f]*d[0][f])-(e[1][f]*d[1][f]);g[f]=(e[0][f]*d[1][f])+(e[1][f]*d[0][f])}return[c,g]};this.complexDiv=function(f,e){var j=f[0].length;var d=new Float32Array(j);var h=new Float32Array(j);var c=this.Mod(e);for(var g=0;g<j;g++){d[g]=(f[0][g]*e[0][g])+(f[1][g]*e[1][g])/Math.pow(c[g],2);h[g]=(f[0][g]*e[1][g])-(f[1][g]*e[0][g])/Math.pow(c[g],2)}return[d,h]}};CanvasXpress.prototype.initFFT=function(){this.fft=function(l,a,e){var d=function(r,q){var i=r.length;if(i!=q.length){throw"Mismatched lengths"}if(i==0){return}else{if((i&(i-1))==0){o(r,q)}else{m(r,q)}}};var p=function(n,i){d(i,n)};var b=function(s,r){var n=0;for(var q=0;q<r;q++){n=(n<<1)|(s&1);s>>>=1}return n};var o=function(A,s){var t=A.length;if(t!=s.length){throw"Mismatched lengths"}if(t==1){return}var E=-1;for(var y=0;y<32;y++){if(1<<y==t){E=y}}if(E==-1){throw"Length is not a power of 2"}var w=new Array(t/2);var C=new Array(t/2);for(var y=0;y<t/2;y++){w[y]=Math.cos(2*Math.PI*y/t);C[y]=Math.sin(2*Math.PI*y/t)}for(var y=0;y<t;y++){var x=b(y,E);if(x>y){var D=A[y];A[y]=A[x];A[x]=D;D=s[y];s[y]=s[x];s[x]=D}}for(var F=2;F<=t;F*=2){var r=F/2;var z=t/F;for(var y=0;y<t;y+=F){for(var x=y,v=0;x<y+r;x++,v+=z){var u=x+r;var q=A[u]*w[v]+s[u]*C[v];var B=-A[u]*C[v]+s[u]*w[v];A[u]=A[x]-q;s[u]=s[x]-B;A[x]+=q;s[x]+=B}}}};var m=function(C,q){var s=C.length;if(s!=q.length){throw"Mismatched lengths"}var u=1;while(u<s*2+1){u*=2}var w=new Array(s);var D=new Array(s);for(var y=0;y<s;y++){var x=y*y%(s*2);w[y]=Math.cos(Math.PI*x/s);D[y]=Math.sin(Math.PI*x/s)}var v=g(u);var B=g(u);for(var y=0;y<s;y++){v[y]=C[y]*w[y]+q[y]*D[y];B[y]=-C[y]*D[y]+q[y]*w[y]}var t=g(u);var A=g(u);t[0]=w[0];A[0]=D[0];for(var y=1;y<s;y++){t[y]=t[u-y]=w[y];A[y]=A[u-y]=D[y]}var r=new Array(u);var z=new Array(u);h(v,B,t,A,r,z);for(var y=0;y<s;y++){C[y]=r[y]*w[y]+z[y]*D[y];q[y]=-r[y]*D[y]+z[y]*w[y]}};var h=function(t,w,s,v,x,q){var r=t.length;if(r!=w.length||r!=s.length||r!=v.length||r!=x.length||r!=q.length){throw"Mismatched lengths"}t=t.slice();w=w.slice();s=s.slice();v=v.slice();d(t,w);d(s,v);for(var u=0;u<r;u++){var y=t[u]*s[u]-w[u]*v[u];w[u]=w[u]*s[u]+t[u]*v[u];t[u]=y}p(t,w);for(var u=0;u<r;u++){x[u]=t[u]/r;q[u]=w[u]/r}};function g(s){var q=[];for(var r=0;r<s;r++){q.push(0)}return q}var c=l.length;var j=new Float64Array(c);var k=new Float64Array(c);for(var f=0;f<c;f++){j[f]=l[f];k[f]=a&&a.length?a[f]:0}if(e){p(j,k)}else{d(j,k)}return[j,k]}};CanvasXpress.prototype.initContour=function(){this.contourNewSeg=function(b,e,a,c,d){return{x0:b,y0:e,x1:a,y1:c,next:d}};this.contourSwapSeg=function(a){var c=a.x0;var b=a.y0;a.x0=a.x1;a.y0=a.y1;a.x1=c;a.y1=b};this.contourSegUpdate=function(g,b,f,e,d,a){var c=function(m,l){return Math.abs(m-l)==0};if(d==null){a=null;return null}switch(f){case 1:case 3:if(c(b,d.y0)){if(!e){this.contourSwapSeg(d)}a=d;return[d.next,a]}if(c(b,d.y1)){if(e){this.contourSwapSeg(d)}a=d;return[d.next,a]}break;case 2:case 4:if(c(g,d.x0)){if(!e){this.contourSwapSeg(d)}a=d;return[d.next,a]}if(c(g,d.x1)){if(e){this.contourSwapSeg(d)}a=d;return[d.next,a]}break}var h=this.contourSegUpdate(g,b,f,e,d.next,a);d.next=h?h[0]:null;return d};this.contourLines=function(o,h,g,n,c){if(!o.length){throw new Error("missing x data")}if(!h.length){throw new Error("missing y data")}if(!g.length){throw new Error("missing z data")}if(o.length*h.length!=g.length){throw new Error("dimensions of 'x', 'y' and 'z' do not match")}var q=this.range(g);var w=q[0];var E=q[1];if(n==null){n=w}var G=function(m,l,f){if((m<f)!=(l<f)&&m!=f&&l!=f){F=(f-m)/(l-m);return 1}else{return 0}};var B,A,v,e,F,p,t,J,L,K,r,a,u;var d=[];var s=[];var I=o.length;var H=h.length;var b=[];if(!c){c=0.001*(E-w)}for(var D=0;D<I;D++){for(var C=0;C<H;C++){b[D+C*I]=null}}for(var D=0;D<I-1;D++){p=o[D];t=o[D+1];for(var C=0;C<H-1;C++){J=h[C];L=h[C+1];B=D+C*I;K=g[B];r=g[B+1];a=g[B+I];u=g[B+I+1];if(K==n){K+=c}if(r==n){r+=c}if(a==n){a+=c}if(u==n){u+=c}e=0;if(isFinite(K)){e+=1}if(isFinite(r)){e+=2}if(isFinite(a)){e+=4}if(isFinite(u)){e+=8}B=0;switch(e){case 15:if(G(K,r,n)){d[B]=p+F*(t-p);s[B]=J;B++}if(G(K,a,n)){s[B]=J+F*(L-J);d[B]=p;B++}if(G(r,u,n)){s[B]=J+F*(L-J);d[B]=t;B++}if(G(a,u,n)){d[B]=p+F*(t-p);s[B]=L;B++}break;case 14:if(G(r,u,n)){s[B]=J+F*(L-J);d[B]=t;B++}if(G(a,u,n)){d[B]=p+F*(t-p);s[B]=L;B++}if(G(a,r,n)){d[B]=p+F*(t-p);s[B]=L+F*(J-L);B++}break;case 13:if(G(K,a,n)){s[B]=J+F*(L-J);d[B]=p;B++}if(G(a,u,n)){d[B]=p+F*(t-p);s[B]=L;B++}if(G(K,u,n)){d[B]=p+F*(t-p);s[B]=J+F*(L-J);B++}break;case 11:if(G(r,u,n)){s[B]=J+F*(L-J);d[B]=t;B++}if(G(K,r,n)){d[B]=p+F*(t-p);s[B]=J;B++}if(G(K,u,n)){d[B]=p+F*(t-p);s[B]=J+F*(L-J);B++}break;case 7:if(G(K,a,n)){s[B]=J+F*(L-J);d[B]=p;B++}if(G(K,r,n)){d[B]=p+F*(t-p);s[B]=J;B++}if(G(a,r,n)){d[B]=p+F*(t-p);s[B]=L+F*(J-L);B++}break}seglist=null;if(B>0){if(B==2){seglist=this.contourNewSeg(d[0],s[0],d[1],s[1],seglist)}else{if(B==4){for(B=3;B>=1;B--){v=B;p=d[B];for(A=0;A<B;A++){if(d[A]>p){p=d[A];v=A}}if(v!=B){p=d[B];J=s[B];d[B]=d[v];s[B]=s[v];d[v]=p;s[v]=J}}seglist=this.contourNewSeg(d[0],s[0],d[1],s[1],seglist);seglist=this.contourNewSeg(d[2],s[2],d[3],s[3],seglist)}else{alert("k is "+B+" and it should be 2 or 4")}}}b[D+C*I]=seglist}}return b};this.contour=function(l,g,f,d){var e=this;contourSegDir=function(C,A,z,E,c,D){var B=function(y,x){return Math.abs(y-x)==0};if(B(A,E[v])){if(v==0){return 0}v=v-1;return 3}if(B(C,z[m])){if(m==0){return 0}m=m-1;return 4}if(B(A,E[v+1])){if(v>=D-1){return 0}v=v+1;return 1}if(B(C,z[m+1])){if(m>=c-1){return 0}m=m+1;return 2}return 0};var q=function(I,G,F,H,A){var U=I.length;var T=G.length;var c,C,V;var W,L;var S,R,K,E,B;var O=[];var D=e.contourLines(I,G,F,H,A);var Q=25000;for(var P=0;P<U-1;P++){for(var N=0;N<T-1;N++){var M=[];var J=[];while((S=D[P+N*U])){m=P;v=N;E=B=S;D[P+N*U]=S.next;c=S.x1;C=S.y1;while((L=contourSegDir(c,C,I,G,U,T))){V=e.contourSegUpdate(c,C,L,true,D[m+v*U],R);if(V){D[m+v*U]=V[0];R=V[1]}else{D[m+v*U]=null;R=null}if(!R){break}B.next=R;B=R;c=B.x1;C=B.y1}B.next=null;m=P;v=N;c=S.x0;C=S.y0;while((L=contourSegDir(c,C,I,G,U,T))){V=e.contourSegUpdate(c,C,L,false,D[m+v*U],R);if(V){D[m+v*U]=V[0];R=V[1]}else{D[m+v*U]=null;R=null}if(!R){break}R.next=E;E=R;c=E.x0;C=E.y0}K=E;W=0;while(K&&W<Q){W++;K=K.next}if(W==Q){alert("Reached max contour segments")}K=E;W=0;M[W]=K.x0;J[W++]=K.y0;while(K.next&&W<Q){K=K.next;M[W]=K.x0;J[W++]=K.y0}M[W]=K.x1;J[W++]=K.y1}if(M.length){O.push({x:M,y:J})}}}return O};if(!l.length){throw new Error("missing x data")}if(!g.length){throw new Error("missing y data")}if(!f.length){throw new Error("missing z data")}if(l.length*g.length!=f.length){throw new Error("dimensions of 'x', 'y' and 'z' do not match")}var p=this.range(f);var u=p[0];var o=p[1];if(!d){d=this[this.axisAlgorithm](u,o,this.contourLevelNumber)}var w=[];var a=0.001*(o-u);var m,v;for(var t=0;t<d.length;t++){var h=q(l,g,f,d[t],a);var b=[];for(var s=0;s<h.length;s++){var n=[];for(var r=0;r<h[s].x.length;r++){n.push([h[s].x[r],h[s].y[r]])}b.push(n)}w.push({type:"Multipolygon",value:d[t],coordinates:[b]})}return w};this.contourFindCutPoints=function(l,d,b,p,f,a,n,e,o,m,h,q){var g;if(f>e){if(e>d||f<l){return q}if(f<d){o[q]=b;m[q]=p;h[q]=f;++q}else{if(f==Number.POSITIVE_INFINITY){o[q]=a;m[q]=p;h[q]=e;++q}else{g=(f-d)/(f-e);o[q]=b+g*(a-b);m[q]=p;h[q]=f+g*(e-f);++q}}if(e==Number.NEGATIVE_INFINITY){o[q]=b;m[q]=p;h[q]=f;++q}else{if(e<=l){g=(e-l)/(e-f);o[q]=a-g*(a-b);m[q]=p;h[q]=e-g*(e-f);++q}}}else{if(f<e){if(e<l||f>d){return q}if(f>l){o[q]=b;m[q]=p;h[q]=f;++q}else{if(f==Number.NEGATIVE_INFINITY){o[q]=a;m[q]=p;h[q]=e;++q}else{g=(f-l)/(f-e);o[q]=b+g*(a-b);m[q]=p;h[q]=f+g*(e-f);++q}}if(e<d){o[q]=a;m[q]=n;h[q]=e;++q}else{if(e==Number.POSITIVE_INFINITY){o[q]=b;m[q]=p;h[q]=f;++q}else{g=(e-d)/(e-f);o[q]=a-g*(a-b);m[q]=p;h[q]=e-g*(e-f);++q}}}else{if(l<=f&&f<=d){o[q]=b;m[q]=p;h[q]=f;++q;o[q]=a;m[q]=n;h[q]=e;++q}}}return q};this.contourFindPolygonVertices=function(g,d,b,a,n,l,e,q,c,p,m,h,f){var o=0;o=this.contourFindCutPoints(g,d,b,n,e,a,n,q,m,h,f,o);o=this.contourFindCutPoints(g,d,n,a,q,l,a,p,h,m,f,o);o=this.contourFindCutPoints(g,d,a,l,p,b,l,c,m,h,f,o);o=this.contourFindCutPoints(g,d,l,b,c,n,b,e,h,m,f,o);return o};this.filledContour=function(g,f,e,r){if(!g.length){throw new Error("missing x data")}if(!f.length){throw new Error("missing y data")}if(!e.length){throw new Error("missing z data")}if(g.length*f.length!=e.length){throw new Error("dimensions of 'x', 'y' and 'z' do not match")}var o=this.range(e);var q=o[0];var t=o[1];if(!r){r=this[this.axisAlgorithm](q,t,this.contourLevelNumber)}var w=g.length;var u=f.length;var a=r.length;var b={};for(i=1;i<w;i++){for(j=1;j<u;j++){for(k=1;k<a;k++){if(!b.hasOwnProperty(r[k-1])){b[r[k-1]]=[]}var p=[];var n=[];var m=[];var h=this.contourFindPolygonVertices(r[k-1],r[k],g[i-1],g[i],f[j-1],f[j],e[i-1+(j-1)*w],e[i+(j-1)*w],e[i-1+j*w],e[i+j*w],p,n,m);var d=[];if(h>2){for(var v=0;v<p.length;v++){d.push([p[v],n[v]])}d.push([d[0][0],d[0][1]]);b[r[k-1]].push(d)}}}}var s=[];for(k=1;k<a;k++){if(b.hasOwnProperty(r[k-1])){s.push({type:"Multipolygon",value:r[k-1],coordinates:[b[r[k-1]]]})}}return s.length?s:false}};CanvasXpress.prototype.initDensity=function(){this.binDist=function(m,o,j,d,b){var p=0;var f=b-2;var k=(d-j)/(b-1);var l=[];for(var h=0;h<2*b;h++){l[h]=0}for(var h=0;h<m.length;h++){if(isFinite(m[h])){var g=(m[h]-j)/k;if(g>Number.MAX_VALUE||g<Number.MIN_VALUE){continue}var c=Math.floor(g);var e=g-c;var a=o[h];if(p<=c&&c<=f){l[c]+=(1-e)*a;l[c+1]+=e*a}else{if(c==-1){l[0]+=e*a}else{if(c==f+1){l[c]+=(1-e)*a}}}}}return l};this.calculateApprox=function(a,g,e){var c=function(h){var m=0;var k=a.length-1;while(m<k-1){var l=parseInt((m+k)/2);if(h<a[l]){k=l}else{m=l}}return g[m]+(g[k]-g[m])*((h-a[m])/(a[k]-a[m]))};var b=[];for(var d=0;d<e.length;d++){var f=c(e[d]);b.push(isNaN(f)?0:Math.max(0,f))}return b};this.calculateApproxStack=function(e,g){var a=[];var h=[];for(var c=0;c<e.length;c++){a.push(e[c][0]);h.push(e[c][1])}var d=[];for(var c=0;c<g.length;c++){d.push(g[c][0])}var b=this.calculateApprox(a,h,d);var f=[];for(var c=0;c<d.length;c++){f.push([g[c][0],b[c]])}return f};this.calculateDensity=function(p,z){var l=[];for(var t=0;t<p.length;t++){if(isFinite(p[t])){l.push(p[t])}}if(!z||!z.length){z=this.rep(1/l.length,l.length)}var q=Math.max(512,l.length);if(q>512){q=Math.pow(Math.ceil(Math.log2(q)),2)}var v=this[this.bandwidthRule+"Rule"](l)*this.bandwidthAdjust;var s=this.min(l)-this.bandwidthCut*v;var b=this.max(l)+this.bandwidthCut*v;var h=s-4*v;var m=b+4*v;var j=this.binDist(l,z,h,m,q);var f=this.seq(0,2*(m-h),false,2*q);var o=1;for(var t=q+1;t<q*2;t++){f[t]=-f[q-o++]}switch(this.densityKernel){case"gaussian":f=this.dnorm(f,0,v);break;case"rectangular":var B=v*Math.sqrt(3);for(var t=0;t<f.length;t++){f[t]=Math.abs(f[t])<B?0.5/B:0}break;case"triangular":var B=v*Math.sqrt(6);for(var t=0;t<f.length;t++){f[t]=Math.abs(f[t]);f[t]=f[t]<B?(1-f[t]/B)/B:0}break;case"epanechnikov":var B=v*Math.sqrt(5);for(var t=0;t<f.length;t++){f[t]=Math.abs(f[t]);f[t]=f[t]<B?0.75*(1-Math.pow((f[t]/B),2))/B:0}break;case"quartic":case"biweight":var B=v*Math.sqrt(7);var A=15/16;for(var t=0;t<f.length;t++){f[t]=Math.abs(f[t]);f[t]=f[t]<B?A*Math.pow(1-Math.pow((f[t]/B),2),2)/B:0}break;case"cosine":var B=v/Math.sqrt(1/3-2/Math.pow(Math.PI,2));for(var t=0;t<f.length;t++){f[t]=Math.abs(f[t])<B?(1+Math.cos(Math.PI*f[t]/B))/(2*B):0}break;case"optcosine":var B=v/Math.sqrt(1-8/Math.pow(Math.PI,2));for(var t=0;t<f.length;t++){f[t]=Math.abs(f[t])<B?Math.PI/4*Math.cos(Math.PI*f[t]/(2*B))/B:0}break}var c=this.fft(j);var k=this.fft(f);this.complexConj(k);var r=this.complexProd(c,k);f=this.fft(r[0],r[1],true);var w=[];for(var t=0;t<q;t++){w[t]=Math.max(0,f[0][t])/(q*2)}var g=this.seq(h,m,false,q);var u=this.seq(s,b,false,q);var e=this.calculateApprox(g,w,u);return{x:u,y:e,bw:v,summX:this.boxplot(u),summY:this.boxplot(e)}};this.kde2d=function(p,m,k,c,o){if(!c){c=25}if(!Array.isArray(c)){c=this.rep(c,2)}if(p.length!=m.length){throw new Error("data vectors must be the same length")}if(!p.every(function(h){return isFinite(h)})||!m.every(function(h){return isFinite(h)})){throw new Error("missing or infinite values in the data are not allowed")}if(!o){o=[this.range(p),this.range(m)]}if(!o[0].every(function(h){return isFinite(h)})||!o[1].every(function(h){return isFinite(h)})){throw new Error("only finite values are allowed in 'lims'")}if(!k){k=[this.nrdRule(p)/4,this.nrdRule(m)/4]}var s=this.seq(o[0][0],o[0][1],false,c[0]);var r=this.seq(o[1][0],o[1][1],false,c[1]);var a=[];for(var g=0;g<s.length;g++){a[g]=[];for(var f=0;f<p.length;f++){a[g][f]=this.dnorm((s[g]-p[f])/k[0])}}var t=[];for(var g=0;g<m.length;g++){t[g]=[];for(var f=0;f<r.length;f++){t[g][f]=this.dnorm((r[f]-m[g])/k[1])}}var l=[];for(var g=0;g<c[0];g++){l[g]=[];for(var f=0;f<c[1];f++){l[g][f]=0}}for(var d=0;d<s.length;d++){for(var b=0;b<r.length;b++){l[d][b]=0;for(var g=0;g<p.length;g++){l[d][b]+=a[d][g]*t[g][b]}l[d][b]/=(p.length*k[0]*k[1])}}var e=[];for(var d=0;d<r.length;d++){for(var b=0;b<s.length;b++){e.push(l[b][d])}}var q={x:s,y:r,z:e};return q}};CanvasXpress.prototype.initLayout=function(){this.isLayoutComb=function(){return(this.scatterPlotMatrix||this.isDOE||(this.graphType=="Pie"&&!this.isDOE&&this.xAxis.length>1)||(this.graphType!="Circular"&&(this.segregateVariablesBy.length||this.segregateSamplesBy.length)))?true:false};this.isValidLayout=function(){var b=this.layoutTopology?this.layoutTopology.split(/X/i):this.layout.split(/X/i);if(this.layoutTopology){this.layoutRows=b[0];this.layoutCols=b[1]}else{if(this.layout){this.layoutRows=b[0];this.layoutCols=b[1]}else{this.layoutRows=1;this.layoutCols=1;this.layoutValid=false}}if(!this.scatterPlotMatrix&&this.layoutComb&&this.data.l&&(this.data.l.vars||this.data.l.smps)&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];if(this.data.l.vars&&this.data.l.smps){var q={};for(var o=0;o<this.data.y.vars.length;o++){if(!q[this.data.y.vars[o]]){q[this.data.y.vars[o]]=[]}q[this.data.y.vars[o]].push(o)}var t={};for(var o=0;o<this.data.y.smps.length;o++){if(!t[this.data.y.smps[o]]){t[this.data.y.smps[o]]=[]}t[this.data.y.smps[o]].push(o)}var s=0;var p=this.layoutTypeVariablesFirst;if(this.layoutType=="wrap"||(this.layoutType=="cols"&&p)||this.layoutType=="rows"&&!p){for(var o=0;o<this.data.l.smps.length;o++){var f=[];var e=this.data.l.smps[o].length;for(var m=0;m<e;m++){for(var h=0;h<t[this.data.l.smps[o][m]].length;h++){f.push(t[this.data.l.smps[o][m]][h])}}for(var m=0;m<this.data.l.vars.length;m++){var d=[];var e=this.data.l.vars[m].length;for(var h=0;h<e;h++){for(var g=0;g<q[this.data.l.vars[m][h]].length;g++){d.push(q[this.data.l.vars[m][h]][g])}}this.data.l.comp[s]=[d,f];s++}}}else{for(var o=0;o<this.data.l.vars.length;o++){var d=[];var e=this.data.l.vars[o].length;for(var m=0;m<e;m++){for(var h=0;h<q[this.data.l.vars[o][m]].length;h++){d.push(q[this.data.l.vars[o][m]][h])}}for(var m=0;m<this.data.l.smps.length;m++){var f=[];var e=this.data.l.smps[m].length;for(var h=0;h<e;h++){for(var g=0;g<t[this.data.l.smps[m][h]].length;g++){f.push(t[this.data.l.smps[m][h]][g])}}this.data.l.comp[s]=[d,f];s++}}}}else{if(this.data.l.vars){if(this.isUnique(this.data.y.smps)){var a={};var u=this.isHistogram?"smps":"vars";for(var o=0;o<this.data.y[u].length;o++){if(!a[this.data.y[u][o]]){a[this.data.y[u][o]]=[]}a[this.data.y[u][o]].push(o)}for(var o=0;o<this.data.l.vars.length;o++){this.data.l.comp[o]=[];var e=this.data.l.vars[o].length;for(var m=0;m<e;m++){if(!this.isDOE&&this.data.l.vars[o][m]){for(var h=0;h<a[this.data.l.vars[o][m]].length;h++){this.data.l.comp[o].push(a[this.data.l.vars[o][m]][h])}}}}}else{for(var o=0;o<this.data.l.ids.length;o++){this.data.l.comp[o]=[];var e=this.data.l.ids[o].length;var a={};for(var m=0;m<this.data.l.ids[o].length;m++){if(!a[this.data.y.vars[this.data.l.ids[o][m]]]){a[this.data.y.vars[this.data.l.ids[o][m]]]=[]}a[this.data.y.vars[this.data.l.ids[o][m]]].push(this.data.l.ids[o][m])}for(var m=0;m<e;m++){if(!this.isDOE){for(var h=0;h<a[this.data.y.vars[this.data.l.ids[o][m]]].length;h++){this.data.l.comp[o].push(a[this.data.y.vars[this.data.l.ids[o][m]]][h])}}}}}}else{if(this.isUnique(this.data.y.smps)){var a={};for(var o=0;o<this.data.y.smps.length;o++){if(!a[this.data.y.smps[o]]){a[this.data.y.smps[o]]=[]}a[this.data.y.smps[o]].push(o)}for(var o=0;o<this.data.l.smps.length;o++){this.data.l.comp[o]=[];var e=this.data.l.smps[o].length;for(var m=0;m<e;m++){if(!this.isDOE){for(var h=0;h<a[this.data.l.smps[o][m]].length;h++){this.data.l.comp[o].push(a[this.data.l.smps[o][m]][h])}}}}}else{for(var o=0;o<this.data.l.ids.length;o++){this.data.l.comp[o]=[];var e=this.data.l.ids[o].length;var a={};for(var m=0;m<this.data.l.ids[o].length;m++){if(!a[this.data.y.smps[this.data.l.ids[o][m]]]){a[this.data.y.smps[this.data.l.ids[o][m]]]=[]}a[this.data.y.smps[this.data.l.ids[o][m]]].push(this.data.l.ids[o][m])}for(var m=0;m<e;m++){if(!this.isDOE){for(var h=0;h<a[this.data.y.smps[this.data.l.ids[o][m]]].length;h++){this.data.l.comp[o].push(a[this.data.y.smps[this.data.l.ids[o][m]]][h])}}}}}}}this.layoutValid=true}else{if(this.layoutComb&&this.data.l&&this.data.l.smps&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];var r=[];for(var o=0;o<this.data.y.vars.length;o++){r.push(o)}for(var o=0;o<this.data.l.type.length;o++){this.data.l.comp[o]=r}this.layoutValid=true}else{if(this.data.l&&this.data.l.comp){if(this.data.l.comp.length<=(this.layoutRows*this.layoutCols)){this.layoutValid=true}else{this.layoutValid=false}}else{this.layoutValid=false}}}if(this.layoutValid){this.meta.config.orig.adjustAspectRatio=this.adjustAspectRatio;this.adjustAspectRatio=true;this.layoutComb=true}};this.validateLayoutTopology=function(){var a=this.layoutTopology?this.layoutTopology.split(/X/i):this.layout.split(/X/i);if(this.layoutTopology){if(this.layoutRows==a[0]&&this.layoutCols==a[1]){return}}else{if(this.layout){if(this.layoutRows==a[0]&&this.layoutCols==a[1]){return}}}this.isValidLayout();var e=1/this.layoutCols;var d=1/this.layoutRows;for(var b=0;b<this.data.l.comp.length;b++){this.data.l.weight[b]=[e,d]}};this.setLayoutFonts=function(){this.setLegends();if(this.graphType.match(/Scatter/)){this.set2DFont()}else{if(this.graphType=="Pie"){this.setPieFont()}else{this.set1DFont()}}};this.getLayoutAxisTitleHeight=function(a){var b=0;if(this.graphType=="Treemap"||this.graphType=="TagCloud"||this.graphType=="Pie"||this.graphType=="Heatmap"){return 0}else{if(this.graphType.match(/Scatter/)){if(a){return this.yAxisTitle?this.axisTitleFontSize+(this.margin*2):0}else{return this.xAxisTitle?this.axisTitleFontSize+(this.margin*2):0}}else{if(this.graphOrientation=="vertical"){b=a?this.getAxisDescription(true):this.getAxisDescription();b=b!=""?this.axisTitleFontSize+(this.margin*2):0}else{b=a?this.getAxisDescription(true):this.getAxisDescription();b=b!=""?this.axisTitleFontSize+(this.margin*2):0}}}return b};this.setLayoutSameSamples=function(){var f=[];if(this.data.l.group&&this.data.l.smps){for(var d=0;d<this.data.l.smps.length;d++){var a={};for(var c=0;c<this.data.l.ids[d].length;c++){var k=this.data.l.ids[d][c];var l=[];for(var b=0;b<this.data.l.group.length;b++){var e=this.data.l.group[b];var g=this.getMetadataValue(k,"x",e,true);if(g==null){g="NA"}l.push(g)}l=l.sort();a[l.join("")]=true}f.push(Object.keys(a).sort())}for(var c=1;c<f.length;c++){if(!this.isSameObject(f[c-1],f[c])){this.layoutSameSamples=false;return}}this.layoutSameSamples=true}else{this.layoutSameSamples=false}};this.setLayoutLeft=function(){var a=0;if(this.isDOE||this.graphType=="Meter"){a=0}else{if(this.graphType.match(/Scatter/)){if(this.showLegend){a+=this.legendPosition=="left"?this.legendWidth:this.margin}if(!this.layoutAdjust||this.layoutAdjust=="axis"||this.scatterPlotMatrixType.match(/correlation|all/)){a+=this.get2DYAxisWidth()}else{a+=this.getLayoutAxisTitleHeight()}}else{if(this.graphType=="Pie"){a=(this.margin*2)+this.measureText("XX",this.smpLabelFont)}else{if(this.graphType=="Heatmap"){a=0}else{if(!this.layoutAdjust){if(this.segregateVariablesBy.length>0){if(this.graphOrientation!="vertical"){a=this.getSampleLabelLength()}else{a=this.getAxisTitleTickLength()}}else{if(this.segregateSamplesBy.length>0){if(this.graphOrientation=="vertical"){a=this.getAxisTitleTickLength()}}}}else{if(this.graphOrientation!="vertical"){if(this.segregateVariablesBy.length){a=this.getSampleLabelLength()}else{if(this.segregateSamplesBy.length&&!this.layout.match(/X1/)){this.setLayoutSameSamples();if(this.layoutSameSamples){a=this.getSampleLabelLength()}}}}}if(this.graphOrientation=="vertical"){a+=this.getLayoutAxisTitleHeight()}else{a+=this.smpTitle?this.smpTitleFontSize+(this.margin*2):0}}}}if(this.showLegend){a+=this.legendPosition=="left"?this.legendWidth:this.margin}}return a};this.setLayoutRight=function(){var a=0;var b=this.layoutType=="rows"||(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1);if(this.isDOE||this.graphType=="Meter"){a=0}else{if(this.graphType.match(/Scatter/)){if(this.scatterPlotMatrix&&this.showScatterPlotMatrixLabels&&this.scatterPlotMatrixType!="first"){a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="rows"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0){a+=this.get2DYAxisWidth(true);a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1){a+=this.get2DYAxisWidth(true);a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="wrap"){a+=this.get2DYAxisWidth(true)}else{if(!this.layoutAdjust){a+=this.get2DYAxisWidth(true)}}}}}}else{if(this.graphType=="Heatmap"){if(this.layoutType=="rows"||(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1)){a+=this.layoutLabelBoxThickness}else{return 0}}else{if(!this.layoutAdjust){if(this.graphOrientation=="vertical"&&!b){a=this.getAxisTitleTickLength(true)}}else{a=0}if(this.graphOrientation=="vertical"&&!b){a+=this.getLayoutAxisTitleHeight(true)}if(b){a+=this.layoutLabelBoxThickness}}}if(this.showLegend){a+=this.legendPosition=="right"&&this.legendWidth?this.legendWidth+(this.margin*2):this.margin}}return a};this.setLayoutTop=function(){if(this.isDOE){return 0}var a=this.getTitleSubtitleHeight();var b=this.layoutType=="cols"||(this.layoutType=="rows"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1);if(this.graphType=="Pie"){a+=this.layoutLabelBoxThickness}else{if(this.graphType.match(/Scatter/)){if(this.showLegend&&this.legendPosition=="top"){a+=this.legendHeight}if(this.scatterPlotMatrix&&this.showScatterPlotMatrixLabels&&this.scatterPlotMatrixType!="first"){a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="rows"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1){a+=this.get2DXAxisHeight(true);a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0){a+=this.get2DXAxisHeight(true);a+=this.layoutLabelBoxThickness}else{if(this.layoutType=="wrap"){a+=this.get2DXAxisHeight(true)}else{if(!this.layoutAdjust){a+=this.get2DXAxisHeight(true)}}}}}}else{if(this.graphType!="Heatmap"){if(this.showLegend&&this.legendPosition=="top"){a+=this.legendHeight}if(!this.layoutAdjust){if(this.graphOrientation!="vertical"&&!b){a+=this.getAxisTitleTickLength()}}if(this.graphOrientation!="vertical"&&!b){a+=this.getLayoutAxisTitleHeight()}}if(b){a+=this.layoutLabelBoxThickness}}}return a};this.setLayoutBottom=function(){var a=0;if(this.isDOE||this.graphType=="Meter"){a=0}else{if(this.graphType.match(/Scatter/)){if(!this.layoutAdjust||this.layoutAdjust=="axis"||this.scatterPlotMatrixType.match(/correlation|all/)){a=this.get2DXAxisHeight()}else{a+=this.getLayoutAxisTitleHeight()}if(this.showLegend&&this.legendPosition=="bottom"){a+=this.legendHeight}}else{if(this.graphType=="Pie"){if(this.showLegend&&this.legendPosition=="bottom"){}}else{if(this.graphType=="Heatmap"){a=this.getHeatmapIndicatorHeight()}else{if(!this.layoutAdjust){if(this.graphOrientation!="vertical"){a=this.getAxisTitleTickLength(true)}}if(this.graphOrientation=="vertical"){if(this.segregateVariablesBy.length>0){a=this.getSampleLabelLength()}else{if(this.segregateSamplesBy.length&&!this.layout.match(/1X/)){this.setLayoutSameSamples();if(this.layoutSameSamples){a=this.getSampleLabelLength()}}}a+=this.smpTitle?this.smpTitleFontSize+(this.margin*2):0}else{a+=this.getLayoutAxisTitleHeight(this.layoutType=="cols"?false:true);if(this.layoutType=="rows"&&this.isGroupedData){a+=this.axisTitleFontSize}}if(this.showLegend&&this.legendPosition=="bottom"){a+=this.getLegendHeight("bottom")}}}}}a+=this.getCitationHeight();return a};this.drawLayoutSampleOverlays=function(b){var a=this.smpIndices;this.smpIndices=b;this.smpIndices=a;this.showSampleNames=true;this.showOverlays=true;this.draw1DYLayout()};this.setLayoutDimensions=function(){this.offsetX=0;this.offsetY=0;this.layoutLeft=this.setLayoutLeft();this.layoutRight=this.setLayoutRight();this.layoutTop=this.setLayoutTop();this.layoutBottom=this.setLayoutBottom();if(this.layoutCanvasCompartments){var a=this.width-(this.marginLeft+this.layoutLeft+this.marginRight+this.layoutRight);var b=this.height-(this.marginTop+this.layoutTop+this.marginBottom+this.layoutBottom);this.toRender({p:["drawShape","rectangle",this.marginLeft+this.layoutLeft+(a/2),this.marginTop+this.layoutTop+(b/2),a,b,false,this.canvasBoxColor,"open"],t:"Size"})}};this.setLayoutLegends=function(){var a=this.isGroupedData;this.isGroupedData=false;this.setLayoutFonts();if(this.graphType=="Pie"||this.isDOE){this.setVariableLegendDimension()}else{if(this.graphType.match(/Scatter/)||this.isMultidimensionalData||((this.isAttributedGraph()||this.connectBy)&&this.graphType.match(/^Bar$|Boxplot|Dotplot|Treemap|Heatmap/))){this.validatePropertyValues(true);if(this.isHistogram){this.setSampleLegendDimension()}}else{this.setVariableLegendDimension()}}this.isGroupedData=a};this.setLayoutDOETables=function(){if(this.isDOE&&!this.layoutDOETables){this.layoutDOETables={}}};this.drawLabelsTitlesLayout=function(){var k=0;var f=0;var q=0;var C=0;var D=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var b=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);if(this.graphType=="Treemap"){return}if(this.graphType=="Pie"&&(this.showPieGrid||this.showPieSampleLabel)){var z,m;var A=0;this.setMainFont();var s=this.getFontPt(this.font);var d=this.marginTop;var a=this.marginLeft+this.layoutLeft;var n=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];for(var v=0;v<this.layoutRows;v++){z=b*this.layoutParams[A].weight[1];k=(this.marginLeft+this.layoutLeft)-this.margin;d+=z;if(this.showPieGrid){this.toRender({p:["drawText",n[v],k,d-((z/2)+(this.margin*0)),this.font,this.foreground,"right","middle"],t:"LabelsTitle"})}for(var u=0;u<this.layoutCols;u++){if(this.xAxis.length<=A){break}m=D*this.layoutParams[A].weight[0];a+=m;f=(this.marginTop+this.layoutTop)-(this.layoutLabelBoxThickness/2);if(v==0){if(this.showPieGrid){this.toRender({p:["drawText",u+1,(a+(s/2))-(m/2),f,this.font,this.foreground,"center","bottom"],t:"LabelsTitle"})}}if(this.showPieSampleLabel){this.toRender({p:["drawText",this.xAxis[A],a-(m/1.1),d-(z/5),this.legendFont,this.foreground,"center","middle"],t:"LabelsTitle"})}A++}a=this.marginLeft+this.layoutLeft}}else{if(this.graphType.match(/Scatter/)){if(this.yAxisTitle){var B=((this.height-(this.marginTop+this.layoutTop+this.marginBottom+this.layoutBottom))/2)+(this.marginTop+this.layoutTop);var o=this.marginLeft+this.margin+(this.axisTitleFontSize/2)+((this.showLegend&&this.legendPosition=="left"?this.legendWidth:0)-this.margin);this.toRender({p:["drawText",this.yAxisTitle,o,B,this.axisTitleFont,this.axisTitleFontColor,"center","middle",-Math.PI/2],t:"LabelsTitle"})}if(this.xAxisTitle){var t=0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.axisTitleFontSize/2)+t+(this.showLegend&&this.legendPosition=="bottom"?this.legendHeight:0)+this.getCitationHeight();this.toRender({p:["drawText",this.xAxisTitle,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"],t:"LabelsTitle"})}if(this.zAxisTitle){var B=((this.height-(this.marginTop+this.layoutTop+this.marginBottom+this.layoutBottom))/2)+(this.marginTop+this.layoutTop);var o=this.width-((this.axisTitleFontSize/2)+((this.showLegend&&this.legendPosition=="right"?this.legendWidth:0)+(this.margin*2)));this.toRender({p:["drawText","Size : "+this.zAxisTitle,o,B,this.axisTitleFont,this.axisTitleFontColor,"center","middle",Math.PI/2],t:"LabelsTitle"})}}else{if(this.graphType=="Heatmap"){this.draw1DXLayout()}if(this.smpTitle&&this.graphType!="Heatmap"){if(this.graphOrientation=="vertical"){var t=this.legendPosition=="bottom"?this.legendHeight:0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.smpTitleFontSize/2)+t+ +this.getCitationHeight();this.toRender({p:["drawText",this.smpTitle,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.smpTitleFont,this.smpTitleFontColor,"center","middle"],t:"LabelsTitle"})}else{this.toRender({p:["drawText",this.smpTitle,this.marginLeft+this.margin+(this.smpTitleFontSize/2),this.height/2,this.smpTitleFont,this.smpTitleFontColor,"center","middle",-Math.PI/2],t:"LabelsTitle"})}}var g=this.getAxisDescription();var e=this.getAxisDescription(true,this.layoutType=="rows"&&this.isGroupedData);if(g!=""&&this.graphType!="Heatmap"&&this.xAxisShow&&this.layoutType!="rows"){if(this.graphOrientation=="vertical"){var o=this.marginLeft+this.margin+(this.axisTitleFontSize/2)+(this.showLegend&&this.legendPosition=="left"?this.legendWidth:0);var B=((this.height-this.layoutTop)/2)+this.layoutTop;this.toRender({p:["drawText",g,o,B,this.axisTitleFont,this.axisTitleFontColor,"center","middle",-Math.PI/2],t:"LabelsTitle"})}else{var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z;if(this.layoutType=="cols"){z=this.marginTop+this.layoutTop+this.layoutHeight+this.getTitleSubtitleHeight()}else{z=this.margin+(this.axisTitleFontSize/2)+this.getTitleSubtitleHeight()+(this.showLegend&&this.legendPosition=="top"?this.legendHeight:0)}this.toRender({p:["drawText",g,this.marginLeft+this.layoutLeft+(m/2),this.marginTop+z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"],t:"LabelsTitle"})}}if((e!=""&&this.graphType!="Heatmap"&&this.xAxis2Show)||(this.layoutType=="rows"&&this.isGroupedData)){if(this.graphOrientation=="vertical"){var t=this.legendPosition=="right"?this.legendWidth:0;var p=this.marginRight+this.margin+(this.axisTitleFontSize/2)+t;this.toRender({p:["drawText",e,this.width-p,this.height/2,this.axisTitleFont,this.axisTitleFontColor,"center","middle",Math.PI/2],t:"LabelsTitle"})}else{var t=this.legendPosition=="bottom"?this.legendHeight:0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var z=this.marginBottom+this.margin+(this.axisTitleFontSize/2)+t;this.toRender({p:["drawText",e,this.marginLeft+this.layoutLeft+(m/2),this.height-z,this.axisTitleFont,this.axisTitleFontColor,"center","middle"],t:"LabelsTitle"})}}}}};this.drawDOELabelsLayout=function(m){var g=this.foreground;var j=this.font;var e=this.measureText(m,j);var b=this.getFontPt(j)/2;var l=this.layoutWidth;var d=this.layoutHeight;var k=this.marginLeft+this.offsetX;var i=this.marginTop+this.offsetY;var a=k+l-5;var c=i+d-5;this.toRender({p:["drawText",m,k+20,i,j,g,"left","top"],t:"Labels"});this.toRender({p:["drawLine","line",k+b,i+b,k+15,i+b,g],t:"Labels"});this.toRender({p:["drawLine","line",k+e+25,i+b,a,i+b,g],t:"Labels"});this.toRender({p:["drawLine","line",a,i+b,a,c,g],t:"Labels"});this.toRender({p:["drawLine","line",k+b,c,a,c,g],t:"Labels"});this.toRender({p:["drawLine","line",k+b,i+b,k+b,c,g],t:"Labels"})};this.setLayoutWeights=function(){var a=this.data.l.weight;var d=this.layoutParams;var e=this.data.l.comp;if(a){if(this.isDOE||this.scatterPlotMatrix||(this.data.l.vars&&this.data.l.smps)){for(var b=0;b<a.length;b++){d[b].weight=a[b]}}else{if(this.graphType=="Pie"){for(var b=0;b<e.length;b++){d[b].weight=a[b]}}else{for(var b=0;b<a.length;b++){d[b].weight=a[b]}}}}else{if(e){a=[];for(var b=0;b<e.length;b++){a[b]=e.length;d[b].weight=a[b]}}else{alert("Wuz going on dude? This aint't gonna work!")}}};this.setLayoutGraphTypes=function(){var b=this.data.l.type;if(b){for(var a=0;a<b.length;a++){this.layoutParams[a].graphType=b&&b[a]?b[a]:this.graphType}}};this.setLayoutIndices=function(g){var b;var a=this.xAxis.length&&this.xAxis2.length?this.getVariableIndices(this.xAxis).concat(this.getVariableIndices(this.xAxis2)):this.varIndices;var c=this.getObjectArray(a);var f=this.getObjectArray(this.smpIndices);for(var e=0;e<this.data.l.comp.length;e++){if(this.data.l.vars&&this.data.l.smps){b=[];var c=this.getObjectArray(this.data.l.comp[e][0]);for(var d=0;d<a.length;d++){if(c.hasOwnProperty(a[d])){b.push(a[d])}}this.layoutParams[e].varIndices=b;b=[];var f=this.getObjectArray(this.data.l.comp[e][1]);for(var d=0;d<this.smpIndices.length;d++){if(f.hasOwnProperty(this.smpIndices[d])){b.push(this.smpIndices[d])}}this.layoutParams[e].smpIndices=b;this.setOriginalIndices(e,this.layoutParams[e].varIndices,this.layoutParams[e].smpIndices)}else{if(this.data.l.comp[e]){b=[];if(this.data.l.vars){var c=this.getObjectArray(this.data.l.comp[e]);for(var d=0;d<a.length;d++){if(c.hasOwnProperty(a[d])){b.push(a[d])}}this.layoutParams[e].varIndices=this.isHistogram?a:b;this.layoutParams[e].smpIndices=this.smpIndices;this.setOriginalIndices(e,this.layoutParams[e].varIndices,this.smpIndices)}else{var f=this.getObjectArray(this.data.l.comp[e]);for(var d=0;d<this.smpIndices.length;d++){if(f.hasOwnProperty(this.smpIndices[d])){b.push(this.smpIndices[d])}}this.layoutParams[e].varIndices=a;if(!this.layoutParams[e].smpIndices||this.layoutParams[e].smpIndices.length!=b.length){this.layoutParams[e].smpIndices=b}this.setOriginalIndices(e,a,this.layoutParams[e].smpIndices)}}else{if(this.data.l.vars){this.layoutParams[e].varIndices=[];this.layoutParams[e].smpIndices=this.smpIndices}else{this.layoutParams[e].varIndices=a;this.layoutParams[e].smpIndices=[]}}}this.layoutParams[e].varIndicesStart=-1;this.layoutParams[e].smpIndicesStart=-1;this.layoutParams[e].grpIndicesStart=-1}for(var e=0;e<this.data.l.type.length;e++){for(var d=0;d<g.length;d++){if(!this.layoutParams[e].hasOwnProperty(g[d])){this.layoutParams[e][g[d]]=this[g[d]]}}}};this.resetLayout=function(){delete (this.data.l);delete (this.layoutParams);this.offsetX=0;this.offsetY=0;this.layoutValidN=false;this.layoutValidR=false;this.layoutValidC=false;this.layoutValidBounds=false;this.layoutCurrent=false;this.layoutComb=false;this.layoutRestore=false;this.layout="1X1"};this.setDOE=function(){this.oneDPlot(true);this.Scatter2D(true);this.Scatter3D(true);this.Pie(true)};this.resetLayoutRestore=function(){this.layoutRestore=false};this.setLayoutRestore=function(){if(!this.layoutRestore){this.layoutRestore={};var c=["title","subtitle","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart","grpIndicesStart","smpTitle","showVariableNames","showSampleNames","showOverlays","showLegend","legendInside","showDecorationsLegend","xAxisShow","xAxis2Show","xAxisS2Show","yAxisShow","yAxisS2Show","xAxisTitle","xAxis2Title","yAxisTitle","zAxisTitle","legendLayout"];c.push("legendDecorationWidth");c.push("legendDecorationHeight");var a=["Color","Shape","Size","Pattern","Connect","Sample"];for(var b=0;b<a.length;b++){c.push("legend"+a[b]+"s");c.push("legend"+a[b]+"sMax");c.push("legend"+a[b]+"sN");c.push("legend"+a[b]+"sS");c.push("legend"+a[b]+"Width");c.push("legend"+a[b]+"Height")}for(var b=0;b<c.length;b++){this.layoutRestore[c[b]]=this[c[b]]}if(this.isGroupedData&&this.data.w){this.layoutRestore.isGroupedData=this.isGroupedData}}};this.setLayoutParams=function(){if(!this.layoutParams&&this.data.l.comp){this.layoutParams=[]}for(var a=0;a<this.data.l.type.length;a++){if(!this.layoutParams[a]){this.layoutParams[a]={}}}};this.removeEmptyCompartments=function(){if(this.layoutRemoveEmpty&&this.layoutParams&&!this.isDOE){var f={};var d=[];var g=["comp","desc","name","type","vars","smps","weight"];var h=0;for(var c=0;c<g.length;c++){if(this.data.l[g[c]]){f[g[c]]=[]}}for(var c=0;c<this.data.l.weight.length;c++){var b=this.layoutParams[c].varIndices.length;var e=this.layoutParams[c].smpIndices.length;if(b&&e){d.push(this.layoutParams[c]);for(var a=0;a<g.length;a++){if(this.data.l[g[a]]){f[g[a]].push(this.data.l[g[a]][c])}}if(this.data.l.group){f.group=this.data.l.group}h++}}if(h!=this.data.l.weight.length){this.stndByLayoutData={};this.stndByLayoutData.data=this.cloneObject(this.data.l);this.stndByLayoutData.pars=this.cloneObject(this.layoutParams);this.stndByLayoutData.layoutRows=this.layoutRows;this.stndByLayoutData.layoutCols=this.layoutCols;this.stndByLayoutData.layout=this.layout;this.data.l=f;this.layoutParams=d;this.layoutRows=Math.ceil(Math.sqrt(h));this.layoutCols=this.layoutRows*(this.layoutRows-1)>=h?this.layoutRows-1:this.layoutRows;this.layout=this.layoutRows+"X"+this.layoutCols;for(var c=0;c<this.data.l.weight.length;c++){this.data.l.weight[c]=[1/this.layoutCols,1/this.layoutRows]}}}};this.restoreEmptyCompartments=function(){if(this.stndByLayoutData){this.data.l=this.stndByLayoutData.data;this.layoutParams=this.stndByLayoutData.pars;this.layoutRows=this.stndByLayoutData.layoutRows;this.layoutCols=this.stndByLayoutData.layoutCols;this.layout=this.stndByLayoutData.layout;delete (this.stndByLayoutData)}};this.getLayoutAxisSamples=function(c){if(this.data.l.smps){if(this.graphType.match(/Scatter2D/)&&this.segregateSamplesBy&&this.segregateSamplesBy.length==1&&this.segregateSamplesBy[0]=="sample"){var e=this.cloneObject(this[c+"Axis"]);if(e[0]=="Bin"){if(c=="x"){return["Bin"]}else{e.shift();return e}}else{return this.cloneObject(this.data.y.smps)}}else{var e={};var b=c=="x"?0:1;for(var d=0;d<this.data.l.smps.length;d++){if(this.data.l.smps[d]&&(this.data.l.smps[d][b]||this.data.l.smps[d][b]==0)){e[this.data.l.smps[d][b]]=true}else{if(this.data.l.smps[d][c+"Axis"]){e[this.data.l.smps[d][c+"Axis"]]=true}}}return this.getKeys(e)}}else{if(this[c+"Axis"].length>0){return this[c+"Axis"]}else{return this.data.y.smps}}};this.preCalculateAdjustLayout=function(f){if(!this.isDOE&&this.graphType!="Pie"){delete this.xAxisLayoutMaxTickStr;delete this.xAxisLayoutMaxTickStrLength;delete this.xAxis2LayoutMaxTickStr;delete this.xAxis2LayoutMaxTickStrLength;delete this.yAxisLayoutMaxTickStr;delete this.yAxisLayoutMaxTickStrLength;var a=this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight;var g=this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom;var l=0;for(var e=0;e<this.layoutRows;e++){for(var d=0;d<this.layoutCols;d++){this.layoutCurrent=l;if(this.layoutParams.length<=l){break}if(this.layoutParams[l]){for(var b=0;b<f.length;b++){this[f[b]]=this.layoutParams[l].hasOwnProperty(f[b])?this.layoutParams[l][f[b]]:this[f[b]]}}this.setLayoutGraphDimensions(a,g,l);if(this.graphType.match(/Scatter/)||(this.graphType.match(/Boxplot/)&&this.scatterPlotMatrix)){this.drawLayoutCompartmentsScatter(a,g,e,d,l)}else{this.drawLayoutCompartmentsOneD(a,g,l)}l++}}this.restoreLayoutParameters()}};this.setLayoutHidden=function(){this.layoutHidden={};var b=["hiddenVars","hiddensSmps","hiddenLegends"];for(var a=0;a<b.length;a++){this.layoutHidden[b[a]]=this.cloneObject(this[b[a]])}};this.restoreLayoutHidden=function(){var b=["hiddenVars","hiddensSmps","hiddenLegends"];for(var a=0;a<b.length;a++){this[b[a]]=this.layoutHidden[b[a]]}};this.drawLayoutCompartments=function(b){var C=["left","right","top","bottom","x","y","offsetX","offsetY","graphType","summaryType","transformData","smpInfo","varInfo","minData","maxData","xAxisMin","xAxisMax","xAxisRange","xAxis2Min","xAxis2Max","xAxis2Range","yAxisMin","yAxisMax","yAxisRange","zAxisMin","zAxisMax","zAxisRange","xAxisAbsMin","xAxisAbsMax","xAxis2AbsMin","xAxis2AbsMax","yAxisAbsMin","yAxisAbsMax","zAxisAbsMin","zAxisAbsMax","xAxisUnit","xAxis2Unit","yAxisUnit","zAxisUnit"];var u=["layoutTop","layoutRight","layoutBottom","layoutLeft","layoutWidth","layoutHeight","layoutValid","layoutComb","offsetX","offsetY"];var f=["weight","graphType","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart","grpIndicesStart","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ"];if(this.layoutComb){this.validateLayoutTopology();if(this.isDOE){C.push("data");this.setDOE()}this.removeEmptyCompartments();if(this.graphType.match(/Scatter/)){this.dataPointSize=Number(Math.max(0.5,this.dataPointSize/Math.max(this.layoutRows,this.layoutCols)).toFixed(1));this.xAxisTmp=this.cloneObject(this.xAxis);this.yAxisTmp=this.cloneObject(this.yAxis);this.xAxis=this.getLayoutAxisSamples("x");this.yAxis=this.getLayoutAxisSamples("y");this.initializeAxis();this.xAxis=this.xAxisTmp;this.yAxis=this.yAxisTmp;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.meta.data.i={vars:this.cloneObject(this.varIndices),smps:this.cloneObject(this.smpIndices)}}else{if(this.data.l&&this.data.l.group){this.meta.data.i={vars:this.cloneObject(this.varIndices),smps:this.cloneObject(this.smpIndices),grps:this.cloneObject(this.grpIndices)};this.meta.data.g=this.data.w;if(this.stackBy&&this.data.l.group.length){this.groupSamples(this.data.l.group,false,false,true,true,true);this.initializeAxis()}}else{this.initAxes()}}this.setLayoutDOETables();this.setLayoutLegends();this.setLayoutRestore();this.setLayoutParams();this.setLayoutWeights();this.setLongestLayoutLabel();this.setLayoutGraphTypes();this.setLayoutIndices(f);this.preCalculateAdjustLayout(f);this.setLayoutHidden();this.setLayoutDimensions();this.title="";this.subtitle="";this.offsetX=this.layoutLeft;this.offsetY=this.graphType=="Pie"?0:this.layoutTop;var g=this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight;var z=this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom;var B=0;for(var y=0;y<this.layoutRows;y++){for(var v=0;v<this.layoutCols;v++){this.layoutCurrent=B;this.layoutCurrentR=y;this.layoutCurrentC=v;if(this.isDOE){if(this.dataStndBy.l.smps.length<=B){break}if(this.offsetY+this.layoutHeight>this.height){break}}else{if(this.graphType=="Pie"){if(this.data.l.smps.length<=B){break}}else{if(this.isCreateHistogram){if(this.data.l.axes.length>=B){}}else{if(this.layoutParams.length<=B){break}}}}if(this.layoutParams[B]){for(var t=0;t<f.length;t++){this[f[t]]=this.layoutParams[B].hasOwnProperty(f[t])?this.layoutParams[B][f[t]]:this[f[t]]}}this.setLayoutGraphDimensions(g,z,B);if(this.isDOE){this.offsetX=this.layoutLeft+((this.width-g)/this.layoutCols*this.dataStndBy.l.coords[B][1]);this.offsetY=this.layoutTop+((this.height-z)/this.layoutRows*this.dataStndBy.l.coords[B][0]);this.drawLayoutCompartmentsDOE(g,z,B)}else{if(this.graphType.match(/Scatter/)||(this.graphType.match(/Boxplot/)&&this.scatterPlotMatrix)){this.drawLayoutCompartmentsScatter(g,z,y,v,B)}else{if(this.graphType=="Pie"){this.drawLayoutCompartmentsPie(g,z,B)}else{if(!this.scatterPlotMatrix){this.drawLayoutCompartmentsOneD(g,z,B)}}}}var D={};if(this.layoutConfig&&this.layoutConfig[B]){for(var q in this.layoutConfig[B]){D[q]=this.cloneObject(this[q]);this[q]=this.layoutConfig[B][q]}}if(!this.isDOE&&this.varIndices.length>0&&this.smpIndices.length>0){if(this.scatterPlotMatrix){if(this.scatterPlotMatrixType.match(/correlation|all/)){if(v>y){if(this.scatterPlotMatrixType.match(/all/)&&v==this.layoutCols-1){var A=this.cloneObject(this.data.l.data[B]);var n=this.data.l.params[B];if(A&&n){var o={};for(var q in n){o[q]=this[q];this[q]=n[q]}if(this.scatterType=="boxplot"&&this.isTransformedData){for(t=0;t<A.y.vars.length;t++){A.y.data[t][1]=this.transformValue(this.isTransformedData,A.y.data[t][1])}}this.initializeData(A,false,true);this.initializeAxis();b.call(this);for(var q in o){this[q]=o[q]}this.switchData(false,true)}}}else{if(v==y||(y==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/))){var l=y==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/)?v:y;var m=this.data.l.group&&this.meta.data.d.z[this.data.l.group]&&this.meta.data.d.z[this.data.l.group][l]&&this.meta.data.d.z[this.data.l.group][l][this.data.y.smps[this.smpIndices[l]]]?this.meta.data.d.z[this.data.l.group][l][this.data.y.smps[this.smpIndices[l]]]:this.meta.data.d.s[l]?this.meta.data.d.s[l]:false;if(m&&this.scatterPlotMatrixType!="correlation"){this.data.l.data[B]=m.data;for(var q in m.params){this[q]=m.params[q]}if(this.scatterPlotMatrixType.match(/all/)&&v==y){this.hideHistogram=true;this.showHistogramDensity=true}var o=[];for(var q=0;q<u.length;q++){o.push(this[u[q]])}if(this.scatterPlotMatrixType.match(/Histogram|Density|all/)){this.initializeData(m.data,false,true)}this.initializeAxis();b.call(this);this.removeHistogram(true);this.restoreMargins();for(var q=0;q<u.length;q++){this[u[q]]=o[q]}if(this.scatterPlotMatrixType.match(/all/)&&v==y){this.hideHistogram=false;this.showHistogramDensity=false}}else{if(this.scatterPlotMatrixType=="correlation"&&y==0){b.call(this)}else{if(y==this.layoutRows-1&&v==this.layoutCols-1&&this.scatterPlotMatrixType.match(/all/)){this.removeHistogram(true);this.restoreMargins()}}}}else{this.restoreLayoutHidden();b.call(this)}}}else{b.call(this)}}else{if(this.graphType.match(/Scatter/)){if(this.xAxis.length&&this.yAxis.length){b.call(this)}}else{b.call(this)}}}if(this.layoutConfig&&this.layoutConfig[B]){for(var q in this.layoutConfig[B]){this[q]=D[q]}}for(var t=0;t<C.length;t++){if(C[t]=="data"&&this.graphType.match(/Sankey|Tree/)){this.layoutParams[B][C[t]]={};this.layoutParams[B][C[t]].y=this.cloneObject(this[C[t]].y);if(this[C[t]].x){this.layoutParams[B][C[t]].x=this.cloneObject(this[C[t]].x)}if(this[C[t]].z){this.layoutParams[B][C[t]].z=this.cloneObject(this[C[t]].z)}}else{this.layoutParams[B][C[t]]=this.cloneObject(this[C[t]])}}if(this.data.w){this.layoutParams[B].w=this.cloneObject(this.data.w)}if(this.layoutCanvasCompartments){this.drawLayoutCanvasCompartments()}if(this.isDOE||this.graphType=="Pie"){}else{if(this.graphType.match(/Scatter/)||(this.graphType.match(/Boxplot/)&&this.scatterPlotMatrix&&this.scatterPlotMatrixType.match(/all/))){if(this.scatterPlotMatrix||this.segregateVariablesBy.length||this.segregateSamplesBy.length){this.drawTrellisLabels(B,y,v,g)}}else{if(!this.layoutAdjust){var e=this.graphOrientation=="vertical"?v:y;var d=this.graphOrientation=="vertical"?this.layoutCols-1:this.layoutRows-1;var r=this.graphOrientation=="vertical"&&(this.layoutType=="rows"||(this.layoutType=="cols"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1));var a=this.graphOrientation!="vertical"&&(this.layoutType=="cols"||(this.layoutType=="rows"&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>1));if(e==0&&this.layoutRestore.xAxisShow&&this.graphType!="Heatmap"&&!a){this.layoutAxis=1;this.xAxisShow=true;this.draw1DXLayout()}if(e==d&&this.layoutRestore.xAxis2Show&&this.graphType!="Heatmap"&&!r){this.layoutAxis=2;this.xAxis2Show=true;this.draw1DXLayout()}}if(this.segregateVariablesBy.length){var s=false;if(this.graphOrientation=="vertical"){if(y==this.layoutRows-1){s=true}else{if(y==this.layoutRows-2&&(B+1+parseInt(this.layoutCols))>this.data.l.weight.length){s=true}}}else{if(v==0){s=true}}if(s){this.showSampleNames=this.layoutRestore.showSampleNames;this.draw1DYLayout()}}else{if(this.graphOrientation=="vertical"&&this.segregateSamplesBy.length&&this.layoutSameSamples&&y==this.layoutRows-1){this.showSampleNames=this.layoutRestore.showSampleNames;this.draw1DYLayout()}else{if(this.graphOrientation!="vertical"&&this.segregateSamplesBy.length&&this.layoutSameSamples&&v==0){this.showSampleNames=this.layoutRestore.showSampleNames;this.draw1DYLayout()}}}this.drawTrellisLabels(B,y,v)}}this.offsetX+=this.layoutWidth;B++}this.offsetX=this.layoutLeft;this.offsetY+=this.layoutHeight}this.layoutCurrent=false;this.restoreLayoutParameters();if(this.isDOE){this.data=this.dataStndBy;this.graphType=this.data.l.type[0]}else{this.drawTitle();this.drawLabelsTitlesLayout();if(this.showLegend){if(this.isDOE||this.graphType!="Pie"){if(this.graphType.match(/Scatter/)){this.setLegends()}this.drawLegend(true)}}}if(this.graphType.match(/Scatter/)&&this.scatterPlotMatrix){this.varIndices=this.meta.data.i.vars;this.smpIndices=this.meta.data.i.smps}else{if(this.meta.data.g){this.data.w=this.meta.data.g;this.varIndices=this.meta.data.i.vars;this.smpIndices=this.meta.data.i.smps;this.grpIndices=this.meta.data.i.grps;delete (this.meta.data.g);delete (this.meta.data.i)}else{this.isGroupedData=false}}}};this.restoreMargins=function(){for(var a in this.meta.config.user){if(a.match(/margin|dataPointSize/)){delete this.meta.config.user[a]}}};this.restoreLayoutParameters=function(){for(var a in this.layoutRestore){this[a]=this.layoutRestore[a]}};this.setLayoutGraphDimensions=function(a,b,d){this.layoutWidth=(this.width-a)*this.layoutParams[d].weight[0];this.layoutHeight=(this.height-b)*this.layoutParams[d].weight[1];this.layoutParams[d].width=this.layoutWidth;this.layoutParams[d].height=this.layoutHeight};this.setLongestLayoutLabel=function(){var a=[];if(this.scatterPlotMatrix){}else{if((this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0)||(this.segregateSamplesBy.length>1||this.segregateVariablesBy.length>1)){for(var b=0;b<this.data.l.name.length;b++){a.push(this.data.l.name[b][0]);a.push(this.data.l.name[b][1])}}else{if(this.data.l.name){for(var b=0;b<this.data.l.name.length;b++){a.push(this.data.l.name[b])}}}this.longestLayoutLabel=this.getMaxText(a)}};this.setLayoutLabels=function(a){this.layoutLabels=[];if(this.isHistogram){if(this.segregateVariablesBy.length&&this.meta.data.z[this.segregateVariablesBy[0]]){this.layoutLabels.push(this.meta.data.z[this.segregateVariablesBy[0]].levels[a])}else{if(this.segregateSamplesBy.length){this.layoutLabels.push(this.legendSamplesN==this.data.l.axes.length?this.dataStndBy.y.smps[a]:this.data.l.axes[a].yAxis[0])}else{this.layoutLabels.push(this.data.l.name[a+1])}}}else{if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.layoutLabels.push(this.data.l.name[a][this.graphType.match(/Scatter/)?1:0]);this.layoutLabels.push(this.data.l.name[a][this.graphType.match(/Scatter/)?0:1])}else{if(this.segregateSamplesBy.length>1||this.segregateVariablesBy.length>1){this.layoutLabels.push(this.data.l.name[a][this.graphType.match(/Scatter/)?0:1]);this.layoutLabels.push(this.data.l.name[a][this.graphType.match(/Scatter/)?1:0])}else{if(this.scatterPlotMatrix){}else{this.layoutLabels.push(this.data.l.name[a])}}}}};this.drawLayoutCompartmentsDOE=function(k,y,D){this.legendPosition="right";this.graphOrientation="vertical";if(D==0){this.isShowDOEData=true;this.showLegend=this.layoutRestore.showLegend;if(this.graphType!="Map"){this.drawDOELabelsLayout("Data")}if(this.graphType.match(/Scatter/i)){this.isHistogram=false;this.xAxis=this.configStndBy.xAxis||[];this.yAxis=this.configStndBy.yAxis||[];this.zAxis=this.configStndBy.zAxis||[];this.xAxisTitle=this.configStndBy.xAxisTitle;this.yAxisTitle=this.configStndBy.yAxisTitle;this.zAxisTitle=this.configStndBy.zAxisTitle;this.initializeData(this.dataStndBy);this.varIndices=this.dataStndBy.l.doe}else{this.initializeData(this.dataStndBy);this.smpIndices=this.dataStndBy.l.doe}this.initializeAxis();this.showLegend=false;if(this.graphType=="Map"){if(this.configStndBy.colorBy){this.colorBy=this.configStndBy.colorBy}this.setMapAttributes();this.drawMapData()}else{if(this.graphType=="Scatter3D"){this.draw3DPlot()}else{if(this.graphType.match(/Scatter/i)){if(!this.data.l.histogram){this.draw2DPlot()}}else{this.plotByVariable=this.configStndBy.plotByVariable;if(this.configStndBy.summaryType){this.summaryType=this.configStndBy.summaryType}if(this.configStndBy.groupingFactors.length>0){this.isGroupedData=true;if(this.dataStndBy.y.smps.length!=this.smpIndices.length){this.layoutComb=false;this.groupSamples(this.configStndBy.groupingFactors,false,false,true,true);this.layoutComb=true}this.initializeAxis();if(!this.data.l.histogram){this.draw1DPlot()}this.isGroupedData=false;this.groupingFactors=[]}else{if(!this.data.l.histogram){this.draw1DPlot()}}this.plotByVariable=false}}}if(this.data.l.histogram){this.ridgeBy=this.data.l.histogram.ridgeBy;this.createHistogram(this.data.l.histogram.ridgeBy||this.data.l.histogram.isAnnt,false,true);this.dataStndBy.l.data=this.cloneObject(this.data);this.initializeAxis();this.draw2DPlot();this.ridgeBy=false}this.showLegend=true;this.isShowDOEData=false}else{if(!this.layoutConfig){this.layoutConfig=[]}if(!this.layoutConfig[D]){this.layoutConfig[D]={}}var o=this.dataStndBy;var r=o.l;var A=this.layoutConfig[D].graphType||r.type[D];this.drawDOELabelsLayout(r.smps[D][0]);this.top=5;this.bottom=5;this.right=5;this.left=5;if(A=="Table"){this.createPie(r.smps[D][0]);this.graphType=A;if(!this.layoutDOETables.hasOwnProperty(r.smps[D][0])||this.layoutDOETables[r.smps[D][0]].idxs.length!=this.data.y.vars.length){this.layoutDOETables[r.smps[D][0]]={sort:false,idxs:[]}}this.drawDOETable()}else{if(A=="Pie"){this.showLegend=false;this.createPie(r.smps[D][0]);this.graphType=A;this.layoutCurrentDOE=r.smps[D][0];this.legendBox=false;this.drawPiePlot()}else{if(A=="Treemap"){this.createTreemap(r.smps[D][0]);this.graphType=A;this.draw1DPlot()}else{if(A=="Scatter2D"){this.createHistogram(r.smps[D][0],false,false,r.extended[D]);this.graphType=A;this.initializeAxis();this.showLegend=false;this.xAxisTitle="";this.yAxisTitle="";this.zAxisTitle="";this.draw2DPlot();this.isHistogram=false;this.isCreateHistogram=false}else{if(A=="Scatter"){A="Scatter2D"}this.graphType=A;var f=o.x||o.z;var z=this.layoutConfig[D].xAxis||r.smps[D][0];var b=this.layoutConfig[D].yAxis||r.smps[D][0];var t=f.hasOwnProperty(z.toString())?f[z]:o.y.data[z];var a=f.hasOwnProperty(b.toString())?f[b]:o.y.data[b];var p=["colorBy","shapeBy","siseBy"];var q={graphType:true,xAxis:true,yAxis:true,sortDir:true};var m;if(A=="Scatter2D"){var C={y:{smps:[f.hasOwnProperty(z)?z:o.y.vars[z]],vars:[],data:[]}};for(var v=0;v<r.doe.length;v++){var n=r.doe[v];C.y.vars.push(o.y.smps[n])}if(z!=b){C.y.smps.push(f.hasOwnProperty(b)?b:o.y.vars[b])}for(var v=0;v<r.doe.length;v++){var n=o.l.doe[v];if(z!=b){C.y.data.push([t[n],a[n]])}else{C.y.data.push([t[n]])}}this.isHistogram=false;this.isCreateHistogram=false;this.initializeData(C);this.graphType=A;this.initializeAxis();this.draw2DPlot()}else{var C={y:{vars:r.smps[D],smps:[],data:[[]]}};var e=this.cloneObject(r.doe);if(this.layoutConfig[D].sortType){if(this.layoutConfig[D].sortType=="Numeric"){if(this.layoutConfig[D].sortDir=="ascending"){e=e.sort(function(d,c){return f[r.smps[D][0]][d]-f[r.smps[D][0]][c]})}else{e=e.sort(function(d,c){return f[r.smps[D][0]][c]-f[r.smps[D][0]][d]})}}else{if(this.layoutConfig[D].sortDir=="ascending"){e.sort(function(d,c){return o.y.smps[d]>o.y.smps[c]})}else{e.sort(function(d,c){return o.y.smps[d]>o.y.smps[c]});e.reverse()}}}for(var v=0;v<e.length;v++){var n=e[v];C.y.smps.push(o.x?o.y.smps[n]:o.y.vars[n])}for(var v=0;v<e.length;v++){var n=e[v];if(this.layoutConfig[D].transformType){C.y.data[0].push(this.transformValue(this.layoutConfig[D].transformType,f[r.smps[D][0]][n]))}else{C.y.data[0].push(f[r.smps[D][0]][n])}}var m={};var F=false;for(var v=0;v<p.length;v++){if(this.layoutConfig[D][p[v]]){F=true;m[this.layoutConfig[D][p[v]]]=[];var E;if(f.hasOwnProperty(this.layoutConfig[D][p[v]])){E=f[this.layoutConfig[D][p[v]]]}else{for(var u=0;u<o.y.vars.length;u++){if(o.y.vars[u]==this.layoutConfig[D][p[v]]){E=o.y.data[u];break}}}for(var u=0;u<e.length;u++){var B=e[u];m[this.layoutConfig[D][p[v]]].push(E[B])}}}if(F){C.x=m}this.initializeData(C);this.graphType=A;for(var v in this.layoutConfig[D]){if(!q[v]){this[v]=this.layoutConfig[D][v]}}this.initializeAxis();this.draw1DPlot();for(var v in this.layoutConfig[D]){if(!q[v]){this[v]=false}}}}}}}}};this.drawLayoutCompartmentsScatter=function(a,e,d,b,g){if(this.segregateVariablesBy.length&&this.segregateSamplesBy.length){this.xAxis=[this.data.l.smps[Math.floor(g/this.data.l.smps.length)][0]];this.yAxis=[this.data.l.smps[Math.floor(g/this.data.l.smps.length)][1]];this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.setLayoutLabels(g)}else{if(this.data.l.smps&&this.data.l.smps[g].xAxis&&this.data.l.smps[g].yAxis){this.xAxis=this.data.l.smps[g].xAxis;this.yAxis=this.data.l.smps[g].yAxis;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{if(!this.scatterPlotMatrix&&this.data.l.smps&&this.data.l.smps[g]){if(this.isHistogram){if(this.data.l.axes[g]){this.xAxis=this.data.l.axes[g].xAxis;this.yAxis=this.data.l.axes[g].yAxis;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{this.xAxis=[];this.yAxis=[];this.xAxisIndices=[];this.yAxisIndices=[]}}else{this.xAxis=[this.data.l.smps[g][0]];if(this.isQQ){this.yAxis=[this.data.l.smps[g][0]]}else{this.yAxis=[this.data.l.smps[g][1]||this.data.l.smps[g][0]]}this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}this.setLayoutLabels(g)}else{if(this.data.l.vars&&this.data.l.vars[g]){if(this.data.l.axes){if(this.data.l.axes[g]){this.xAxis=this.data.l.axes[g].xAxis;this.yAxis=this.data.l.axes[g].yAxis;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis);this.setLayoutLabels(g)}else{this.xAxis=[];this.yAxis=[];this.xAxisIndices=[];this.yAxisIndices=[]}}else{this.setLayoutLabels(g)}}else{this.xAxis=false;this.yAxis=false;this.xAxisIndices=false;this.yAxisIndices=false}}}}if(this.layoutAdjust&&this.xAxis&&this.yAxis){this.initializeAxis();this.layoutAxis=3}else{this.layoutAxis=b==0?2:0;this.layoutAxis=d==this.layoutRows&&this.layoutAxis?3:d==this.layoutRows?1:0}if(this.isQQ){this.setAxes("qq")}else{if(this.isCDF){this.setAxes("cdf")}}if(this.data.l.reg){if(this.data.l.reg[g]){if(this.decorations&&this.decorations.reg){delete (this.decorations.reg)}for(var f=0;f<this.data.l.reg[g].length;f++){this.addRegressionDecoration(this.data.l.reg[g][f].reg,this.data.l.reg[g][f].cor,this.data.l.reg[g][f].lab,this.data.l.reg[g][f].col,this.data.l.reg[g][f].fit,this.data.l.reg[g][f].id,this.data.l.reg[g][f].n,this.data.l.reg[g][f].factor)}}}this.showLegend=false;this.legendInside=true;this.showDecorationsLegend=true;this.xAxisTitle="";this.yAxisTitle="";if(!this.layoutAdjust||this.layoutAdjust=="axis"||this.scatterPlotMatrixType.match(/correlation|all/)){this.xAxisShow=false;this.yAxisShow=false;this.xAxisS2Show=false;this.yAxisS2Show=false;if(d==0&&b%2>0){this.xAxisS2Show=true}if(d==this.layoutRows-1&&(b%2==0||this.scatterPlotMatrixType.match(/correlation|all/)||this.layoutAdjust=="axis")){this.xAxisShow=true}if(b==0&&(d%2>0||this.scatterPlotMatrixType.match(/correlation|all/)||this.layoutAdjust=="axis")){if(d==0||(d==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/))){this.yAxisShow=false}else{this.yAxisShow=true}}if(d==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/)){this.yAxisShow=true}if(d==b&&this.scatterPlotMatrix&&this.scatterPlotMatrixType!="first"){this.xAxisShow=true;this.yAxisShow=true}if(b==this.layoutCols-1&&d%2==0&&(!this.scatterPlotMatrixType.match(/correlation|all/)||this.layoutAdjust=="axis")){this.yAxisS2Show=true}}if(this.scatterType=="manhattan"){if(this.meta.config.user.xAxisShow===false){this.xAxisShow=false;this.xAxisS2Show=false}this.yAxisShow=true}this.xAxisMajorTicks=true;this.yAxisMajorTicks=true;if((d==b&&(this.scatterPlotMatrixType.match(/correlation|all/)||this.layoutAdjust=="axis"))||(d==this.layoutRows-1&&this.scatterPlotMatrixType.match(/all/))){this.xAxisMajorTicks=false;this.yAxisMajorTicks=false}};this.drawLayoutCompartmentsPie=function(a,b,d){this.smpIndices=[this.getSampleIndices(this.data.l.smps[d])];this.showLegend=true};this.drawLayoutCompartmentsOneD=function(b,e,g){this.showLegend=false;this.showOverlays=true;this.isGroupedData=false;this.xAxisTitle=false;this.xAxis2Title=false;this.smpTitle=false;this.adjustAspectRatioXTries=0;this.adjustAspectRatioYTries=0;this.setLayoutLabels(g);if(this.varIndices.length>0&&this.smpIndices.length>0){if(this.data.l.group){this.groupSamples(this.data.l.group,false,false,true,true,true);var a=this.layoutParams[g].dragged&&this.layoutParams[g].grpIndices.length==this.data.w.grpIdxs.length?this.layoutParams[g].grpIndices:this.data.w.grpIdxs;this.groupSamples(this.data.l.group,false,a,true,true,true);this.layoutParams[g].grpIndices=this.grpIndices;if(this.colorBy&&this.groupingFactors.includes(this.colorBy)&&this.layoutRestore.showLegend){}var f=false;for(var d=0;d<this.data.l.group.length;d++){if(this.segregateSamplesBy.includes(this.data.l.group[d])){f=true;break}}if(this.data.w.smps.length==1&&this.graphType!="Heatmap"&&f){this.showSampleNames=false}if(this.segregateSamplesBy.length&&this.layoutSameSamples){this.showSampleNames=false}if(this.hiddenGrpsLayout){if(this.hiddenGrps.length==1){if(this.hiddenGrpsLayout[g]){this.hiddenGrps[0]=true}}else{for(var d=0;d<this.hiddenGrps.length;d++){if(this.hiddenGrpsLayout[d]){this.hiddenGrps[d]=true}}}}}else{if(this.smpIndices.length==1&&this.graphType!="Heatmap"){}}if(this.segregateVariablesBy.length>0&&this.graphType!="Heatmap"){this.showSampleNames=false}if(this.layoutAdjust||this.graphType=="Meter"){this.layoutAxis=3;if(this.varIndices.length>0&&this.smpIndices.length>0){this.initializeAxis()}}else{if(this.graphOrientation=="vertical"){this.xAxisShowLayout=!(g%this.layoutCols)?true:false}else{this.xAxisShowLayout=g<this.layoutCols?true:false;this.xAxis2ShowLayout=g>=this.layoutCols*(this.layoutRows-1)?true:false}this.xAxisShow=false;this.xAxis2Show=false}}};this.drawTrellisLabels=function(R,A,O,S){var n=this;if(this.scatterPlotMatrix){var o=this.yAxisTopBottomTickColor||this.foreground;var L=R==0?this.margin:0;switch(this.scatterPlotMatrixType){case"first":if(this.data.y.smps[R+1]){var P=this.layoutLabelBoxThickness;var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr+" & "+this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.8/this.layoutCols,P);if(this.layoutBoxLabelColors[0]){this.toRender({p:["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),this.x,P,this.layoutBoxLabelColors[0],this.foreground],t:"Labels"})}else{this.toRender({p:["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),this.x,P,false,this.foreground,"open"],t:"Labels"})}this.toRender({p:["drawText",this.data.y.smps[0]+" & "+this.data.y.smps[R+1],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),C,this.foreground,"center","middle"],t:"Labels"})}break;case"both":case"upper":case"lower":case"correlation":if(A==O){var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.7/this.layoutCols,this.y);this.toRender({p:["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,this.foreground,"open"],t:"Labels"});this.toRender({p:["drawText",this.data.y.smps[A],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),C,this.foreground,"center","middle"],t:"Labels"})}else{if(O>A&&this.scatterPlotMatrixType=="correlation"){var j=this.meta.data.c;var H=this.data.y.smps[this.smpIndices[A]]+"::"+this.data.y.smps[this.smpIndices[O]];var e=this.colorBy&&j.z[this.colorBy]&&j.z[this.colorBy][H]?j.z[this.colorBy][H]:j.s[H]?j.s[H]:false;var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.7/this.layoutCols,this.y);this.drawPlotWindow();this.toRender({p:["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,o,"open"],t:"Labels"});if(e){var g=this.y/(e.length+1);for(var K=0;K<e.length;K++){var T=this.formatNumber(e[K].cor,3);var k=e[K].col;var G=(K+1)*g;this.toRender({p:["drawText",T,this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+G,C,k,"center","middle"],t:"Labels"})}}}}break;case"correlationHistogram":case"correlationDensity":case"all":if(this.scatterPlotMatrixType=="all"&&O==this.layoutCols-1&&A==this.layoutRows-1){break;this.drawPlotWindow();this.toRender({p:["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,o,"open"],t:"Labels"})}if(this.showScatterPlotMatrixLabels){var P=this.layoutLabelBoxThickness;var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.fontSize,Math.min(this.layoutWidth,this.layoutHeight),P);if(A==0){var E=this.data.z&&this.data.z.hasOwnProperty(this.scatterPlotMatrix)?this.scatterPlotMatrix:"Variation";var H=this.scatterPlotMatrixType=="all"&&O==this.layoutCols-1?E:this.data.y.smps[O];this.toRender({p:["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),this.x,P,false,this.foreground,"open"],t:"Labels"});this.toRender({p:["drawText",H,this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(P/2),C,this.foreground,"center","middle"],t:"Labels"})}if(O==this.layoutCols-1){this.toRender({p:["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+this.x+(P/2),this.marginTop+this.offsetY+this.top+(this.y/2),P,this.y,false,this.foreground,"open"],t:"Labels"});this.toRender({p:["drawText",this.data.y.smps[A],this.marginLeft+this.offsetX+this.left+this.x+(P/2),this.marginTop+this.offsetY+this.top+(this.y/2),C,this.foreground,"center","middle",Math.PI/2],t:"Labels"})}}else{if(A==O){var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.7/this.layoutCols,this.y);var P=this.layoutLabelBoxThickness;this.toRender({p:["drawText",this.data.y.smps[A],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+P,C,this.foreground,"center","middle"],t:"Labels"})}}if(O>A){if(this.scatterPlotMatrixType=="all"&&O==this.layoutCols-1){break}var j=this.meta.data.c;var H=this.data.y.smps[this.smpIndices[A]]+"::"+this.data.y.smps[this.smpIndices[O]];var e=this.colorBy&&j.z[this.colorBy]&&j.z[this.colorBy][H]?j.z[this.colorBy][H]:j.s[H]?j.s[H]:false;var C=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-S)*0.7/this.layoutCols,this.y);this.drawPlotWindow();this.toRender({p:["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,o,"open"],t:"Labels"});if(e){var g=this.y/(e.length+1);for(var K=0;K<e.length;K++){var T=this.formatNumber(e[K].cor,3);var k=e[K].col;var G=(K+1)*g;this.toRender({p:["drawText",T,this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+G,C,k,"center","middle"],t:"Labels"})}}}break}}else{if(this.layoutValid&&this.layoutLabelShow){var J=function(){var c=n.marginLeft+n.offsetX;if(n.layoutCollapse||(n.layoutType!="wrap"&&n.graphOrientation=="horizontal"&&!n.graphType.match(/Scatter/))){return c+(n.layoutCollapse?0:n.margin)}else{if(n.graphType.match(/Scatter/)&&(n.isQQ||n.isCDF)||n.layoutType!="wrap"){return c+n.margin}else{return c+(n.graphOrientation=="horizontal"?n.left:n.left)+(n.graphType.match(/Scatter/)?0:0)}}};var a=function(){var c=n.marginTop+n.offsetY;if(n.layoutCollapse||(n.layoutType!="wrap"&&n.graphOrientation=="horizontal"&&!n.graphType.match(/Scatter/))){return c}else{return c+(n.top-(n.layoutLabels.length*Q*(n.layoutType=="wrap"?1:0)))}};var b=function(){var c=n.layoutWidth;if(n.layoutCollapse){return c}else{if(n.graphType.match(/Scatter/)){return c-n.margin}else{if(n.layoutType!="wrap"){return c-(n.margin*(n.graphOrientation=="horizontal"?1:2))}else{return c-(n.left+n.right);if(n.layoutAdjust){return c-(n.graphOrientation=="horizontal"?(n.right+n.margin):n.left+n.right)}else{return c-(n.margin*2)}}}}};var v=function(){var c=n.layoutHeight;if(n.layoutCollapse){return c}else{if(n.graphType.match(/Scatter/)){return c-n.margin}else{if(n.layoutType!="wrap"){return c-(n.margin*(n.graphOrientation=="horizontal"?1:2))}else{if(n.layoutAdjust){return c-(n.graphOrientation=="horizontal"?((n.top+n.bottom)-(n.layoutLabels.length*Q)):n.bottom)}else{return c-(n.graphOrientation=="horizontal"?n.margin:n.bottom)}}}}};var s=this.layoutCollapse||this.layoutType!="wrap";var Q=this.layoutLabelBoxThickness;var I=J()+0.5;var B=a()+0.5;var u=b();var M=v();var F=u/2;var N=this.layoutLabels.length?this.scaleTextToFont(this.longestLayoutLabel,(this.layoutBoxShow?this.fontSize:this.maxFontSize),u,M):this.font;var D=this.layoutBoxShow?this.foreground:"rgba(0,0,0,0)";var p=1;if(this.layoutType=="wrap"){for(var K=0;K<this.layoutLabels.length;K++){if(this.layoutBoxLabelColors[K]){this.toRender({p:["drawShape","box",I+(u/2),B+(Q/2)+(Q*K),u,Q,this.layoutBoxLabelColors[K],this.layoutBoxShow?this.foreground:this.layoutBoxLabelColors[K]],t:"Labels"})}}}else{if(this.layoutType=="cols"){if(this.layoutLabels.length>1){}}else{if(this.layoutType=="rows"){if(this.layoutLabels.length>1){}}}}if(n.graphType.match(/Scatter/)){if(!this.xAxis.length||!this.yAxis.length){return}else{if(this.layoutType=="wrap"){this.toRender({p:["drawShape","box",I+(u/2),B+(this.layoutLabels.length*Q/2),u,this.layoutLabels.length*Q,false,D,"open",false,p],t:"Labels"})}}}else{this.toRender({p:["drawShape","box",I+(u/2),B+(M/2),u,M,false,D,"open"],t:"Labels"})}if(this.layoutType=="wrap"){for(var K=0;K<this.layoutLabels.length;K++){this.toRender({p:["drawText",this.layoutLabels[K],I+F,B+(Q/2)+(Q*K),N,this.layoutLabelColor,"center","middle"],t:"Labels"});var r=B+Q+(Q*K);this.toRender({p:["drawLine","line",I,r,I+u,r,D],t:"Labels"})}}else{if(this.layoutType=="cols"){if(A==0){this.toRender({p:["drawText",this.layoutLabels[this.layoutLabels.length>1?1:0],I+F,B-(Q/2),N,this.layoutLabelColor,"center","middle"],t:"Labels"});this.toRender({p:["drawShape","box",I+(u/2),B-(Q/2),u,Q,false,D,"open",false,p],s:true,t:"Labels"})}if(this.layoutLabels.length>1&&Number(O)+1==this.layoutCols){this.toRender({p:["drawText",this.layoutLabels[0],I+u+(Q/2),B+(M/2),N,this.layoutLabelColor,"center","middle",Math.PI/2]});this.toRender({p:["drawShape","box",I+u+(Q/2),B+(M/2),Q,M,false,D,"open",false,p],s:true,t:"Labels"})}}else{if(this.layoutType=="rows"){if(Number(O)+1==this.layoutCols){this.toRender({p:["drawText",this.layoutLabels[0],I+u+(Q/2),B+(M/2),N,this.layoutLabelColor,"center","middle",Math.PI/2]});this.toRender({p:["drawShape","box",I+u+(Q/2),B+(M/2),Q,M,false,D,"open",false,p],s:true,t:"Labels"})}if(this.layoutLabels.length>1&&A==0){this.toRender({p:["drawText",this.layoutLabels[1],I+F,B-(Q/2),N,this.layoutLabelColor,"center","middle"],t:"Labels"});this.toRender({p:["drawShape","box",I+(u/2),B-(Q/2),u,Q,false,D,"open",false,p],s:true,t:"Labels"})}}}}}}};this.getLayoutConfig=function(a){if(this.layoutValid&&this.layoutConfig&&this.layoutConfig[this.layoutCurrent]&&this.layoutConfig[this.layoutCurrent][a]){return this.layoutConfig[this.layoutCurrent][a]}else{return false}};this.initializeLayout=function(){this.isValidLayout()}};CanvasXpress.prototype.initViewport=function(){this.setViewport=function(v){var d=this.$("container-"+this.target);if(!d){var y=this.$(this.target);var A=y.attributes;for(var w=0;w<A.length;w++){this.meta.dom[A[w].name]=A[w].value}var s=y.parentNode;y.className="CanvasXpress";if(!y.hasAttribute("data-maxWidth")){y.setAttribute("data-maxWidth",y.hasAttribute("width")?Number(y.getAttribute("width")):s.clientWidth)}if(!y.hasAttribute("data-maxHeight")){y.setAttribute("data-maxHeight",y.hasAttribute("height")?Number(y.getAttribute("height")):s.clientHeight)}if(!s.id){s.id="CanvasXpress-ParentNode-"+this.target}if(!CanvasXpress.system.isShiny){s.classList.add("CanvasXpress-ParentNode")}if(!s.style.margin&&!s.style.marginTop&&this.toolbarType.match(/over|fixed/)){s.style.marginTop="36px"}this.targetParentNode=s.id;this.targetParentNodeResponsive=false;this.targetParentNodeAspectRatio=[];var u=y.hasAttribute("data-responsive")?JSON.parse(y.getAttribute("data-responsive")):false;var q=y.hasAttribute("data-aspectRatio")?y.getAttribute("data-aspectRatio"):false;var f=y.hasAttribute("data-resizable")?y.getAttribute("data-resizable"):false;if(f){if(f=="both"){this.resizable=true;this.resizableX=true;this.resizableY=true}else{if(f=="x"||f=="X"){this.resizable=true;this.resizableX=true;this.resizableY=false}else{if(f=="y"||f=="Y"){this.resizable=true;this.resizableX=false;this.resizableY=true}else{if(f=="none"){this.resizable=false;this.resizableX=false;this.resizableY=false}}}}}if(u){this.targetParentNodeResponsive=true;var l=q?q.split(/:/):[];var j=this.getMaxCanvasWidthHeight(y,l);y.width=j[0];y.height=j[1];this.targetParentNodeAspectRatio=[y.width,y.height]}y.width=y.originalWidth=parseInt(y.width);y.height=y.originalHeight=parseInt(y.height);if(y.width==0){y.width=500}if(y.height==0){y.height=500}y.style.width=y.width+"px";y.style.height=y.height+"px";var o=this.$cX("canvas",{id:this.target+"-events",className:"CanvasXpress",width:y.width,height:y.height},{position:"absolute",left:0,top:0});this.target2=this.target+"-events";var d=this.$cX("div",{id:"container-"+this.target,className:"CanvasXpressContainer"},{backgroundColor:this.background});if(v){d.style.display="none"}var B=this.$cX("div",{id:"northest-container-"+this.target,className:"CanvasXpressContainer"},{width:y.width+"px",clear:"left",backgroundColor:this.background});var n=this.$cX("div",{id:"northest-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:y.width+"px",backgroundColor:this.background});var k=this.$cX("div",{id:"north-container-"+this.target,className:"CanvasXpressContainer"},{width:y.width+"px",height:"0px",clear:"left",backgroundColor:this.background});var z=this.$cX("div",{id:"north-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:y.width+"px",height:"0px",backgroundColor:this.background});var D=this.$cX("div",{id:"middle-container-"+this.target,className:"CanvasXpressContainer"},{width:y.width+"px",height:y.height+"px",clear:"left",backgroundColor:this.background});var m=this.$cX("div",{id:"west-container-"+this.target,className:"CanvasXpressContainer"},{width:"0px",height:y.height+"px",cssFloat:"left",backgroundColor:this.background});var C=this.$cX("div",{id:"west-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:y.height+"px",backgroundColor:this.background});var e=this.$cX("div",{id:"center-wrapper-"+this.target,className:"CanvasXpressWrapper"},{backgroundColor:this.background});var h=this.$cX("div",{id:"east-container-"+this.target,className:"CanvasXpressContainer"},{width:"0px",height:y.height+"px",backgroundColor:this.background});var x=this.$cX("div",{id:"east-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:y.height+"px",backgroundColor:this.background});var b=this.$cX("div",{id:"south-container-"+this.target,className:"CanvasXpressContainer"},{width:y.width+"px",height:"0px",clear:"left",backgroundColor:this.background});var r=this.$cX("div",{id:"south-wrapper-"+this.target,className:"CanvasXpressWrapper",state:"open"},{width:y.width+"px",height:"0px",backgroundColor:this.background});var t=this.$cX("div",{id:"southest-container-"+this.target,className:"CanvasXpressContainer"},{width:y.width+"px",clear:"left",backgroundColor:this.background});var g=this.$cX("div",{id:"southest-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:y.width+"px",backgroundColor:this.background});B.appendChild(n);t.appendChild(g);k.appendChild(z);m.appendChild(C);h.appendChild(x);b.appendChild(r);D.appendChild(m);D.appendChild(e);D.appendChild(h);d.appendChild(B);d.appendChild(k);d.appendChild(D);d.appendChild(b);d.appendChild(t);d.appendChild(this.createLoadingTimer());y.parentNode.insertBefore(d,y);e.appendChild(y.parentNode.appendChild(y));y.parentNode.appendChild(o);this.meta.canvas.ctx2=this.get2DCanvasContext(o);this.meta.canvas.ctx2.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0)}};this.getMaxCanvasWidthHeight=function(k,f){var m,i;if(!k){k=this.$(this.target)}if(!f){f=this.targetParentNodeAspectRatio}var d=this.targetParentNode&&this.$(this.targetParentNode)?this.$(this.targetParentNode):false;var n=Number(k.getAttribute("data-maxWidth"));var j=Number(k.getAttribute("data-maxHeight"));if(d){if(d.parentNode){d=d.parentNode}}else{return[n,j]}var a=d.getClientRects();var e=parseInt(getComputedStyle(d).paddingLeft);var g=Number(a[0]!=null?a[0].width:this.width);var b=Number(a[0]!=null?a[0].height:this.height);g=g>n?n:g;b=b>j?j:b;if(f.length==2){f[0]=Number(f[0]);f[1]=Number(f[1]);if(f[0]==f[1]){m=g-(g>=n?0:(e?e*2:0));i=m}else{if(f[0]>f[1]){m=parseInt(g);i=parseInt(m*f[1]/f[0])}else{i=parseInt(b);m=parseInt(i*f[0]/f[1])}}}else{m=g;i=b}return[m,i]};this.createLoadingTimerOld=function(){var j=this.target+"canvasXpressLoadingTimer";if(this.$(j)){return}var h=this.$(this.target);var g=this.$cX("div",{id:j},{display:"none",position:"absolute",width:"100%",top:parseInt((h.height/2)-100.5)+"px"});var e=this.$cX("div",{className:"counter"});var b=this.$cX("div",{className:"timer"});var a=this.$cX("div",{className:"imer-val-container seconds-single"});for(var d=0;d<10;d++){a.appendChild(this.$cX("div",{className:"timer-val",innerHTML:d}))}b.appendChild(a);e.appendChild(b);g.appendChild(e);var f=this.$cX("div",{className:"sk-fading-circle"});for(var d=1;d<13;d++){f.appendChild(this.$cX("div",{className:"sk-circle"+d+" sk-circle"}))}g.appendChild(f);return g};this.createLoadingTimer=function(){var f=this.target+"canvasXpressLoadingTimer";if(this.$(f)){return}var e=this.$(this.target);var d=this.$cX("div",{id:f},{display:"block",position:"absolute",top:parseInt((e.height/2)-40)+"px",left:parseInt((e.width/2)-40)+"px"});var a=this.$cX("div",{className:"lds-ring"});for(var b=0;b<4;b++){a.appendChild(this.$cX("div"))}d.appendChild(a);return d};this.resizeViewportNorth=function(){var e=this.meta.canvas.canvasPixelRatio;var f=this.$("west-container-"+this.target);var d=this.$("east-container-"+this.target);var b=this.$("northest-container-"+this.target);var c=this.$("northest-wrapper-"+this.target);var g=this.$("north-container-"+this.target);var a=this.$("north-wrapper-"+this.target);if(f&&d&&b&&c&&g&&a){b.style.width=(parseInt(f.style.width)+(this.meta.canvas.ctx.canvas.width/e)+parseInt(d.style.width))+"px";c.style.width=(parseInt(f.style.width)+(this.meta.canvas.ctx.canvas.width/e)+parseInt(d.style.width))+"px";g.style.width=(parseInt(f.style.width)+(this.meta.canvas.ctx.canvas.width/e)+parseInt(d.style.width))+"px";a.style.width=(parseInt(f.style.width)+(this.meta.canvas.ctx.canvas.width/e)+parseInt(d.style.width))+"px";g.style.height="0px";a.style.height="0px"}};this.resizeViewportWest=function(){var e=this.$(this.target+"-cX-Configurator");var a=this.meta.canvas.canvasPixelRatio;var b=this.$("west-container-"+this.target);var d=this.$("west-wrapper-"+this.target);if(b&&d){b.style.width="0px";d.style.width="0px";b.style.height=(this.meta.canvas.ctx.canvas.height/a)+"px";d.style.height=(this.meta.canvas.ctx.canvas.height/a)+"px"}};this.resizeViewportEast=function(){var d=this.$(this.target+"-cX-DataFilter");var c=this.meta.canvas.canvasPixelRatio;var a=this.$("east-container-"+this.target);var b=this.$("east-wrapper-"+this.target);if(a&&b){a.style.width="0px";b.style.width="0px";a.style.height=(this.meta.canvas.ctx.canvas.height/c)+"px";b.style.height=(this.meta.canvas.ctx.canvas.height/c)+"px"}};this.resizeViewportSouth=function(b){var h=this.$(this.target+"-cX-DataTable");var e=this.meta.canvas.canvasPixelRatio;var f=this.$("west-container-"+this.target);var c=this.$("east-container-"+this.target);var g=this.$("south-container-"+this.target);var a=this.$("south-wrapper-"+this.target);if(h&&f&&c&&g&&a){if(b){g.style.height=parseInt(h.style.height)+"px";a.style.height=parseInt(h.style.height)+"px";g.style.width=parseInt(h.style.width)+"px";a.style.width=parseInt(h.style.width)+"px"}else{g.style.width=(parseInt(f.style.width)+(this.meta.canvas.ctx.canvas.width/e)+parseInt(c.style.width))+"px";a.style.width=(parseInt(f.style.width)+(this.meta.canvas.ctx.canvas.width/e)+parseInt(c.style.width))+"px";g.style.height="0px";a.style.height="0px"}}};this.resizeViewport=function(){var b=this.meta.canvas.canvasPixelRatio;var d=this.$("middle-container-"+this.target);var a=this.$("east-container-"+this.target);var c=this.$("west-container-"+this.target);if(d&&a&&c){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();d.style.width=(parseInt(c.style.width)+(this.meta.canvas.ctx.canvas.width/b)+parseInt(a.style.width)+0)+"px";d.style.height=((this.meta.canvas.ctx.canvas.height/b)+0)+"px"}};this.resizeViewportMiddle=function(a,c){var e=this.$("middle-container-"+this.target);var b=this.$("east-container-"+this.target);var d=this.$("west-container-"+this.target);if(e&&b&&d){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();e.style.width=(parseInt(d.style.width)+a+parseInt(b.style.width)+0)+"px";e.style.height=(c+0)+"px"}};this.resetViewportOverflow=function(b){if(b){var a=this.$(b+"-wrapper-"+this.target);if(a){a.style.overflow="visible"}}};this.initializeViewport=function(a){this.setViewport(a)}};CanvasXpress.prototype.initMenus=function(){this.addMenu=function(C,a,o,b,g,d,z,B,n){if(this.disableMenu){return}var q;var p;var j=this.$("north-wrapper-"+this.target);var c=this.$("west-container-"+this.target);this.resetLinkDiv();if(j&&c){if(a){p=this.newId("-cX-Menu-");q=this.$cX("div",{id:p,className:"CanvasXpressMenu draggable",par:o},{left:"0px",top:"0px",zIndex:this.menuIndex++,display:"none"})}else{this.removeMenus();if(b){a=b;g+=c.offsetWidth}else{a=this.setMenu(C);var A=this.getTargetEvent(C);var D=this.adjustedCoordinates(C,A);if(B){g=8;d=8}else{g=D.x+c.offsetWidth;d=D.y}}p=this.newId("-cX-Menu-");q=this.$cX("div",{id:p,className:"CanvasXpressMenu draggable"},{left:g+"px",top:d+"px",zIndex:this.menuIndex++})}var k=this.$cX("ul",{id:this.newId("-cX-List-"),className:"CanvasXpressList",header:z,colorBackground:n});q.appendChild(k);j.appendChild(q);var v=this.maxSubMenus;var r=a.length>v?v:a.length;if(a.length>v&&this.graphType!="Network"){k.rawMenu=a;k.rawMenuIndex=0;this.addMenuItemScroller(k,"Top")}for(var t=0;t<r;t++){if(a[t][0]=="-"){this.addMenuItemSep(k)}else{if(a[t][0]=="-text-"){this.addMenuItemText(a[t],k)}else{if(a[t][0]=="-color-"){this.addMenuItemColor(a[t],k)}else{if(a[t][0]=="-slider-"){this.addMenuItemSlider(a[t],k)}else{if(a[t][0]=="-filter-"){this.addMenuItemFilter(a[t],k)}else{this.addMenuItem(a[t],k)}}}}}}if(a.length>v){this.addMenuItemScroller(k,"Bottom")}}return p};this.pageMenuItem=function(e,f){var g,j,a,i;var h=e.rawMenuMatch||e.rawMenu;if(h){var d=e.childNodes.length-2;if(f=="Top"&&e.rawMenuIndex>0){g=e.childNodes[e.childNodes.length-2];j=h[e.rawMenuIndex-1];a=e.childNodes[2];i=true;e.rawMenuIndex--}else{if(f=="Bottom"&&h.length>(e.rawMenuIndex+d)){g=e.childNodes[2];j=h[e.rawMenuIndex+d];a=e.childNodes[e.childNodes.length-1];i=true;e.rawMenuIndex++}}if(i){this.addRemoveItemListeners("removeEvtListener",g);g.parentNode.removeChild(g);if(j[0]=="-"){this.addMenuItemSep(e,a)}else{if(j[0]=="-text-"){this.addMenuItemText(j,e,a)}else{if(j[0]=="-color-"){this.addMenuItemColor(j,e,a)}else{if(j[0]=="-slider-"){this.addMenuItemSlider(j,e,a)}else{if(j[0]=="-filter-"){this.addMenuItemFilter(j,e,a)}else{this.addMenuItem(j,e,a)}}}}}}}};this.filterScrollSearch=function(b){var k=this.$(b);if(k){var c=k.value;var n=new RegExp(k.value,"i");var h=k.parentNode.parentNode;var j=h.rawMenu;var f=[];for(var e=0;e<j.length;e++){if(j[e][0].match(n)){f.push(j[e])}}if(f.length!=j.length){h.rawMenuMatch=f}else{delete (h.rawMenuMatch)}while(h.childNodes.length>0){var d=h.childNodes[0];this.addRemoveItemListeners("removeEvtListener",d);h.removeChild(d)}var m=this.maxSubMenus;var g=f.length>m?m:f.length;h.rawMenuIndex=0;var a=this.addMenuItemScroller(h,"Top",c);for(var e=0;e<g;e++){this.addMenuItem(f[e],h)}this.addMenuItemScroller(h,"Bottom");a.focus();a.value=c}};this.addMenuItemSep=function(d,a){var c=this.$cX("li",{id:this.newId("-cX-List-Item-Sep-"),className:"CanvasXpressListItemSep"});var e=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Sep-"),className:"CanvasXpressListItemTextSep",innerHTML:"&nbsp;"});c.appendChild(e);if(a){a.parentNode.insertBefore(c,a)}else{d.appendChild(c)}};this.addMenuItemScroller=function(c,d){var b=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-"+d),className:"CanvasXpressListItemScroll"+d});var f=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Scroll-"+d),className:"CanvasXpressListItemTextScroll"+d,innerHTML:"&nbsp;"});b.appendChild(f);c.appendChild(b);this.addRemoveItemListeners("addEvtListener",b);if(d=="Top"){var a=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-Search"),className:"CanvasXpressListItemScrollSearch"+d});var e=this.$cX("input",{id:this.newId("-cX-List-Item-Scroll-Search-Input"),className:"CanvasXpressListItemScrollSearch",type:"text",placeholder:" Search menu"});a.appendChild(e);c.appendChild(a);return e}};this.getMenuItemValue=function(d){if(d[2][2]){var c=this.cloneObject(d[2][2]);var b=this;while(c.length>0){var a=c.shift();if(b[a]){b=b[a]}else{return""}}return b!=null?b:""}else{return this[d[2][0]]||""}};this.addMenuItem=function(r,j,w){var d=this.newId("-cX-List-Item-");var t=this.$cX("li",{id:d,className:"CanvasXpressListItem",click:r[2],params:r[3]||[],upload:r[0]&&r[0]=="Load"?true:false,uploadParams:r[0]&&r[0]=="Load Parameters"?true:false});if(j.colorBackground){var c=CanvasXpress.colorSchemes[r[0]];var m,e,f;if(c&&c[3]){m=this.rgbToHex(c[3][0]);e=this.rgbToHex(c[3][1]);f=this.rgbToHex(c[3][2])}else{var z=this.getKeys(c).sort(function(l,i){return l-i});var h=c[z[0]].length;m=this.rgbToHex(c[z[0]][0]);e=this.rgbToHex(c[z[0]][Math.floor(h/2)]);f=this.rgbToHex(c[z[0]][h-1])}t.style.background="linear-gradient(to right, "+m+"70 33%, "+e+"70 33% 67%, "+f+"70 67%)"}var x;var k={cursor:"grab",cursor:"-moz-grab",cursor:"-webkit-grab"};var y=false;if(r[5]){x=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemAArrow",hidefocus:"true",unselectable:"on",href:"#",menu:d,menuId:"false",menuFunc:r[5],menuParm:r[6],draggable:false},k);y=true}else{x=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#",menuFunc:r[2],menuParm:r[3],draggable:false})}var v=this.$cXI(r[1]&&CanvasXpress.icons.use.hasOwnProperty(r[1])?r[1]:CanvasXpress.png,{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:r[1],key:r[1]});var n;if(r[0]&&(r[0]=="Load"||r[0]=="Load Parameters")){n=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",draggable:false},{marginRight:0});var g=this.$cX("input",{id:this.newId("-cX-List-Item-Text-File-Upload"),className:"CanvasXpressListItemText",type:"file",draggable:false},{color:"transparent",width:"100px"});n.appendChild(g)}else{n=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",innerHTML:r[0]||"",draggable:false},y?k:false)}if(j.colorBackground){n.style.fontWeight="bolder"}var p=this.$cX("span",{className:"CanvasXpressListItemTextShort",innerHTML:r[4]||"",draggable:false});x.appendChild(v);x.appendChild(n);x.appendChild(p);t.appendChild(x);if(w){w.parentNode.insertBefore(t,w)}else{j.appendChild(t)}this.addRemoveItemListeners("addEvtListener",t)};this.addMenuItemText=function(c,m,j){var h=this.newId("-cX-List-Item-Text-");var f=this.newId("-cX-List-Item-Text-Input-");var d=this.getMenuItemValue(c);var e=this.$cX("li",{id:h,className:"CanvasXpressListItem",click:c[1],params:[c[2],f]});var n=this.$cX("input",{id:f,className:"CanvasXpressList",type:"text",value:d},{paddingLeft:"3px",width:"200px"});var k=this.$cX("a",{id:this.newId("-cX-List-Text-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"});var g=this.$cXI("op_refresh",{id:this.newId("-cX-List-Text-Icon-"),className:"CanvasXpressListIcon",src:"op_refresh",key:"refreshForm"},{marginTop:"4px"});k.appendChild(g);k.appendChild(n);e.appendChild(k);if(j){j.parentNode.insertBefore(e,j)}else{m.appendChild(e)}this.addRemoveItemListeners("addEvtListener",e)};this.addMenuItemColor=function(E,v,L){var m=this.newId("-cX-List-Item-Color-");var n=this.newId("-cX-List-Item-Color-Container-");var g=this.newId("-cX-List-Item-Color-Current-");var B=this.newId("-cX-List-Item-Color-Palete-");var f=this.newId("-cX-List-Item-Color-Palete-Current-");var k=this.newId("-cX-List-Item-Color-Saturation-");var w=this.newId("-cX-List-Item-Color-Saturation-Current-");var N=this[E[2][0]]||"";var G=this.$cX("li",{id:m,className:"CanvasXpressListItem",click:E[1],params:[E[2],g],palete:B,paleteCurrent:f,colorCurrent:g,saturation:k,saturationCurrent:w});var M=this.$cX("a",{id:this.newId("-cX-List-Color-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"},{height:"140px",width:"250px"});var I=this.$cXI("op_refresh",{id:this.newId("-cX-Lis