% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genome_wide_threshold_1D.R
\name{genome_wide_threshold_1D}
\alias{genome_wide_threshold_1D}
\title{Calculate a genome-wide significance threshold for the single-variant scan}
\usage{
genome_wide_threshold_1D(
  data_obj,
  geno_obj,
  n_perm = 100,
  scan_what = c("eigentraits", "raw_traits"),
  ref_allele = NULL,
  alpha = c(0.01, 0.05),
  model_family,
  run_parallel = FALSE,
  n_cores = 4,
  verbose = FALSE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object.}

\item{n_perm}{The number of permutations to perform. The default is 100.}

\item{scan_what}{A character value that uniquely specifies whether the 
eigentraits or phenotypes should be scanned. Options are "eigentraits"
or "raw_traits".}

\item{ref_allele}{\code{\link{Cape}} requires that one of the alleles 
in the population be selected as a reference allele. The effects of all 
alleles are then reported as the effects relative to the reference allele. 
In the DO population B represents the C57BL/6J (B6) mouse. Because this strain is 
considered the standard strain, the default reference allele is B. 
If another allele has a positive effect, it means that it increases the given 
phenotype relative to that in the B6 mouse. Any other allele can be selected 
as the reference allele simply by specifying it with this argument.}

\item{alpha}{The alpha value(s) used to calculate significance levels. This should
be a vector of any length of numerical values between 0 and 1. The default is
a vector of length two: c(0.01, 0.05).}

\item{model_family}{Indicates the model family of the phenotypes. This can be 
either "gaussian" or "binomial".}

\item{run_parallel}{A logical value indicating whether the process should
be run in parallel. Defaults to FALSE.}

\item{n_cores}{integer number of cores to use if running in parallel}

\item{verbose}{A logical value indicating whether to print progress to the screen.
Defaults to FALSE.}
}
\value{
Returns a vector the same length as alpha indicating the
thresholds for each value of alpha.
}
\description{
This function uses permutation testing to calculate a genome-wide significance
threshold for the single-variant scan. Two user-defined thresholds are 
calculated: the lower threshold (higher alpha) can be used to determine which 
variants will be used in the pairwise scan. The higher threshold (lower alpha) 
is used to determine which variants are used as covariates in the pairwise scan. 
In each permutation, the phenotype or eigentrait is shuffled and all markers 
are retested with the permuted phenotype. The regression coefficients are 
collected from each permutation and the extreme value distribution is used to 
determine thresholds for the user-defined alpha values.
}
\keyword{internal}
