% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motivation_and_confidence.R
\name{get_pa_competence_score}
\alias{get_pa_competence_score}
\title{Compute a physical activity competence score.}
\usage{
get_pa_competence_score(
  feelings_about_pa1 = NA,
  feelings_about_pa2 = NA,
  feelings_about_pa3 = NA
)
}
\arguments{
\item{feelings_about_pa1}{A numeric (integer) vector representing a response to BREQ item 4 (valid values are integers between 1 and 5).}

\item{feelings_about_pa2}{A numeric (integer) vector representing a response to BREQ item 5 (valid values are integers between 1 and 5).}

\item{feelings_about_pa3}{A numeric (integer) vector representing a response to BREQ item 6 (valid values are integers between 1 and 5).}
}
\value{
Returns a numeric vector with values between 1.5 and 7.5 (if valid) or NA (if not valid).
}
\description{
This function computes a physical activity competence score (\code{pa_competence_score}) for responses to items 4-6 of the the Behavioral Regulation in
Exercise Questionnaire (BREQ) as they appear in \href{https://www.capl-eclp.ca/wp-content/uploads/2018/02/CAPL-2-questionnaire.pdf}{the CAPL-2 Questionnaire}. This score is used to compute the motivation and confidence domain score
(\code{mc_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_scale]{validate_scale()}}.

Valid elements (integers between 1 and 5) represent the following responses:
\itemize{
\item 1 = Not true for me
\item 2 = Not really true for me
\item 3 = Sometimes true for me
\item 4 = Often true for me
\item 5 = Very true for me
}
}
\examples{
get_pa_competence_score(
  feelings_about_pa1 = c(4, 3, 6, 5, "2"),
  feelings_about_pa2 = c(1:5),
  feelings_about_pa3 = c(1, 5, 4, 3, 3)
)

# [1]  3  5 NA  6  5

}
