% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rename_variable}
\alias{rename_variable}
\title{Rename variables in a data frame.}
\usage{
rename_variable(x = NULL, search = NA, replace = NA)
}
\arguments{
\item{x}{A data frame.}

\item{search}{A character vector representing the variable names to be renamed.}

\item{replace}{A character vector representing the new names for those variables identified in the \code{search} argument.}
}
\value{
Returns a data frame with the renamed variables (if variables in the \code{search} argument are successfully found and renamed).
}
\description{
This function renames variables in a data frame.
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_character]{validate_character()}}.
}
\examples{
capl_demo_data <- get_capl_demo_data(n = 25)

str(capl_demo_data[, 1:2])

# 'data.frame':	25 obs. of  2 variables:
# $ age   : int  11 9 10 11 9 8 11 9 10 12 ...
# $ gender: chr  "Female" "Girl" "Girl" "f" ...

capl_demo_data <- rename_variable(
  x = capl_demo_data, 
  search = c("age", "gender"),
  replace = c("hello", "world")
)

str(capl_demo_data[, 1:2])

# 'data.frame':	25 obs. of  2 variables:
# $ hello: int  11 9 10 11 9 8 11 9 10 12 ...
# $ world: chr  "Female" "Girl" "Girl" "f" ...

}
