% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/CalculateStratifiedSampleSize.R
\name{CalculateStratifiedSampleSize}
\alias{CalculateStratifiedSampleSize}
\title{Stratified random sample size}
\usage{
CalculateStratifiedSampleSize(strata = NULL, x = NULL, conf.level = 0.95,
  error = 0.1)
}
\arguments{
\item{strata}{\code{\link{vector}}, \code{\link{matrix}} or \code{\link{data.frame}}. If vector, the length must be equal to the number of sampling units in the population and each element represent the strata memebership of each sampling unit. If matrix or data.frame, first column represent the size of each strata, second column represent the expected mean in each strata and third column represent the expected variance in each strata. Each row is a stra and must be named.}

\item{x}{\code{\link{data.frame}} representing a pilot sample. First column has the variable to be estimated and second column has the strata membership of each observation.}

\item{conf.level}{the confidence level required. It must be \code{\link{numeric}} between 0 and 1 inclusive.}

\item{error}{the maximum relative difference between the estimate and the unknown population value. It must be \code{\link{numeric}} between 0 and 1 inclusive.}
}
\value{
numeric sample size rounded up to nearest integer.
}
\description{
Calculates sample size for a stratified random sampling design to estimate a total.
}
\examples{
# Using a pilot sample from a population with 10000 sampling units.
strata <- rep(c('Rural', 'Urban'), c(100, 9900))
pilot.sample <- data.frame(c(rpois(5, 1.3), rpois(45, 0.8)),
                           rep(c('Rural', 'Urban'), c(5, 45)))
CalculateStratifiedSampleSize(strata, pilot.sample)

# Using expected mean and variance for a population with
# 10000 sampling units.
str.n <- c(Rural = 100, Urban = 9900)
str.mean <- c(Rural = 1.4, Urban = 0.98)
str.var <- c(Rural = 1.48, Urban = 1.02)
CalculateStratifiedSampleSize(cbind(str.n, str.mean, str.var))
}
\references{
Levy P and Lemeshow S (2008). Sampling of populations: methods and applications, Fourth edition. John Wiley and Sons, Inc.

\url{http://oswaldosantos.github.io/capm}
}

