% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculus.R
\name{limf}
\alias{limf}
\title{Limit of a function}
\usage{
limf(f, var, val, dir = NULL, doit = TRUE)
}
\arguments{
\item{f}{Function to take limit of}

\item{var}{Variable to take limit for (either string or \code{caracas_symbol})}

\item{val}{Value for \code{var} to approach}

\item{dir}{Direction from where \code{var} should approach \code{val}: \code{'+'} or \code{'-'}}

\item{doit}{Evaluate the limit immediately (or later with \code{\link[=doit]{doit()}})}
}
\description{
Limit of a function
}
\examples{
if (have_sympy()) {
  x <- symbol("x")
  limf(sin(x)/x, "x", 0)
  limf(1/x, "x", 0, dir = '+')
  limf(1/x, "x", 0, dir = '-')
}

}
\concept{calculus}
