% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr_to_fun.R
\name{as_func}
\alias{as_func}
\title{Convert expression into function object.}
\usage{
as_func(x, order = NULL, vec_arg = FALSE)
}
\arguments{
\item{x}{caracas expression.}

\item{order}{desired order of function argument. Defaults to
alphabetical ordering.}

\item{vec_arg}{should the function take vector valued argument.}
}
\description{
Convert expression into function object.
}
\examples{
if (has_sympy()) {
  def_sym(b0, b1, b2, k, x)
  e <- b1 + (b0 - b1)*exp(-k*x) + b2*x

  f1 <- as_func(e)
  f1
  f1(1, 2, 3, 4, 5)
  f1 <- as_func(e, order = sort(all_vars(e)))
  f1(1, 2, 3, 4, 5)
  f2 <- as_func(e, vec_arg = TRUE)
  f2
  f2(c(1, 2, 3, 4, 5))
  f2 <- as_func(e, order = sort(all_vars(e)), vec_arg = TRUE)
  f2
  f2(c(1,2,3,4,5))
}
}
\concept{caracas_symbol}
