\name{StrBCD.sim}
\alias{StrBCD.sim}
\alias{StrBCD.sim.carandom}
\title{
Shao's Method in Two-arms Case for Simulated Data
}
\description{
Allocates patients generated by simulating covariates-profile on assumption of independence between covariates and levels within each covariate, to one of two treatments using Shao's method proposed by Shao J, Yu X, Zhong B (2010) <Doi:10.1093/biomet/asq014>. 
}
\usage{
\method{StrBCD.sim}{carandom}(n = 1000, cov_num = 2, level_num = c(2, 2), 
           pr = rep(0.5, 4), p = 0.85)
}
\arguments{
  \item{n}{number of patients. Default is \code{1000}.}
  \item{cov_num}{number of covariates. Default is \code{2}.}
  \item{level_num}{vector of level numbers for each covariates. Hence the length of level_num should equal to number of covariates. Default is \code{level_num = c(2, 2)}. }
  \item{pr}{vector of probabilities. Under assumption of independence between covariates, \code{pr} is a vector containing probabilities for each levels of each covariates. The length of \code{pr} should correspond to number of all levels; and sum of \code{pr} should equal \code{cov_num}. If \code{pr = rep(0.5, 4)} (default), it means \code{cov_num = 2}, and \code{level_num = c(2, 2)}.}
  \item{p}{probabilities of assigning one patient to treatment 1. p should be larger than 1 / 2 to obtain balance. The default is \code{0.85}.}
}
\details{
See \code{\link{StrBCD}}.
}
\value{
See \code{\link{StrBCD}}.
}
\seealso{
  See \code{\link{StrBCD}} for allocating a given completely collected data; See \code{\link{StrBCD.ui}} for command-line user interface. 
}