% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPosteriorMeanRate.R
\name{PlotPosteriorMeanRate}
\alias{PlotPosteriorMeanRate}
\title{Plot Posterior Mean Rate of Sample Occurrence for Poisson Process Model}
\usage{
PlotPosteriorMeanRate(
  output_data,
  n_posterior_samples = 5000,
  calibration_curve = NULL,
  plot_14C_age = TRUE,
  plot_cal_age_scale = "BP",
  show_individual_means = TRUE,
  show_confidence_intervals = TRUE,
  interval_width = "2sigma",
  bespoke_probability = NA,
  denscale = 3,
  resolution = 1,
  n_burn = NA,
  n_end = NA,
  plot_pretty = TRUE
)
}
\arguments{
\item{output_data}{The return value from the updating function
\link{PPcalibrate}. Optionally, the output data can have an extra list item
named \code{label} which is used to set the label on the plot legend.}

\item{n_posterior_samples}{Number of samples it will draw, after having removed \code{n_burn},
from the (thinned) MCMC realisations stored in \code{output_data} to estimate the
rate \eqn{\lambda(t)}. These samples may be repeats if the number of, post burn-in,
realisations is less than \code{n_posterior_samples}. If not given, 5000 is used.}

\item{calibration_curve}{This is usually not required since the name of the
calibration curve variable is saved in the output data. However, if the
variable with this name is no longer in your environment then you should pass
the calibration curve here. If provided, this should be a dataframe which
should contain at least 3 columns entitled \code{calendar_age}, \code{c14_age} and \code{c14_sig}.
This format matches \link{intcal20}.}

\item{plot_14C_age}{Whether to use the radiocarbon age (\eqn{{}^{14}}C yr BP) as
the units of the y-axis in the plot. Defaults to \code{TRUE}. If \code{FALSE} uses
F\eqn{{}^{14}}C concentration instead.}

\item{plot_cal_age_scale}{(Optional) The calendar scale to use for the x-axis. Allowed values are
"BP", "AD" and "BC". The default is "BP" corresponding to plotting in cal yr BP.}

\item{show_individual_means}{(Optional) Whether to calculate and show the mean posterior
calendar age estimated for each individual \eqn{{}^{14}}C sample on the plot as a rug on
the x-axis. Default is \code{TRUE}.}

\item{show_confidence_intervals}{Whether to show the pointwise confidence intervals
(at chosen probability level) on the plot. Default is \code{TRUE}.}

\item{interval_width}{The confidence intervals to show for both the
calibration curve and the predictive density. Choose from one of \code{"1sigma"} (68.3\%),
\code{"2sigma"} (95.4\%) and \code{"bespoke"}. Default is \code{"2sigma"}.}

\item{bespoke_probability}{The probability to use for the confidence interval
if \code{"bespoke"} is chosen above. E.g., if 0.95 is chosen, then the 95\% confidence
interval is calculated. Ignored if \code{"bespoke"} is not chosen.}

\item{denscale}{(Optional) Whether to scale the vertical range of the Poisson process mean rate plot
relative to the calibration curve plot. Default is 3 which means
that the maximum of the mean rate will be at 1/3 of the height of the plot.}

\item{resolution}{The distance between calendar ages at which to calculate the value of the rate
\eqn{\lambda(t)}. These ages will be created on a regular grid that automatically covers
the calendar period specified in \code{output_data}. Default is 1.}

\item{n_burn}{The number of MCMC iterations that should be discarded as burn-in (i.e.,
considered to be occurring before the MCMC has converged). This relates to the number
of iterations (\code{n_iter}) when running the original update functions (not the thinned \code{output_data}).
Any MCMC iterations before this are not used in the calculations. If not given, the first half of the
MCMC chain is discarded. Note: The maximum value that the function
will allow is \code{n_iter - 100 * n_thin} (where \code{n_iter} and \code{n_thin} are the arguments that were given to
\link{PPcalibrate}) which would leave only 100 of the (thinned) values in \code{output_data}.}

\item{n_end}{The last iteration in the original MCMC chain to use in the calculations. Assumed to be the
total number of iterations performed, i.e. \code{n_iter}, if not given.}

\item{plot_pretty}{logical, defaulting to \code{TRUE}. If set \code{TRUE} then will select pretty plotting
margins (that create sufficient space for axis titles and rotates y-axis labels). If \code{FALSE} will
implement current user values.}
}
\value{
A list, each item containing a data frame of the \code{calendar_age_BP}, the \code{rate_mean}
and the confidence intervals for the rate - \code{rate_ci_lower} and \code{rate_ci_upper}.
}
\description{
Given output from the Poisson process fitting function \link{PPcalibrate} calculate
and plot the posterior mean rate of sample occurrence (i.e., the underlying Poisson process
rate \eqn{\lambda(t)}) together with specified probability intervals, on a given calendar age grid
(provided in cal yr BP).

Will show the original set of radiocarbon determinations (those you are modelling/summarising),
the chosen calibration curve, and the estimated posterior rate of occurrence \eqn{\lambda(t)} on the same plot.
Can also optionally show the posterior mean of each individual sample's calendar age estimate.

\strong{Note:} If all you are interested in is the value of the posterior mean rate
on a grid, without an accompanying plot, you can use
\link{FindPosteriorMeanRate} instead.

For more information read the vignette: \cr
\code{vignette("Poisson-process-modelling", package = "carbondate")}
}
\examples{
# NOTE: All these examples are shown with a small n_iter and n_posterior_samples
# to speed up execution.
# Try n_iter and n_posterior_samples as the function defaults.

pp_output <- PPcalibrate(
    pp_uniform_phase$c14_age,
    pp_uniform_phase$c14_sig,
    intcal20,
    n_iter = 1000,
    show_progress = FALSE)

# Default plot with 2 sigma interval
PlotPosteriorMeanRate(pp_output, n_posterior_samples = 100)

# Specify an 80\% confidence interval
PlotPosteriorMeanRate(
    pp_output,
    interval_width = "bespoke",
    bespoke_probability = 0.8,
    n_posterior_samples = 100)
}
