% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highd_obj.R
\name{spiral_3d}
\alias{spiral_3d}
\title{Generate a spiral dataset with optional noise.}
\usage{
spiral_3d(n, num_dims, num_noise, min_n, max_n)
}
\arguments{
\item{n}{Total number of data points to generate.}

\item{num_dims}{Number of effective dimensions for each data point.}

\item{num_noise}{Number of additional noise dimensions to add to the data.}

\item{min_n}{Minimum value for the noise added to the data.}

\item{max_n}{Maximum value for the noise added to the data.}
}
\value{
A matrix containing the generated data points with or without added noise.
}
\description{
This function generates a dataset arranged in a spiral pattern with optional noise.
}
\examples{
set.seed(20240412)
spiral_3d(n = 100, num_dims = 10, num_noise = 2, min_n = -0.05, max_n = 0.05)

}
