% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangular.R
\name{tri_plane_bkg}
\alias{tri_plane_bkg}
\title{Generate Triangular Plane with Background Noise}
\usage{
tri_plane_bkg(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of samples to generate.}

\item{num_noise}{The number of additional noise dimensions to add to the data.}

\item{min_n}{The minimum value for the noise dimensions.}

\item{max_n}{The maximum value for the noise dimensions.}
}
\value{
A matrix containing the triangular plane dataset with background noise.
}
\description{
This function generates a triangular plane dataset with background noise dimensions.
}
\examples{
set.seed(20240412)
triangular_plane_data <- tri_plane_bkg(
  n = 216,
  num_noise = 2, min_n = -0.05, max_n = 0.05
)
}
