% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_dichotomous.R
\name{ard_dichotomous}
\alias{ard_dichotomous}
\alias{ard_dichotomous.data.frame}
\title{Dichotomous ARD Statistics}
\usage{
ard_dichotomous(data, ...)

\method{ard_dichotomous}{data.frame}(
  data,
  variables,
  by = dplyr::group_vars(data),
  strata = NULL,
  value = maximum_variable_value(data[variables]),
  statistic = everything() ~ c("n", "N", "p"),
  denominator = NULL,
  fmt_fn = NULL,
  stat_label = everything() ~ default_stat_labels(),
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{...}{Arguments passed to methods.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries. Default is \code{everything()}.}

\item{by, strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to use for grouping or stratifying the table output.
Arguments are similar, but with an important distinction:

\code{by}: results are tabulated by \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{strata}: results are tabulated by \strong{all \emph{observed} combinations} of the
columns specified.

Arguments may be used in conjunction with one another.}

\item{value}{(named \code{list})\cr
named list of dichotomous values to tabulate. Default is \code{maximum_variable_value(data)},
which returns the largest/last value after a sort.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element one or more of  \code{c("n", "N", "p")}
(or the RHS of a formula).}

\item{denominator}{(\code{data.frame}, \code{integer})\cr
Specify this \emph{optional} argument to change the denominator,
e.g. the \code{"N"} statistic. Default is \code{NULL}. See below for details.}

\item{fmt_fn}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character()))}.}

\item{stat_label}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(n = "n", p = "pct")} or
\code{everything() ~ list(n ~ "n", p ~ "pct")}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Compute Analysis Results Data (ARD) for dichotomous summary statistics.
}
\section{Denominators}{

By default, the \code{ard_categorical()} function returns the statistics \code{"n"}, \code{"N"}, and
\code{"p"}, where little \code{"n"} are the counts for the variable levels, and big \code{"N"} is
the number of non-missing observations. The default calculation for the
percentage is merely \code{p = n/N}.

However, it is sometimes necessary to provide a different \code{"N"} to use
as the denominator in this calculation. For example, in a calculation
of the rates of various observed adverse events, you may need to update the
denominator to the number of enrolled subjects.

In such cases, use the \code{denominator} argument to specify a new definition
of \code{"N"}, and subsequently \code{"p"}.
The argument expects one of the following inputs:
\itemize{
\item a data frame. Any columns in the data frame that overlap with the \code{by}/\code{strata}
columns will be used to calculate the new \code{"N"}.
\item an integer. This single integer will be used as the new \code{"N"}
\item a string: one of \code{"column"}, \code{"row"}, or \code{"cell"}. \code{"column"} is equivalent
to \code{denominator=NULL}. \code{"row"} gives 'row' percentages where \code{by}/\code{strata}
columns are the 'top' of a cross table, and the variables are the rows.
\code{"cell"} gives percentages where the denominator is the number of non-missing
rows in the source data frame.
\item a structured data frame. The data frame will include columns from \code{by}/\code{strata}.
The last column must be named \code{"...ard_N..."}. The integers in this column will
be used as the updated \code{"N"} in the calculations.
}
}

\examples{
ard_dichotomous(mtcars, by = vs, variables = c(cyl, am), value = list(cyl = 4))

mtcars |>
  dplyr::group_by(vs) |>
  ard_dichotomous(
    variables = c(cyl, am),
    value = list(cyl = 4),
    statistic = ~"p"
  )
}
