% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_mcnemar_test.R
\name{.format_mcnemartest_results}
\alias{.format_mcnemartest_results}
\title{Convert McNemar's test to ARD}
\usage{
.format_mcnemartest_results(by, variable, lst_tidy, ...)
}
\arguments{
\item{by}{(\code{string})\cr by column name}

\item{variable}{(\code{string})\cr variable column name}

\item{lst_tidy}{(named \code{list})\cr
list of tidied results constructed with \code{\link[cards:eval_capture_conditions]{eval_capture_conditions()}},
e.g. \code{eval_capture_conditions(t.test(mtcars$mpg ~ mtcars$am) |> broom::tidy())}.}

\item{...}{passed to \code{stats::mcnemar.test(...)}}
}
\value{
ARD data frame
}
\description{
Convert McNemar's test to ARD
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cardx:::.format_mcnemartest_results(
  by = "ARM",
  variable = "AGE",
  lst_tidy =
    cards::eval_capture_conditions(
      stats::mcnemar.test(cards::ADSL[["SEX"]], cards::ADSL[["EFFFL"]]) |>
        broom::tidy()
    )
)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
