% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calibrate_horizon_scores}
\alias{calibrate_horizon_scores}
\title{Perform rolling-origin calibration with recursive forecasting}
\usage{
calibrate_horizon_scores(
  y,
  y_modified,
  max_lag,
  caret_method,
  seasonal,
  K,
  lambda,
  pre_process,
  tune_grid,
  xreg = NULL,
  calibration_horizon,
  n_windows = NULL,
  initial_window = NULL,
  verbose = FALSE
)
}
\arguments{
\item{y}{Original time series (untransformed)}

\item{y_modified}{Transformed time series (Box-Cox if applicable)}

\item{max_lag}{Maximum lag used in the model}

\item{caret_method}{The caret method name}

\item{seasonal}{Logical, whether seasonal terms are used}

\item{K}{Fourier order for seasonality}

\item{lambda}{Box-Cox transformation parameter}

\item{pre_process}{Pre-processing specification}

\item{tune_grid}{Tuning grid (uses best parameters from initial fit)}

\item{xreg}{External regressors matrix (optional)}

\item{calibration_horizon}{Maximum forecast horizon for calibration}

\item{n_windows}{Number of rolling windows for calibration}

\item{initial_window}{Initial training window size for calibration}

\item{verbose}{Logical, print progress}
}
\value{
A list with horizon-indexed vectors of sorted absolute errors
}
\description{
This function computes horizon-specific nonconformity scores by performing
rolling-origin evaluation with recursive multi-step forecasting. This ensures
proper out-of-sample calibration that respects the exchangeability assumption
required for valid conformal prediction intervals.
}
\keyword{internal}
