% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogram_ncont.R
\name{cartogram_ncont}
\alias{cartogram_ncont}
\alias{cartogram_ncont.SpatialPolygonsDataFrame}
\alias{cartogram_ncont.sf}
\title{Calculate Non-Contiguous Cartogram Boundaries}
\usage{
cartogram_ncont(x, weight, k = 1, inplace = TRUE)

\method{cartogram_ncont}{SpatialPolygonsDataFrame}(x, weight, k = 1,
  inplace = TRUE)

\method{cartogram_ncont}{sf}(x, weight, k = 1, inplace = TRUE)
}
\arguments{
\item{x}{SpatialPolygonDataFrame or an sf object}

\item{weight}{Name of the weighting variable in x}

\item{k}{Factor expansion for the unit with the greater value}

\item{inplace}{If TRUE, each polygon is modified in its original place, 
if FALSE multi-polygons are centered on their initial centroid}
}
\value{
An object of the same class as x with resized polygon boundaries
}
\description{
Construct a non-contiguous area cartogram (Olson 1976).
}
\examples{
library(maptools)
library(cartogram)
library(rgdal)
data(wrld_simpl)

# Remove uninhabited regions
afr <- spTransform(wrld_simpl[wrld_simpl$REGION==2 & wrld_simpl$POP2005 > 0,],
                   CRS("+init=epsg:3395"))

# Create cartogram
afr_nc <- cartogram_ncont(afr, "POP2005")

# Plot
plot(afr)
plot(afr_nc, add = TRUE, col = 'red')

# Same with sf objects
library(sf)

afr_sf = st_as_sf(afr)

afr_sf_nc <- cartogram_ncont(afr_sf, "POP2005")

plot(st_geometry(afr_sf))
plot(st_geometry(afr_sf_nc), add = TRUE, col = 'red')

}
\references{
Olson, J. M. (1976). Noncontiguous Area Cartograms. In The Professional Geographer, 28(4), 371-380.
}
