% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typoLayer.R
\name{typoLayer}
\alias{typoLayer}
\title{Topology Layer}
\usage{
typoLayer(spdf, df, spdfid = NULL, dfid = NULL, var, col = NULL,
  border = "grey20", lwd = 1, legend.pos = "bottomleft",
  legend.title.txt = var, legend.title.cex = 0.8, legend.values.cex = 0.6,
  legend.nodata = "no data", legend.frame = FALSE, add = FALSE)
}
\arguments{
\item{spdf}{a SpatialPolygonsDataFrame.}

\item{df}{a data frame that contains the values to plot.}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{dfid}{identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the field in df to plot.}

\item{col}{a vector of colors.}

\item{border}{color of the polygons borders.}

\item{lwd}{borders width.}

\item{legend.pos}{position of the legend, one of "topleft", "top", 
"topright", "left", "right", "bottomleft", "bottom", "bottomright". If 
legend.pos is "n" then the legend is not plotted.}

\item{legend.title.txt}{title of the legend.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.nodata}{no data label.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot a typology layer.
}
\examples{
data(nuts2006)
## Example 1
nuts0.df$typo <- c(rep("A",10),rep("B",10),rep("C",10),rep("D",4))
colours <- c("red","green","blue","yellow")
typoLayer(spdf = nuts0.spdf, df = nuts0.df, var = "typo")


## Example 2
# Layout plot
layoutLayer(title = "Colors in Europe",
            sources = "UMS RIATE, 2015",
            scale = NULL,
            frame = TRUE,
            col = "black",
            coltitle = "white",
            bg = "#D9F5FF",
            extent = nuts0.spdf)
#Countries plot
nuts0.df$typo <- c(rep("A",10),rep("B",10),rep("C",10),rep("D",4))
typoLayer(spdf = nuts0.spdf, df = nuts0.df,
          var="typo", 
          legend.pos = "topright", 
          legend.title.txt = "Category", 
          add=TRUE)
}
\seealso{
\link{propSymbolsTypoLayer}, \link{typoLayer}, \link{legendTypo}
}

