% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOuterBorders.R
\name{getOuterBorders}
\alias{getOuterBorders}
\title{Extract SpatialPolygonsDataFrame Outer Borders}
\usage{
getOuterBorders(spdf, spdfid = NULL, res = NULL, width = NULL)
}
\arguments{
\item{spdf}{a SpatialPolygonsDataFrame.}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{res}{resolution of the grid used to compute borders (in spdf units). 
A high resolution will give more detailed borders. (optional)}

\item{width}{maximum distance between used to compute borders (in spdf units). 
A higher width will build borders between units that are farther apart. (optional)}
}
\value{
A SpatialLinesDataFrame of borders is returned. This object has three 
id fields: id, id1 and id2.
id1 and id2 are ids of units that neighbour a border; id is the concatenation 
of id1 and id2 (with "_" as separator).
}
\description{
Extract outer borders between SpatialPolygonsDataFrame units. 
Outer borders are non-contiguous SpatialPolygonsDataFrame borders (e.g. 
maritim borders).
}
\note{
getBorders and getOuterBorders can be combined with rbind.
}
\examples{
\dontrun{
data(nuts2006)
# Get units borders
nuts0.outer <- getOuterBorders(nuts0.spdf)
# Plot Countries
plot(nuts0.spdf, border = NA, col = "grey60")
# Plot borders
plot(nuts0.outer, col = sample(x = rainbow(nrow(nuts0.outer))), 
     lwd = 3, add = TRUE)
}
}
\seealso{
\link{discLayer}, \link{getBorders}
}

