% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLinkLayer.R
\name{getLinkLayer}
\alias{getLinkLayer}
\title{Create a Links Layer from a Data Frame of Links.}
\usage{
getLinkLayer(x, xid = NULL, df, dfid = NULL, spdf, spdf2 = NULL,
  spdfid = NULL, spdf2id = NULL, dfids = NULL, dfide = NULL)
}
\arguments{
\item{x}{an sf object, a simple feature collection (or a Spatial*DataFrame).}

\item{xid}{identifier field in x, default to the first column (optional)}

\item{df}{a data frame that contains identifiers of starting and ending points.}

\item{dfid}{identifier fields in df, character vector of length 2, default to 
the two first columns. (optional)}

\item{spdf}{defunct.}

\item{spdf2}{defunct.}

\item{spdfid}{defunct.}

\item{spdf2id}{defunct.}

\item{dfids}{defunct.}

\item{dfide}{defunct.}
}
\value{
An sf LINESTRING is returned, it contains two fields (origins and destinations).
}
\description{
Create a links layer from a data frame of links.
}
\examples{
library(sp)
data("nuts2006")
# Create a link layer
head(twincities.df)
# Select links from Ireland (IE)
twincitiesIE <- twincities.df[substr(twincities.df$i,1,2)=="IE", ]
twincities.sf <- getLinkLayer(x = nuts2.spdf, df = twincitiesIE, dfid = c("i", "j"))
# Plot the links
plot(nuts2.spdf, col = "#6C6870")
plot(twincities.sf, col = "#F78194", add = TRUE)
}
\seealso{
\link{gradLinkLayer}, \link{propLinkLayer}
}
