% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghostLayer.R
\name{ghostLayer}
\alias{ghostLayer}
\title{Plot a Ghost Layer}
\usage{
ghostLayer(x, bg)
}
\arguments{
\item{x}{an sf object, a simple feature collection or a 
Spatial*DataFrame.}

\item{bg}{background color.}
}
\description{
Plot an invisible layer with the extent of a spatial object.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
target <- mtq[30,]
ghostLayer(target, bg = "lightblue")
plot(st_geometry(mtq), add = TRUE, col = "gold2")
plot(st_geometry(target), add = TRUE, col = "red")
# overly complicated label placement trick:
labelLayer(x = suppressWarnings(st_intersection(mtq, st_buffer(target, 2000))), 
           txt = "LIBGEO", halo = TRUE, cex = .9, r = .14, font = 2, 
           bg = "grey20", col= "white")
}
