% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHazardRatio.R, R/plot_methods.R, R/utils.R
\name{plotHazardRatio}
\alias{plotHazardRatio}
\alias{plot.singleEventCB}
\alias{incrVar}
\title{Plot Hazards and Hazard Ratios}
\usage{
plotHazardRatio(x, newdata, newdata2, ci, ci.lvl, ci.col, rug, xvar, ...)

\method{plot}{singleEventCB}(
  x,
  ...,
  type = c("hazard", "hr"),
  hazard.params = list(),
  newdata,
  exposed,
  increment = 1,
  var,
  xvar = NULL,
  ci = FALSE,
  ci.lvl = 0.95,
  rug = !ci,
  ci.col = "grey"
)

incrVar(var, increment = 1)
}
\arguments{
\item{x}{Fitted object of class \code{glm}, \code{gam}, \code{cv.glmnet} or \code{gbm}. This is
the result from the \code{\link[=fitSmoothHazard]{fitSmoothHazard()}} function.}

\item{newdata}{Required for \code{type="hr"}. The \code{newdata} argument is
the "unexposed" group, while the exposed group is defined by either: (i) a
change (defined by the \code{increment} argument) in a variable in newdata
defined by the \code{var} argument ; or (ii) an exposed function that takes
a data-frame and returns the "exposed" group (e.g. \code{exposed =
  function(data) transform(data, treat=1)}). This is a generalization of the
behavior of the rstpm2 plot function. It allows both numeric and factor
variables to be incremented or decremented. See references for rstpm2
package. Only used for \code{type="hr"}}

\item{newdata2}{\code{data.frame} for exposed group. calculated and passed
internally to \code{plotHazardRatio} function}

\item{ci}{Logical; if TRUE confidence bands are calculated. Only available
for \code{family="glm"} and \code{family="gam"}, and only used for \code{type="hr"},
Default: !add. Confidence intervals for hazard ratios are calculated using
the Delta Method.}

\item{ci.lvl}{Confidence level. Must be in (0,1), Default: 0.95. Only used
for \code{type="hr"}.}

\item{ci.col}{Confidence band color. Only used if argument \code{ci=TRUE},
Default: 'grey'. Only used for \code{type="hr"}.}

\item{rug}{Logical. Adds a rug representation (1-d plot) of the event times
(only for \code{status=1}), Default: !ci. Only used for \code{type="hr"}.}

\item{xvar}{Variable to be used on x-axis for hazard ratio plots. If NULL,
the function defaults to using the time variable used in the call to
\code{fitSmoothHazard}. In general, this should be any continuous variable
which has an interaction term with another variable. Only used for
\code{type="hr"}.}

\item{...}{further arguments passed to \code{plot}. Only used if \code{type="hr"}.
Any of \code{lwd},\code{lty},\code{col},\code{pch},\code{cex} will be applied to the hazard ratio
line, or point (if only one time point is supplied to \code{newdata}).}

\item{type}{plot type. Choose one of either \code{"hazard"} for hazard
function or \code{"hr"} for hazard ratio.  Default: \code{type = "hazard"}.}

\item{hazard.params}{Named list of arguments which will override the defaults
passed to \code{\link[visreg:visreg]{visreg::visreg()}}, The default arguments are \code{list(fit = x,
  trans = exp, plot = TRUE, rug = FALSE, alpha = 1, partial = FALSE, overlay
  = TRUE)}. For example, if you want a 95\% confidence band, specify
\code{hazard.params = list(alpha = 0.05)}. Note that The \code{cond} argument
must be provided as a named list. Each element of that list specifies the
value for one of the terms in the model; any elements left unspecified are
filled in with the median/most common category. Only used for
\code{type="hazard"}. All other argument are used for \code{type="hr"}. Note that the
\code{visreg} package must be installed for \code{type="hazard"}.}

\item{exposed}{function that takes \code{newdata} and returns the exposed
dataset (e.g. function(data) transform(data, treat = 1)). This argument
takes precedence over the \code{var} argument, i.e., if both \code{var} and
\code{exposed} are correctly specified, only the \code{exposed} argument
will be used. Only used for \code{type="hr"}.}

\item{increment}{Numeric value indicating how much to increment (if positive)
or decrement (if negative) the \code{var} variable in \code{newdata}. See
\code{var} argument for more details. Default is 1. Only used for
\code{type="hr"}.}

\item{var}{specify the variable name for the exposed/unexposed (name is given
as a character variable). If this argument is missing, then the
\code{exposed} argument must be specified. This is the variable which will
be incremented by the \code{increment} argument to give the exposed
category. If \code{var} is coded as a factor variable, then
\code{increment=1} will return the next level of the variable in
\code{newdata}. \code{increment=2} will return two levels above, and so on.
If the value supplied to \code{increment} is greater than the number of
levels, this will simply return the max level. You can also decrement the
categorical variable by specifying a negative value, e.g.,
\code{increment=-1} will return one level lower than the value in
\code{newdata}. If \code{var} is a numeric, than \code{increment} will
increment (if positive) or decrement (if negative) by the supplied value.
Only used for \code{type="hr"}.}
}
\value{
a plot of the hazard function or hazard ratio. For \code{type="hazard"}, a
\code{data.frame} (returned invisibly) of the original data used in the fitting
along with the data used to create the plots including \code{predictedhazard}
which is the predicted hazard for a given covariate pattern and time.
\code{predictedloghazard} is the predicted hazard on the log scale. \code{lowerbound}
and \code{upperbound} are the lower and upper confidence interval bounds on the
hazard scale (i.e. used to plot the confidence bands). \code{standarderror} is
the standard error of the log hazard or log hazard ratio (only if
\code{family="glm"} or \code{family="gam"}). For \code{type="hr"}, \code{log_hazard_ratio} and
\code{hazard_ratio} is returned, and if \code{ci=TRUE}, \code{standarderror} (on the log
scale) and \code{lowerbound} and \code{upperbound} of the \code{hazard_ratio} are
returned.
}
\description{
Plot method for objects returned by the \code{fitSmoothHazard}
function. Current plot types are hazard function and hazard ratio. The
\code{visreg} package must be installed for \code{type="hazard"}. This
function accounts for the possible time-varying exposure effects.
}
\details{
This function has only been thoroughly tested for \code{family="glm"}. If
the user wants more customized plot aesthetics, we recommend saving the
results to a \code{data.frame} and using  the graphical package of their choice.
}
\examples{
if (requireNamespace("splines", quietly = TRUE)) {
data("simdat") # from casebase package
library(splines)
simdat <- transform(simdat[sample(1:nrow(simdat), size = 200),],
                    treat = factor(trt, levels = 0:1,
                    labels = c("control","treatment")))

fit_numeric_exposure <- fitSmoothHazard(status ~ trt*bs(eventtime),
                                        data = simdat,
                                        ratio = 1,
                                        time = "eventtime")

fit_factor_exposure <- fitSmoothHazard(status ~ treat*bs(eventtime),
                                       data = simdat,
                                       ratio = 1,
                                       time = "eventtime")

newtime <- quantile(fit_factor_exposure[["data"]][[fit_factor_exposure[["timeVar"]]]],
                    probs = seq(0.05, 0.95, 0.01))

par(mfrow = c(1,3))
plot(fit_numeric_exposure,
     type = "hr",
     newdata = data.frame(trt = 0, eventtime = newtime),
     exposed = function(data) transform(data, trt = 1),
     xvar = "eventtime",
     ci = TRUE)

#by default this will increment `var` by 1 for exposed category
plot(fit_factor_exposure,
     type = "hr",
     newdata = data.frame(treat = factor("control",
              levels = c("control","treatment")), eventtime = newtime),
     var = "treat",
     increment = 1,
     xvar = "eventtime",
     ci = TRUE,
     ci.col = "lightblue",
     xlab = "Time",
     main = "Hazard Ratio for Treatment",
     ylab = "Hazard Ratio",
     lty = 5,
     lwd = 7,
     rug = TRUE)


# we can also decrement `var` by 1 to give hazard ratio for control/treatment
result <- plot(fit_factor_exposure,
               type = "hr",
               newdata = data.frame(treat = factor("treatment",
                                    levels = c("control","treatment")),
                                    eventtime = newtime),
               var = "treat",
               increment = -1,
               xvar = "eventtime",
               ci = TRUE)

# see data used to create plot
head(result)
}
}
\references{
Mark Clements and Xing-Rong Liu (2019). rstpm2: Smooth Survival
Models, Including Generalized Survival Models. R package version 1.5.1.
https://CRAN.R-project.org/package=rstpm2

Breheny P and Burchett W (2017). Visualization of Regression Models Using
visreg. The R Journal, 9: 56-71.
}
\seealso{
\code{\link[utils]{modifyList}}, \code{\link[=fitSmoothHazard]{fitSmoothHazard()}},
\code{\link[graphics:par]{graphics::par()}}, \code{\link[visreg:visreg]{visreg::visreg()}}
}
