% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat2cat.R
\name{cat2cat}
\alias{cat2cat}
\title{Automatic mapping of a categorical variable in a panel dataset according to a new encoding}
\usage{
cat2cat(
  data = list(old = NULL, new = NULL, cat_var = NULL, cat_var_old = NULL, cat_var_new =
    NULL, id_var = NULL, time_var = NULL, multiplier_var = NULL, freqs_df = NULL),
  mappings = list(trans = NULL, direction = NULL),
  ml = list(data = NULL, cat_var = NULL, method = NULL, features = NULL, args = NULL)
)
}
\arguments{
\item{data}{`named list` with fields `old`, `new`, `cat_var` (or `cat_var_old` and `cat_var_new`), `time_var` and optional `id_var`,`multiplier_var`,`freq_df`.}

\item{mappings}{`named list` with 2 fields `trans` and `direction`.}

\item{ml}{`named list` with up to 5 fields `data`, `cat_var`, `method`, `features` and optional `args`.}
}
\value{
named list with 2 fields old an new - 2 data.frames.
There will be added additional columns like index_c2c, g_new_c2c, wei_freq_c2c, rep_c2c, wei_(ml method name)_c2c.
Additional columns will be informative only for a one data.frame as we always make a changes to one direction.
}
\description{
This function is built to work for two time points at once.
Thus for more periods some recursion will be needed.
The \code{prune_c2c} might be needed when we have many interactions to limit growing number of replications.
This function might seems to be a complex at the first glance though it is built to offer a wide range of applications for complex tasks.
}
\details{
data args
\itemize{
 \item{"old"}{ data.frame older time point in a panel}
 \item{"new"} { data.frame more recent time point in a panel}
 \item{"cat_var"}{ character name of the categorical variable.}
 \item{"cat_var_old"}{ optional character name of the categorical variable in the older time point. Default `cat_var`.}
 \item{"cat_var_new"}{ optional character name of the categorical variable in the newer time point. Default `cat_var`.}
 \item{"time_var"}{ character name of the time variable.}
 \item{"id_var"}{ optional character name of the unique identifier variable - if this is specified then for subjects observe in both periods the direct mapping is applied.}
 \item{"multiplier_var"}{ optional character name of the multiplier variable - number of replication needed to reproduce the population}
 \item{"freqs_df"}{ optional - data.frame with 2 columns where first one is category name and second counts.
 It is optional nevertheless will be very often needed, as give more control.
 It will be used to assess the probabilities. The multiplier variable is omit so sb has to apply it in this table.}
}
mappings args
\itemize{
 \item{"trans"}{ data.frame with 2 columns - transition table - all categories for cat_var in old and new datasets have to be included.
  First column contains an old encoding and second a new one.
  The transition table should to have a candidate for each category from the targeted for an update period.
}
 \item{"direction"}{ character direction - "backward" or "forward"}
}
optional ml args
\itemize{
 \item{"data"}{ data.frame - dataset with features and the `cat_var`.}
 \item{"cat_var"}{ character - the dependent variable name.}
 \item{"method"}{ character vector - one or a few from "knn", "rf" and "lda" methods - "knn" k-NearestNeighbors, "lda" Linear Discrimination Analysis, "rf" Random Forest }
 \item{"features"}{ character vector of features names where all have to be numeric or logical}
 \item{"args"}{ optional - list parameters: knn: k ; rf: ntree  }
}

Without ml section only simple frequencies are assessed.
When ml model is broken then weights from simple frequencies are taken.
`knn` method is recommended for smaller datasets.
}
\note{
The transition table should to have a candidate for each category from the targeted for an update period.
The observation from targeted for an updated period without a matched category from base period is removed.
If you want to leave NA values add `c(NA, NA)` row to the `trans` table.
Please check the vignette for more information.
}
\examples{
\dontrun{
data(occup_small)
data(occup)
data(trans)

occup_old <- occup_small[occup_small$year == 2008, ]
occup_new <- occup_small[occup_small$year == 2010, ]

# Adding the dummy level to the mapping table for levels without the candidate
# The best to fill them manually with proper candidates, if possible
# In this case it is only needed for forward mapping, to suppress warnings
trans2 <- rbind(
  trans,
  data.frame(
    old = "no_cat",
    new = setdiff(c(occup_new$code), trans$new)
  )
)

# default only simple frequencies
occup_simple <- cat2cat(
  data = list(old = occup_old, new = occup_new, cat_var = "code", time_var = "year"),
  mappings = list(trans = trans2, direction = "forward")
)

# additional probabilities from knn
occup_ml <- cat2cat(
  data = list(old = occup_old, new = occup_new, cat_var = "code", time_var = "year"),
  mappings = list(trans = trans, direction = "backward"),
  ml = list(
    data = occup_old,
    cat_var = "code",
    method = "knn",
    features = c("age", "sex", "edu", "exp", "parttime", "salary"),
    args = list(k = 10)
  )
)
}

}
