% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{obsInf}
\alias{obsInf}
\title{Observed Information}
\usage{
obsInf(catObj, theta, item)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{theta}{A numeric or an integer indicating the value for \eqn{\theta}}

\item{item}{An integer indicating the index of the question item}
}
\value{
The function \code{obsInf} returns a numeric value of the observed information of the likelihood, given \eqn{\theta}, for a given question item.
}
\description{
Calculates the observed information of the likelihood of a respondent's ability \eqn{\theta} for a given \code{item}.
}
\details{
The observed information is equivalent to the negative second derivative of the log-likelihood evaluated at \eqn{\theta}.
This function should never be called when the respondent has answered no questions as the likelihood is not defined.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Calculate observed information for different ability parameters and items
obsInf(ltm_cat, theta = 1, item = 10)
obsInf(ltm_cat, theta = 1, item = 11)
obsInf(ltm_cat, theta = 0, item = 10)
obsInf(ltm_cat, theta = 0, item = 11)

}
\seealso{
\code{\link{estimateTheta}}, \code{\link{expectedObsInf}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
