% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{extra_cat}
\alias{extra_cat}
\title{Extraversion Cat Object}
\format{An object of class \code{Cat} of length 1.}
\source{
See \url{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.
}
\usage{
data(extra_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 20-item Extraversion dimension of the 
100-item IPIP representation of Costa and McCrae's Five Factor Model
}
\details{
Cat object containing item parameters for graded response model fit with
  774,410 response profiles by myPersonality Project and 1500 response profiles
collected by YouGov in June 2018.  The sample from myPersonality Project was a convenience sample, and the
respondents from YouGov were matched to a sampling frame on gender, age, race, and education.

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the YouGov sample (-.367) and a standard deviation (1.3)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are 1=Very inaccurate; 2=Moderately inaccurate; 3=Neither inaccurate nor accurate;
4=Moderately accurate; 5=Very accurate.

The wording of the question items:

I...
\describe{
\item{\code{q83}}{Feel comfortable around people.}
\item{\code{q10}}{Make friends easily.}
\item{\code{q73}}{Am skilled in handling social situations.}
\item{\code{q63}}{Am the life of the party.}
\item{\code{q53}}{Know how to captivate people.}
\item{\code{q93}}{Start conversations.}
\item{\code{q33}}{Warm up quickly to others.}
\item{\code{q43}}{Talk to a lot of different people at parties.}
\item{\code{q3}}{Don't mind being the center of attention.}
\item{\code{q23}}{Cheer people up.}
\item{\code{q39}}{Have little to say.}
\item{\code{q14}}{Keep in the background.}
\item{\code{q89}}{Would describe my experiences as somewhat dull.}
\item{\code{q59}}{Don't like to draw attention to myself.}
\item{\code{q29}}{Don't talk a lot.}
\item{\code{q18}}{Avoid contacts with others.}
\item{\code{q99}}{Am hard to get to know.}
\item{\code{q79}}{Retreat from others.}
\item{\code{q69}}{Find it difficult to approach others.}
\item{\code{q49}}{Keep others at a distance.}
}
}
\references{
Costa, P. T., Jr., & McCrae, R. R. (1992). Revised NEO Personality Inventory (NEO PI-R)
and NEO Five-Factor Inventory (NEO-FFI): Professional manual. Odessa, FL: Psychological Assessment Resources.

Stillwell, David, and Michal Kosinski. 2007. "myPersonality Project."
\url{https://sites.google.com/michalkosinski.com/mypersonality}
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
