% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catching-n-plans.R
\name{dispense_collected}
\alias{dispense_collected}
\title{Return the value after raising all collected conditions}
\usage{
dispense_collected(l, treat_errs = c("raise", "display", "warn"))
}
\arguments{
\item{l}{The results of \code{\link[=catch_expr]{catch_expr()}} or a function from \code{\link[=make_catch_fn]{make_catch_fn()}}}

\item{treat_errs}{One of three strings governing how errors are treated: \code{"raise"} which will simply raise errors as they are, \code{"display"} which will just print the error messages on-screen, and \code{"warn"} which will raise the errors as warnings.}
}
\description{
This function takes in the \link[=collect]{collected conditions list} that is the output of \code{\link[=catch_expr]{catch_expr()}} or a function from \code{\link[=make_catch_fn]{make_catch_fn()}}, raises all the conditions that were collected, and then returns the value the original evaluated expression had returned.  This might be useful in situations in which one had collected conditions from a remote evaluation of an expression, and wishes to raise the conditions locally.

The way the errors are treated can be changed as well: they can either be raised as-is, displayed on screen, or raised as warnings.
}
