% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate_functions.R
\name{gen.sim.data}
\alias{gen.sim.data}
\title{Generate simulation data set}
\usage{
gen.sim.data(n, p, r, d0 = 0, d1 = 1, X.dist = c("binary", "normal"),
  alpha = matrix(0.5, r, d0 + d1), beta = NULL, beta.strength = 1,
  beta.nonzero.frac = 0.05, Gamma = NULL, Gamma.strength = sqrt(p),
  Gamma.beta.cor = 0, Sigma = 1, seed = NULL)
}
\arguments{
\item{n}{number of observations}

\item{p}{number of observed variables}

\item{r}{number of confounders}

\item{d0}{number of nuisance regression covariates}

\item{d1}{number of primary regression covariates}

\item{X.dist}{the distribution of X, either "binary" or "normal"}

\item{alpha}{association of X and Z, a r*d vector (d = d0 + d1)}

\item{beta}{treatment effects, a p*d vector}

\item{beta.strength}{strength of beta}

\item{beta.nonzero.frac}{if beta is not specified, fraction of nonzeros in beta}

\item{Gamma}{confounding effects, a p*r matrix}

\item{Gamma.strength}{strength of Gamma, more precisely the mean of square entries of Gamma * alpha}

\item{Gamma.beta.cor}{the "correlation" (proportion of variance explained) of beta and Gamma}

\item{Sigma}{noise variance, a p*p matrix or p*1 vector or a single real number}

\item{seed}{random seed}
}
\value{
a list of objects
\describe{
\item{X0}{matrix nuisance covariates}
\item{X1}{primary covariates}
\item{Y}{matrix Y}
\item{Z}{matrix of confounders}
\item{alpha}{regression coefficients between X and Z}
\item{beta}{regression coefficients between X and Y}
\item{Gamma}{coefficients between Z and Y}
\item{Sigma}{noise variance}
\item{beta.nonzero.pos}{the nonzero positions in beta}
\item{r}{number of confounders}
}
}
\description{
\code{gen.sim.data} generates data from the following model
Y = X_0 Beta_0^T + X_1 Beta_1^T + Z Gamma^T + E Sigma^{1/2},
Z|X_0, X_1 = X_0 Alpha_0^T + X_1 Alpha_1^T + D,
cov(X_0, X_1) ~ Sigma_X
}

