% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagp_plot.R
\name{dagp_plot}
\alias{dagp_plot}
\title{Plot posterior distribution from dataframe of posterior draws.}
\usage{
dagp_plot(drawsDF, densityPlot = FALSE)
}
\arguments{
\item{drawsDF}{the dataframe output of \code{dag_greta(mcmc=TRUE)} where each column is a parameter and each row a single draw from a representative sample.}

\item{densityPlot}{If \code{TRUE}, each parameter gets its own density plot.  If \code{FALSE} (recommended usage), parameters are grouped into facets based on whether they share the same prior or not.  10 and 90 percent credible intervals are displayed for the posterior distributions.}
}
\value{
a credible interval plot of all latent posterior distribution parameters.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Plot the posterior distribution of all latent parameters using a dataframe of posterior draws from a \code{causact_graph} model.
}
\examples{
# A simple example
posteriorDF = data.frame(x = rnorm(100),
y = rexp(100),
z = runif(100))
posteriorDF \%>\%
dagp_plot(densityPlot = TRUE)

# More complicated example requiring 'greta'
\dontrun{
library(greta)
# Create a 2 node graph
graph = dag_create() \%>\%
  dag_node("Get Card","y",
         rhs = bernoulli(theta),
         data = carModelDF$getCard) \%>\%
  dag_node(descr = "Card Probability by Car",label = "theta",
           rhs = beta(2,2),
           child = "y")
graph \%>\% dag_render()

# below requires Tensorflow installation
drawsDF = graph \%>\% dag_greta(mcmc=TRUE)
drawsDF \%>\% dagp_plot()
}

# A multiple plate example
library(dplyr)
poolTimeGymDF = gymDF \%>\%
mutate(stretchType = ifelse(yogaStretch == 1,
                            "Yoga Stretch",
                            "Traditional")) \%>\%
group_by(gymID,stretchType,yogaStretch) \%>\%
  summarize(nTrialCustomers = sum(nTrialCustomers),
            nSigned = sum(nSigned))
graph = dag_create() \%>\%
  dag_node("Cust Signed","k",
           rhs = binomial(n,p),
           data = poolTimeGymDF$nSigned) \%>\%
  dag_node("Probability of Signing","p",
           rhs = beta(2,2),
           child = "k") \%>\%
  dag_node("Trial Size","n",
           data = poolTimeGymDF$nTrialCustomers,
           child = "k") \%>\%
  dag_plate("Yoga Stretch","x",
            nodeLabels = c("p"),
            data = poolTimeGymDF$stretchType,
            addDataNode = TRUE) \%>\%
  dag_plate("Observation","i",
            nodeLabels = c("x","k","n")) \%>\%
  dag_plate("Gym","j",
            nodeLabels = "p",
            data = poolTimeGymDF$gymID,
            addDataNode = TRUE)
graph \%>\% dag_render()
\dontrun{
# below requires Tensorflow installation
drawsDF = graph \%>\% dag_greta(mcmc=TRUE)
drawsDF \%>\% dagp_plot()
}
}
