% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occupation.R
\name{LBFA_31A_a}
\alias{LBFA_31A_a}
\title{Occupation Group (5 categories)}
\usage{
LBFA_31A_a(LBFA_31A_a)
}
\arguments{
\item{LBFA_31A_a}{cchsflow variable name for Occupation Group (5 categories)}
}
\description{
\strong{NOTE:} this is not a function.

 This is a 5 category variable (LBFA_31A_a) that is in the CCHS that asks
 which occupation group best describes a respondent. Occupation group is
 asked in the 2001 CCHS cycle and in CCHS cycles from 2007-2014.
}
\details{
In the 2007-2014 CCHS survey cycles, occupation group has 5
 categories. The categories are as follows:
 \enumerate{
 \item Management, Health, Education, Art, Culture
 \item Business, Finance, Admin
 \item Sales or Service
 \item Trades, Transport or Equipment Operator
 \item Unique to Primary Industry/Processing/Manufacturing
 }
 
 In this variable, categories from the 2001 CCHS survey cycle were collapsed
 to harmonize with the other survey cycles. "Management, Professional
 (including accountants), Technologist, Technician or Tech Occupation" were
 combined into one category "Management, Health, Education, Art, Culture".
 "Farming, Forestry, Fishing, Mining" and "Processing, Manufacturing,
 Utilities", were combined into one category "Farming, Forestry, Fishing,
 Mining, Processing, Manufacturing, Utilities".  
 
 The "other" category in the 2001 CCHS survey cycle was assigned to missing
 (NA(b)). This is consistent with 
 \href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6423929/}{other studies}
 that group the "other" category as "missing". \code{\link{LBFA_31A_b}}
 is a 6 category variable that keeps the "other" category in the 2001 survey
 cycle as "other".
}
\examples{
library(cchsflow)
?LBFA_31A_a  

}
\seealso{
\code{\link{LBFA_31A}}, \code{\link{LBFA_31A_b}}
}
