% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColumns.R, R/old_fns.R
\name{pivot_to_rowrecs}
\alias{pivot_to_rowrecs}
\alias{pivotValuesToColumns}
\title{Move values from rows to columns (pivot).}
\usage{
pivot_to_rowrecs(data, columnToTakeKeysFrom, columnToTakeValuesFrom,
  rowKeyColumns, ..., sep = NULL, env = parent.frame())

pivotValuesToColumns(data, columnToTakeKeysFrom, columnToTakeValuesFrom,
  rowKeyColumns, ..., sep = NULL, env = parent.frame())
}
\arguments{
\item{data}{data.frame to work with (must be local, for remote please try \code{moveValuesToColumns*}).}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{rowKeyColumns}{character array names columns that should be table keys.}

\item{...}{force later arguments to bind by name.}

\item{sep}{character if not null build more detailed column names.}

\item{env}{environment to look for "winvector_temp_db_handle" in.}
}
\value{
new data.frame with values moved to columns.
}
\description{
For a tutorial please try \code{vignette('RowsAndColumns', package='cdata')}.

pivotValuesToColumns deprecated, functionality moved to: pivot_to_rowrecs
}
\examples{

d <- data.frame(meas= c('AUC', 'R2'), val= c(0.6, 0.2))
pivot_to_rowrecs(d,
                    columnToTakeKeysFrom= 'meas',
                    columnToTakeValuesFrom= 'val',
                    rowKeyColumns= c())

}
\seealso{
\code{\link{unpivot_to_blocks}}
}
