% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColsQ.R
\name{blocks_to_rowrecs_q}
\alias{blocks_to_rowrecs_q}
\title{Map sets rows to columns (query based, take name of table).}
\usage{
blocks_to_rowrecs_q(tallTable, keyColumns, controlTable, my_db, ...,
  columnsToCopy = NULL, tempNameGenerator = mk_tmp_name_source("mvtcq"),
  strict = FALSE, checkNames = TRUE, showQuery = FALSE,
  defaultValue = NULL, dropDups = FALSE, temporary = FALSE,
  resultName = NULL)
}
\arguments{
\item{tallTable}{name of table containing data to be mapped (db/Spark data)}

\item{keyColumns}{character list of column defining row groups}

\item{controlTable}{table specifying mapping (local data frame)}

\item{my_db}{db handle}

\item{...}{force later arguments to be by name.}

\item{columnsToCopy}{character list of column names to copy}

\item{tempNameGenerator}{a tempNameGenerator from cdata::mk_tmp_name_source()}

\item{strict}{logical, if TRUE check control table name forms}

\item{checkNames}{logical, if TRUE check names}

\item{showQuery}{if TRUE print query}

\item{defaultValue}{if not NULL literal to use for non-match values.}

\item{dropDups}{logical if TRUE supress duplicate columns (duplicate determined by name, not content).}

\item{temporary}{logical, if TRUE make result temporary.}

\item{resultName}{character, name for result table.}
}
\value{
wide table built by mapping key-grouped tallTable rows to one row per group
}
\description{
Transform data facts from rows into additional columns using SQL
and controlTable.
}
\details{
This is using the theory of "fluid data"n
(\url{https://github.com/WinVector/cdata}), which includes the
principle that each data cell has coordinates independent of the
storage details and storage detail dependent coordinates (usually
row-id, column-id, and group-id) can be re-derived at will (the
other principle is that there may not be "one true preferred data
shape" and many re-shapings of data may be needed to match data to
different algorithms and methods).

The controlTable defines the names of each data element in the two notations:
the notation of the tall table (which is row oriented)
and the notation of the wide table (which is column oriented).
controlTable[ , 1] (the group label) cross colnames(controlTable)
(the column labels) are names of data cells in the long form.
controlTable[ , 2:ncol(controlTable)] (column labels)
are names of data cells in the wide form.
To get behavior similar to tidyr::gather/spread one builds the control table
by running an appropiate query over the data.

Some discussion and examples can be found here:
\url{https://winvector.github.io/FluidData/FluidData.html} and
here \url{https://github.com/WinVector/cdata}.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) &&
  requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  # pivot example
  d <- data.frame(meas = c('AUC', 'R2'), val = c(0.6, 0.2))
  DBI::dbWriteTable(my_db,
                    'd',
                    d,
                    temporary = TRUE)
  cT <- build_pivot_control_q('d',
                              columnToTakeKeysFrom= 'meas',
                              columnToTakeValuesFrom= 'val',
                              my_db = my_db)
  tab <- blocks_to_rowrecs_q('d',
                             keyColumns = NULL,
                             controlTable = cT,
                             my_db = my_db)
  qlook(my_db, tab)
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{rowrecs_to_blocks_q}}, \code{\link{build_pivot_control_q}}, \code{\link{blocks_to_rowrecs}}
}
