% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColumns.R
\name{pivot_to_rowrecs}
\alias{pivot_to_rowrecs}
\alias{layout_to_rowrecs}
\title{Map data records from block records that have one row per measurement value to row records.}
\usage{
pivot_to_rowrecs(data, columnToTakeKeysFrom, columnToTakeValuesFrom,
  rowKeyColumns, ..., sep = NULL, checkNames = TRUE,
  checkKeys = TRUE, strict = FALSE, allow_rqdatatable = FALSE)

layout_to_rowrecs(data, columnToTakeKeysFrom, columnToTakeValuesFrom,
  rowKeyColumns, ..., sep = NULL, checkNames = TRUE,
  checkKeys = TRUE, strict = FALSE, allow_rqdatatable = FALSE)
}
\arguments{
\item{data}{data.frame to work with (must be local, for remote please try \code{moveValuesToColumns*}).}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{rowKeyColumns}{character array names columns that should be table keys.}

\item{...}{force later arguments to bind by name.}

\item{sep}{character if not null build more detailed column names.}

\item{checkNames}{logical, if TRUE check names.}

\item{checkKeys}{logical, if TRUE check keyColumns uniquely identify blocks (required).}

\item{strict}{logical, if TRUE check control table name forms}

\item{allow_rqdatatable}{logical, if TRUE allow rqdatatable shortcutting on simple conversions.}
}
\value{
new data.frame with values moved to columns.
}
\description{
Map data records from block records (where each record may be more than one row) to
row records (where each record is a single row).  Values specified in rowKeyColumns
determine which sets of rows build up records and are copied into the result.
}
\examples{

  d <- data.frame(model_id = c("m1", "m1"), meas = c('AUC', 'R2'), val= c(0.6, 0.2))
  pivot_to_rowrecs(d,
                   columnToTakeKeysFrom= 'meas',
                   columnToTakeValuesFrom= 'val',
                   rowKeyColumns= "model_id") \%.>\%
     print(.)

}
\seealso{
\code{\link{unpivot_to_blocks}}, \code{\link{blocks_to_rowrecs}}
}
