% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ili-weekly-state.r
\name{ili_weekly_activity_indicators}
\alias{ili_weekly_activity_indicators}
\title{Retrieve weekly state-level ILI indicators per-state for a given season}
\usage{
ili_weekly_activity_indicators(years = NULL)
}
\arguments{
\item{years}{a vector of years to retrieve data for (i.e. \code{2014} for CDC
flu season 2014-2015). CDC has data for this API going back to 2008
and up until the current, active flu season.
Default value (\code{NULL}) means retrieve \strong{all} years. NOTE: if you
happen to specify a 2-digit season value (i.e. \code{57} == 2017-2018)
the function is smart enough to retrieve by season ID vs convert that
to a year.}
}
\description{
Retrieve weekly state-level ILI indicators per-state for a given season
}
\note{
These statistics use the proportion of outpatient visits to healthcare providers
for influenza-like illness to measure the ILI activity level within a state. They do
not, however, measure the extent of geographic spread of flu within a state. Therefore,
outbreaks occurring in a single city could cause the state to display high activity levels.\cr
\cr
Data collected in ILINet may disproportionately represent certain populations within
a state, and therefore may not accurately depict the full picture of influenza activity
for the whole state.\cr
\cr
All summary statistics are based on either data collected in ILINet, or reports from
state and territorial epidemiologists. Differences in the summary data presented by
CDC and state health departments likely represent differing levels of data completeness
with data presented by the state likely being the more complete.
}
\examples{
\dontrun{
iwai <- ili_weekly_activity_indicators(2016)
}
}
\references{
\itemize{
\item \href{https://gis.cdc.gov/grasp/fluview/main.html}{ILI Activity Indicator Map Portal}
}
}
