% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrHMethod.R
\name{summary.cdfqrH}
\alias{summary.cdfqrH}
\alias{print.cdfqrH}
\alias{logLik.cdfqrH}
\alias{nobs.cdfqrH}
\alias{deviance.cdfqrH}
\alias{coef.cdfqrH}
\alias{vcov.cdfqrH}
\alias{update.cdfqrH}
\alias{formula.cdfqrH}
\alias{confint.cdfqrH}
\title{S3 Methods for getting output from fitted cdfqrr Objects.}
\usage{
\method{summary}{cdfqrH}(object, ...)

\method{print}{cdfqrH}(x, digits = max(3, getOption("digits") - 3), ...)

\method{logLik}{cdfqrH}(object, ...)

\method{nobs}{cdfqrH}(object, ...)

\method{deviance}{cdfqrH}(object, ...)

\method{coef}{cdfqrH}(object, type = c("full", "mean", "sigma", "zero", "one"), ...)

\method{vcov}{cdfqrH}(object, type = c("full", "mean", "sigma", "zero", "one"), ...)

\method{update}{cdfqrH}(object, formula., zero.fo., one.fo., ..., evaluate = TRUE)

\method{formula}{cdfqrH}(x, ...)

\method{confint}{cdfqrH}(
  object,
  parm,
  level = 0.95,
  type = c("full", "mean", "sigma", "zero", "one"),
  ...
)
}
\arguments{
\item{object}{The fitted cdfqrH model.}

\item{...}{Pass onto other functions or currently ignored}

\item{x}{The fitted cdfqrH model.}

\item{digits}{Number of digits to be retained in printed output.}

\item{type}{The parts of coefficients or variance-covariance matrix to be extracted.Can be "full", "mean",or "sigma".}

\item{formula.}{Changes to the formula. See \code{\link[Formula]{update.Formula}} for details.}

\item{zero.fo.}{Changes to the formula for the zero component, only input as \code{~ predictors}. See \code{\link[Formula]{update.Formula}} for details.}

\item{one.fo.}{Changes to the formula for the one component, only input as \code{~ predictors}. See \code{\link[Formula]{update.Formula}} for details.}

\item{evaluate}{If true evaluate the new updated model else return the call for the new model.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}
}
\description{
Give S3 Methods for CDF-Quantile Distribution Models
}
\examples{
data(cdfqrHExampleData)
ipcc_mid <- subset(IPCC, mid == 1 & high == 0)
fit <- cdfquantregH(prob ~ valence | valence, zero.fo = ~valence,
  one.fo = ~valence,
  fd ='t2',sd ='t2', type = "ZO", data = ipcc_mid)

summary(fit)
print(fit)
logLik(fit)
coef(fit)
deviance(fit)
vcov(fit)
confint(fit)


}
