% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudobulk.R
\name{class_to_deseq2}
\alias{class_to_deseq2}
\title{Create DESeq2 object for a given cell type}
\usage{
class_to_deseq2(obj, meta_df, class, design = ~condition)
}
\arguments{
\item{obj}{A cellpypes object, see section \strong{cellpypes Objects} below.}

\item{meta_df}{Data frame where each column helps to identify a pseudobulk.
Typical columns of meta_df are for example patient, treatment and
cell type -- anything
that uniquely identifies a replicate / batch / 10x run.
Each row in meta_df corresponds to a single cell in your raw count matrix.}

\item{class}{The name of cellpypes class for which you want to test
for differential expression.}

\item{design}{A formula based on columns in \code{meta_df}.
To test differential expression between two groups
in meta_df$condition, use formula \code{~ condition}.
More complex formulas (e.g. with interactions) are possible, for example
\code{~ genotype + treatment + genotype:treatment}.}
}
\value{
A DESeq2 object (e.g. dds)
}
\description{
Create a DESeq2 data set (`dds' in the
\href{https://www.bioconductor.org/packages/release/bioc/vignettes/DESeq2/inst/doc/DESeq2.html}{DESeq2 vignette})
for the specified class (cell type).
}
\section{cellpypes Objects}{

A cellpypes object is a \link[base]{list} with four slots:
\describe{
\item{\code{raw }}{(sparse) matrix with genes in rows, cells in columns}
\item{\code{totalUMI }}{the colSums of obj$raw}
\item{\code{embed }}{two-dimensional embedding of the cells, provided as data.frame
or tibble with two columns and one row per cell.}
\item{\code{neighbors }}{index matrix with one row per cell and k columns, where
k is the number of nearest neighbors (we recommend 15<k<100, e.g. k=50).
Here are two ways to get the neighbors index matrix:
\itemize{
\item Use \code{find_knn(featureMatrix)$idx}, where featureMatrix could be
principal components, latent variables or normalized genes (features in
rows, cells in columns).
\item use \code{as(seurat@graphs[["RNA_nn"]], "dgCMatrix")> .1} to extract
the kNN
graph computed on RNA. The \code{> .1} ensures this also works with RNA_snn,
wknn/wsnn or any other
available graph – check with \code{names(seurat@graphs)}.
}
}
}
}

\examples{
data("simulated_umis") 
# Meta data
ncells <- ncol(simulated_umis$raw)
dummy_variable <- function(x) factor(sample(x, ncells, replace=TRUE))
meta_data <- data.frame(patient=dummy_variable(paste0("patient", 1:6)),
                        treatment=dummy_variable(c("control", "treated")))

obj <- rule(simulated_umis, "T", "CD3E",">", 1e-4)
\donttest{ # > 5 s in CRAN check
dds <- class_to_deseq2(obj, meta_data, "T", ~ treatment)
}
}
