% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional_hazards-glmnet.R
\name{survival_time_coxnet}
\alias{survival_time_coxnet}
\title{A wrapper for survival times with coxnet models}
\usage{
survival_time_coxnet(object, new_data, penalty = NULL, multi = FALSE, ...)
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from
\link[parsnip:details_proportional_hazards_glmnet]{proportional_hazards() with engine = "glmnet"}.}

\item{new_data}{Data for prediction.}

\item{penalty}{Penalty value(s).}

\item{multi}{Allow multiple penalty values?}

\item{...}{Options to pass to \code{\link[survival:survfit]{survival::survfit()}}.}
}
\value{
A vector.
}
\description{
A wrapper for survival times with coxnet models
}
\examples{
\dontshow{if (rlang::is_installed("glmnet")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cox_mod <- proportional_hazards(penalty = 0.1) \%>\%
  set_engine("glmnet") \%>\%
  fit(Surv(time, status) ~ ., data = lung)
survival_time_coxnet(cox_mod, new_data = lung[1:3, ], penalty = 0.1)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
