% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_what_if.R
\name{plot.ceteris_paribus_explainer}
\alias{plot.ceteris_paribus_explainer}
\title{Plots Ceteris Paribus Explanations}
\usage{
\method{plot}{ceteris_paribus_explainer}(x, ..., quantiles = TRUE,
  split = "models", split_ncol = NULL, color = "variables")
}
\arguments{
\item{x}{a ceteris paribus explainer produced with the 'ceteris_paribus' function}

\item{...}{other explainers that shall be plotted together}

\item{quantiles}{if TRUE (default) then quantiles will be presented on OX axis. If FALSE then original values will be presented on OX axis}

\item{split}{a character, either 'models' or 'variables'. Sets the variable for faceting}

\item{split_ncol}{number of columns for the 'facet_wrap'}

\item{color}{a character, either 'models' or 'variables'. Sets the variable for coloring}
}
\value{
a ggplot2 object
}
\description{
Function 'plot.ceteris_paribus_explainer' plots Ceteris Paribus Plots (What-If Plots) for a single prediction / observation.
}
\examples{
library("DALEX")
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartmentsTest[,2:6], y = apartmentsTest$m2.price)

new_apartment <- apartmentsTest[1, ]
new_apartment

wi_rf <- ceteris_paribus(explainer_rf, observation = new_apartment)
wi_rf

plot(wi_rf, split = "variables", color = "variables")
plot(wi_rf)
}
