% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_coral_plots.R
\name{print.local_fit_explainer}
\alias{print.local_fit_explainer}
\title{Prints Local Fit / Wangkardu Summary}
\usage{
\method{print}{local_fit_explainer}(x, ...)
}
\arguments{
\item{x}{a local fit explainer produced with the 'local_fit' function}

\item{...}{other arguments that will be passed to 'head' function}
}
\description{
Prints Local Fit / Wangkardu Summary
}
\examples{
library("DALEX")
library("randomForest")
apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
                     no.rooms + district, data = apartments)
explainer_rf <- explain(apartments_rf_model,
                     data = apartmentsTest[,2:6], y = apartmentsTest$m2.price)
new_apartment <- apartmentsTest[1, ]
new_apartment
cr_rf <- local_fit(explainer_rf, observation = new_apartment, select_points = 0.002)
cr_rf
}
