% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg.active}
\alias{cg.active}
\title{Change Active Graph}
\value{
none.
}
\description{
Set the graph to be the active graph.
}
\details{
\code{$active()}
}
\note{
Any nodes that are created are automatically added to the active graph. This also applies to operations that are created by overloaded S3 functions that do not follow the cg.<name> naming convention (such as primitive functions '+' and '-').

Only one graph can be active at a time. The active graph can be changed by calling \link[cgraph]{cg.active} on another cgraph object.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Initialize another computational graph. It becomes the current active graph.
y <- cgraph$new()

# Set graph x to be the active graph.
x$active()

}
\author{
Ron Triepels
}
