% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{approx_gradients}
\alias{approx_gradients}
\title{Approximate Gradients}
\usage{
approx_gradients(graph, target, values = new.env(), index = 1,
  eps = 1e-04)
}
\arguments{
\item{graph}{cg_graph object, graph that is differentiated.}

\item{target}{cg_node object, node in the graph that is differentiated.}

\item{values}{named list or environment, values that are subsituted for the input nodes in the graph.}

\item{index}{numeric scalar, index of the target node that is differentiated. Defaults to the first element.}

\item{eps}{numeric scalar, step size. Defaults to 1e-4.}
}
\value{
environment, the gradients of all ancestors of the node (including the target node itself) with respect to the target node.
}
\description{
Differentiate a graph with respect to a given target node by numerical differentiation.
}
\note{
All nodes required to compute the target node must have a value, or their value must be able to be computed at run-time. The values of the nodes can be obtained by first evaluating function \link[cgraph]{cg_graph_run}. The values obtained by this function for the nodes can then be supplied to argument \code{values}.

The graph is differentiation by the symmetric difference quotient. This method can only be used to differentiate scalars. In case the value of the target node is a vector or an array, argument \code{index} can be used to specify which element of the vector or array is differentiated. The gradients have the same shape as the values of the nodes.

Numerical differentiation is subject to estimation error and can be very slow. Therefore, this function should only be used for testing purposes.
}
\author{
Ron Triepels
}
\keyword{internal}
