% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.mv.class.R
\docType{methods}
\name{costs}
\alias{costs}
\alias{costs,changepoint.mv.mrc.class-method}
\title{Uses the changepoint locations to determine the penalised cost of the segmented data.}
\usage{
\S4method{costs}{changepoint.mv.mrc.class}(x)
}
\arguments{
\item{x}{An S4 object as returned by \code{\link{mrc}}.}
}
\value{
Data frame containing cost information as described in the description section (above).
}
\description{
For results obtained using \code{\link{mrc}}, \code{costs} calculates the the total penalised cost for all segments across all variates for different numbers of
most recent change point values (p). It also calculates the code length \eqn{{\rm log}_{2}n^{p}p^{N}} and the total of the penalised cost and code length. The result
is a data frame containing p, the penalised cost, the code length and the sum of penalised cost and code length. The row in the data frame with the smallest total corresponds to
the minimum description length (MDL). See Bardwell, Eckley, Fearnhead and Smith, (2016) for more details about the cost and code length.
}
\examples{
library(changepoint.mv)
data(mrcexample)
res<-mrc(mrcexample,pmax=8)
costs(res)

}
\references{
\insertRef{doi:10.1080/00401706.2018.1438926}{changepoint.mv}
}
