% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useragent-provider.R
\name{UserAgentProvider}
\alias{UserAgentProvider}
\title{UserAgentProvider}
\description{
user agent methods
}
\examples{
(x <- UserAgentProvider$new())
x$locale
x$mac_processor()
x$linux_processor()
x$user_agent()
x$chrome()
x$firefox()
x$internet_explorer()
x$opera()
x$safari()
}
\keyword{internal}
\section{Super class}{
\code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{UserAgentProvider}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{locale}}{(character) the locale}

\item{\code{user_agents}}{(character) user agent browser specific strings}

\item{\code{windows_platform_tokens}}{(character) windows platform tokens}

\item{\code{linux_processors}}{(character) linux processor options}

\item{\code{mac_processors}}{(character) mac processor options}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-UserAgentProvider-allowed_locales}{\code{UserAgentProvider$allowed_locales()}}
\item \href{#method-UserAgentProvider-new}{\code{UserAgentProvider$new()}}
\item \href{#method-UserAgentProvider-mac_processor}{\code{UserAgentProvider$mac_processor()}}
\item \href{#method-UserAgentProvider-linux_processor}{\code{UserAgentProvider$linux_processor()}}
\item \href{#method-UserAgentProvider-user_agent}{\code{UserAgentProvider$user_agent()}}
\item \href{#method-UserAgentProvider-chrome}{\code{UserAgentProvider$chrome()}}
\item \href{#method-UserAgentProvider-firefox}{\code{UserAgentProvider$firefox()}}
\item \href{#method-UserAgentProvider-safari}{\code{UserAgentProvider$safari()}}
\item \href{#method-UserAgentProvider-opera}{\code{UserAgentProvider$opera()}}
\item \href{#method-UserAgentProvider-internet_explorer}{\code{UserAgentProvider$internet_explorer()}}
\item \href{#method-UserAgentProvider-windows_platform_token}{\code{UserAgentProvider$windows_platform_token()}}
\item \href{#method-UserAgentProvider-linux_platform_token}{\code{UserAgentProvider$linux_platform_token()}}
\item \href{#method-UserAgentProvider-mac_platform_token}{\code{UserAgentProvider$mac_platform_token()}}
\item \href{#method-UserAgentProvider-clone}{\code{UserAgentProvider$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="bothify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-bothify'><code>charlatan::BaseProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="lexify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-lexify'><code>charlatan::BaseProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="numerify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-numerify'><code>charlatan::BaseProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit'><code>charlatan::BaseProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_not_zero'><code>charlatan::BaseProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_not_zero_or_empty'><code>charlatan::BaseProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_or_empty'><code>charlatan::BaseProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_element'><code>charlatan::BaseProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element_prob"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_element_prob'><code>charlatan::BaseProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_int"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_int'><code>charlatan::BaseProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_letter"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_letter'><code>charlatan::BaseProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-randomize_nb_elements'><code>charlatan::BaseProvider$randomize_nb_elements()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-allowed_locales"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-allowed_locales}{}}}
\subsection{Method \code{allowed_locales()}}{
fetch the allowed locales for this provider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$allowed_locales()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-new"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{UserAgentProvider} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$new(locale = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{(character) the locale to use. See
\verb{$allowed_locales()} for locales supported (default: en_US)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{UserAgentProvider} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-mac_processor"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-mac_processor}{}}}
\subsection{Method \code{mac_processor()}}{
a mac processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$mac_processor()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-linux_processor"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-linux_processor}{}}}
\subsection{Method \code{linux_processor()}}{
a linux processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$linux_processor()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-user_agent"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-user_agent}{}}}
\subsection{Method \code{user_agent()}}{
a random user agent string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$user_agent()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-chrome"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-chrome}{}}}
\subsection{Method \code{chrome()}}{
a chrome user agent string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$chrome(
  version_from = 13,
  version_to = 63,
  build_from = 800,
  build_to = 899
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_from}}{(integer) minimum version}

\item{\code{version_to}}{(integer) maximum version}

\item{\code{build_from}}{(integer) minimum build}

\item{\code{build_to}}{(integer) maximum build}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-firefox"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-firefox}{}}}
\subsection{Method \code{firefox()}}{
a firefox user agent string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$firefox()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-safari"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-safari}{}}}
\subsection{Method \code{safari()}}{
a safari user agent string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$safari()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-opera"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-opera}{}}}
\subsection{Method \code{opera()}}{
an opera user agent string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$opera()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-internet_explorer"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-internet_explorer}{}}}
\subsection{Method \code{internet_explorer()}}{
an internet explorer user agent string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$internet_explorer()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-windows_platform_token"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-windows_platform_token}{}}}
\subsection{Method \code{windows_platform_token()}}{
a windows platform token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$windows_platform_token()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-linux_platform_token"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-linux_platform_token}{}}}
\subsection{Method \code{linux_platform_token()}}{
a linux platform token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$linux_platform_token()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-mac_platform_token"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-mac_platform_token}{}}}
\subsection{Method \code{mac_platform_token()}}{
a mac platform token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$mac_platform_token()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserAgentProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-UserAgentProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserAgentProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
