% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryWebScraping.R
\name{summaryWebScrapingText}
\alias{summaryWebScrapingText}
\title{Text Summary via Web Scraping}
\usage{
summaryWebScrapingText(
  query = "LLM",
  t = "w",
  gl = "us",
  hl = "en",
  URL_num = 5,
  verbose = TRUE,
  translateJA = FALSE
)
}
\arguments{
\item{query}{The search query. Default is "LLM".}

\item{t}{Time period for search. 'w' for last week, 'm' for last month, 'y' for last year.
Default is 'w'.}

\item{gl}{Geographical location based on ISO 3166-1 alpha-2 country code. Default is 'us'.}

\item{hl}{Language for search results based on ISO 639-1 language code. Default is 'en'.}

\item{URL_num}{Number of URLs to scrape. Default is 5.}

\item{verbose}{A boolean value indicating if details should be printed. Default is TRUE.}

\item{translateJA}{A boolean value indicating if results should be translated to Japanese.
Default is FALSE.}
}
\value{
Returns a list of summaries.
}
\description{
Scrapes Google Search results for the provided query and summarizes the content.
}
\details{
Summarize Text via Web Scraping of Google Search

Scrape text information from Google Search and summarize it using LLM.
Uses OpenAI API key for execution. Translation to Japanese requires a Deepl API key.
}
\examples{
\dontrun{
summaryWebScrapingText(query = "LLM", t = "w", gl = "us", hl = "en", URL_num = 5)
}
}
\author{
Satoshi Kume
}
