% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_pkg.R
\name{check_pkg}
\alias{check_pkg}
\title{Check R-packages for globals and imports}
\usage{
check_pkg(pkg = ".", include_compiled = FALSE, skip_globals = NULL)
}
\arguments{
\item{pkg}{character path to R-package, can be either:
\itemize{
\item a local R-package folder;
\item path to bundled (tar.gz) R-package on local filesystem;
\item remote path to bundled (tar.gz) R-package, (e.g. a remote server or the web).
}}

\item{include_compiled}{logical value indicating if compiled functions called with \code{\link{.Call}},
\code{\link{.C}}, \code{\link{.External}}, \code{\link{.Fortran}} should be included as global variables.}

\item{skip_globals}{optional character vector of names to skip/exclude as (unrecognized) global variables.}
}
\value{
list S3-object of class \code{"checkglobals"} with three components:
\itemize{
\item \code{globals}, list of class \code{"checkglobalsg"}
\item \code{imports}, list of class \code{"checkglobalsi"}
\item \code{missing_packages}, character vector with missing packages
}
for programmatic use, cast the returned S3-object with \code{\link{as.data.frame}}, \code{\link{as.matrix}},
\code{\link{as.character}} or \code{\link[checkglobals]{as_vector}}.
}
\description{
Approximately detect global and imported functions or variables from R-packages by
static code analysis. Conceptually, the function inspects all files in the package
R-folder and contrasts the detected (unrecognized) globals and imports against
the imports listed in the NAMESPACE of the R-package. R-scripts present elsewhere
in the package (i.e. not in the R-folder) are not scanned, as these are not
coupled to the package NAMESPACE file.
}
\examples{
## from R-package folder
check_pkg(
  pkg = system.file(
    "unit_tests", "pkg", "testpkg",
    package = "checkglobals"
  )
)

## from bundled R-package
\donttest{
  check_pkg(
    pkg = "https://cran.r-project.org/src/contrib/tinytest_1.4.1.tar.gz",
    skip_globals = "cluster"
  )
}
}
\seealso{
\code{\link{checkglobals}}, \code{\link{check_source}}
}
