% Generated by roxygen2 (4.0.2): do not edit by hand
\name{assert}
\alias{assert}
\title{Combine multiple checks into one assertion}
\usage{
assert(..., .var.name)
}
\arguments{
\item{...}{[ANY]\cr
List of calls to check functions.}

\item{.var.name}{[character(1)]\cr
Name of object to check. Defaults to a heuristic to determine
the name of the first argument of the first call.}
}
\value{
Throws an error if all checks fails and invisibly returns
 \code{TRUE} otherwise.
}
\description{
Combine multiple checks into one assertion
}
\examples{
x = 1:10
assert(checkNull(x), checkInteger(x, any.missing = FALSE))
\dontrun{
x = 1
assert(checkChoice(x, c("a", "b")), checkDataFrame(x))
}
}

