% Generated by roxygen2 (4.0.2): do not edit by hand
\name{checkFile}
\alias{assertFile}
\alias{checkFile}
\alias{testFile}
\title{Check existence and access rights of files}
\usage{
checkFile(x, access = "")

assertFile(x, access = "", .var.name)

testFile(x, access = "")
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{access}{[\code{character(1)}]\cr
Single string containing possible characters \sQuote{r}, \sQuote{w} and \sQuote{x} to
force a check for read, write or execute access rights, respectively.
Write and executable rights are not checked on Windows.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertFile} throws an error message,
 \code{testFile} returns \code{FALSE} and \code{checkFile} returns
 a string with the error message.
}
\description{
Check existence and access rights of files
}
\examples{
# Check if R's COPYING file is readable
testFile(file.path(R.home(), "COPYING"), access = "r")

# Check if R's COPYING file is readable and writable
testFile(file.path(R.home(), "COPYING"), access = "rw")
}
\seealso{
Other filesystem: \code{\link{assertAccess}},
  \code{\link{checkAccess}}, \code{\link{testAccess}};
  \code{\link{assertDirectory}},
  \code{\link{checkDirectory}},
  \code{\link{testDirectory}};
  \code{\link{assertPathForOutput}},
  \code{\link{checkPathForOutput}},
  \code{\link{testPathForOutput}}
}

