% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFunction.r
\name{checkFunction}
\alias{assertFunction}
\alias{assert_function}
\alias{checkFunction}
\alias{expect_function}
\alias{testFunction}
\alias{test_function}
\title{Check if an argument is a function}
\usage{
checkFunction(x, args = NULL, ordered = FALSE, nargs = NULL)

assertFunction(x, args = NULL, ordered = FALSE, nargs = NULL,
  add = NULL, .var.name)

assert_function(x, args = NULL, ordered = FALSE, nargs = NULL,
  add = NULL, .var.name)

testFunction(x, args = NULL, ordered = FALSE, nargs = NULL)

test_function(x, args = NULL, ordered = FALSE, nargs = NULL)

expect_function(x, args = NULL, ordered = FALSE, nargs = NULL,
  info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{args}{[\code{character}]\cr
Expected formal arguments. Checks that a function has no arguments if
set to \code{character(0)}.
Default is \code{NULL} (no check).}

\item{ordered}{[\code{logical(1)}]\cr
Flag whether the arguments provided in \code{args} must be the first
\code{length(args)} arguments of the function in the specified order.
Default is \code{FALSE}.}

\item{nargs}{[\code{integer(1)}]\cr
Required number of arguments, without \code{...}.
Default is \code{NULL} (no check).}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertFunction}/\code{assert_function}
 throws an error message, \code{testFunction}/\code{test_function}
 returns \code{FALSE},
 and \code{checkFunction} returns a string with the error message.
 The function \code{expect_function} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a function
}
\examples{
testFunction(mean)
testFunction(mean, args = "x")
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDataTable}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNumeric}}, \code{\link{checkVector}}
}

