% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFile.r
\name{checkFile}
\alias{assertFile}
\alias{assert_file}
\alias{checkFile}
\alias{expect_file}
\alias{testFile}
\alias{test_file}
\title{Check existence and access rights of files}
\usage{
checkFile(x, access = "", extension = NULL)

assertFile(x, access = "", extension = NULL, add = NULL,
  .var.name = NULL)

assert_file(x, access = "", extension = NULL, add = NULL,
  .var.name = NULL)

testFile(x, access = "", extension = NULL)

test_file(x, access = "", extension = NULL)

expect_file(x, access = "", extension = NULL, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{access}{[\code{character(1)}]\cr
Single string containing possible characters \sQuote{r}, \sQuote{w} and \sQuote{x} to
force a check for read, write or execute access rights, respectively.
Write and executable rights are not checked on Windows.}

\item{extension}{[\code{character}]\cr
Vector of allowed file extensions, matched case insensitive.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertFile}/\code{assert_file}
 throws an error message, \code{testFile}/\code{test_file}
 returns \code{FALSE},
 and \code{checkFile} returns a string with the error message.
 The function \code{expect_file} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check existence and access rights of files
}
\examples{
# Check if R's COPYING file is readable
testFile(file.path(R.home(), "COPYING"), access = "r")

# Check if R's COPYING file is readable and writable
testFile(file.path(R.home(), "COPYING"), access = "rw")
}
\seealso{
Other filesystem: \code{\link{checkAccess}},
  \code{\link{checkDirectory}},
  \code{\link{checkPathForOutput}}
}

