% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{proto_basis1d_distribution}
\alias{proto_basis1d_distribution}
\title{Adds the distribution of the row local attributions to a ggtour}
\usage{
proto_basis1d_distribution(
  attr_df,
  primary_obs = NULL,
  comparison_obs = NULL,
  position = c("top1d", "floor1d", "bottom1d", "off"),
  group_by = as.factor(FALSE),
  pcp_shape = c(3, 142, 124),
  do_add_pcp_segments = TRUE,
  inc_var_nms = NULL,
  row_index = NULL
)
}
\arguments{
\item{attr_df}{An data frame, the attributions of a local explanation.}

\item{primary_obs}{The rownumber of the primary observation. Its local
attribution becomes the 1d projection basis, and the point it highlighted
as a dashed line. Defaults to NULL, no highlighting.}

\item{comparison_obs}{The rownumber of the comparison observation. Point
is highlighted as a dotted line. Defaults to NULL, no highlighting.}

\item{position}{The position for the basis, one of: c("top1d", "floor1d",
"bottom1d", "off").
Defaults to "top1d"; basis above the density curves.}

\item{group_by}{Vector to group densities by. Originally \emph{predicted} class.}

\item{pcp_shape}{The number of the shape character to add. Expects
3, 142, or 124, '+', '|' in \code{plotly}, and '|' in \code{gganimate}, respectively.
Defaults to 3, '+' in either output.}

\item{do_add_pcp_segments}{Logical, whether or not to add to add faint
parallel coordinate lines on the 1D basis. Defaults to TRUE.}

\item{inc_var_nms}{A character vector, the names of the variables to keep.
Defaults to NULL, all variables kept.}

\item{row_index}{A numeric or logical vector, the index of the rows to keep.
Defaults to NULL, all rows kept.}
}
\value{
A \code{ggplot} object of the the distribution of the local explanation's
attributions.
}
\description{
A {spinifex} proto_*-like function, that adds the distribution of
orthonormalized row values of the specified local explanation \code{attr_df}.
Does not draw the basis bars; use in conjunction with \code{proto_basis1d()}.
}
\examples{
library(cheem)
library(spinifex)

## Regression setup
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Basis, manipulation var, manual tour path, & predictions to fix to y-axis
bas     <- sug_basis(ames_rf_shap, 1)
mv      <- sug_manip_var(ames_rf_shap, 1, 2)
mt_path <- manual_tour(bas, mv)
## Also consumed by: ?radial_cheem_tour()

## Compose and animate the tour
ggt <- ggtour(mt_path, scale_sd(X), angle = .3) +
  append_fixed_y(fixed_y = scale_sd(Y)) +
  proto_point(list(color = clas, shape = clas)) +
  proto_basis1d_distribution(
    attr_df = ames_rf_shap,
    primary_obs = 1, comparison_obs = 2,
    position = "top1d", group_by = clas) +
  proto_basis1d(position = "bottom1d") +
  proto_origin()

if(interactive()){
  animate_plotly(ggt)
}
}
\seealso{
\code{\link[=radial_cheem_tour]{radial_cheem_tour()}}
}
\concept{ggtour proto}
