% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaderboards.R
\name{lichess_leaderboard}
\alias{lichess_leaderboard}
\title{Get top players on Lichess leaderboards}
\usage{
lichess_leaderboard(top_n_players, speed_variant)
}
\arguments{
\item{top_n_players}{The number of players (up to 200) you want returned}

\item{speed_variant}{A valid lichess speed variant to return the leaderboard for}
}
\value{
a dataframe of the lichess top players based on speed_variant and top_n_players selected
}
\description{
This function takes in two parameters; how many players you want
returned (max 200) and the speed variant. The result is a data
frame for each game type
}
\details{
The leaderboard speed variant options include:

\emph{"ultraBullet"}, \emph{"bullet}", \emph{"blitz"},
\emph{"rapid"}, \emph{"classical"}, \emph{"chess960"},
\emph{"crazyhouse"}, \emph{"antichess" }, \emph{"atomic"},
\emph{"horde"}, \emph{"kingOfTheHill"}, \emph{"racingKings"},
\emph{"threeCheck"}
}
\examples{
\dontrun{
top10_blitz <- lichess_leaderboard(top_n_players = 10, speed_variant = "blitz")
leaderboards <- purrr::map2_df(top_n_players = 10, c("ultraBullet", "bullet"), lichess_leaderboard)
}

}
