% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.locus.plot.R
\name{create.locus.plot}
\alias{create.locus.plot}
\title{create.locus.plot}
\usage{
create.locus.plot(
  genome = "hg38",
  chr = NULL,
  start = NULL,
  end = NULL,
  gene.data = NULL,
  genomic.features = NULL,
  feature.name = NULL,
  fdr.filter = 0.05,
  interaction.data = NULL,
  file.name = NULL,
  height = 5.5,
  width = 8.5,
  track.heights = c(0.2, 0.5, 0.8, 0.5, 1.5, 2),
  ...
)
}
\arguments{
\item{genome}{Name of genome build (e.g. 'hg38' or 'hg37')}

\item{chr}{Chromosome number for desired locus including 'chr' (e.g. 'chr1')}

\item{start}{Start coordinate of desired locus}

\item{end}{End coordinate of desired locus}

\item{gene.data}{Path to chosen genome annotation file in .gtf format}

\item{genomic.features}{Path to BED file with coordinates of desired feature track}

\item{feature.name}{Title to appear above genomic features}

\item{fdr.filter}{Q-value filter threshold for interaction calls to be included}

\item{interaction.data}{Path to unfiltered CHiCANE calls output}

\item{file.name}{Path to output file}

\item{height}{Height in inches for desired plot}

\item{width}{Width in inches of desired plot}

\item{track.heights}{Vector of length 6 indicating desired height of individual tracks}

\item{\dots}{Any additional parameters to \code{Gviz::plotTracks}}
}
\value{
TRUE if plot was successfully created
}
\description{
Create a file compatible with WashU Epigenome Browser from CHiCANE interaction calls.
}
\examples{
# In order to conserve memory only significant interactions are included in example 
# interaction.data file. However, in order to show raw counts, unfiltered calls should be 
# included and only significant interactions (as set by fdr.filter) wil be displayed

gene.data <- system.file('extdata', 'gencode_2q35.gtf', package = 'chicane');
genomic.features <- system.file('extdata', '2q35.bed', package = 'chicane');
interaction.data <- system.file(
  'extdata', 'T47D_2q35_filtered_chicane_calls.txt', 
  package = 'chicane'
  );
file.name <- file.path(tempdir(), "chr2_interactions.pdf");

\donttest{
create.locus.plot(
   genome = 'hg38', 
   chr = 'chr2', 
   start = 216600000,
   end = 217200000,
   gene.data = gene.data,
   genomic.features = genomic.features,
   feature.name = 'baits',
   interaction.data = interaction.data,
   file.name = file.name,
   collapseTranscripts = TRUE,
   shape = "arrow"
   );
 }

}
\author{
Andrea Gillespie, Syed Haider
}
