% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMPR.R
\name{COMPR}
\alias{COMPR}
\title{Compressive Orthogonal Matching Pursuit with Replacement}
\usage{
COMPR(
  Data,
  ind.col = 1:ncol(Data),
  K,
  Frequencies,
  lower_b,
  upper_b,
  SK_Data,
  maxIter = 300,
  HardThreshold = TRUE,
  options = list(tol_centroid = 1e-08, nIterCentroid = 1500, min_weight = 0, max_weight
    = Inf, nIterLast = 1000, tol_global = 1e-12)
)
}
\arguments{
\item{Data}{A Filebacked Big Matrix n x N, data vectors are stored in the matrix columns.}

\item{ind.col}{Column indeces, which indicate which data vectors are considered for clustering. By default the entire \code{Data} matrix.}

\item{K}{Number of clusters.}

\item{Frequencies}{A frequency matrix m x n with frequency vectors in rows.}

\item{lower_b}{A vector of the lower boundary of data.}

\item{upper_b}{A vector of the upper boundary.}

\item{SK_Data}{Data sketch vector of the length 2m. It can be computed using \code{\link{Sketch}}.}

\item{maxIter}{Maximum number of iterations in the global optimization with respect to cluster centroid vectors and their weights. Default is 300.}

\item{HardThreshold}{logical that indicates whether to perform the replacement. Default is TRUE.}

\item{options}{List of optimization parameters:
\itemize{
\item \code{tol_centroid} is a tolerance value for the centroid optimization. Default is 1e-8.
\item \code{nIterCentroid} is a maximum number of iterations in the centroid optimization (default is 1500).
\item \code{min_weight} is a lower bound for centroid weights (default is 0).
\item \code{max_weight} is an upper bound for centroids weights (default is Inf)
\item \code{nIterLast} is a number of iteration in the global optimization at the last algorithm iteration. Default is 1000.
\item \code{tol_global} is a tolerance value for the global optimization. Default is 1e-12.
}}
}
\value{
A matrix n x K with cluster centroid vectors in columns.
}
\description{
An implementation of the Compressive Orthogonal Matching Pursuit with Replacement algorithm
}
\details{
COMPR is an iterative greedy method, which alternates between expanding
the cluster centroid set \eqn{C} with a new element \eqn{c_i}, whose sketch is the most correlated to the residue and
the global minimization with respect to cluster centroids \eqn{c_1, \dots, c_K} and their weights \eqn{w_1, \dots, w_K}.
It clusters the data collection into K groups
by minimizing the difference between the compressed data version (data sketch) and
a linear combination of cluster centroid sketches, \emph{i.e.} \eqn{\|Sk(Data) - \sum_{i=1}^K w_i \cdot Sk(c_i)\|}.
}
\note{
This method is also referred to as Compressive K-means and it has been published in
\insertRef{DBLP:journals/corr/KerivenTTG16}{chickn}.
}
\examples{
X = matrix(rnorm(1e5), ncol=1000, nrow = 100)
lb = apply(X, 1, min)
ub = apply(X, 1, max)
X_FBM = bigstatsr::FBM(init = X, ncol=1000, nrow = 100)
out = GenerateFrequencies(Data = X_FBM, m = 20, N0 = ncol(X_FBM))
SK = Sketch(Data = X_FBM, W = out$W)
C  <- COMPR(Data = X_FBM, K = 2, Frequencies = out$W, lower_b = lb, upper_b = ub, SK_Data = SK)
}
